#include "html.h"

namespace html {
#if 0
  block_template* block_template::setup_on( view& v, element* el )
  {
    block_template* tb = turn_element_to<block_template>(el);
    tb->init(v);
    return tb;
  }
#endif

  using namespace kiwi;

  int spring_board::solve(int width, spring_board::align align) {
    // if( width < total_min )
    //  width = total_min;

    if (solved_width == width && solved_align == align) return solved_offset;

    solved_width = width;
    solved_align = align;
    int offset   = 0;
    int pos      = 0;

    if (total_flex != 0 || spans.length()) {
      kiwi::Solver solver;

      try {
        kiwi::Variable flex_unit(""); // that 1* thing

        solver.addEditVariable(flex_unit, 1);

        {
          // kiwi::Constraint c( (a + b + c + d) == width );

          kiwi::Expression sum;

          for (int n = 0; n < items.size(); ++n) {
            item &p = items[n];

            p.m_var.activate();
            p.b_var.activate();

            // accounting (left) margin
            sum = sum + p.m_var;
            solver.addEditVariable(p.m_var, 1);

            if (p.m_flex > 0) {
              solver.addConstraint(0.9 | p.m_var >= double(p.m_min));
              solver.addConstraint(0.6 | double(p.m_flex) * flex_unit == p.m_var);
            } else {
              solver.addConstraint(p.m_var == double(p.m_min));
            }

            if (n == items.last_index()) // last item is a dummy one, only
                                         // margin is used
              break;

            // accounting body
            sum = sum + p.b_var;
            solver.addEditVariable(p.b_var, 1);
            if (p.b_flex > 0) {
              solver.addConstraint(0.9 | p.b_var >= double(p.b_min));
              solver.addConstraint(0.6 | double(p.b_flex) * flex_unit == p.b_var);
            } else {
              solver.addConstraint(0.9 | p.b_var == double(p.b_min));
            }

            if (p.b_max < limits<int>::max_value())
              solver.addConstraint(0.5 | p.b_var <= p.b_max);
          }
          solver.addConstraint(sum == double(width));
        }

        for (span_item *span = spans.begin(), *end = spans.end(); span < end;
             ++span) {
          span->b_var.activate();

          try {
          // kiwi::Constraint c( (a + b ) >= span_width );
              kiwi::Expression span_sum = kiwi::Term(items[span->first].b_var);
              for (int i = span->first + 1; i <= span->last; ++i) {
                span_sum = span_sum + items[i].b_var;
                span_sum = span_sum + items[i].m_var;
              }
              solver.addConstraint(span_sum >= span->b_min);
              if (span->b_max < limits<int>::max_value())
                solver.addConstraint(0.5 | span_sum <= span->b_max);
          } catch(kiwi::UnsatisfiableConstraint e) {
              ;
          }
        }
        // solve
        solver.updateVariables();
      } catch (UnsatisfiableConstraint &) {
        goto MINWIDTH;
        // e.what();
      } catch (std::exception &) {
        goto MINWIDTH;
        // e.what();
      } catch (...) {
        // assert(false);
      }
      item *last_flex = nullptr;
      for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
        p->m_val = (int)(p->m_var.value());
        pos += p->m_val;
        p->pos   = pos;
        p->b_val = (int)(p->b_var.value());
        if (p->b_flex)
          last_flex = p;
        pos += p->b_val;
      }
#pragma TODO("better rounding error distribution please")
      if ((pos < width) && last_flex) {
        last_flex->b_val += width - pos;
        pos = width;
      }
#ifdef DEBUG
      //assert(width == pos);
#endif
    } else {
    MINWIDTH:
      for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
        p->m_val = p->m_min;
        pos += p->m_val;
        p->pos   = pos;
        p->b_val = p->b_min;
        pos += p->b_val;
      }
    }

    switch (align) {
    default:
    case spring_board::ALIGN_START:
      offset = 0;
      break; // items.last().m_flex = 1; break;
    case spring_board::ALIGN_END:
      offset = width - pos;
      break; // items.first().m_flex = 1; break;
    case spring_board::ALIGN_CENTER:
      offset = (width - pos) /
               2; // items.first().m_flex = 1; items.last().m_flex = 1; break;
    }
    return (solved_offset = offset);
  }

#if 0
  int flex::engine::calc(int width)
  {
    freespace = width; // free space to distribute

    if (width == 0 || ptotal == 0) 
      return vmin;

    int width_to_distribute = width;
    int distributed = 0;

    if (vmin >= width) { // min content is known to be larger than container - just set all items to mins
      for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
        p->v = int(p->vmin);
        distributed += p->v;
      }
      freespace = max(0,width - distributed);
      return distributed;
    }
    else if (vmax <= width) { // max content is known to be larger than container - just set all items to maxes
      for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
        if(p->vmax.is_defined())
          p->v = int(p->vmax.val(0));
        else
          p->v = int(p->vmin);
        distributed += p->v;
      }
      freespace = max(0,width - distributed);
      return distributed;
    }

    kiwi::Solver solver;

    try {
      kiwi::Variable flex_unit(""); // that 1* thing

      solver.addEditVariable(flex_unit, 1);

      kiwi::Expression sum;

      for (int n = 0; n < items.size(); ++n) {
        item &p = items[n];

        if (!p.p) {
          p.v = p.vmin;
          width_to_distribute -= p.v;
          continue;
        }

        p.var.activate();

        // accounting body
        sum = sum + p.var;
        solver.addEditVariable(p.var, 1);
        solver.addConstraint(0.9 | p.var >= double(p.vmin));
        solver.addConstraint(0.1 | double(p.p) * flex_unit == p.var);
        if (p.vmax.is_defined())
          solver.addConstraint(0.9 | p.var <= p.vmax.val(0));
      }
      solver.addConstraint(sum == double(width_to_distribute));

      // solve
      solver.updateVariables();

      int nflexible = 0;
      for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
        if (!p->p) {
          distributed += p->v;
          continue;
        }
        p->v = int(p->var.value());
        distributed += p->v;
        ++nflexible;
      }
      if ((distributed < width) && nflexible) {
        int width_left = width - distributed;
        for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
          if (!p->p) continue;
          if (p->vmax.is_defined() && (p->v == p->vmax)) continue;
          int delta = max(1,width_left / nflexible);
          p->v += delta;
          width_left -= delta;
          distributed += delta;
          --nflexible;
          if (nflexible == 0 || width_left <= 0)
            break;
        }
      }
    }
    catch (UnsatisfiableConstraint &) 
    {
      for (item *p = items.begin(), *end = items.end(); p < end; ++p) {
        if (!p->p) {
          distributed += p->v;
          continue;
        }
        p->v = p->vmin;
        distributed += p->v;
      }
    }
    freespace = width - distributed;
    return distributed;
  }
#endif


}
