#include "html.h"

namespace html {

  block_stack *block_stack::setup_on(view &v, element *el) {
    block_stack *tb = turn_element_to<block_stack>(el);
    /*if( el->layout_type() != flow_vertical )
      tb = turn_to<block_stack>(el);
    else
    {
      tb = static_cast<block_stack*>(el);
      if( tb->ldata->type() != flow_vertical ) tb->ldata = new layout_data;
      //else tb->ldata->drop();
    }*/
    return tb;
  }

  void block_stack::calc_intrinsic_widths(view &v) {
    //super::calc_intrinsic_widths(v);
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    inc_max<int> miw;
    inc_max<int> maw;

    ld->dim_min.y.clear();
    ld->dim_max.y.clear();

    int subs_size = ld->blocks.size();

    for (int i = 0; i < subs_size; i++) {
      element *b = ld->blocks[i];

      hstyle bcs = b->get_style(v);

      if (bcs->is_display_none()) { continue; }

      h_layout_data bld = b->ldata;

      int bwidth = b->declared_width(v, 0);//premeasure(v, b, bcs, size(0,0));

      if (b->positioned(v)) b->check_positioned_containment(v);

      if (bcs->position > position_relative)
        continue;

      if (bcs->visibility == visibility_collapse) 
        continue;

      int outer = b->outer_int_x_extra(v, 0);

      int vmin = b->min_width(v) + outer;
      int_v vmax = b->max_width(v);
      if (vmax.is_undefined())
        vmax = b->max_content_width(v);
      vmax = vmax.val(0) + outer;

      miw <<= vmin;
      maw <<= vmax;
      //bld->dim.y = b->computed_height(v, 0); // this will be recalculated by this->layout_height
    }

    int extra_x = 0;
    if (cs->box_sizing_x() > box_sizing_content || cs->box_sizing_y() > box_sizing_content)
    {
      size container_dim = parent ? parent->dim() : v.client_dim();
      measure_borders_x(v, container_dim);
      measure_borders_y(v, container_dim);
      extra_x = ld->inner_borpad_x();
    }
    ld->dim_min.x = miw + extra_x;
    ld->dim_max.x = maw + extra_x;

  }
  int block_stack::layout_width(view &v, int width) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    ld->dim.x = width;

    rect crect = client_rect(v);
    size inner = crect.size();
    if (cs->overflow_x >= overflow_scroll)
      inner.x = max(inner.x, ld->dim_min.x);

    if (ld->dim_min.x.is_defined() && ld->dim_min.y.is_defined() &&
        ld->inner_dim.x == inner.x)
      return ld->dim_min.y; // already measured

    ld->inner_dim.x = inner.x;
    ld->inner_dim.y = 0;

    ld->dim_min.y.clear();
    ld->dim_max.y.clear();

    if (ld->dim_min.x.is_undefined() || flags.has_percent_widths) {
      calc_intrinsic_widths(v);
      if (cs->overflow_x >= overflow_scroll)
        inner.x = max(inner.x, ld->dim_min.x);
    }

    int subs_size = ld->blocks.size();
    halign_e halign = cs->get_horizontal_align();

    inc_max<int> mih;
    inc_max<int> mah;

    int xpos = ld->inner_borpad_left();

    if (ld->fctx) ld->fctx->reset(v);

    range xx(0, inner.x - 1);

    for (int i = 0; i < subs_size; i++) {
      element *b = ld->blocks[i];

      hstyle bcs = b->get_style(v);

      if (bcs->is_display_none()) { continue; }

      h_layout_data bld = b->ldata;

      if (bcs->visibility == visibility_collapse) continue;

      replace_h(v, b, inner.x,true, halign);

      if (b->positioned(v)) 
        b->check_positioned_containment(v);

      if (bcs->position > position_relative) {
        //b->set_pos(b->ldata->outer_left(), ysz + bld->outer_top());
        continue;
      }

      int outer = b->outer_int_y_extra(v, 0);

      int vmin = b->min_height(v) + outer;
      int_v vmax = b->max_height(v);
      if (vmax.is_undefined())
        vmax = b->max_content_height(v);
      vmax = vmax.val(0) + outer;

      mih <<= vmin;
      mah <<= vmax;
    }

    int extra_y = 0;
    if (cs->box_sizing_y() > box_sizing_content)
    {
      size container_dim(width,width);
      measure_borders_y(v, container_dim);
      extra_y = ld->inner_borpad_y();
    }
    ld->dim_min.y = mih + extra_y;
    ld->dim_max.y = mah + extra_y;

    return ld->dim_min.y;
  }
  int block_stack::layout_height(view &v, int height) {
    reorder(v);

    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    int       i         = 0;
    const int subs_size = ld->blocks.size();

    ld->dim.y = height;

    size inner_dim = client_rect(v).size();

    if (subs_size == 0) {
      ld->inner_dim.y = inner_dim.y;
      ld->dim.y       = height;
      return ld->dim.x;
    }

    if (ld->dim_min.y.is_defined() && ld->dim_max.y.is_defined() &&
        ld->inner_dim.y == inner_dim.y)
      return ld->dim.x;

    ld->inner_dim = inner_dim;


    auto valign = cs->get_block_vertical_align();

    for (i = 0; i < subs_size; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;
      if (b->oof_positioned(v)) continue;
#pragma TODO("out of flow measurement!")
      /*if(b->flags.out_of_flow)
      {
         b->measure(v,d->dim.x,d->dim.y);
         continue;
      }*/

      replace_v(v, b, height, true, valign);
    }

    return ld->dim.x;
  }

  void block_stack::reorder(view &v) {

    handle<layout_data> pld = ldata.ptr_of<layout_data>();
    for (int i = 0; i < pld->blocks.size(); ++i)
      pld->blocks[i]->get_style(v); // we need to check styles first to ensure safety of tool::sort later on,
                                    // get_style(v) may call script code that can ruin the DOM of this element.

    auto stack_index = [&v](element *el) -> int {
      int idx = short(el->get_style(v)->z_index);
      return (idx << 16) | ushort(el->flags.ui_index);
    };

    auto comparator = [&](const helement &l, const helement &r) -> bool {
      return stack_index(l) < stack_index(r);
    };
    tool::sort(pld->blocks.head(), pld->blocks.size(), comparator);
  }

  element *block_stack::find_child_element(view &v, point pos /*at is this relative*/, bool  exact) 
  {
    reorder(v);

    get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

#if 0
    auto is_on_non_transparent = [&v,this](element* base, element* child) -> bool {
      for (; child; child = child->layout_parent(v)) {
        if (child->get_style(v)->has_background())
          return true;
        if (child == this)
          break;
      }
      return false;
    };

    element* fallback = nullptr;

    for (int i = ld->blocks.last_index(); i >= 0; --i) {
      element *b = ld->blocks[i];
      if (!b) continue;
      if (b->state.popup()) // it is handled already for the popups
        continue;
      if (b->state.moving() || b->state.copying())
        continue; // this is dragging block, skip it
      if (!b->floats(v) && !b->positioned(v) && b->is_visible(v)) {
        point    p = b->pos();
        element *tb = b->find_element(v, pos - p, exact);
        if (tb) {
          if(!fallback) 
            fallback = tb;
          if (is_on_non_transparent(this, tb))
            return tb; // this element is on transparent background
        }
      }
    }
    return fallback;
#else 
    for (int i = ld->blocks.last_index(); i >= 0; --i) {
      element *b = ld->blocks[i];
      if (!b) continue;
      if (b->state.popup()) // it is handled already for the popups
        continue;
      if (b->state.moving() || b->state.copying())
        continue; // this is dragging block, skip it
      if (!b->floats(v) && !b->positioned(v) && b->is_visible(v)) {
        point    p = b->pos();
        element *tb = b->find_element(v, pos - p, exact);
        if (tb)
          return tb;
      }
    }
    return nullptr;
#endif
  }


} // namespace html