#include "html.h"

namespace html {
  block_horizontal *block_horizontal::setup_on(view &v, element *el) {
    block_horizontal *tb = turn_element_to<block_horizontal>(el);
    /*if( el->layout_type() != flow_horizontal )
      tb = turn_to<block_horizontal>(el);
    else
    {
      tb = static_cast<block_horizontal*>(el);
      if( tb->ldata->type() != flow_horizontal ) tb->ldata = new layout_data;
    }*/
    return tb;
  }

  void block_horizontal::calc_intrinsic_widths(view &v) {
    hstyle              cs  = get_style(v);
    handle<layout_data> ld  = ldata.ptr_of<layout_data>();
    size                dim = ld->dim;

    slice<helement> subs = ld->blocks();

    element *prevb = 0;
    int      pix = 0, spr = 0;

    int extra = ld->inner_borpad_x();

    int miw = extra;
    int maw = extra;

#ifdef _DEBUG
    if (this->is_id_test())
      miw = miw;
#endif

    for (uint i = 0; i < subs.length; ++i) {
      element *b = subs[i];
      if (!b) continue;
      hstyle bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;

      if (bcs->visibility == visibility_collapse) {
        premeasure(v, b, bcs, dim);
        continue;
      }
      if (b->state.moving() || b->state.copying() || b->state.popup()) continue;

      if (b->oof_positioned(v) || b->popup_positioned(v)) continue;

      //premeasure(v, b, bcs, dim);
      element::max_values mx = b->measure_borders_x(v, size());
      element::max_values my = b->measure_borders_y(v, size());

      h_layout_data bld = b->ldata;

      overlapping_x(v, this, prevb, b, pix, spr);
      miw += pix;
      maw += pix;
      int borpad = bld->borpad_left() + bld->borpad_right();
      miw += b->min_width(v) + borpad;
      maw += b->max_width(v).val(b->max_content_width(v)) + borpad;
      prevb = b;
    }
    overlapping_x(v, this, prevb, 0, pix, spr);
    miw += pix;
    maw += pix;
    ld->dim_min.x = miw;
    ld->dim_max.x = maw;
  }

  int block_horizontal::layout_width(view &v, int width) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    ld->dim.x = width;

    rect crect     = client_rect(v);
    size inner_dim = crect.size();

    if (ld->dim_min.x.is_defined() && ld->dim_min.y.is_defined() && ld->inner_dim.x == inner_dim.x)
      return ld->dim_min.y; // already measured

#ifdef _DEBUG
    if (is_id_test())
      ld = ld;
#endif

    ld->inner_dim.x = inner_dim.x;
    ld->inner_dim.y = 0;
    ld->dim.y       = 0; // ?
    ld->dim_min.y.clear();
    ld->dim_max.y.clear();

    if (ld->dim_min.x.is_undefined()) calc_intrinsic_widths(v);

    buffer<helement,16> subs = ld->blocks();

    flex::engine sc(subs.size() * 6 + 5);

    int      pix = 0, spr = 0;
    element *prevb = 0;

    each<helement> blocks(subs(), cs->direction == direction_rtl);

    cs->inner_used_border_width(0).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);
    
    cs->inner_used_padding(0).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);

    for (helement b; blocks(b);) {
      hstyle bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;

      h_layout_data bld = b->ldata;

      if (b->positioned(v)) b->check_positioned_containment(v);

      if (b->oof_positioned(v) || b->popup_positioned(v)) continue;

      /*if(b->flags.out_of_flow)
      {
         b->measure(v,d->dim.x,d->dim.y);
         continue;
      }*/
      auto maxes = b->measure_borders_x(v, width);
#pragma TODO("overlapping min/max")
      overlapping_x(v, this, prevb, b, pix, spr);
      sc.add(pix, maxes.m1, spr);

      bcs->used_border_width(0).pixels_n_spring_w(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.b1, spr);

      bcs->used_padding(0).pixels_n_spring_h(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.p1, spr);

      int   spring_width  = 0;
      int   min_width     = 0;
      int_v max_width;

      if (bcs->width.is_defined()) {
        spring_width  = bcs->width.flex1000();
        //percent_width = bcs->width.percent();
        //pref_width    = bcs->width.preferred_pixels_width(v, b, ld->dim.x);
        min_width     = b->min_width(v, width);
        max_width     = b->max_width(v, width);
      } else if (bcs->min_width.is_defined()) {
        min_width = b->min_width(v, width);
        max_width = b->max_width(v, width);
      } else {
        min_width  = b->min_width(v, width);
        int cwidth = b->max_content_width(v);
        max_width = b->max_width(v, width).val(cwidth); // shrink to fit
        spring_width = 10000;
      }

      sc.add(min_width, max_width, spring_width);

      bcs->used_padding(2).pixels_n_spring_h(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.p2, spr);

      bcs->used_border_width(2).pixels_n_spring_w(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.b2, spr);

      prevb = b;
    }
    
    overlapping_x(v, this, prevb, 0, pix, spr);
    sc.add(pix, int_v(), spr);

#ifdef _DEBUG
    if (is_id_test())
      ld = ld;
#endif 

    cs->inner_used_padding(2).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);

    cs->inner_used_border_width(2).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);
    
    ld->dim_min.x = sc.vmin;
    if (ld->dim_max.x < ld->dim_min.x) ld->dim_max.x = ld->dim_min.x;

    int content_width = sc.calc(ld->dim.x);

    if (ld->dim_min.x > content_width) content_width = ld->dim_min.x;

    int freespace_a = ld->dim.x - content_width;

    int freespace = min(sc.freespace, freespace_a);
    if (freespace < 0 && (cs->overflow_x != overflow_hidden && cs->overflow_x != overflow_visible))
      freespace = 0;
    
    int posx = 0;

    halign_e halign = cs->get_horizontal_align();

    switch (halign) {
    case align_left: break;
    case align_right: posx += freespace; break;
    case align_center: posx += freespace / 2; break;
    default: break;
    }

    inc_max<int> min_y;
    inc_max<int> max_y;
    inc_max<int> ascent_y;
    inc_max<int> descent_y;

    int n                = 0;
    int container_height = known_height(v, this);

    posx += (ld->inner_border_width.s.x = sc.val(n++));
    posx += (ld->inner_padding_width.s.x = sc.val(n++));

    blocks.rewind();
    for (helement b; blocks(b);) {
      hstyle bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) { continue; }

      h_layout_data bld = b->ldata;

      if (bcs->position > position_relative) {
        b->set_pos(posx + bld->outer_left(), bld->outer_top());
        // reposition(v,b);
        continue;
      }

      if (b->oof_positioned(v) || b->popup_positioned(v)) continue;

      // point& bpos = bcs->position? bld->static_pos : bld->pos;

      int margin = sc.val(n);
      posx += margin;

      bld->margin_width.s.x = margin;
      posx += (bld->border_width.s.x = sc.val(++n));
      posx += (bld->padding_width.s.x = sc.val(++n));
      b->set_x_pos(posx);

      int bw = sc.val(++n); 
      b->set_width(v, bw);

      posx += bld->dim.x;
      posx += (bld->padding_width.e.x = sc.val(++n));
      posx += (bld->border_width.e.x = sc.val(++n));
      bld->margin_width.e.x = sc.val(++n);
      b->measure_borders_y(v, ld->dim);
      int outer = b->outer_int_y_extra(v, b->dim().y);
      min_y <<= b->min_height(v, container_height) + outer;
      max_y <<= b->max_height(v, container_height) + outer;

      //valign_v va = b->get_style(v)->vertical_align;
      valign_e va = bcs->vertical_align.val(cs->get_block_vertical_align());

      int ascent  = 0;
      int descent = 0;

      switch (va) {
        case valign_baseline: {
          int a = 0, d = 0, h = 0;
          b->get_inline_block_metrics(v, a, d, h);
          ascent  = a;
          descent = d;
          ascent_y <<= ascent;
          descent_y <<= descent;
          break;
        }
        case valign_sub:
        case valign_super: {
          int a = 0, d = 0, h = 0;
          b->get_inline_block_metrics(v, a, d, h);
          int shift = b->get_baseline_shift(v, this);
          ascent    = a - shift;
          descent   = d + shift;
          ascent_y <<= ascent;
          descent_y <<= descent;
        } break;
      }
    }

    posx += (ld->inner_padding_width.e.x = sc.val(++n));
    posx += (ld->inner_border_width.e.x = sc.val(++n));

    if (ascent_y) {
      if ((ascent_y + descent_y) < min_y)
        ld->baseline = (ascent_y * min_y) / (ascent_y + descent_y);
      else {
        min_y <<= ascent_y + descent_y;
        ld->baseline = ascent_y;
      }
    } else
      ld->baseline.clear();

    int inners = ld->inner_borpad_y();
    ld->dim.y = ld->dim_min.y = max(min_y, ascent_y + descent_y) + inners;
    ld->dim_max.y = max(ld->dim_min.y, max_y + inners);
    return ld->dim_min.y;
  }

  void calc_margin_left(view &v, helement b, int parent_width, int &pix,
                        int &spr, int &pref) {
    style *cs = b->get_style(v);
    pix       = pixels(v, b, cs->margin[0]).width();
    spr       = cs->margin[0].flex1000();
#if defined(FLEX_PLUS)
    pref = cs->margin[0].preferred().pixels(cs->font_size, parent_width, false,
                                            &v);
#else
    pref = 0;
#endif

    element *first_ui_child = b->first_ui_element();

    if (first_ui_child && collapse_left(v, b) &&
        (cs->flow == flow_horizontal || cs->flow == flow_h_flow) &&
        first_ui_child->get_style(v)->clears == 0) {
      int fpix  = 0;
      int fspr  = 0;
      int fpref = 0;
      calc_margin_left(v, first_ui_child, b->ldata->dim.x, fpix, fspr, fpref);
      pix = overlap(fpix, pix);
    }
  }

  void calc_margin_right(view &v, helement b, int parent_width, int &pix,
                         int &spr, int &pref) {
    style *cs = b->get_style(v);
    pix       = pixels(v, b, cs->margin[2]).width();
    spr       = cs->margin[2].flex1000();
#if defined(FLEX_PLUS)
    pref = cs->margin[2].preferred().pixels(cs->font_size, parent_width, false,
                                            &v);
#else
    pref = 0;
#endif

    element *last_ui_child = b->last_ui_element();

    if (last_ui_child && collapse_right(v, b) &&
        (cs->flow == flow_horizontal || cs->flow == flow_h_flow) &&
        last_ui_child->get_style(v)->clears == 0) {
      int fpix  = 0;
      int fspr  = 0;
      int fpref = 0;
      calc_margin_right(v, last_ui_child, b->ldata->dim.x, fpix, fspr, fpref);
      pix = overlap(fpix, pix);
    }
  }

  void overlapping_x(view &v, helement self, element *prev_blk, element *blk,
                     int &pix, int &spr) {
    int ppix  = 0;
    int npix  = 0;
    int pspr  = 0;
    int nspr  = 0;
    int ppref = 0;
    int npref = 0;

    if (prev_blk)
      calc_margin_right(v, prev_blk, self->ldata->dim.x, ppix, pspr, ppref);
    if (blk) calc_margin_left(v, blk, self->ldata->dim.x, npix, nspr, npref);
    if (!blk && !prev_blk) return;

    spr  = max(pspr, nspr);
    pix  = overlap(ppix, npix);
    //pref = max(ppref, npref);

    if (spr == 0) {
      if (prev_blk == 0 && pix > 0 && collapse_left(v, self) &&
          collapse_left(v, blk)) {
        // collapsed
        pix  = 0;
        spr  = 0;
        //pref = 0;
        return;
      }
      if (blk == 0 && pix > 0 && collapse_right(v, self) &&
          collapse_right(v, prev_blk)) {
        // collapsed
        pix  = 0;
        spr  = 0;
        //pref = 0;
        return;
      }
    }

    if (self->c_style->border_spacing_x.is_defined() && prev_blk && blk) {
      int bpix, bspr;
      self->c_style->border_spacing_x.pixels_n_spring_w(v, self, self->ldata->dim.x, bpix, bspr);
      pix  = overlap(pix, bpix);
      spr  = max(spr, bspr);
      //pref = max(pref, bpref);
    }
  }

  void replace_v(view &v, element *b, int cell_height, bool include_margins, valign_ev valign, int_v baseline) {
    hstyle cs = b->get_style(v);

    int height_spring = cs->height.flex1000();

    size container_dim = b->parent ? b->parent->dim() : v.client_dim();

#ifdef _DEBUG
    if (b->is_id_test())
      cs = cs;
#endif // _DEBUG

    auto maxes = b->measure_borders_y(v, container_dim);

    flex::engine se(7);

    int          minh = b->min_height(v /*,container_dim.y*/);
    layout_data *bld  = b->ldata;

    if (include_margins)
      se.add(bld->margin_width.s.y, maxes.m1, cs->margin[1].flex1000());
    se.add(bld->border_width.s.y, maxes.b1, cs->border_width[1].flex1000());
    se.add(bld->padding_width.s.y, maxes.p1, cs->used_padding(1).flex1000());
    se.add(minh, b->max_height(v, container_dim.y), height_spring);
    se.add(bld->padding_width.e.y, maxes.p2, cs->used_padding(3).flex1000());
    se.add(bld->border_width.e.y, maxes.b2, cs->border_width[3].flex1000());
    if (include_margins)
      se.add(bld->margin_width.e.y, maxes.m2, cs->margin[3].flex1000());

    bool has_springs = se.ptotal > 0;

    se.calc(cell_height);

    int n = 0;
    int h = 0;
    if (include_margins) bld->margin_width.s.y = se.val(n++);
    bld->border_width.s.y  = se.val(n++);
    bld->padding_width.s.y = se.val(n++);

    h = se.val(n++);

    bld->padding_width.e.y = se.val(n++);
    bld->border_width.e.y  = se.val(n++);
    if (include_margins) bld->margin_width.e.y = se.val(n++);
    // point& bpos = cs->position? bld->static_pos : bld->pos;
    b->set_y_pos(include_margins ? bld->outer_top() : bld->borpad_top());

    b->set_height(v, h);

    if (valign.is_defined()) {
      int va = valign;
      int dtop = include_margins ? bld->outer_top() : bld->borpad_top();
      int dbot = include_margins ? bld->outer_bottom() : bld->borpad_bottom();

      int bh = h + dtop + dbot;
      
      switch (va) {
      case valign_baseline:
        if (baseline.is_defined() &&
            (se.freespace > 0 || height_spring < 100)) {
          int a = 0, d = 0, h = 0;
          b->get_inline_block_metrics(v, a, d, h);
          int shift = baseline - a;
          //bld->pos.y += shift;
          b->set_y_pos( b->pos().y + shift );
        }
        break;
      default:
      case valign_top:
        break;
      case valign_bottom:
        if (has_springs)
          b->set_y_pos(b->pos().y + se.freespace);
        else
          b->set_y_pos(cell_height - bh + dtop);
        break;
      case valign_middle: 
        if(has_springs)
          b->set_y_pos(b->pos().y + se.freespace / 2);
        else {
          b->set_y_pos((cell_height - bh) / 2 + dtop);
        }
        break;
      }
    }
  }

  void replace_h(view &v, element *b, int cell_width, bool include_margins, halign_ev halign) {
    hstyle cs = b->get_style(v);

    int width_spring = cs->width.flex1000();

    size container_dim = b->parent ? b->parent->dim() : v.client_dim();

    flex::engine se(7);

    int          minw = b->min_width(v,container_dim.x);
    layout_data *bld  = b->ldata;

    auto maxes = b->measure_borders_x(v, container_dim);

    if (include_margins)
      se.add(bld->margin_width.s.x, maxes.m1, cs->margin[0].flex1000());
    se.add(bld->border_width.s.x, maxes.b1, cs->border_width[0].flex1000());
    se.add(bld->padding_width.s.x, maxes.p1, cs->used_padding(0).flex1000());
    se.add(minw, b->max_width(v, container_dim.x), width_spring);
    se.add(bld->padding_width.e.x, maxes.p2, cs->used_padding(2).flex1000());
    se.add(bld->border_width.e.x, maxes.b2, cs->border_width[2].flex1000());
    if (include_margins)
      se.add(bld->margin_width.e.x, maxes.m2, cs->margin[2].flex1000());

    bool has_springs = se.ptotal > 0;

    se.calc(cell_width);

    int n = 0;
    int w = 0;
    if (include_margins) bld->margin_width.s.x = se.val(n++);
    bld->border_width.s.x  = se.val(n++);
    bld->padding_width.s.x = se.val(n++);

    w = se.val(n++);

    bld->padding_width.e.x = se.val(n++);
    bld->border_width.e.x  = se.val(n++);
    if (include_margins) bld->margin_width.e.x = se.val(n++);
    // point& bpos = cs->position? bld->static_pos : bld->pos;
    b->set_x_pos(include_margins ? bld->outer_left() : bld->borpad_left());

    b->set_width(v, w);

    if (halign.is_defined()) {
      int ha = halign;
      int dlef = include_margins ? bld->outer_left() : bld->borpad_left();
      int drig = include_margins ? bld->outer_right() : bld->borpad_right();

      int bw = w + dlef + drig;

      switch (ha) {
      default:
      case align_left:
        break;
      case align_right:
        if( has_springs )
          b->set_x_pos( b->pos().x + se.freespace);
        else
          b->set_x_pos((cell_width - bw) + dlef);
        break;
      case align_center: 
        if (has_springs)
          b->set_x_pos(b->pos().x + se.freespace / 2);
        else
          b->set_x_pos((cell_width - bw) / 2 + dlef);
        break;
      }
    }
  }

  int block_horizontal::layout_height(view &v, int height) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    slice<helement> subs = ld->blocks();

    ld->dim.y = height;

    size inner_dim = client_rect(v).size();

    if (subs.length == 0) {
      ld->inner_dim.y = inner_dim.y;
      ld->dim.y       = height;
      return ld->dim.x;
    }

    if (ld->dim_min.y.is_defined() && ld->dim_max.y.is_defined() &&
        ld->inner_dim.y == inner_dim.y)
      return ld->dim.x;

    ld->inner_dim = inner_dim;

    int ypos = ld->inner_borpad_top();

    for (uint i = 0; i < subs.length; i++) {
      helement b   = subs[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;
      if (b->oof_positioned(v)) continue;
      if (b->popup_positioned(v)) {
        measure_out_of_flow(v, b);
        continue;
      }

      valign_e va = bcs->vertical_align.val(cs->get_block_vertical_align());
      replace_v(v, b, ld->dim.y, true, va, ld->baseline);
      b->set_y_pos(b->pos().y + ypos);
    }
    return ld->dim.x;
  }

  float block_horizontal::inline_baseline(view &v) {
    // for( element* le = last_ui_element(); le; le = le->prev_ui_element() )
    if (c_style->overflow_y > overflow_visible && !c_style->height.is_auto() &&
        !c_style->height.is_min_intrinsic() &&
        !c_style->height.is_max_intrinsic())
      return float(ldata->outer_top() + ldata->dim.y);

    float bl  = 0;
    auto  foo = [&bl, &v](element *le) -> bool {
      if (le->c_style->position > position_relative) return false;
      if (le->c_style->get_float() > 0) return false;
      bl = le->inline_baseline(v) - le->ldata->outer_top() + le->pos().y;
      return true;
    };
    if (each_ui_child(foo)) return bl + ldata->outer_top();
    return super::inline_baseline(v);
  }

  int block_horizontal::n_rows() { return 1; }
  int block_horizontal::n_cols() {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    return ld->blocks.size();
  }
  void block_horizontal::get_row(int row, array<handle<element>> &els) {
    if (row == 0) {
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      els                    = ld->blocks;
    }
  }
  void block_horizontal::get_col(int col, array<handle<element>> &els) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    els.push(ld->blocks[col]);
  }
  bool block_horizontal::get_col_x(int col, gool::range &x) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    view *              pv = pview();
    if (!pv) return false;
    if (col >= 0 && col < ld->blocks.size()) {
      x = ld->blocks[col]->margin_box(*pv, TO_PARENT).x();
      return true;
    }
    return false;
  }
  bool block_horizontal::get_row_y(int row, gool::range &y) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    y                      = range(0, max(ld->dim_min.y, ld->dim.y));
    return true;
  }
  bool block_horizontal::get_row_at(view &v, int y, int &row) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    row                    = 0;
    return true;
  }
  bool block_horizontal::get_col_at(view &v, int x, int &col) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    point               pos(x, ld->dim.y / 2);
    element *           child = find_child_element(v, pos, false);
    for (; child; child = child->get_owner()) {
      if (child->get_owner() == this) {
        col = int(child->flags.ui_index);
        return true;
      }
    }
    return false;
  }
  element *block_horizontal::at(int row, int col) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    return row < 0 || row > 0 ? 0 : ld->blocks[col];
  }

} // namespace html