#include "html.h"
#include "html-behaviors.h"
#include "html-dom-merge.h"

namespace html {

  bool get_auto_width(view &v, element *b, int &w);
  bool get_auto_height(view &v, element *b, int &h);

  inline css_content *get_css_content(element *el) {
    if (!el->style_content)
      el->style_content = new css_content;
    return el->style_content;
  }

  rect caret_metrics::caret_v_bar() const {
    float onedip = 1;
    if (elem) {
      sizef one = elem->pixels_per_dip();
      onedip    = one.x;
    }
    if (at_end) // int(at_end ? x2 : x1);
      return rect(int(x2 + 0.5f), int(y1), int(x2 + 0.5f + onedip), int(y2));
    else
      return rect(int(x1 + 0.5f), int(y1), int(x1 + 0.5f + onedip), int(y2));
  }
  rect caret_metrics::caret_h_bar() const {
    float onedip = 0;
    if (elem) {
      sizef one = elem->pixels_per_dip();
      onedip    = one.y;
    }
    if (at_end)
      return rect(int(x1), int(y2 - onedip), int(x2), int(y2));
    else
      return rect(int(x1), int(y1), int(x2), int(y1 + onedip));
  }

  tuple<rect, rect> caret_metrics::caret_bars(CARET_TYPE ct) const {
    // int x = int(at_end? x2:x1); return rect(x,y1,x,y2);
    rect r1    = glyph_rc;
    rect r2    = glyph_rc;
    size shift = size(elem->pixels_per_dip()) * 3;
    size one   = size(elem->pixels_per_dip()) - size(1, 1);
    switch (ct) {
    case ROW_POSITION:
      if (at_end) {
        r1.s.x = r1.e.x;
        --r1.e.y;
        r2.s.y = r2.e.y;
      } else {
        r1.e.x = r1.s.x;
        ++r1.s.y;
        r2.e.y = r2.s.y;
      }
      return tuple<rect, rect>(r1, r2);
    case BLOCK_POSITION: {
      // bool is_first = !elem->prev_element();
      // bool is_last = !elem->next_element();
      if (at_end) {
        // |____
        r1 = rect(point(int(x1), int(y2) - one.y), point(int(x2), int(y2))) +
             point(-shift.x, 0);
        r2 = rect(point(int(x1), int(y1)), point(int(x1) + one.x, int(y2))) +
             point(0, shift.y);
        return tuple<rect, rect>(r1, r2);
      } else // if (!at_end && is_first)
      {
        r1 = rect(point(int(x1), int(y1)), point(int(x2), int(y1) + one.y)) +
             point(-shift.x, 0);
        r2 = rect(point(int(x1), int(y1)), point(int(x1) + one.x, int(y2))) +
             point(0, -shift.y);
        return tuple<rect, rect>(r1, r2);
      }
      /*else if(at_end)
      {
        r1 = rect(pointf(x1 - 2 * one.x, y2 - one.y), pointf(x2, y2));
        r2 = rect(pointf(x1 - one.x, y2 - 5 * one.y), pointf(x1, y2 + 5 *
      one.y)); return tuple<rect, rect>(r1, r2);
      }
      else //if (!at_end)
      {
        r1 = rect(pointf(x1 - 2 * one.x, y1), pointf(x2, y1 + one.y));
        r2 = rect(pointf(x1 - one.x, y1 - 5 * one.y), pointf(x1, y1 + 5 *
      one.y)); return tuple<rect, rect>(r1, r2);
      }*/
    } // fall through
    case CHAR_POSITION:
      if (at_end)
        return tuple<rect, rect>(
            rect(int(x1), int(y2 - one.y), int(x2), int(y2)), rect());
      else
        return tuple<rect, rect>(
            rect(int(x1), int(y1), int(x2), int(y1 + one.y)), rect());
      break;
    }

    return tuple<rect, rect>(rect(), rect());
  }

  /*view* node::pview() const
  {
    return parent? parent->pview(): 0;
  }*/
  view *node::pview() const {
    document *pd = doc();
    return pd ? pd->pview() : nullptr;
  }

  document *node::doc() const {
    //if (!parent_document)
    //  parent_document = parent ? parent->doc() : nullptr;
    //return parent_document;
    return parent ? parent->doc() : nullptr;
  }

  style *node::get_style(view &v) {
    element *owner = get_owner();
    return owner ? owner->get_style(v) : element::null_style.ptr();
  }

  locked::counter node::last_uid;

  node *node::next_node() const {
    if (!parent || int(node_index) < 0 || int(node_index) >= parent->nodes.last_index()) return nullptr;
    return parent->nodes[node_index + 1];
  }
  node *node::prev_node() const {
    if (!parent || int(node_index) <= 0) return nullptr;
    return parent->nodes[node_index - 1];
  }

  node* node::root_node() const { return doc(); }

  void node::got_parent(element *p, uint nidx) {
    parent = owner = p;
    node_index = nidx;
  }


  bool node::is_connected() const {
    if (!parent)
      return false;
    if ((node_index == UNDEFINED_NODE_INDEX) && parent->is_document())
      return false;
    //return parent->is_connected();
    return true;
  }

  element * node::logical_parent() const {
    if (!is_connected()) return nullptr;
    return parent.ptr();
  }

  bool node::remove(bool finalize, view *pv) {
#if 0
    html::hnode    self = this;
    html::helement p    = self->parent;
    if (!p) return false; // already removed
    if (node_index >= p->nodes.length())
      return false; // already removed, this may happen when node::remove is
                    // called from inside element::stray path
    if (p->nodes[node_index] != this)
      return false; // already removed, this may happen when node::remove is
                    // called from inside element::stray path

    p->remove_child(self);

    p->flags.indexes_are_valid = 0;
    if (!pv || pv->mutator_rq(p, CONTENT_REMOVED))
    {
      if (!pv) pv = pview();
      int elidx = 0;
      for (int n = 0; n < p->nodes.size(); ++n) {
        node *pn = p->nodes[n];
        pn->node_index = n;
        if (pn->is_element()) pn->cast<element>()->flags.index = elidx++;
      }

      p->flags.indexes_are_valid = 1;

      this->owner = nullptr;
      this->parent = nullptr;

      if (pv) {
        p->drop_layout(pv);
        pv->on_content_change(p, CONTENT_REMOVED);
        pv->add_to_update(p, CHANGES_MODEL);
      }
    }
#else
    //int         cnt = get_ref_count();
    html::hnode self = this;
    html::helement p = self->parent;
    if (!p) return false;

    uint nidx;
    if (is_connected()) {
      nidx = node_index;
      p->remove_child(this);
    }
    else
      nidx = 0;

    p->flags.indexes_are_valid = 0;
    if (!pv || pv->mutator_rq(p, CONTENT_REMOVED)) {
      if (!pv) pv = pview();
      for (uint n = nidx; n < p->nodes.length(); ++n) {
        node *tn = p->nodes[n];
        tn->node_index = n;
        if (tn->is_element()) {
          if (pv) tn->cast<element>()->drop_styles(*pv);
        }
      }
      p->drop_layout();
      p->check_states();
    }
    else
    {
      for (int n = max(0,nidx); n < p->nodes.size(); ++n) {
        node *tn = p->nodes[n];
        tn->node_index = n;
      }
    }

    this->owner = nullptr;

    if (finalize)
      this->parent = nullptr;
    else
      this->parent = p->doc();
#endif
    return true;
  }

  bool node::node_is_equal(node* pn) {
    document_context dctx(parent);
    return node_equal(dctx, this, pn);
  }

  text::text(wchars t) : chars(t) {
#ifdef _DEBUG
    if (t.length == 0) t = t;
#endif
  }

  bool text::marks_at(view &v, int pos, uint mid) {
    //#ifdef _DEBUG
    //    if(this->get_element()->is_id_test())
    //      pos = pos;
    //#endif
    if (marks.size() != chars.size()) marks.size(chars.size());
    if (pos >= 0 && pos < marks.size()) {
      if (marks[pos] != mid) {
        marks[pos] = char_mark_t(mid);
        return true;
      }
    }
    return false;
  }

  bool text::marks_at_contains(int pos, tool::chars markcls) const {
    uint mid = marks_at(pos);
    return mid && mark_id_contains_class(mid, markcls);
  }

  node *text::split(view &v, int at, bool force) {
    if (!parent) return 0;
    if (!force && (at <= 0 || at >= chars.size())) return 0;
    handle<text> nt = new text(chars(at));
    chars.size(at);
    parent->insert(node_index + 1, nt, &v);
    return nt;
  }
  int text::unsplit(view &v) {
    node *nn = next_node();
    ASSERT(nn && nn->is_text());
    //{
    //  assert(false);
    //  return chars.size();
    //}
    text *nt = nn->cast<text>();
    int   at = chars.size();
    chars.push(nt->chars());
    nt->remove(true);
    if (get_element()) v.add_to_update(get_element(), CHANGES_MODEL);
    return at;
  }

  bool text::set_text(wchars text, view* pv) {
    if (chars() == text) return false;
    chars = text;
    helement b = nearest_box();
    if (pv) {
      b->drop_layout(pv);
      pv->add_to_update(b, CHANGES_MODEL);
    }
    return true;
  }


  rect node::rbox(view &v) {
    if (!parent->is_visible(v)) return rect();
    bookmark start = this->start_caret_pos(v);
    bookmark end   = this->end_caret_pos(v);
    return html::rbox(v, start, end);
  }

  /*static bool next_node_is_root_text(text* pt, element* box) {
    node *pn = walk::next(pt, pt->doc());
    if (!pn) return false;
    return pn->is_text();
  }

  static bool prev_node_is_root_text(text* pt, element* box) {
    node *pn = walk::prev(pt, pt->doc());
    if (!pn) return false;
    return pn->is_text();
  }*/

  bool text::advance_caret_pos(view &v, bookmark &bm, ADVANCE_DIR dir,
                               array<wchar> *out) {
    element *tb = bm.node->nearest_box();
    if (!tb) return false;

    switch (dir) {

      case ADVANCE_PREV:
        {
          if (!tb->is_of_type<text_block>() || is_start_pos(bm)) {
            bm = this_pos(false);
            return true;
          }
          int start = bm.pos + int(bm.after_it);
          int pos = start;
          while (u16::advance(chars(), -1, pos)) {
            /*if (bm.pos) {
              bm.pos = pos - 1;
              bm.after_it = true;
            }
            else {
              bm.pos = 0;
              bm.after_it = false;
            }*/
            bm.pos = pos;
            bm.after_it = false;

            if (tb->cast<text_block>()->is_caret_pos_at(v,bm)) {
              if (out) out->push(chars(pos, start));
              return true;
            }
          }
          bm = this_pos(false);
          return true;
        }

      case ADVANCE_NEXT:
        {
          if (!tb->is_of_type<text_block>() || is_end_pos(bm)) {
            bm = this_pos(true);
            return true;
          }
          int start = bm.pos + int(bm.after_it);
          int pos = start;
          while (u16::advance(chars(), +1, pos)) {
            /*bm.pos = pos;
            if (pos == chars.size()) {
              bm.pos = chars.last_index();
              bm.after_it = true;
            }*/
            bm.pos = pos - 1;
            bm.after_it = true;

            if (tb->cast<text_block>()->is_caret_pos_at(v,bm)) {
              if (out) out->push(chars(start, pos));
              return true;
            }
          }
          bm = this_pos(true);
          return true;
        }
     case ADVANCE_RIGHT:
        /*if (is_end_pos(bm) && tb->is_of_type<text_block>() && this->owner != tb && !next_node_is_root_text(this,tb))
        {
          bm = this->parent->end_pos();
          return true;
        }
        else */
        if (tb->is_of_type<text_block>())
          return tb->advance_caret_pos(v, bm, dir, out);
        else {
          if (tb->get_style(v)->direction == direction_ltr)
            bm = this_pos(true);
          else
            bm = this_pos(false);
          return true;
        }
        break;
     case ADVANCE_LEFT:
        /*if (is_start_pos(bm) && tb->is_of_type<text_block>() && !prev_node_is_root_text(this, tb))
        {
          bm = this->owner->start_pos();
          return true;
        }
        else*/ if (tb->is_of_type<text_block>())
          return tb->advance_caret_pos(v, bm, dir, out);
        else {
          if (tb->get_style(v)->direction == direction_ltr)
            bm = this_pos(false);
          else
            bm = this_pos(true);
          return true;
        }
        break;
     default:
       return tb->advance_caret_pos(v, bm, dir, out);
    }

  }

  wchar text::ui_char_code(const bookmark &bm) const {
#if 0 // defined(USE_D2D)
    if( bm.tb && bm.tb->ldata)
    {
      wchars wc = bm.tb->ldata.ptr_of<text_block::layout_data>()->chars();
      return bm.tb_pos >= 0 && bm.tb_pos < int(wc.length) ? wc[ bm.tb_pos]:0;
    }
#endif
    if (bm.pos < 0 || bm.pos >= chars.size()) return 0;
    return chars[bm.pos];
  }

  void text::denormalize(bookmark &bm) const {
    assert(bm.node.ptr() == this);
    if (!bm.after_it) // normalized already
      return;
    if (bm.pos < 0)
      bm.pos = 0;
    else if (bm.pos >= this->chars.size())
      bm.pos = this->chars.size();
    if (!u16::advance(chars(), 1, bm.pos._v)) bm.pos = this->chars.size();
    bm.after_it = false;
  }

  void text::normalize(bookmark &bm) const {
    assert(bm.node.ptr() == this);
    if (bm.pos < 0 || this->chars.size() == 0) {
      bm.pos      = 0;
      bm.after_it = false;
    } else if (bm.pos >= this->chars.size()) {
      bm.pos      = this->chars.last_index();
      bm.after_it = true;
    }
    /*else if(chars.size())
    {
      if(after)
        while(chars[bm.pos] == '\r')
      {


      }
    }*/
  }

  bool text::advance_forward(bookmark &bm, wchar &c) const {
    c = 0;
    assert(bm.node.ptr() == this);
    if (bm.after_it) {
      bm.after_it = false;
      bm.pos      = bm.pos + 1;
      if (bm.pos > chars.last_index()) bm = this_pos(true);
    } else if (bm.pos >= 0 && bm.pos < chars.size()) {
      c           = chars[bm.pos];
      bm.after_it = true;
    } else
      bm = this_pos(true);
    return true;
  }
  bool text::advance_backward(bookmark &bm, wchar &c) const {
    c = 0;
    assert(bm.node.ptr() == this);
    if (!bm.after_it) {
      bm.after_it = true;
      bm.pos      = bm.pos - 1;
      if (bm.pos < 0) bm = this_pos(false);
    } else if (bm.pos >= 0 && bm.pos < chars.size()) {
      c           = chars[bm.pos];
      bm.after_it = false;
    } else
      bm = this_pos(false);
    return true;
  }

  bool text::is_caret_pos(view& v, const bookmark &bm) const {
    int lp = bm.linear_pos();
    if (lp == 0 && chars.size() == 0) return true;
    if (lp < 0 || lp > chars.size()) return false;
    element *tb = bm.node->nearest_box(true);
    if (tb && tb->is_of_type<text_block>())
      return tb->cast<text_block>()->is_caret_pos_at(v,bm);
    return false;
  }

  bool text::is_char_pos(view& v,const bookmark &bm) const {
    int lp = bm.linear_pos();
    if (lp == 0 && chars.size() == 0) return true;
    if (lp < 0 || lp > chars.size()) return false;
    element *tb = bm.node->nearest_box();
    if (tb && tb->is_of_type<text_block>())
      return tb->cast<text_block>()->is_caret_pos_at(v,bm);
    return false;
    /*    assert(bm.node.ptr() == this);
        int p = bm.linear_pos();
        return p >= 0 && p <= chars.size(); */
  }
  bool text::is_start_pos(const bookmark &bm) const {
    assert(bm.node.ptr() == this);
    return (bm.pos + int(bm.after_it)) <= 0;
  }
  bool text::is_end_pos(const bookmark &bm) const {
    assert(bm.node.ptr() == this);
    return (bm.pos + int(bm.after_it)) >= chars.size();
  }
  wchar text::char_code(const bookmark &bm) const {
    int i = bm.pos; // - int(bm.after_it);
    if (i < 0 || i >= chars.size()) return 0;
    return chars[i];
  }

  void css_content::clear_style() {
    if (before) before->clear_style();
    if (after) after->clear_style();
    if (marker) marker->clear_style();
    //if (shade) shade->clear_style();
  }

  hstyle                element::null_style       = new style();
  handle<layout_data>   element::null_layout_data = new layout_data();
  THREAD_LOCAL element* element::drawing_element  = nullptr;

  element::element(uint st)
      : tag(st), c_style(null_style), p_style(null_style), d_style(null_style), p_drawn_style(null_style),
        ldata(null_layout_data), positioned_parent(0)/*, last_act_assigned(0)*/ {
    assert(tag.is_defined());
#ifdef DEBUG
    if (tag == tag::T_INPUT)
      st = st;
#endif
  }

  element::element(NO_INIT ni)
      : super(ni), tag(ni), lang(ni), atts(ni), state(ni), style_state(ni), nodes(ni), flags(ni),
        ldata(ni), c_style(ni), p_style(ni), p_drawn_style(ni), d_style(ni), a_style(ni),
        animator(ni), behavior(ni),
        meta(ni), airborn(ni), style_content(ni), weakable(ni), forced_style_set_holder(ni), vars(ni)
#if defined(SCITERJS)
        , event_target(ni)
#endif

  {
    assert(tag.is_defined());
  }

  element::~element() {
    #ifdef _DEBUG
       if(tag == tag::T_OBJECT)
         ldata = ldata;
    #endif
    if (ldata) ldata->drop();
    FOREACH(i, nodes)
    nodes[i]->detach(this);
  }

  void element::finalize() {
    if (ldata) ldata->drop();
    FOREACH(i, nodes)
      nodes[i]->detach(this);
    super::finalize();
  }

  element * element::logical_parent() const
  {
    if (!is_connected()) return nullptr;
    if (parent->tag == tag::T_POPUP) {
      auto ct = parent->ctl_type();
      if(ct != CTL_SELECT_SINGLE && ct != CTL_SELECT_MULTIPLE)
        return parent.ptr();
      if(!parent->parent)
        return parent.ptr();
      if (parent->parent->ctl_type() == CTL_DD_SELECT)
        return parent->parent;
    }
    return parent.ptr();
  }

  string element::node_def() const {
    string out = CHARS("Element(");
    out += tag::symbol_name(tag);
    ustring id = attr_id();
    if (id.length()) {
      out += CHARS("#");
      out += string(id);
    }
    string cls = attr_class();
    if (cls.length()) {
      atokens z(cls, CHARS(" "));
      chars  t, v = cls;
      while (z.next(t)) {
        out += CHARS(".");
        out += t;
      }
    }
    out += CHARS(")");
    return out;
  }

  bool element::set_style_variables(view &v, const dictionary<string, value>& vars) {
#if 1
    int counter = 0;
    int counter_color = 0;
    for (auto& pair : vars.elements()) {
      if (this->vars.set(pair.key, pair.val)) {
        ++counter;
        if (pair.val.is_color())
          ++counter_color;
      }
    }
    if (counter)
      v.refresh(this);

    if (counter_color != counter) {
      drop_layout_tree(&v);
      v.add_to_update(this, true);
    }
    else {
      drop_styles(v);
      v.add_to_update(this, false);
    }

    return counter > 0;
#else
    int counter = 0;
    int counter_lengths = 0;
    for (auto& pair : vars.elements()) {
      if (this->vars.set(pair.key, pair.val)) {
        ++counter;
        if (pair.val.is_length())
          ++counter_lengths;
      }
    }
    if (counter)
      v.refresh(this);

    if (counter_lengths) {
      drop_layout_tree(&v);
      v.add_to_update(this, true);
    }
    else {
      drop_styles(v);
      v.add_to_update(this, false);
    }

    return counter > 0;
#endif
  }

  bool element::set_style_variable(view &v, const string &ns, value val) {
    if (this->vars.set(ns, val)) {
      v.refresh(this);
      if (!val.is_color()) {
        drop_layout_tree(&v);
        v.add_to_update(this, true);
      }
      else {
        drop_styles(v);
        v.add_to_update(this, false);
      }
      return true;
    }
    return false;
  }

  node *element::get_node_by_uid(long uid_) const {
    if (uid == uid_) return const_cast<node *>(static_cast<const node *>(this));
    FOREACH(i, nodes) {
      node *t = nodes[i]->get_node_by_uid(uid_);
      if (t) return t;
    }
    element *t = 0;
    const_cast<element *>(this)->each_ui_child([uid_, &t](element *el) -> bool {
      if (el->uid == uid_) {
        t = el;
        return true;
      } else
        return false;
    });
    return t;
  }

  element *element::get_element_by_uid(long uid_) const {
    node * pn = element::get_node_by_uid(uid_);
    if (!pn) return nullptr;
    return pn->is_element() ? pn->cast<element>() : nullptr;
  }

  int element::index() const {
    if (!parent) return 0;
    if (!parent->flags.indexes_are_valid) {
      parent->flags.indexes_are_valid = 1;
      int          n                  = 0;
      slice<hnode> nodes              = parent->nodes();
      for (uint i = 0; i < nodes.length; ++i) {
        if (nodes[i]->is_element())
          nodes[i].ptr_of<element>()->flags.index = n++;
      }
    }
    return flags.index;
  }

  node *element::first_node() const {
    if (nodes.size() == 0) return 0;
    return nodes.first();
  }
  node *element::last_node() const {
    if (nodes.size() == 0) return 0;
    return nodes.last();
  }

  element *element::first_element() const {
    for (int n = 0; n < nodes.size(); ++n)
      if (nodes[n]->is_element()) return nodes[n].ptr_of<element>();
    return 0;
  }
  element *element::last_element() const {
    for (int n = nodes.last_index(); n >= 0; --n)
      if (nodes[n]->is_element()) return nodes[n].ptr_of<element>();
    return 0;
  }

  node *element::first_nonspace_node() const {
    for (int n = 0; n < nodes.size(); ++n) {
      node *pn = nodes[n];
      if (pn->is_comment()) continue;
      if (pn->is_text() && pn->cast<text>()->is_space()) continue;
      return pn;
    }
    return 0;
  }
  node *element::last_nonspace_node() const {
    for (int n = nodes.last_index(); n >= 0; --n) {
      node *pn = nodes[n];
      if (pn->is_comment()) continue;
      if (pn->is_text() && pn->cast<text>()->is_space()) continue;
      return pn;
    }
    return 0;
  }

  element *element::next_child(const element *el) const {
    assert(el->parent == this);
    if (el->node_index == UNDEFINED_NODE_INDEX)
      return nullptr;
    int nm = nodes.size();
    for (int i = el->node_index + 1; i >= 0 && i < nm; ++i)
      if (nodes[i]->is_element()) return nodes[i].ptr_of<element>();
    return nullptr;
  }
  element *element::prev_child(const element *el) const {
    assert(el->parent == this);
    // assert(el->node_index < nodes.length());
    if (el->node_index < nodes.length())
      for (int i = el->node_index - 1; i >= 0; --i)
        if (nodes[i]->is_element()) return nodes[i].ptr_of<element>();
    return nullptr;
  }

  element *element::first_ui_element() {
    element *p = 0;
    each_ui_child([&p](element *el) -> bool {
      p = el;
      return true;
    });
    return p;
  } // ui child

  element *element::last_ui_element() {
    element *p = 0;
    each_ui_child(
        [&p](element *el) -> bool {
          p = el;
          return true;
        },
        BACKWARD);
    return p;
  } // ui child

  element *element::next_ui_element() {
    element *owner = get_owner();
    if (!owner) return nullptr;
    return owner->ldata->next_ui_element(this);
  } // ui child

  element *element::prev_ui_element() {
    element *owner = get_owner();
    if (!owner) return nullptr;
    return owner->ldata->prev_ui_element(this);
  } // ui child

  element *element::child(int index) const {
    int nm = nodes.size();
    if (index < 0 || index >= nm) return nullptr;
    for (int i = index; i < nm; ++i) // start lookup from the index
      if (nodes[i]->is_element()) {
        element *pc = nodes[i].ptr_of<element>();
        if (pc->index() == index) return pc;
      }
    return nullptr;
  }

  element *element::find_by_id(const ustring &id, bool this_too,
                               bool skip_frames) {
    if (this_too && attr_id() == id) return this;
    slice<hnode> nodes = this->nodes();
    for (int i = 0; i < nodes.size(); ++i)
      if (nodes[i]->is_element()) {
        element *pc = nodes[i].ptr_of<element>();
        if (skip_frames && pc->is_document()) continue;
        pc = pc->find_by_id(id, true, skip_frames);
        if (pc) return pc;
      }
    return 0;
  }

  element *element::find_by_tag(tag::symbol_t t, bool this_too,
                                bool skip_frames) {
    if (this_too && tag == t) return this;
    slice<hnode> nodes = this->nodes();
    for (int i = 0; i < nodes.size(); ++i)
      if (nodes[i]->is_element()) {
        element *pc = nodes[i].ptr_of<element>();
        if (skip_frames && pc->is_document()) continue;
        pc = pc->find_by_tag(t, true, skip_frames);
        if (pc) return pc;
      }
    return 0;
  }

  element *element::find_for_id(const ustring &id,
                                const element *except) const {
    if (atts.get_ustring(attr::a_for) == id) return const_cast<element *>(this);

    if (except)
      for (const element *ch = first_element(); ch; ch = ch->next_element())
        if (ch != except) {
          element *t =
              ch->find_for_id(id, ch /*to indicate - don't visit parent*/);
          if (t) return t;
        }

    if (parent && (this != except)) return parent->find_for_id(id, this);

    return 0;
  }

  element *element::find_neighbour_id(const ustring &id, const element *except,
                                      bool and_name_too) const {
    if (atts.get_ustring(attr::a_id) == id) return const_cast<element *>(this);
    if (and_name_too && atts.get_ustring(attr::a_name) == id)
      return const_cast<element *>(this);

    if (except)
      for (const element *ch = first_element(); ch; ch = ch->next_element())
        if (ch != except) {
          element *t = ch->find_neighbour_id(
              id, ch /*to indicate - don't visit parent*/, and_name_too);
          if (t) return t;
        }

    if (parent && (this != except))
      return parent->find_neighbour_id(id, this, and_name_too);

    return 0;
  }

  bool element::belongs_to(element *pb, bool include_this) {
    element *t = include_this ? this : dom_parent();
    while (t) {
      if (t == pb) return true;
      t = t->dom_parent();
    }
    return false;
  }

  // same as belongs_to above but takes popups into account
  bool element::belongs_to(view &v, element *pb, bool include_this) {
    element *t = include_this ? this : get_owner();
    while (t) {
      if (t == pb) return true;
      t = t->ui_parent(v);
    }
    return false;
  }

  element *element::ui_owner(view &v) {
    if (!parent) return 0;
    if (state.popup() && get_owner()) {
      element *ta = v.popup_anchor(this);
      if (ta) return ta;
    }
    return get_owner();
  }

  element *element::ui_parent(view &v) {
    if (!is_connected()) return nullptr;
    if (state.popup() && get_owner()) {
      element *ta = v.popup_anchor(this);
      if (ta) return ta;
    }
    return parent;
  }


  void element::append(node *n, view *pv) {
    //assert(!n->is_connected());

    if(n->wraps_nodes()) {
      array<hnode> nodes;
      n->unwrap_nodes(nodes);
      return append_nodes(nodes, pv);
    }

    if (n->is_connected()) {
      if (pv) {
        pv->add_to_update(n->parent, CHANGES_MODEL);
        pv->on_content_change(n->parent, CONTENT_REMOVED);
      }
      n->remove(false);
    }
    n->got_parent(this, nodes.size());

    nodes.push(n);
    flags.indexes_are_valid = 0;
    if (!pv)
      return;
    if (pv->mutator_rq(this, CONTENT_ADDED))
    {
      if (n->is_element()) check_states();

      drop_layout();

      element *last_el = this->last_element();
      if (last_el) last_el->drop_styles(*pv);
      pv->add_to_update(this, CHANGES_MODEL);
      pv->on_content_change(this, CONTENT_ADDED);

    }
  }

  void element::append_nodes(slice<hnode> other_nodes, view *pv) {
    insert_nodes(nodes.size(), other_nodes, pv);
  }

  void element::insert_nodes(int idx, slice<hnode> other_nodes, view *pv) {
    idx = limit(idx, 0, nodes.size());
    int start = idx;
    while (!!other_nodes) {
      node *n = other_nodes++;
      //if (!n) continue;
      n->got_parent(this, idx);
      nodes.insert(idx, n);
      ++idx;
    }
    flags.indexes_are_valid = 0;
    if (!pv)
      goto SILENT;
    if (pv->mutator_rq(this, CONTENT_ADDED))
    {
      if (!pv) pv = pview();
      for (idx = start; idx < nodes.size(); ++idx) {
        hnode pn = nodes[idx];
        pn->node_index = idx;
        if (pn->is_element() && pv)
          pn.ptr_of<element>()->drop_styles(*pv);
      }
      check_states();
      drop_layout();
      if (pv) {
        pv->add_to_update(this, CHANGES_MODEL);
        pv->on_content_change(this, CONTENT_ADDED);
      }
    }
    else {
SILENT:
      int nm = nodes.size();
      for (int i = start; i < nm; ++i) {
        node *tn = nodes[i];
        tn->node_index = i;
      }
    }
  }

  void element::insert(int nidx, node *n, view *pv) {

    if (n->wraps_nodes()) {
      array<hnode> nodes;
      n->unwrap_nodes(nodes);
      return insert_nodes(nidx,nodes(), pv);
    }

    handle<node> holder = n;
    if (n->parent == this)
      nodes.remove(n->node_index); // just reposition
    else if (n->parent && n->is_connected()) {
      helement p = n->parent;
      if (p == this && int(n->node_index) == nidx) return;
      if (p == this && int(n->node_index) < nidx) --nidx;
      n->remove(false,pv);
    }
    nidx = limit(nidx, 0, nodes.size());
    n->got_parent(this, nidx);
    if (nidx >= nodes.size())
      nodes.push(n);
    else
      nodes.insert(nidx, n);

    flags.indexes_are_valid = 0;
    if (!pv)
      goto SILENT;
    if (pv->mutator_rq(this,CONTENT_ADDED))
    {
      int nm = nodes.size();
      int elidx = 0;
      for (int i = 0; i < nm; ++i) {
        node *tn = nodes[i];
        tn->node_index = i;
        if (tn->is_element()) {
          element *el = tn->cast<element>();
          el->flags.index = elidx++;
          if (pv) el->drop_styles(*pv);
        }
      }
      flags.indexes_are_valid = 1;
      if (n->is_element()) {
        n->cast<element>()->drop_layout(pv);
        check_states();
      }
      drop_layout();
      if (pv) {
        pv->add_to_update(this, CHANGES_MODEL);
        pv->on_content_change(this, CONTENT_ADDED);
      }
    }
    else {
SILENT:
      int nm = nodes.size();
      for (int i = nidx; i < nm; ++i) {
        node *tn = nodes[i];
        tn->node_index = i;
      }
    }
  }

  void element::commit_mutation(view &v, uint mflags, bool top) {
    int nm = nodes.size();
    int elidx = 0;
    for (int i = 0; i < nm; ++i) {
      node *tn = nodes[i];
      tn->node_index = i;
      if (tn->is_element()) {
        element *el = tn->cast<element>();
        el->flags.index = elidx++;
        el->drop_styles(v);
      }
    }
    check_states();
    flags.indexes_are_valid = 1;
    bool queued = false;
    if (top) {
      v.add_to_update(this, CHANGES_MODEL);
      queued = true;
      v.on_content_change(this, mflags);
    }
    else
      drop_layout();

    if (mflags & ATTRIBUTES_CHANGED) {

      helement b = nearest_box();
      v.refresh(b);
      drop_layout_tree(&v);
      if(!queued)
        v.add_to_update(b, CHANGES_MODEL);
      element* nsb = next_element();
      if (nsb && (nsb->c_style != null_style)) {
        nsb->drop_styles(v);
        nsb->get_style_no_cache(v);
      }
    }


  }



  inline bool is_plaintext_line(element *el) {
    return el->tag == tag::T_TEXT && el->parent &&
           el->parent->tag == tag::T_PLAINTEXT;
  }

  node *element::split(view &v, int at, bool force) {
    if (!parent) return 0;
    if (!force && (at <= 0 || at >= nodes.size())) return 0;
    tag::symbol_t new_tag = tag;
    if ((flags.is_synthetic || state.synthetic()) && !is_plaintext_line(this))
      new_tag = tag::T_P;
    handle<element> ne = new element(new_tag);
    ne->atts           = atts;
    ne->atts.remove(attr::a_id);
    ne->append_nodes(nodes(at));
    drop_layout();
    nodes.size(at);
    parent->insert(node_index + 1, ne, &v);
    return ne;
  }
  int element::unsplit(view &v) {
    node *nn = next_node();
    ASSERT(nn && nn->is_element());
    //{
    //  assert(false);
    //  return nodes.size();
    //}
    helement ne = nn->cast<element>();
    ASSERT(ne->tag == tag /*&& ne->atts == atts*/);
    //{
    //  assert(false);
    //  return nodes.size();
    //}
    int at = nodes.size();
    ne->remove(true,&v);
    append_nodes(ne->nodes(), &v);
    return at;
  }

  /*void element::clear_value(view& v)
  {
    if (!behavior || !behavior->set_value(v, this, value()))
      clear(&v);
  }*/

  void element::clear(view *pv) {
    if (nodes.size() == 0) return;
    if (pv) {
      for (helement c = first_element(); c; c = c->next_element())
        c->stray(*pv);
      pv->add_to_update(this, CHANGES_MODEL);
      pv->on_content_change(this, CONTENT_REMOVED);
    }
    drop_layout();
    while (nodes.size()) {
      hnode tn   = nodes.pop();
      tn->detach(this);
    }
    nodes.clear();
  }

  element *element::clone_element(bool and_content, bool and_attributes) {
    element *t = new element(this->tag);
    if (and_attributes) t->atts = atts;
    // t->atts.remove(attr::a_id);
    if (and_content) {
      int nn = nodes.size();
      t->nodes.size(nn);
      for (int n = 0; n < nn; ++n) {
        node *tn = nodes[n]->clone();
        // tn->parent = t;
        // tn->owner = t;
        // tn->node_index = n;
        tn->got_parent(t, n);
        t->nodes[n] = tn;
      }
      t->flags.indexes_are_valid = 0;
      // t->flags.layout_ctl_valid = 0;
    }
    t->state                   = state.clone();
    t->flags.is_synthetic      = flags.is_synthetic;
    t->flags.state_initialized = 1;
    t->drop_layout();
    return t;
  }

  void element::copy_content_from(view &v, const element *src) {
    drop_layout();
    // for(helement c = first_element();c; c = c->next_element()  )
    //  c->stray(v);
    int nn = nodes.size();
    for (int n = 0; n < nn; ++n) {
      handle<node> pnn = nodes[n];
      if (pnn->is_element()) pnn.ptr_of<element>()->stray(v);
    }
    nodes.clear();
    for (int n = 0; n < src->nodes.size(); ++n) {
      handle<node> pnn = src->nodes[n]->clone();
      append(pnn);
    }
  }

  void element::remove_nodes(int from, int to, view *pv) {
    to = min(to, nodes.size());
    if (from < 0 || from >= nodes.size() || to <= from) return;
    if (pv) pv->add_to_update(this, CHANGES_MODEL);

    for (int n = from; n < to; ++n) {
      handle<node> pnn = nodes[n];
      if (pnn->is_element() && pv) pnn.ptr_of<element>()->stray(*pv);
      pnn->owner  = nullptr;
      pnn->parent = nullptr;
      pnn->node_index = UNDEFINED_NODE_INDEX;
    }
    nodes.remove(from, to - from);
    flags.indexes_are_valid = 0;
    for (int n = 0; n < nodes.size(); ++n)
      nodes[n]->node_index = n;
    drop_layout(pv);
  }


  void handle_detachment(view& v, helement self, bool force_close_popups) {
    if (self->state.popup() || self->state.owns_popup() || force_close_popups)
      v.close_popup_tree(self);
    if (self->airborn)
      v.stop_move_element(self);
    if (self->state.hover()) {
      event_mouse evt(self, 0, point(0, 0), 0, 0);
      v.mouse_over_element = self->parent;
      evt.cmd = MOUSE_LEAVE | EVENT_SINKING;
      v.traverse_mouse_parent_child(self, self->parent, evt);
      evt.cmd = MOUSE_LEAVE;
      v.traverse_mouse_child_parent(self, self->parent, evt);
    }
    if (!v.has_mutator() && self->parent && !self->parent->flags.strayed) {
      v.on_content_change(self->parent, CONTENT_REMOVED);
      v.add_to_update(self->parent, CHANGES_MODEL);
    }
    if (self->positioned_parent && !self->positioned_parent->flags.strayed) {
      v.add_to_update(self->positioned_parent, CHANGES_DIMENSION);
      self->positioned_parent->ldata->zctx.remove(self, self->positioned_parent);
    }
  }

  bool element::remove(bool finalize, view *pv) {
#ifdef DEBUG
     //dbg_report("removing element");
#endif
    int cnt = get_ref_count();
    html::helement self = this;
    bool was_connected = is_connected();
    if (was_connected) {
      //if (!pv) pv = p->pview();
      if (pv) handle_detachment(*pv, self, true);
    }
    if (pv && ((cnt == 1) || finalize))
      self->stray(*pv);
    if (!node::remove(finalize, pv))
      return false;
    this->drop_styles_and_states(pv);
    this->drop_forced_style_set();
    this->flags.state_initialized = !finalize;
    return true;

  }

  void handle_detachment(view& v, helement self, bool force_close_popups);

  // element is about to be completely removed from the DOM, clear all runtime
  // structures
  void element::stray(view &v) {

#ifdef DEBUG
    if (tag == tag::T_OBJECT)
      ldata = ldata;
    if (tag == tag::T_TEXT && parent->tag == tag::T_PLAINTEXT)
      flags.strayed = flags.strayed;
#endif // DEBUG


    if (flags.strayed)
      return;

    flags.strayed = 1;

    handle<layout_data>  holder = ldata;

    v.on_element_removing(this); // NOTE: this shall be called before super::stray(v);

    super::stray(v);
#if defined(SCITERJS)
    if(subscriptions.length())
      subscriptions.clear();
#endif

    if (animator)
      v.remove_animation(this);

    handle_detachment(v, this, false);

    auto cb = [&v](hnode pn) -> bool {
      pn->stray(v);
      return false;
    };

    //if (this->get_ref_count() > 1)
    //  v.unobserve_element(this);

    each_any_child_node(cb);

    detach_behaviors(v);

    // subscriptions.clear();

    if (ldata) {
      ldata->drop();
      if (ldata->lmarker) {
        ldata->lmarker = nullptr;
      }
      flags.clear();
    }
    v.on_element_removed(this);

    c_style = d_style = null_style;
    p_style           = null_style;
    p_drawn_style     = null_style;
    a_style           = nullptr;
    positioned_parent = 0;
    meta.clear();
  }

  int element::n_children() const {
    element *last = last_element();
    // note: element::index() can be negative - SYNTHETIC_NODE_INDEX
    if (last) return max(0,last->index()) + 1;
    return 0;
  }


  // virtual bool each_ui_child( const function<bool(element*)>& f );
  //   virtual bool each_ui_child( const function<bool(element*)>& f, BACKWARD_E
  //   ); virtual element* first_ui_element(); virtual element*
  //   last_ui_element();

  bool element::is_inline_element(view &v) {
    get_style(v);
    return c_style->display == display_inline ||
           c_style->display == display_inline_block ||
           c_style->display == display_inline_table;
  }

  bool element::is_inside_text_flow(view &v) {
    element *owner = get_owner();
    if (get_owner() && owner->is_of_type<text_block>()) return true;
    //if (parent && parent->is_of_type<text_block>()) return true;
    return false;
  }

  bool element::is_atomic_box() const {
    if (tag == tag::T_IMG || tag == tag::T_PICTURE || tag == tag::T_INPUT ||
        tag == tag::T_BUTTON || tag == tag::T_SELECT || tag == tag::T_WIDGET ||
        tag == tag::T_FRAME || tag == tag::T_BR || tag == tag::T_HR || tag == tag::T_IFRAME)
      return true;
    if (this->get_style()->is_inline_span()) return false;
    if (this->behavior && this->behavior->is_atomic()) return true;
    //if (this->parent && this->parent->state.content_editable() && this->get_style()->is_inline_block()) return true;
    return false;
  }

  bool element::is_inline_span_element(view &v) {
    get_style(v);
    return c_style->display == display_inline &&
           c_style->get_float() == float_none && !oof_positioned(v);
  }

  bool element::is_inline_block_element(view &v) {
    const style* cs = get_style(v);
    return  cs->display == display_inline_block ||
            cs->display == display_inline_table ||
            cs->get_float() != float_none || oof_positioned(v);
  }

  bool element::is_inline_block_element() {
    view* pv = pview();
    if (!pv) return false;
    return is_inline_block_element(*pv);
  }


  bool element::is_row_element(view &v) {
    const style *cs = get_style(v);
    return cs->display == display_table_row || cs->flow == flow_table_row;
  }
  bool element::is_table_element(view &v) {
    get_style(v);
    return c_style->display == display_table ||
           c_style->display == display_inline_table;
  }
  bool element::is_inline_table_element(view &v) {
    return get_style(v)->display == display_inline_table;
  }
  bool element::is_cell_element(view &v) {
    return get_style(v)->display == display_table_cell;
  }
  bool element::is_block_element(view &v) {
    get_style(v);
    return c_style->display == display_block ||
           c_style->display == display_table ||
           //c_style->display == display_table_body ||
           //c_style->display == display_table_row ||
           c_style->display == display_table_cell ||
           c_style->display == display_list_item;
  }
  bool element::is_box_element(view &v) {
    get_style(v);
    return (!c_style->is_display_none() &&
            c_style->display != display_inline) ||
           c_style->get_float() != float_none || oof_positioned(v);
  }

  bool element::is_it_visible(view &v) {
    hstyle cs = get_style(v);
    return cs->visible() /*|| (animator && animator->always_visible())*/ ||
           state.popup();
  }

  bool element::it_takes_space(view &v) {
    hstyle cs = get_style(v);
    return !cs->is_display_none();
  }


  bool element::is_it_drawable(view &v) {
    return is_it_visible(v) && c_style->opacity > 0;
  }

  size element::rel_shift(view &v, element *contianer) {
    // assert(rel_positioned(v));

    if ((this != contianer) && rel_positioned(v)) {
      point  p;
      size_v l = c_style->left;
      size_v r = c_style->right;
      size_v t = c_style->top;
      size_v b = c_style->bottom;

      if (l.is_defined())
        p.x = pixels(v, this, l).width();
      else if (r.is_defined())
        p.x = -pixels(v, this, r).width();
      if (t.is_defined())
        p.y = pixels(v, this, t).height();
      else if (b.is_defined())
        p.y = -pixels(v, this, b).height();
      return p + parent->rel_shift(v, contianer);
    }
    return point();
  }

  uint element::get_tab_size() const { return c_style->tab_size.val(8); }

  bool element::is_disabled() const {
    const element *t = this;
    while (t) {
      if (t->state.disabled()) return true;
      t = t->parent;
    }
    if (this->parent && this->parent->state.content_editable() && this->is_input_ctl_type())
      return true;
    return false;
  }
  bool element::is_readonly() const {
    const element *t = this;
    while (t) {
      if (t->state.readonly()) return true;
      t = t->parent;
    }
    return false;
  }

  bool element::is_empty() const {

    for (ctl *t = behavior; t; t = t->next) {
      bool r = false;
      if (t->is_empty(this, r)) return r;
    }

    for (int n = 0; n < nodes.size(); ++n) {
      if (!nodes[n]->is_space()) return false;
    }
    return true;
  }

  int_v element::tab_index() const {
    if (state.wants_no_focus()) return int_v::null_val();
    if (state.non_tabable()) return int_v::null_val();

    ustring v;
    if(atts.exist(attr::a_tabindex,v))
    {
      int ti = 0;
      if (v.length() && stoi(v, ti))
        return ti;
      else
        return int_v(0);
    }

    if (state.wants_focus()) return int_v(0);

    ctl *pc = behavior;
    while (pc) {
      if (pc->focusable(this)) return int_v(0);
      pc = pc->next;
    }
    // this was used to make scrollables tab focusable but appears as a wrong
    // idea ... Bunch of Symantec issues.
    //    if( _style->overflow() > overflow_hidden )
    //       return int_v(0);

    // hstyle cs = current_style();
#if 0
    if (c_style->act_focus_on || c_style->act_focus_off) return int_v(0);
#endif

    return int_v::null_val();
  }

  bool element::is_focusable(view &v) {
    if (state.wants_no_focus()) return false;
    if (!is_visible(v) || state.disabled())
      return false;
    int_v ti = tab_index();
    if (ti.is_defined() && ti >= 0)
      return true;
    behavior_h pc = behavior;
    while (pc) {
      if (pc->focusable(this)) return true;
      pc = pc->next;
    }
    return /*is_x_focusable(v) ||*/ get_style(v)->overflow() > overflow_hidden;
  }
#ifndef SCITER
  //bool element::is_x_focusable(view &v) { return false; }
#endif

  element *element::_find_element(view &v, point zpt, bool exact) {

#ifdef DEBUG
    if (is_id_test())
      zpt = zpt;
#endif

      rect sp = hit_box(v);
      zpt     = inverse_translate(v, zpt);
      if (sp.contains(zpt)) {
        if (c_style->overflow() == overflow_hidden && c_style->has_rounded_corners())
        {
          gool::rect         r = border_box(v);
          handle<gool::path> path;
          gool::rect         box;
          c_style->background_outline(v, v.surface(), r, box, path,this);
          if (path) {
            if (path->is_inside(zpt))
              return this;
            else
              return nullptr;
          }
        }
        if (v.hit_test_element(this, zpt))
          return this;
      }

      if (!ldata->zctx.is_empty()) {
        point nt_zpt = zpt;
        zpt          = inverse_translate(v, zpt);
        zpt += scroll_pos();
        zpt -= client_rect(v).s;

        element *zel = ldata->zctx.find_element(v, zpt, nt_zpt, this);
        if (zel) return zel;
      }

      if (this == v.mouse_capture_element && !exact) {
        if (v.hit_test_element(this, zpt)) return this;
      }

      if( ldata->sb.hit_test(zpt) )
        return this;

      if (exact)
        return 0;
      return this;
  }

  element *element::find_element(view &v, gool::point zpos, bool exact) {

    if (!is_visible(v))
      return 0;

    check_layout(v);

    if (!_find_element(v, zpos, exact))
      return nullptr;

    zpos = inverse_translate(v, zpos);

    point nt_zpos = zpos;

    zpos += scroll_pos();
    zpos -= client_rect(v).s;

    element *t = ldata->zctx.find_element(v, zpos, nt_zpos, this);
    if (t) return t;

    if (auto marker = get_marker()) {
      //#ifdef _DEBUG
      //      if (marker->hit_box(v, TO_PARENT).left() < 0 && zpos.x < 0)
      //        marker = marker;
      //#endif
      if (marker->get_style(v)->z_index.val(0) >= 0 && marker->hit_box(v, TO_PARENT).contains(zpos))
        return marker;
    }

    if (auto shade = get_shade()) {
      //#ifdef _DEBUG
      //      if (marker->hit_box(v, TO_PARENT).left() < 0 && zpos.x < 0)
      //        marker = marker;
      //#endif
      if (shade->get_style(v)->z_index.val(0) >= 0 && shade->hit_box(v, TO_PARENT).contains(zpos)) {
        point zshadepos = zpos - shade->pos();
        element *shade_child = shade->find_child_element(v, zshadepos, exact);
        return shade_child ? shade_child : shade;
      }
    }

    if (exact && get_style(v)->clip_overflow() && ldata->sb.hit_test(nt_zpos)) // not inside client area - on scrollbar
    {
        return this;
    }

    if (ldata->fctx) {
      element *tb = ldata->fctx->find_element(v, zpos);
      if (tb) return tb;
    }

    element *child = find_child_element(v, zpos, exact);
    if (child) return child;

    return this;
  }

  bool has_valid_style(view &v, element *pe) {
    return pe->c_style != element::null_style;
  }

  void  element::clear_style() {
    drop_forced_style_set();
    if (style_content) style_content->clear_style();
    if (behavior) behavior->clear_style();
    ldata->sb.clear_style();
    if (!flags.in_determine_style) {
      d_style = c_style = null_style;
    }
  }

  void element::drop_styles(view &v) {
    /*if (!c_style->is_display_none() || force_all)
    {
      each_any_child([&v, force_all](element *el) -> bool {
        el->drop_styles(v, force_all);
        return false;
      });
    }
    flags.has_transformed = 0;
    clear_style();*/
    v.drop_styles(this);
  }


  void element::drop_style_and_state(view *pv) {
    flags.has_transformed = 0;
    clear_style();
    if (pv) {
      if (state.hover() && this == pv->mouse_over_element) {
        pv->mouse_over_element = parent;
        state.hover(false);
      }
      if (state.focus() && this == pv->focus_element) {
        pv->post_set_focus(parent, BY_CODE);
        state.focus(false);
      }
      // v.mouse_over_element = v.mouse_over_element->parent;
      if (this == pv->mouse_capture_element) {
        pv->mouse_capture_element = nullptr;
        pv->mouse_capture_strict  = false;
      }
    }
    // state.data = 0;
  }

  void element::drop_styles_and_states(view *pv, bool force_all) {
    function<bool(element * el)> drop = [&drop, force_all,
                                         pv](element *el) -> bool {
      helement hel = el;
      if (hel->c_style != element::null_style || force_all)
        hel->each_ui_child(drop);
      el->drop_style_and_state(pv);
      return false;
    };
    drop(this);
  }

  void element::reset_styles(view &v) {
    flags.has_transformed = 0;

    // v.refresh(this);

    handle<document> pd = doc();

    helement holder = this;

    auto drop = [&v](element *el) -> bool {
      if ((el->c_style != element::null_style && !el->c_style->is_display_none())) {
        helement holder = el;
        el->drop_styles(v);
        el->resolve_styles(v);
      }
      return false;
    };

    c_style = d_style = null_style;
    if (determine_style(v, pd)->visible())
      each_ui_child(drop);
  }

  void element::drop_style(view *pv) {
    if (pv) {
      pv->refresh(this);
      drop_styles(*pv);
    } else
      clear_style();
  }

  void element::drop_positioned(view *pv) {
    if (ldata) {
      ldata->zctx.request_replace();
      if(pv) pv->refresh(this);
    }
  }

  ui_state element::get_state(bool disabled_deep) const {
    ui_state t = state;
    t.animating(animator != 0);
    t.empty(is_empty());
    if (disabled_deep) {
      bool dis = is_disabled();
      t.disabled(dis);
      bool ro = is_readonly();
      t.readonly(ro); //??????????????
    }
    // ATTN: recursive call: don't use is_visible() here!
    // t.focusable( !t.disabled() && tab_index().is_defined() && is_visible() );
    t.focusable(!t.disabled() && tab_index().is_defined());
    t.root(is_document());

    int n = n_children();
    t.has_child(n == 1);
    t.has_children(n > 0);

    if (tag == tag::T_OPTION && n > 0) {
      if (t.expanded() || t.collapsed())
        t.node(true);
      else if (has_children_of_type(tag::T_OPTION))
        t.node(true);
    }

    return t;
  }

  element *element::floats_parent(view &v) {
    element *p = parent;
    while (p) {
      if (p->is_floats_container(v)) return p;
      p = p->parent;
    }
    return doc();
  }

  bool element::is_floats_container(view &v) // a.k.a. layout root
  {
    if (tag == tag::T_BODY || tag == tag::T_HTML || tag == tag::T_FIELDSET)
      return true;

    hstyle cs = get_style(v);

    /* http://www.w3.org/TR/CSS21/visuren.html#block-formatting :
      Floats, absolutely positioned elements, inline-blocks, table-cells,
      table-captions, and elements with 'overflow' other than 'visible' (except
      when that value has been propagated to the viewport) establish new block
      formatting contexts.
      */

    if (cs->overflow() > overflow_visible) return true;

    if (cs->get_float()) return true;

    if (cs->display == display_inline_block) return true;

    if (state.popup()) return true;

    // if(cs->flow > flow_vertical && cs->flow != flow_text)
    //  return true;

    if (cs->position > position_static) return true;

    if (is_table_cell()) return true;

    // + immediate children of flow:something establish block formating context
    element *owner = get_owner();
    hstyle pcs = owner ? owner->get_style(v) : null_style.ptr();
    return pcs->flow != flow_default && pcs->flow != flow_text;
  }

  element *view_root(element *b) {
    view *pv = b->pview();
    return pv ? pv->doc() : b->doc();
  }

  element *element::abs_pos_parent(view &v) {
    element *found_parent = 0;
    helement p;
    helement pp;

    if (positioned_parent) {
      found_parent = positioned_parent;
      goto CHECK;
    }

    if (popup_positioned(v)) {
      found_parent = view_root(this);
      goto CHECK;
    }
    if (fix_positioned(v)) {
      found_parent = doc();
      goto CHECK;
    }

    p  = pp = get_owner();
    while (p) {
      const style* ps = p->get_style(v);
      if (
        ps->position > 0
        || ps->transforms.is_defined()
        || ps->overflow() > 0 // NOTE: IE style , FF and W3C think differently.
        || !p->get_owner()
        || p->is_document()
        || p->state.popup())
      {
        found_parent = p;
        goto CHECK;
      }
#if NOT_YET
      if (p->is_header_row_element(v)) {
        p = p->owner; // special case for fixed table rows
      }
#endif
      pp = p;
      p  = p->get_owner();
    }

    found_parent = doc();
  CHECK:
    /*if(found_parent->ldata->zctx.has_it(this))
      return found_parent;
    if( positioned_parent )
      positioned_parent->ldata->zctx.remove(this,positioned_parent);
    found_parent->ldata->zctx.push(v,found_parent,this);*/
    return found_parent;
  }

  element* element::check_positioned_containment(view &v) {
    element *found_parent = abs_pos_parent(v);
    if (found_parent && !found_parent->ldata->zctx.has_it(this)) {
      if (positioned_parent)
        positioned_parent->ldata->zctx.remove(this, positioned_parent);
      positioned_parent = found_parent;
      // flags.out_of_flow = get_style(v)->position == position_popup;
      assert(positioned_parent->ldata != element::null_layout_data);
      positioned_parent->ldata->zctx.push(v, positioned_parent, this);
    }
    return positioned_parent;
  }

  ustring element::get_lang() const {
    if (lang.is_defined()) return lang;

    ustring l = attr_lang();
    if (l.is_defined()) {
      const_cast<element *>(this)->lang = l;
      return l;
    }

    if (state.popup()) {
      view *pv = pview();
      if (!pv) return ustring();
      element *pp = pv->popup_anchor(const_cast<element *>(this));
      if (pp) return (const_cast<element *>(this)->lang = pp->get_lang());
    }
    if (element *owner = get_owner())
      return (const_cast<element *>(this)->lang = owner->get_lang());
    //else if (parent)
    //  return (const_cast<element *>(this)->lang = parent->get_lang());
    return ustring();
  }

  ustring element::get_theme() const {
    if (theme.is_defined()) return theme;

    ustring t = atts.get_ustring(attr::a_theme);

    if (t.length()) {
      this->theme = t.to_lower();
      return t;
    }

    if (state.popup()) {
      view *pv = pview();
      if (!pv) return ustring();
      element *pp = pv->popup_anchor(const_cast<element *>(this));
      if (pp) return (this->theme = pp->get_theme());
    }
    if (element *owner = get_owner())
      return (this->theme = owner->get_theme());
    return ustring();
  }


  bool element::is_visible(view &v, const element *up_to_parent) {
    helement b = this;
    for (; b; b = b->get_owner()) {
      if (b == up_to_parent) break;
      if (b->state.popup())
        break;
      b->get_style(v);
      if (!b->is_it_visible(v)) return false;
    }
    return true;
  }

  bool element::takes_space(view &v, const element *up_to_parent) {
    helement b = this;
    for (; b; b = b->get_owner()) {
      if (b == up_to_parent) break;
      if (b->state.popup())
        break;
      b->get_style(v);
      if (!b->it_takes_space(v)) return false;
    }
    return true;
  }


  bool element::is_drawable(view &v, const element *up_to_parent) {
    helement b = this;
    for (; b; b = b->get_owner()) {
      if (b == up_to_parent) break;
      if (b == element::drawing_element) break;
      if (b->state.popup()) break;
      b->get_style(v);
      if (!b->is_it_drawable(v))
        return false;
    }
    return true;
  }

  style *element::get_style(view &v, document *pd) {
    if (c_style == null_style) {
      if (!pd) pd = doc();
      if (pd) determine_style(v, pd);
    }
    // assert(ldata);
    return c_style;
  }

  hstyle element::resolve_style_for_mark(view &v, char_mark_t cm)
  {
    style_list list;

    hdocument pd = doc();
    style_bag &sbag = pd->styles();

    get_style_list(v, pd, list);
    style ps;
#pragma TODO("CSS:marks")
#if 0
    if (!list.has_uniques) {
      style::key k = list.compute_marks_key();
      // we need to add cm as a key item
      k.push({style_prop_bag::key_hash,cm});
      ps = pd->styles().get_cached(k);
      if (ps)
        return ps; // that's the idea, we've found style we've already created
      ps = new style();
      ps->set_key(k);
      pd->styles().set_cached(k,ps);
    } else
      ps = new style();
#endif

    ps.inherit(d_style, style::INHERIT_CHAR);
    list.apply_char_mark_styles_to(element_context(v,pd,this,&ps), ps, cm);
    ps.resolve(v, this,*c_style);
    //return ps;
    return pd->styles().intern_resolved(ps);

  }

  style *element::get_style_no_cache(view &v, document *pd) {
    if (c_style == null_style) {
      if (!pd) pd = doc();
      if (pd) determine_style(v, pd, true, true);
    }
    assert(ldata);
    return c_style;
  }

  style *element::get_style() const {
    if (c_style == null_style) {
      document *pd = doc();
      if (pd) {
        view *pv = pd->pview();
        if (pv) const_cast<element *>(this)->determine_style(*pv, pd);
      }
    }
    return c_style;
  }

  value element::get_style_const(view &v, const string &name) {
    document *d = doc();
    if (!d) return value();

    string ssn = get_style(v, d)->style_set;
    if (ssn.is_undefined()) return d->styles().get_const(name);
#pragma TODO("hierarchical style sets?")
    style_bag *sb = d->get_named_style_set(ssn);
    if (sb) return sb->get_const(name);
    return value();
  }

  void element::get_applied_styles(view &v, style_def::callback &cb) {
    document *d = doc();
    if (!d) return;

    style_list slist;
    get_style_list(v, d, slist);

    for (auto& item : slist.list) {
      if (item.prop_bag->is_style_def())
        cb.has_rule(item.prop_bag.ptr_of<style_def>());
      else if (item.prop_bag->is_prop_map())
        cb.has_assigned_style(item.prop_bag.ptr_of<style_prop_map>());
      else if (item.prop_bag->is_prop_list())
        cb.has_inline_style(item.prop_bag.ptr_of<style_prop_list>());
    }
  }

  gool::point element::view_pos(view &v) {
    document *pd = doc();
    if (pd) return doc_pos(v) + pd->view_pos(v);
    return doc_pos(v);
  }

  gool::point element::window_pos(view &v) {
    element *pw = get_windowed_container(v, true);
    if (pw) return view_pos(v) - pw->view_pos(v);
    return view_pos(v);
  }

  gool::point element::screen_pos(view &v) {
    return view_pos(v) + v.client_screen_pos();
  }

  inline element *static_layout_parent(view &v, element *b) {
    element *owner = b->get_owner();
    if (!b || !owner) return 0;
    if (b->floats(v)) return b->floats_parent(v);
    b = owner;
    for (; b; b = b->get_owner()) {
      // if( b->is_inline_element(v) )
      //  continue;
      owner = b->get_owner();
      if (b->is_inline_span_element(v) && owner && owner->is_of_type<text_block>())
        continue;
      if (b->is_of_type<block_table_row>() || b->is_row_element(v)) continue;
      // block_table_body is a real box container, so this wrong: if(
      // b->is_of_type<block_table_body>() )
      //    continue;
      return b;
    }
    return 0;
  }

#if defined(SVG_SUPPORT)
  bool svg_positioned(const element *el);
  struct svg_document;
  element *svg_root(element *el);
#endif

  element *element::layout_parent(view &v) {
    if (!parent) return 0;
    if (popup_positioned(v)) return view_root(this);
    if (fix_positioned(v)) return doc();
    if (abs_positioned(v)) {
      element *l_parent = abs_pos_parent(v);
      if (l_parent) return l_parent;
    }
#if defined(SVG_SUPPORT)
    if (svg_positioned(this)) {
      element *svgr = svg_root(this);
      if (svgr) return svgr;
    }
#endif
    return static_layout_parent(v, this);
  }

  point element::doc_pos(view &v) {
    if (airborn) { // pos is strictly view related
      document *pd = this->parent_doc();
      if (pd) return v.moved_element_pos(this) - pd->view_pos(v);
      return point(0, 0);
    }

    if (state.popup() || popup_positioned(v)) { // pos is strictly view related
      document *pd = this->parent_doc();
      if (pd) {
        // dbg_printf("pos %d %d\n", pos().x, pos().y);
        return pos() - pd->view_pos(v);
      }
      return point(0, 0);
    }
    if (fix_positioned(v)) {
      document *pd = doc();
      if (pd) {
        check_positioned_containment(v);
        return pd->positioned_pos(v, this);
      }
      return pos();
    }

    element *l_parent = 0;

    if (positioned(v)) {
      document *pd = doc();
      if (pd) {
        check_positioned_containment(v);
        l_parent = abs_pos_parent(v);
        if (l_parent) {
          point pos = l_parent->positioned_pos(v, this);
          return l_parent->doc_pos(v) + l_parent->scroll_translate(v, pos);
        }
      }
    }

#if defined(SVG_SUPPORT)
    if (svg_positioned(this)) {
      element *svgr = svg_root(this);
      if (svgr) {
        point parent_pos = svgr->doc_pos(v);
        return parent_pos + pos();
      }
    }
#endif

    l_parent = static_layout_parent(v, this);
    if (l_parent) {
      point parent_doc_pos = l_parent->doc_pos(v);
      return parent_doc_pos + l_parent->scroll_translate(v, pos()) +
             l_parent->client_rect(v).s;
    }
    return point(0, 0); // scroll_translate(pos);
  }

  void element::transform(view &v, affine_mtx_f &mtx) // apply transformations to mtx
  {
    if (ldata && c_style->transforms) {
      // rect r0 = r;
      affine_mtx_f this_mtx;
      compute_mtx(v, this_mtx);
      mtx = this_mtx * mtx;
    }
  }

  point element::transform_view_to_local(
      view &v, point vpt) // translates view point vpt into local dom coordinate
  {
    affine_mtx_f vmx;
    view_mtx(v, vmx);
    vmx.inverse_transform(vpt);

    return vpt;
  }

  point element::transform_local_to_view(view &v, point pt) {
    // pt += this->view_pos(v);
    affine_mtx_f vmx;
    view_mtx(v, vmx);
    vmx.transform(pt);
    return pt;
  }

  // void element::view_mtx(view& v,affine_mtx_f& vmx)
  //{
  //  doc_mtx(v,vmx);
  //  //document *pd = doc();
  //  //if( pd )
  //  //  pd->view_mtx(v,vmx);
  //}

  // void document::view_mtx(view& v,affine_mtx_f& vmx)
  //{
  //  if(_isolated) return;
  //  if(owner) {
  //     owner->view_mtx(v,vmx);
  //  }
  //}

  void element::view_mtx(view &v, affine_mtx_f &vmx) {
    if (airborn) { // pos is strictly view related
      vmx.translate(v.moved_element_pos(this));
      return;
    }

    if (state.popup() || popup_positioned(v)) { // pos is strictly view related
                                                // document* pd = doc();
                                                // if(pd) {
      vmx.translate(pos() /* - pd->view_pos(v)*/);
      // pd->transform(v,vmx);
      //}
      return;
    }

    element *l_parent = 0;

    if (positioned(v)) {
      document *pd = doc();
      if (pd) {
        check_positioned_containment(v);
        l_parent = abs_pos_parent(v);
        if (l_parent && (l_parent != this)) {
          point pos = l_parent->positioned_pos(v, this);
          vmx.translate(l_parent->scroll_translate(v, pos) +
                        l_parent->client_rect(v).s);
          transform(v, vmx);
          l_parent->view_mtx(v, vmx);
        }
      }
      return;
    }

    l_parent = static_layout_parent(v, this);
    if (l_parent) {
      vmx.translate(l_parent->scroll_translate(v, pos()) +
                    l_parent->client_rect(v).s);
      transform(v, vmx);
      l_parent->view_mtx(v, vmx);
    }
  }

  point element::layout_parent_pos(view &v) {
    // element* lp = layout_parent(v);
    // if(lp)
    //  return view_pos(v) - lp->view_pos(v);
    return pos();
  }

  // computes relative position of bp from s of content of this element
  // to get this.pos <-> bp.pos offset use: scroll_translate(rel_pos(bp))
  point element::rel_pos(view &v, element *bp) {
    if (bp == this) return point(0, 0);

    point bp_pos   = bp->view_pos(v);
    point this_pos = this->view_pos(v);

    return this_pos - bp_pos;
  }

  element *element::pos_parent(view &v) // redefined in cell?
  {
    if (state.popup() || popup_positioned(v)) return v.doc(); // super root
    if (fix_positioned(v)) return doc();                      // root
    if (positioned(v)) return abs_pos_parent(v);
    if (floats(v)) return floats_parent(v);
    element *owner = get_owner();
    if (get_owner() && owner->is_row_element(v)) return owner->get_owner();
    return owner;
  }

  rect element::content_box(view &v, RELATIVE_TO rt) {
    if (this->is_box() || this->is_table_row()) switch (rt) {
      case TO_SELF: return rect(dim());
      case TO_PARENT: return rect(pos(), dim());
      case TO_LAYOUT_PARENT: return rect(layout_parent_pos(v), dim());
      case TO_DOC: return rect(doc_pos(v), dim());
      case TO_VIEW: return rect(view_pos(v), dim());
      case TO_SCREEN: return rect(screen_pos(v), dim());
      case TO_WINDOW: return rect(window_pos(v), dim());
      }
    else if (this->is_visible(v) && this->is_connected()) {
      helement cont = this->nearest_box();
      if (cont && cont->parent && cont->is_text_box()) {
        rect            rcout;
        pos_ui_iterator it(v, this->start_caret_pos(v), this->end_caret_pos(v));
        for (bookmark bm; it(bm);) {
          caret_metrics cm;
          if (bm.get_caret_metrics(v, cm)) {
            rect rcglyph = cm.glyph_rc;
            // WTF? int h2 = cm.glyph_rc.height() / 2;
            //     rcglyph >>= size(h2,h2);
            rcout |= rcglyph;
          }
        }
        rect rccont = cont->content_box(v, rt);
        rcout += rccont.s;
        return rcout;
      }
    }
    return rect(dim());
  }

  rect element::margin_box(view &v, RELATIVE_TO rt) {
    return border_box(v, rt) >> ldata->margin_width;
  }
  rect element::border_box(view &v, RELATIVE_TO rt) {
    //WRONG(this method is for external border box only): return padding_box(v, rt) >> ldata->border_width >> ldata->inner_border_width;
    return padding_box(v, rt) >> ldata->border_width;
  }
  rect element::padding_box(view &v, RELATIVE_TO rt) {
    //WRONG: return content_box(v, rt) >> ldata->padding_width >> ldata->inner_padding_width;
    return content_box(v, rt) >> ldata->padding_width;
  }

  rect element::margin_distance(view &v) {
    rect r;
    r.s = ldata->border_width.s + ldata->padding_width.s +
               ldata->inner_border_width.s + ldata->inner_padding_width.s +
               ldata->margin_width.s;
    r.e = ldata->border_width.e + ldata->padding_width.e +
               ldata->inner_border_width.e + ldata->inner_padding_width.e +
               ldata->margin_width.e;

#ifndef SCROLL_INDICATOR_ONLY
    if (c_style->overflow_y == overflow_scroll && !ldata->sb._vsb)
      ldata->sb._vsb = new scrollbar(true, c_style->get_block_vertical_align() == valign_bottom);
    if (c_style->overflow_x == overflow_scroll && !ldata->sb._hsb)
      ldata->sb._hsb = new scrollbar(false, c_style->get_horizontal_align() == align_right);

    if (c_style->overflow_y != overflow_hidden_scroll &&
        c_style->overflow_y != overflow_scroll_indicator) {
      if (state.rtl())
        r.s.x += ldata->sb.v_width(v, this);
      else
        r.e.x += ldata->sb.v_width(v, this);
    }
    if (c_style->overflow_x != overflow_hidden_scroll &&
        c_style->overflow_x != overflow_scroll_indicator) {
      r.e.y += ldata->sb.h_height(v, this);
    }
#endif
    return r;
  }

  rect element::outer_distance(view &v) {
    rect r;
    r.s = ldata->border_width.s + ldata->padding_width.s +
               ldata->inner_border_width.s + ldata->inner_padding_width.s +
               ldata->margin_width.s;
    r.e = ldata->border_width.e + ldata->padding_width.e +
               ldata->inner_border_width.e + ldata->inner_padding_width.e +
               ldata->margin_width.e;
    return r;
  }

  rect element::hit_margin_distance(view &v) {
    rect br = border_box(v);
    rect r = hit_box(v);
    r.s.x = br.s.x - r.s.x;
    r.s.y = br.s.y - r.s.y;
    r.e.x = r.e.x - br.e.x;
    r.e.y = r.e.y - br.e.y;
    return r;
  }

  rect element::border_distance(view &v) {
    rect r;
    r.s = ldata->border_width.s + ldata->padding_width.s + ldata->inner_border_width.s + ldata->inner_padding_width.s;
    r.e = ldata->border_width.e + ldata->padding_width.e + ldata->inner_border_width.e + ldata->inner_padding_width.e;
    return r;
  }

  rect element::padding_distance(view &v) {
    rect r;
    r.s = ldata->padding_width.s /*+ ldata->inner_padding_width.s*/;
    r.e = ldata->padding_width.e /*+ ldata->inner_padding_width.e*/;
    return r;
  }

  rect element::rendering_box(view &v, RELATIVE_TO rt) // border_box + outlines
  {
    rect rb = border_box(v, rt);
    rect r  = rb;

    r.s.x += min(0, ldata->margin_width.s.x);
    r.s.y += min(0, ldata->margin_width.s.y);
    r.e.x -= min(0, ldata->margin_width.e.x);
    r.e.y -= min(0, ldata->margin_width.e.y);
    rect zr = r;
    if (c_style->has_outline()) {
      int t = 2 * pixels(v, this, c_style->outline_offset).width() + 30;
      r >>= t;
      t = pixels(v, this, c_style->outline_width).width() + 1;
      r >>= t;
      size shift(pixels(v, this, c_style->outline_shift_x).width(),
                 pixels(v, this, c_style->outline_shift_y).height());
      r >>= shift;
    }
    if (c_style->box_shadow.is_defined())
      for (shadow_def *it = c_style->box_shadow; it; it = it->next) {
        rect tr = rb;

        box_shadow_params params;

        size dim = rb.size();

        params.inner    = it->inset != 0;
        params.distance = pixels(v, this, it->spread, dim).width();
        params.radius   = pixels(v, this, it->radius, dim).width();
        params.offset.x = pixels(v, this, it->offset_x,dim).width();
        params.offset.y = pixels(v, this, it->offset_y, dim).width();
        params.color    = it->color.to_argb();
        params.dim      = rb.size();

        if (params.radius < 0) params.radius = 0;
        if (params.radius + params.distance <= 0) continue;

        tr >>= params.radius;
        tr >>= params.offset;

        r |= tr;
      }

    if (c_style->back_image.clip == clip_margin_box ||
        c_style->fore_image.clip == clip_margin_box)
      r |= margin_box(v, rt);
    if (c_style->display == display_list_item && parent) {
      if (state.rtl()) {
        int marker_width = ldata->margin_width.right();
        if (!marker_width) {
          marker_width = parent->ldata->margin_width.right();
        }
        if (!marker_width) {
          marker_width = parent->ldata->padding_width.right();
        }
        if (!marker_width) { marker_width = ldata->padding_width.right(); }
        if (marker_width < 10) marker_width = 10;
        r.e.x += marker_width;
      } else // ltr
      {
        int marker_width = ldata->margin_width.left();
        if (!marker_width) {
          marker_width = parent->ldata->margin_width.left();
        }
        if (!marker_width) {
          marker_width = parent->ldata->padding_width.left();
        }
        if (!marker_width) { marker_width = ldata->padding_width.left(); }
        if (marker_width < 10) marker_width = 10;
        r.s.x -= marker_width;
      }
    }

    if (style_content) {
      if (helement marker = get_marker()) {
        replace__marker_element(v, marker);
        r |= marker->border_box(v, TO_PARENT) + rb.s;
      }
      if (helement shade = get_shade()) {
        replace__shadow_element(v, shade);
        r |= shade->border_box(v, TO_PARENT) + rb.s;
      }
    }

    /*
    if( deep && (subs.size() < 32))
    {
      outline_functor of;
      do_for_each(of);
      zr >>= of.extra;
    }*/
    r |= zr;

    if (ldata && c_style->transforms) {
      // rect r0 = r;
      affine_mtx_f mtx;
      compute_mtx(v, mtx);

      point p7 = r.pointOf(7);
      point p9 = r.pointOf(9);
      point p1 = r.pointOf(1);
      point p3 = r.pointOf(3);
      mtx.transform(p7);
      mtx.transform(p9);
      mtx.transform(p1);
      mtx.transform(p3);
      r |= p7;
      r |= p9;
      r |= p1;
      r |= p3;
      // dbg_printf("rendering box xr=%d,%d %d,%d zr=%d,%d %d,%d \n", xr.left(),
      // xr.top(),
      //                                                             xr.right(),
      //                                                             xr.bottom(),
      //                                                             r0.left(),
      //                                                             r0.top(),
      //                                                             r0.right(),
      //                                                             r0.bottom());
      r >>= 2;
    }
    return r;
  }

  rect element::outline_box(view &v, RELATIVE_TO rt) // border_box + outlines
  {
    rect rb = border_box(v, rt);
    rect r = rb;
    rect zr = r;
    if (c_style->has_outline()) {
      int t = 2 * pixels(v, this, c_style->outline_offset).width() + 30;
      r >>= t;
      t = pixels(v, this, c_style->outline_width).width() + 1;
      r >>= t;
      size shift(pixels(v, this, c_style->outline_shift_x).width(),
                 pixels(v, this, c_style->outline_shift_y).height());
      r >>= shift;
    }
    if (c_style->box_shadow.is_defined())
      for (shadow_def *it = c_style->box_shadow; it; it = it->next) {
        rect tr = rb;

        box_shadow_params params;
        size dim = rb.size();
        params.inner = it->inset != 0;
        params.distance = pixels(v, this, it->spread, dim).width();
        params.radius = pixels(v, this, it->radius, dim).width();
        params.offset.x = pixels(v, this, it->offset_x, dim).width();
        params.offset.y = pixels(v, this, it->offset_y, dim).width();
        params.color = it->color.to_argb();
        params.dim = rb.size();

        if (params.radius < 0) params.radius = 0;
        if (params.radius + params.distance <= 0) continue;

        tr >>= params.radius;
        tr >>= params.offset;

        r |= tr;
      }

    r |= zr;
    if(c_style->is_transparent() || c_style->has_rounded_corners())
      r |= margin_box(v, rt);
    return r;
  }

  rect element::outline_distance(view &v)
  {
    rect cb = content_box(v);
    rect ob = outline_box(v);
    return rect( cb.s - ob.s, ob.e - cb.e );
  }

  rect element::outline_border_distance(view &v)
  {
    rect cb = border_box(v);
    rect ob = outline_box(v);
    return rect(cb.s - ob.s, ob.e - cb.e);
  }

  /*void element::set_popup_attachment(uint a) {
    flags.popup_attachment = a;
  }

  rect element::popup_margin_box(view &v, RELATIVE_TO rt) {
    rect mb = outline_box(v, rt);
    if (c_style->is_transparent())
      mb |= margin_box(v, rt);
    rect r;
    switch (flags.popup_attachment) {
      case 3: r.s.x = mb.left(); break;
      case 0: r.s.y = mb.top(); break;
      case 1: r.e.x = mb.right(); break;
      case 2: r.e.y = mb.bottom(); break;
    }
    return r;
  }

  rect element::popup_margin_border_distance(view &v)
  {
    rect bb = border_box(v);
    rect ob = popup_margin_box(v);
    return rect(bb.s - ob.s, ob.e - bb.e);
  }

  rect element::popup_margin_distance(view &v)
  {
    rect cb = content_box(v);
    rect ob = popup_margin_box(v);
    return rect(cb.s - ob.s, ob.e - cb.e);
  }*/
  
  rect clip_rect(view &v, element *b);

  rect element::background_clip_box(view &v, RELATIVE_TO rt) {
    switch (get_style(v)->back_image.clip) {
    case clip_content_box: return client_rect(v) + content_box(v, rt).s;
    case clip_padding_box: return padding_box(v, rt);
    case clip_margin_box: return margin_box(v, rt);
    default: return border_box(v, rt);
    }
  }
  rect element::foreground_clip_box(view &v, RELATIVE_TO rt) {
    switch (get_style(v)->fore_image.clip) {
    case clip_content_box: return client_rect(v) + content_box(v, rt).s;
    case clip_padding_box: return padding_box(v, rt);
    case clip_margin_box: return margin_box(v, rt);
    case clip_hit_margin_box: return hit_box(v, rt);
    default: return border_box(v, rt);
    }
  }

  rect element::foreground_image_box(view &v, RELATIVE_TO rt) {
    if (!ldata) return rect();
    return ldata->foreground_box + content_box(v, rt).s;
  }

  rect element::hit_box(view &v, RELATIVE_TO rt) // border_box + outlines
  {
    rect r  = border_box(v, rt);
    rect zr = r;
    if (c_style->has_outline()) {
      int t = 2 * pixels(v, this, c_style->outline_offset).width() + 1;
      r >>= t;
      t = pixels(v, this, c_style->outline_width).width() + 1;
      r >>= t;
      size shift(pixels(v, this, c_style->outline_shift_x).width(),
                 pixels(v, this, c_style->outline_shift_y).height());
      r += shift;
      r |= zr;
    }

    if (c_style->hit_margin[0].is_defined() ||
        c_style->hit_margin[1].is_defined() ||
        c_style->hit_margin[2].is_defined() ||
        c_style->hit_margin[3].is_defined()) {
      rect hr = zr;
      hr.s.x -= pixels(v, this, c_style->hit_margin[0]).width();
      hr.s.y -= pixels(v, this, c_style->hit_margin[1]).height();
      hr.e.x += pixels(v, this, c_style->hit_margin[2]).width();
      hr.e.y += pixels(v, this, c_style->hit_margin[3]).height();
      r = hr;
    }

    if (element* marker = get_marker())
      r |= marker->hit_box(v, TO_PARENT) + content_box(v, rt).s;
    if (element* shade = get_shade())
      r |= shade->hit_box(v, TO_PARENT) + content_box(v, rt).s;

    return r;
  }

  element* element::w3_offset_parent(view &v) {
    for (element* p = parent; p; p = p->layout_parent(v)) {
      if (p->positioned(v)) return p;
      if (p->is_table_cell()) return p;
      if (p->is_table()) return p;
      if (p->is_document()) return p;
    }
    return v.root();
  }

  pointf  element::w3_offset_origin(view &v) {
    if(!is_layout_valid())
      v.commit_update(); // sigh
    sizef pos = size(border_box(v,TO_VIEW).s);
    if (element* ofp = w3_offset_parent(v))
      pos -= sizef(ofp->padding_box(v, TO_VIEW).s);
    return v.ppx_to_px(pos);
  }

  sizef  element::w3_offset_size(view &v) {
    if (!is_layout_valid())
      v.commit_update(); // sigh
    sizef sz = border_box(v, TO_VIEW).size();
    return v.ppx_to_px(sz);
  }

  sizef  element::w3_client_size(view &v) {
    if (!is_layout_valid())
      v.commit_update();
    sizef  sz = client_box(v).size();
    return v.ppx_to_px(sz);
  }

  pointf  element::w3_client_origin(view &v) {
    if (!is_layout_valid())
      v.commit_update();
    sizef  pt = size(ldata->border_width.s);
    return v.ppx_to_px(pt);
  }

  pointf element::w3_scroll_position(view &v) {
    if (!is_layout_valid())
      v.commit_update();
    pointf sp = scroll_pos();
    return v.ppx_to_dip(sp);
  }

  void element::w3_scroll_position(view &v, pointf sp) {
    point dsp = pointf(v.pixels_per_dip(sizef(sp)));
    return scroll_pos(v,dsp);
  }

  sizef element::w3_scroll_size(view &v) {
    if (!is_layout_valid())
      v.commit_update();

    scroll_data sd;
    get_scroll_data(v, sd);

    sizef sz = sd.content_outline.size();
    return v.ppx_to_dip(sz);
  }


  bool element::no_pixels_behind(view &v) // true if it and all its parents are transparent
  {
    for (element* p = this; p; p = p->parent)
      if (p->get_style(v)->has_background_color()) return false;
    return true;
  }

  bool parent_get_var(const element_context& ctx, element* p, name_or_symbol nm, value& v) {
    if (p->vars.get(nm, v)) return true;
    if (p->get_style(*ctx.pview(),ctx.pdoc())->vars.get(nm, v)) return true;
    if (p = p->get_owner())
      return parent_get_var(ctx,p,nm, v);
    return false;
  }

  bool element::get_var(const element_context& ctx,name_or_symbol nm, value& v, const style* ps) const {
    if (vars.get(nm, v)) return true;
    if (ps && ps->vars.get(nm, v)) return true;
    if (c_style->vars.get(nm, v)) return true;
    if (element* p = get_owner())
      return parent_get_var(ctx,p,nm,v);
    return false;
  }

  /*bool element::get_color_var(name_or_symbol nm, color_v& v, const style* ps) const {
    value val;
    if (get_var(nm, val, ps) && val.is_color()) {
      v = val;
      return true;
    }
    return false;
  }
  bool element::get_length_var(name_or_symbol nm, size_v& v, const style* ps) const {
    value val;
    if (get_var(nm, val, ps) && val.is_length()) {
      v = val;
      return true;
    }
    return false;
  }*/

  sizef element::pixels_per_dip() {
    view *pv = pview();
    if (!pv) return sizef(1, 1);
    return pixels_per_dip(*pv);
  }

  sizef element::pixels_per_dip(view &v) {
    // iwindow* pw = this->get_window(v, true);
    // if (!pw) return sizef(1, 1);
    sizef one(1, 1);
    // return pw->pixels_per_dip(one);
    return v.pixels_per_dip(one);
  }

  bool element::is_inside(view &v, point viewpt) {
    element *t = v.find_element(viewpt);
    if (!t) return false;
    return t->belongs_to(this, true);
  }

  bool element::is_on_icon(view &v, point pos) {
    rect iconr = ldata->foreground_box;
     if(iconr.empty())
      return false;
    size_v oneem(1.2, size_v::unit_type::em);
    int oneem_px = pixels(v, this, oneem).width();
    rect rem(size(oneem_px, oneem_px));
    rem.pointOf(5,iconr.pointOf(5));
    iconr |= rem;
    return iconr.contains(pos);
    //return ldata ? ldata->foreground_box.contains(pos) : false;
  }

  rect element::image_z_box(view &v, const style::image_def &imd) {
    rect   rcimg;
    himage back_image = // imd.id.img();
        provide_fore_image(v);
    if (back_image.is_null()) return rcimg;

    image *pimg = back_image;

    int  mode   = int(imd.repeat);
    rect rcback = padding_box(v);
    size dim    = rcback.size();

    /*rcback <<= rect(imd.offset[0].pixels_width(v, this, dim.x),
                    imd.offset[1].pixels_height(v, this, dim.y),
                    imd.offset[2].pixels_width(v, this, dim.x),
                    imd.offset[3].pixels_height(v, this, dim.y));*/

    rcimg = rcback;

    if (imd.attachment) { rcback = rect(point(0, 0), v.dimension()); }
    rect rclip = rcimg;
    if (tag == tag::T_HTML || tag == tag::T_BODY)
      rclip = rect(point(0, 0), v.dimension());

    size ipsize = pimg->dim();

    while (!imd.dim[0].undefined_or_auto() || !imd.dim[1].undefined_or_auto()) {
      float ratio = (ipsize.y == 0) ? 1.0f : float(ipsize.x) / float(ipsize.y);

      if (imd.dim[0].is_literal(size_v::special_values::$cover)) {
        float rcratio = (rclip.height() == 0)
                            ? 1.0f
                            : float(rclip.width()) / float(rclip.height());
        if (ratio > rcratio) {
          ipsize.y = rclip.height();
          ipsize.x = int(ipsize.y * ratio + 0.5f);
        } else {
          ipsize.x = rclip.width();
          ipsize.y = int(ipsize.x / ratio + 0.5f);
        }
        break;
      } else if (imd.dim[0].is_literal(size_v::special_values::$contain)) {
        float rcratio = (rclip.height() == 0)
                            ? 1.0f
                            : float(rclip.width()) / float(rclip.height());
        if (ratio > rcratio) {
          ipsize.x = rclip.width();
          ipsize.y = int(ipsize.x / ratio + 0.5f);
        } else {
          ipsize.y = rclip.height();
          ipsize.x = int(ipsize.y * ratio + 0.5f);
        }
        break;
      }

      if (imd.dim[0].is_ui_scale())
        ipsize.x = (ipsize.x * v.pixels_per_inch().x) / 96;
      else if (imd.dim[0].is_defined() && !imd.dim[0].is_auto() && !imd.dim[0].is_spring())
        ipsize.x = html::pixels(v, this, imd.dim[0]).width();

      if (imd.dim[1].is_ui_scale())
        ipsize.y = (ipsize.y * v.pixels_per_inch().y) / 96;
      else if (imd.dim[1].is_defined() && !imd.dim[1].is_auto() && !imd.dim[1].is_spring())
        ipsize.y = pixels(v, this, imd.dim[1]).height();

      // if( imd.dim[0].undefined_or_auto() && imd.dim[1].undefined_or_auto() )
      //  /*use existing ipsize*/;
      // else
      if (imd.dim[0].undefined_or_auto())
        ipsize.x = int(ipsize.y * ratio + 0.5f);
      else if (imd.dim[1].undefined_or_auto())
        ipsize.y = int(ipsize.x / ratio + 0.5f);

      break;
    }

    point org;
    point cor;

    if (imd.margin[0].is_defined() && imd.margin[2].undefined_or_auto()) {
      /*if (imd.margin[0].is_percent()) {
        int percent = imd.margin[0].percent();
        int xi      = (ipsize.x * percent) / 100;
        int xw      = (rcback.width() * percent) / 100;
        org.x       = xw - xi;
      } else
        org.x = imd.margin[0].pixels_width(v, this, 0);*/
      org.x = image_position_pixels(v, this, imd.margin[0], rcback.size(), ipsize).width();

    }
    else if (imd.margin[0].undefined_or_auto() && imd.margin[2].is_defined())
    {
      /*if (imd.margin[2].is_percent()) {
        int percent = imd.margin[2].percent();
        int xi      = (ipsize.x * percent) / 100;
        int xw      = (rcback.width() * percent) / 100;
        org.x       = rcback.width() - (xw - xi + 1) - ipsize.x;
      } else {
        org.x = rcback.width() - ipsize.x - imd.margin[2].pixels_width(v, this, 0);
      }*/
      org.x = rcback.width() - image_position_pixels(v, this, imd.margin[2], rcback.size(), ipsize).width();
    }
    else if (!imd.margin[0].undefined_or_auto() && !imd.margin[2].undefined_or_auto()) // both margins are defined
    {
      /*if (imd.margin[0].is_percent()) {
        int percent = imd.margin[0].percent();
        int xw      = (rcback.width() * percent) / 100;
        org.x       = xw;
      } else
        org.x = imd.margin[0].pixels_width(v, this, 0);

      if (imd.margin[2].is_percent()) {
        int percent = imd.margin[2].percent();
        int xw      = (rcback.width() * percent) / 100;
        cor.x       = xw;
      } else {
        cor.x = imd.margin[2].pixels_width(v, this, 0);
      }*/
      org.x = image_position_pixels(v, this, imd.margin[0], rcback.size(), ipsize).width();
      cor.x = image_position_pixels(v, this, imd.margin[2], rcback.size(), ipsize).width();
    }

    if (imd.margin[1].is_defined() && imd.margin[3].undefined_or_auto()) {
      /*if (imd.margin[1].is_percent()) {
        int percent = imd.margin[1].percent();
        int yi      = (ipsize.y * percent) / 100;
        int yw      = (rcback.height() * percent) / 100;
        org.y       = yw - yi;
      } else
        org.y = imd.margin[1].pixels_height(v, this, 0);*/
      org.y = image_position_pixels(v, this, imd.margin[1], rcback.size(), ipsize).height();
    }
    else if (imd.margin[1].undefined_or_auto() && imd.margin[3].is_defined()) {
      /*if (imd.margin[3].is_percent()) {
        int percent = imd.margin[3].percent();
        int yi      = (ipsize.y * percent) / 100;
        int yw      = (rcback.height() * percent) / 100;
        org.y       = rcimg.height() - (yw - yi + 1) - ipsize.y;
      } else {
        org.y = rcback.height() - ipsize.y -
                imd.margin[3].pixels_height(v, this, 0);
      }*/
      org.y = rcback.height() - image_position_pixels(v, this, imd.margin[3], rcback.size(), ipsize).height();
    }
    else if (!imd.margin[1].undefined_or_auto() && !imd.margin[3].undefined_or_auto()) // both margins are defined
    {
      /*if (imd.margin[1].is_percent()) {
        int percent = imd.margin[1].percent();
        int yw      = (rcback.height() * percent) / 100;
        org.y       = yw;
      } else
        org.y = imd.margin[1].pixels_height(v, this, 0);

      if (imd.margin[3].is_percent()) {
        int percent = imd.margin[3].percent();
        int yw      = (rcback.height() * percent) / 100;
        cor.y       = yw;
      } else {
        cor.y = imd.margin[3].pixels_height(v, this, 0);
      }*/
      org.y = image_position_pixels(v, this, imd.margin[1], rcback.size(), ipsize).height();
      cor.y = image_position_pixels(v, this, imd.margin[3], rcback.size(), ipsize).height();
    }

    org += rcback.s - rcimg.s;

    switch (mode & 0xF) {
    case background_repeat: break;
    case background_no_repeat:
      rcimg.e.y = rcimg.s.y + ipsize.y;
      rcimg.e.x = rcimg.s.x + ipsize.x;
      rcimg += org;
      if (imd.attachment) rcimg = rclip & rcimg;
      break;
    case background_repeat_x:
      rcimg.e.y = rcimg.s.y + ipsize.y;
      rcimg.s.y += org.y;
      rcimg.e.y += org.y;
      org.y = 0;
      rcimg = rcimg & rcback;
      break;
    case background_repeat_y:
      rcimg.e.x = rcimg.s.x + ipsize.x;
      rcimg.s.x += org.x;
      rcimg.e.x += org.x;
      org.x = 0;
      rcimg = rcimg & rcback;
      break;
    case background_stretch:
    case background_expand:
    default: break;
    }
    return rcimg;
  }

  bool styles_are_different(const style *s1, const style *s2) {
    if (s1 == s2) return false;
    // --------- if (!s1->unique && !s2->unique) return true;
    // --------- one of styles is unique
    return *s1 != *s2;
  }

  bool shall_contain_text_at_start(element *el) {
    if (tag::content_model(el->tag) == tag::CMODEL_INLINES) return true;
    switch (el->tag) {
    case tag::T_BODY:
    case tag::T_DIV:
    case tag::T_LI:
    case tag::T_DT:
    case tag::T_DD:
    case tag::T_TD:
    case tag::T_TH:
    case tag::T_PRE: return true;
    default: return false;
    }
  }

  inline void expand_display_contents(view &v, slice<hnode> in, array<hnode> &out) {
    for (hnode n : in) {
      if (!n->is_element())
        out.push(n);
      else {
        helement el = n.ptr_of<element>();
        if (el->get_style(v)->display == display_contents)
          expand_display_contents(v, el->nodes(), out);
        else
          out.push(el);
      }
    }
  }

  static slice<hnode> get_inlines(view& v, slice<hnode> seq) {
    slice<hnode> r = seq;
    r.length = 0;
    uint n = 0;
    for (; n < seq.length; ++n) {
      node *pn = seq[n];
      if (pn->is_comment()) { r.length = n + 1; continue; }
      if (pn->is_text()) { r.length = n + 1; continue; }
      if (pn->cast<element>()->is_inline_element(v)) { r.length = n + 1; continue; }
      break;
    }
    return r;
  }

  slice<hnode> element::get_nodes(view &v, array<hnode> &buf)
  {
/*#ifdef DEBUG
    if (is_id_test())
      this->tag = this->tag;
#endif*/

    if (state.content_editable() && shall_contain_text_at_start(this) && !flags.is_synthetic) {
      if (nodes.size() == 0 ) {
        //this->dbg_report("appending text node");
        text *pt = new text(wchars(WCHARS("")));
        this->append(pt);
      }
      else if (get_inlines(v,nodes()).length == 0 ) /*!nodes.first()->is_text()*/
      {
        //this->dbg_report("prepending text node");
        text *pt = new text(wchars(WCHARS(" ")));
        this->insert(0,pt);
      }
    }

    if (style_content) {
      if (style_content->before) {
        style_content->before->parent = this;
        style_content->before->owner = this;
        buf.push(style_content->before.ptr());
      }

      if (style_content->content) {
        style_content->content->parent = this;
        style_content->content->owner = this;
        buf.push(style_content->content);
      }
      else
        //buf.push(nodes());
        expand_display_contents(v, nodes(), buf);

      if (style_content->after) {
        style_content->after->parent = this;
        style_content->after->owner = this;
        buf.push(style_content->after.ptr());
      }
    } else
      expand_display_contents(v, nodes(), buf);

    return buf();

#if 0

    hstyle st = get_style(v);

    ustring text_before;

    switch( tag )
    {
      case tag::T_OPTGROUP:
        atts.get(attr::a_label,text_before);
        break;
    }

    if( st->after || st->before || st->content.length() || text_before.length() )
    {
       if( st->before )
       {
          helement anonymous_text_block = v.get_anonymous_para(tag::T_BEFORE);
          anonymous_text_block->parent = this;
          anonymous_text_block->owner = this;
          if(st->before->content.length())
          {
            text* tn = new text(st->before->content);
            anonymous_text_block->append(tn);
          }
          buf.push(anonymous_text_block.ptr());
       }
       if( text_before.length() )
       {
          helement anonymous_text_block = v.get_anonymous_para(tag::T_CAPTION);
          anonymous_text_block->parent = this;
          anonymous_text_block->owner = this;
          text* tn = new text(text_before);
          anonymous_text_block->append(tn);
          buf.push(anonymous_text_block.ptr());
       }

       if(st->content.length())
       {
          text* tn = new text(st->content);
          tn->parent = this;
          tn->owner = this;
          buf.push(tn);
          /*helement anonymous_text_block = v.get_anonymous_para(tag::T_TEXT);
          anonymous_text_block->parent = anonymous_text_block->owner = this;
          if(st->content.length())
          {
            text* tn = new text(st->content);
            anonymous_text_block->append(tn);
          }
          buf.push(anonymous_text_block.ptr());*/
       }
       else
         buf.push(nodes());
       if( st->after )
       {
          helement anonymous_text_block = v.get_anonymous_para(tag::T_AFTER);
          anonymous_text_block->parent = this;
          anonymous_text_block->owner = this;
          if(st->after->content.length())
          {
            text* tn = new text(st->after->content);
            anonymous_text_block->append(tn);
          }
          buf.push(anonymous_text_block.ptr());
       }
       return buf();
    }

    return nodes();
#endif
  }

  void element::check_states() {
    // check test-cases/input/select-tree-model.htm after changing anything
    // below:
    if (!flags.state_initialized)
    {
      if(tag == tag::T_OPTION) {
        bool is_node = has_children_of_type(tag::T_OPTION) || atts.exist(attr::a_expanded) || atts.exist(attr::a_collapsed);
        if (is_node) {
          if (!state.node())
            state.collapsed(true);
        }
        else
          state -= (S_EXPANDED | S_COLLAPSED);
      }
      state.disabled(atts.get_bool(attr::a_disabled,false));
      state.readonly(atts.get_bool(attr::a_readonly,false));
      state.checked(atts.get_bool(attr::a_checked,false));
      if (atts.exist(attr::a_expanded)) {
        if(atts.get_bool(attr::a_expanded,false))
          state.expanded(true);
        else
          state.collapsed(true);
      }

      if (tag::type(tag) != tag::INFO_TAG) {
        ustring href = atts.get_ustring(attr::a_href);
        state.link(href.is_defined());
      }


      flags.state_initialized = 1;
    }
  }

#ifdef _DEBUG
  extern int _total_new;
  extern int _total_reused;
#endif

  inline ustring produce_content(view &v, element *el, const value &cont) {
    if (cont.is_string())
      return cont.get(W(""));
    else if (cont.is_function(WCHARS("attr"))) {
      auto func = cont.get_function();
      if (func->params.size() == 1 && func->params.value(0).is_string()) {
        string attr_name = func->params.value(0).to_string();
        if (el->tag == tag::T__AFTER || el->tag == tag::T__BEFORE || el->tag == tag::T__MARKER)
          el = el->get_owner();
        return el->atts.get_ustring(attr_name);
      }
      else
        return cont.to_string();
    }
    else if (cont.is_function(WCHARS("parent-attr")) && el->parent) {
      if (el->tag == tag::T__AFTER || el->tag == tag::T__BEFORE || el->tag == tag::T__MARKER)
        el = el->get_owner();
      auto func = cont.get_function();
      if (el && func->params.size() == 1 && func->params.value(0).is_string()) {
        string attr_name = func->params.value(0).to_string();
        return el->parent->atts.get_ustring(attr_name);
      }
      else
        return cont.to_string();
    }
#if defined(SCITER)
    else if (cont.is_function(WCHARS("prop"))) {
      auto func = cont.get_function();
      if (func->params.size() == 1 && func->params.value(0).is_string()) {
        ustring prop_name = func->params.value(0).to_string();
        ustring prop_val;
        if (el->is_css_element() && el->parent)
          el = el->parent;
        if (v.get_element_property(el, prop_name, prop_val))
          return prop_val;
      }
      return cont.to_string();
    }
    else if (cont.is_function(WCHARS("parent-prop")) && el->parent) {
      if (el->tag == tag::T__AFTER || el->tag == tag::T__BEFORE || el->tag == tag::T__MARKER)
        el = el->get_owner();
      auto func = cont.get_function();
      if (el && func->params.size() == 1 && func->params.value(0).is_string()) {
        ustring prop_name = func->params.value(0).to_string();
        ustring prop_val;
        if (v.get_element_property(el->parent, prop_name, prop_val))
          return prop_val;
      }
      return cont.to_string();
    }
#endif

    return ustring();
  }


  style *element::determine_style(view &v, document *d, bool call_on_changed, bool no_cache) {
    helement holder = this;

    if (flags.strayed)
      return null_style;

    flags.in_determine_style = 1;
    ON_SCOPE_EXIT(flags.in_determine_style = 0);

    if (!flags.state_initialized)
      check_states();

    assert(c_style == null_style);
    if (parent)
    {
      if( is_document() )
        parent->get_style(v, parent->doc());
      else
        parent->get_style(v, d);

      if (d_style != null_style) // may happen if parent->get_style(v) caused
                                 // this style to be determined
        return d_style;

      if (parent->state.ltr())
        state.ltr(true);
      else if (parent->state.rtl())
        state.rtl(true);

      if (parent->state.content_editable())
        state.content_editable(true);

      //flags.svg_context = is_svg_element() || parent->flags.svg_context;

      // WRONG: else if (parent->state.content_non_editable()) - that one is not inheritable - prevents editors to work on popups.
      //  state.content_non_editable(true);
    }

    bool was_incomplete = state.incomplete();


    style *pns = no_cache ? nullptr : get_similar_style(v);
    if (pns) {
#ifdef _DEBUG
      ++_total_reused;
#endif
      c_style = d_style = pns;
    } else {
#ifdef _DEBUG
      ++_total_new;
#endif
      if (!d) return c_style;

      // if element has assigned_style (styles set programmatically) so it is
      // highly probable that it a) is unique and b) will change dynamicaly. So
      // I am not placing it into the shared table

#if 0
      if (a_style) {
        if (!d_style->unique)
          d_style = style::create_unique();
        else
          *d_style = *null_style;
        hstyle ps = d_style;
        resolve_style(v, d, ps);
      }
      else
      {
        d_style = resolve_style(v, d);
      }
#endif
      resolve_style(v, d);
    }


    if (d->is_document_fragment()) return c_style = d_style;

    bool changed = false;

    if (p_style->display != d_style->display) { changed = true; drop_layout(); }
    if (p_style->flow != d_style->flow) { changed = true; drop_layout(); }

#if 0
    if (a_style)
      apply_a_style(v, d, false);

    if (animator) {
      c_style = style::create_unique();
      *c_style = *d_style;
      c_style->animated = true;
      animator->update_style(v, this, *c_style);
    }
    else
      c_style = d_style;
#endif

    hstyle _p_style = p_style;
    hstyle _c_style = c_style;
    hstyle _d_style = d_style;

    if (!c_style->collapsed() || state.popup() /*is_visible(v)*/)
      c_style->fetch_images(v, d ? d : doc());

    if(style_content)
      set_style_generated_content(v, d_style);

    if (changed
    || (was_incomplete != state.incomplete())
    || styles_are_different(p_style, d_style))
    {
      if (call_on_changed) on_style_changed(v, d);
    }

    return d_style;
  }

  style *element::apply_a_style(view &v, document *d, bool call_on_changed)
  {
    if (!d_style->unique) {
      hstyle hs = style::create_unique();
      *hs = *d_style;
      d_style = hs;
    }
    if (a_style) {
      /*if (a_style->font_size.is_defined() && !a_style->font_size.is_points()) {
        size_v parent_font_size = (parent ? parent->get_style(v) : v.get_default_style())->font_size;
        a_style->font_size.resolve(v, parent_font_size);
      }*/
      //d_style->inherit(a_style);
      a_style->apply_to(element_context(v,d,this), *d_style, style::INHERIT_ALL,false);
    }

    if (call_on_changed)
      on_style_changed(v, d);
    else
      c_style = d_style;
    return d_style;
  }

  void element::update_a_style(view &v, document *d, const function<bool(style_prop_map& s)>& updater, bool to_remove)
  {
    STYLE_CHANGE_TYPE utn = {};

    //refresh(v); -- drop_style(v) does this

    if (to_remove) {
      if (!a_style)
        return;
      if (!updater(*a_style))
        return;
      utn = a_style->changes();
    }
    else {
      if (!a_style)
        a_style = new style_prop_map();
      if (!updater(*a_style))
        return;
      utn = a_style->changes();
    }
    //-- apply_a_style(v, d, utn != 0); - bad idea - it will break get_style() cases
    drop_style(&v);
    v.add_to_update(this, utn);
  }

  style *element::get_similar_style(view &v) {
    if (!parent) return 0;
    if (!tag || flags.is_synthetic) return 0; // artificial element

    element *nb = parent->similar_neighbour(this);
    if (!nb) return 0;
    if (nb->tag != tag) return 0;
    if (nb->layout_type() != layout_type()) return 0;
    if (nb->c_style == null_style) return 0;
    if (a_style || nb->a_style) return 0;
    if (animator || nb->animator) return 0;
    if (!nb->state.similar(state)) return 0;
    if (nb->flags.disable_fast_css_match) return 0;
    if (behavior || nb->behavior) return 0;
    if (atts != nb->atts) return 0;
    if (nb->c_style->unique) return 0;
    return nb->c_style;
  }

  style *element::get_base_style(view &v) {
    return parent ? parent->get_style(v) : v.get_default_style();
  }

  handle<style_prop_list> parse_style_prop_list(document *pd, const ustring& text);

  /*bool apply_list(style &s, const element *el, slice<hstyle_def> list, bool apply_important)
  {
    bool          has_importants = false;

    for (auto ps : list) {
      if (ps->pseudo_element.val(0) != el->pseudo_element_id()) {
        s.inherited_pseudo_element_ids |= ps->pseudo_element.val(0);
        continue;
      }
      style *importants = ps->pstyle->get_importants(false);
      if (apply_important)
        s.inherit(importants);
      else {
        if (!has_importants) has_importants = importants != 0;
        s.inherit(ps->pstyle);
      }
    }
    return has_importants;
  }*/

  hstyle element::get_style_list(view &v, document *d, style_list& list) {
    hstyle resolved_parent_style = get_base_style(v);

    style_bag &master_bag = html_app()->stock_styles();
    style_bag &sbag = d->styles();

#if DEBUG
    if ( tag == tag::T_HTML)
      d = d;
    //if (tag == tag::T_METER)
    //  d = d;
#endif

    style_prop_list *intrinsic_style = tag::intrinsic_style(tag, d->is_svg_document());

    {
      if (intrinsic_style && intrinsic_style->props.size()) {
        list.add(resolved_parent_style, style::INHERIT_CHAR | style::INHERIT_PARA);
        list.add(intrinsic_style, style::INHERIT_ALL);
      }
      else //if (d != this)
        list.add(resolved_parent_style, style::INHERIT_CHAR | style::INHERIT_PARA);
    }

    if (is_document_fragment())
      return resolved_parent_style;

    if (handle<style_prop_list> pl = apply_attributes(v, d))
      list.add(pl, style::INHERIT_ALL);

    // get list of rules from master css and style_set name
    master_bag.rules_for(this, d, list);

    // apply style sets

    string master_style_set = list.style_set;
    string master_style_set_base = list.style_set_base;

    // get document's styles in separate list ( they will be appended later )

    style_list sbag_list; sbag_list.style_set = list.style_set;

    // "SSX" feature: apply forced style set if any
    const style_set_holder* pssh = forced_style_set();
    if (pssh && !pssh->important)
      sbag.forced_style_set_rules_for(this, d, pssh, sbag_list);

    // get list of rules from doc css and style_set name
    sbag.rules_for(this, d, sbag_list);

    string sbag_style_set = sbag_list.style_set;
    // if we have doc_style_bag apply it on top of normal styles
    if (sbag_style_set.is_defined())
      sbag.style_set_rules_for(this, d, sbag_list, sbag_style_set);

    if (sbag_list.appearance == appearance_auto)
      sbag_list.appearance = resolved_parent_style->appearance.val();

    // apply master_bag set rules if a) any and b) style-set was not redifend by doc's styles and c) doc's style has no such set
    if (master_style_set.is_defined() && master_style_set == sbag_style_set && (sbag.get_named_set(master_style_set) == nullptr)) {
      if (sbag_list.appearance == appearance_none && master_style_set_base.is_defined())
        master_bag.style_set_rules_for(this, d, list, master_style_set_base);
      else
        master_bag.style_set_rules_for(this, d, list, master_style_set);
    }

    // "SSX" feature: apply forced style set if any
    if (pssh && pssh->important)
      sbag.forced_style_set_rules_for(this, d, pssh, sbag_list);

    list.append(sbag_list);

    // <some style="..."> on top of the above
    if (d->allow_own_styles) {
      ustring styletext = atts.get_ustring(attr::a_style);
      if (styletext.length()) {
        if (handle<style_prop_list> pl = parse_style_prop_list(d, styletext)) {
          list.add(pl, style::INHERIT_ALL);
          if (flags.was_a_style_change) list.has_uniques = true;
        }
      }
    }

    // h) runtime styles on top of everything
    if (a_style) //- will do it on resolve_style level
      list.add(a_style, style::INHERIT_ALL); //s.inherit(a_style);

    return resolved_parent_style;
  }

  inline bool animates_styles(const element* el) {
    auto pa = el->animator;
    while (pa) {
      if (pa->changes_styles())
        return true;
      pa = pa->next;
    }
    return false;
  }

  void element::resolve_style(view &v, document *d)
  {
    style_list list;
    hstyle resolved_parent_style = get_style_list(v, d, list);

    style ps;

    element_context ctx(v, d, this, &ps);

    list.apply_variables(ctx, ps); // variables needs to be collected first
    ps.vars.inherit(this->vars);   // apply variables defined in this element

    list.apply_to(ctx, ps, false);

    // !important stuff:
    if (list.n_importants)
      list.apply_to(ctx, ps, true);

    fixup_style(v, d, ps);

    //if (a_style) -- get_style_list() cares about this
      //  apply_a_style(v, d, false);

    ps.resolve(v, this, *resolved_parent_style);

    if (!ps.unique && !a_style && !list.has_uniques)
      d_style = d->styles().intern_resolved(ps);
    else
      d_style = style::create_unique(&ps);

    if (animates_styles(this)) {
      if(!c_style->unique)
        c_style = style::create_unique();
      *c_style = *d_style;
      c_style->animated = true;
      animator->update_style(v, this, *c_style);
    }
    else
      c_style = d_style;

  }


  void element::resolve_styles(view &v) {
    helement holder = this;
#ifdef _DEBUG
    if (is_id_test())
      holder = holder;
#endif
    get_style(v);
    auto resolve = [&v](element *el) -> bool {
      if (el->c_style == element::null_style) el->resolve_styles(v);
      return false;
    };

    each_child(resolve);
  }

  /*        switch(tag)
    inline bool is_row(view& v, element* el)  {
      //return el->tag == tag::T_TR;
      const style* cs = el->get_style(v);
      if( el->tag == tag::T_TR && cs->display == display_block )
        return true;
      return cs->display == display_table_row;
    }*/

  template <typename T> void rotate_right(T *arr, uint len) {
    T tmp = arr[len - 1];
    for (uint n = len - 1; n > 0; --n)
      arr[n] = arr[n - 1];
    arr[0] = tmp;
  }

  void element::fixup_style(view &v, document *pd, style &s) {
    switch (tag) {
    case tag::T_UL:
    case tag::T_OL:
    case tag::T_DIR:
    case tag::T_MENU:
    case tag::T_DD:
      if (s.direction == direction_rtl && s.padding_width[2].is_undefined() && !s.mapping.u.parts.padding)
        swap(s.padding_width[2], s.padding_width[0]);
      break;

    case tag::T_TBODY:
      s.overflow_x = overflow_none;
      // if(s.overflow_y == overflow_auto)
      //  s.overflow_y = overflow_scroll;
      if (s.display == display_block) s.display = display_table_body;
      break;

    case tag::T_TR:
      if (s.display ==
          display_block) // display:block is used to show hidden rows :(
        s.display = display_table_row;
      break;
    case tag::T_TD:
      if (s.display ==
          display_block) // display:block is used to show hidden cells :(
        s.display = display_table_cell;
      break;
    case tag::T_TABLE:
      if (s.display ==
          display_block) // display:block is used to show hidden tables :(
        s.display = display_table;
      /*if (s.border_collapse == border_collapse) {
        s.padding[0].set_pixels(0);
        s.padding[3] = s.padding[2] = s.padding[1] = s.padding[0];
      }*/
      break;
    case tag::T_THEAD:
    case tag::T_TFOOT:
      if (s.display ==
          display_block) // display:block is used to show hidden tbody :(
        s.display = display_table_body;
      break;
    case tag::T_HTML:
      if (s.overflow_x.is_undefined() && s.overflow_y.is_undefined()) {
        if (!parent) {
          s.overflow_x = overflow_auto;
          s.overflow_y = overflow_auto;
        } else {
          const style *ps = parent->get_style(v);
          if (ps->overflow_x.is_undefined() && ps->overflow_y.is_undefined()) {
            s.overflow_x = overflow_auto;
            s.overflow_y = overflow_auto;
          }
        }
        /*          if (!parent) {
                    s.margin[0] = s.margin[1] = s.margin[2] = s.margin[3] =
           size_v(); s.padding[0] = s.padding[1] = s.padding[2] = s.padding[3] =
           size_v(); s.border_width[0] = s.border_width[1] = s.border_width[2] =
           s.border_width[3] = size_v();
                  }*/
      }
      break;
      /*case tag::T_BODY:
        if (is_empty())
          s.flow = flow_text;
        break;*/

    case tag::T_G:
    case tag::T_PATH:
    case tag::T_RECT:
    case tag::T_CIRCLE:
    case tag::T_ELLIPSE:
    case tag::T_LINE:
    case tag::T_POLYLINE:
    case tag::T_POLYGON:
    case tag::T_SWITCH:
      // case tag::T_RADIALGRADIENT:
      // case tag::T_LINEARGRADIENT:
      // case tag::T_STOP:
      // if(s.display != display_none)
      //  s.display = display_block;
      // s.flow = flow_svg_element;
      break;
    }

    switch (s.mapping.u.parts.border) {
    case mapping_left_to_right:
      swap(s.border_color[0], s.border_color[2]);
      swap(s.border_width[0], s.border_width[2]);
      swap(s.border_style[0], s.border_style[2]);

      swap(s.border_radius[0], s.border_radius[2]);
      swap(s.border_radius[1], s.border_radius[3]);
      swap(s.border_radius[4], s.border_radius[6]);
      swap(s.border_radius[5], s.border_radius[7]);
      break;
    case mapping_top_to_right:
      rotate_right(s.border_color, 4);
      rotate_right(s.border_width, 4);
      rotate_right(s.border_style, 4);
      rotate_right(s.border_style, 4);
      rotate_right(s.border_radius, 8);
      rotate_right(s.border_radius, 8);
      break;
    }
    switch (s.mapping.u.parts.margin) {
    case mapping_left_to_right:
      swap(s.margin[0], s.margin[2]);
      swap(s.hit_margin[0], s.hit_margin[2]);
      break;
    case mapping_top_to_right:
      rotate_right(s.margin, 4);
      rotate_right(s.hit_margin, 4);
      break;
    }
    switch (s.mapping.u.parts.padding) {
      case mapping_left_to_right: swap(s.padding_width[0], s.padding_width[2]); break;
      case mapping_top_to_right: rotate_right(s.padding_width, 4); break;
    }
    switch (s.mapping.u.parts.background_position) {
      case mapping_left_to_right: swap(s.back_image.margin[0], s.back_image.margin[2]); break;
      case mapping_top_to_right: rotate_right(s.back_image.margin, 4); break;
    }
    switch (s.mapping.u.parts.foreground_position) {
    case mapping_left_to_right:
      swap(s.fore_image.margin[0], s.fore_image.margin[2]);
      break;
    case mapping_top_to_right: rotate_right(s.fore_image.margin, 4); break;
    }

    if (s.border_collapse == border_collapse)
      s.border_spacing_x = s.border_spacing_y = size_v(0);

    if (s.margin[0].is_auto()) s.margin[0].set_flex(0.01f);
    if (s.margin[2].is_auto()) s.margin[2].set_flex(0.01f);

  }

  PAV_RESULT parse_attribute_value(document *pd, style_prop_map &sm, cssa::name_or_symbol name, const ustring &v);

  void element::set_style_attribute(cssa::name_or_symbol name, const ustring &v) {
    document *pd = doc();
    assert(pd);
    if (!pd) return;

    view *pv = pd->pview();
    if (!pv) return;

    this->update_a_style(*pv, pd, [&](style_prop_map& s) -> bool
    {
      if (name == CHARS("zoom")) this->drop_layout_tree(pv);
      parse_attribute_value(pd, s, name, v);
      return true;
    });
  }

  void element::remove_style_attributes() {
    if (!a_style)
      return;

    document *pd = doc();

    if (!pd) {
      a_style = 0;
      return;
    }

    STYLE_CHANGE_TYPE ut = a_style->changes();
    view *            pv = pd->pview();
    if (pv && ut) {
      pv->refresh(this);
      a_style = 0;
      pv->add_to_update(this, ut);
      clear_style();
    }
  }

  void element::set_style_attribute(cssa::name_or_symbol name, const value &v) {
    document *pd = doc();
    assert(pd);
    if (!pd) return;

    array<value> avals;
    if (v.is_array_like()) {
      uint n = v.size();
      for (uint i = 0; i < n; ++i) {
        value t = v.get_element(i);
        t.isolate();
        avals.push(t);
      }
    } else {
      value t = v;
      t.isolate();
      avals.push(t);
    }

    view *pv = pd->pview();
    if (!pv)
      return;

    this->update_a_style(*pv, pd, [&](style_prop_map& s)
    {
      if (name == CHARS("zoom")) this->drop_layout_tree(pv);
      return s.set(name, v);
      //return set_attribute_value(pd, s, name, avals());
    });
  }

  void element::remove_style_attribute(cssa::name_or_symbol name) {
    document *pd = doc();
    assert(pd);
    if (!pd) return;

    view *pv = pd->pview();
    if (!pv) return;

    this->update_a_style(*pv, pd, [&](style_prop_map& s) -> bool
    {
      s.set(name, value());
      return true;
    }, true);
  }


  void element::set_style_attributes(const style_prop_list& pl) {
    document *pd = doc();
    assert(pd);
    if (!pd) return;

#ifdef DEBUG
    if (pd == this)
      pd = pd;
#endif

    view *pv = pd->pview();
    if (!pv)
      return;

    this->update_a_style(*pv, pd, [&](style_prop_map& s) -> bool
    {
      bool need_full_reset = false;

      bool changes = false;

      index_t n = pl.props.size();
      while (--n >= 0) {
        const value & val = pl.props[n].val;
        const cssa::symbol_t sym = pl.props[n].sym;
        if (sym == cssa_zoom) need_full_reset = true;
        bool r = s.set(sym, val);
        changes = changes || r;
      }
      if (need_full_reset) this->drop_layout_tree(pv);
      if (s.udt >= CHANGES_DIMENSION) {
        if (element* p = layout_parent(*pv))
          p->drop_layout_tree(pv);
      }
      return changes;
    });
  }



  /*void element::set_style_attributes(const slice<named_value> &bag, style* target) {
    document *pd = doc();
    assert(pd);
    if (!pd) return;

    view *pv = pd->pview();
    if (!pv)
      return;

    this->update_a_style(*pv, pd, [&](style_prop_map& s) -> bool
    {
      index_t n = bag.size();
      bool changes = false;
      while (--n >= 0) {
        const value & val = bag[n].value;
        const string &name = bag[n].name;

        if (val.is_undefined()) clear_attribute_value(*target, name);
        if (val.is_string()) {
          bool r = parse_attribute_value(pd, target, name, val.to_string()) == PAV_OK;
          changes = changes || r;
        }
        else {
          slice<value> vals;
          array<value> avals;
          if (val.is_array_like()) {
            uint n = val.size();
            for (uint i = 0; i < n; ++i)
              avals.push(val.get_element(i));
            vals = avals();
          }
          else
            vals = slice<value>(&val, 1);
          bool r = set_attribute_value(pd, *target, bag[n].name, vals);
          changes = changes || r;
        }
      }
      return changes;
    });

  }*/

#if 0

  // check if attribute ns is used as { content:attr(ns) }
  // and if so call set_style_generated_content()
  void check_used_by_style_content(element *pel, const name_or_symbol &ns, view *pv) {

#ifdef DEBUG
    if (pel->is_id_test())
      pel = pel;
#endif

    auto is_used = [&](const style* ps) -> bool {
      value cont = ps->content;
      if (cont.is_function(WCHARS("attr"))||cont.is_function(WCHARS("parent-attr"))) {
        auto func = cont.get_function();
        if (func->params.size() == 1 && func->params.value(0).is_string()) {
          string attr_name = func->params.value(0).to_string();
          if (attr_name == attr::symbol_name(ns.att_sym))
            return true;
        }
      }
      return false;
    };

    if(pel->style_content) {
      handle<css_content> cc = get_css_content(pel);
      if (!pv) pv = pel->pview();

      if (pv) {
        uint changes = 0;
        if ((pel->c_style->pseudo_elements & PSEUDO_BEFORE) && cc->before) {
          cc->before->set_style_generated_content(*pv, cc->before->get_style(*pv));
          ++changes;
        }

        if ((pel->c_style->pseudo_elements & PSEUDO_AFTER) && cc->after) {
          cc->after->set_style_generated_content(*pv, cc->after->get_style(*pv));
          ++changes;
        }

        if ((pel->c_style->pseudo_elements & PSEUDO_MARKER) && cc->marker) {
          cc->marker->set_style_generated_content(*pv, cc->marker->get_style(*pv));
          ++changes;
        }

        if (is_used(pel->c_style))
        {
          pel->set_style_generated_content(*pv, pel->get_style(*pv));
          ++changes;
        }
        if (changes)
          pv->add_to_update(pel, true);
      }
    }

    each_child it(pel);
    for (element* ch; it(ch);) {
      //ch->get_style(*pv);
      check_used_by_style_content(ch, ns, pv);
    }

  }

  void check_prop_used_by_style_content(view& v, element *pel, wchars name)
  {
    auto is_used = [&](const style* ps) -> bool {
      value cont = ps->content;
      if (cont.is_function(WCHARS("prop"))) {
        auto func = cont.get_function();
        if (func->params.size() == 1 && func->params.value(0).is_string()) {
          ustring prop_name = func->params.value(0).to_string();
          if (prop_name == name)
            return true;
        }
      }
      return false;
    };

    handle<css_content> cc = get_css_content(pel);

    uint changes = 0;
    /*if (pel->c_style->before && is_used(pel->c_style->before) && cc->before) {
      cc->before->set_style_generated_content(v, cc->before->get_style(v));
      ++changes;
    }

    if (pel->c_style->after && is_used(pel->c_style->after) && cc->after) {
      cc->after->set_style_generated_content(v, cc->after->get_style(v));
      ++changes;
    }

    if (pel->c_style->marker && is_used(pel->c_style->marker) && cc->marker) {
      cc->marker->set_style_generated_content(v, cc->marker->get_style(v));
      ++changes;
    }

    if (is_used(pel->c_style))
    {
      pel->set_style_generated_content(v, pel->get_style(v));
      ++changes;
    }*/

    if (changes)
      v.add_to_update(pel, true);


  }

#endif

  bool element::set_states(const attribute_bag_v& other, view* pv, bool skip_value_if_in_focus) {

    html::ui_state to_set; uint n_to_set = 0;
    html::ui_state to_clear; uint n_to_clear = 0;

    tool::value val; uint n_val = 0;
    tool::ustring htm; uint h_val = 0;

    for (int n = other.items.last_index(); n >= 0; --n) {
      auto item = other.items[n];
      string sname = html::attr::symbol_name(item.att_sym);
      value  sval = item.att_value;

      if (sname == CHARS("value")) {
        val = sval;
        ++n_val;
        continue;
      }

      if (sname == CHARS("html")) {
        htm = sval.to_string();
        ++h_val;
        continue;
      }


      html::ui_state st;
      if (!html::parse_state_flag(sname, st))
        continue;
      if (sval.is_undefined() || sval.to_bool() == true)
      {
        to_set += st.data;
        ++n_to_set;
      }
      else {
        if (st.expanded()) {
          to_set += S_COLLAPSED;
          ++n_to_set;
        }
        else {
          to_clear += st.data;
          ++n_to_clear;
        }
      }
    }

    if (!n_to_set && !n_to_clear && !n_val && !h_val)
      return false;

    if (pv && pv->mutator_rq(this, STATES_CHANGED)) {
      if (n_to_set)
        this->state_on(*pv, to_set);
      if (n_to_clear)
        this->state_off(*pv, to_clear);
      if (n_val) {
        tool::value cval;
        if (!this->get_value(*pv, cval, true) || cval != val)
        {
          if (!skip_value_if_in_focus || !this->state.focus()) {
            if (pv && is_connected())
              //this->set_value(*pv, val, true);
              pv->set_element_native_value(this, val, true);
            else
              this->delay_value(val);
          }
        }
      }
      else if (h_val) {
        //set_element_html
        helement self = this;
        flags.ssx_reconciliation = 1; // disable reconciliation
        pv->set_element_html(self, htm(), SE_TYPE::SE_REPLACE);
      }
    }
    else {
      if (n_to_set) {
        if (!state.current() && to_set.current()) {
          if (!pv) pv = pview();
          if (pv) {
            event_behavior evt(this, this, CURRENT_ELEMENT_CHANGED, 0);
            pv->post_behavior_event(evt, true);
          }
        }
        this->state += to_set.data;
        this->flags.state_initialized = true;
      }
      if (n_to_clear) {
        this->state -= to_clear.data;
        this->flags.state_initialized = true;
      }
      if (n_val) {
        if (!skip_value_if_in_focus || !this->state.focus()) {
          if(pv && is_connected())
            //this->set_value(*pv, val, true);
            pv->set_element_native_value(this, val, true);
          else
            this->delay_value(val);
        }
      }
      else if (h_val) {
        if (!pv) pv = pview();
        if (pv) {
          //set_element_html
          helement self = this;
          flags.ssx_reconciliation = 1; // disable reconciliation
          pv->set_element_html(self, htm(), SE_TYPE::SE_REPLACE);
        }
      }

    }
    return n_to_set || n_to_clear || n_val || h_val;
  }


  bool element::set_attributes(const attribute_bag& other, view* pv, bool allow_change_id) {

    bool r = false;

    for (int n = atts.items.last_index(); n >= 0; --n) {
      auto item = atts.items[n];
      //dbg_printf("att 1 %s\n", attr::symbol_name(item.att_sym).c_str());
      if (!other.exist(item.att_sym)) {
        if (item.att_sym == attr::a_id && !allow_change_id)
          continue;
        if (remove_attr(item.att_sym, pv))
          r = true;
      }
    }

    for (int n = other.items.last_index(); n >= 0 ; --n) {
      auto item = other.items[n];
      //dbg_printf("att 2 %s\n", attr::symbol_name(item.att_sym).c_str());
      if (item.att_sym == attr::a_id && !allow_change_id)
        continue;
      if (set_attr(item.att_sym, item.att_value, pv))
        r = true;
    }
    return r;
  }

  bool element::set_attr(const name_or_symbol &ns, const ustring &val, view* pv) {

#ifdef DEBUG
    /*if (is_id_test()) {
      element* pfe = this->first_element();
      const style* cs = pfe->d_style;
      pfe->dbg_report("!");
      pfe = pfe;
    }*/
#endif

    if (!atts.set(ns, val)) return false;
    if (!is_connected()) return true;
    bool r = on_set_attr(ns.att_sym, val);
    bool rem = false;

    //if(style_content)
    //check_used_by_style_content(this, ns, pv); // NOTE: check_used_by_style_content() check shall come first in order to update style_content->content properly

    if (is_sensitive_attr(ns, rem))
    {
      if (!pv || pv->mutator_rq(this, ATTRIBUTES_CHANGED))
      {
        if (!pv) pv = pview();
        if (pv) {
          helement b = nearest_box();
#if 1
          pv->refresh(b);
          if (rem)
            this->drop_layout_tree(pv,true);
          else
            this->drop_styles(*pv);
          pv->add_to_update(b, rem ? CHANGES_MODEL : CHANGES_VISUAL);

          element* nsb = next_element();
          if (nsb && (nsb->c_style != null_style)) {
            nsb->drop_styles(*pv);
            //nsb->get_style_no_cache(*pv);
          }
#else
          pv->drop_styles(b);
          if (element* nsb = next_element())
            pv->drop_styles(nsb);
#endif
        }
      }
    }
    if (pv)
      notify_attribute_change(*pv, ns);
    return r;
  }

  bool element::set_attr(view &v, const name_or_symbol &ns, const ustring &val) {
    if (!atts.set(ns, val)) return false;
    if (!is_connected()) return true;
    bool r = on_set_attr(ns.att_sym, val);
    bool rem = false;
    //check_used_by_style_content(this, ns, &v); // NOTE: check_used_by_style_content() check shall come first in order to update style_content->content properly
    if (is_sensitive_attr(ns, rem) ) {
      helement b = nearest_box();
#if 1
      v.refresh(b);
      if (rem)
        this->drop_layout_tree(&v,true);
      else
        this->drop_styles(v);
      v.add_to_update(b, rem ? CHANGES_MODEL : CHANGES_VISUAL);
      element* nsb = next_element();
      if (nsb && (nsb->c_style != null_style)) {
        nsb->drop_styles(v);
        nsb->get_style_no_cache(v);
      }
#else
      v.drop_styles(b);
      if (element* nsb = next_element())
        v.drop_styles(nsb);
#endif
    }

    notify_attribute_change(v, ns);

    return r;
  }

  bool element::remove_attr(const name_or_symbol &ns, view* pv) {
    ustring val = atts(ns);
    if (!atts.remove(ns)) return false;
    if (!is_connected()) return true;
    bool      r   = on_remove_attr(ns.att_sym,val);
    bool      rem = false;

    //check_used_by_style_content(this, ns, pv); // NOTE: check_used_by_style_content() check shall come first in order to update style_content->content properly

    if (is_sensitive_attr(ns, rem)) {
      if (!pv || pv->mutator_rq(this, ATTRIBUTES_CHANGED)) {
        if (!pv) pv = pview();
        if (pv) {
          helement b = nearest_box();
#if 1
          pv->refresh(b);
          if (rem)
            this->drop_layout_tree(pv, true);
          else
            this->drop_styles(*pv);
          pv->add_to_update(b, rem ? CHANGES_MODEL : CHANGES_VISUAL);
          element* nsb = next_element();
          if (nsb && (nsb->c_style != null_style)) {
            nsb->drop_styles(*pv);
            nsb->get_style_no_cache(*pv);
          }
#else
          pv->drop_styles(b);
          if (element* nsb = next_element())
            pv->drop_styles(nsb);
#endif
        }
      }
    }

    if (pv)
      notify_attribute_change(*pv, ns);

    return r;
  }

  bool element::remove_attr(view &v, const name_or_symbol &ns) {
    ustring val = atts(ns);
    if (!atts.remove(ns)) return false;
    if (!is_connected()) return true;
    bool      r   = on_remove_attr(ns.att_sym,val);
    bool      rem = false;

    //check_used_by_style_content(this, ns, &v); // NOTE: check_used_by_style_content() check shall come first in order to update style_content->content properly

    if (is_sensitive_attr(ns, rem)) {
      helement b = nearest_box();
#if 1
      v.refresh(b);
      if (rem)
        this->drop_layout_tree(&v, true);
      else
        this->reset_styles(v);
      v.add_to_update(b, rem ? CHANGES_MODEL : CHANGES_VISUAL);
      element* nsb = next_element();
      if (nsb && (nsb->c_style != null_style)) {
        nsb->drop_styles(v);
        nsb->get_style_no_cache(v);
      }
#else
      v.drop_styles(b);
      if (element* nsb = next_element())
        v.drop_styles(nsb);
#endif
    }
    notify_attribute_change(v, ns);
    return r;
  }

  void element::notify_attribute_change(view &v, const name_or_symbol &nm)
  {
    for(auto bhv = behavior; bhv; bhv = bhv->next)
      bhv->on_attr_change(v, this, nm);
  }

  /*void element::set_class(const ustring& val)
  {
    set_attr(attr::a_class,val);
  }
  bool element::remove_class(const ustring& val)
  {
    if( !atts.remove_class(val) )
      return false;
    view* pv = pview();
    if( pv )
    {
      helement b = nearest_box();
      pv->refresh(b);
      reset_styles(*pv);
    }
    return true;
  }
  bool element::add_class(const ustring& val)
  {
    if( !atts.add_class(val) )
      return false;
    view* pv = pview();
    if( pv )
    {
      helement b = nearest_box();
      pv->refresh(b);
      reset_styles(*pv);
    }
    return true;
  }*/

  static bool boolval(wchars v) { return v != WCHARS("false") && v != WCHARS("no") && v != WCHARS("off"); }

  bool element::on_set_attr(uint att_sym, const ustring &val) {
    switch (att_sym) {
    case attr::a_readonly:
        state.readonly(boolval(val));
        return true;
    case attr::a_disabled:
        state.disabled(boolval(val));
        return true;
    case attr::a_id:
      if (document* pd = doc())
        pd->add_element_id(this, val);
      return true;
    case attr::a_lang:
      if (view* pv = pview()) {
        drop_layout_tree(pv);
        on_lang_change(pv);
      }
      return true;
    case attr::a_theme:
      if (view* pv = pview()) {
        drop_layout_tree(pv);
        on_theme_change(pv);
      }
      return true;

    /*case attr::a_placeholder :
      if (view* pv = pview()) {
        drop_layout_tree(pv);
        pv->add_to_update(this, true);
      }
      return true;*/

    case attr::a_href: {
        ustring href = atts.get_ustring(attr::a_href);
        state.link(href.is_defined());
        return true;
      }

    case attr::a_type: {
       value val;
       if (view* pv = pview()) {
         if (get_value(*pv, val, true)) {
           drop_style();
           get_style(*pv);
           set_value(*pv, val, true);
         }
       }
       return true;
     }

    case attr::a_style:
      flags.was_a_style_change = true;
      return true;
    }

    return false;
  }

  bool element::on_remove_attr(uint att_sym, const ustring &val) {
    switch (att_sym) {
    case attr::a_readonly:
      state.readonly(false);
      return true;
    case attr::a_disabled:
      state.disabled(false);
      return true;
    case attr::a_id:
      if (document* pd = doc())
        pd->remove_element_id(this, val);
      return true;
    case attr::a_href:
      state.link(false);
      return true;
    case attr::a_lang:
      if (view* pv = pview()) {
        drop_layout_tree(pv);
        on_lang_change(pv);
      }
      return true;
    case attr::a_theme:
      if (view* pv = pview()) {
        drop_layout_tree(pv);
        on_theme_change(pv);
      }
      return true;
    }
    return false;
  }

  void element::on_lang_change(view* pv) {
    lang.clear();
    if (!pv) pv = pview();
    if (behavior && pv)
      for (handle<ctl> bhv = behavior; bhv; bhv = bhv->next) bhv->on_lang_change(*pv, this);
    each_child([pv](element* c) -> bool { c->on_lang_change(pv); return false; });
  }
  void element::on_theme_change(view* pv) {
    theme.clear();
    if (!pv) pv = pview();
    if (behavior && pv)
      for (handle<ctl> bhv = behavior; bhv; bhv = bhv->next) bhv->on_theme_change(*pv, this);
    each_child([pv](element* c) -> bool { c->on_theme_change(pv); return false; });
  }


  inline int list_level(const element *b) {
    int level = 0;
    while (b) {
      if (b->tag == tag::T_UL || b->tag == tag::T_OL || b->tag == tag::T_DIR)
        ++level;
      b = b->parent;
    }
    return level;
  }

  element *parent_table(element *el) {
    if (!el) return 0;
    // this shall not force styles/layout
    return (el->tag == tag::T_TABLE) ? el : parent_table(el->parent);
  }

  void apply_svg_attributes(view &v, document *pd, element* el, attribute_bag atts, style_prop_list* s) {
    for (int n = atts.size() - 1; n >= 0; --n) {
      uint    sym;
      ustring val;
      atts.item_at(n, sym, val);
      switch (sym) {
      default: continue;
      case attr::a_fill:
//#ifdef _DEBUG
//        if (el->is_id_test())
//          el = el;
//#endif
        parse_css_property_as( pd, cssa_fill, val, s);
        break;
      case attr::a_fill_opacity:
        parse_css_property_as( pd, cssa_fill_opacity, val, s);
        break;
      case attr::a_fill_rule:
        parse_css_property_as( pd, cssa_fill_rule, val, s);
        break;
      case attr::a_stroke:
        parse_css_property_as( pd, cssa_stroke, val, s);
        break;
      case attr::a_stroke_width:
        parse_css_property_as( pd, cssa_stroke_width, val, s);
        break;
      case attr::a_stroke_linecap:
        parse_css_property_as( pd, cssa_stroke_linecap, val, s);
        break;
      case attr::a_stroke_linejoin:
        parse_css_property_as( pd, cssa_stroke_linejoin, val, s);
        break;
      case attr::a_stroke_miterlimit:
        parse_css_property_as( pd, cssa_stroke_miterlimit, val, s);
        break;
      case attr::a_stroke_dasharray:
        parse_css_property_as(pd, cssa_stroke_dasharray, val, s);
        break;
      case attr::a_stroke_dashoffset:
        parse_css_property_as( pd, cssa_stroke_dashoffset, val, s);
        break;
      case attr::a_stroke_opacity:
        parse_css_property_as( pd, cssa_stroke_opacity, val, s);
        break;
      case attr::a_opacity:
        parse_css_property_as( pd, cssa_opacity, val, s);
        break;
      case attr::a_stop_color:
        parse_css_property_as( pd, cssa_stop_color, val, s);
        break;
      case attr::a_stop_opacity:
        parse_css_property_as( pd, cssa_stop_opacity, val, s);
        break;
      case attr::a_gradienttransform:
        parse_css_property_as( pd, cssa_transform, val, s);
        break;
      case attr::a_transform:
        parse_css_property_as( pd, cssa_transform, val, s);
        break;
      case attr::a_alignment_baseline:
      case attr::a_dominant_baseline:
        {
           wchars v = val;
           // auto | text-bottom | alphabetic | ideographic | middle | central | mathematical | hanging | text-top
           // note: I have no separate prop for that so map
           if (v == WCHARS("auto")) s->set(cssa_vertical_align, valign_ev(valign_auto));
           else if (v == WCHARS("middle")) s->set(cssa_vertical_align, valign_ev(valign_middle));
           else if (v == WCHARS("central")) s->set(cssa_vertical_align, valign_ev(valign_middle));
           else if (v == WCHARS("hanging")) s->set(cssa_vertical_align, valign_ev(valign_text_top));
           else if (v == WCHARS("text-top")) s->set(cssa_vertical_align, valign_ev(valign_text_top));
           else if (v == WCHARS("text-bottom")) s->set(cssa_vertical_align, valign_ev(valign_text_bottom));
           else s->set(cssa_vertical_align, valign_ev(valign_baseline));
        }
        break;

        // case attr::a_marker,
        // case attr::a_marker_start,
        // case attr::a_marker_mid,
        // case attr::a_marker_end,
      }
    }
  }

  handle<style_prop_list> element::apply_attributes(view &v, document *pd) {

    handle<style_prop_list> _spl = nullptr;
    auto spl = [&]() -> style_prop_list* {
      if (!_spl) _spl = new style_prop_list();
      return _spl;
    };

    auto check_align_float = [&]() {
      halign_ev ha = atts.get_align();
      if (ha.is_defined()) {
        if (ha == align_left)
          spl()->set(cssa_float, float_ev(float_left));
        else if (ha == align_right)
          spl()->set(cssa_float, float_ev(float_right));
      }
    };

    auto check_valign_content = [&]() {
      valign_ev va = atts.get_valign();
      if (va.is_defined())
        spl()->set(cssa_vertical_align,va);
    };

    switch (tag) {
    case tag::T_UL: {
      int l = list_level(this);
      switch (l) {
      case 1: spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_disc)); break;
      case 2:
        spl()->set(cssa_margin_top, value::make_length(0, value::px));
        spl()->set(cssa_margin_bottom, value::make_length(0, value::px));
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_circle));
        break;
      default:
        spl()->set(cssa_margin_top, value::make_length(0, value::px));
        spl()->set(cssa_margin_bottom, value::make_length(0, value::px));
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_square));
      }

      goto CHECK_LIST_TYPE;

    } break;
    case tag::T_OL: {
      if (list_level(this) > 1) {
        spl()->set(cssa_margin_top, value::make_length(0, value::px));
        spl()->set(cssa_margin_bottom, value::make_length(0, value::px));
      }
    CHECK_LIST_TYPE:
      string type = atts.get_string(attr::a_type);
      if (type.length() == 0)
        ;
      else if (type == CHARS("1"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_decimal));
      else if (type == CHARS("a"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_lower_alpha));
      else if (type == CHARS("A"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_upper_alpha));
      else if (type == CHARS("i"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_lower_roman));
      else if (type == CHARS("I"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_upper_roman));
      else if (type == CHARS("disc"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_disc));
      else if (type == CHARS("circle"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_circle));
      else if (type == CHARS("square"))
        spl()->set(cssa_list_style_type, ENUMV(list_style_type_e)(list_style_square));
    } break;

    case tag::T_BODY: {
      /*
      space_v padding_left;
      space_v padding_right;
      space_v padding_top;
      space_v padding_bottom;

      from_string(padding_left, atts.get_ustring("leftmargin"));
      from_string(padding_right, atts.get_ustring("rightmargin"));
      from_string(padding_top, atts.get_ustring("topmargin"));
      from_string(padding_bottom, atts.get_ustring("bottommargin"));

      s.margin[0].inherit(size_v(padding_left));
      s.margin[1].inherit(size_v(padding_top));
      s.margin[2].inherit(size_v(padding_right));
      s.margin[3].inherit(size_v(padding_bottom));*/

      color_v bc = atts.get_color(attr::a_bgcolor);
      if(bc.is_defined())
        spl()->set(cssa_background_color, atts.get_color(attr::a_bgcolor));
      color_v fc = atts.get_color("text");
      if(fc.is_defined())
        spl()->set(cssa_color, fc);
      //???? s.height.set_flex(1.0f);
    } break;

    case tag::T_OPTIONS:
    case tag::T_OPTION: {
      if (!state.expanded() && !state.collapsed()) {
        auto exp = atts.get_bool_v(attr::a_expanded);
        bool is_node = exp.is_defined() || has_children_of_type(tag::T_OPTION);
        state.node(is_node);
        if (exp)
          state.expanded(true);
        else if (is_node)
          state.collapsed(true);
      }
    } break;
#pragma TODO("CSS:optgroup")
/*  case tag::T_OPTGROUP: {
      ustring text_before = atts.get_ustring(attr::a_label);
      if (text_before.length()) {
        helement anonymous_text_block = v.get_anonymous_para(tag::T_CAPTION);
        anonymous_text_block->parent  = this;
        anonymous_text_block->owner   = this;
        text *tn                      = new text(text_before);
        anonymous_text_block->append(tn);
        get_css_content(this)->before = anonymous_text_block;
      } else if (style_content && style_content->before)
        style_content->before = nullptr;
    } break; */

    case tag::T_FONT: {
      string fontname = atts.get_string(attr::a_face);
      string fontsize = atts.get_string(attr::a_size);
      if (fontname.length())
        spl()->set(cssa_font_family, value(fontname));
      if (fontsize.length()) {
        int isz = atoi(fontsize);
        if (fontsize[0] == '-' || fontsize[0] == '+')
          spl()->set(cssa_font_size, value::make_length(isz, value::rs));
        else
          spl()->set(cssa_font_size, value::make_literal_length(value::length_special_values(value::$xx_small + isz - 1)));
      }
      ustring fontcolor = atts.get_ustring(attr::a_color);
      color_v fc; from_string(fc, fontcolor);
      if(fc.is_defined())
        spl()->set(cssa_color, fc);
      color_v bc = atts.get_color(attr::a_bgcolor);
      if (bc.is_defined())
        spl()->set(cssa_background_color, bc);
    } break;

    case tag::T_DIV:
    case tag::T_H1:
    case tag::T_H2:
    case tag::T_H3:
    case tag::T_H4:
    case tag::T_H5:
    case tag::T_H6:
    case tag::T_P: {
      halign_ev alignment = atts.get_align();
      if (alignment.is_defined())
        spl()->set(cssa_text_align, alignment);
    } break;
    case tag::T_TABLE: {
      halign_ev alignment = atts.get_align();
      space_v  border    = atts.get_border();
      if (border.is_defined()) {
        //s.border_style[0] = s.border_style[1] = s.border_style[2] = s.border_style[3] = border_solid;
        border_style_ev solid(border_solid);
        spl()->set(cssa_border_bottom_style, solid);
        spl()->set(cssa_border_top_style, solid);
        spl()->set(cssa_border_left_style, solid);
        spl()->set(cssa_border_right_style, solid);

        value dips = value::make_length(border, value::dip);
        spl()->set(cssa_border_bottom_width, dips);
        spl()->set(cssa_border_top_width, dips);
        spl()->set(cssa_border_left_width, dips);
        spl()->set(cssa_border_right_width, dips);
      }
      dimension_v w = atts.get_width();
      if (w.is_defined()) {
        if (w < 0)
          spl()->set(cssa_width, value::make_length(-int(w) / 100.0f,value::sp));
        else if (w > 0)
          spl()->set(cssa_width, value::make_length(int(w), value::dip));
      }
      dimension_v h = atts.get_height();
      if (h.is_defined()) {
        if (h < 0)
          spl()->set(cssa_height, value::make_length(-int(h) / 100.0f, value::sp));
        else if (h > 0)
          spl()->set(cssa_height, value::make_length(int(h), value::dip));
      }
      check_align_float();
    } break;

    case tag::T_TBODY:
    case tag::T_THEAD:
    case tag::T_TFOOT: {
      if (parent) {
        //const style *pcs = parent->c_style;
        //s.border_spacing_x.inherit(pcs->border_spacing_x);
        //s.border_spacing_y.inherit(pcs->border_spacing_y);
        spl()->set(cssa_border_spacing_x, value::inherit_val());
        spl()->set(cssa_border_spacing_y, value::inherit_val());
      }
    } break;
    case tag::T_TD:
    case tag::T_TH: {
      element *table = parent_table(this);
      if (table) {
        space_v border = table->atts.get_border();
        if (border.is_defined()) {
          ENUMV(border_style_e) solid(border_solid);
          spl()->set(cssa_border_bottom_style, solid);
          spl()->set(cssa_border_top_style, solid);
          spl()->set(cssa_border_left_style, solid);
          spl()->set(cssa_border_right_style, solid);
          value dips = value::make_length(border, value::dip);
          spl()->set(cssa_border_bottom_width, dips);
          spl()->set(cssa_border_top_width, dips);
          spl()->set(cssa_border_left_width, dips);
          spl()->set(cssa_border_right_width, dips);
        }
        space_v spacing = table->atts.get_cell_spacing();
        if (spacing.is_defined()) {
          value dips = value::make_length(spacing, value::dip);
          spl()->set(cssa_padding_bottom, dips);
          spl()->set(cssa_padding_top, dips);
          spl()->set(cssa_padding_left, dips);
          spl()->set(cssa_padding_right, dips);
        }

        color_v bc = atts.get_color(attr::a_bgcolor);
        if(bc.is_defined())
          spl()->set(cssa_background_color, bc);

        if (atts.get_bool(attr::a_nowrap, false))
          spl()->set(cssa_white_space, ENUMV(white_space_e)(white_space_nowrap));

        halign_ev alignment = atts.get_align();
        if (alignment.is_defined())
          spl()->set(cssa_text_align, alignment);

        check_valign_content();
      }
    } break;

    case tag::T_SVG:
      apply_svg_attributes(v, pd, this, this->atts, spl());
      // and fall trough
    case tag::T_IMG:
    case tag::T_PICTURE:
    case tag::T_VIDEO:
    case tag::T_CANVAS:
    {
      dimension_v dv = atts.get_width();
                              if (dv.is_defined()) spl()->set(cssa_width, value::make_length(dv,value::dip));
      dv = atts.get_height(); if (dv.is_defined()) spl()->set(cssa_height, value::make_length(dv, value::dip));
      size_v w = atts.get_width_size();
      if (w.is_defined()) spl()->set(cssa_width, w);
      size_v h = atts.get_height_size();
      if (h.is_defined()) spl()->set(cssa_height, h);
      check_align_float();
      color_v bc = atts.get_color(attr::a_bgcolor);
      if(bc.is_defined()) spl()->set(cssa_background_color, bc);
    } break;

    case tag::T_TEXT: // in Sciter it is used in HTML and in SVG
      if (!is_in_svg_context()) break;
      spl()->set(cssa_width, value::make_literal_length(value::$max_content));
    // SVG elements
    case tag::T_G:
    case tag::T_PATH:
    case tag::T_RECT:
    case tag::T_CIRCLE:
    case tag::T_ELLIPSE:
    case tag::T_LINE:
    case tag::T_POLYLINE:
    case tag::T_POLYGON:
    case tag::T_SWITCH:
    case tag::T_RADIALGRADIENT:
    case tag::T_LINEARGRADIENT:
    case tag::T_STOP:
      apply_svg_attributes(v, pd, this, this->atts, spl());
      break;
    case tag::T_USE:
    {
      ustring buddyid = this->atts.get_ustring("xlink:href");
      if (buddyid.is_empty()) break;
      if (buddyid[0] != '#') break;
      helement buddy = pd->get_element_by_id(buddyid().sub(1));
      if (!buddy) break;

      attribute_bag catts = this->atts;
      catts.inherit(buddy->atts);
      apply_svg_attributes(v, pd, this, catts, spl());

    } break;

    default: break;
    }

    /*if( state.content_editable() ) { // content editable support
      tag::CMODEL_TYPE cmt = tag::content_model(tag);
      if( cmt == tag::CMODEL_INLINES || cmt == tag::CMODEL_TEXT ) {
        if( s.white_space != white_space_pre  )
          s.white_space = white_space_prewrap;
      }
    }*/

    ustring dir = atts.get_ustring(attr::a_dir);
    if (dir.is_defined()) {
      if (dir() == WCHARS("ltr")) {
        spl()->set(cssa_direction, ENUMV(direction_e)(direction_ltr));
        state.ltr(true);
      } else if (dir() == WCHARS("rtl")) {
        spl()->set(cssa_direction, ENUMV(direction_e)(direction_rtl));
        state.rtl(true);
      }
      // else if( dir.equals(L"ttb") )
      //{
      //  s.direction = direction_rtl;
      //  state.rtl(true);
      //}
    }

    if (state.ltr() || state.rtl())
      spl()->set(cssa_horizontal_align, ENUMV(halign_e)(align_start));

    string styleset = atts.get_url(pd->uri().src, attr::a_styleset);
    if (styleset.is_defined()) {
      chars url, name;
      if (styleset().split('#', url, name))
      {
        bool is_important = false;
        if (name.ends_with('!')) {
          name.prune(0, 1);
          is_important = true;
        }
        forced_style_set(name, url, is_important);
      }
    }
    return _spl;
  }

  point element::scroll_pos() const {
    if (!ldata) return point();
    point p = ldata->sb.scroll_pos(this);
    return p + ldata->offset;
  }

  void element::scroll_pos(view &v, point off, bool allow_out_of_bounds) {
    if (ldata) { ldata->sb.scroll_pos(v, this, off, allow_out_of_bounds); }
  }

  bool element::can_scroll_h(view &v) const {
    if (ldata) return ldata->sb.can_scroll_h(v);
    return false;
  }
  bool element::can_scroll_v(view &v) const {
    if (ldata) return ldata->sb.can_scroll_v(v);
    return false;
  }

  point element::scroll_translate(view &v, point pt) {
    /*if( ldata && ldata->xctx && c_style->transforms )
    {
      affine_mtx_f mtx;
      compute_mtx(v,mtx);
      mtx.transform(pt);
    }*/
    return pt - scroll_pos();
  }

  point element::translate(view &v, point pt) {
    if (ldata && c_style->transforms) {
      affine_mtx_f mtx;
      compute_mtx(v, mtx);
      mtx.transform(pt);
    }
    return pt;
  }

  point element::inverse_translate(view &v, point pos) // inverse
                                                       // scroll_translate - to
                                                       // flat, non transformed
                                                       // local (for the
                                                       // element) position
  {
    if (ldata && c_style->transforms) {
      affine_mtx_f mtx;
      compute_mtx(v, mtx);
      mtx.inverse_transform(pos);
    }
    return pos;
  }

  size get_container_dim(view &v, element *self) {
    element *p = self->layout_parent(v);
    if (!p) return v.dimension();
    return p->dim();
  }

  bool is_in_vertical_layout(
      element *b) // this gets called when b->width->flex is not zero
  {
    flow_e pflow = flow_default;
    if (element *owner = b->get_owner())
      pflow = owner->layout_type();
    //else if (b->parent)
    //  pflow = b->parent->layout_type();

    if ((b->c_style->display == display_inline ||
         b->c_style->display == display_inline_block) &&
        pflow == flow_text)
      return false;
    return pflow == flow_default || pflow == flow_vertical ||
           pflow == flow_stack;
  }

  bool is_in_horizontal_layout(
      element *b) // this gets called when b->height->flex is not zero
  {
    flow_e pflow = flow_default;
    element *owner = b->get_owner();
    if (owner)
      pflow = owner->layout_type();
    //else if (b->parent)
    //  pflow = b->parent->layout_type();

    if (pflow == flow_vertical || pflow == flow_default)
      return !owner || (owner->last_ui_element() == owner->first_ui_element());
    // b is single child of its owner thus it can
    // be trated as horizontal too.
    return pflow == flow_horizontal || pflow == flow_stack;
  }

  // calculates declared width of the parent.
  /*int_v get_parent_declared_width(view &v, element *b) {
    element *pb = b->get_owner();
    if (pb) {
      //pb->ldata->content_h_percent_dependent = true;
      // if(is_defined_width(v, b->parent))
      //  return true;
      const style *cs = pb->get_style(v);
      if (cs->overflow_x >= overflow_hidden || pb->oof_positioned(v) ||
          pb->popup_positioned(v))
        return pb->dim().x;
      size_v w = cs->width;
      if (w.is_percent()) {
        int_v t = get_parent_declared_width(v, pb);
        if (t.is_undefined()) return int_v();
        return int(w.percent1() * t.val(0));
      }
      else if (w.is_auto())
      {
        return pb->min_max_width(v);
      }
      else if (w.is_fixed() || w.is_percent_of_view())
        return w.pixels_width(v, pb, 0);

      if (w.flex() && pb && is_in_vertical_layout(pb)) { // workaround
        int_v t = get_parent_declared_width(v, pb);
        if (t.is_defined()) {
          auto margins = pb->margin_distance(v);
          return max(0, t - margins.left() - margins.right());
        }
      }
      if (v.bfc) return v.bfc->dim().x;
      return int_v();
    } else
      return v.dimension().x;
  }*/

  // calculates declared height of the parent.
  /*int_v get_parent_declared_height(view &v, element *b) {
    element *pb = b->get_owner();
    if (pb) {
      //pb->ldata->content_v_percent_dependent = true;
      const style *cs                        = pb->get_style(v);
      if ((cs->overflow_y >= overflow_hidden && pb->ldata->dim.y) ||
          pb->oof_positioned(v) || pb->popup_positioned(v))
        return pb->ldata->dim.y;
      size_v h = cs->height;
      if (h.is_percent()) {
        int_v t = get_parent_declared_height(v, pb);
        if (t.is_undefined()) return int_v();
        return int(h.percent1() * t.val(0));
      } else if (h.is_fixed() || h.is_percent_of_view())
        return h.pixels_height(v, pb, 0);

      if (h.flex() && is_in_horizontal_layout(pb)) { // workaround
        int_v t = get_parent_declared_height(v, pb);
        if (t.is_defined()) {
          auto margins = pb->margin_distance(v);
          return max(0, t - margins.top() - margins.bottom());
        }
      }
      if (v.bfc) return v.bfc->dim().y;
      return int_v();
    } else
      return v.dimension().y;
  }*/

  int element::min_width(view &v, int_v container_width) {
    hstyle cs = get_style(v);
    check_layout(v);

    int fixed_width = -1;

    auto get_min_content = [&]() -> int {
      if (ldata->dim_min.x.is_undefined()) { calc_intrinsic_widths(v); }
      return ldata->dim_min.x.val(0);
      //return max(ldata->dim_min.x.val(0),ldata->used_dim_min.x);
    };
    auto get_max_content = [&]() -> int {
      if (ldata->dim_max.x.is_undefined()) { calc_intrinsic_widths(v); }
      return ldata->dim_max.x.val(0);
    };

    int w = cs->overflow_x > overflow_visible ? 0 : get_min_content();

    if (airborn && airborn->dim.x.is_defined())
      w = airborn->dim.x;
    else if (cs->width.is_defined()) {
      if (cs->width.is_auto()) {
        if (!get_auto_width(v, this, w)) w = get_min_content();
        fixed_width = w;
      }
      else if (cs->width.is_min_intrinsic()) {
        w = get_min_content();
        fixed_width = w;
      }
      else if (cs->width.is_max_intrinsic()) {
        w = get_max_content();
        fixed_width = w;
      }
      else if (cs->width.is_spring())
        w = cs->overflow_x > overflow_visible ? 0 : get_min_content();
      else if (cs->width.is_percent())
      {
        if (container_width.is_defined()) {
          w = pixels(v, this, cs->width).width();
          fixed_width = w;
        }
      }
      else {
        w = pixels(v, this, cs->width).width();
        fixed_width = w;
      }
    }
    if (cs->min_width.is_defined()) {
      int t = 0;
      if (cs->min_width.is_auto()) {
        if (!get_auto_width(v, this, t))
          t = get_min_content();
      } else if (cs->min_width.is_min_intrinsic())
        t = get_min_content();
      else if (cs->min_width.is_max_intrinsic())
        t = get_max_content();
      else
        t = pixels(v, this, cs->min_width).width();
      if (t >= fixed_width)
        w = t;
    }

    if (cs->max_width.is_defined()) {
      int t = limits<int>::max_value();
      if (cs->max_width.is_auto()) {
        if (!get_auto_width(v, this, t)) t = get_min_content();
      } else if (cs->max_width.is_min_intrinsic())
        t = get_min_content();
      else if (cs->max_width.is_max_intrinsic())
        t = get_max_content();
      else
        t = pixels(v, this, cs->max_width).width();
      if (t < w) w = t;
    }

    if (cs->overflow_x == overflow_none) return max(w, ldata->dim_min.x);
    return w;
  }


  int element::declared_min_width(view &v, int container_width) {
    hstyle cs = get_style(v);
    if (cs->min_width.is_defined()) {
      check_layout(v);
      int t = 0;
      if (cs->min_width.is_min_intrinsic())
        t = min_content_width(v);
      else if (cs->min_width.is_max_intrinsic())
        t = max_content_width(v);
      else
        t = pixels(v, this, cs->min_width).width();
      return t;
    }
    return 0;
  }
  int element::declared_max_width(view &v, int container_width) {
    hstyle cs = get_style(v);
    if (cs->max_width.is_defined()) {
      check_layout(v);
      int t = 0;
      if (cs->max_width.is_min_intrinsic())
        t = min_content_width(v);
      else if (cs->max_width.is_max_intrinsic())
        t = max_content_width(v);
      else
        t = pixels(v, this, cs->max_width).width();
      return t;
    }
    return limits<int>::max_value();
  }
  int element::declared_width(view &v, int container_width) {
    hstyle cs = get_style(v);
    if (airborn && airborn->dim.x.is_defined()) return airborn->dim.x;
    if (cs->width.is_defined()) {
      check_layout(v);
      int t = 0;
      if (cs->width.is_min_intrinsic())
        t = min_content_width(v);
      else if (cs->width.is_max_intrinsic())
        t = max_content_width(v);
      else
        t = pixels(v, this, cs->width).width();
      return t;
    }
    return element::declared_min_width(v, container_width);
  }

  int element::min_defined_width(view &v, bool including_width) {
    hstyle cs = get_style(v);
    check_layout(v);
    int w  = 0;
    int pw = get_container_dim(v, this).x;
    if (including_width && cs->width.is_defined()) {
      if (cs->width.is_auto()) {
        if (!get_auto_width(v, this, w)) w = min_content_width(v);
      } else if (cs->width.is_min_intrinsic())
        w = min_content_width(v);
      else if (cs->width.is_max_intrinsic())
        w = max_content_width(v);
      else
        w = pixels(v, this, cs->width).width();
    }
    if (cs->min_width.is_defined()) {
      int t = 0;
      if (cs->min_width.is_min_intrinsic())
        t = min_content_width(v);
      else if (cs->min_width.is_max_intrinsic())
        t = max_content_width(v);
      else
        t = pixels(v, this, cs->min_width).width();
      if (t > w) w = t;
    }

    if (cs->overflow_x > overflow_none) return w;
    return max(w, ldata->dim_min.x);
  }

  int element::declared_min_height(view &v, int container_height) {
    hstyle cs = get_style(v);
    if (cs->min_height.is_defined()) {
      check_layout(v);
      int t = 0;
      if (cs->min_height.is_min_intrinsic())
        t = min_content_height(v);
      else if (cs->min_height.is_max_intrinsic())
        t = max_content_height(v);
      else
        t = pixels(v, this, cs->min_height).height();
      return t;
    }
    return 0;
  }
  int element::declared_max_height(view &v, int container_height) {
    hstyle cs = get_style(v);
    if (cs->max_height.is_defined()) {
      check_layout(v);
      int t = 0;
      if (cs->max_height.is_min_intrinsic())
        t = min_content_height(v);
      else if (cs->max_height.is_max_intrinsic())
        t = max_content_height(v);
      else
        t = pixels(v, this, cs->max_height).height();
      return t;
    }
    return limits<int>::max_value();
  }
  int element::declared_height(view &v, int container_height) {
    hstyle cs = get_style(v);
    if (airborn && airborn->dim.y.is_defined())
      return airborn->dim.y;
    else if (cs->height.is_defined()) {
      check_layout(v);
      int t = 0;
      if (cs->height.is_min_intrinsic())
        t = min_content_height(v);
      else if (cs->height.is_max_intrinsic())
        t = max_content_height(v);
      else
        t = pixels(v, this, cs->height).height();
      return t;
    }
    return max(min_content_height(v),element::declared_min_height(v, container_height));
  }

  int element::outer_int_x_extra(view &v, int container_width) {
    hstyle cs = get_style(v);
    int    mw = 0;
    mw += pixels(v, this, cs->margin[0]).width();
    mw += pixels(v, this, cs->margin[2]).width();
    mw += pixels(v, this, cs->used_padding(0)).width();
    mw += pixels(v, this, cs->used_padding(2)).width();
    mw += pixels(v, this, cs->used_border_width(0)).width();
    mw += pixels(v, this, cs->used_border_width(2)).width();
    return mw;
  }
  int element::borpad_int_x_extra(view &v, int container_width) {
    hstyle cs = get_style(v);
    int    mw = 0;
    mw += pixels(v, this, cs->used_padding(0)).width();
    mw += pixels(v, this, cs->used_padding(2)).width();
    mw += pixels(v, this, cs->used_border_width(0)).width();
    mw += pixels(v, this, cs->used_border_width(2)).width();
    return mw;
  }

  int div2d(int n) { return n / 2; }
  int div2u(int n) { return n / 2 + n % 2; }

  int element::cell_int_x_extra(view &v, int container_width, bool collapsed) {
    hstyle cs = get_style(v);
    int    mw = 0;
    mw += pixels(v, this, cs->used_padding(0)).width();
    mw += pixels(v, this, cs->used_padding(2)).width();
    if (collapsed) {
      mw += div2d(pixels(v, this, cs->used_border_width(0)).width());
      mw += div2u(pixels(v, this, cs->used_border_width(2)).width());
    } else {
      mw += pixels(v, this, cs->used_border_width(0)).width();
      mw += pixels(v, this, cs->used_border_width(2)).width();
    }
    return mw;
  }

  int element::outer_int_y_extra(view &v, int container_width) {
    hstyle cs = get_style(v);
    int    mw = 0;
    mw += pixels(v, this, cs->margin[1]).width();
    mw += pixels(v, this, cs->margin[3]).width();
    mw += pixels(v, this, cs->used_padding(1)).width();
    mw += pixels(v, this, cs->used_padding(3)).width();
    mw += pixels(v, this, cs->used_border_width(1)).width();
    mw += pixels(v, this, cs->used_border_width(3)).width();
    return mw;
  }

  int element::borpad_int_y_extra(view &v, int container_width) {
    hstyle cs = get_style(v);
    int    mw = 0;
    mw += pixels(v, this, cs->used_padding(1)).width();
    mw += pixels(v, this, cs->used_padding(3)).width();
    mw += pixels(v, this, cs->used_border_width(1)).width();
    mw += pixels(v, this, cs->used_border_width(3)).width();
    return mw;
  }

  int element::cell_int_y_extra(view &v, int container_width, bool collapsed) {
    hstyle cs = get_style(v);
    int    mw = 0;
    mw += pixels(v, this, cs->used_padding(1)).width();
    mw += pixels(v, this, cs->used_padding(3)).width();
    if (collapsed) {
      mw += div2d(pixels(v, this, cs->used_border_width(1)).width());
      mw += div2u(pixels(v, this, cs->used_border_width(3)).width());
    } else {
      mw += pixels(v, this, cs->used_border_width(1)).width();
      mw += pixels(v, this, cs->used_border_width(3)).width();
    }
    return mw;
  }


  int_v element::max_width(view &v, int_v container_width) {
    hstyle cs = get_style(v);
    check_layout(v);
    int_v w;

    auto get_min_content = [&]() -> int {
      if (ldata->dim_min.x.is_undefined()) { calc_intrinsic_widths(v); }
      return ldata->dim_min.x.val(0);
    };
    auto get_max_content = [&]() -> int {
      if (ldata->dim_max.x.is_undefined()) { calc_intrinsic_widths(v); }
      return ldata->dim_max.x.val(0);
    };

    if (airborn && airborn->dim.x.is_defined())
      w = airborn->dim.x;
    else if (cs->width.is_defined()) {
      if (cs->width.is_auto()) {
        int t;
        if (get_auto_width(v, this, t))
          w = t;
      } else if (cs->width.is_min_intrinsic())
        w = get_min_content();
      else if (cs->width.is_max_intrinsic())
        w = get_max_content();
      else if (cs->width.is_spring())
        ; // w is left undefined here, not w = ldata->dim_max.x;
      else
        w = pixels(v, this, cs->width).width();
    }

    if (cs->max_width.is_defined()) {
      int   maw = 0;
      if (cs->max_width.is_auto()) {
        if (!get_auto_width(v, this, maw))
          return w;
      } else if (cs->max_width.is_min_intrinsic())
        maw = get_min_content();
      else if (cs->max_width.is_max_intrinsic())
        maw = get_max_content();
      else if (cs->max_width.is_spring())
        return w;
      else
        maw = pixels(v, this, cs->max_width).width();
      w = max(w.val(0), maw);
    }

    if (w.is_defined() && cs->min_width.is_defined()) {
      int miw = 0;
      if (cs->min_width.is_auto()) {
        if (!get_auto_width(v, this, miw))
          return w;
      }
      else if (cs->min_width.is_min_intrinsic())
        miw = get_min_content();
      else if (cs->min_width.is_max_intrinsic())
        miw = get_max_content();
      else if (cs->min_width.is_spring())
        return w;
      else
        miw = pixels(v, this, cs->min_width).width();
      w = max(w.val(0), miw);
    }

    return w;
  }
#if 0
  int_v element::min_max_width(view &v) {
    hstyle cs = get_style(v);
    check_layout(v);
    int_v w;
    {
      if (airborn && airborn->dim.x.is_defined())
        w = airborn->dim.x;
      else if (cs->width.is_defined()) {
        if (cs->width.is_auto()) {
          if (!get_auto_width(v, this, w._v))
            w = ldata->dim_max.x;
        }
        else if (cs->width.is_min_intrinsic())
          w = ldata->dim_min.x;
        else if (cs->width.is_max_intrinsic())
          w = ldata->dim_max.x;
        else if (cs->width.is_spring())
          w.clear(); // ldata->dim_max.x;
        else
          w = pixels(v, this, cs->width).width();
      }
      // else
      //  w = ldata->dim_max.x;
    }

    if (cs->max_width.is_defined()) {
      int t = 0;
      if (cs->max_width.is_auto()) {
        if (!get_auto_width(v, this, t)) t = ldata->dim_max.x;
      } else if (cs->max_width.is_min_intrinsic())
        t = ldata->dim_min.x;
      else if (cs->max_width.is_max_intrinsic())
        t = ldata->dim_max.x;
      else
        t = pixels(v, this, cs->max_width).width();
      if (w.is_undefined())
        w = t;
      else if (t < w.val(0))
        w = t;
    }
    return w;
  }


  int_v element::min_max_height(view &v) {
    hstyle cs = get_style(v);
    check_layout(v);
    int h = -1;
    {
      if (airborn && airborn->dim.y.is_defined())
        h = airborn->dim.y;
      else if (cs->height.is_defined()) {
        if (cs->height.is_auto()) {
          if (!get_auto_height(v, this, h)) h = ldata->dim_max.y;
        }
        if (cs->height.is_min_intrinsic())
          h = ldata->dim_min.y;
        else if (cs->height.is_max_intrinsic())
          h = ldata->dim_max.y;
        else if (cs->height.is_spring())
          h = -1; // ldata->dim_max.x;
        else
          h = pixels(v, this, cs->height).height();
      }
      // else
      //  h = ldata->dim_max.y;
    }

    if (cs->max_height.is_defined()) {
      int t = 0;
      if (cs->max_height.is_auto()) {
        if (!get_auto_height(v, this, t)) t = ldata->dim_max.y;
      } else if (cs->max_height.is_min_intrinsic())
        t = ldata->dim_min.y;
      else if (cs->max_height.is_max_intrinsic())
        t = ldata->dim_max.y;
      else
        t = pixels(v, this, cs->max_width).height();
      if (t < h) h = t;
    }
    return h < 0 ? int_v() : int_v(h);
  }

#endif

  int element::min_content_width(view &v) {
    get_style(v);
    check_layout(v);
    if (ldata->dim_min.x.is_undefined()) { calc_intrinsic_widths(v); }
    return ldata->dim_min.x;
  }
  int element::max_content_width(view &v) {
    get_style(v);
    check_layout(v);
    if (ldata->dim_max.x.is_undefined()) { calc_intrinsic_widths(v); }
    return ldata->dim_max.x;
  }
  int element::min_content_height(view &v) {
    get_style(v);
    check_layout(v);
    if (ldata->dim_min.y.is_undefined()) { set_width(v, ldata->dim.x); }
    return ldata->dim_min.y;
  }
  int element::max_content_height(view &v) {
    get_style(v);
    check_layout(v);
    if (ldata->dim_max.y.is_undefined()) {
      check_layout(v);
      set_width(v, ldata->dim.x);
    }
    return ldata->dim_max.y;
  }

  floats_ctx *element::fctx(view &v, bool create) {
    if (!ldata->fctx && create) ldata->fctx = new floats_ctx(v, this);
    return ldata->fctx;
  }

  int element::min_inline_margin_box_width(view &v) {
    int pw = parent ? parent->dim().x : v.dim.x;
    return (get_style(v)->get_float() == float_none)
               ? (min_width(v, pw) + outer_int_x_extra(v, pw))
               : 0;
  }

#if 0
  int_v element::min_max_width_border(view &v) {
    int_v t = min_max_width(v);
    if (t.is_undefined()) return t;
    return t + ldata->borpad_left() + ldata->borpad_right();
  }


  int_v element::min_max_height_border(view &v) {
    int_v t = min_max_height(v);
    if (t.is_undefined()) return t;
    return t + ldata->borpad_left() + ldata->borpad_right();
  }
  int_v element::min_max_width_outer(view &v) {
    int_v t = min_max_width(v);
    if (t.is_undefined()) return t;
    return t + ldata->outer_left() + ldata->outer_right();
  }

  int_v element::min_max_height_outer(view &v) {
    int_v t = min_max_height(v);
    if (t.is_undefined()) return t;
    return t + ldata->outer_left() + ldata->outer_right();
  }
#endif

#if 1

  int element::min_height(view &v, int_v container_height) {
    hstyle cs = get_style(v);
    check_layout(v);
    // assert(ldata->dim_min.y.is_defined());

#ifdef _DEBUG
    if (is_id_test())
      cs = cs;
#endif

    auto get_min_content = [&]() -> int {
      if (ldata->dim_min.y.is_undefined()) { set_width(v, ldata->dim.x); }
      return ldata->dim_min.y;
    };
    auto get_max_content = [&]() -> int {
      if (ldata->dim_max.y.is_undefined()) { set_width(v, ldata->dim.x); }
      return ldata->dim_max.y;
    };

    int h = 0;
    int_v fixed_height;

    if (airborn && airborn->dim.y.is_defined())
      h = airborn->dim.y;
    else if (cs->height.is_defined()) {
      if (cs->height.is_auto()) {
        if (!get_auto_height(v, this, h))
          h = get_min_content();
        else
          fixed_height = h;
      }
      else if (cs->height.is_spring()) {
        fixed_height = 0;
        if (cs->overflow_y >= overflow_hidden)
          h = 0;
        else
          h = get_min_content();
      }
      else if (cs->height.is_min_intrinsic()) {
        //assert(ldata->dim_min.y.is_defined());
        h = get_min_content();
        fixed_height = h;
      }
      else if (cs->height.is_max_intrinsic()) {
        //assert(ldata->dim_min.y.is_defined());
        h = get_max_content();
        fixed_height = h;
      }
      else if (cs->height.is_percent()) {
        if (container_height.is_defined()) {
          h = pixels(v, this, cs->height).height();
          fixed_height = h;
        }
        else {
          h = get_min_content();
          fixed_height = h;
        }
      }
      else {
        h = pixels(v, this, cs->height).height();
        fixed_height = h;
      }
    }
    else if (cs->overflow_y < overflow_hidden) // undefined
      fixed_height = h = get_min_content();

    if (cs->min_height.is_defined()) {
      int t = 0;
      if (cs->min_height.is_auto()) {
        if (!get_auto_height(v, this, t)) t = get_min_content();
      }
      else if (cs->min_height.is_min_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = get_min_content();
      }
      else if (cs->min_height.is_max_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = get_max_content();
      }
      else if (cs->min_height.is_percent()) {
        //t = cs->min_height.pixels_height(v, this,
        //  get_parent_declared_height(v, this));
        if (container_height.is_defined())
          t = pixels(v, this, cs->min_height).height();
      }
      else
        t = pixels(v, this, cs->min_height).height();

      //if (fixed_height.is_defined() && t >= fixed_height.val(0))
      //  h = t;
      if (t > h)
        h = t;
    }

    if (cs->max_height.is_defined()) {
      int t = 0;
      if (cs->max_height.is_auto()) {
        if (!get_auto_height(v, this, t)) t = get_max_content();
      }
      else if (cs->max_height.is_min_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = get_min_content();
      }
      else if (cs->max_height.is_max_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = get_max_content();
      }
      else if (cs->max_height.is_percent()) {
        if( container_height.is_defined() )
          t = pixels(v, this, cs->max_height).height();
      }
      else
        t = pixels(v, this, cs->max_height).height();
      if ((t < h) && t) h = t;
    }

    if (cs->overflow_y > overflow_visible) return h; // height of overflow:hidden element is not content dependent
    if (fixed_height.is_defined() ) return h; // height of height:23em element is not content dependent

    return max(h, get_min_content());
  }

#else

  int element::min_height(view &v, int container_height) {
    hstyle cs = get_style(v);
    check_layout(v);
    // assert(ldata->dim_min.y.is_defined());
    if( ldata->dim_min.y.is_undefined() )
    {
      set_width(v,ldata->dim.x);
      assert(ldata->dim_min.y.is_defined());
    }
    int h = 0;
    int fixed_height = -1;

    if (airborn && airborn->dim.y.is_defined())
      h = airborn->dim.y;
    else if (cs->height.is_defined()) {
      if (cs->height.is_auto()) {
        if (!get_auto_height(v, this, h))
          h = ldata->dim_min.y;
        else
          fixed_height = h;
      } else if (cs->height.is_spring()) {
        if (cs->overflow_y >= overflow_hidden)
          h = 0;
        else
          h = ldata->dim_min.y;
      } else if (cs->height.is_min_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        h = ldata->dim_min.y;
        fixed_height = h;
      } else if (cs->height.is_max_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        h = ldata->dim_max.y;
        fixed_height = h;
      } else if (get_owner() && cs->height.is_percent()) {
        h = cs->height.pixels_height(v, this,
                                     get_parent_declared_height(v, this));
        fixed_height = h;
      }
      else {
        h = cs->height.pixels_height(v, this, container_height);
        fixed_height = h;
      }
    } else if (cs->overflow_y < overflow_hidden)
      h = ldata->dim_min.y;

    if (cs->min_height.is_defined()) {
      int t = 0;
      if (cs->min_height.is_auto()) {
        if (!get_auto_height(v, this, t)) t = ldata->dim_min.y;
      } else if (cs->min_height.is_min_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = ldata->dim_min.y;
      } else if (cs->min_height.is_max_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = ldata->dim_max.y;
      } else if (get_owner() && cs->min_height.is_percent()) {
        t = cs->min_height.pixels_height(v, this,
                                         get_parent_declared_height(v, this));
      } else
        t = cs->min_height.pixels_height(v, this, container_height);
      if (t >= fixed_height)
        h = t;
    }

    if (cs->max_height.is_defined()) {
      int t = 0;
      if (cs->max_height.is_auto()) {
        if (!get_auto_height(v, this, t)) t = ldata->dim_max.y;
      } else if (cs->max_height.is_min_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = ldata->dim_min.y;
      } else if (cs->max_height.is_max_intrinsic()) {
        assert(ldata->dim_min.y.is_defined());
        t = ldata->dim_max.y;
      } else if (get_owner() && cs->max_height.is_percent()) {
        t = cs->max_height.pixels_height(v, this,
                                         get_parent_declared_height(v, this));
      } else
        t = cs->max_height.pixels_height(v, this, container_height);
      if ((t < h) && t) h = t;
    }

    if (cs->overflow_y > overflow_none) return h;

    return max(h, ldata->dim_min.y);
  }
#endif

  int element::min_defined_height(view &v, bool including_height) {
    hstyle cs = get_style(v);
    check_layout(v);
    int h = 0;
    if (including_height && cs->height.is_defined()) {
      if (cs->height.is_auto()) {
        if (!get_auto_height(v, this, h)) h = min_content_height(v);
      } else if (cs->height.is_min_intrinsic())
        h = min_content_height(v);
      else if (cs->height.is_max_intrinsic())
        h = max_content_height(v);
      else
        h = pixels(v, this, cs->height).height();
    }

    if (cs->min_height.is_defined()) {
      int t = 0;
      if (cs->min_height.is_auto()) {
        if (!get_auto_height(v, this, t)) t = min_content_height(v);
      }
      if (cs->min_height.is_min_intrinsic())
        t = min_content_height(v);
      else if (cs->min_height.is_max_intrinsic())
        t = min_content_height(v);
      else
        t = pixels(v, this, cs->min_height).height();
      if (t > h) h = t;
    }

    if (cs->overflow_y > overflow_none) return h;

    return max(h, ldata->dim_min.y);
  }

  /*int element::max_int_height(view &v, int container_height) {
    hstyle cs = get_style(v);
    check_layout(v);
    int h = ldata->dim_min.y;

    if (airborn && airborn->dim.y.is_defined())
      h = airborn->dim.y;
    else if (cs->height.is_defined()) {
      if (cs->height.is_min_intrinsic())
        h = ldata->dim_min.y;
      else if (cs->height.is_max_intrinsic())
        h = ldata->dim_max.y;
      else if (cs->height.is_spring())
        ; // h = ldata->dim_min.y;
      else if (get_owner() && cs->height.is_percent()) {
        h = cs->height.pixels_height(v, this,
                                     get_parent_declared_height(v, this));
      } else
        h = cs->height.pixels_height(v, this, 0);
    } else
      h = ldata->dim_max.y;

    if (cs->max_height.is_defined()) {
      int t = 0;
      if (cs->max_height.is_min_intrinsic())
        t = ldata->dim_min.y;
      else if (cs->max_height.is_max_intrinsic())
        t = ldata->dim_max.y;
      else if (cs->max_height.is_spring())
        return h;
      else if (get_owner() && cs->max_height.is_percent()) {
        t = cs->max_height.pixels_height(v, this,
                                         get_parent_declared_height(v, this));
      } else
        t = cs->max_height.pixels_height(v, this, 0);
      //???? if(t < h)
      h = t;
    }
    return h;
  }*/

  int_v element::max_height(view &v, int_v container_height) {
    hstyle cs = get_style(v);
    check_layout(v);
    int_v h;

    if (airborn && airborn->dim.y.is_defined())
      h = airborn->dim.y;
    else if (cs->height.is_defined()) {
      if (cs->height.is_auto()) {
        int t = 0;
        if (get_auto_height(v, this, t)) h = t;
      }
      if (cs->height.is_min_intrinsic())
        h = ldata->dim_min.y;
      else if (cs->height.is_max_intrinsic())
        h = ldata->dim_max.y;
      else if (cs->height.is_spring())
        ; // h = ldata->dim_min.y;
      else if (cs->height.is_percent()) {
        if(container_height.is_defined())
          h = pixels(v, this, cs->height).height();
      } else
        h = pixels(v, this, cs->height).height();
    }
    // else - must be left undefined
    //    h = ldata->dim_max.y;

    if (cs->max_height.is_defined()) {
      int t = 0;
      if (cs->max_height.is_min_intrinsic())
        t = ldata->dim_min.y;
      else if (cs->max_height.is_max_intrinsic())
        t = ldata->dim_max.y;
      else if (cs->max_height.is_spring())
        return h;
      else if (cs->max_height.is_percent()) {
        if(container_height.is_defined())
          t = pixels(v, this, cs->max_height).height();
      } else
        t = pixels(v, this, cs->max_height).height();
      h = max(t, h.val(0));
    }

    if (h.is_defined() && cs->min_height.is_defined()) {
      int mih = 0;
      if (cs->min_height.is_auto()) {
        if (!get_auto_height(v, this, mih))
          return h;
      }
      else if (cs->min_height.is_min_intrinsic())
        mih = ldata->dim_min.y;
      else if (cs->min_width.is_max_intrinsic())
        mih = ldata->dim_max.y;
      else if (cs->min_height.is_spring())
        return h;
      else
        mih = pixels(v, this, cs->min_height).height();
      h = max(h.val(0), mih);
    }

    return h;
  }

  rect element::client_rect(view &v) {
    return ldata->sb.client_rect(v, this);
    // return rect(dim());
  }

  bool element::get_scroll_data(view &v, scroll_data &sd) {
    check_layout(v);

    if (ldata->dim_min.x.is_undefined() || ldata->dim_min.y.is_undefined()) {
      size d = dim();
      layout_width(v, d.x);
      layout_height(v, d.y);
    }

    // assert(ldata->dim_min.x.is_defined() && ldata->dim_min.y.is_defined());

    sd.content_outline = rect(size(max(ldata->dim_min.x.val(0),ldata->content_dim.x), max(ldata->dim_min.y.val(0),ldata->content_dim.y)));
    sd.pos             = scroll_pos();
    sd.dim_view        = client_rect(v).size(); // ldata->dim;

    behavior_h pc = behavior;
    while (pc) {
      if (pc->get_scroll_data(v, this, sd)) return true;
      pc = pc->next;
    }

    return true;
  }

  void element::set_scroll_pos(view &v, point pos, bool smooth,
                               bool allow_out_of_bounds) {
    helement cover;
    if (!is_x_minmax_valid() || !is_y_minmax_valid() ||
        v.to_update.is_covered_by(this, cover))
      v.to_update.request_scroll_pos(this, pos, smooth, allow_out_of_bounds);
    else
      do_set_scroll_pos(v, pos, smooth, allow_out_of_bounds);
  }

  void element::do_set_scroll_pos(view &v, point pos, bool smooth,
                                  bool allow_out_of_bounds) {
    behavior_h pc = behavior;
    while (pc) {
      if (pc->set_scroll_pos(v, this, pos, smooth)) return;
      pc = pc->next;
    }
    v.scroll_window(pos, this, (smooth ? SCROLL_SMOOTH : SCROLL), true,
                    allow_out_of_bounds);
  }

  struct discard_animation_on {
    helement _this;
    uint     _prev;
    discard_animation_on(element *t) : _this(t) {
      _prev                          = _this->flags.discard_animation;
      _this->flags.discard_animation = 1;
    }
    ~discard_animation_on() { _this->flags.discard_animation = _prev; }
  };


  static helement create_shade_root(view& v, element* on) {
    helement el = new element(tag::T__SHADE);
    el->owner = el->parent = on;
    el->flags.disable_text_selection = true;
    return el;
  }

  void element::set_style_generated_content(view &v, const style *from) {

    uint changes = 0;

    if (from->content.is_defined()) {
      ustring cont = produce_content(v, this, d_style->content);
      handle<text> tn = new text(cont);
      tn->parent = this;
      tn->owner = this;
      if (!tn->same_as(get_css_content(this)->content)) {
        ++changes;
        get_css_content(this)->content = tn;
      }
    }
    else if (style_content && style_content->content) {
      style_content->content = nullptr;
      ++changes;
    }

    if (!flags.is_synthetic) { // we do not handle ::after on sythetic ::after elements
      if (from->pseudo_elements & PSEUDO_AFTER) {
        handle<html::css_content> cc = get_css_content(this);
        helement anonymous_text_block = cc->after ? cc->after.ptr() : v.get_anonymous_para(tag::T__AFTER);
        anonymous_text_block->parent = this;
        anonymous_text_block->owner = this;
        cc->after = anonymous_text_block;
      }
      else if (style_content && style_content->after) {
        ++changes;
        style_content->after->stray(v);
        style_content->after = nullptr;
      }

      if (from->pseudo_elements & PSEUDO_BEFORE) {
        handle<html::css_content> cc = get_css_content(this);
        helement anonymous_text_block = cc->before ? cc->before.ptr() : v.get_anonymous_para(tag::T__BEFORE);
        anonymous_text_block->parent = this;
        anonymous_text_block->owner = this;
        get_css_content(this)->before = anonymous_text_block;
      }
      else if (style_content && style_content->before && style_content->before->tag == tag::T__BEFORE) {
        ++changes;
        style_content->before->stray(v);
        style_content->before = nullptr;
      }

      if (from->pseudo_elements & PSEUDO_MARKER) {
        handle<html::css_content> cc = get_css_content(this);
        helement marker = cc->marker;
        if (!marker) {
          marker = this->create_text_block(v, wchars());
          cc->marker = marker;
        }
        //else
        //  marker->drop_style(); // WRONG! may create style update cycle
      }
      else if (style_content && style_content->marker && style_content->marker->tag == tag::T__MARKER) {
        style_content->marker->stray(v);
        style_content->marker = nullptr;
      }

      if (from->pseudo_elements & PSEUDO_SHADE) {
        handle<html::css_content> cc = get_css_content(this);
        helement shade = cc->shade;
        if (!shade) {
          shade = create_shade_root(v, this);
#ifdef DEBUG
          this->dbg_report("creating ::shade");
#endif // DEBUG

          cc->shade = shade;
        }
        //else {
        //  shade->drop_style();
        //}
      }
      else if (style_content && style_content->shade && style_content->shade->tag == tag::T__SHADE) {
        style_content->shade->stray(v);
        style_content->shade = nullptr;
      }
    }

    if (changes && flags.layout_ctl_valid)
      drop_layout(&v);
  }

  void element::check_animations(view &v, document *pd, const style *prev_style, STYLE_CHANGE_TYPE sct)
  {
    //handle<css_property_animator> pa;
    handle<css_std_property_animator> psa;

    if (d_style->has_transition_effect() && (sct == CHANGES_VISUAL) /* || prev_style->has_transition_effect()*/)
    {

      handle<effect_animator> pa = get_animation<effect_animator>();
      /*if (d_style->transition_effect == prev_style->transition_effect)
        ;
      else*/
      if (pa) {
        if (!pa->reverse(v, this, d_style, prev_style))
          v.remove_animation(this, pa);
      }
      else {
        pa = new effect_animator();
        pa->state = effect_animator::FORWARD;
        v.add_animation(this, pa, d_style, prev_style);
      }
      return;
    }

#if 0
    if (prev_style->transitions && !prev_style->transitions->is_std() && !d_style->transitions)
    {
      //hstyle new_style = d_style;
      //hstyle old_style = prev_style;
      pa = get_animation<css_property_animator>();
      if (pa) {
        //if (pa->is_same(prev_style, d_style))
        //  return;
        pa->reverse(v, this, d_style, prev_style);
      }
      else {
        pa = new css_property_animator(prev_style,d_style);
        v.add_animation(this, pa, d_style, prev_style);
      }
      // assert(c_style != null_style);
      if (c_style == null_style) // style was cleared somewhere in in behavior::attach
      {
        determine_style(v, pd, false, false);
      }
    }
    else if (!prev_style->transitions && d_style->transitions && !d_style->transitions->is_std())
    {
      pa = get_animation<css_property_animator>();
      if (pa) {
        //if (pa->is_same(prev_style, d_style))
        //  return;
        // pa->reverse(v,this, d_style, prev_style);
        hstyle _c_style = c_style;
        v.remove_animation(this, pa);
        c_style = _c_style;
        pa = new css_property_animator(prev_style, d_style);
        v.add_animation(this, pa, d_style, _c_style);
      }
      else {
        pa = new css_property_animator(prev_style, d_style);
        pa->initial_style = prev_style;
        pa->final_style = d_style;

        v.add_animation(this, pa, d_style, prev_style);
      }
      if (c_style == null_style) // style was cleared somewhere in in behavior::attach
      {
        determine_style(v, pd, false, false);
      }
    }
#endif

    // standard CSS transition handling
    if (d_style->transitions && need_animation(d_style->transitions,prev_style, d_style))
    {
      psa = get_animation<css_std_property_animator>();
      if (psa) {
        //if (psa->is_same(prev_style, d_style))
        //  return;
        psa->update_targets(v, this, d_style, prev_style);
      }
      else
      {
        psa = new css_std_property_animator(prev_style,d_style);
#ifdef DEBUG
        this->dbg_report("add_animation");
        need_animation(d_style->transitions, prev_style, d_style);
#endif
        v.add_animation(this, psa, d_style, prev_style);
        if (c_style == null_style) // style was cleared somewhere in in behavior::attach
          determine_style(v, pd, false, false);
      }
    }
    else if (prev_style->transitions && !d_style->transitions)
    {
      psa = get_animation<css_std_property_animator>();
      if (psa) {
        //if (psa->is_same(prev_style, d_style))
        //  return;
        v.remove_animation(this, psa); //just remove existing CSS animation
        if (c_style == null_style) // style was cleared somewhere in in behavior::attach
        {
          determine_style(v, pd, false, false);
        }
      }
    }

#ifdef DEBUG
    if (is_id_test())
      d_style = d_style;
#endif

    if (d_style->has_animations() && prev_style->has_animations()) {
      ;
    }
    else if (d_style->has_animations() && !prev_style->has_animations()) {
      handle<css_std_animate_animator> psa = new css_std_animate_animator();
      v.add_animation(this, psa, d_style, prev_style);
    }
    else if (!d_style->has_animations() && prev_style->has_animations()) {
      handle<css_std_animate_animator> psa = get_animation<css_std_animate_animator>();
      v.remove_animation(this, psa);
    }

  }

  void element::on_style_changed(view &v, document *pd) {
    hstyle   prev_style = p_style;
    hstyle   prev_drawn_style = p_drawn_style;
    helement holder     = this;

#ifdef _DEBUG
    if (is_id_test())
      pd = pd;
#endif

    if (d_style != null_style /* && p_style != c_style*/) {
      p_style = d_style;
      if (p_drawn_style == null_style)
        p_drawn_style = p_style;
      else if(d_style->is_display_none()) // invisible elements treatment
        p_drawn_style = p_style;
    }

    //flags.style_assignment = 1;

    element *owner = get_owner();
    if (owner) {
      if (d_style->transforms) owner->flags.has_transformed = 1;
      if (d_style->letter_spacing.is_defined()) {
        owner->flags.has_letter_spacing = 1;
        flags.has_letter_spacing        = 1;
      }
    }

    if (prev_style->behavior != d_style->behavior ||
        prev_style->display != d_style->display ||
        prev_style->is_display_none() != d_style->is_display_none())
    {
      // WRONG: if(c_style->display != display_none || state.popup())
      // display:none elements may have behaviors.
      //{

      discard_animation_on _(this);

      array<chars> new_behaviors = d_style->behavior.tokens(CHARS(" "));

      array<string> old_behaviors;
      get_behavior_names(old_behaviors);
      // ATTN, THIS DOES NOT WORK!: prev_style->behavior.tokens(old_behaviors,' ');

      if (flags.strayed || d_style->behavior.is_empty() ||
          d_style->behavior == CHARS("none")) {
        for (int o = 0; o < old_behaviors.size(); ++o)
          detach_named_behavior(v, old_behaviors[o]);
      } else {
        //state.ready(false);
        bool has_video = this->get_named_behavior("video") != nullptr;
        if (has_video) {
          // video may require companions to exist at moment of initialization:
          for (int o = 0; o < old_behaviors.size(); ++o)
            detach_named_behavior(v, old_behaviors[o]);
          for (int n = 0; n < new_behaviors.size(); ++n)
            attach_behavior(v, new_behaviors[n]);
        } else {
          for (int o = 0; o < old_behaviors.size(); ++o)
            if (new_behaviors.get_index(old_behaviors[o]) < 0)
              detach_named_behavior(v, old_behaviors[o]);
          for (int n = 0; n < new_behaviors.size(); ++n)
            if (old_behaviors.get_index(new_behaviors[n]) < 0 /*|| has_video*/)
              attach_behavior(v, new_behaviors[n]);
        }
      }
      //_style = _prev_style;
      v.on_element_behavior_changed(this, prev_style->behavior,
                                    d_style->behavior);
      if (flags.strayed || !parent)
        return; // removed by behavior
      if (d_style == null_style) // style was cleared somewhere in in behavior::attach
        determine_style(v, pd, false, false);
    }

    int is_p        = d_style->position;
    int z_index     = d_style->z_index;
    int was_z_index = prev_style->z_index;

    if (is_p == position_static) {
      if (positioned_parent)
        positioned_parent->ldata->zctx.remove(this, positioned_parent);
    } else {
      if (was_z_index != z_index && positioned_parent) {
        if (positioned_parent)
          positioned_parent->ldata->zctx.remove(this, positioned_parent);
      }
    }

    //handle<css_property_animator> pa;
    handle<css_std_property_animator> psa;

#ifdef DEBUG
    if (is_id_test()) {
      prev_style = prev_style;
    }
#endif // DEBUG

    bool check_geometry_change = false;

    STYLE_CHANGE_TYPE sct = CHANGES_MODEL;

    if (prev_style != null_style) // otherwise it is too heavy, see
                                  // /test-cases/stress/table-10000.htm
    {
      sct = changes(c_style, prev_style);

      if (pd->operational
        && !flags.discard_animation
        && !v.animations_disabled
        && (p_drawn_style != null_style)
        && (v.checking_animation_on != this)) // dont run any animation on initial document load
      {
        auto_state<element*> _(v.checking_animation_on, this);
        check_animations(v, pd, prev_drawn_style,sct);
      }
      check_geometry_change = true;
    }
    else if((prev_drawn_style == null_style) && d_style->has_animations()) {
      if ( !flags.discard_animation
        && !v.animations_disabled
        && (v.checking_animation_on != this))
      {
        auto_state<element*> _(v.checking_animation_on, this);
        check_animations(v, pd, prev_drawn_style,sct);
        check_geometry_change = true;
      }
    }

    if (check_geometry_change)
    {
      if (sct != NO_CHANGES) {

        element* to_update = (prev_style->take_space() && !c_style->take_space()) ? get_owner() : this;

        switch (sct) {
          case NO_CHANGES: break;
          case CHANGES_VISUAL: refresh(v); break;
          case CHANGES_POSITION: refresh(v); // break; - fall through
          case CHANGES_DIMENSION:
          case CHANGES_MODEL: v.add_to_update(to_update, sct); break;
        }

        bool was_visible = prev_style->visible();
        bool now_visible = c_style->visible();

        if (was_visible != now_visible /*&& flags.visibility_status != uint(now_visible)*/)
          v.on_element_visibility_changed(this, now_visible);
      }
    }

    set_style_generated_content(v, d_style);

    if (prev_style != element::null_style && d_style != element::null_style &&
        ((prev_style->overflow_x != d_style->overflow_x) ||
         (prev_style->overflow_y != d_style->overflow_y))) {
      v.post(delegate(this, &element::_update_scrollbars, &v, true), true);
    }

    // this has to be called after add_to_update above.
    // if(c_style->display != display_none && c_style->display != display_inline)
    // check_layout(v); -- don't need check layout here - it's too early.

    v.on_style_resolved(this, prev_style);

#if 0
    exec_assigned(v);
#endif

    // [SSX] check value requested by SSX
    tool::value initial_value;
    if (delayed_value(initial_value))
      v.set_element_native_value(this, initial_value, true); //set_value(v, initial_value, true);

    if (c_style == element::null_style)
      v.to_update.queue(&v, this, RESOLVE_STYLE);

    //flags.style_assignment = 0;

    if (!this->is_document()) state.ready(true);
    // document will get ready state at the end of load - immediately before
    // self.ready() call.

    if(c_style->cursor != prev_style->cursor)
      v.to_update.require_touch_mouse = true;

    /*if (flags.need_style_update) {
      //if (style_content) style_content->clear_style();
      //d_style = c_style = null_style;
      v.to_update.add(&v, this, RESET_STYLE);
      flags.need_style_update = 0;
    }*/
  }

  void element::refresh(view &v) {
    element *boxed_element = nearest_known_box();
    if (boxed_element) {
      rect rc = boxed_element->rendering_box(v) | boxed_element->hit_box(v);
      v.refresh(boxed_element, rc);
    }
  }

  STYLE_CHANGE_TYPE changes(const style *s1, const style *s2) {
    if (s1 == s2) return NO_CHANGES;
    if (s1->changes_model(*s2)) return CHANGES_MODEL;
    if (s1->changes_position(*s2)) return CHANGES_POSITION;
    if (s1->changes_dimension(*s2)) return CHANGES_DIMENSION;
    return styles_are_different(s1, s2) ? CHANGES_VISUAL : NO_CHANGES;
  }

  STYLE_CHANGE_TYPE changes(const style *s1) {
    if (s1->changes_model()) return CHANGES_MODEL;
    if (s1->changes_position()) return CHANGES_POSITION;
    if (s1->changes_dimension()) return CHANGES_DIMENSION;
    return CHANGES_VISUAL;
  }

#if 0
  void element::exec_assigned(view &v) {
    if (!flags.assigned_running && c_style->act_assigned && (d_style->act_assigned != this->last_act_assigned)) {
      flags.assigned_running  = 1;
      this->last_act_assigned = d_style->act_assigned;
      event dummy(0, 0);
      eval_action(v, dummy, d_style->act_assigned);

      if (d_style == null_style) // style was cleared by eval_action
        determine_style(v, doc(), false, true);

      flags.assigned_running = 0;
      // All above used to be this:
      //{
      //  internal_event_behavior evt(
      //  const_cast<element*>(this),const_cast<element*>(this),INVOKE_ACT_ASSIGNED,0);
      //  v.post_behavior_event(evt, true );
      //}
      // dealying this creates non-desired effects in animations.
    } else
      this->last_act_assigned = c_style->act_assigned;
  }
#endif

  element *element::get_event_owner() {

    if (state.popup()) {
      if (view* pv = pview()) {
        // anchor
        if (element* pa = pv->popup_anchor(const_cast<element*>(this)))
          return pa;
      }
      return parent;
    }

    element* o = event_owner;
    if (o && o->is_connected())
      return o;

    return parent;
  }

  element *element::drop_layout(view *pv) {
    if (!flags.layout_ctl_valid)
      return this;
    ldata->drop();
    flags.layout_ctl_valid = 0;
    flags.marker_layout_valid = 0;
    flags.shadow_layout_valid = 0;
    return this;
  }

  void element::drop_layout_tree(view *pv, bool and_drop_cache) {
    if (and_drop_cache)
      drop_cache();
    else if (!this->flags.layout_ctl_valid && c_style == null_style)
      return; // don't do shortcut if and_drop_cache is defined

    if ((c_style != null_style) && c_style->is_display_none() && !and_drop_cache)
      return;

    if (ldata->fctx && !ldata->fctx->is_empty() && pv) {
      ldata->fctx->reset(*pv);
    }

    each_any_child([pv,and_drop_cache](element *el) -> bool {
      // wrong: if(el->flags.layout_ctl_valid) - drop_layout_tree clears also
      // styles.
      el->drop_layout_tree(pv, and_drop_cache);
      return false;
    });
    lang = ustring();
    theme = ustring();
    drop_layout(pv);
    clear_style();
  }

  void element::broadcast(view &v, event_behavior &evt) {
    if (evt.target != this) {
      if (on(v, evt)) return;
    }
    each_any_child([&](element *el) -> bool {
      el->broadcast(v, evt);
      return false;
    });
  }

#if defined(SCITER) || defined(SCITERJS)
  void  element::check_prototypes_tree(view& v) {
    const html::style *cs = get_style(v);
    if (cs->prototype.length() || cs->handler_list.defined())
      v.on_style_resolved(this, p_style);
    each_any_child([&v](element *el) -> bool {
      if (!el->is_document()) // don't go inside child documents
        el->check_prototypes_tree(v);
      return false;
    });
  }
#endif

  bool stops_layout_propagation(element *el) {
    if (el->state.popup() || el->airborn) return true;
    if (el->c_style == element::null_style) return false;
    return el->c_style->stops_layout_propagation();
  }

  void element::drop_content_layout(view *pv) {

    if (c_style == null_style) return;
    if (!ldata) return;
    if (!ldata->is_valid()) {
      drop_minmax_dim();
      return;
    }
    drop_minmax_dim();
    // for floats we have to drop all children of BFC
    if (ldata->fctx && !ldata->fctx->is_empty() && pv) {
      each_element it(this); // BUT NOT each_ui_element - may walk in loops!
      for (element *cel; it(cel);) {
      // cel->drop_content_layout(pv);
#pragma TODO("investigate why this is required")
        cel->ldata->inner_dim.x = 0;
      }
      ldata->fctx->reset(*pv);
    }
  }

  bool element::is_layout_valid() {
    if (c_style == null_style) return false;
    if (!ldata) return false;
    if (!ldata->is_valid()) return false;
    return true;
  }
  bool element::is_x_minmax_valid() {
    if (c_style == null_style) return false;
    if (!ldata) return false;
    return ldata->dim_min.x.is_defined() && ldata->dim_max.x.is_defined();
  }
  bool element::is_y_minmax_valid() {
    if (c_style == null_style) return false;
    if (!ldata) return false;
    return ldata->dim_min.y.is_defined() && ldata->dim_max.y.is_defined();
  }

  void element::drop_minmax_dim() {
#ifdef _DEBUG
    if (is_id_test())
      ldata = ldata;
#endif
    if (ldata) ldata->drop_minmax_dim();
  }

  bool element::on_data_arrived(view &v, pump::request *rq) {
    v.on_element_data_arrived(this, rq);
    if (rq->data_type == DATA_HTML && !rq->consumed) {
      helement t(this);
      rq->consumed = true;
      v.set_element_html(t, rq->data(), SE_REPLACE, rq->url);
    }
    if (parent) parent->on_data_arrived(v, rq);

    return false;
  }

  bool element::on_data_request(view &v, pump::request *rq) {
    if (parent) parent->on_data_request(v, rq);
    return v.on_element_data_request(this, rq);
  }

  void element::attach_behavior(view &v, const string &name) {
    handle<ctl> cp = v.create_behavior_for(this, name);
    if (cp) {
      if (cp->is_ext() && behavior && !behavior->is_ext()) {
        // native behaviors are always the very firts ones
        cp->next       = behavior->next;
        behavior->next = cp;
      } else {
        cp->next = behavior;
        behavior = cp;
      }
      element *self = const_cast<element *>(this);
      if (!cp->attach(v, self)) {
        this->detach_behavior(v, cp);
        if (this->is_it_visible(v))
          view::debug_printf(OT_DOM, OS_ERROR,
                             "Creation of behavior %s was rejected by <%S> "
                             "element. Wrong DOM model.\n",
                             name.c_str(), report().c_str());
      }
    }
  }

  void element::attach_behavior(view &v, ctl *pc) {
    ctl *t    = behavior;
    ctl *last = 0;
    while (t)
      if (t == pc)
        return;
      else if (t->next == 0) {
        last = t;
        break;
      } else
        t = t->next;

    element *self = const_cast<element *>(this);

    if (last)
      last->next = pc;
    else
      behavior = pc;

    pc->next = 0;

    bool r = pc->attach(v, self);
    assert(r);
    r = r;
  }

  void element::detach_named_behavior(view &v, const string &name) {
    behavior_h cp = behavior;
    behavior_h prevcp;
    behavior_h nextcp;
    while (cp) {
      if (cp->behavior_name() == name && !cp->is_intrinsic()) {
        nextcp = cp->next;
        cp->detach(v, const_cast<element *>(this));
        break;
      }
      prevcp = cp;
      cp     = cp->next;
    }
    if (prevcp)
      prevcp->next = nextcp;
    else
      behavior = nextcp;
  }

  void element::get_behavior_names(array<string> &names) {
    ctl *pbh = behavior;
    while (pbh) {
      if (pbh->behavior_name().length() && pbh->behavior_name()[0] != ' ')
        names.push(pbh->behavior_name());
      pbh = pbh->next;
    }
  }

  ctl *element::get_named_behavior(const string &name) const {
    ctl *pbh = behavior;
    while (pbh) {
      if (pbh->behavior_name() == name) return pbh;
      pbh = pbh->next;
    }
    return 0;
  }


  uint element::behavior_count() const {
    uint cnt = 0;
    ctl *pbh = behavior;
    while (pbh) {
      ++cnt;
      pbh = pbh->next;
    }
    return cnt;
  }

  ctl *element::behavior_no(uint n) const {
    uint cnt = 0;
    ctl *pbh = behavior;
    while (pbh) {
      if (cnt++ == n) return pbh;
      pbh = pbh->next;
    }
    return 0;
  }

  ctl *element::get_behavior(CTL_TYPE t1, CTL_TYPE t2) const {
    ctl *pbh = behavior;
    while (pbh) {
      CTL_TYPE ct = pbh->get_type();
      if (ct == t1) return pbh;
      if (t2 && (ct == t2)) return pbh;
      pbh = pbh->next;
    }
    return 0;
  }

  void element::each_behavior(function<bool(ctl *)> f) const {
    handle<ctl> pbh = behavior;
    while (pbh) {
      if (f(pbh)) return;
      pbh = pbh->next;
    }
  }

  selection_ctx *element::get_selection_ctx() const {
    ctl *pbh = behavior;
    while (pbh) {
      selection_ctx *sc = pbh->get_selection_ctx();
      if (sc) return sc;
      pbh = pbh->next;
    }
    return parent ? parent->get_selection_ctx() : 0;
  }

  void element::detach_behavior(view &v, ctl *pc) {
    behavior_h cp = behavior;
    behavior_h prevcp;
    behavior_h nextcp;
    while (cp) {
      if (cp == pc) {
        nextcp = cp->next;
        cp->detach(v, this);
        break;
      }
      prevcp = cp;
      cp     = cp->next;
    }
    if (prevcp)
      prevcp->next = nextcp;
    else
      behavior = nextcp;
  }

  void element::detach_behaviors(view &v) {
    behavior_h cp = behavior;
    behavior      = 0;
    while (cp) {
      behavior_h tcp = cp->next;
      cp->detach(v, this);
      // delete behavior; - behavior shall delete itself in 'detach' if needed
      cp = tcp;
    }
    //#pragma TODO("on_element_lost_behaviors")
    // v.on_element_lost_behaviors(this);
  }

  string element::behavior_name() const {
    if (behavior) return behavior->behavior_name();
    return string();
  }

  bool element::get_caret_location(view &v, rect &r) {
    ctl *pbh = behavior;
    while (pbh) {
      if (pbh->get_caret_place(v, this, r)) return true;
      pbh = pbh->next;
    }
    return false;
  }

#if defined(SCITERJS)
  bool element::set_value(view &v, const value &val, bool ignore_text_value) {
    return v.set_element_native_value(this, val, ignore_text_value);
  }
  bool element::get_value(view &v, value &val, bool ignore_text_value) {
    return v.get_element_native_value(this, val, ignore_text_value);
  }
#else
  bool element::set_value(view &v, const value &val, bool ignore_text_value) {
    return v.set_element_value(this, val, ignore_text_value);
  }
  bool element::get_value(view &v, value &val, bool ignore_text_value) {
    return v.get_element_value(this, val, ignore_text_value);
  }
#endif

  bool element::get_attr_value(tool::value& val) {
    ustring us;
    if (!atts.exist(attr::a_value, us))
      return false;

    ustring as = atts(attr::a_as);
    if (as.is_defined()) {
      if (as == WCHARS("string"))
        val = value::parse_string(us);
      else if (as == WCHARS("integer"))
        val = value::parse_integer(us);
      else if (as == WCHARS("float"))
        val = value::parse_float(us);
      else if (as == WCHARS("numeric"))
        val = value::parse_numeric(us);
      else // "auto", "any"
        val = value::parse(us);
      if (val.is_undefined())
        val = value(us);
   } else
      val = value(us);
   return true;
 }

  bool element::default_set_value(view &v, const value &val,bool ignore_text_value) {

    if (tag == tag::T_INPUT) {
      set_attr(attr::a_value, val.to_string(),&v);
      return true;
    }
    else if (tag == tag::T_OPTION/* && atts.exist(attr::a_value)*/) {
      set_attr(attr::a_value, val.to_string(),&v);
      return true;
    }
    else if (!ignore_text_value) {
      ustring us = val.to_string();
      this->set_text(v, us);
      return true;
    }
    return false;
  }

  bool element::default_get_value(view &v, value &val, bool ignore_text_value) {
    if (get_attr_value(val))
      return true;
    if (!ignore_text_value) {
      val = value(this->get_text(v));
      return true;
    }
    return false;
  }

  bool element::wants_keyboard(view &v) {
    helement el = this;
    el->get_style(v); // to force style to be resolved
    behavior_h pc = el->behavior;
    while (pc) {
      if (pc->wants_keyboard(this)) return true;
      pc = pc->next;
    }
    return false;
  }

  point element::pos() const {
    // assert(ldata);
    return ldata ? ldata->pos : point();
  }
  size element::dim() const {
    assert(ldata);
    return ldata ? ldata->dim : size();
  }
  size element::content_dim() const {
    assert(ldata);
    size sz;
    if (ldata) {
      sz.x = ldata->dim_min.x;
      sz.y = ldata->dim_min.y;
    }
    return sz;
  }

  void element::set_pos(point p) {
    assert(ldata);
    if (ldata) ldata->pos = p;
  }

  void element::set_x_pos(int p) {
    assert(ldata);
    if (ldata) ldata->pos.x = p;
  }

  void element::set_y_pos(int p) {
    assert(ldata);
    if (ldata) ldata->pos.y = p;
  }

  void element::set_border_pos(point p) // p here is top/left of border box
  {
    assert(ldata);
    if (ldata) {
      p.x += ldata->borpad_left();
      p.y += ldata->borpad_top();
      ldata->pos = p;
    }
  }

  void element::set_border_dim(size s)
  {
    assert(ldata);
    if (ldata) {
      s.x -= ldata->borpad_left();
      s.y -= ldata->borpad_top();
      s.x -= ldata->borpad_right();
      s.y -= ldata->borpad_bottom();
      ldata->dim = s;
    }
  }


  void element::set_cell_pos(point p,
                             bool collapsed) // p here is top/left of border box
  {
    assert(ldata);
    if (c_style->display == display_table_cell)
    {
      if (collapsed) {
        // p.x += div2d(ldata->borpad_left());
        // p.y += div2d(ldata->borpad_top());
        p.x += div2d(ldata->border_width.left()) + ldata->padding_width.left();
        p.y += div2d(ldata->border_width.top()) + ldata->padding_width.top();

      }
      else {
        p.x += ldata->borpad_left();
        p.y += ldata->borpad_top();
      }
      ldata->pos = p;
    }
    else {
      ldata->pos += p;
    }

  }

  void element::set_margin_pos(point p) // p here is top/left of border box
  {
    assert(ldata);
    if (ldata) {
      p.x += ldata->borpad_left() + ldata->margin_width.s.x;
      p.y += ldata->borpad_top() + ldata->margin_width.s.y;
      ldata->pos = p;
    }
  }

  void element::set_dim(size s) {
    assert(ldata);
    if (ldata) ldata->dim = s;
  }

  int element::set_width(view &v, int width) {
#ifdef _DEBUG
    if (is_id_test()) {
      width = width;
    }
#endif

    if (airborn && airborn->dim.x.is_defined()) {
      width        = airborn->dim.x;
      ldata->dim.y = airborn->dim.y;
    }

    if (ldata->inner_dim.x != width)
      v.on_element_client_size_changing(this, true, width);

    if (flags.delayed_measurement) {
      ldata->dim.x = width;
      return ldata->dim.y;
    } else if (c_style->overflow() > overflow_visible && flags.need_delayed_measurement) {
      ldata->dim.x = width;
      if (!flags.delayed_measurement) {
        flags.delayed_measurement = 1;
        v.start_timer(this, DELAYED_MEASURE_TIMER_MS, DELAYED_MEASURE_TIMER_ID,
                      INTERNAL_TIMER);
        // v.post( delegate(this, &element::do_delayed_measure), true);
      }
      if (airborn && airborn->dim.y.is_defined()) {
        ldata->dim.y = airborn->dim.y;
        return airborn->dim.y;
      }
      return ldata->dim.y;
    } else {
      check_layout(v);
      //if (ldata->dim.x != width)
      int h = layout_width(v, width);
      if (airborn && airborn->dim.y.is_defined()) {
        ldata->dim.y = airborn->dim.y;
        return airborn->dim.y;
      }
      return h;
    }
  }

  struct size_change_notifier : public tool::functor {
    view &          v;
    handle<element> el;
    size_change_notifier(view &v_, element *el_) : v(v_), el(el_) {}
    virtual bool operator()() // returns 'true' if complete
    {
      if (v.is_painting)
        return false; // do not generate onSize notifications while painting.
      if (!el->is_layout_valid()) {
        el->flags.awaiting_on_size_handling = 0;
        return true;
      }
      //el->dbg_report("size_change_notifier");
      v.on_element_client_size_changed(el);
      el->flags.awaiting_on_size_handling = 0;
      return true;
    }
  };

  INLINE void notify_size_changed(view &v, element *el) {
    el->ldata->used_dim = el->ldata->inner_dim;
    el->flags.marker_layout_valid = false;
    el->flags.shadow_layout_valid = false;

    if (!v.may_have_on_size_handler(el)) return;

    if (!el->flags.awaiting_on_size_handling/* && v.may_have_on_size_handler(el)*/)
    {
      el->flags.awaiting_on_size_handling = 1;
      v.post(new size_change_notifier(v, el), true);
    }
  }

  int element::set_height(view &v, int height) {
#ifdef _DEBUG
    if (is_id_test())
      height = height;
    //if (is_document() && !parent) {
    //  dbg_printf("doc height %d\n", height);
    //  if(height < ldata->dim.y)
    //    height = height;
    //}
#endif // _DEBUG

    if (ldata->used_dim.y != height)
      v.on_element_client_size_changing(this, false,height);

    if (flags.delayed_measurement) {
      ldata->dim.y = height;
      return ldata->dim.x;
    }

    int w = layout_height(v, height);
    ldata->zctx.replace(v, this);
    if ((c_style->want_scrollbars() || ldata->sb.has_external_scrollbars()))
      update_scrollbars(v);
    if (ldata->used_dim != ldata->inner_dim)
      notify_size_changed(v, this);

    return w;
  }

  void element::replace_css_element(view& v, element* shadow_element)
  {
    hstyle mcs = shadow_element->get_style(v);
    assert(mcs != null_style);
    size sz = this->padding_box(v).size();
    replace_h(v, shadow_element, sz.x, true, mcs->horizontal_align);
    replace_v(v, shadow_element, sz.y, true, mcs->get_block_vertical_align());
    shadow_element->set_pos(shadow_element->pos() - this->padding_distance(v).s);
    if (mcs->position) {
      if(element *pp = shadow_element->check_positioned_containment(v))
        pp->drop_positioned(); // nullptr is the must, otherwise stack overflow
    }
  }

  bool element::do_delayed_measure(view &v) {
#ifdef _DEBUG
    //dbg_report("element::do_delayed_measure\n");
    //if (tag == tag::T_HTML) {
    //  flags.delayed_measurement = flags.delayed_measurement;
    //  dbg_printf("HTML delayed measure %d %d\n", ldata->dim.x, ldata->dim.y);
    //}
#endif
    assert(flags.delayed_measurement);
    flags.delayed_measurement = 0;
    size dim                  = ldata->dim;
    layout_width(v, dim.x);
    layout_height(v, dim.y);
    ldata->zctx.replace(v, this);
    if (c_style->want_scrollbars() || ldata->sb.has_external_scrollbars())
      update_scrollbars(v);
    if (ldata->used_dim != ldata->inner_dim) notify_size_changed(v, this);
    v.refresh(this);
    event_behavior evt(this, this, UI_STATE_CHANGED, 0);
    v.post_behavior_event(evt, true);
    return true;
  }

  void element::set_border_width(view &v, int width) {
    set_width(v, width - ldata->borpad_left() - ldata->borpad_right());
  }
  void element::set_border_height(view &v, int height) {
    set_height(v, height - ldata->borpad_top() - ldata->borpad_bottom());
  }

  void element::set_cell_width(view &v, int width, bool collapsed) {

    const style* cs = get_style(v);
    if (cs->display == display_table_cell)
    {
      if (collapsed)
        set_width(v, width - // div2u(ldata->borpad_left()) -
                             // div2d(ldata->borpad_right()));
          ldata->padding_width.s.x -
          ldata->padding_width.e.x -
          div2u(ldata->border_width.s.x) -
          div2d(ldata->border_width.e.x));
      else
        set_width(v, width - ldata->borpad_left() - ldata->borpad_right());
    }
    else {
#ifdef _DEBUG
      if (tag == tag::T_SELECT)
        width = width;
#endif
      replace_h(v, this, width, true, cs->horizontal_align.val(align_start));
    }

  }
  void element::set_cell_height(view &v, int height, bool collapsed) {
    const style* cs = get_style(v);
    if (cs->display == display_table_cell)
    {
      if (collapsed)
        set_height(v, height - // div2u(ldata->borpad_top()) -
                               // div2d(ldata->borpad_bottom()));
          ldata->padding_width.s.y -
          ldata->padding_width.e.y -
          div2u(ldata->border_width.s.y) -
          div2d(ldata->border_width.e.y));

      else
        set_height(v, height - ldata->borpad_top() - ldata->borpad_bottom());
    }
    else {
#ifdef _DEBUG
       if (tag == tag::T_LABEL)
          parent = parent;
#endif
       replace_v(v, this, height, true);
    }

  }

  void element::set_cell_width_nm(view &v, int width, bool collapsed) {
    get_style(v);
    check_layout(v);
    if (collapsed)
      ldata->dim.x =
          width - // div2u(ldata->borpad_left()) - div2d(ldata->borpad_right());
          ldata->padding_width.s.x - ldata->padding_width.e.x -
          div2u(ldata->border_width.s.x) -
          div2d(ldata->border_width.e.x);
    else
      ldata->dim.x = width - ldata->borpad_left() - ldata->borpad_right();
  }
  void element::set_cell_height_nm(view &v, int height, bool collapsed) {
    get_style(v);
    check_layout(v);
    if (collapsed)
      ldata->dim.y = height - // div2u(ldata->borpad_top()) -
                              // div2d(ldata->borpad_bottom());
                     ldata->padding_width.s.y -
                     ldata->padding_width.e.y -
                     div2u(ldata->border_width.s.y) -
                     div2d(ldata->border_width.e.y);
    else
      ldata->dim.y = height - ldata->borpad_top() - ldata->borpad_bottom();
    do_h_align(v);
  }

  bool element::do_h_align(view &v) {
    hstyle cs = get_style(v);

    if (cs->overflow_x >= overflow_scroll) {
      ldata->offset.x = 0;
      return false;
    }

    rect crect = client_rect(v);
    size inner = crect.size();

    if (ldata->dim_min.x < inner.x) {
      ldata->offset.x = 0;
      return false;
    }

    int freespace_h = inner.x - ldata->dim_min.x;

    halign_e halign = cs->get_horizontal_align();
    switch (halign) {
    case align_left:
      ldata->offset.x = 0;
      break; // already here
    case align_right: ldata->offset.x = -freespace_h; break;
    case align_center: ldata->offset.x = -freespace_h / 2; break;
    default: break;
    }
    return true;
  }
  bool element::do_v_align(view &v) {
    hstyle cs = get_style(v);

    int freespace_v = ldata->inner_dim.y - ldata->dim_min.y;

    auto valign = cs->get_block_vertical_align();
    if (cs->display == display_inline_block || cs->display == display_inline)
      valign = valign_top;

    if (freespace_v <= 0 && cs->overflow_y >= overflow_scroll)
      return true;
    else
      switch (valign) {
        default:
        case valign_top:
          ldata->offset.y = 0;
          break; // already here
        case valign_bottom:
          ldata->offset.y = -freespace_v;
          break;
        case valign_middle:
          ldata->offset.y = -freespace_v / 2;
          break;
      }
    return true;
  }

  element *node::find_common_parent(node *b1, node *b2) {
    if (b1 == b2) {
      if (!b1) return 0;
      return b1->parent;
    }

    array<node *> s1;
    array<node *> s2;

    node *t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->parent;
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->parent;
    }

    node *r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); i++) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    assert(!r || r->is_element());
    if (!r) return nullptr;
    return r->is_element() ? static_cast<element *>(r) : r->doc();
  }

  element *node::find_common_owner(node *b1, node *b2) {
    if (b1 == b2) {
      if (!b1) return 0;
      return b1->get_owner();
    }

    array<node *> s1;
    array<node *> s2;

    node *t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->get_owner();
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->get_owner();
    }

    node *r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); i++) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    assert(r && r->is_element());
    if (!r) return 0;
    return r->is_element() ? static_cast<element *>(r) : r->doc();
  }

  node *node::find_base(node *b1, node *b2) {
    if (b1 == b2) return b1;

    array<node *> s1;
    array<node *> s2;

    node *t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->parent;
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->parent;
    }

    node *r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); i++) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    return r;
  }

  element *element::find_common_parent(element *b1, element *b2) {
    if (b1 == b2) {
      if (!b1) return 0;
      return b1->parent;
    }

    array<element *> s1;
    array<element *> s2;

    element *t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->parent;
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->parent;
    }

    element *r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); i++) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    return r;
  }

  element *element::find_common_ui_parent(view &v, element *b1, element *b2) {
    if (b1 == b2) {
      if (!b1) return nullptr;
      return b1->get_owner();
    }

    if (!b1 || b1->pview() != &v) return nullptr;
    if (!b2 || b2->pview() != &v) return nullptr;

    array<helement> s1;
    array<helement> s2;

    helement t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->ui_parent(v);
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->ui_parent(v);
    }

    helement r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); i++) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    return r;
  }

  element *element::find_base(element *b1, element *b2) {
    if (b1 == b2) {
      if (!b1) return 0;
      return b1;
    }

    array<element *> s1;
    array<element *> s2;

    element *t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->parent;
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->parent;
    }

    element *r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); ++i) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    return r;
  }

  element *element::find_ui_base(element *b1, element *b2) {
    if (b1 == b2) {
      if (!b1) return 0;
      return b1;
    }

    array<element *> s1;
    array<element *> s2;

    element *t = b1;
    while (t) {
      s1.insert(0, t);
      t = t->get_owner();
    }
    t = b2;
    while (t) {
      s2.insert(0, t);
      t = t->get_owner();
    }

    element *r = 0;
    for (int i = 0; i < min(s1.size(), s2.size()); ++i) {
      if (s1[i] != s2[i]) break;
      r = s1[i];
    }
    return r;
  }

  element *element::find_common_parent(element *b1, element *b2,
                                       int layout_type) {
    element *b = find_common_parent(b1, b2);
    while (b)
      if (b->layout_type() == layout_type)
        return b;
      else
        b = b->parent;
    return 0;
  }

  /*bool element::get_attr(const char* name, ustring& val)
  {
    assert(name[0] == '-');
    hstyle cs = get_style();
    if(atts.get(name+1,val))
      return true;
    tool::value v;
    if(cs->get_custom_attr(name, v))
    {
      val = v.to_string();
      return true;
    }
    return false;
  }*/

  iwindow *element::window(view &v) {
    return v.get_iwindow_of(this);

    /*iwindow* pw;


    if( flags.has_window && behavior )
    {
      ctl* pc = behavior;
      if( pc->get_window(pw))
        return pw;
      pc = pc->next;
    }
    return 0;*/
  }

  graphics *element::surface(view &v, point &offset_on_surface) {
    element *w = get_windowed_container(v, true);
    if (!w) return 0; // stop it

    iwindow *pwnd = w->get_window(v, true);
    if (!pwnd) return 0;

    offset_on_surface = this->view_pos(v) - w->view_pos(v);
    return pwnd->surface();
  }

  element *element::create_context_menu(view &v, const string &url,
                                        event_behavior &evt) {
    // array<byte> utf;
    document *pd = doc();
    if (!pd) return 0;

    handle<pump::request> rq = new pump::request(url, DATA_HTML);
    rq->dst                  = this;
    rq->initiator            = this;

    if (v.load_data(rq, true) && rq->data.size()) {
      helement he = this;
      if (v.construct_element_from_html(rq->data(), he)) {
        he->state.synthetic(true);
        //???? evt.target = this;
        evt.source = he;
        pd->register_popup(v, he);
        return he;
      }
    }
    return 0;
  }

  void element::accept_image(view &v, const image_ref &ir) {
    hstyle cs = get_style(v);
#ifdef _DEBUG
    if (tag == tag::T_PICTURE) cs = cs;
#endif
    if (cs->fore_image.id == ir || cs->back_image.id == ir)
      v.add_to_update(this, CHANGES_VISUAL);
    ctl *pc = this->behavior;
    while (pc) {
      pc->accept_image(v, this, ir);
      pc = pc->next;
    }
  }

  void element::used_images(view &                                        v,
                            function<void(const string &url, image *img)> cb) {
    hstyle cs   = get_style(v);
    himage pimg = this->get_fore_image(v);
    if (pimg) cb(pimg->get_url(), pimg);
    pimg = this->get_back_image(v);
    if (pimg) cb(pimg->get_url(), pimg);

    html::each_child it(this);
    for (element *ch; it(ch);)
      used_images(v, cb);

    // if (cs->fore_image.id.img())
    //  cb(cs->fore_image.id.url(), cs->fore_image.id.img());
    // if (cs->back_image.id.img())
    //  cb(cs->back_image.id.url(), cs->back_image.id.img());
  }

  ustring element::get_text(view &v) {
    behavior_h pc = behavior;
    if (pc) {
      ustring us;
      while (pc) {
        if (pc->get_text(v, this, us)) return us;
        pc = pc->next;
      }
    }
    if (nodes.size() == 0) return wchars();
    if (nodes.size() == 1 && nodes[0]->is_text())
      // simple element containing one text node
      return nodes[0].ptr_of<text>()->chars();
    array<wchar> text_buffer;
    emit_text(text_buffer,true);
    return text_buffer();
  }

  void element::get_ui_text(view &v, array<wchar> &out) {
    each_ui_child([&out, &v](element *el) -> bool {
      el->get_ui_text(v, out);
      return false;
    });
  }

  void element::emit_text(array<wchar> &to, bool verbose) {
    ustring alt;
    if (tag == tag::T_BR)
      to.push(WCHARS("\r\n"));
    else if( atts.exist(attr::a_alt,alt))
      to.push(alt);
    else if (!verbose && is_atomic_box() && (this->first_element() || this->nodes.length() == 0)) {
      ustring val = atts.get_ustring(attr::a_value);
      to.push(val());
    } else {
      // WTF? if(to.size() && !::is_space(to.last()))
      //  to.push(' ');
      for (int n = 0; n < nodes.size(); ++n) {
        if (!nodes[n]->is_comment()) nodes[n]->emit_text(to,verbose);
      }
    }
  }

  void element::set_text_value(view &v, wchars t) {
    behavior_h pc = behavior;
    if (pc) {
      while (pc) {
        if (pc->set_text(v, this, t)) return;
        pc = pc->next;
      }
    }
    refresh(v);
    nodes.clear();
    append(new text(t), &v);
    // v.add_to_update(this,CHANGES_MODEL);
  }

  void element::set_html_value(view &v, bytes html) {
    helement   self = this;
    behavior_h pc   = behavior;
    while (pc) {
      if (pc->set_html(v, this, html)) return;
      pc = pc->next;
    }
    v.set_element_html(self, html, html::SE_REPLACE);
  }


  void element::set_text(view &v, wchars t) {
    nodes.clear();
    // drop_layout();
    append(new text(t), &v);
    // v.add_to_update(this,CHANGES_MODEL);
  }

  bool element::get_attr(const char *name, ustring &val) const {
    assert(name[0] == '-');
    hstyle cs = get_style();
    if (atts.get(name + 1, val)) return true;
    tool::value v;
    if (cs->get_custom_attr(name, v)) {
      val = v.to_string();
      return true;
    }
    return false;
  }

  bool element::has_attr(const char *name) const {
    ustring dummy;
    return get_attr(name, dummy);
  }

  bool element::call_behavior_method(view &v, method_params *p) {
    behavior_h pc = behavior;
    while (pc) {
      if (pc->will_handle(HANDLE_METHOD_CALL) &&
          pc->handle_method_call(v, this, p))
        return true;
      behavior_h next = pc->next;
      pc              = next;
    }

    if (p->method_id == DO_CLICK && is_focusable(v)) v.set_focus(this, BY_CODE);

    return false;
  }


  void element::post_custom_event(view &v, const ustring &name,
                                  uint_ptr reason) {
    event_behavior evt(this, this, CUSTOM, reason);
    evt.name = name;
    v.post_behavior_event(evt, true);
  }

  bool element::send_custom_event(view &v, const ustring &name,
                                  uint_ptr reason) {
    event_behavior evt(this, this, CUSTOM, reason);
    evt.name = name;
    return v.send_behavior_event(evt);
  }

  CTL_TYPE element::ctl_type(view &v) {
    get_style(v);
    return ctl_type();
  }

  CTL_TYPE element::ctl_type() const {
    behavior_h pc = behavior;
    while (pc) {
      CTL_TYPE ct = pc->get_type();
      if (ct != CTL_UNKNOWN) return ct;
      pc = pc->next;
    }
    if (state.popup() && atts(attr::a_role, W("")) == WCHARS("tooltip"))
      return CTL_TOOLTIP;
    else if ((tag == tag::T_INPUT || tag == tag::T_WIDGET) &&
             atts(attr::a_type, W("")) == WCHARS("hidden"))
      return CTL_HIDDEN;
#ifdef SCITER
    if (obj) return CTL_UNKNOWN;
#endif
    return CTL_NO;
  }

  void element::line_no(int ln) {
    line_no_holder *ph = new line_no_holder;
    ph->val            = ln;
    meta.push(ph);
  }

  int_v element::line_no() const {
    int_v val;
    html::each_resource<line_no_holder>(
        this->meta, [&val](const line_no_holder *it) -> bool {
          val = it->val;
          return true;
        });
    return val;
  }

  void element::delay_value(tool::value val)
  {
    value_holder *ph = new value_holder;
    ph->val = val;
    meta.push(ph);
  }
  bool element::delayed_value(tool::value& val)
  {
    bool found = html::each_resource<value_holder>(
      this->meta, [&val](const value_holder *it) -> bool { val = it->val; return true;});
    if( found )
      html::remove_resource<value_holder>(this->meta);
    return found;
  }


  void element::sequential_id(string id) {
    sequential_id_holder *ph = new sequential_id_holder;
    ph->val                  = id;
    meta.push(ph);
  }

  string element::sequential_id() const {
    ustring val;
    html::each_resource<sequential_id_holder>(
        this->meta, [&val](const sequential_id_holder *it) -> bool {
          val = it->val;
          return true;
        });
    return val;
  }

  const style_set_holder*  element::forced_style_set() const
  {
    static handle<style_set_holder> null = new style_set_holder;
    if(forced_style_set_holder.is_defined())
      return forced_style_set_holder == null ? nullptr : forced_style_set_holder;
    if (parent) {
      forced_style_set_holder = parent->forced_style_set();
    }
    if (!forced_style_set_holder) {
      forced_style_set_holder = null;
      return nullptr;
    } else
      return forced_style_set_holder;
  }

  void element::forced_style_set(const string& name, const string& cssurl, bool important)
  {
    forced_style_set_holder = new style_set_holder;
    forced_style_set_holder->name = name;
    forced_style_set_holder->url = cssurl;
    forced_style_set_holder->important = important;
    forced_style_set_holder->owner = uint_ptr(this);
  }

  void element::forced_style_set(const style_set_holder* ph)
  {
    if (forced_style_set_holder && (forced_style_set_holder->owner != uint_ptr(this)))
      forced_style_set_holder = ph;
  }


  bookmark element::find_text_pos(view &v,
                                  point zpos /*at is owner relative*/) {
    element *cel = find_element(v, zpos, false);
    assert(cel);
    while (cel && cel != this) {
      if (cel->is_block_element(v)) {
        return cel->find_text_pos(v, zpos - cel->rel_pos(v, this));
      }
      cel = cel->get_owner();
    }
    // return this_pos( zpos.x > ldata->dim.x / 2);
    // return bookmark( this, zpos.y > ldata->dim.y  );
    rect hb = this->hit_box(v);
    return bookmark(this, 0, zpos.x >= hb.pointOf(5).x);
  }

  bool advance(view &v, element *self, bookmark &bm, ADVANCE_DIR cmd,
               point vpt) {
    helement holder = self;
    if (!self->is_layout_valid()) v.commit_update();
    bookmark temp = bm;
    if (self->advance(v, bm, cmd, vpt))
    {
      if (bm.node->belongs_to(self, false))
        return true;
      //switch (cmd) {
      //  case ADVANCE_LEFT:
      //}
    }
    bm = temp;
    return false;
  }

  bool element::advance_caret_pos(view &v, bookmark &bm, ADVANCE_DIR dir,
                                  array<wchar> *out) {
    wchar c;
    switch (dir) {
    case ADVANCE_RIGHT:
      if (get_style(v)->direction == direction_ltr)
        return advance_forward(bm, c);
      else
        return advance_backward(bm, c);
    case ADVANCE_LEFT:
      if (get_style(v)->direction == direction_ltr)
        return advance_backward(bm, c);
      else
        return advance_forward(bm, c);
    case ADVANCE_NEXT:
      return advance_forward(bm, c);
      /*if( !bm.after_it )
      {
        bm.after_it = true;
        return true;
      }
      assert(bm.node.ptr() == this);
      for(; bm.pos < nodes.size(); bm.pos = bm.pos + 1 )
        if( nodes[bm.pos]->is_element() )
        {
          bm = nodes[bm.pos]->start_caret_pos(v);
          return true;
        }
      bm = this_pos(true);
      break;*/

    case ADVANCE_PREV:
      return advance_backward(bm, c);
      /*
      if( bm.after_it )
      {
        bm.after_it = false;
        return true;
      }
      assert(bm.node.ptr() == this);
      for(bm.pos = bm.pos - 1; bm.pos >= 0; bm.pos = bm.pos - 1)
        if( nodes[bm.pos]->is_element() )
        {
          bm = nodes[bm.pos]->end_caret_pos(v);
          return true;
        }
      bm = this_pos(false);
      break;*/
    default:
      // assert(false);
      break;
    }
    return true;
  }

  bookmark element::start_caret_pos(view &v) const {
    bookmark pos = start_pos();
    // array<wchar> char_buf;
    // if(pos.advance_caret_pos(v,ADVANCE_NEXT,char_buf) && pos < end_pos())
    //  return pos;
    if(!is_atomic_box())
      while (const_cast<element *>(this)->advance(v, pos, ADVANCE_NEXT))
        if (pos.at_caret_pos(v)) return pos;
    return start_pos();
  }
  bookmark element::end_caret_pos(view &v) const {
    bookmark pos = end_pos();
    // array<wchar> char_buf;
    if (!is_atomic_box())
      while (const_cast<element *>(this)->advance(v, pos, ADVANCE_PREV))
        if (pos.at_caret_pos(v)) return pos;
    // if(pos.advance_caret_pos(v,ADVANCE_PREV,char_buf) && pos >= start_pos())
    //  return pos;
    return end_pos();
  }

  bookmark element::first_content_caret_pos(view &v) const {
/*    bookmark pos = start_pos();
    if (!is_atomic_box()) {
      while (!pos.at_char_pos(v)) {
        if (!const_cast<element *>(this)->advance(v, pos, ADVANCE_NEXT))
          break;
      }
      return pos;
    }*/
    pos_iterator iter(start_pos(), end_pos());
    for (bookmark pos; iter(pos);) {
      if (!pos.is_inside(this))
        continue;
      if (pos.at_caret_pos(v))
        return pos;
    }
    return start_pos();
  }
  bookmark element::last_content_caret_pos(view &v) const {
/*    bookmark pos = end_pos();
    if (!is_atomic_box())
      while (const_cast<element *>(this)->advance(v, pos, ADVANCE_PREV))
        if (pos.at_char_pos(v)) return pos;*/

    pos_iterator iter(start_pos(), end_pos(),false);
    for (bookmark pos; iter(pos);) {
      if (!pos.is_inside(this))
        continue;
      if (pos.at_caret_pos(v))
        return pos;
    }

    return end_pos();
  }


  int element::get_list_index() {
    // assert(bullet);
    if (!parent) return 0;

    int cnt = parent->atts.get_int(attr::a_start, 1) - 1;

    hstyle cs = get_style();

    element *t = this;

    while (t) {
      hstyle tcs = t->get_style();
      if (tcs->display != display_list_item) break;
      if (tcs->list_style_type != cs->list_style_type) break;
      int val = t->atts.get_int(attr::a_value, 0);
      if (val) return val + cnt - 1;
      ++cnt;
      t = t->prev_element();
    }
    return cnt;
  }

  bool in_static_flow(view &v, element *el) {
    const style *cs = el->get_style(v);
    if (cs->is_display_none()) return false;
    if (cs->visibility == visibility_collapse) return false;
    if (el->oof_positioned(v) || el->popup_positioned(v)) return false;
    return true;
  }

  bool element::get_first_line_metrics(view &v, int &y, int &height,
                                       int &ascent) {

    if (get_style(v)->overflow_y >= overflow_hidden) return false;

    return each_ui_child([&](element *el) -> bool {
      if (in_static_flow(v, el) &&
          el->get_first_line_metrics(v, y, height, ascent)) {
        y += el->rel_pos(v, this).y;
        return true;
      }
      return false;
    });
  }
  bool element::get_last_line_metrics(view &v, int &y, int &height,
                                      int &ascent) {
    style *cs = get_style(v);

    if (cs->overflow_y >= overflow_hidden) return false;

    if (tag == tag::T_BR) {
      font *pf = v.get_font(cs);
      y        = 0;
      ascent   = pf->ascent;
      height   = pf->height();
      return true;
    }

    return each_ui_child(
        [&](element *el) -> bool {
          if (in_static_flow(v, el) &&
              el->get_last_line_metrics(v, y, height, ascent)) {
            int  ry = el->rel_pos(v, this).y;
            rect od = el->outer_distance(v);
            height += od.bottom();
            y += ry;
            return true;
          }
          return false;
        },
        BACKWARD);
  }

  bool element::scan_floats(view &v, element *float_container) {
    if (!float_container) return false;
    if (!ldata) get_style(v);
    size pdim = ldata->inner_dim;
    uint n    = 0;

    child_iterator it(v, this);
    for (element *el; it(el);) {
      auto floats = el->floats(v);
      if (floats) {
        int y = this->rel_pos(v, float_container).y;
        premeasure(v, el, el->get_style(v), pdim);
        el->set_width(v, el->computed_width(v, pdim.x));
        el->set_height(v, el->computed_height(v, pdim.y));
        if (floats == float_left) {
          float_container->fctx(v, true)->push_left(v, y, el);
          ++n;
        } else if (floats == float_right) {
          float_container->fctx(v, true)->push_right(v, y, el);
          ++n;
        }
      } else if (el->scan_floats(v, float_container))
        ++n;
      return false; // continue enumerating
    };
    return n > 0;
  }

  void element::get_inline_block_metrics(view &v, int &ascent, int &descent,
                                         int &height) {
    // if( tag == tag::T_BR )
    //  ascent = ascent;

    ascent  = 0;
    descent = 0;
    height  = 0;
    switch (get_style(v)->get_text_vertical_align()) {
    case valign_sub:
    case valign_super:
    case valign_auto:
    case valign_baseline: {
      int y = 0, h = 0, a = 0;
      if (get_last_line_metrics(v, y, h, a)) {
        rect od = outer_distance(v);
        ascent  = y + a + od.top();
        descent = max(0, h - a) + od.bottom();
        if (this->is_box_element(v)) {
          height = min_height(v) + od.top() + od.bottom();
          if (height > ascent + descent) ascent = height - descent;
        }
      } else {
        rect md = this->ldata->margin_width;
        ascent  = this->min_height(v) + this->borpad_int_y_extra(v) + md.top();
        descent = md.bottom();
      }
    } break;
    case valign_text_top:
    case valign_text_bottom:
    case valign_top:
    case valign_middle:
    case valign_bottom:
      height = this->min_height(v) + this->outer_int_y_extra(v);
      break;
    }
  }

  int element::get_baseline_shift(view &v, element *parent_text_block) {
    int    shift = 0;
    style *cs    = get_style(v);
    if (parent && (cs->get_text_vertical_align() == valign_sub || cs->get_text_vertical_align() == valign_super)) {
      html::style *pps = parent->get_style(v);
      gool::font * ppf = v.get_font(pps);
      gool::font * ptf = v.get_font(cs);
      // ratios below match MS Word and GC but not FF and IE
      if (cs->get_text_vertical_align() == valign_super)
        shift -= ppf->x_height - ptf->x_height / 2 + 1;
      else
        shift += ptf->x_height / 2;
      if (parent != parent_text_block)
        shift += parent->get_baseline_shift(v, parent_text_block);
    }
    return shift;
  }

  void element::on_layout_set(
      view &v) // called immediately after the element got its layout controller
  {}

  /*bool element::is_active_dd_target(view& v, element* dragging)
  {
    if(dragging == this || v.dragging_source_element == this)
      return false;
    if(belongs_to(dragging,true) || belongs_to(v.dragging_source_element,true))
      return false;
    hstyle cs = get_style(v);
    ustring sel = cs->accept_drop;
    if( sel.length() == 0 || sel == WCHARS("none") )
      return false;

    if( cs->drop > drop_insert
     && dragging->parent == this ) // already here.
      return false;

    const document* root = dragging->doc();
    if(!root)
      return false;

    css_istream s(sel, root->uri().src);
    tool::array<tool::handle<html::style_def>> sds;
    html::style_def::parse_list(s,sds);
    for(int i = sds.size() - 1; i >= 0; --i)
      if(sds[i]->match(dragging, root))
        return true;
    return false;
  }*/

  element *element::get_target(view &v, bool only_visible) const {
    ustring for_selector;
    if (get_attr("-for", for_selector)) {
      ustring at_selector;
      get_attr("-at", at_selector);
      element *t = find_first_ex(v, doc(), for_selector, at_selector, only_visible);
      if (t) return t;
    }
    return const_cast<element *>(this);
  }

  bookmark element::start_pos() const {
    return bookmark(const_cast<element *>(this), 0, false);
  }

  bookmark element::end_pos() const {
    return bookmark(const_cast<element *>(this), max(0, nodes.last_index()), true);
  }

/*      if( this->flags.is_synthetic && this->nodes.size() )
      {
        if (tail) {
          node* pn = html::walk::next(last_node(), doc());
          if (pn) return pn->this_pos(false);
          return parent->this_pos(true);
        } else {
          node* pn = html::walk::next(last_node(), doc());
          if (pn) return pn->this_pos(false);
          return parent->this_pos(true);
        }

      }
*/

  bool element::advance_forward(bookmark &bm, wchar &c) const {
    c = 0;
    assert(bm.node.ptr() == this);

    if (this->is_disabled()) {
      bm = bm == end_pos() ? this_pos(true) : end_pos();
      return true;
    }

    if (this->state.content_editable() && const_cast<element*>(this)->is_inline_block_element() /*tag::type(tag) == tag::INLINE_BLOCK_TAG*/) {
      bm = bm == end_pos() ? this_pos(true) : end_pos();
      return true;
    }

    if (bm.after_it) {
      bm.after_it = false;
      bm.pos = bm.pos + 1;
      if (bm.pos >= nodes.size()) {
        if (this->flags.is_synthetic && last_node())
        {
          node* pn = html::walk::next(last_node(), doc());
          if (pn)
            bm = pn->this_pos(false);
          else
            bm = bookmark();
        } else
         bm = this_pos(true);
      }
    } else if (bm.pos >= 0 && bm.pos < nodes.size()) {
      node *pn = nodes[bm.pos];
      // if(pn->is_element() && pn->cast<element>()->is_atomic_box(
      bm = pn->start_pos();
    } else
      bm = end_pos();
    return true;
  }

  bool element::advance_backward(bookmark &bm, wchar &c) const {
    c = 0;
    assert(bm.node.ptr() == this);

    if (this->is_disabled()) {
      // bm = bm != end_pos() ? start_pos() : this_pos(false);
      bm = bm == start_pos() ? this_pos(false) : start_pos();
      return true;
    }

    //if (this->state.content_editable() && tag::type(tag) == tag::INLINE_BLOCK_TAG) {
    if (this->state.content_editable() && const_cast<element*>(this)->is_inline_block_element() /*tag::type(tag) == tag::INLINE_BLOCK_TAG*/) {
      bm = bm == start_pos() ? this_pos(false) : start_pos();
      return true;
    }

    if (!bm.after_it) {
      bm.after_it = true;
      bm.pos      = bm.pos - 1;
      if (bm.pos < 0) {
        if (this->flags.is_synthetic && last_node())
        {
          node* pn = html::walk::prev(last_node(), doc());
          if (pn)
            bm = pn->this_pos(true);
          else
            bm = bookmark();
        }
        else
          bm = this_pos(false);
      }

    } else if (bm.pos >= 0 && bm.pos < nodes.size())
      bm = nodes[bm.pos]->end_pos();
    else
      bm = start_pos();

    return true;
  }

  bool element::is_start_pos(const bookmark &bm) const {
    assert(bm.node.ptr() == this);
    return bm.pos == 0 && !bm.after_it;
  }

  bool element::is_end_pos(const bookmark &bm) const {
    assert(bm.node.ptr() == this);
    // return bm.linear_pos() >= nodes.size();
    return bm.pos == max(0, nodes.last_index()) && bm.after_it;
  }

  bool good_for_block_caret_position(view &v, const element *el, bool tail) {

#if 1

    if (const_cast<element *>(el)->is_inline_block_element(v)) return true;

    switch (el->tag) {
    case tag::T_BLOCKQUOTE:
    case tag::T_UL:
    case tag::T_OL:
    case tag::T_DL:
    case tag::T_DIR:
    case tag::T_MENU:
    case tag::T_PRE:
    case tag::T_LI:
    case tag::T_DD:
    case tag::T_FIGURE:
    case tag::T_TABLE: return true;

    default: return false;
    }

#else
    switch (el->tag) {
    case tag::T_TR:
    case tag::T_TD:
    case tag::T_TH:
    case tag::T_TBODY:
    case tag::T_THEAD:
    case tag::T_TFOOT:
    case tag::T_LI:
    case tag::T_DT:
    case tag::T_HTMLAREA:
    case tag::T_PLAINTEXT: return false;
    case tag::T_P:
    case tag::T_TEXT:
      // if( tail && !el->next_element() )
      //  return true;
      // if( !tail && !el->prev_element() )
      //  return true;
      return false;
    }
    return true;
#endif
  }

  /*bool is_last_visible_in_block(view& v, const element* el) {
    element* pb = el->nearest_text_box(); // closest box or this
    if (!pb) return true;
    each_node each(pb);
    each.n = el;
    for (node* pn; each(pn); ) {
      if (pn == el) continue;
      if (!pn->is_space()) return false;
    }
    return true;
  }

  bool is_first_visible_in_block(view& v, const element* el) {
    element* pb = el->nearest_text_box(); // closest box or this
    if (!pb) return true;
    each_node_backward each(pb);
    each.n = el;
    for (node* pn; each(pn); ) {
      if (pn == el) continue;
      if (!pn->is_space()) return false;
    }
    return true;
  }*/

  bool element::is_caret_pos(view& v,const bookmark &bm) const {
    if (bm == end_pos() || bm == start_pos()) {

      if (tag == tag::T_BR)
      {
        if (bm == end_pos()) return false;
        if (bm == start_pos()) {
          node* ppn = prev_node();
          if (!ppn)
            return true;
          if(ppn->is_element() && ppn->cast<element>()->tag == tag::T_BR)
            return true;
          return false;
        }
      }

      if (is_atomic_box()) {
        // element* pb = const_cast<element*>(this)->nearest_text_box(); //
        // closest box or this  if (!pb) return true;  if (
        // pb->cast<text_block>()->last_visible_node() == bm.node )
        //  return true; // it has only one valid position
        // else
        //  return bm == start_pos(); // it has only one valid position
        return true;
      }

      if (bm == end_pos())
      {
        if (element* ne = next_element()) {
          //assert(ne->flags.layout_ctl_valid);
          if(ne->is_text_box())
            return false;
          element* pnext = ne->first_ui_element();
          if (pnext && pnext->is_text_box())
            return false;
        }
        else if (next_node()) {
          if (!next_node()->is_space())
            return false;
        }
        //else
        //  return true; // very last
      }
      if (bm == start_pos())
      {
        if (element* pe = prev_element()) {
          //assert(pe->flags.layout_ctl_valid);
          if (pe->is_text_box())
            return false;
          element* pprev = pe->last_ui_element();
          if (pprev && pprev->is_text_box())
            return false;
        }
        else if (prev_node()) {
          if (!prev_node()->is_space())
            return false;
        }
        //else
        //  return true; // very first

      }

      if ( const_cast<element *>(this)->is_box_element(v)
        && good_for_block_caret_position(v, this, bm == end_pos()))
        return true;
    }
    return false;
  }

  bool element::is_char_pos(view& v,const bookmark &bm) const {
    if (bm == end_pos() || bm == start_pos()) return is_atomic_box();
    return false;
  }

  bool element::is_of_class(const char *clsname) const {
    string s = string(attr_class());
    if (s.length() == 0) return false;
    chars   t, cn = chars_of(clsname);
    atokens ts((s), CHARS(" "));
    while (ts.next(t))
      if (t == cn) return true;
    return false;
  }

  bool same_caret_position(const bookmark &bm1, const bookmark &bm2) {
    if (bm1 == bm2) return true;
    if (bm1.at_end() && bm2.at_start() && bm1.node->next_node() == bm2.node)
      return true;
    if (bm2.at_end() && bm1.at_start() && bm2.node->next_node() == bm1.node)
      return true;
    return false;
  }

  bool element::advance(view &v, bookmark &bm, ADVANCE_DIR cmd, point vpt) {
    auto is_valid = [&](const bookmark &t) -> bool {
      if (!t.valid()) return false;
      //bool check_this_too = bm == this->start_pos() || bm == this->end_pos();
      return t.is_inside(this);
    };

    /*auto is_valid_for_first = [&](const bookmark &bm) -> bool {
      if (!bm.valid()) return false;
      if (!bm.node->belongs_to(this, true)) return false;
      return true;
    };*/

    auto char_kind = [&v](const bookmark &bm) -> uint {
      if (!bm.at_char_pos(v)) return uint(-1);
      wchar c = bm.char_code(v);
      if (ucisalnum(c)) return 1;
      if (ucisspace(c)) return 0;
      return 2;
    };

    switch (cmd) {
    case ADVANCE_UP: {
      if (!bm.valid()) return false;

      vpt -= this->view_pos(v);
      vpt += this->scroll_pos();
      rect rc0 = bm.get_caret_rect(v);
      for (; vpt.y >= -this->scroll_pos().y; --vpt.y) {
        bookmark tbm = this->find_text_pos(v, vpt);
        if (is_valid(tbm) && (~tbm != ~bm) && tbm.at_caret_pos(v) &&
            tbm.get_caret_rect(v).top() < rc0.top()) {
          bm = tbm;
          return true;
        }
      }
      return false;
    }

    case ADVANCE_DOWN: {
      if (!bm.valid()) return false;

      vpt -= this->view_pos(v);
      vpt -= this->scroll_pos();
      rect rc0 = bm.get_caret_rect(v);

      for (int maxy = this->ldata->dim_min.y - scroll_pos().y; vpt.y < maxy; ++vpt.y) {
        bookmark tbm = this->find_text_pos(v, vpt);
        if (is_valid(tbm) && (~tbm != ~bm) && tbm.at_caret_pos(v) &&
            tbm.get_caret_rect(v).top() > rc0.top()) {
          bm = tbm;
          return true;
        }
      }

      return false;
    }

    case ADVANCE_WORD_END: {
      if (!is_valid(bm)) return false;
      element* tb = bm.node->nearest_text_box();
      if (!tb)
        break;
      if (!bm.advance_caret_pos(v, ADVANCE_RIGHT))
        break;
      for (;;) {
        bookmark t = bm;
        if (!t.advance_caret_pos(v, ADVANCE_RIGHT)) break;
        if (t == bm) break;
        if (!is_valid(t)) break;
        if (tb != t.node->nearest_text_box())  break;
        if (t.at_inline_block_element_start(v)) { bm = t; break; }
        auto char_kind_t = char_kind(t);
        auto char_kind_bm = char_kind(bm);
        if (char_kind_t != char_kind_bm)
          break;
        if (char_kind_t == 2 || char_kind_bm == 2) {
          bm = t;
          break;
        }
        bm = t;
      }
      return is_valid(bm);
    }
    case ADVANCE_WORD_START: {
      if (!is_valid(bm)) return false;
      element* tb = bm.node->nearest_text_box();
      if (!tb)
        break;
      if (!bm.advance_caret_pos(v, ADVANCE_LEFT))
        break;
      for (;;) {
        bookmark t = bm;
        if (!t.advance_caret_pos(v, ADVANCE_LEFT)) break;
        if (t == bm) break;
        if (!is_valid(t)) break;
        if (tb != t.node->nearest_text_box()) break;
        if (t.at_inline_block_element_start(v)) { if(t.node->belongs_to(this)) bm = t; break;  }
        auto char_kind_t = char_kind(t);
        auto char_kind_bm = char_kind(bm);
        if (char_kind_t != char_kind_bm)
          break;
        if (char_kind_t == 2 || char_kind_bm == 2)
          break;
        bm = t;
      }
      bm.after_it = false;
      return is_valid(bm);
    }

    case ADVANCE_FIRST: // very first position
    {
      bookmark t  = this->start_caret_pos(v);
      bookmark fc = t;
      for (; t.valid(); t.advance_caret_pos(v, ADVANCE_NEXT)) {
        if (!t.node->belongs_to(this, true))
          break;
        if (t.at_char_pos(v) && is_valid(t)) {
          bm = t;
          return true;
        }
      }
      if (fc.valid()) {
        bm = fc;
        return true;
      }
    } break;

    case ADVANCE_LAST: // very last position
    {
      bookmark t  = this->end_caret_pos(v);
      bookmark lc = t;
      for (; t.valid(); t.advance_caret_pos(v, ADVANCE_PREV)) {
        if (!t.node->belongs_to(this, true))
          break;
        if (t.at_char_pos(v) && is_valid(t)) {
          bm = t;
          return true;
        }
      }
      if (lc.valid()) {
        bm = lc;
        return true;
      }
    } break;

    case ADVANCE_END:
    case ADVANCE_HOME:
      for (bookmark t = bm; is_valid(t);) {
        bookmark pt = t;
        t.advance_caret_pos(v, cmd);
        if (!is_valid(t)) break;
        bm = t;
        return true;
      }
      break;

    case ADVANCE_NEXT_CHAR:
    case ADVANCE_PREV_CHAR:
      for (bookmark t = bm; is_valid(t);) {
        bookmark pt = t;
        t.advance_caret_pos(v, cmd == ADVANCE_NEXT_CHAR ? ADVANCE_NEXT
                                                        : ADVANCE_PREV);
        if (!is_valid(t) || t == bm) break;
        if (t.at_char_pos(v) && !same_caret_position(bm, t)) {
          bm = t;
          return true;
        } else if (pt == t)
          return false;
      }
      return false;

    case ADVANCE_NEXT_CARET:
    case ADVANCE_PREV_CARET:
      for (bookmark t = bm; is_valid(t);) {
        bookmark pt = t;
        t.advance_caret_pos(v, cmd == ADVANCE_NEXT_CARET ? ADVANCE_NEXT
          : ADVANCE_PREV);
        if (!is_valid(t) || t == bm) break;
        if ((t.at_caret_pos(v) || t.at_block_element_start(v) || t.at_block_element_end(v)) && !same_caret_position(bm, t)) {
          //t.dbg_report("ADVANCE_NEXT_CARET");
          bm = t;
          return true;
        }
        else if (pt == t)
          return false;
      }
      return false;

    default:
      for (bookmark t = bm; is_valid(t);) {
        bookmark pt = t;
        t.advance_caret_pos(v, cmd);
        //t.dbg_report("advance left");
        if (!is_valid(t) || t == bm) break;
        if (t.at_caret_pos(v) && !same_caret_position(bm, t)) {
          bm = t;
          return true;
        } else if (pt == t)
          return false;
      }
      return false;
    }
    return false;
  }

  flow_e element::check_layout(view &v) {
    if (flags.in_setup_layout) return flow_e(0);

    get_style(v);

    /*if (!flags.model_valid) {
      drop_layout(&v);
      get_style(v);
    }
    else*/
    if (flags.layout_ctl_valid && ldata->is_initialized && flags.model_valid)
      return layout_type();

    drop_layout();
    setup_layout(v);
    flags.model_valid      = 1;
    flags.layout_ctl_valid = 1;

    return layout_type();
  }

  void element::check_layout_tree(view &v) {
    check_layout(v);
    each_ui_child([&v](element* pel) {
      pel->check_layout_tree(v);
      return false;
    });
  }

  bool element::used_style_props_report(view &v, value &retval) {
    retval = get_style(v)->definition();
#ifdef _DEBUG
    //ustring us = retval.to_string();
    //dbg_printf("used %S\n", us.c_str());
#endif
    return true;
  }

  bool element::applied_style_rules_report(view &v, value &retval) {
    style_list slist;
    get_style_list(v, doc(), slist);
    array<value> vlist;
    for (auto& item : slist.list)
      vlist.push(item.prop_bag->definition());
    retval = value::make_array(vlist());
#ifdef _DEBUG
    //ustring us = retval.to_string();
    //dbg_printf("applied %S\n", us.c_str());
#endif
    return true;
  }

  bool element::swap_locations(element *b1, element *b2, view *pv) {
    if (b1->tag == tag::T_TR && b2->tag != tag::T_TR) return false;
    if (b2->tag == tag::T_TR && b1->tag != tag::T_TR) return false;
    if (b1->tag == tag::T_TD && b2->tag != tag::T_TD) return false;
    if (b2->tag == tag::T_TD && b1->tag != tag::T_TD) return false;

    helement hb1 = b1;
    helement hb2 = b2;

    int idx1 = b1->node_index;
    int idx2 = b2->node_index;

    element *parent1 = b1->parent;
    element *parent2 = b2->parent;

    if (parent1) {
      parent1->flags.indexes_are_valid = 0;
      parent1->nodes[idx1]             = b2;
    }
    b2->parent     = parent1;
    b2->node_index = idx1;

    if (parent2) {
      parent2->flags.indexes_are_valid = 0;
      parent2->nodes[idx2]             = b1;
    }

    b1->parent     = parent2;
    b1->node_index = idx2;

    if (!pv) return true;

    if (parent1 != parent2) {
      if (parent1) {
        parent1->flags.indexes_are_valid = 0;
        parent1->drop_layout(pv);
        parent1->reset_styles(*pv);
        pv->add_to_update(b1, true);
        pv->on_content_change(parent1, CONTENT_REMOVED | CONTENT_ADDED);
      }
      if (parent2) {
        parent2->flags.indexes_are_valid = 0;
        parent2->drop_layout(pv);
        parent2->reset_styles(*pv);
        pv->add_to_update(b2, true);
        pv->on_content_change(parent2, CONTENT_REMOVED | CONTENT_ADDED);
      }
    } else if (b1->dim() == b2->dim() && b1->tag == b2->tag &&
               b1->c_style == b2->c_style && b1->is_layout_valid() &&
               b2->is_layout_valid()) {
      if (b1->parent) pv->refresh(b1);
      if (b2->parent) pv->refresh(b2);
      swap(b1->ldata->pos, b2->ldata->pos);
      if (b1->is_table_row()) {
        child_iterator ci1(*pv, b1);
        child_iterator ci2(*pv, b2);
        element *      td1, *td2;
        for (; ci1(td1) && ci2(td2);)
          swap(td1->ldata->pos, td2->ldata->pos);
      }
      b1->parent->drop_content_layout(pv);
      b1->parent->commit_measure(*pv);
    } else if (parent1) {
      // if(b1->parent) pv->add_to_update(b1,false);
      // if(b2->parent) pv->add_to_update(b2,false);
      // b1->parent->drop_content_layout(pv);
      pv->refresh(b1);
      pv->refresh(b2);
      parent1->flags.indexes_are_valid = 0;
      if (b1->flags.disable_fast_css_match || b2->flags.disable_fast_css_match)
        parent1->reset_styles(*pv);
      parent1->drop_layout(pv);
      parent1->commit_measure(*pv);
    }
    return true;
  }

  element *element::a11y_navigate(NAVDIR dir) {
    helement next;
    switch (dir) {
      case DIR_UP:    next = (parent && parent->is_vertical_layout()) ? prev_ui_element() : nullptr; break;
      case DIR_DOWN:  next = (parent && parent->is_vertical_layout()) ? next_ui_element() : nullptr; break;
      case DIR_LEFT:  next = (parent && parent->is_horizontal_layout()) ? prev_ui_element() : nullptr; break;
      case DIR_RIGHT: next = (parent && parent->is_horizontal_layout()) ? next_ui_element() : nullptr; break;
      case DIR_NEXT:  next = next_ui_element(); break;
      case DIR_PREVIOUS:   next = prev_ui_element(); break;
      case DIR_FIRSTCHILD: next = first_ui_element(); break;
      case DIR_LASTCHILD:  next = last_ui_element(); break;
    }
    return next;
  }

  bool element::a11y_get_children(array<hnode>& nodes)
  {
    for (auto bh = this->behavior; bh; bh = bh->next) {
      helement hf;
      if (bh->a11y_get_children(this, nodes))
        return hf;
    }
    this->nodes.each([this, &nodes](node* pn) -> bool {

      if (pn->is_text()) {
        if (pn->cast<html::text>()->is_space())
          return false;
      }
      else if (pn->is_element()) {
        html::view *pv = pn->pview();
        if (!pv) return false;
        if (!pn->a11y_is_visible(*pv)) return false;
      }
      else
        return false;
      nodes.push(pn);
      return false;
    });
    return true;
  }

  element * element::a11y_find_element(view &v, point zpos) {

    helement pchild = find_element(v, zpos);
    if (!pchild)
      return pchild;
    if (pchild == this)
      return this;

    for (helement p = pchild->ui_owner(v); p; p = p->ui_owner(v)) {
      if (p->state.popup())
        break;
      if (p->a11y_is_atomic(v))
        return p;
    }
    return pchild;
  }

  bool element::a11y_is_atomic(view &v) {
    for (auto bh = this->behavior; bh; bh = bh->next) {
      if (bh->a11y_is_atomic(v, this))
        return true;
    }
    return false;
  }

  bool element::a11y_get_state(view &v, ui_state& st) {
    st = this->state;
    for (auto bh = this->behavior; bh; bh = bh->next) {
      if (bh->a11y_get_state(v, this, st))
        return true;
    }
    return true;
  }

  handle<element> element::a11y_get_focus(view &v) {
    //assert(state.focus());
    for (auto bh = this->behavior; bh; bh = bh->next) {
      helement hf;
      if (bh->a11y_get_focus(v, this, hf))
        return hf;
    }
    return state.focus() ? this : nullptr;
  }

  bool element::a11y_do_default_action(view& v) {
    event_behavior evt(this, this, ACTIVATE_CHILD,0);
    return v.send_behavior_event(evt);
  }

  bool element::a11y_get_name(view &v, ustring &name) {
    if (get_attr("-aria-label", name) && name.length()) return true;
    ustring list;
    if (get_attr("-aria-labelledby", list)) {
      wchars d = list();
      for (wchars id = d.chop(' '); id; id = d.chop(' '))
      {
        element *lbl = find_by_id(id);
        if (!lbl) lbl = find_neighbour_id(id);
        if (lbl) {
          if (name.length()) name += WCHARS(" ");
          name += trim(lbl->get_text(v)());
        }
      }
      return name.length() > 0;
    }

    auto get_ui_text = [&](element* el) -> ustring {
      array<wchar> tchars;
      el->get_ui_text(v, tchars);
      return trim(tchars());
    };

    CTL_TYPE ct = ctl_type(v);
    switch (ct) {
    case CTL_NO:
    case CTL_UNKNOWN: return false;
    case CTL_HYPERLINK:
      name = get_ui_text(this);
      return true;
    default:
      if (tag == tag::T_BUTTON) {
        name = get_ui_text(this);
        return true;
      } else {
        ustring id = attr_id();
        if (id.length()) {
          element *elid = this->find_for_id(id);
          if (elid) {
            name = get_ui_text(elid);
            return true;
          }
        } else if (parent && (parent->ctl_type(v) == CTL_LABEL)) {
          name = get_ui_text(parent);
          return true;
        } else if (!ct && is_focusable(v)) {
          name = get_ui_text(this);
          return true;
        }
      }
    }
    return false;
  }

  bool element::a11y_get_desc(view &v, ustring &desc) {
    if (get_attr("-aria-description", desc) && desc.length()) return true;
    ustring list;
    if (get_attr("-aria-describedby", list)) {
      wchars d = list();
      for (wchars id = d.chop(' '); id; id = d.chop(' '))
      {
        element *lbl = find_by_id(id);
        if (!lbl) lbl = find_neighbour_id(id);
        if (lbl) {
          if (desc.length()) desc += WCHARS(" ");
          desc +=  trim(lbl->get_text(v)());
        }
      }
      return desc.length() > 0;
    }
    return false;
  }

  bool element::a11y_get_value(view &v, ustring &text)
  {
    for (auto bh = this->behavior; bh; bh = bh->next) {
      helement hf;
      if (bh->a11y_get_value(v, this, text))
        return true;
    }

    /*
    auto ct = ctl_type();
    if (ct) {
      value val;
      if (this->get_value(v, val)) {
        text = val.to_string();
        return true;
      }
    }*/

    return false;
  }

  bool element::a11y_is_visible(view &v) {
    if (is_it_visible(v)) return true;
    if (tag == tag::T_MENU || tag == tag::T_POPUP) return true;
    return false;
  }

/*  enum A11Y_LIVE {
    A11Y_LIVE_OFF,
    A11Y_LIVE_POLITE,
    A11Y_LIVE_ASSERTIVE,
  }; */
  element::A11Y_LIVE element::get_a11y_live(view &v)
  {
    ustring val;
    if (get_attr("-aria-live", val)) {
      if (val == WCHARS("assertive")) return A11Y_LIVE_ASSERTIVE;
      if (val == WCHARS("polite")) return A11Y_LIVE_POLITE;
    }
    return A11Y_LIVE_OFF;
  }

  string element::doc_url() const {
    document *pd = doc();
    return pd ? pd->uri().src : string();
  }

  bool do_request_delayed_measure(view &v, element *el, bool horizontal, int depth) {
    if (--depth < 0) return false;
    if (el->flags.delayed_measurement) return false; // already requested

    const hstyle cs = el->get_style(v);

    /*if (horizontal && (cs->overflow_x >= overflow_scroll)) {
      el->flags.delayed_measurement = 1;
      v.start_timer(el, DELAYED_MEASURE_TIMER_MS, DELAYED_MEASURE_TIMER_ID,INTERNAL_TIMER);
    } else if (!horizontal && (cs->overflow_y >= overflow_scroll)) {
      el->flags.delayed_measurement = 1;
      v.start_timer(el, DELAYED_MEASURE_TIMER_MS, DELAYED_MEASURE_TIMER_ID,INTERNAL_TIMER);
    } */
#if defined(WINDOWLESS)
    if (horizontal || (cs->overflow() >= overflow_scroll && el->n_children() > 8))
#else
    if (cs->overflow() >= overflow_scroll && el->n_children() > 8)
#endif
    {
      el->flags.delayed_measurement = 1;
      v.start_timer(el, DELAYED_MEASURE_TIMER_MS, DELAYED_MEASURE_TIMER_ID, INTERNAL_TIMER);
    }
    else {
      bool r = false;
      for (element *c = el->first_element(); c; c = c->next_element())
        if (do_request_delayed_measure(v, c, horizontal, depth)) r = true;
      return r;
    }
    return true;
  }

  bool element::request_delayed_measure(view &v, bool horizontal) {
    if (!do_request_delayed_measure(v, this, horizontal, 3)) {
      reset_style(v);
      return false;
    }
    return true;
  }

  bool bookmark::at_table_row_start() const {
    return at_element_start() && node.ptr_of<element>()->tag == tag::T_TR;
  }
  bool bookmark::at_table_row_end() const {
    return at_element_end() && node.ptr_of<element>()->tag == tag::T_TR;
  }
  // true for cells in first row
  bool bookmark::at_table_column_start() const {
    return at_element_start() && node.ptr_of<element>()->is_table_cell() &&
           node.ptr_of<element>()->parent->index() == 0;
  }
  bool bookmark::at_table_column_end() const {
    return at_element_end() && node.ptr_of<element>()->is_table_cell() &&
           node.ptr_of<element>()->parent->index() == 0;
  }

  void bookmark::stack(array<int> &stack, const element *root) const {
    assert(valid());
    if (!valid()) return;
    node->index_stack(stack, root);
    stack.push((pos << 1) | (after_it ? 1 : 0));
  }

  void bookmark_p::set(const bookmark &bm, const element *root) {
    _stack.clear();
    if (bm.valid()) bm.stack(_stack, root);
  }

  bookmark bookmark_p::get(const element *root) const {
    if (_stack.size() == 0) return bookmark();
    const node *n = root;
    for (int i = 0; i < _stack.size() - 1; i++) {
      if (!n || !n->is_element()) return bookmark();
      const element *b   = n->cast<element>();
      int            idx = _stack[i];
      idx >>= 1;
      if (idx < 0 || idx >= b->nodes.size()) return b->this_pos(false);
      n = b->nodes[idx];
    }
    int  pos      = _stack.last();
    bool after_it = bool(pos & 1);
    pos >>= 1;

    return bookmark(const_cast<node *>(n), pos, after_it);
  }

  bool bookmark::is_inside(const element *container) const {
    if (!valid()) return false;
    if (node->belongs_to(const_cast<element*>(container),true))
      return true;
    return false;
  }

  bool bookmark::is_between(const bookmark &ls, const bookmark &rs) const {
    assert(valid());
    if (!valid()) return false;
    if (!ls.valid() || !rs.valid()) return false;

    array<int> t;
    stack(t);
    array<int> tls;
    ls.stack(tls);
    array<int> trs;
    rs.stack(trs);

    if (tls > trs) tls.swap(trs);

    if ((t >= tls) && (t < trs)) return true;
    // if( *this == rs ) return false;

    return false;
  }

  bool bookmark::operator<(const bookmark &rs) const {
    array<int> tls;
    stack(tls);
    array<int> trs;
    rs.stack(trs);
    return tls < trs;
  }
  bool bookmark::operator>(const bookmark &rs) const {
    array<int> tls;
    stack(tls);
    array<int> trs;
    rs.stack(trs);
    return tls > trs;
  }

  bool bookmark::operator>=(const bookmark &rs) const {
    array<int> tls;
    stack(tls);
    array<int> trs;
    rs.stack(trs);
    return tls >= trs;
  }

  bool bookmark::operator<=(const bookmark &rs) const {
    array<int> tls;
    stack(tls);
    array<int> trs;
    rs.stack(trs);
    return tls <= trs;
  }

  bool bookmark::get_caret_metrics(view &v, caret_metrics &gm, bool char_only) const {
    assert(valid());
    if (!valid())
      return false;
    element *pel = node->nearest_box();
    if (!pel) return false;
    pel->commit_measure(v);
    if (char_only && !pel->is_of_type<text_block>()) return false;

    return pel->get_caret_metrics(v, *this, gm);
  }

  rect bookmark::get_caret_rect(view &v) const {
    caret_metrics gm;
    if (get_caret_metrics(v, gm) && gm.elem) {
      return gm.caret_v_bar() + gm.elem->view_pos(v) - gm.elem->scroll_pos();
    }
    return rect();
  }
  rect bookmark::get_glyph_box(view &v) const {
    caret_metrics gm;
    if (get_caret_metrics(v, gm, true) && gm.elem) {
      return gm.glyph_rc + gm.elem->view_pos(v) - gm.elem->scroll_pos();
    }
    return rect();
  }

  bool bookmark::advance_caret_pos(view &v, ADVANCE_DIR dir) {
    if (!valid()) return false;
    element *pel = node->nearest_box();
    if (!pel) return false;
    pel->commit_measure(v);
    return node->advance_caret_pos(v, *this, dir);
  }
  bool bookmark::advance_caret_pos(view &v, ADVANCE_DIR dir,
                                   array<wchar> &out) {
    if (!valid()) return false;
    element *pel = node->nearest_box();
    if (!pel) return false;
    pel->commit_measure(v);
    return node->advance_caret_pos(v, *this, dir, &out);
  }
  /*bool bookmark::advance_pos(view& v)
  {
    if(!valid()) return false;
    return node->advance_pos(v,*this);
  }
  bool bookmark::advance_pos(view& v, BACKWARD_E)
  {
    if(!valid()) return false;
    return node->advance_pos(v,*this);
  }*/

  bool tree_scanner::each_node(const function<bool(node *)> &f) {
    hash_table<uint_ptr, bool> scanned(
        1024U); // to ensure that elements are scanned once

    const function<bool(node *)> scan = [&f, &scan, &scanned](node *n) -> bool {

      bool created;
      scanned.get_ref(uint_ptr(n), created);

      // bool visited = ((n->scan_tree_state ^ state) & mask) == 0;
      // n->scan_tree_state ^= mask;

      if (!created) // so it is already there
        return false;
      if (f(n)) return true;
      if (n->each_any_child_node(scan)) return true;
      return false;
    };

    bool r = false;
    FOREACH(ri, roots)
    r = scan(roots[ri]) || r;
    return r;
  }

  bool tree_scanner::each_element(const function<bool(element *)> &f) {
    hash_table<uint_ptr, bool> scanned(
        1024U); // to ensure that elements are scanned once

    const function<bool(element *)> scan = [&f, &scan,
                                            &scanned](element *n) -> bool {

      bool created;
      scanned.get_ref(uint_ptr(n), created);

      // bool visited = ((n->scan_tree_state ^ state) & mask) == 0;
      // n->scan_tree_state ^= mask;

      if (!created) // so it is already there
        return false;
      if (f(n)) return true;
      if (n->each_any_child(scan)) return true;
      return false;
    };

    bool r = false;
    FOREACH(ri, roots)
    r = scan(roots[ri]) || r;
    return r;
  }

  rect rbox(view &v, bookmark start, bookmark end) {
    // start.linearize();
    // end.linearize();
    if (start > end) swap(start, end);
    pos_iterator positions(start, end);
    rect         r;
    for (bookmark bm; positions(bm);) {
      if (bm.at_char_pos(v)) r |= bm.get_glyph_box(v);
    }
    return r;
  }

} // namespace html
