#include "html.h"
#include "html-behaviors.h"

namespace html {
  namespace behavior {

#if defined(USE_VIDEO)

#if defined(USE_DS_VIDEO)
    extern video_ctl *produce_ds_video_ctl(element *el);
#endif
    extern video_ctl *produce_zero_video_ctl(element *el);
    extern video_ctl *produce_custom_video_ctl(element *el);

    struct video_ctl_factory : ctl_factory {
      video_ctl_factory() : ctl_factory("video") {}
      virtual ctl *create(element *el) override;
    };

    static video_ctl_factory *_video_ctl_factory = 0;

    ctl *video_ctl_factory::create(element *el) {
      video_ctl *c = produce_zero_video_ctl(el);
      if (c) return c;
#if defined(USE_DS_VIDEO)
      c = produce_ds_video_ctl(el);
      if (c) return c;
#endif
      return nullptr;
    }

    const string &video_ctl::behavior_name() const {
      return _video_ctl_factory->name;
    }


    struct custom_video_ctl_factory : ctl_factory {
      custom_video_ctl_factory() : ctl_factory(CUSTOM_VIDEO_CTL_NAME) {}
      virtual ctl *create(element *el) override;
    };

    static custom_video_ctl_factory *_custom_video_ctl_factory = 0;
    ctl *custom_video_ctl_factory::create(element *el) {
      return produce_custom_video_ctl(el);
    }



    // <video> draws its content on top of foreground
    bool video_ctl::draw_content(view &v, element *self, graphics *sf,
                                 point pos) {
      critical_section _(_guard);
      self->draw_foreground(v, sf, pos);
      return true;
    }
    bool video_ctl::draw_foreground(view &v, element *self, graphics *sf,
                                    point pos) {
      critical_section _(_guard);
      self->draw_content(v, sf, pos);
      return true;
    }

    image *video_ctl::get_fore_image(view &v, element *self) { return frame; }

    bool video_ctl::on_x_method_call(view &v, element *self, const char *name,
                                     const value *argv, size_t argc,
                                     value &retval) {
      critical_section _(_guard);

      chars fname = chars_of(name);
#define METHOD(ARGC, NAME) if (argc == ARGC && fname == CHARS(#NAME))

      METHOD(0, videoIsPlaying) {
        retval = value(is_playing());
        return true;
      }
      METHOD(0, videoIsEnded) {
        retval = value(is_movie_ended());
        return true;
      }
      METHOD(0, videoDuration) {
        retval = value(this->get_movie_duration());
        return true;
      }
      METHOD(0, videoPosition) {
        retval = value(this->get_position());
        return true;
      }
      METHOD(0, videoWidth) {
        retval = value(this->get_movie_normal_size().x);
        return true;
      }
      METHOD(0, videoHeight) {
        retval = value(this->get_movie_normal_size().y);
        return true;
      }
      METHOD(0, videoBox) {
        // bool need_clipping = false;
        rect box = // get_target_box(need_clipping);
            self->foreground_image_box(v);
        value r[4] = {value(box.left()), value(box.top()), value(box.width()),
                      value(box.height())};
        retval     = value::make_array(items_of(r));
        return true;
      }
      METHOD(0, audioVolume) {
        retval = value(this->get_volume());
        return true;
      }
      METHOD(0, audioBalance) {
        retval = value(this->get_balance());
        return true;
      }
      METHOD(1, videoLoad) {
        if (!argv[0].is_string()) return false;

        string    in = argv[0].get(W(""));
        tool::url u(combine_url(self->doc()->uri().src, in));

        retval = value(load_movie(u));
        return true;
      }
      METHOD(0, videoUnload) {
        this->close_movie();
        retval = value(true);
        return true;
      }

      METHOD(0, videoPlay) {
        // if( this->is_movie_open() )
        retval = value(this->play());
        // retval = value(load_movie(u));
        return true;
      }
      METHOD(1, videoPlay) {
        double dura = argv[0].get(0.0);
        this->set_position(dura);
        retval = value(this->play());
        return true;
      }
      METHOD(0, videoStop) {
        if (this->is_movie_open()) {
          this->stop();
          retval = value(true);
        }
        retval = value(false);
        return true;
      }
      METHOD(1, videoPosition) {
        double dura = argv[0].get(0.0);
        this->set_position(dura);
        retval = value(this->get_position());
        return true;
      }
      METHOD(0, videoRewind) {
        this->goto_start();
        retval = value(this->get_position());
        return true;
      }
      METHOD(1, audioVolume) {
        double val = argv[0].to_float();
        this->set_volume(val);
        retval = value(this->get_volume());
        return true;
      }
      METHOD(1, audioBalance) {
        double val = argv[0].to_float();
        this->set_balance(val);
        retval = value(this->get_balance());
        return true;
      }

#undef METHOD
      return super::on_x_method_call(v, self, name, argv, argc, retval);
    }

#if defined(OSX) && !defined(WINDOWLESS)
    void init_camera();
#endif

    void init_media() {
#if defined(OSX) && !defined(WINDOWLESS)
      init_camera();
#endif
      ctl_factory::add(_video_ctl_factory = new video_ctl_factory());
      ctl_factory::add(_custom_video_ctl_factory = new custom_video_ctl_factory());
    }
#else
    void init_media() {}
#endif
  }
} // namespace html
