//#include "stdafx.h"
#include "html.h"
//#include "html_clipboard.h"
//#include "html_ctl_text.h"

#include <wctype.h>

namespace html {
  namespace behavior {

  //#define PLACEHOLDER_CHAR 0x2022
  //#define PLACEHOLDER_CHAR 0x25cf
  #define PLACEHOLDER_CHAR ' '
    
    extern bool is_inside_focus(const element *self);
    extern bool is_focus_inside(view &pv, const element *self);

    struct masked_edit_ctl_factory : public ctl_factory {
      masked_edit_ctl_factory() : ctl_factory("masked-edit") {}
      virtual ctl *create(element *el);
    };

    masked_edit_ctl_factory *_masked_edit_ctl_factory = 0;

    inline int span_length(wchars wc, int n) {
      wchar c      = wc[n];
      int   length = 1;
      for (++n; n < int(wc.length); ++n)
        if (wc[n] != c)
          break;
        else
          ++length;
      return length;
    }

    struct masked_edit_ctl : ctl {
      enum { DIGIT_SPACE_CHAR = ' ' };

      element *self;

      enum group_def_type {
        FIELD_UNKNOWN,
        FIELD_TEXT,
        FIELD_ALPHA_TEXT,
        FIELD_NUMBER,
        FIELD_ZNUMBER,
        FIELD_ENUM,
      };

      struct span_def {
        uint start;
        uint length;
        span_def() : start(0), length(0) {}
        span_def(const span_def& sd) : start(sd.start), length(sd.length) {}
        wchars span(wchars s) const { return wchars(s.start + start, length); }
      };

      struct group_def : public span_def {
        group_def_type type;
        ustring        filter;
        int_v          maxv;
        int_v          minv;
        int_v          step;
        array<ustring> enum_items;
        int            enum_no; // current no of enum option
        range          x;
        weak_handle<element> el;

        group_def() : type(FIELD_UNKNOWN), el(0) { enum_no = -1; }
        group_def(const group_def& gd) 
          : span_def(gd)
          , type(gd.type)
          , filter(gd.filter) 
          , maxv(gd.maxv)
          , minv(gd.minv)
          , step(gd.step)
          , enum_items(gd.enum_items)
          , enum_no(gd.enum_no)
          , x(gd.x)
          , el(gd.el)
        {  
        }

        array<wchar> &text() {
          static array<wchar> black_hole;
          if (!el) { assert(false); return black_hole; }
          node *pf = el->first_node();
          if (!pf) { assert(false); return black_hole; }
          if (!pf->is_text()) { assert(false); return black_hole; }
          return static_cast<html::text *>(pf)->chars;
        }

        wchars chars() const { 
          if (!el) { return wchars(); }
          return static_cast<html::text *>(el->first_node())->chars();
        }

        void   set_text(view &v, wchars val);

        void invalidate(view &v) {
          if (!el) { assert(false); return; }
          v.add_to_update(el, true);
        }
          
        /*wchar placeholder(wchar def) const {
            return type == FIELD_ZNUMBER ? '0' : def;
        }*/

        // bool  is_full() const { return text().length() >= length; }
        bool is_full() const {
          if (type == FIELD_TEXT || type == FIELD_ALPHA_TEXT || type == FIELD_NUMBER || type == FIELD_ZNUMBER)
            return trim(chars()).length >= length;
          // else if(type == FIELD_ZNUMBER)
          //{
          //  ustring us = i64tow(parse_int(chars()));
          //  return uint(us.length()) >= length;
          //}
          return false;
        }
        bool  is_valid_char(wchar c);
        bool  handle_char(view &v, ucode uc);
        void  select(view& v, wchar placeholder_char);
        void  deselect(view& v, wchar placeholder_char);
        bool  increment(view &v, int inc_cmd);
        bool  is_valid() const;
        bool  constraint_value(view &v);
        bool  is_empty() const;
        bool  drop_char(view &v);
        void  update(view &v);
        bool  set_value(view &v, const value &val);
        value get_value();
        // int   measure_width(surface& sf, const element* b);
        // void  produce_content(const element* b, array<wchar>& content, wchar
        // placeholder_char);  void  draw(surface& sf, const element* b, point pt,
        // range y, bool current, wchar placeholder_char);
          
      };
      /*struct edit_auto_state
      {
        masked_edit_ctl* ctl;
        view&     pv;
        element*    self;
        bool      is_empty;
        bool      is_valid;
        edit_auto_state(masked_edit_ctl* c, element* b, view& v = 0):
      ctl(c),pv(v),self(b)
        {
          ++ ctl->_state_counter;
          is_empty = ctl->check_empty(self);
          is_valid = ctl->check_valid(self);
        }
        ~edit_auto_state()
        {
          if(--ctl->_state_counter > 0)
            return;
          bool n_is_empty = ctl->check_empty(self);
          bool n_is_valid = ctl->check_valid(self);
          if(is_empty == n_is_empty && is_valid == n_is_valid)
             return;

          if(!pv) pv = self->pview();

          if( (is_valid != n_is_valid) && is_valid )
             self->atts.set("invalid",ustring());
          else if( (is_valid != n_is_valid) && n_is_valid )
             self->atts.remove("invalid");
          ctl->_is_empty = n_is_empty;
          ctl->_is_valid = n_is_valid;
          if( pv )
            pv.add_to_update(self,false);
        }};*/

      array<group_def> groups;
      // array<span_def>  spans;
      ustring _mask;
      value   _mask_def;
      wchar   placeholder_char;
      bool    compound_value;
      bool    _is_empty;
      bool    _is_valid;
      int     _current_group;
      int     _state_counter;
      int     _intrinsic_width;
      int_v   _caret_state;
      int_v   _auto_width;

      masked_edit_ctl()
          : compound_value(false), _current_group(-1), _is_empty(true),
            _is_valid(true), _state_counter(0), _intrinsic_width(100),
            placeholder_char(PLACEHOLDER_CHAR) {}

      typedef ctl  super;
      virtual bool selectable() const { return true; }
      virtual bool focusable(const element *self) {
        return self->tag != tag::T_CAPTION;
      }

      void update(view &v, element *self) {
        self->drop_layout_tree(&v);
        self->check_layout(v);
        self->commit_measure(v);
        self->check_layout(v);
      }

      virtual const string &behavior_name() const {
        return _masked_edit_ctl_factory->name;
      }

      virtual CTL_TYPE get_type() { return CTL_EDIT; }

      bool is_editable_char(wchar c) {
        return c == '_' || c == '#' || c == '@' || c == '0';
      }

      virtual bool wants_keyboard(const element *b) const {
        return !is_readonly(b);
      }

      bool check_empty(element *self);
      bool check_valid(element *self);

      // void show_caret(view& v, element* self,bool onOff);
      // void refresh_caret(view& v, element* self);
      // bool get_caret_rect(view& v, element* self, rect& r );
      // virtual bool draw_content(view& v, element* self, graphics* sf, point
      // pos );

      virtual ustring get_mask(view &v, element *self) {
        if (_mask.length()) return _mask;
        if (self->get_attr("-mask", _mask)) {
          parse_mask(v, self);
          // measure(v,self);
        }
        ustring us;
        if (self->get_attr("-placeholder", us) && us.length())
          placeholder_char = us[0];
        else
          placeholder_char = PLACEHOLDER_CHAR;
        return _mask;
      }

      void create_text_node(view &v, element *el, wchars t) {
        if (t.length) el->append(new html::text(t));
      }
      element *create_span_node(view &v, element *el, uint length,
                                const ustring &cls = ustring()) {
        static const wchar *empty =
            W("                                                                "
              "                                    ");
        element *ps = new element(tag::T_SPAN);
        ps->append(new html::text(wchars(empty, min(100, length))));
        if (cls.length()) ps->atts.set(attr::a_class, cls);
        el->append(ps);
        return ps;
      }

      void parse_mask(view &v, element *el) {
        // el->nodes.clear();
        el->clear();
        wchars wc = _mask;
        int    n  = 0;
        groups.clear();
        // spans.clear();
        span_def spd;
        while (n < int(wc.length))
          switch (wc[n]) {
          case '@':
          case '_': {
            create_text_node(v, el, spd.span(wc));
            // spans.push(spd);
            group_def gd;
            gd.type   = wc[n] == '@' ? FIELD_ALPHA_TEXT : FIELD_TEXT;
            gd.start  = n;
            gd.length = span_length(wc, n);
            n += gd.length;
            gd.el      = create_span_node(v, el, gd.length);
            spd.start  = n;
            spd.length = 0;
            groups.push(gd);
          }
            continue;
          case '#': {
            create_text_node(v, el, spd.span(wc));
            group_def gd;
            gd.type   = FIELD_NUMBER;
            //gd.filter = WCHARS("0~9");
            gd.start  = n;
            gd.length = span_length(wc, n);
            n += gd.length;
            gd.el      = create_span_node(v, el, gd.length);
            spd.start  = n;
            spd.length = 0;
            groups.push(gd);
          }
            continue;
          case '0': {
            create_text_node(v, el, spd.span(wc));
            // spans.push(spd);
            group_def gd;
            gd.type   = FIELD_ZNUMBER;
            gd.start  = n;
            gd.length = span_length(wc, n);
            n += gd.length;
            gd.el      = create_span_node(v, el, gd.length);
            spd.start  = n;
            spd.length = 0;
            groups.push(gd);
          }
            continue;
          /*case '^':
            {
              create_text_node(v, el, spd.span(wc));
              //spans.push(spd);
              group_def gd; gd.type = FIELD_NUMBER;
              gd.start = n; gd.length = span_length(wc,n);
              n += gd.length;
              gd.el = create_span_node(v,el,gd.length);
              spd.start = n; spd.length = 0;
              groups.push(gd);
            }
            continue;*/
          default: ++spd.length; ++n;
          }
        // spans.push(spd);
        create_text_node(v, el, spd.span(wc));

        update(v, el);
      }

      inline bool gen_mask(view &v, element *self, const tool::value &arr) {
        self->clear();
        _mask_def = arr;
        groups.clear();
        span_def     spd;
        array<wchar> m;
        for (uint n = 0; n < arr.size(); ++n) {
          tool::value zd = arr.get_element(n);
          if (zd.is_string()) {
            wchars wc = zd.get_chars();
            spd.length += uint(wc.length);
            m.push(wc);
          } else if (zd.is_array_like()) {
            create_text_node(v, self, spd.span(m()));
            group_def gd;
            gd.type   = FIELD_ENUM;
            gd.length = 1;
            gd.start  = m.size();
            for (uint k = 0; k < zd.size(); ++k) {
              ustring us = zd.get_element(k).to_string();
              gd.length  = max(gd.length, uint(us.length()));
              gd.enum_items.push(us);
            }
            m.push(ustring('_', gd.length));
            gd.el = create_span_node(v, self, gd.length);
            groups.push(gd);
            spd.start  = m.size();
            spd.length = 0;

          } else {
            create_text_node(v, self, spd.span(m()));
            group_def gd;
            ustring   s   = zd.get_prop("type").to_string();
            ustring   cls = zd.get_prop("class").to_string();
            if (s == WCHARS("integer")) {
                wchar mask_char = '#';
              gd.type = FIELD_NUMBER;
              if (zd.get_prop("leading-zero").to_bool()) {
                gd.type = FIELD_ZNUMBER;
                mask_char = '0';
              }
              gd.minv   = zd.get_prop("min").get(int_v::null_val());
              gd.maxv   = zd.get_prop("max").get(int_v::null_val());
              gd.step   = zd.get_prop("step").get(int_v::null_val());
              gd.start  = m.size();
              gd.length = zd.get_prop("width").get(1);
              m.push(ustring( mask_char, gd.length));
            } else if (s == WCHARS("enum")) {
              zd = zd.get_prop("items");
              if (!zd.is_array_like()) {
                zd = value::make_array(1);
                zd.set_element(0, value(WCHARS("{no items!}")));
              }
              create_text_node(v, self, spd.span(m()));
              gd.type   = FIELD_ENUM;
              gd.length = 1;
              gd.start  = m.size();
              for (uint k = 0; k < zd.size(); ++k) {
                ustring us = zd.get_element(k).to_string();
                gd.length  = max(gd.length, uint(us.length()));
                gd.enum_items.push(us);
              }
              m.push(ustring('_', gd.length));
              // gd.el = create_span_node(v,self,gd.length);
              // groups.push(gd);
              // spd.start = m.size(); spd.length = 0;
            } else // if(s == L"text")
            {
              assert(s == WCHARS("text"));
              gd.type   = FIELD_TEXT;
              gd.filter = zd.get_prop("filter").to_string();
              gd.start  = m.size();
              gd.minv   = zd.get_prop("min").get(int_v::null_val());
              gd.length = zd.get_prop("width").get(1);
              m.push(ustring('_', gd.length));
            }
            gd.el = create_span_node(v, self, gd.length, cls);
            groups.push(gd);
            spd.start  = m.size();
            spd.length = 0;
          }
        }
        // spans.push(spd);
        create_text_node(v, self, spd.span(m()));
        value t        = get_value_as_text(v, self);
        _mask          = m();
        compound_value = true;

        if (t.is_string())
          set_text_value(v, self, t.to_string());
        else
          set_text_value(v, self, ustring());

        v.add_to_update(self, CHANGES_MODEL);
        // update(v,self);

        return m.size() && groups.size();
      }

      // void measure(view& v, const element* self);

      int get_group_def(int pos) {
        for (int n = 0; n < groups.size(); ++n)
          if (uint(pos) >= groups[n].start &&
              uint(pos) < groups[n].start + groups[n].length)
            return n;
        // assert(false);
        return -1;
      }

      void select_group(view &v, element *self, int gn) {
        if (!groups.size()) return;
        if (_current_group != gn) {
          if (_current_group >= 0 && _current_group < groups.size()) {
            group_def &gd = groups[_current_group];
            gd.deselect(v,placeholder_char);
          }
          _current_group = gn;
          if (_current_group >= 0 && _current_group < groups.size()) {
            group_def &gd = groups[_current_group];
            gd.select(v,placeholder_char);
          }
        }
        event_behavior tevt(self, self, UI_STATE_CHANGED, gn);
        v.post_behavior_event(tevt, true);
      }

      virtual bool copy(view &v, element *self);
      virtual bool cut(view &v, element *self);
      virtual bool paste(view &v, element *self);

      virtual bool on(view &v, element *self, event_mouse &evt);
      virtual bool on(view &v, element *self, event_key &evt);
      virtual bool on(view &v, element *self, event_focus &evt);
      virtual bool on(view &v, element *self, event_command &evt);
      virtual bool on_x_method_call(html::view &v, element *self,
                                    const char *name, const value *argv,
                                    size_t argc, value &retval);

      virtual bool is_valid_char_at(element *self, wchar c, int pos) {
        int gn = get_group_def(pos);
        if (gn < 0) return false;
        return groups[gn].is_valid_char(c);
        /*switch(maskc)
        {
          case '_': return iswalnum(c) != 0;
          case '@': return iswalpha(c) != 0;
          case '#': return iswdigit(c) != 0;
        }
        return false;*/
      }

      virtual bool append_char(view &v, element *self, int &gn, wchar c) {
        if (gn < 0) return false;
        return groups[gn].handle_char(v, c);
      }

      virtual bool handle_key(view &v, element *self, uint k, bool isCtl,
                              bool isShift) {
        if (isCtl || isShift) return false;
        if (_current_group < 0) return false;
        group_def &gd      = groups[_current_group];
        int        inc_cmd = 0;
        switch (k) {
        case KB_UP: inc_cmd = +1; break;
        case KB_DOWN: inc_cmd = -1; break;
        case KB_HOME: inc_cmd = -2; break;
        case KB_END: inc_cmd = +2; break;
        default: return false;
        }
        event_behavior evt(self, self, uint(MASKED_EDIT_INCREMENT),
                           make_dword(word(inc_cmd), word(_current_group)));
        get_value(v, self, evt.data);
        if (v.send_behavior_event(evt)) {
          int cg = _current_group;
          set_value(v, self, evt.data);
          _current_group = cg;
          return true;
        }
        return gd.increment(v, inc_cmd);
      }

      virtual bool attach(view &v, element *self) {
        super::attach(v, self);
        this->self = self;
        ustring us = self->attr_value();
        set_text_value(v, self, us);
        update(v, self);
        select_group(v, self, -1);
        return true;
      }

      virtual void detach(view &v, element *self) {
        super::detach(v, self);
        groups.clear();
      }

      bool get_auto_width(view &v, element *self, int &value) {
        value = _auto_width.val(100);
        return true;
      }

      bool is_editable_pos(const ustring &mask, int pos) {
        if (pos < 0) return false;
        if (pos >= mask.size()) return false;
        wchar c = mask[pos];
        return is_editable_char(c);
      }

      /*virtual const array<wchar>& text( const element* self )
      {
        return text_block(self)->text;
      }

      virtual array<wchar>& mutable_text( element* self )
      {
        return text_block(self)->text;
      }*/

      int get_group_def(element *self, event_mouse &e) {
        if (e.cmd == MOUSE_WHEEL) {
          if (_current_group >= 0)
            return _current_group;
          return 0;
        }
        if (e.target && e.target->parent == self) 
          return e.target->index();
        return -1;
      }

      bool set_text_value(view &v, element *self, const ustring &val) {
        // array<wchar>& txt = mutable_text(self);
        ustring mask = get_mask(v, self);

        if (!mask.length()) return false;

        _is_empty = val.length() == 0;
        array<wchar> txt;
        txt     = mask;
        int end = mask.size();
        int n, spos = 0;
        for (n = 0; n < end; ++n) {
          if (is_editable_char(mask[n])) {
            wchar c = get_next_v_char(val, spos, mask[n]);
            if (c == placeholder_char || is_valid_char_at(self, c, n))
              txt[n] = c;
            else
              txt[n] = ' ';
          } else
            txt[n] = mask[n];
        }
        for (n = 0; n < groups.size(); ++n) {
          groups[n].set_text(v, groups[n].span(txt()));
        }
        return true;
      }


      value get_value_as_text(view &v, element *self) {
        if (_mask.is_empty()) return value();

        array<wchar> buf;
        for (int n = 0; n < self->nodes.size(); ++n)
          self->nodes[n]->emit_text(buf);
        // WRONG: self->emit_text(buf);
        return value(ustring(buf.head(), buf.size()));
      }

      wchar get_next_v_char(const ustring &s, int &spos, wchar mask_char) {
        for (; spos < s.size(); ++spos)
          if (iswalnum(s[spos])) {
            wchar t = s[spos];
            ++spos;
            return t;
          }
        return /*mask_char == '0'? '0' : */placeholder_char;
      }

      virtual bool set_value(view &v, element *self,
                             const value &val) override {
        if (val.is_array_like() && val.size() == groups.length()) {
          /*#ifdef _DEBUG
                int n1 = val.size();
                int n2 = groups.size();
          #endif*/
          for (int n = 0; n < int(val.size()); ++n) {
            if (!groups[n].set_value(v, val.get_element(n))) goto TRY_AS_TEXT;
          }
        } else if (val.is_undefined()) {
          set_text_value(v, self, ustring());
        } else {
        TRY_AS_TEXT:
          ustring us = (const wchar *)val.to_string();
          if (!set_text_value(v, self, us)) return false;
        }
        update(v, self);
        return true;
      }

      virtual bool get_value(view &pv, element *self, value &v) override {
        if (compound_value) {
          v = value::make_array(groups.size());
          for (int n = 0; n < groups.size(); ++n) {
            value t = groups[n].get_value();
            v.set_element(n, t);
          }
        }
        else if (check_valid(self))
          v = get_value_as_text(pv, self);
        else
          v = value();
        return true;
      }

      virtual int maxlength(element *self) {
        return 0;
        // ustring mask = get_mask(self);
        // return mask.length();
      }

      virtual bool notify_changed(view &v, element *self, uint reason) {
        // const style* cs = self->get_style(v);
        // v.add_to_update(self, false);
        event_behavior evt(self, self, EDIT_VALUE_CHANGED, reason);
        v.post_behavior_event(evt);
        return true;
      }

      virtual bool notify_changing(view &v, element *self, uint reason,
                                   array<wchar> &text) {
        event_behavior evt(self, self, EDIT_VALUE_CHANGING, reason);
        evt.data = value(text());
        if (v.send_behavior_event(evt)) {
          text = evt.data.get(W(""));
          return true;
        }
        return false;
      }

      void clear_all(view &v, element *self) {
        set_text_value(v, self, ustring());
      }

      bool delete_back(view &v, element *self);
      
      // script API
      bool setMask(tool::value mask) {
        if (mask.is_string()) {
          _mask = mask.to_string();
          return true;
        }
        else if (mask.is_array_like()) {
          ustring pmask = _mask;
          if(view* pv = self->pview())
          if (!gen_mask(*pv, self, mask)) 
            _mask = pmask;
          return true;
        }
        return false;
      }

      tool::value getMask() {
        return _mask_def;
      }

      bool selectAll() {
        if (view* pv = self->pview()) {
          select_group(*pv, self, -1);
          pv->refresh(self);
          return true;
        }
        return false;
      }

      bool selectGroup(int gn) {
        if (view* pv = self->pview()) {
          select_group(*pv, self, gn);
          pv->refresh(self);
          return true;
        }
        return false;
      }

      SOM_PASSPORT_BEGIN_EX(masked, masked_edit_ctl)
        SOM_FUNCS(
          SOM_FUNC(selectAll),
          SOM_FUNC(selectGroup))

        SOM_PROPS(
          SOM_VIRTUAL_PROP(mask, getMask, setMask)
        )
      SOM_PASSPORT_END

    };

    bool masked_edit_ctl::on(view &v, element *self, event_mouse &evt) {
      switch (evt.cmd) {
      case MOUSE_MOVE: {
        if (!evt.is_point_button() || evt.target != self) return false;
        int gn = get_group_def(self, evt);
        if (_current_group != gn)
          select_group(v, self, -1);
        else
          select_group(v, self, gn);
        return true;
      }
      case MOUSE_DOWN: {
        if (evt.is_point_button()) {
          v.set_focus(self, BY_MOUSE);
          int gn = get_group_def(self, evt);
          select_group(v, self, gn);
          v.set_capture(self);
          return true;
        }
        return false;
      }
      case MOUSE_DCLICK: {
        if (!evt.is_point_button()) return false;
        select_group(v, self, -1);
        return true;
      }
      case MOUSE_UP: {
        if (evt.is_point_button() && evt.target == self) {
          v.set_capture(0);
          return true;
        }
        return false;
      }
      case MOUSE_WHEEL:
        if (evt.get_wheel_delta() < 0) {
          int gn = get_group_def(self, evt);
          if (gn < 0) return false;
          select_group(v, self, gn);
          event_key ke(self, KEY_DOWN, KB_DOWN, 0);
          return on(v, self, ke);
        } else if (evt.get_wheel_delta() > 0) {
          int gn = get_group_def(self, evt);
          if (gn < 0) return false;
          select_group(v, self, gn);
          event_key ke(self, KEY_DOWN, KB_UP, 0);
          return on(v, self, ke);
        }
        return false;
      }
      return false;
    }

    bool masked_edit_ctl::delete_back(view &v, element *self) {
      // if( _current_group >= 0 && _current_group < groups.size())
      //  groups[_current_group].buf.clear();
      // else
      //  clear_all(v,self);
      if (_current_group < 0 || _current_group >= groups.size()) {
        if (check_empty(self)) return false;
        clear_all(v, self);
        notify_changed(v, self, CHANGE_BY_DEL_CHARS);
      } else {
        groups[_current_group].drop_char(v);
        notify_changed(v, self, CHANGE_BY_DEL_CHAR);
        if (groups[_current_group].is_empty() && _current_group)
          select_group(v, self, _current_group - 1);
      }
      v.refresh(self);
      return true;
    }

    bool masked_edit_ctl::on(view &v, element *self, event_key &evt) {
      if (!evt.target->belongs_to(self, true) && !self->state.current())
        return false; // that is a key targeted to something else (menu.context
                      // for example).

      // edit_auto_state _(this,self,v);

      if (evt.cmd == KEY_CHAR) {
        if (evt.key_code == 127 /* Ctrl+Backspace! */) return false;
        if (!is_editable(self)) return false;
        if (evt.is_alt()) return false;

        if (evt.key_code >= ' ' /*&& !evt.is_alt()*/) {
          /*int ml = maxlength(self);
          if( ml && text(self).size() >= ml )
          {
            //MessageBeep(MB_ICONEXCLAMATION);
            beep();
            return true;
          }*/
          if (_current_group < 0) _current_group = 0;
          if (_current_group >= groups.size()) return false;

          group_def &gd = groups[_current_group];

          if (gd.is_valid_char((wchar)evt.key_code)) {
            array<wchar> t;
            t.push((wchar)evt.key_code);
            notify_changing(v, self, CHANGE_BY_INS_CHAR, t);
            bool   changed = false;
            wchars chars   = t();
            bool   need_advance = false;
            while (!!chars) {
              if (gd.handle_char(v, chars++)) changed = true;
              if (gd.is_full())
                if (_current_group < groups.last_index())
                  select_group(v, self, _current_group + 1);
                else
                  need_advance = true;
            }
            if (changed) notify_changed(v, self, CHANGE_BY_INS_CHAR);
            if (need_advance)
              v.set_focus_on(view::FOCUS_NEXT);
            return true;
          } else
            beep();
          /*if( !gd.is_valid_char((wchar)evt.key_code) )
            beep();
          else if( gd.handle_char((wchar)evt.key_code) )
          {
            if( gd.is_full() )
            {
              if( self->current_style(*v)->direction == direction_rtl )
                select_group(v,self,max(0,_current_group - 1));
              else
                select_group(v,self,min(groups.last_index(),_current_group + 1));
            }
            return true;
          }*/
        }
        return false;
      } else if (evt.cmd == KEY_DOWN) {
        bool isCtl   = (evt.alt_state & ALT_SHORTCUT) != 0;
        bool isShift = (evt.alt_state & ALT_SHIFT) != 0;
        bool isAlt   = (evt.alt_state & ALT_ALT) != 0;
        if (isAlt) return false;

        switch (evt.key_code) {
        case KB_LEFT:
          if (_current_group == 0) 
            return false;
          if ((_current_group == -1) && groups.size())
            select_group(v, self, groups.last_index());
          else
            select_group(v, self, _current_group - 1);
          return true;
        case KB_RIGHT:
          if (_current_group == groups.last_index()) return false;
          if ((_current_group == -1) && groups.size())
            select_group(v, self, 0);
          else
            select_group(v, self, _current_group + 1);
          return true;
        case KB_BACK: return is_editable(self) && delete_back(v, self);
        case KB_A:
          if (isCtl) {
            select_group(v, self, -1);
            return true;
          }
          break;
        case KB_DELETE:
          if (is_editable(self)) {
            clear_all(v, self);
            notify_changed(v, self, CHANGE_BY_DEL_CHARS);
            return true;
          }
          return false;
        case KB_C:
          if (isCtl && !check_empty(self) && copy(v, self)) return true;
          break;
        case KB_INSERT:
          if (isShift) return is_editable(self) && paste(v, self);
          // break; - fall through
        case KB_X:
          if (isCtl && is_editable(self) && !check_empty(self) && cut(v, self))
            return true;
          break;
        case KB_V:
          if (isCtl && is_editable(self) && paste(v, self)) return true;
          break;
        /*case 'Z':
          if(isCtl) return is_editable(self) && undo(v,self);
          break;
        case 'Y':
                                        if(isCtl) return is_editable(self) &&
        redo(v,self); break;*/
        case KB_SHIFT:
          if (isCtl && self->get_style(v)->direction.is_defined()) {
            bool to_rtl = evt.is_right_shift();
            self->atts.set(attr::a_dir, to_rtl ? "rtl" : "ltr");
            self->drop_layout(&v);
            self->commit_measure(v);
            // move_caret(v, self, 0, false);
            return true;
          }
          break;
        }

        if (_current_group < 0) _current_group = 0;
        if (_current_group >= groups.size()) return false;

        if (is_editable(self) &&
            handle_key(v, self, evt.key_code, isCtl, isShift)) {
          v.refresh(self);
          notify_changed(v, self, CHANGE_BY_INS_CHAR);
          return true;
        }

        return false;
      }
      return false;
    }

    bool masked_edit_ctl::on_x_method_call(view &v, element *self,
                                           const char *name, const value *argv,
                                           size_t argc, value &retval) {
      chars fname = chars_of(name);
#define ACTION(ARGC, NAME) if (argc == ARGC && fname == CHARS(#NAME))
#define IFDO() if (argv[0].get(false))

      ACTION(1, mask) {
        if (argv[0].is_string()) {
          _mask = argv[0].to_string();
        }
        else if (argv[0].is_array_like()) {
          ustring pv = _mask;
          if (!gen_mask(v, self, argv[0])) _mask = pv;
        }
        return true;
      }

      ACTION(0, mask) {
        retval = _mask_def;
        return true;
      }


      ACTION(1, copy) {
        IFDO() {
          bool r = copy(v, self);
          retval = value(r);
          v.set_focus(self, BY_CODE);
        }
        else {
          bool r = check_empty(self);
          retval = value(!r);
        }
        return true;
      }

      ACTION(1, paste) {
        IFDO() {
          bool r = paste(v, self);
          retval = value(r);
          v.set_focus(self, BY_CODE);
        }
        else {
          bool r = is_editable(self) &&
                   (clipboard::available_formats() & clipboard::cf_text) != 0;
          retval = value(r);
        }
        return true;
      }

      ACTION(1, selectAll) {
        IFDO() {
          select_group(v, self, -1);
          v.refresh(self);
          return true;
        }
        else {
          bool r = check_empty(self);
          retval = value(!r);
        }
        return true;
      }

      ACTION(1, selectGroup) {
        int gn = argv[0].get(-1);
        select_group(v, self, gn);
        v.refresh(self);
        return true;
      }


#undef ACTION
      return super::on_x_method_call(v, self, name, argv, argc, retval);
    }

    bool masked_edit_ctl::on(view &v, element *self, event_focus &evt) {
      if (evt.cmd == FOCUS_IN || evt.cmd == (FOCUS_IN | EVENT_HANDLED)) {
        v.refresh(self);
        if (!evt.by_mouse()) select_group(v, self, 0);
        if (self->tag == tag::T_CAPTION && self->parent)
          self->parent->drop_styles(v);
        self->drop_styles(v);
        evt.need_ime = false; // need_ime(self);
        // show_caret(v,self,true);
        // self->sta
      } else if (evt.cmd == FOCUS_OUT ||
                 evt.cmd == (FOCUS_OUT | EVENT_HANDLED)) {
        v.refresh(self);
        // show_caret(v,self,false);
        self->drop_styles(v);
        if (self->tag == tag::T_CAPTION && self->parent)
          self->parent->drop_styles(v);
        select_group(v, self, -1);
        // clear_comp_chars(v,self);
        evt.need_ime = false;
      } else {
        v.refresh(self);
        return false;
      }
      return true;
    }

    bool masked_edit_ctl::check_empty(element *self) {
#pragma TODO("#4")
      // FOREACH(n,groups)
      //  if( groups[n].buf.size() == 0 ) return true;
      return false;
    }
    bool masked_edit_ctl::check_valid(element *self) {
      if (!check_empty(self)) FOREACH(n, groups)
      if (!groups[n].is_valid()) return false;
      return true;
    }

    bool masked_edit_ctl::copy(view &v, element *self) {
      value val = get_value_as_text(v, self);
      if (val.is_string()) {
        clipboard::set_text(val.get_chars());
        return true;
      }
      return false;
    }

    bool masked_edit_ctl::cut(view &v, element *self) {
      value val = get_value_as_text(v, self);
      if (val.is_string()) {
        clipboard::set_text(val.get_chars());
        clear_all(v, self);
        return true;
      }
      return false;
    }

    bool masked_edit_ctl::paste(view &v, element *self) {
      if (!is_readonly(self) &&
          clipboard::available_formats() & clipboard::cf_text) {
        ustring us;
        clipboard::get(us);
        array<wchar> text = us();
        notify_changing(v, self, CHANGE_BY_INS_CHARS, text);
        // edit_auto_state _(this,self,v);
        if (set_text_value(v, self, text())) {
          update(v, self);
          notify_changed(v, self, CHANGE_BY_INS_CHARS);
          return true;
        }
      }
      return false;
    }

    extern void enable_mi(view &v, element *m, wchars selector, bool onoff);

    bool masked_edit_ctl::on(view &v, element *self, event_command &evt) {
      if (!evt.doit() && !evt.checkit()) return false;

      ustring cmd = evt.command;
      if (cmd == event_command::EDIT_CUT()) {
        if (evt.doit()) return cut(v, self);
        evt.result = !check_empty(self) ? CMD_AVAILABLE : CMD_DISABLED;
        return true;
      } else if (cmd == event_command::EDIT_COPY()) {
        if (evt.doit()) return copy(v, self);
        evt.result = !check_empty(self) ? CMD_AVAILABLE : CMD_DISABLED;
        return true;
      } else if (cmd == event_command::EDIT_PASTE()) {
        if (evt.doit()) return paste(v, self);
        evt.result = is_editable(self) && (clipboard::available_formats() &
                                           clipboard::cf_text) != 0
                         ? CMD_AVAILABLE
                         : CMD_DISABLED;
        return true;
      } else {
        if (evt.checkit()) {
          evt.result = CMD_DISABLED;
          return true;
        }
      }
      return false;
    }

    bool masked_edit_ctl::group_def::is_valid_char(wchar c) {
      if (filter.length()) {
        tool::charset<wchar, wchar('~'), wchar(0)> cset;
        const wchar *                              f = filter;
        cset.parse(f);
        if (!cset.valid(c)) return false;
      }
      switch (type) {
      case FIELD_TEXT: return is_alnum(c) != 0;
      case FIELD_ALPHA_TEXT: return is_alpha(c) != 0;
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: return is_digit(c) != 0;
      case FIELD_ENUM: return c == ' ' || is_alnum(c) != 0;
      }
      return false;
    }

    bool masked_edit_ctl::group_def::is_empty() const {
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT:
      case FIELD_NUMBER:
      case FIELD_ZNUMBER:
      case FIELD_ENUM: {
        wchars t = trim(chars());
        return t.length == 0;
      } break;
      default: return true;
      }
    }

    bool masked_edit_ctl::group_def::handle_char(view &v, ucode uc) {

      array<wchar> buffer;// = chars();

      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT:
        if (trim(chars()).length >= length) {
          text().clear();
          text().push(' ', length);
        }
        text()[index_t(trim(chars()).length)] = wchar(uc);
        update(v); // v.add_to_update(el,true);
        return true;
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: 
      {
        buffer = trim(chars());
        if (buffer.length() >= length)
          buffer.clear();
        buffer.push(wchar(uc));
        bool invalid = false;
        if (buffer.length() >= length) {
          int64 n = parse_int64(trim(buffer()));
          if (maxv.is_defined() && n > maxv) {
            buffer = i64tow(maxv, 10);
            //invalid = true;
          }
          if (minv.is_defined() && n < minv) {
            buffer = i64tow(minv, 10);
            //invalid = true;
          }
        }
        //set_text(v, buffer());
        if (buffer.length() < length)
          buffer.insert(0, ' ', length - buffer.length());
        text() = buffer;
        el->state.invalid(invalid);
        update(v); // v.add_to_update(el,true);
      }
      return true;


      case FIELD_ENUM:
        if (uc == ' ') {
          int n = (enum_no + 1) % enum_items.size();
          set_text(v, wchars(enum_items[n]));
          enum_no = n;
          return true;
        } else {
          int n = enum_no + 1;
          for (int i = 0; i < enum_items.size(); ++i, ++n) {
            n %= enum_items.size();
            if (to_upper(enum_items[n][0]) == to_upper(wchar(uc))) {
              text() = wchars(enum_items[n]);
              text().push(' ', length - text().length());
              enum_no = n;
              update(v); // v.add_to_update(el,true);
              return true;
            }
          }
        }
        return false;
      default: return false;
      }
    }

    bool masked_edit_ctl::group_def::drop_char(view &v) {
      if (is_empty()) return false;
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT: {
        text()[index_t(trim(chars()).length - 1)] = ' ';
        update(v); // v.add_to_update(el,true);
      } break;
      //case FIELD_ZNUMBER:
      case FIELD_NUMBER: {
        text().pop();
        text().insert(0, ' ');
        update(v); // v.add_to_update(el,true);
      } break;
      case FIELD_ZNUMBER: {
        text().pop();
        text().insert(0, '0');
        update(v); // v.add_to_update(el,true);
      } break;
      case FIELD_ENUM:
        text().clear();
        text().push(' ', length);
        update(v); // v.add_to_update(el,true);
        break;
      default: return false;
      }
      return true;
    }

    void masked_edit_ctl::group_def::set_text(view &v, wchars val) {
      //WRONG: val = trim(val); spaces are significant here
      text() = val;
      if( val.length )
        switch (type) {
        case FIELD_TEXT:
        case FIELD_ALPHA_TEXT:
          if (val.length < length) text().push(' ', length - val.length);
          break;
        case FIELD_ENUM:
          el->set_attr("value", val);
          if (val.length < length) text().push(' ', length - val.length);
          break;
        case FIELD_NUMBER:
          if (val.length < length) text().insert(0, ' ', length - val.length);
          break;
        case FIELD_ZNUMBER:
          if (val.length < length) text().insert(0, '0', length - val.length);
          break;
        default: return;
        }

      update(v); // v.add_to_update(el,true);
    }


    void masked_edit_ctl::group_def::deselect(view &v, wchar placeholder_char) {
      ustring text = trim(chars());
      set_text(v, text.length() ? text() : ustring(placeholder_char,this->length)());
      el->state.current(false);
      constraint_value(v);
      el->state.invalid(!is_valid());
      update(v); // v.add_to_update(el,true);
    }
    
    void masked_edit_ctl::group_def::select(view &v, wchar placeholder_char) {
      array<wchar> buffer = trim(text()(), [placeholder_char](wchar c) { return is_space(c) || c == placeholder_char; });
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT:
        if (buffer.length() < length) buffer.push(' ', length - buffer.length());
        break;
      case FIELD_ENUM:
        el->set_attr("value", buffer());
        if (buffer.length() < length) buffer.push(' ', length - buffer.length());
        break;
      case FIELD_ZNUMBER:
      case FIELD_NUMBER:
        //buffer = trim_left(buffer(), [](wchar c) { return is_space(c) || c == '0'; });
        //buffer = trim_left(buffer());
        if (buffer.length() < length) buffer.insert(0, ' ', length - buffer.length());
        break;
      default: return;
      }
      text() = buffer;
      el->state.current(true);
      update(v);
    }

    bool masked_edit_ctl::group_def::constraint_value(view &v) {
      wchars wc = trim(text()());
      if(wc.length)
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT: return false;
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: {
        int maxn = maxv.val(int(pow(10.0, int(length))) - 1);
        int minn = minv.val(0);
        int n = parse_int(text()());
        bool change = false;
        if (n > maxn) { n = maxn; change = true; }
        if (n < minn) { n = minn; change = true; }
        if (change) {
          set_text(v, itow(n, 10));
          return true;
        }
        break;
      }
      case FIELD_ENUM: {
        int    n = -1;
        for (int i = 0; i < enum_items.size(); ++i)
          if (enum_items[i] == wc) {
            n = i;
            break;
          }
        if (n < 0) { 
          set_text(v, wchars(enum_items[0]));
          return true;
        }
        break;
      }
      default: break;
      }
      return false;
    }
    
    bool masked_edit_ctl::group_def::increment(view &v, int inc_cmd) {
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT: return false;
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: {
        // int stepv = step.val(1);
        int maxn = maxv.val(int(pow(10.0, int(length))) - 1);
        int minn = minv.val(0);
        int n    = parse_int(text()());
        switch (inc_cmd) {
        case +1:
          ++n;
          if (n > maxn) n = minn;
          break;
        case -1:
          --n;
          if (n < minn) n = maxn;
          break;
        case -2: n = minn; break;
        case +2: n = maxn; break;
        }
        set_text(v, itow(n, 10));
        return true;
      }
      case FIELD_ENUM: {
        wchars wc = text()();
        int    n  = 0;
        for (int i = 0; i < enum_items.size(); ++i)
          if (enum_items[i] == wc) {
            n = i;
            break;
          }
        switch (inc_cmd) {
        case +1:
          ++n;
          if (n > enum_items.last_index()) n = 0;
          break;
        case -1:
          --n;
          if (n < 0) n = enum_items.last_index();
          break;
        case -2: n = 0; break;
        case +2: n = enum_items.last_index(); break;
        }
        set_text(v, wchars(enum_items[n]));
        return true;
      }
      default: return false;
      }
    }

    bool masked_edit_ctl::group_def::set_value(view &v, const value &val) {
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT:
      case FIELD_ENUM: {
        ustring us = val.to_string();
        if (type == FIELD_ENUM) enum_no = enum_items.get_index(us);
        wchars uc = us;
        uc.length = limit<size_t>(uc.length, 0, length);
        set_text(v, uc);
        return true;
      }
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: {
        if (val.is_undefined())
          set_text(v, wchars());
        else
          set_text(v, itow(val.to_int(), 10));
        return true;
      }
      default: return false;
      }
    }

    value masked_edit_ctl::group_def::get_value() {
      wchars t = trim(text()());
      if (t.length == 0)
        return value();
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT:
      case FIELD_ENUM: {
        // PLACEHOLDER_CHAR
        return value(t);
      }
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: {
        int    n = 0;
        if (parse_int(t, n, 10)) return value(n);
        return value();
      }
      default: return value();
      }
    }

    bool masked_edit_ctl::group_def::is_valid() const {
      switch (type) {
      case FIELD_TEXT:
      case FIELD_ALPHA_TEXT: {
        if (minv.is_defined() && minv <= int(length))
          return chars().size() >= minv;
        return true;
      }
      case FIELD_NUMBER:
      case FIELD_ZNUMBER: {
        int n;
        auto text = chars();
        if (!parse_int(text, n, 10))
          return false;

        if (minv.is_defined() || maxv.is_defined()) {
          int maxn = maxv.val(int(pow(10.0, int(length))) - 1);
          int minn = minv.val(0);
          return is_between(n, minn, maxn);
        }
        return true;
      }
      case FIELD_ENUM: {
        for (int i = 0; i < enum_items.size(); ++i) {
          wchars wc = enum_items[i];
          if (wc == chars()) return true;
        }
        return false;
      }
      default: return false;
      }
    }

    void masked_edit_ctl::group_def::update(view &v) {
      v.refresh(el->parent);
      el->drop_layout();
      el->drop_style(&v);
    }

    ctl *masked_edit_ctl_factory::create(element *el) {
      return new masked_edit_ctl();
    }

    void init_masked_edit() {
      ctl_factory::add(_masked_edit_ctl_factory =
                           new masked_edit_ctl_factory());
    }
  }
} // namespace html
