#include "html.h"

namespace html {

  void ctl::on_attr_change(view &v, element *self, const name_or_symbol &nm) {
    if (nm == attr::a_value)
      set_value(v, self, value(self->attr_value()));
  }
  
  namespace behavior {

    struct edit_ctl_factory : public ctl_factory {
      edit_ctl_factory() : ctl_factory("edit") {}
      virtual ctl *create(element *el) { return new edit_ctl(); }
    };

    static edit_ctl_factory *_edit_ctl = 0;

    const string &edit_ctl::behavior_name() const { return _edit_ctl->name; }

    bool edit_ctl::attach(view &v, element *_this) {
      if (_this->get_style(v)->collapse_ws()) {
        view::debug_printf(
            OT_DOM, OS_ERROR,
            "behavior:edit requires white-space:pre or prewrap\n");
        return false;
      }

      _this->check_layout(v);
      // assert(_this->layout_type() == flow_text);
      self = _this->layout_type() == flow_text ? _this->cast<text_block>() : 0;
      if (!self) return false;
      ustring val = self->atts.get_ustring(attr::a_value, W(""));

      array<wchar> &bf = edit_buffer(v, self);
      if (!val.is_empty()) {
        bf.clear();
        bf.push(val);
      } 
      //v.add_to_update(self, CHANGES_MODEL);
      _is_empty = bf.length() == 0;
      return true;
    }

    array<wchar> &edit_ctl::edit_buffer(view &v, element *self) {
      if (self->nodes.size() == 0 || !self->nodes[0]->is_text()) {
        //bool ldata_valid = self->is_layout_valid();
        array<wchar> t;
        self->emit_text(t);
        for (helement c = self->first_element(); c; c = c->next_element())
          c->stray(v);
        self->nodes.clear();
        self->append(new text(t()));
        self->drop_style(&v);
        self->drop_layout(&v);
        self->setup_layout(v);
      }
      return self->nodes[0]->cast<text>()->chars;
    }

    bool edit_ctl::get_auto_width(view &v, element *self, int &value) {
      int sz = self->atts.get_int(attr::a_size, 18);
      if (sz) {
        value = sz * (pixels(v, self, self->get_style(v)->font_size).height() * 3) / 4;
      } else
        value = 150;
      return true;
    }
    bool edit_ctl::get_auto_height(view &v, element *self, int &value) {
      style *cs = self->get_style(v);
      int    sz = pixels(v, self, cs->font_size).height();
      int    h  = v.get_font(cs)->height(float(sz));
      if (cs->line_height.is_defined())
        h = cs->line_height.pixels(cs->font_size, sz);
      value = h;
      return true;
    }

    struct password_ctl_factory : public ctl_factory {
      password_ctl_factory() : ctl_factory("password") {}
      virtual ctl *create(element *el) { return new password_ctl(); }
    };

    static password_ctl_factory *_password_ctl = 0;

    const string &password_ctl::behavior_name() const {
      return _password_ctl->name;
    }

    array<wchar> &password_ctl::edit_buffer(view &v, element *self) {
      return _buffer;
    }
    void password_ctl::update(view &v, element *self) {
      wchar pchar = placeholder(self);

      wchars buffer = _buffer();
      // if(buffer.ends_with(WCHARS("\r")))
      //  buffer.prune(0,1);

      uint          nchars   = u16::codepoints(buffer);
      array<wchar> &torender = super::edit_buffer(v, self);
      torender.clear();
      torender.push(pchar, nchars);
      // if( !torender().ends_with(WCHARS("\r")) )
      //  torender.push(WCHARS("\r"));
      super::update(v, self);
    }

    bool password_ctl::attach(view &v, element *_this) {
      if (_this->get_style(v)->collapse_ws()) {
        view::debug_printf(
            OT_DOM, OS_ERROR,
            "behavior:password requires white-space:pre or prewrap\n");
        return false;
      }

      _this->check_layout(v);
      assert(_this->layout_type() == flow_text);
      self = _this->layout_type() == flow_text ? _this->cast<text_block>() : 0;
      if (!self) return false;
      _buffer = self->atts.get_ustring(attr::a_value, W(""));

      wchar pchar  = placeholder(self);
      uint  nchars = u16::codepoints(_buffer());

      array<wchar> &torender = super::edit_buffer(v, self);
      torender.clear();
      if (nchars) {
        torender.push(pchar, nchars);
        self->drop_style(&v);
        self->drop_layout(&v);
        self->setup_layout(v);
      }
      check_empty(v, self);
      return true;
    }

    wchar password_ctl::placeholder(element *self) {
      ustring ss = get_attr(self, "-password-char");
      if (ss.length())
        return ss[0];
      else
        return 0x25cf;
    }

    bool password_ctl::move_caret(view &v, ADVANCE_DIR dir, bool keep_anchor,
                                  uint n) {
      return super::move_caret(v, dir, keep_anchor, n);
    }

    // used by script to get value
    //bool password_ctl::get_text(view & v, element * self, ustring & val)
    //{
    //    val.clear();
    //    return true;
    //}

    bool password_ctl::get_value(view &v, element *self, value &val) {
      ustring text;
      get_text(v, self,text);
      val = value(text, value::UT_SECURE);
      return true;
    }

    bool password_ctl::a11y_get_value(view & v, element * self, ustring & sval)
    {
        ustring text;
        super::get_text(v, self, text);

        wchar pchar = placeholder(self);
        sval = ustring(pchar,text.length());
        return true;
    }

    void init_edit_ctl() {
      ctl_factory::add(_edit_ctl = new edit_ctl_factory());
      ctl_factory::add(_password_ctl = new password_ctl_factory());
    }

  } // namespace behavior
} // namespace html