#include "html.h"
#include "html-behaviors.h"

namespace html {
  namespace behavior {

#define W_THRESHOLD 3

    struct column_resizer_ctl_factory : ctl_factory {
      column_resizer_ctl_factory() : ctl_factory("column-resizer") {}
      virtual ctl *create(element *el) override;
    };

    column_resizer_ctl_factory *_column_resizer_ctl = 0;

#if !defined(FLEX_COLUMN_RESIZER) && 0

    struct column_resizer_ctl : ctl {
      bool            tracking;
      int             column_no;
      handle<element> column_header;
      int             offset;
      int             pos_x;
      range           content_x;

      column_resizer_ctl() : ctl(), tracking(false) {}

      virtual const string &behavior_name() const override {
        return _column_resizer_ctl->name;
      }
      virtual CTL_TYPE get_type() override { return CTL_UNKNOWN; }

      virtual bool attach(view &v, element *self) override {
        ctl::attach(v, self);
        return true;
      }

      virtual void detach(view &v, element *self) override {
        column_header = 0;
      }

      /*virtual bool get_scroll_data(view& v, element* self, scroll_data& sd)
      {
        return false;
      }*/

      bool do_resize(view *v, element *self) {
        if (!column_header) return false;

        // nail down all flexes:

        helement headrow = self->first_element();
        if (headrow->tag != tag::T_TR) return false;

        for (helement th = headrow->first_element(); th;
             th          = th->next_element()) {
          size sz = th->border_box(*v).size();
          sz.x -=
              th->border_distance(*v).left() + th->border_distance(*v).right();
          sz           = v->pixels_per_dip(sz);
          size_v toset = size_v(sz.x, size_v::dip);

          if (th->get_style(*v)->width == toset) continue;

          if (!th->a_style) th->a_style = new style();
          th->a_style->width = toset;
          th->drop_style(v);
        }

        handle<column_resizer_ctl> this_holder = this;
        handle<view>               view_holder = v;
        handle<element>            self_holder = self;

        tracking = true;
        v->set_capture_strict(column_header);
        while (tracking && v->do_event(DO_EVENT_WAIT)) {
          if (v->get_capture() != column_header) return false;
        }
        v->set_capture(0);
        return true;
      }

      virtual bool on(view &v, element *self, event_mouse &evt) override {

        // if( !is_on_table(self) )
        //  return false;
        if (tracking) return on_tracking(v, self, evt);

        switch (evt.cmd) {
        case MOUSE_CHECK:
        case MOUSE_CHECK | EVENT_SINKING:
        case MOUSE_MOVE:
        case MOUSE_MOVE | EVENT_SINKING:
          if (is_on_column_boundary(v, self, evt.target,
                                    evt.pos + self->scroll_pos())) {
            evt.cursor = cursor::system(cursor_e_resize);
            return true;
          }
          break;
        case MOUSE_DOWN | EVENT_SINKING:
          if (evt.is_point_button() &&
              is_on_column_boundary(v, self, evt.target,
                                    evt.pos + self->scroll_pos())) {
            evt.cursor = cursor::system(cursor_e_resize);
            // v.post(delegate(this,&column_resizer_ctl::do_resize,&v,self),true);
            do_resize(&v, self);
            return true;
          }
          break;
        }
        return false;
      }

      bool is_table(element *self) {
        return self->layout_type() == flow_table ||
               self->layout_type() == flow_table_fixed;
      }
      bool is_table_section(element *self) {
        return self->layout_type() == flow_table_row;
      }

      bool is_h_scrollbale(view &v, element *self) {
        if (is_table_section(self)) self = self->owner;
        return self->get_style(v)->overflow_x >= overflow_auto;
      }

      element *get_table(element *self) {
        while (self) {
          if (is_table(self)) return self;
          self = self->owner;
        }
        return 0;
      }

      virtual bool on_tracking(view &v, element *self, event_mouse &evt) {
        evt.cursor = cursor::system(cursor_e_resize);
        switch (evt.cmd) {
        case MOUSE_CHECK:
        case MOUSE_CHECK | EVENT_SINKING:
          // case MOUSE_TICK:
          // case MOUSE_TICK | EVENT_SINKING:
          evt.cursor = cursor::system(cursor_e_resize);
          return true;
        case MOUSE_MOVE | EVENT_SINKING: {
          evt.cursor = cursor::system(cursor_e_resize);
          if (!evt.is_point_button() || evt.is_prop_button() ||
              !column_header) {
            tracking = false;
            return false;
          }

          point pos =
              self->scroll_pos() + evt.pos - column_header->rel_pos(v, self);

          int w  = 0;
          int dw = 0;

          helement ch = column_header;
          helement cr = ch->parent;

          // table* parent_table(element *el);

          if (self->get_style(v)->direction == direction_rtl) {
            dw = -pos.x + offset;
            w  = ch->border_box(v).right() + dw;
            w -= ch->border_distance(v).left() +
                 column_header->border_distance(v).right();
          } else {
            // size sz = column_header->content_box(v).size();
            w = pos.x + offset - column_header->border_distance(v).right();
          }

          // int minw = column_header->min_width(v,self->dim().x);
          hstyle tds  = ch->get_style(v);
          int    minw = tds->min_width.pixels_width(v, column_header, 0);
          if (w < minw) w = minw;
          int maxw = tds->max_width.is_defined()
                         ? tds->max_width.pixels_width(v, column_header, 0)
                         : limits<int>::max_value();
          if (w > maxw) w = maxw;

          if (ch->dim().x == w) return true;

          /*if( ch->index() == cr->n_children() - 2  // if it is last but one
             || ch->get_style(v)->width.is_spring()  // or is flex then we need
          to resize its next sibling
            )
          {
             dw = w - ch->dim().x;
             ch = ch->next_element();
             w = ch->dim().x - dw;
          }*/

          {
            if (!ch->a_style) ch->a_style = new style();

            ch->a_style->width = size_v(w);
            ch->clear_style();

            // dbg_printf("column=%d width=%d\n", column_header->index(), w);

            element *tbl = get_table(self);
            if (tbl) {
              // tbl->drop_layout(&v);
              tbl->_commit_measure(v);
              v.refresh(tbl);
              v.update_element(tbl);
            } else {
              tracking = false;
              return true;
            }
            // dbg_printf("column=%d width=%d\n",column_no,w);
          }
          evt.cursor = cursor::system(cursor_e_resize);
        }
          return true;

        case MOUSE_UP:
          tracking   = false;
          evt.cursor = cursor::system(cursor_e_resize);
          return true;
        }
        return false;
      }

      bool is_on_column_boundary(view &v, element *self, element *target,
                                 point pos) {
        // target->dbg_report("is_on_column_boundary");
        element *th =
            find_first_parent(v, target, WCHARS("thead>tr>th,thead>tr>td"));
        if (!th) return false;
        if (!th->belongs_to(v, self, true)) return false;
        // if( !th->next_element() )
        //  return false;
        pos -= th->rel_pos(v, self);

        int   x;
        range xrt;

        auto is_fixed = [](view &v, element *th) -> bool {
          const style *cs = th->get_style(v);
          return cs->min_width.is_defined() && (cs->min_width == cs->max_width);
        };

        if (th->get_style(v)->direction == direction_rtl) {
          // if( th->prev_element() == 0 ) // we are not resizing first column
          //  return false;
          if (is_fixed(v, th)) return false;
          x   = th->border_box(v).left();
          xrt = range(x - W_THRESHOLD, x + W_THRESHOLD);
        } else {
          // if( th->next_element() == 0 ) // we are not resizing last column
          //  return false;
          if (is_fixed(v, th)) return false;
          x   = th->border_box(v).right();
          xrt = range(x - W_THRESHOLD, x + W_THRESHOLD);
        }

        if (pos.x && xrt) {
          offset        = x - pos.x;
          column_header = th;
          return true;
        }
        return false;
      }
    };

#else
    struct column_resizer_ctl : ctl {
      bool            tracking;
      int             column_no;
      handle<element> column_header;
      int             offset;
      int             pos_x;
      range           content_x;

      column_resizer_ctl() : ctl(), tracking(false) {}

      virtual const string &behavior_name() const override {
        return _column_resizer_ctl->name;
      }
      virtual CTL_TYPE get_type() override { return CTL_UNKNOWN; }

      virtual bool attach(view &v, element *self) override {
        ctl::attach(v, self);
        return true;
      }

      virtual void detach(view &v, element *self) override {
        column_header = 0;
      }

      //virtual bool ssx_disable_reconcilition(element* self, bool& disable) { return false; }
      virtual element* r13n_container(element* self) override { return self; }

      /*virtual bool get_scroll_data(view& v, element* self, scroll_data& sd)
      {
        return false;
      }*/

      bool do_resize(view *v, element *self) {
        if (!column_header) return false;

        handle<column_resizer_ctl> this_holder = this;
        handle<view>               view_holder = v;
        handle<element>            self_holder = self;

        tracking = true;
        v->set_capture_strict(column_header);
        while (tracking && v->do_event(DO_EVENT_WAIT)) {
          if (v->get_capture() != column_header) return false;
        }
        v->set_capture(0);
        return true;
      }

      virtual bool on(view &v, element *self, event_mouse &evt) override {

        // if( !is_on_table(self) )
        //  return false;
        if (tracking) return on_tracking(v, self, evt);

        switch (evt.cmd) {
        case MOUSE_CHECK:
        case MOUSE_CHECK | EVENT_SINKING:
        case MOUSE_MOVE:
        case MOUSE_MOVE | EVENT_SINKING:
          if (is_on_column_boundary(v, self, evt.target, evt.pos + self->scroll_pos())) {
            evt.cursor = cursor::system(cursor_e_resize);
            return true;
          }
          break;
        case MOUSE_DOWN | EVENT_SINKING:
          if (evt.is_point_button() &&
              is_on_column_boundary(v, self, evt.target, evt.pos + self->scroll_pos())) {
            evt.cursor = cursor::system(cursor_e_resize);
            do_resize(&v, self);
            return true;
          }
          break;
        case MOUSE_DCLICK: {
            helement th = is_on_column_boundary(v, self, evt.target, evt.pos + self->scroll_pos());
            if (th) {
              event_behavior evt(th, th, CUSTOM, 0);
              evt.name = WCHARS("doubleclick-gap");
              return v.send_behavior_event(evt);
            }
          }
          break;
        case MOUSE_TCLICK: {
            helement th = is_on_column_boundary(v, self, evt.target, evt.pos + self->scroll_pos());
            if (th) {
              event_behavior evt(th, th, CUSTOM, 0);
              evt.name = WCHARS("tripleclick-gap");
              return v.send_behavior_event(evt);
            }
          }
          break;

        }
        return false;
      }

      bool is_table(element *self) {
        return self->layout_type() == flow_table ||
               self->layout_type() == flow_table_fixed;
      }
      bool is_table_section(element *self) {
        return self->layout_type() == flow_table_row;
      }

      bool is_h_scrollbale(view &v, element *self) {
        if (is_table_section(self)) self = self->get_owner();
        return self->get_style(v)->overflow_x >= overflow_auto;
      }

      element *get_table(element *self) {
        while (self) {
          if (is_table(self)) return self;
          self = self->get_owner();
        }
        return 0;
      }

      bool has_springs_before(view &v, element *column) {
        if (column->get_style(v)->width.is_spring()) return true;
        element *prev = column->prev_element();
        if (prev) return has_springs_before(v, prev);
        return false;
      }

      bool has_springs_after(view &v, element *column) {
        if (column->get_style(v)->width.is_spring()) return true;
        element *next = column->next_element();
        if (next) return has_springs_after(v, next);
        return false;
      }

      virtual bool on_tracking(view &v, element *self, event_mouse &evt) {
        evt.cursor = cursor::system(cursor_e_resize);
        switch (evt.cmd) {
        case MOUSE_CHECK:
        case MOUSE_CHECK | EVENT_SINKING:
          // case MOUSE_TICK:
          // case MOUSE_TICK | EVENT_SINKING:
          evt.cursor = cursor::system(cursor_e_resize);
          return true;
        case MOUSE_MOVE | EVENT_SINKING: {
          evt.cursor = cursor::system(cursor_e_resize);
          if (!evt.is_point_button() || evt.is_prop_button() || !column_header) {
            tracking = false;
            return false;
          }

          point pos = self->scroll_pos() + evt.pos - column_header->rel_pos(v, self);

          int w  = 0;
          int dw = 0;

          helement ch = column_header;
          helement cr = ch->parent;

          // table* parent_table(element *el);

          if (self->get_style(v)->direction == direction_rtl) {
            dw = -pos.x + offset;
            w  = ch->border_box(v).right() + dw;
          } else {
            w = pos.x + offset;
          }
          auto bd = ch->border_distance(v);
          w -= bd.left() + bd.right();

          // int minw = column_header->min_width(v,self->dim().x);
          hstyle tds  = ch->get_style(v);
          int    minw = pixels(v, column_header, tds->min_width).width();
          if (w < minw) w = minw;
          int maxw = tds->max_width.is_defined()
                         ? pixels(v, column_header, tds->max_width).width()
                         : limits<int>::max_value();
          if (w > maxw) w = maxw;

          if (ch->dim().x == w) return true;

          helement ch_next = ch->next_element();

          if (ch_next && has_springs_before(v, ch)) {
            dw = w - ch->dim().x;
            ch = ch->next_element();
            w  = ch->dim().x - dw;
          }

          {
            ch->update_a_style(v, ch->doc(), [w](style_prop_map& s)->bool {
              s.set(cssa_width, value::make_length(w,value::ppx));
              return true;
            });

            // dbg_printf("column=%d width=%d\n", column_header->index(), w);

            element *tbl = get_table(self);
            if (tbl) {
              tbl->drop_layout(&v);
              tbl->commit_measure(v);
              v.refresh(tbl);
              v.update_element(tbl);
              event_behavior tevt(ch, ch, UI_STATE_CHANGED, 0);
              v.post_behavior_event(tevt, true);
            } else {
              tracking = false;
              return true;
            }
            // dbg_printf("column=%d width=%d\n",column_no,w);
          }
          evt.cursor = cursor::system(cursor_e_resize);
        }
          return true;

        case MOUSE_UP:
          tracking   = false;
          evt.cursor = cursor::system(cursor_e_resize);
          return true;
        }
        return false;
      }

      helement is_on_column_boundary(view &v, element *self, element *target, point pos) {
        // target->dbg_report("is_on_column_boundary");
        element *th =
            find_first_parent(v, target, WCHARS("thead>tr>th,thead>tr>td"));
        if (!th) return nullptr;
        if (!th->belongs_to(v, self, true)) return nullptr;
        // if( !th->next_element() )
        //  return false;
        pos -= th->rel_pos(v, self);

        int   x;
        range xrt;

        auto is_fixed = [](view &v, element *th) -> bool {
          const style *cs = th->get_style(v);
          return cs->min_width.is_defined() && (cs->min_width == cs->max_width);
        };

        //int w_threshold = v.pixels_per_dip(size(W_THRESHOLD, W_THRESHOLD)).x;

        if (th->get_style(v)->direction == direction_rtl) {
          // if( th->prev_element() == 0 ) // we are not resizing first column
          //  return false;
          if (!th->prev_element() &&
              has_springs_after(v, th)) // we are not resizing first column in
                                        // presense of springs
            return nullptr;
          if (is_fixed(v, th)) return nullptr;

          int hit_margin = max(W_THRESHOLD,th->hit_margin_distance(v).left());

          x   = th->border_box(v).left();
          xrt = range(x - hit_margin, x + hit_margin);
        } else {
          if (!th->next_element() &&
              has_springs_before(
                  v,
                  th)) // we are not resizing last column in presense of springs
            return nullptr;
          if (is_fixed(v, th)) return nullptr;
          x   = th->border_box(v).right();
          int hit_margin = max(W_THRESHOLD,th->hit_margin_distance(v).right());
          xrt = range(x - hit_margin, x + hit_margin);
        }

        if (xrt.contains(pos.x)) {
          offset        = x - pos.x + th->border_distance(v).left();
          column_header = th;
          return th;
        }
        return nullptr;
      }
    };

#endif

    ctl *column_resizer_ctl_factory::create(element *el) {
      return new column_resizer_ctl();
    }

    void init_table_ctl() {
      ctl_factory::add(_column_resizer_ctl = new column_resizer_ctl_factory());
    }
  }
} // namespace html
