#ifndef __html_csss_rt_h__
#define __html_csss_rt_h__

#include "tool/tool.h"
#include "gool/gool.h"
#include "html-dom.h"

namespace html {
  extern bool parse_state_flag(const string &val, ui_state &s);

  namespace csss // the CSSS! thing.
  {
    using namespace tool;
    using namespace gool;

    // support of eval CSS attributes

    enum element_value_id {
      BV_VALUE = 0,
      BV_INDEX = 1,
    };

    struct exec_env {
      view &    v;
      helement  self;
      eval::vm *pvm;

      exec_env(view &vw, element *pb) : v(vw), self(pb), pvm(0) {}
      virtual ~exec_env() {}

      void clear_attr(element *b, name_or_symbol ns) {
        if (b->atts.exist(ns)) { b->remove_attr(ns); }
      }
      void set_attr(element *b, name_or_symbol ns, const ustring &nv) {
        ustring ov = b->atts(ns);
        if (ov != nv) { b->set_attr(ns, nv); }
      }

      bool get_state(element *b, uint64 flag) {
        ui_state st = b->get_state(false);
        return st.is_set(flag);
      }

      bool get_value(element *b, element_value_id bvid, value &val) {
        switch (bvid) {
        case BV_VALUE:
          if (b->get_value(v, val)) return true;
          break;
        case BV_INDEX:
          val = value(b->index() + 1);
          return true;
          break;
        }
        return false;
      }
      bool set_value(element *b, element_value_id bvid, const value &val) {
        switch (bvid) {
        case BV_VALUE:
          if (b->set_value(v, val)) return true;
          break;
        case BV_INDEX: return false;
        }
        return false;
      }

      // try to call outer world -> e.g.
      // htmlayout::event_handler::handle_scripting_call
      bool call_world(element *b, wchars name, uint argn, const value *argv,
                      value &retval) {
        uint n;
        char x_name[64];
        for (n = 0; n < min(63u, name.length); ++n)
          x_name[n] = (char)name[n];
        x_name[n] = 0;
        // json::value x_argv[16];
        //   for(n = 0; n < min(16,argn); ++n ) x_argv[n] =
        //   value2value(argv[n]);

        scripting_params sp;
        sp.csss_call   = true;
        sp.method_name = x_name;
        sp.argc        = argn;
        sp.argv        = argv;

        if (b == 0) {
          if (v.call_behavior_method(&sp)) {
            retval = sp.retval;
            return true;
          }
        } else if (v.call_behavior_method(b, &sp)) {
          retval = sp.retval;
          return true;
        }
        return false;
      }

      bool call(element *b, wchars name, uint argn, const value *argv,
                value &retval);

      virtual bool get_const(wchars name, value &v) {
        document *pd = self->doc();
        if (!pd) return false;
        value pva = pd->styles().get_const(string(name.start, name.length));
        if (pva.is_defined()) {
          v = pva;
          return true;
        }
        return pd->find_media_var(name, v);
      }

      bool sort(array<helement> &lst, const value &fun);

      NONCOPYABLE(exec_env)
    };

    struct element_set : object // wrapper of set of elements
    {
      exec_env &      env;
      array<helement> set;
      element_set(exec_env &xenv, element *r, const ustring &sel, bool parents)
          : env(xenv) {
        if (parents)
          find_all_parents(env.v, set, r, sel);
        else
          find_all(env.v, set, r, sel);
      }

      virtual bool to_bool() const { return set.size() > 0; }

      virtual bool set_style_attr(wchars attr, const value &v) {
        string name(attr.start, attr.length);
        for (int n = 0; n < set.size(); ++n) {
          element *me = set[n];
          //if (v.is_undefined())
          //  me->remove_style_attribute(name);
          //else
          me->set_style_attribute(name, v);
        }
        return true;
      }

      virtual bool set_attr(wchars attr, const value &v) {
        name_or_symbol ns(string(attr.start, attr.length));
        if (v.is_null() || v.is_undefined())
          for (int n = 0; n < set.size(); ++n) {
            element *b = set[n];
            env.clear_attr(b, ns);
          }
        else {
          ustring us = v.to_string();
          for (int n = 0; n < set.size(); ++n) {
            element *b = set[n];
            env.set_attr(b, ns, us);
          }
        }
        return true;
      }
      virtual bool get_attr(wchars attr, value &v) { return false; }

      virtual bool set_state(wchars attr, const value &v) {
        if (attr == WCHARS("value")) {
          for (int n = 0; n < set.size(); ++n) {
            element *b = set[n];
            env.set_value(b, BV_VALUE, v);
          }
          return true;
        } else if (attr == WCHARS("index")) {
          for (int n = 0; n < set.size(); ++n) {
            element *b = set[n];
            env.set_value(b, BV_INDEX, v);
          }
          return true;
        }
        ui_state st;
        bool     bv = v.to_bool();
        if (parse_state_flag(string(attr.start, attr.length), st)) {
          for (int n = 0; n < set.size(); ++n) {
            element *b = set[n];
            if (bv)
              b->set_state(st, &env.v);
            else
              b->reset_state(st, &env.v);
            // env.set_state(b,st.data,bv);
          }
          return true;
        }
        return false;
      }
      virtual bool get_state(wchars attr, value &v) { return false; }
      virtual bool call(wchars name, uint argn, const value *argv,
                        value &retval) {
        if (name == WCHARS("sort")) {
          if (argn == 1 && env.pvm && (env.pvm->func_num_vars(argv[0]) >= 2)) {
            env.sort(set, argv[0]);

            // v.set_focus(b, BY_CODE);
          }
          return true;
        }
        for (int n = 0; n < set.size(); ++n) {
          element *b = set[n];
          env.call(b, name, argn, argv, retval);
        }

        return true;
      }

      virtual void enumerate(enumerator &en);

      NONCOPYABLE(element_set)
    };

    struct element_1 : object // wrapper of single element
    {
      exec_env &env;
      helement  me;

      enum _ { TYPE = 0xAFED0001 };

      element_1(exec_env &xenv, element *r, const ustring &sel, bool parent)
          : env(xenv) {
        if (parent)
          me = find_first_parent(env.v, r, sel);
        else
          me = find_first(env.v, r, sel);
      }

      element_1(exec_env &xenv, element *r) : env(xenv), me(r) {}

      virtual uint type() const { return uint(TYPE); }

      virtual bool get_user_data(void **ppv) {
        *ppv = me.ptr();
        return true;
      }

      virtual bool to_bool() const { return !me.is_null(); }

      virtual bool set_style_attr(wchars attr, const value &v) {
        if (!me) return true;
        string name(attr.start, attr.length);
        //if (v.is_undefined())
        //  me->remove_style_attribute(name);
        //else
        me->set_style_attribute(name, v);
        return true;
      }
      virtual bool get_style_attr(wchars attr, value &v) {
        if (!me) return true;

        string name(attr.start, attr.length);
        v = me->get_style()->to_value(name);
        return true;
      }

      virtual bool set_attr(wchars attr, const value &v) {
        if (!me) return true;
        name_or_symbol ns(string(attr.start, attr.length));

        if (v.is_undefined())
          env.clear_attr(me, ns);
        else
          env.set_attr(me, ns, v.to_string());
        return true;
      }
      virtual bool get_attr(wchars attr, value &v) {
        if (!me) return true;

        name_or_symbol ns(string(attr.start, attr.length));
        if (me->atts.exist(ns)) {
          v = value(me->atts(ns));
          /*
          ustring us = me->atts(ns);
          v = value::parse_length(us);
          if(v.is_undefined())
            v = value::parse(us);
          else if(v.units == 0 )
            v = v.get(0);*/
          return true;
        }
        //   return false;
        return true;
      }

      virtual bool set_state(wchars attr, const value &v) {
        if (!me) return true;

        if (attr == WCHARS("value")) {
          env.set_value(me, BV_VALUE, v);
          return true;
        } else if (attr == WCHARS("index")) {
          env.set_value(me, BV_INDEX, v);
          return true;
        }
        ui_state st;
        bool     bv = v.to_bool();
        if (parse_state_flag(string(attr.start, attr.length), st)) {
          // env.set_state(me,st.data,bv);
          if (bv) {
            if (st.focus()) {
              internal_event_behavior evt(me, me, DO_SET_FOCUS, 0);
              env.v.post_behavior_event(evt, true);
              st.focus(false);
            }
            me->set_state(st, &env.v);
          } else
            me->reset_state(st, &env.v);
          return true;
        }
        return false;
      }

      virtual bool get_state(wchars attr, value &v) {
        if (!me) return true;

        if (attr == WCHARS("value")) {
          env.get_value(me, BV_VALUE, v);
          return true;
        } else if (attr == WCHARS("index")) {
          env.get_value(me, BV_INDEX, v);
          return true;
        }
        ui_state st;
        if (parse_state_flag(string(attr.start, attr.length), st)) {
          v = value(env.get_state(me, st.data));
          return true;
        }
        return false;
      }

      virtual bool call(wchars name, uint argn, const value *argv,
                        value &retval) {
        if (!me) return true;
        env.call(me, name, argn, argv, retval);
        return true;
      }

      virtual void enumerate(enumerator &en);

      NONCOPYABLE(element_1)
    };

    inline void element_set::enumerate(enumerator &en) {
      for (int n = 0; n < set.size(); ++n) {
        value el(new element_1(env, set[n]));
        if (!en.doit(el)) break;
      }
    }

    inline void element_1::enumerate(enumerator &en) {
      value el(this);
      en.doit(el);
    }

    inline bool exec_env::sort(array<helement> &lst, const value &cmpf) {
      if (lst.size() == 0) return false;

      helement p = lst[0]->parent;
      if (!p) return false;

      auto comparator = [&](const html::helement &v1,
                            const html::helement &v2) -> bool {
        value params[2];
        params[0].set_object(new element_1(*this, v1));
        params[1].set_object(new element_1(*this, v2));
        value r = pvm->call(cmpf, 2, params);
        return r.get_bool();
      };

      tool::sort(lst.head(), lst.length(), comparator);

#if NOT_YET
      for (int n = 0; n < lst.size(); ++n) {
        helement el = lst[n];
        if (el->owner != p)
          return false; // we are sorting only children of the same owner
        int dst_index = n + first_index;
        int src_index = el->index();

        if (dst_index == src_index) continue;

        swap(p->subs[dst_index], p->subs[src_index]);
        swap(p->subs[dst_index]->index, p->subs[src_index]->index);
        v.add_to_update(el, true);
      }
#endif
      return true;
    }

#if 0
    struct eval_env : object // evaluation environment, responsible for handling
                             // "global" functions
    {
      exec_env &env;
      event &   evt;
      eval_env(exec_env &xenv, event &e) : env(xenv), evt(e) {}

      virtual bool get_const(wchars name, value &v) {
        return env.get_const(name, v);
      }

      virtual bool call(wchars func, uint argn, const value *argv,
                        value &retval) 
      {
        if (func == WCHARS("$")) // find all, root == doc
        {
          ustring sel = argv[0].to_string();
          retval.set_object(new element_set(env, env.self->doc(), sel, false));
          return true;
        }
        if (func == WCHARS("$1")) // find first, root == doc
        {
          ustring sel = argv[0].to_string();
          retval.set_object(new element_1(env, env.self->doc(), sel, false));
          return true;
        }
        if (func == WCHARS("$c")) // find all, root == self
        {
          ustring sel = argv[0].to_string();
          retval.set_object(new element_set(env, env.self, sel, false));
          return true;
        }
        if (func == WCHARS("$1c")) // find first, root == self
        {
          ustring sel = argv[0].to_string();
          retval.set_object(new element_1(env, env.self, sel, false));
          return true;
        }
        if (func == WCHARS("$p")) // find parents
        {
          if (!env.self->parent) return false;
          ustring sel = argv[0].to_string();
          retval.set_object(new element_set(env, env.self->parent, sel, true));
          return true;
        }
        if (func == WCHARS("$1p")) // find first parent
        {
          if (!env.self->parent) return false;
          ustring sel = argv[0].to_string();
          retval.set_object(new element_1(env, env.self->parent, sel, true));
          return true;
        }
        if (func == WCHARS("key-code")) {
          int cc = evt.get_key_code();
          if (evt.get_alt_state() == ALT_CONTROL) cc |= 0x80000000;
          value vcc = value(cc);
          if (argn) {
            for (uint n = 0; n < argn; ++n)
              if (argv[n] == vcc) {
                retval = value(true);
                return true;
              }
            retval = value(false);
          } else
            retval = vcc;
          return true;
        }
        if (func == WCHARS("is-on-icon")) {
          retval = value(evt.get_on_icon());
          return true;
        }
        if (func == WCHARS("mouse-x")) {
          retval = value::make_ppx_length(evt.get_pos().x);
          return true;
        }
        if (func == WCHARS("mouse-y")) {
          retval = value::make_ppx_length(evt.get_pos().y);
          return true;
        } else if (func == WCHARS("morph") && argn == 3) {
          ustring ease_f_name = argv[0].get(W(""));
          value   start       = argv[1];
          value   end         = argv[2];
          retval = morph_value(ease_f_name, start, end, evt.get_start_time(),
                               evt.get_current_time(), evt.get_end_time());
          return true;
        }
        return env.call_world(0, func, argn, argv, retval);
        // return false;
      }

      value morph_value(const ustring &ease_f_name, const value &start,
                        const value &end, uint start_time, uint current_time,
                        uint end_time);

      NONCOPYABLE(eval_env)
    };
#endif

#if 0
    struct csss_animation_starter : tool::functor {
      view *   pv;
      helement b;
      hstyle   cs;
      real     duration;
      csss_animation_starter(view &v, element *pb, const style *pcs)
          : pv(&v), b(pb), cs(pcs), duration(0) {}
      csss_animation_starter(view &v, element *pb, const style *pcs,
                             real total_time)
          : pv(&v), b(pb), cs(pcs), duration(total_time) {}
      virtual bool operator()() {
        csss_animator *pa = new csss_animator();
        pa->duration      = duration;
        pv->add_animation(b, pa, cs, b->p_style);
        return true;
      }
    };
#endif

    // handler of global function calls
    inline bool exec_env::call(element *b, wchars name, uint argn,
                               const value *argv, value &retval) {
      if (!b) return call_world(b, name, argn, argv, retval);
#if 0
      hstyle                cs = b->get_style(v);
      handle<eval::conduit> prg;

      if (name == WCHARS("hover-on"))
        prg = cs->act_hover_on;
      else if (name == WCHARS("hover-off"))
        prg = cs->act_hover_off;
      else if (name == WCHARS("active-on"))
        prg = cs->act_active_on;
      else if (name == WCHARS("active-off"))
        prg = cs->act_active_off;
      else if (name == WCHARS("focus-on"))
        prg = cs->act_focus_on;
      else if (name == WCHARS("focus-off"))
        prg = cs->act_focus_off;
      else if (name == WCHARS("click"))
        prg = cs->act_click;
      else if (name == WCHARS("double-click"))
        prg = cs->act_double_click;
      else if (name == WCHARS("value-changed"))
        prg = cs->act_value_changed;
      else if (name == WCHARS("size-changed"))
        prg = cs->act_size_changed;
      else if (name == WCHARS("attached"))
        prg = cs->act_assigned;
      else if (name == WCHARS("key-on"))
        prg = cs->act_key_on;
      else if (name == WCHARS("key-off"))
        prg = cs->act_key_off;
      else if (name == WCHARS("validate"))
        prg = cs->act_validate;
      else if (name == WCHARS("animation-end"))
        prg = cs->act_animation_end;
      else if (name == WCHARS("animation-start"))
        prg = cs->act_animation_start;
      else if (name == WCHARS("animation-step"))
        prg = cs->act_animation_step;

      else if (name == WCHARS("start-animation")) {
        if ((cs->act_animation_step || cs->act_animation_end) &&
            !b->state.animating()) {
          // if(argn == 1 && argv[0].is_duration())
          //  v.post(new csss_animation_starter(v,b,cs,argv[0].get_duration()));
          // else
          //  v.post(new csss_animation_starter(v,b,cs));
          csss_animator *pa = new csss_animator();
          if (argn == 1 && argv[0].is_duration())
            pa->duration = real(argv[0].get_duration());
          v.add_animation(b, pa, cs, b->p_style);
          return true;
        }
        return false;
      } else if (name == WCHARS("stop-animation")) // child(1..num_children)
      {
        v.remove_animation(b);
        return true;
      }

      else if (name == WCHARS("child")) // child(1..num_children)
      {
        int n = argv[0].get_int() - 1;
        if (n < 0 || n >= b->n_children()) return true;
        element *bc = b->child(n);
        if (!bc) return true;
        retval.set_object(new element_1(*this, bc));
        return true;
      } else if (name == WCHARS("parent")) // parent
      {
        if (!b->parent) return true;
        retval.set_object(new element_1(*this, b->parent));
        return true;
      } else if (name == WCHARS("next")) // next sibling
      {
        if (!b->parent) return true;
        element *t = b->next_element();
        if (!t) return true;
        retval.set_object(new element_1(*this, t));
        return true;
      } else if (name == WCHARS("previous") ||
                 name == WCHARS("prev")) // prev sibling
      {
        if (!b->parent) return true;
        element *t = b->prev_element();
        if (!t) return true;
        retval.set_object(new element_1(*this, t));
        return true;
      } else if (name == WCHARS("children")) // parent
      {
        retval = value((int)b->n_children());
        return true;
      } else if (name == WCHARS("$")) // find all, root == self
      {
        ustring sel = argv[0].to_string();
        // printf("$call with '%S'\n", sel.c_str());
        retval.set_object(new element_set(*this, b, sel, false));
        return true;
      } else if (name == WCHARS("$1")) // find first, root == self
      {
        ustring sel = argv[0].to_string();
        // printf("$call with '%S'\n", sel.c_str());
        retval.set_object(new element_1(*this, b, sel, false));
        return true;
      } else if (name == WCHARS("$p")) // find parents
      {
        if (!b->parent) return false;
        ustring sel = argv[0].to_string();
        // printf("$call with '%S'\n", sel.c_str());
        retval.set_object(new element_set(*this, b->parent, sel, true));
        return true;
      } else if (name == WCHARS("$1p")) // find first parent
      {
        if (!b->parent) return false;
        ustring sel = argv[0].to_string();
        // printf("$1p with '%S'\n", sel.c_str());
        retval.set_object(new element_1(*this, b->parent, sel, true));
        return true;
      } else if (name == WCHARS("start-timer") && argn == 1) {
        uint tout = (uint)argv[0].to_int();
        v.start_timer(b, tout, uint(CSSS_TIMER_ID), CSSS_TIMER);
        return true;
      } else if (name == WCHARS("stop-timer")) {
        v.stop_timer(b, uint(CSSS_TIMER_ID), CSSS_TIMER);
        return true;
      } else if (name == WCHARS("scroll-to-view")) {
        v.ensure_visible(b, false, SCROLL_SMOOTH);
        return true;
      } else if (name == WCHARS("min-intrinsic-width")) {
        retval = value((int)b->min_content_width(v));
        return true;
      } else if (name == WCHARS("max-intrinsic-width")) {
        retval = value((int)b->max_content_width(v));
        return true;
      } else if (name == WCHARS("min-intrinsic-height")) {
        // assert(b->min_content_height.defined());
        retval = value((int)b->min_content_height(v));
        return true;
      } else if (name == WCHARS("max-intrinsic-height")) {
        retval = value((int)b->max_content_height(v));
        return true;
      } else if (name == WCHARS("text-width")) {
        hstyle  cs   = b->get_style(v);
        ustring text = argv[0].to_string();
        view *  pv   = b->pview();
        if (pv) {
          handle<text_block> tl = b->create_text_block(v, text);
          retval                = value(tl->max_content_width(v));
        } else
          retval = value(0);
        return true;
      } else if (name.like(W("box-*"))) {
        rect rc(b->dim());

        wtokens toks(name, WCHARS("-"));
        wchars  tok;
        toks.next(tok);
        assert(tok == WCHARS("box"));

        if (!toks.next(tok)) return false;

        if (tok == WCHARS("client"))
          rc = b->client_rect(v);
        else if (tok == WCHARS("margin")) {
          rc = b->margin_box(v);
        } else if (tok == WCHARS("border")) {
          rc = b->border_box(v);
        } else if (tok == WCHARS("padding")) {
          rc = b->padding_box(v);
        } else if (tok == WCHARS("content")) {
          rc = rect(-b->scroll_pos(), b->content_dim());
        }
        /*else if( tok == WCHARS("inner") )
        {
          rc;
        }*/

        if (!toks.next(tok)) return false;

        if (tok == WCHARS("left"))
          retval = value::make_ppx_length(rc.left());
        else if (tok == WCHARS("right"))
          retval = value::make_ppx_length(rc.right());
        else if (tok == WCHARS("top"))
          retval = value::make_ppx_length(rc.top());
        else if (tok == WCHARS("bottom"))
          retval = value::make_ppx_length(rc.bottom());
        else if (tok == WCHARS("width"))
          retval = value::make_ppx_length(rc.width());
        else if (tok == WCHARS("height"))
          retval = value::make_ppx_length(rc.height());
        else
          return false;
        return true;
      } // box-*

      else if (name.like(W("x-*"))) {
        // x-screen
        // x-parent
        // x-root
        // x-view
        wtokens toks(name, WCHARS("-"));
        wchars  tok;
        toks.next(tok);
        point pos;
        assert(tok == WCHARS("x"));
        if (!toks.next(tok)) return false;
        if (tok == WCHARS("parent"))
          pos = b->pos();
        else if (tok == WCHARS("root"))
          pos = b->doc_pos(v);
        else if (tok == WCHARS("view"))
          pos = b->view_pos(v);
        else if (tok == WCHARS("screen"))
          pos = b->screen_pos(v);
        else
          return false;
        retval = value::make_ppx_length(pos.x);
        return true;
      } else if (name.like(W("y-*"))) {
        // y-screen
        // y-parent
        // y-root
        // y-view
        wtokens toks(name, WCHARS("-"));
        wchars  tok;
        toks.next(tok);
        point pos;
        assert(tok == WCHARS("y"));
        if (!toks.next(tok)) return false;
        if (tok == WCHARS("parent"))
          pos = b->pos();
        else if (tok == WCHARS("root"))
          pos = b->doc_pos(v);
        else if (tok == WCHARS("view"))
          pos = b->view_pos(v);
        else if (tok == WCHARS("screen"))
          pos = b->screen_pos(v);
        else
          return false;
        retval = value::make_ppx_length(pos.y);
        return true;
      } else if (name == WCHARS("show-popup") && argn >= 1) {
        object *obj = argv[0].get_object();
        if (!obj || obj->type() != element_1::TYPE) return false;
        // uint placement = 1;
        // uint popup_placement = 0;
        // if(argn >= 2)
        //  placement = argv[1].get_int();
        // if(argn >= 3)
        //  popup_placement = argv[2].get_int();
        element_1 *p = static_cast<element_1 *>(obj);
        if (!p->me) return false;
#if POPUP_NOT_YET
        v.show_popup(p->me, b, placement | (popup_placement << 16),
                     view::POPUP_ANIMATE | view::POPUP_MODAL);
#endif
        return true;
      } else if (name == WCHARS("update")) {
        v.add_to_update(b, true);
        return true;
      } else
        return call_world(b, name, argn, argv, retval);

      if (prg) {
        event dummy(b, 0);
        if (b->eval_action(v, dummy, prg)) return true;
      }
#endif
      return false;
    }

    // the calc() invocation environment
    struct calc_env : public exec_env, object {
      bool    horizontal;
      pixels& pxc;
      calc_env(view &vw, element *pb, bool for_width, pixels& px)
          : exec_env(vw, pb), horizontal(for_width), pxc(px) {}

      virtual void finalize() {
        ; /* does nothing as we will create in the stack only*/
      }

      virtual bool to_bool() const { return !self.is_null(); }

      virtual bool set_style_attr(wchars attr, const value &v) { return false; }
      virtual bool get_style_attr(wchars attr, value &v) { return false; }
      virtual bool set_attr(wchars attr, const value &v) { return false; }
      virtual bool get_attr(wchars attr, value &v) {
        v.clear();
        if (!self) return true;
        name_or_symbol ns(string(attr.start, attr.length));
        if (self->atts.exist(ns)) {
          ustring us = self->atts(ns);
          v = value::parse_numeric_units(us);
          if (v.is_undefined()) v = value::parse(us);
          return true;
        }
        return true;
      }

      virtual bool set_state(wchars attr, const value &v) { return false; }
      virtual bool get_state(wchars attr, value &val) {
        if (!self) return true;

        if (attr == WCHARS("value")) {
          self->get_value(v, val);
          return true;
        } else if (attr == WCHARS("index")) {
          val = value(self->index() + 1);
          return true;
        }
        ui_state st;
        if (parse_state_flag(string(attr.start, attr.length), st)) {
          val = value(self->state.is_set(st.data));
          return true;
        }
        return false;
      }

      virtual bool call(wchars name, uint argn, const value *argv,
                        value &retval) {
        if (!self) return true;

        if (name == WCHARS("child")) // child(1..num_children)
        {
          int n = argv[0].get_int() - 1;
          if (n < 0 || n >= self->n_children()) return true;
          element *bc = self->child(n);
          if (!bc) return true;
          retval.set_object(new element_1(*this, bc));
          return true;
        } else if (name == WCHARS("parent")) // parent
        {
          if (!self->parent) return true;
          retval.set_object(new element_1(*this, self->parent));
          return true;
        } else if (name == WCHARS("next")) // next sibling
        {
          if (!self->parent) return true;
          element *t = self->next_element();
          if (!t) return true;
          retval.set_object(new element_1(*this, t));
          return true;
        } else if (name == WCHARS("previous") ||
                   name == WCHARS("prev")) // prev sibling
        {
          if (!self->parent) return true;
          element *t = self->prev_element();
          if (!t) return true;
          retval.set_object(new element_1(*this, t));
          return true;
        } else if (name == WCHARS("children")) // parent
        {
          retval = value((int)self->n_children());
          return true;
        } else if (name == WCHARS("min-intrinsic-width")) {
          retval = value((int)self->min_content_width(v));
          return true;
        } else if (name == WCHARS("max-intrinsic-width")) {
          retval = value((int)self->max_content_width(v));
          return true;
        } else if (name == WCHARS("min-intrinsic-height") ||
                   name == WCHARS("intrinsic-height")) {
          retval = value((int)self->min_content_height(v));
          return true;
        } else if (name == WCHARS("max-intrinsic-height")) {
          retval = value((int)self->max_content_height(v));
          return true;
        } 
#ifdef THEMES_SUPPORT
        else if (name == WCHARS("system-scrollbar-height")) {
          retval = value(gool::theme::current()->scrollbar_height());
          return true;
        } else if (name == WCHARS("system-scrollbar-width")) {
          retval = value(gool::theme::current()->scrollbar_width());
          return true;
        } else if (name == WCHARS("system-border-width")) {
          retval = value(gool::theme::current()->border_width());
          return true;
        } else if (name == WCHARS("system-3d-border-width")) {
          retval = value(gool::theme::current()->border_width());
          return true;
        } else if (name == WCHARS("system-small-icon-height")) {
          retval = value(gool::theme::current()->small_icon_height());
          return true;
        } else if (name == WCHARS("system-small-icon-width")) {
          retval = value(gool::theme::current()->small_icon_width());
          return true;
        } 
#endif
        else if (name == WCHARS("text-width")) {
#if NOT_YET
          ustring        text = argv[0].to_string();
          gool::surface &sf   = v.get_m_surface();
          hstyle         cs   = self->get_style(v);
          sf.set_font(v.get_font(*cs));
          retval = value(sf.measure(text).x);
#endif
          return true;
        } else if (name == WCHARS("foreground-image-width")) {
          // retval = value(gool::theme::current()->small_icon_width());
          himage img = self->get_fore_image(v);
          if (img)
            retval = value::make_ppx_length(img->dimension().x);
          else
            retval = value();
          return true;
        } else if (name == WCHARS("foreground-image-height")) {
          // retval = value(gool::theme::current()->small_icon_width());
          himage img = self->get_fore_image(v);
          if (img)
            retval = value::make_ppx_length(img->dimension().y);
          else
            retval = value();
          return true;
        } else if (name == WCHARS("background-image-width")) {
          himage img = self->get_back_image(v);
          if (img)
            retval = value::make_ppx_length(img->dimension().x);
          else
            retval = value();
          return true;
        } else if (name == WCHARS("background-image-height")) {
          // retval = value(gool::theme::current()->small_icon_width());
          himage img = self->get_back_image(v);
          if (img)
            retval = value::make_ppx_length(img->dimension().y);
          else
            retval = value();
          return true;
        } else
          return call_world(name, argn, argv, retval);
      }

      bool call_world(wchars name, uint argn, const value *argv,
                      value &retval) {
        uint n;
        char x_name[64];
        for (n = 0; n < min(63u, name.length); ++n)
          x_name[n] = (char)name[n];
        x_name[n] = 0;
        // json::value x_argv[16];
        //   for(n = 0; n < min(16,argn); ++n ) x_argv[n] =
        //   value2value(argv[n]);

        view *pv = self->pview();
        if (pv) {

          scripting_params sp;
          sp.method_name = x_name;
          sp.argc        = argn;
          sp.argv        = argv;

          if (self->call_behavior_method(*pv, &sp)) {
            retval = sp.retval;
            return true;
          }
          if (pv->call_behavior_method(&sp)) {
            retval = sp.retval;
            return true;
          }
        }
        return false;
      }
      // resolve em, ex and % units
      virtual bool to_pixels(const value &val, int &px) {
        if (!val.is_length()) return false;
        pxc.s = val;
        if (horizontal)
          px = pxc.width();
        else
          px = pxc.height();
        return true;
      }

      virtual bool get_const(wchars name, value &v) {
        document *pd = self->doc();
        if (!pd) return false;
        value pva = pd->styles().get_const(string(name.start, name.length));
        if (pva.is_defined()) {
          v = pva;
          return true;
        }
        return pd->find_media_var(name, v);
      }
    };

#if 0
    struct draw_env : eval_env // evaluation environment, responsible for
                               // handling "global" stuff in draw!
    {
      typedef eval_env super;
      draw_env(exec_env &xenv, event &e) : eval_env(xenv, e) {}

      virtual bool call(wchars func, uint argn, const value *argv,
                        value &retval);
    };
#endif

  } // namespace csss

} // namespace html

#endif
