#include "html.h"

namespace html {

  ctl_factory::ctl_factory(const char *n) : name(n) {}

  hash_table<string, handle<ctl_factory>> ctl_factory::all;

  // returns behavior implementation by name.
  ctl *ctl_factory::produce(element *el, const string &name) {
    handle<ctl_factory> t;
    if (all.find(name, t)) return t->create(el);
    return 0; // not found
  }

  ustring ctl::get_attr(element *self, const char *name) {
    ustring val;
    self->get_attr(name, val);
    return val;
  }

  int ctl::get_attr(element *self, const char *name, int dv) {
    ustring val;
    if (self->get_attr(name, val)) {
      int v = 0;
      return stoi(val, v) ? v : dv;
    }
    return dv;
  }
  double ctl::get_attr(element *self, const char *name, double dv) {
    ustring val;
    if (self->get_attr(name, val)) {
      double v = 0.0;
      return stof(val, v) ? v : dv;
    }
    return dv;
  }

  bool ctl::is_readonly(const element *b) const { return b->is_readonly(); }
  bool ctl::is_disabled(const element *b) const { return b->is_disabled(); }

  bool ctl::set_child_state(view &v, element *self, element *child,
                            const ui_state &st) {
    return child->state_on(v, st);
    // child->state += st.data;
    // child->drop_styles(*v);
    // return true;
  }
  bool ctl::reset_child_state(view &v, element *self, element *child,
                              const ui_state &st) {
    return child->state_off(v, st);
    // child->state -= st.data;
    // child->drop_styles(*v);
    // return true;
  }

  bool view::call_behavior_method(element *b, const char *name,
                                  const value *argv, size_t argc,
                                  value &retval) {
    helement   guard = b;
    behavior_h pc    = b ? b->behavior : ground_behavior;
    while (pc) {
      if (pc->on_x_method_call(*this, b, name, argv, argc, retval)) return true;
      pc = pc->next;
    }
    if (name[0] == '_') {
      if (b && strcmp(name, "_applied_style_rules_") == 0)
        return b->applied_style_rules_report(*this, retval);
      else if (b && strcmp(name, "_used_style_properties_") == 0)
        return b->used_style_props_report(*this, retval);
#if defined(WINDOWS) && !defined(WINDOWLESS)
      else if (strcmp(name, "_notifyWinEvent") == 0 && argc == 1 &&
               argv[0].is_int()) {
        NotifyWinEvent(DWORD(argv[0].get(0)), get_hwnd(), b->uid, CHILDID_SELF);
        retval = value(true);
        return true;
      }
#endif
    }
    return false;
  }
#ifdef SCITER
  /*bool view::call_behavior_method(element *b, tis::VM *c, tis::value tag,
                                  tis::value &retval) {
    helement   guard = b;
    behavior_h pc    = b ? b->behavior : ground_behavior;
    while (pc) {
      if (pc->on_script_method_call(*this, b, c, tag, retval)) return true;
      pc = pc->next;
    }
    return false;
  }*/
#endif

  namespace behavior {

    struct windowed_element_factory : public ctl_factory {
      windowed_element_factory() : ctl_factory("windowed") {}
      virtual ctl *create(element *el) { return new windowed_element(); }
    };

    windowed_element_factory *_windowed_element_factory = nullptr;

    const string &windowed_element::behavior_name() const {
      return _windowed_element_factory->name;
    }

    void init(bool start) {
      if (start) {
        ctl_factory::add(_windowed_element_factory =
                             new windowed_element_factory());
      } else {
        shutdown_ctl_image();
      }
    }

  } // namespace behavior

} // namespace html