#include "html.h"

namespace html {
  uint fore_image_animator::start(view &v, element *el, const style *nst,
                                  const style *ost) {
    image *pimg = el->get_fore_image(v);
    assert(pimg && pimg->is_animated(uint_ptr(el)));
    himg = static_cast<animated_image *>(pimg);
    return step(v, el, v.get_animation_ticks());
    //return himg->step_duration(uint_ptr(el));
  }
  uint back_image_animator::start(view &v, element *el, const style *nst,
                                  const style *ost) {
    image *pimg = el->get_back_image(v);
    assert(pimg && pimg->is_animated(uint_ptr(el)));
    himg = static_cast<animated_image *>(pimg);
    return step(v, el, v.get_animation_ticks());
    //return himg->step_duration(uint_ptr(el));
  }

  uint fore_image_animator::step(view &v, element *el, uint current_clock) {
    image *pimg = el->get_fore_image(v);
    // assert(pimg && pimg->is_animated(uint_ptr(el)));
    if (!el->is_drawable(v) || pimg != himg) {
      himg->remove_state_for(uint_ptr(el));
      return 0;
    }

    auto frame_no = el->get_style(v)->fore_image.frame_no;
    if( frame_no.is_defined() && frame_no != 0 )
    {
      himg->set_frame_no(frame_no - 1, uint_ptr(el));
      return 0;
    }

    uint duration = himg->next_step(uint_ptr(el));
    v.refresh(el);
    return duration;
  }

  uint back_image_animator::step(view &v, element *el, uint current_clock) {
    image *pimg = el->get_back_image(v);
    // assert(pimg && pimg->is_animated(uint_ptr(el)));
    if (!el->is_drawable(v) || pimg != himg) {
      himg->remove_state_for(uint_ptr(el));
      return 0;
    }

    auto frame_no = el->get_style(v)->fore_image.frame_no;
    if (frame_no.is_defined() && frame_no != 0)
    {
      himg->set_frame_no(frame_no - 1, uint_ptr(el));
      return 0;
    }

    uint duration = himg->next_step(uint_ptr(el));
    v.refresh(el);
    return duration;
  }

  bool image_animator::draw(view &v, graphics *pg, element *b, point pos) {
    v.request_animation_frame(16);
    return false;
  }

  void image_animator::stop(view &v, element *el) {
    animation::stop(v, el);
    himg->remove_state_for(uint_ptr(el));
  }
} // namespace html