//
//  macosx_utils.mm
//
//  Copyright (c) 2014 andrew fedoniouk. All rights reserved.
//
#import <Cocoa/Cocoa.h>
#include "gool/gool.h"

#include <ApplicationServices/ApplicationServices.h>
#include <Carbon/Carbon.h>
#import <IOKit/graphics/IOGraphicsLib.h>

namespace gool
{
    
    bitmap* bitmap::create(CGImageRef cgimage, bool transparent, gool::size sz) {
        
        size dim = sz;
        
        if( sz.empty() ) {
            dim.x = (int) CGImageGetWidth(cgimage);
            dim.y = (int) CGImageGetHeight(cgimage);
        }
        bitmap* r = new bitmap(dim,transparent,true);
        //r->cg_image = cgimage;
        
        //return r;
        
        
        CF::ref<CGColorSpaceRef> colorSpace = CGColorSpaceCreateDeviceRGB();
        CGBitmapInfo flags = kCGImageAlphaPremultipliedFirst | kCGBitmapByteOrder32Little;
        
        CGContextRef target = CGBitmapContextCreate(NULL,
                                                    dim.x,
                                                    dim.y, 8, dim.x * sizeof(gool::argb), colorSpace, flags);
        
        CGContextSetFillColorSpace(target, colorSpace);
        CGContextSetStrokeColorSpace(target, colorSpace);
        
        CGContextSetFillColorWithColor(target, cvt(gool::argb(255,255,255,0)));
        
        CGContextFillRect(target,cvt(rect(dim)));
        
        //CGContextTranslateCTM(target, 0.0f, dim.y);
        //CGContextScaleCTM(target, 1.0f, -1.0f);
        
        CGContextDrawImage ( target, cvt(rect(dim)), cgimage );
        
        void *data = CGBitmapContextGetData (target);
        if (data)
        {
            const gool::argb *pba = (gool::argb*)data;
            r->set_bits(slice<gool::argb>(pba, dim.x * dim.y));
        }
        
        CGContextRelease(target);
        return r;
    }

}




