#ifndef __gool_macosx_spacifics_h__
#define __gool_macosx_spacifics_h__

#include "tool/tool.h"

#if defined(__OBJC__)

template <typename CT> inline gool::geom::size_t<CT> cvt (const CGSize& sz) noexcept { return gool::geom::size_t<CT>((CT)sz.width,(CT)sz.height); }
template <typename CT> inline gool::geom::point_t<CT> cvt (const CGPoint& pt) noexcept { return gool::geom::point_t<CT>((CT)pt.x,(CT)pt.y); }
template <typename CT> inline gool::geom::rect_t<CT> cvt (const CGRect& r) noexcept { return gool::geom::rect_t<CT>(cvt<CT>(r.origin),cvt<CT>(r.size)); }

template <typename CT> inline gool::geom::size_t<CT> fromns (const NSSize& sz) noexcept { return gool::geom::size_t<CT>((CT)sz.width,(CT)sz.height); }
template <typename CT> inline gool::geom::point_t<CT> fromns (const NSPoint& pt) noexcept { return gool::geom::point_t<CT>((CT)pt.x,(CT)pt.y); }
template <typename CT> inline gool::geom::rect_t<CT> fromns (const NSRect& r) noexcept { return gool::geom::rect_t<CT>(fromns<CT>(r.origin),fromns<CT>(r.size)); }

template <typename CT> inline CGPoint cvt (const gool::geom::point_t<CT>& pt) noexcept { CGPoint r; r.x = pt.x; r.y = pt.y; return r; }
template <typename CT> inline NSPoint tons (const gool::geom::point_t<CT>& pt) noexcept { NSPoint r; r.x = pt.x; r.y = pt.y; return r; }

template <typename CT> inline CGSize cvt (const gool::geom::size_t<CT>& sz) noexcept { CGSize r; r.width = sz.x; r.height = sz.y; return r; }
template <typename CT> inline NSSize tons (const gool::geom::size_t<CT>& sz) noexcept { NSSize r; r.width = sz.x; r.height = sz.y; return r; }

inline NSRect tons (const gool::rect& r)
{
    return NSMakeRect (static_cast <CGFloat> (r.left()),
                       static_cast <CGFloat> (r.top()),
                       static_cast <CGFloat> (r.width()),
                       static_cast <CGFloat> (r.height()));
}

inline NSRect tons (const gool::rectf& r)
{
    return NSMakeRect (static_cast <CGFloat> (r.left()),
                       static_cast <CGFloat> (r.top()),
                       static_cast <CGFloat> (r.width()),
                       static_cast <CGFloat> (r.height()));
}

inline CGRect cvt (const gool::rect& r)
{
    return CGRectMake (static_cast <CGFloat> (r.left()),
                       static_cast <CGFloat> (r.top()),
                       static_cast <CGFloat> (r.width()),
                       static_cast <CGFloat> (r.height()));
}

inline CGRect cvt (const gool::rectf& r)
{
    return CGRectMake (static_cast <CGFloat> (r.left()),
                       static_cast <CGFloat> (r.top()),
                       static_cast <CGFloat> (r.width()),
                       static_cast <CGFloat> (r.height()));
}

inline CGColorRef cvt( gool::argb color ) {
  
    CGFloat comp[4] = {color.red / CGFloat(255.0), color.green / CGFloat(255.0), color.blue / CGFloat(255.0), color.alfa / CGFloat(255.0)};
    static CF::ref<CGColorSpaceRef> cp = CGColorSpaceCreateDeviceRGB();
    return CGColorCreate(cp, comp);
}

#endif

#endif


