#ifndef __gool_icon_h__
#define __gool_icon_h__

#ifdef WINDOWS
#include "tool/tool.h"
#include <shlobj.h>
#include <shlguid.h>
#include <shellapi.h>
#include <commctrl.h>
#include <commoncontrols.h>


#ifndef SHIL_JUMBO
#define SHIL_JUMBO 4
#endif // SHIL_JUMBO

namespace gool {

  using namespace tool;

  class bitmap;

  namespace icon {

//////////////////////////////////////////////////////////////////////////
// Format in ico file
#pragma pack(push, 2)

    struct icondirentry {
      BYTE  bwidth;        // width, in pixels, of the image
      BYTE  bheight;       // height, in pixels, of the image
      BYTE  bcolorcount;   // number of colors in image (0 if >=8bpp)
      BYTE  breserved;     // reserved ( must be 0)
      WORD  wplanes;       // color planes
      WORD  wbitcount;     // bits per pixel
      DWORD dwbytesinres;  // how many bytes in this resource?
      DWORD dwimageoffset; // where in the file is this image?
    };

    struct icondir {
      WORD         idreserved;   // reserved (must be 0)
      WORD         idtype;       // resource type (1 for icons)
      WORD         idcount;      // how many images?
      icondirentry identries[1]; // an entry for each image (idcount of 'em)
    };

#pragma pack(pop)

    struct icon_handle {
      HICON h;
      icon_handle(HICON hi = 0) : h(hi) {}
      ~icon_handle() { clear(); }
           operator HICON() { return h; }
      void clear() {
        if (h) {
          ::DestroyIcon(h);
          h = 0;
        }
      }
    };
    struct icon_info : public ICONINFO {
      icon_info(HICON h) { ::GetIconInfo(h, this); }
      ~icon_info() {
        if (hbmColor) ::DeleteObject(hbmColor);
        if (hbmMask) ::DeleteObject(hbmMask);
      }
    };

    gool::bitmap *make_bitmap_from_ico_bytes(size place_sz, size min_size,
                                             bytes data);
    gool::bitmap *make_bitmap_from_ico_handle(HICON hicon, point &offset);

    struct file_icon_list : public bitmap_list {
      HIMAGELIST _image_list;

      enum FIL_SIZE {
        SYSTEM   = SHIL_SYSSMALL,
        SMALL    = SHIL_SMALL,
        LARGE    = SHIL_LARGE,
        X_LARGE  = SHIL_EXTRALARGE,
        XX_LARGE = SHIL_JUMBO,
      };

      file_icon_list(FIL_SIZE sz);
      ~file_icon_list() {
        if (_image_list) ImageList_Destroy(_image_list);
      }
      virtual bitmap *create(const ustring &name, bool allow_read_from_disk) override;
    };
  }
} // namespace gool

#endif

#endif
