//#include "tool.h"
#include "gool.h"
#include "gool-icon.h"

#ifdef WINDOWS

namespace gool {

  HICON bitmap::create_win_icon(size offset) {

    LONG           dwWidth = this->dim().x, dwHeight = this->dim().y;
    BITMAPV5HEADER bi;
    HBITMAP        hBitmap /*, hOldBitmap*/;
    void *         lpBits;

    ZeroMemory(&bi, sizeof(BITMAPV5HEADER));
    bi.bV5Size        = sizeof(BITMAPV5HEADER);
    bi.bV5Width       = dwWidth;
    bi.bV5Height      = -dwHeight;
    bi.bV5Planes      = 1;
    bi.bV5BitCount    = 32;
    bi.bV5Compression = BI_BITFIELDS;
    bi.bV5RedMask     = 0x00FF0000;
    bi.bV5GreenMask   = 0x0000FF00;
    bi.bV5BlueMask    = 0x000000FF;
    bi.bV5AlphaMask   = 0xFF000000;

    HDC hdc;
    hdc = GetDC(NULL);
    // Create the DIB section with an alpha channel.
    hBitmap = CreateDIBSection(hdc, (BITMAPINFO *)&bi, DIB_RGB_COLORS,
                               (void **)&lpBits, NULL, (DWORD)0);
    ReleaseDC(NULL, hdc);

    // Create an empty mask bitmap.
    HBITMAP hMonoBitmap = CreateBitmap(dwWidth, dwHeight, 1, 1, NULL);

    array<argb> src = this->get_bits();
    for (auto& c : src)
      c = c.demultiply();

    argb *      dst = (argb *)lpBits;
    //slice<argb> src = this->get_bits();
    target(dst, dwWidth * dwHeight).copy(src());

    ICONINFO ii;
    ii.fIcon    = FALSE; // Change fIcon to TRUE to create an alpha icon
    ii.xHotspot = offset.x;
    ii.yHotspot = offset.y;
    ii.hbmMask  = hMonoBitmap;
    ii.hbmColor = hBitmap;

    HICON hicon = CreateIconIndirect(&ii); // Create the alpha cursor with the alpha DIB section.
    DeleteObject(hBitmap);
    DeleteObject(hMonoBitmap);

    return hicon;
  }
  HBITMAP image::create_win_bitmap() {

    handle<gool::bitmap> bmp;
    if (is_bitmap() && static_cast<gool::bitmap *>(this)->get_bits().length)
      bmp = (gool::bitmap *)this;
    else {
      bmp = new gool::bitmap(dim(), true, true);
      handle<gool::graphics> gfx =
          app()->create_bitmap_bits_graphics(bmp, gool::argb());
      if (gfx) gfx->draw(const_cast<gool::image *>(this), gool::pointf(0, 0));
    }

    LONG           dwWidth = bmp->dim().x, dwHeight = bmp->dim().y;
    BITMAPV5HEADER bi;
    HBITMAP        hBitmap /*, hOldBitmap*/;
    void *         lpBits;

    ZeroMemory(&bi, sizeof(BITMAPV5HEADER));
    bi.bV5Size        = sizeof(BITMAPV5HEADER);
    bi.bV5Width       = dwWidth;
    bi.bV5Height      = -dwHeight;
    bi.bV5Planes      = 1;
    bi.bV5BitCount    = 32;
    bi.bV5Compression = BI_BITFIELDS;
    bi.bV5RedMask     = 0x00FF0000;
    bi.bV5GreenMask   = 0x0000FF00;
    bi.bV5BlueMask    = 0x000000FF;
    bi.bV5AlphaMask   = 0xFF000000;

    HDC hdc = GetDC(NULL);
    // Create the DIB section with an alpha channel.
    hBitmap = CreateDIBSection(hdc, (BITMAPINFO *)&bi, DIB_RGB_COLORS,
                               (void **)&lpBits, NULL, (DWORD)0);
    ReleaseDC(NULL, hdc);

    argb *      dst = (argb *)lpBits;
    slice<argb> src = bmp->get_bits();
    target(dst, dwWidth * dwHeight).copy(src);

    return hBitmap;
  }

  namespace icon {

    gool::bitmap *make_bitmap_from_ico_handle(HICON hicon, point &offset) {
      icon_info iconinfo(hicon);

      offset.x = iconinfo.xHotspot;
      offset.y = iconinfo.yHotspot;

      BITMAP bitmapinfo;
      GetObject(iconinfo.hbmColor, sizeof(bitmapinfo), &bitmapinfo);
      if (bitmapinfo.bmBitsPixel == 32) {
        dib32 pd(size(bitmapinfo.bmWidth, bitmapinfo.bmHeight));
        if (!pd.bits()) return 0;
        // pd.clear_all(0x00000000);
        HDC hdc = GetDC(0);
        GetDIBits(
            hdc, iconinfo.hbmColor,
            0,                   // first scan line to set
            bitmapinfo.bmHeight, // number of scan lines to copy
            pd.bits(),           // array for bitmap bits
            const_cast<BITMAPINFO *>(&pd.get_info()), // bitmap data buffer
            DIB_RGB_COLORS                            // RGB or palette index
        );
        ReleaseDC(0, hdc);
        // pd->alpha_inv();
        return new bitmap(&pd);
      }

      size sz(bitmapinfo.bmWidth, bitmapinfo.bmHeight);

      dib32 pd(sz);
      dib32 pd_mask(sz);
      if (!pd.bits() || !pd_mask.bits()) { return 0; }

      pd_mask.set_white();
      DrawIconEx(pd_mask.DC(), 0, 0, hicon, sz.x, sz.y, 0, 0, DI_MASK);
      DrawIconEx(pd.DC(), 0, 0, hicon, sz.x, sz.y, 0, 0, DI_IMAGE);
      argb *pm     = (argb *)pd_mask.bits();
      argb *pi     = (argb *)pd.bits();
      argb *pi_end = pi + pd.width() * pd.height();
      for (; pi < pi_end; ++pi, ++pm)
        pi->alfa = 255 - pm->red;
      return new bitmap(&pd);
    }

    gool::bitmap *make_bitmap_from_ico_bytes(size place_sz, size min_size,
                                             bytes data) {
#ifdef PLATFORM_WINCE
      // TODO: try to convert icon image data to bitmap and draw bitmap
      return 0;
#else
      int offset       = 0;
      int small_offset = 0;

      icondir *idir = (icondir *)data.start;

      int  best_wbitcount = 0;
      size best_sz;
      uint nbytes = 0;

      int small_wbitcount = 0;

      int i;
      for (i = 0; i < idir->idcount; i++) {
        int w = idir->identries[i].bwidth;
        int h = idir->identries[i].bheight;
        if (!w) w = 256;
        if (!h) h = 256;
        int bits = idir->identries[i].wbitcount;
        if (w <= place_sz.x && h <= place_sz.y) {
          if (w >= best_sz.x && h >= best_sz.y) {
            if (bits >= best_wbitcount) {
              best_wbitcount = bits;
              offset         = idir->identries[i].dwimageoffset;
              nbytes         = idir->identries[i].dwbytesinres;
            }
            best_sz.x = w;
            best_sz.y = h;
          }
        }
        if (w == min_size.x && h == min_size.y) {
          if (bits >= small_wbitcount) {
            small_wbitcount = bits;
            small_offset    = idir->identries[i].dwimageoffset;
          }
        }
      }
      if (!offset) {
        if (!small_offset) return false;
        offset         = small_offset;
        best_sz        = min_size;
        best_wbitcount = small_wbitcount;
      }

      icon_handle hicon;
      hicon.h = CreateIconFromResourceEx(
          const_cast<byte *>(data.start) + offset, nbytes, TRUE, 0x00030000,
          best_sz.x, best_sz.y, LR_DEFAULTCOLOR);

      if (hicon) {
        icon_info iconinfo(hicon);
        BITMAP    bitmapinfo;
        GetObject(iconinfo.hbmColor, sizeof(bitmapinfo), &bitmapinfo);
        if (best_wbitcount == 32) {
          dib32 pd(size(bitmapinfo.bmWidth, bitmapinfo.bmHeight));
          if (!pd.bits()) return 0;
          // pd.clear_all(0x00000000);
          HDC hdc = GetDC(0);
          GetDIBits(
              hdc, iconinfo.hbmColor,
              0,                   // first scan line to set
              bitmapinfo.bmHeight, // number of scan lines to copy
              pd.bits(),           // array for bitmap bits
              const_cast<BITMAPINFO *>(&pd.get_info()), // bitmap data buffer
              DIB_RGB_COLORS                            // RGB or palette index
          );
          ReleaseDC(0, hdc);
          // pd->alpha_inv();
          return new bitmap(&pd);
        }

        dib32 pd(best_sz);
        dib32 pd_mask(best_sz);
        if (!pd.bits() || !pd_mask.bits()) { return 0; }

        pd_mask.set_white();
        DrawIconEx(pd_mask.DC(), 0, 0, hicon, best_sz.x, best_sz.y, 0, 0,
                   DI_MASK);
        DrawIconEx(pd.DC(), 0, 0, hicon, best_sz.x, best_sz.y, 0, 0, DI_IMAGE);
        argb *pm     = (argb *)pd_mask.bits();
        argb *pi     = (argb *)pd.bits();
        argb *pi_end = pi + pd.width() * pd.height();
        for (; pi < pi_end; ++pi, ++pm)
          pi->alfa = 255 - pm->red;
        return new bitmap(&pd);
      } else {
        DWORD dwerr = GetLastError();
        dwerr       = dwerr;
        return 0;
      }
#endif
    }

    /*
    // Get the icon index using SHGetFileInfo
    SHFILEINFOW sfi = {0};
    SHGetFileInfo(filePath, -1, &sfi, sizeof(sfi), SHGFI_SYSICONINDEX);
     

    // Retrieve the system image list.
    // To get the 48x48 icons, use SHIL_EXTRALARGE
    // To get the 256x256 icons (Vista only), use SHIL_JUMBO
    HIMAGELIST* imageList;
    HRESULT hResult = SHGetImageList(SHIL_EXTRALARGE, IID_IImageList,
    (void**)&imageList);
     

    if (hResult == S_OK) {
      // Get the icon we need from the list. Note that the HIMAGELIST we
    retrieved
      // earlier needs to be casted to the IImageList interface before use.
      HICON hIcon;
      hResult = ((IImageList*)imageList)->GetIcon(sfi.iIcon, ILD_TRANSPARENT,
    &hIcon);
     

      if (hResult == S_OK) {
        // Do something with the icon here.
        // For example, in wxWidgets:
        wxIcon* icon = new wxIcon();
        icon->SetHICON((WXHICON)hIcon);
        icon->SetSize(48, 48);
      }
    }
    */

    gool::bitmap *make_bitmap_from_imagelist(size sz, HIMAGELIST hlist,
                                             int idx) {
      // IMAGEINFO ii;
      // if(!ImageList_GetImageInfo(hlist, idx, &ii))
      //  return 0;

      // BITMAP bi,bm;
      // GetObject(ii.hbmImage, sizeof(bi),&bi);
      // GetObject(ii.hbmMask, sizeof(bi),&bm);

      dib32 pd(sz);
      dib32 pd_mask(sz);

      if (!pd.bits() || !pd_mask.bits()) { return 0; }

      pd_mask.set_white();
      // ImageList_Draw(hlist, idx, sf, 0, 0, ILD_MASK );
      ImageList_DrawEx(hlist, idx, pd_mask.DC(), 0, 0, 0, 0, CLR_NONE, CLR_NONE,
                       ILD_MASK);

      ImageList_DrawEx(hlist, idx, pd.DC(), 0, 0, 0, 0, CLR_NONE, CLR_NONE,
                       ILD_NORMAL);

      argb *pm        = (argb *)pd_mask.bits();
      argb *pi        = (argb *)pd.bits();
      argb *pi_end    = pi + pd.width() * pd.height();
      bool  need_mask = true;
      for (argb *t = pi; t < pi_end; ++t) {
        if (t->alfa != 0) {
          need_mask = false;
          break;
        }
      }
      if (need_mask)
        for (; pi < pi_end; ++pi, ++pm)
          pi->alfa = 255 - pm->red;
      // else
      //   for(;pi < pi_end; ++pi )
      //      pi->alfa ^= 0xFF;
      return new bitmap(&pd);
    }

    file_icon_list::file_icon_list(FIL_SIZE sz) {
      _image_list = 0;
      HRESULT hr  = SHGetImageList(sz, IID_IImageList, (void **)&_image_list);
      assert(SUCCEEDED(hr));
      hr = hr;
    }

#if 1
    bitmap *file_icon_list::create(const ustring &filename_in,
                                   bool           allow_read_from_disk) {
      if (!_image_list) return 0;

      critical_section _(lock);

      ustring filename = filename_in;
      filename.replace_all('/', '\\');

      SHFILEINFOW sfi = {0};

#if defined(DISALLOW_FILE_ICON_TO_READ_FS)
      uint flags = SHGFI_SYSICONINDEX | SHGFI_USEFILEATTRIBUTES;
#else
      uint flags = SHGFI_SYSICONINDEX;
      if (!allow_read_from_disk) flags |= SHGFI_USEFILEATTRIBUTES;
#endif

      DWORD file_atts = INVALID_FILE_ATTRIBUTES;

      if (filename.like(L"?:*")) // it is a physical file
      {
        file_atts = GetFileAttributesW(filename);
        // if(file_atts == INVALID_FILE_ATTRIBUTES)
        //  return 0;
      } else {
        if (filename == WCHARS("."))
          file_atts = FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_DIRECTORY;
        else if (filename == WCHARS(".."))
          file_atts = FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_DEVICE;
        else
          file_atts = FILE_ATTRIBUTE_NORMAL;
      }
      if (file_atts == INVALID_FILE_ATTRIBUTES) {
        flags |= SHGFI_USEFILEATTRIBUTES;
        if (filename == WCHARS("."))
          file_atts = FILE_ATTRIBUTE_DIRECTORY;
        else if (filename == WCHARS(".."))
          file_atts = FILE_ATTRIBUTE_DEVICE;
        else
          file_atts = FILE_ATTRIBUTE_NORMAL;
      }

      if (!SHGetFileInfoW(filename, file_atts, &sfi, sizeof(SHFILEINFOW),
                          flags))
        return 0;

      size dimension(GetSystemMetrics(SM_CXSMICON),
                     GetSystemMetrics(SM_CXSMICON));
      ImageList_GetIconSize(_image_list, &dimension.x, &dimension.y);

      bitmap *pb =
          make_bitmap_from_imagelist(dimension, _image_list, sfi.iIcon);
      if (pb) pb->set_url(u8::cvt(filename));
      return pb;
    }
#else 

    // attempt to get icon + overlays, does not work on W10 

    bitmap *file_icon_list::create(const ustring &filename_in,
      bool           allow_read_from_disk) {
      if (!_image_list) return 0;

      critical_section _(lock);

      ustring filename = filename_in;
      filename.replace('/', '\\');

      SHFILEINFOW sfi = { 0 };

#if defined(DISALLOW_FILE_ICON_TO_READ_FS)
      uint flags = SHGFI_SYSICONINDEX | SHGFI_USEFILEATTRIBUTES;
#else
      uint flags = 0;
      if (!allow_read_from_disk) 
        flags |= SHGFI_USEFILEATTRIBUTES | SHGFI_SYSICONINDEX;
      else 
        flags |= SHGFI_ADDOVERLAYS | SHGFI_ICON | SHGFI_OVERLAYINDEX;
#endif

      DWORD file_atts = INVALID_FILE_ATTRIBUTES;

      if (filename.like(L"?:*")) // it is a physical file
      {
        file_atts = GetFileAttributesW(filename);
        // if(file_atts == INVALID_FILE_ATTRIBUTES)
        //  return 0;
      }
      else {
        if (filename == L".")
          file_atts = FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_DIRECTORY;
        else if (filename == L"..")
          file_atts = FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_DEVICE;
        else
          file_atts = FILE_ATTRIBUTE_NORMAL;
      }
      if (file_atts == INVALID_FILE_ATTRIBUTES) {
        flags |= SHGFI_USEFILEATTRIBUTES;
        if (filename == L".")
          file_atts = FILE_ATTRIBUTE_DIRECTORY;
        else if (filename == L"..")
          file_atts = FILE_ATTRIBUTE_DEVICE;
        else
          file_atts = FILE_ATTRIBUTE_NORMAL;
      }

      if (!SHGetFileInfoW(filename, file_atts, &sfi, sizeof(SHFILEINFOW),
        flags))
        return 0;

      size dimension(GetSystemMetrics(SM_CXSMICON),
        GetSystemMetrics(SM_CXSMICON));
      ImageList_GetIconSize(_image_list, &dimension.x, &dimension.y);

      if (sfi.hIcon) {
        point off;
        bitmap *pb = make_bitmap_from_ico_handle(sfi.hIcon,off);
        if (pb) pb->set_url(filename.utf8());
        DestroyIcon(sfi.hIcon);
        return pb;
      }
      else {
        bitmap *pb =
          make_bitmap_from_imagelist(dimension, _image_list, sfi.iIcon);
        if (pb) pb->set_url(filename.utf8());
        return pb;
      }
    }


#endif

#pragma comment(lib, "comctl32.lib")

  } // namespace icon
} // namespace gool

#endif