#pragma once

#include "tool/tool.h"
#include "gool/gool.h"
#include "win/win-view.h"
#include "win/win-frame.h"
#include "html/html-view-print.h"

#if defined(USE_GDI)

namespace gdi {
  using namespace tool;
  using namespace gool;
  class window : public mswin::window {
    typedef mswin::window super;

  public:
    window(const window_params& params): super(params) {}

    virtual GRAPHICS_CAPS graphics_caps() const override {
      return SOFTWARE_GRAPHICS;
    }
    ustring graphics_backend() const { return ustring(W("gdi+")); }
    static LPCWSTR class_name_suffix() { return W("-gdi+"); }

    virtual gool::graphics *surface() override;

    virtual void reset_surface() override {
      if (doc()) doc()->drop_caches();
      _gfx = 0;
      refresh();
    }

    // events
    // virtual void attached();
    virtual void on_size(size sz) override;
    virtual bool render(void *hdc, rect paint_rc) override;
    // virtual void render(html::element* el = 0) override;
    virtual bool render_on(gool::graphics *gfx,
                           rect            paint_rc = rect()) override;
    virtual bool render_layered(void *dc, rect client_rc) override;

    // virtual void test_gfx_paint( point pos ); // for testing purposes

    virtual bool get_transparency() const override { return !!_is_transparent; }
    virtual void set_transparency(bool on_off) override {
      window_frame_updater _(this);
      _is_transparent = on_off;
      _gfx            = 0;
    }

    virtual bool set_frame_type(FRAME_TYPE on) {
      _gfx = 0;
      return super::set_frame_type(on);
    }

    virtual mswin::popup *create_popup() override;
    //virtual gool::text_layout * create_text_layout(wchars text, const text_format &tf) override;

    virtual void
    setup_text_flow(html::element *elem, html::tflow::text_flow &tf,
                    tool::slice<tool::handle<html::node>> nodes) override;
    // virtual void draw_glyph_runs( html::element* elem, const
    // html::tflow::text_flow& tf, gool::graphics* gfx, gool::point at,
    // html::tflow::sel_context* sctx) override;
    virtual void draw_glyph_run(gool::graphics *              gfx,
                                const html::tflow::text_flow &tf,
                                const html::tflow::glyph_run &gr,
                                gool::pointf at, argb color,
                                const style *run_style) override;

  protected:
    // sizef                 _dpi_scale; // how much to scale a design that
    // assumes 96-DPI pixels
    handle<graphics> _gfx;
    tristate_v       _is_transparent;
  };

  class popup : public mswin::popup {
    friend class window;
    typedef mswin::popup super;

  protected:
    handle<gdi::graphics> _gfx;

    popup() {}
    virtual ~popup() { _gfx = 0; }

  public:
    // iwindow stuff:
    virtual gool::graphics *surface() override;

    virtual bool render_layered(void *dc, rect client_rc) override;
    virtual bool render(void *dc, rect client_rc) override;
  };

  inline mswin::popup *window::create_popup() { return new popup(); }

  typedef mswin::frame<window>  frame;
  typedef mswin::dialog<window> dialog;

  class print_view : public html::print_view {
  protected:
    friend class application;
    typedef html::print_view super;
    print_view(const window_params& params): super(params) {}

  public:
    virtual void
    setup_text_flow(html::element *elem, html::tflow::text_flow &tf,
                    tool::slice<tool::handle<html::node>> nodes) override {
      html::print_view::setup_text_flow(elem, tf, nodes);
    }
    virtual void draw_glyph_run(gool::graphics *              gfx,
                                const html::tflow::text_flow &tf,
                                const html::tflow::glyph_run &gr,
                                gool::pointf at, argb color,
                                const html::style *run_style) override {
      html::print_view::draw_glyph_run(gfx, tf, gr, at, color, run_style);
    }
    virtual void draw_glyph_run_back(gool::graphics *              gfx,
                                     const html::tflow::text_flow &tf,
                                     const html::tflow::glyph_run &gr,
                                     gool::rectf rc, argb back_color) override {
      html::print_view::draw_glyph_run_back(gfx, tf, gr, rc, back_color);
    }
  };

} // namespace gdi

#endif