#include "gdi+.h"

#if defined(USE_GDI)

#include "win/win-layered.h"

namespace gdi {

  gool::graphics *window::surface() {
    assert(get_hwnd());

    if (!_gfx) {
      // if(is_layered()) {
      //  _gfx = graphics::create(this);
      //}
      // else
      _gfx = new graphics(get_hwnd());
    }
    return _gfx;
  }

  void window::on_size(size sz) {
    super::on_size(sz);
    //::UpdateWindow(get_hwnd());
  }

  bool window::render(void *hdc, rect paint_rc) {

    Gdiplus::Graphics tgfx((HDC)hdc);
    Gdiplus::Bitmap   tbmp(paint_rc.width(), paint_rc.height(),
                         &tgfx /*PixelFormat32bppPARGB*/);

    {
      handle<gdi::graphics> gfx = new gdi::graphics(&tbmp);

      auto_state<handle<gdi::graphics>> _1(_gfx, gfx);

      if (!_gfx) return false;

      _gfx->offset(-paint_rc.s);

      auto_state<bool>             _2(is_painting, true);
      auto_state<gool::graphics *> _3(drawing_surface, _gfx.ptr());

      if (!paint_rc.empty()) {
        _gfx->_target->SetClip(Gdiplus::Rect(paint_rc.left(), paint_rc.top(),
                                             paint_rc.width(),
                                             paint_rc.height()));
        _gfx->set_clip_rc(paint_rc);
      } else {
        _gfx->_target->SetClip(Gdiplus::Rect(0, 0, dim.x, dim.y));
        _gfx->set_clip_rc(rect(dim));
      }

      /*if(_is_child && doc()->get_style(*this)->is_transparent())
      {
        //if(!_background_bitmap || _background_bitmap->dimension() !=
      this->dim)
        //{
        // dib32 dib(this->dim);
        //  request_window_background(get_hwnd(),dib.DC());
        //  _background_bitmap = new bitmap(&dib);
        //}
        //gfx->draw(_background_bitmap,rect(this->dim));
      }*/

      auto pa = gfx->target()->GetSmoothingMode();

      paint();

      assert(pa == gfx->target()->GetSmoothingMode());
      pa = pa;
    }
    tgfx.DrawImage(&tbmp, paint_rc.s.x, paint_rc.s.y);
    return true;
  }

  /* void window::render(html::element* el)
   {
     surface();
     if(!_gfx)
       return;

     auto_state<bool> _(is_painting,true);

     paint(point(0,0));

   }*/

  bool window::render_on(gool::graphics *gfx, rect paint_rc) {
    auto_state<handle<graphics>>(_gfx, static_cast<gdi::graphics *>(gfx));

    if (!_gfx) return false;

    auto_state<bool> _(is_painting, true);

    if (!paint_rc.empty())
      _gfx->_target->SetClip(Gdiplus::Rect(paint_rc.left(), paint_rc.top(),
                                           paint_rc.width(),
                                           paint_rc.height()));

    paint();
    return true;
  }
  bool window::render_layered(void *dc, rect client_rc) {
    super::render_layered(dc,client_rc);
    if (!doc()) return false;

    size dim = window_dim();

    HWND hwnd = get_hwnd();

    auto_state<bool> _(is_painting, true);

    Gdiplus::Bitmap tbmp(dim.x, dim.y, PixelFormat32bppPARGB);

    rect paint_rc = invalid; // >> 3;

    if (!doc()->is_layout_valid()) {
      doc()->commit_measure(*this);
      paint_rc = client_dim();
    }

    {
      auto_state<handle<gdi::graphics>> _1(
          _gfx, new graphics(&tbmp, argb(0, 0, 0, 0)));
      paint();
    }

    mswin::layered_window_ctx lwctx(dim);

    HBITMAP hbmp = 0;
    tbmp.GetHBITMAP(Color(0, 0, 0, 0), &hbmp);
    HDC     source_dc = CreateCompatibleDC(0);
    HGDIOBJ oldobj    = SelectObject(source_dc, hbmp);
    lwctx.update(hwnd, source_dc);
    SelectObject(source_dc, oldobj);
    DeleteDC(source_dc);
    DeleteObject(hbmp);

    invalid = rect();
    return true;
  }

  gool::graphics *popup::surface() {
    assert(get_hwnd());

    if (!_gfx) {
      // if(is_layered()) {
      //  _gfx = graphics::create(this);
      //}
      // else
      _gfx = new gdi::graphics(get_hwnd());
    }
    return _gfx;
  }

#if 0
  void popup::paint(HDC hdc, rect paint_rc)
  {
    if( is_layered() )
      render_layered();
    else 
    {
      Gdiplus::Graphics tgfx(hdc);
      Gdiplus::Bitmap   tbmp(paint_rc.width(),paint_rc.height(), &tgfx);

      {
        auto_state<handle<gdi::graphics>> _1(_gfx, new gdi::graphics(&tbmp));

        if(!_gfx)
          return;

        _gfx->offset(-paint_rc.origin);

        auto_state<bool>            _2(is_painting,true);
    
        if(!paint_rc.empty()) {
          _gfx->_target->SetClip(Gdiplus::Rect(paint_rc.left(),paint_rc.top(),paint_rc.width(),paint_rc.height()));
          _gfx->set_clip_rc(paint_rc);
        }
        else  {
          size dim = client_dim();
		      _gfx->_target->SetClip(Gdiplus::Rect(0,0,dim.x,dim.y));
          _gfx->set_clip_rc(rect(dim));
        }
        //paint(point(0,0));
        render();
        //_gfx->target()->Flush(FlushIntention::FlushIntentionSync);
	    }
      tgfx.DrawImage(&tbmp,paint_rc.origin.x,paint_rc.origin.y);
    }
  }
  
  bool popup::render() 
  {
    surface();
    if(!_gfx)
      return;

    auto_state<bool> _(is_painting,true);

    html::view* pv = _root->pview();
    if( pv && _root->ldata && _root->state.popup() )
    {
      auto_state<gool::graphics*> _1(pv->drawing_surface, _gfx);
      _gfx->set_drawing_root(_root);
      _root->commit_measure(*pv);
      _gfx->begin_drawing();
      assert( _root->ldata->dim_min.x.is_defined() && _root->ldata->dim_min.y.is_defined());
      assert( _root->ldata->dim.x > 0 && _root->ldata->dim.y > 0 );
      point vp = _root->view_pos(*pv);
      point rp = vp - point(_root->ldata->borpad_left(),_root->ldata->borpad_top());
      rect rc(vp,_root->dim());
      rc >>= rect(_root->ldata->borpad_left(),_root->ldata->borpad_top(), _root->ldata->borpad_right(),_root->ldata->borpad_bottom());
      _gfx->offset(-rp);
      _root->draw(*pv,_gfx,vp);
      _gfx->end_drawing();

    }
    invalid = rect();
    return true;
  }

#endif

  bool popup::render_layered(void *dc, rect client_rc) {
    super::render_layered(dc,client_rc);
    if (!_root) return false;

    size dim = window_dim();

    if (dim.empty()) return false;

    HWND        hwnd = get_hwnd();
    html::view *pv   = _root->pview();

    auto_state<bool> _(is_painting, true);

    // auto updater = [&lwctx,hwnd](HDC hdc) { lwctx.update(hwnd,hdc); };

    Gdiplus::Bitmap           tbmp(dim.x, dim.y, PixelFormat32bppPARGB);
    mswin::layered_window_ctx lwctx(dim);

    if (pv && _root->ldata) {
      handle<graphics> gfx = new graphics(&tbmp, argb(0, 0, 0, 0));
      gfx->set_drawing_root(_root);
      auto_state<gool::graphics *> _1(pv->drawing_surface, gfx);
      _root->commit_measure(*pv);
      point vp = _root->view_pos(*pv);
      auto outline_margins = _root->outline_distance(*pv);
      point rp =
        vp - //point(_root->ldata->borpad_left(), _root->ldata->borpad_top());
             outline_margins.s;
      rect rc(vp, _root->dim());
      rc >>= //rect(_root->ldata->borpad_left(), _root->ldata->borpad_top(),
             //     _root->ldata->borpad_right(), _root->ldata->borpad_bottom());
             outline_margins;
      gfx->offset(-rp);
      _root->draw(*pv, gfx, vp);
    }

    HBITMAP hbmp = 0;
    tbmp.GetHBITMAP(Color(0, 0, 0, 0), &hbmp);
    HDC     source_dc = CreateCompatibleDC(0);
    HGDIOBJ oldobj    = SelectObject(source_dc, hbmp);
    lwctx.update(hwnd, source_dc);
    SelectObject(source_dc, oldobj);
    DeleteDC(source_dc);
    DeleteObject(hbmp);

    invalid = rect();

    return true;
  }
  bool popup::render(void *hdc, rect paint_rc) {
    // WTF? Gdiplus::Graphics tgfx((HDC)hdc);
    // WTF? Gdiplus::Bitmap   tbmp(paint_rc.width(),paint_rc.height(), &tgfx);

    auto_state<handle<gdi::graphics>> _1(_gfx, new gdi::graphics((HDC)hdc));

    if (!_gfx) return false;

    // WTF? _gfx->offset(-paint_rc.origin);

    auto_state<bool> _2(is_painting, true);

    if (!paint_rc.empty()) {
      _gfx->_target->SetClip(Gdiplus::Rect(paint_rc.left(), paint_rc.top(),
                                           paint_rc.width(),
                                           paint_rc.height()));
      _gfx->set_clip_rc(paint_rc);
    } else {
      size dim = this->client_dim();
      _gfx->_target->SetClip(Gdiplus::Rect(0, 0, dim.x, dim.y));
      _gfx->set_clip_rc(rect(dim));
    }
    // this->render();

    html::view *pv = _root->pview();
    if (pv && _root->ldata && _root->state.popup()) {
      auto_state<gool::graphics *> _1(pv->drawing_surface, _gfx);
      _gfx->set_drawing_root(_root);
      _root->commit_measure(*pv);
      _gfx->begin_drawing();
      assert(_root->ldata->dim_min.x.is_defined() &&
             _root->ldata->dim_min.y.is_defined());
      assert(_root->ldata->dim.x > 0 && _root->ldata->dim.y > 0);
      point vp = _root->view_pos(*pv);
      point rp =
          vp - point(_root->ldata->borpad_left(), _root->ldata->borpad_top());
      rect rc(vp, _root->dim());
      rc >>= rect(_root->ldata->borpad_left(), _root->ldata->borpad_top(),
                  _root->ldata->borpad_right(), _root->ldata->borpad_bottom());
      _gfx->offset(-rp);
      _root->draw(*pv, _gfx, vp);
      _gfx->end_drawing();
    }
    invalid = rect();
    return true;
  }

  mswin::window* application::create_window_processor(const window_params &params) {
    return new gdi::window(params);
  }

  handle<html::view> application::create_frame(const window_params &params) {
    // window_params wparams(params);
    return handle<html::view>(gdi::frame::construct(params).ptr());
  }
  handle<html::view> application::create_dialog(const window_params &params) {
    // window_params wparams(params);
    return handle<html::view>(gdi::dialog::construct(params).ptr());
  }

} // namespace gdi

#endif