/**************************************************************************\
*
* Modified version of: GdiplusBase.h
*
* class GdiplusBase is public virtual tool::resource now (reference counting)
*
* -------------------------------------------------------------------------
* Copyright (c) 1998-2001, Microsoft Corp.  All Rights Reserved.
*
* Module Name:
*
*   GdiplusBase.h
*
* Abstract:
*
*   GDI+ base memory allocation class
*
\**************************************************************************/

#ifndef _GDIPLUSBASE_H
#define _GDIPLUSBASE_H

#include "tool/tool.h"

namespace GdiplusX {

  namespace Gdiplus {
    namespace DllExports {
#include "GdiplusMem.h"
    };

    class GdiplusBase : public virtual tool::resource {
    public:
      void(operator delete)(void *in_pVoid) { DllExports::GdipFree(in_pVoid); }
      void *(operator new)(size_t in_size) {
        return DllExports::GdipAlloc(in_size);
      }
      void(operator delete[])(void *in_pVoid) {
        DllExports::GdipFree(in_pVoid);
      }
      void *(operator new[])(size_t in_size) {
        return DllExports::GdipAlloc(in_size);
      }
    };
  } // namespace Gdiplus

} // namespace GdiplusX

#endif
