#pragma once

#include "win/win-application.h"
#include "win/win-frame.h"

#if defined(USE_GDI)

namespace gdi {
  using namespace Gdiplus;

  bool          gdi_init_font(gool::font *gf);
  tool::ustring gdi_supported_font_family(
      const tool::ustring &family_name_list /*comma separated list*/);
  bool            gdi_install_font(const tool::ustring &name, tool::bytes data);
  gool::font *    gdi_create_font(const ustring &name, float size, uint weight,
                                  bool italic, FONT_RENDERING mode);
  bool            gdi_used_font(tool::handle<gool::font> &pf,
                                tool::wchars family_name_list, const gool::font *proto,
                                tool::wchars lang_id, WRITING_SCRIPT script,
                                uint char_code = 0);
  void            gdi_clear_font_cache();
  gool::path *    gdi_create_path();
  gool::graphics *gdi_create_bitmap_graphics(gool::graphics *proto,
                                             gool::bitmap *  bmp,
                                             gool::argb      initc);
  gool::graphics *gdi_create_bitmap_bits_graphics(gool::bitmap *pb,
                                                  gool::argb    initc,
                                                  bool high_quality = false);

  class application : public mswin::application {
    friend application *app_factory();

    typedef mswin::application super;

  public:
    DEFINE_TYPE_ID(application)

    virtual void final_release() override;

    virtual bool is_valid() override;
    virtual bool is_gdi() override { return true; }

    virtual tool::ustring
    get_supported_font_family(const tool::ustring &family_name_list) override {
      critical_section _(guard);
      return gdi_supported_font_family(family_name_list);
    }

    virtual bool install_font(const tool::ustring &name, int weight,
                              bool italic, tool::bytes data) override {
      return gdi_install_font(name, data);
    }

    virtual bool supports_printing() const override { return true; }
    virtual html::print_view* create_print_processor(const window_params& params) override;

    virtual bool get_used_font(tool::handle<gool::font> &pf,
                               tool::wchars              family_name_list,
                               const gool::font *proto, tool::wchars lang_id,
                               WRITING_SCRIPT script, uint char_code = 0) {
      return gdi_used_font(pf, family_name_list, proto, lang_id, script,
                           char_code);
    }

    virtual gool::font *create_font(const ustring &name, float size,
                                    uint weight, bool italic,
                                    FONT_RENDERING mode) {
      critical_section _(guard);
      return gdi_create_font(name, size, weight, italic, mode);
    }
    virtual void clear_font_cache() override { gdi_clear_font_cache(); }

    virtual gool::path *create_path() { return gdi_create_path(); }

    virtual gool::graphics *create_bitmap_graphics(gool::graphics *proto,
                                                   gool::bitmap *  bmp,
                                                   gool::argb initc) override {
      return gdi_create_bitmap_graphics(proto, bmp, initc);
    }
    virtual gool::graphics *
    create_bitmap_bits_graphics(gool::bitmap *pb, gool::argb initc,
                                bool high_quality = false) override {
      return gdi_create_bitmap_bits_graphics(pb, initc, high_quality);
    }

    //virtual gool::text_layout * create_text_layout(tool::wchars text, const gool::text_format &tf) override;

    virtual GRAPHICS_CAPS graphics_caps() const override {
      return SOFTWARE_GRAPHICS;
    }

    virtual mswin::window* create_window_processor(const window_params &params) override;

    virtual handle<html::view> create_frame(const window_params &params) override;
    virtual handle<html::view> create_dialog(const window_params &params) override;

  protected:
    application();

    virtual bool init_font(gool::font *pf) override {
      critical_section _(guard);
      return gdi_init_font(pf);
    }
  };

#if 0
  class printing_application
    : public gool::application
  {
    typedef gool::application super;

  public:

    DEFINE_TYPE_ID(application)

    virtual void final_release() override;
    virtual bool is_valid() override;

    static gool::application* create();

    virtual tool::ustring get_supported_font_family(const tool::ustring& family_name_list) override
      {
        critical_section _(guard); 
        return gdi_supported_font_family(family_name_list);
      }
        
    virtual bool install_font(const tool::ustring& name, int weight, bool italic, tool::bytes data) override 
      { 
        return gdi_install_font(name,data); 
      }

    virtual bool get_used_font(
        tool::handle<gool::font>& pf,
        tool::wchars family_name_list, const gool::font* proto,
        tool::wchars lang_id, 
        WRITING_SCRIPT script, 
        uint char_code = 0) 
      {
        return gdi_used_font(pf,family_name_list,proto,lang_id,script,char_code);
      }

    virtual gool::font*     create_font(const ustring& name, float size, uint weight, bool italic, FONT_RENDERING  mode)
      {
        critical_section _(guard);
        return gdi_create_font(name,size,weight,italic,mode);
      }
    virtual void            clear_font_cache() override
      {
        gdi_clear_font_cache();
      }

    virtual gool::path*     create_path() 
      {
        return gdi_create_path();
      }

    virtual gool::graphics*    create_bitmap_graphics( gool::graphics *proto, gool::bitmap *bmp, gool::argb initc ) override
      {
        return gdi_create_bitmap_graphics( proto, bmp, initc );
      }
    virtual gool::graphics*    create_bitmap_bits_graphics(gool::bitmap* pb, gool::argb initc, bool high_quality = false) override
      {
        return gdi_create_bitmap_bits_graphics(pb, initc, high_quality);
      }

    virtual gool::text_layout* create_text_layout(tool::wchars text, const gool::text_format& tf) override;
    
    virtual GRAPHICS_CAPS graphics_caps() const override { return SOFTWARE_GRAPHICS; }

    virtual handle<html::view> create_frame(const window_params& params) override { return nullptr; }
    virtual handle<html::view> create_dialog(const window_params& params) override { return nullptr; }
#ifdef WIC_SUPPORT
    virtual IWICImagingFactory*   wic_factory() const override { return nullptr; }
#endif


  protected:
    printing_application();

    virtual bool init_font(gool::font* pf) override
      {
        critical_section _( guard); 
        return gdi_init_font(pf);
      }
        

  };
#endif

} // namespace gdi

#endif