
#ifndef SBIO_H
#define SBIO_H


#include "stdlib.h"
#include "mbedtls/ssl.h"
#include "defs.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char BYTE;

struct _SBIO;
typedef struct _SBIO SBIO;

struct _SBIO {
    SBIO* prev;          /* previous in chain */
    SBIO* next;          /* next in chain */
    SBIO* pair;          /* SBIO paired with */
    BYTE*        mem;           /* memory buffer */
    int          wrSz;          /* write buffer size (mem) */
    int          wrIdx;         /* current index for write buffer */
    int          rdIdx;         /* current read index */
    int          readRq;        /* read request */
    int          memLen;        /* memory buffer length */
    int          type;          /* method type */
};

enum {
    SSL_SBIO_ERROR = -1,
    SSL_SBIO_UNSET = -2,
    SSL_SBIO_SIZE  = 1024 * 1024  /* default SBIO write size if not set */
};

enum SBIO_TYPE {
    SBIO_BUFFER = 1,
    SBIO_SOCKET = 2,
    SBIO_SSL    = 3,
    SBIO_MEMORY = 4,
    SBIO_SBIO    = 5,
    SBIO_FILE   = 6
};


// IO API

SBIO *SSL_SBIO_new(int type);
int SBIO_make_bio_pair(SBIO *b1, SBIO *b2);


size_t SBIO_ctrl_pending(SBIO *bio);
int SBIO_read(SBIO *bio, char *buf, size_t size);
int SBIO_write(SBIO *bio, const char *buf, size_t size);

int SBIO_net_recv( void *ctx, unsigned char *buf, size_t len);
int SBIO_net_send( void *ctx, const unsigned char *buf, size_t len );
int SBIO_free_all(SBIO* bio);
int SBIO_free(SBIO* bio);

#ifdef __cplusplus
};
#endif

#endif //CHAT_SBIO_H
