#include "d2d.h"
#include "html/html.h"
#include "win/win-application.h"
#include "win/win-delayload.h"
#include <numeric>
#include <comdef.h>

//DLOADV(_D3D10CreateDevice1, D3D10CreateDevice1, d3d10_1.dll,
//       HRESULT(WINAPI *)(IDXGIAdapter *pAdapter, D3D10_DRIVER_TYPE DriverType,
//                         HMODULE Software, UINT Flags,
//                         D3D10_FEATURE_LEVEL1 HardwareLevel, UINT SDKVersion,
//                         ID3D10Device1 **ppDevice));

#if defined(USE_D2D_PLUS)
EXTERN_DLOADV(_D3D11CreateDevice, D3D11CreateDevice, d3d11.dll,
       HRESULT(WINAPI *)(IDXGIAdapter *pAdapter, D3D_DRIVER_TYPE DriverType,
                         HMODULE Software, UINT Flags,
                         const D3D_FEATURE_LEVEL *pFeatureLevels,
                         UINT FeatureLevels, UINT SDKVersion,
                         ID3D11Device **       ppDevice,
                         D3D_FEATURE_LEVEL *   pFeatureLevel,
                         ID3D11DeviceContext **ppImmediateContext));
#endif

namespace d2d {
  using namespace tool;
  using namespace gool;
  using namespace html;
  using namespace mswin;

  bool is_display_hw_capable();

  window_graphics *window_graphics::create(html::iwindow *pw,
                                           bool           is_transparent,
                                           GRAPHICS_CAPS  caps) {
    auto_ptr<window_graphics> pg =
        auto_ptr<window_graphics>(new window_graphics(is_transparent));

    D2D1_RENDER_TARGET_PROPERTIES rtp = D2D1::RenderTargetProperties();
    rtp.dpiX                          = 96.0;
    rtp.dpiY                          = 96.0;

    GRAPHICS_CAPS gfx_layer = caps;

    if (gfx_layer == WARP_GRAPHICS || !is_display_hw_capable()) {
      rtp.type  = D2D1_RENDER_TARGET_TYPE_SOFTWARE;
      gfx_layer = WARP_GRAPHICS;
    } else
      gfx_layer = HARDWARE_GRAPHICS;

    rtp.pixelFormat =
        D2D1::PixelFormat(DXGI_FORMAT_B8G8R8A8_UNORM,
                          is_transparent ? D2D1_ALPHA_MODE_PREMULTIPLIED
                                         : D2D1_ALPHA_MODE_IGNORE);
    D2D1_HWND_RENDER_TARGET_PROPERTIES wrtp =
        D2D1::HwndRenderTargetProperties(pw->get_hwnd(), g2u(pw->client_dim()));
    // wrtp.presentOptions =
    // D2D1_PRESENT_OPTIONS_RETAIN_CONTENTS;//D2D1_PRESENT_OPTIONS_IMMEDIATELY;

    // Create a Direct2D render target.
     com::asset<ID2D1HwndRenderTarget> rt;
    HRESULT hr = d2_factory()->CreateHwndRenderTarget(
        rtp, wrtp, rt.target());
    if (FAILED(hr)) return 0;
    pg->render_target(rt);
    pg->set_clip_rc(pw->window_dim());

    D2D1_RENDER_TARGET_PROPERTIES hardware = rtp;
    hardware.type                          = D2D1_RENDER_TARGET_TYPE_HARDWARE;
    if (pg->render_target()->IsSupported(&hardware))
      pg->_graphics_caps = HARDWARE_GRAPHICS;
    else
      pg->_graphics_caps = WARP_GRAPHICS;

    return pg.release();
  }
#if defined(USE_D2D_PLUS)
  void window_graphics_dxgi::release_device() {
    _bitmap.release();
    _device_context.release();
    _render_target.release();
    _swap_chain.release();
  }

  bool window_graphics_dxgi::create_device_swap_chain_bitmap() {
    com::asset<IDXGISurface> surface;
    HRESULT             hr = _swap_chain->GetBuffer(
        0, // buffer index
        __uuidof(surface), reinterpret_cast<void **>(surface.target()));
    if (FAILED(hr)) return false;

    D2D1_BITMAP_OPTIONS bitmap_options =
        D2D1_BITMAP_OPTIONS_TARGET | D2D1_BITMAP_OPTIONS_CANNOT_DRAW;
    if (this->_for_layered)
      bitmap_options |= D2D1_BITMAP_OPTIONS_GDI_COMPATIBLE;

    auto props = D2D1::BitmapProperties1(
        bitmap_options,
        D2D1::PixelFormat(DXGI_FORMAT_B8G8R8A8_UNORM,
                          _transparent ? D2D1_ALPHA_MODE_PREMULTIPLIED
                                       : D2D1_ALPHA_MODE_IGNORE));

    com::asset<ID2D1Bitmap1> bitmap;
    hr = device_context()->CreateBitmapFromDxgiSurface(surface, props, bitmap.target());
    if (SUCCEEDED(hr)) {
      device_context()->SetTarget(bitmap);
      device_context()->SetDpi(96.0, 96.0); // we do DIPs by ourselves
    }
    return true;
  }

  bool window_graphics_dxgi::is_feasible() {
    application *papp = static_cast<application *>(gool::app());
    //if (!papp || !papp->d2_1_factory()) return false;
    //return true;
    return papp && papp->device_3d() && papp->d2_1_factory();
  }

  void window_graphics_dxgi::end_drawing() {
    auto const hr = _swap_chain->Present(1, 0);
    if (S_OK != hr && DXGI_STATUS_OCCLUDED != hr) 
      release_device();
  }

  bool create_d2d_device(com::asset<ID2D1Device> &d2d1_device) {

    application *papp = static_cast<application *>(gool::app());

    com::asset<ID3D11Device> device = papp->device_3d();

    if (!device) return false;

    com::asset<ID3D11Device1>        device1;
    com::asset<ID3D11DeviceContext1> context1;

    HRESULT hr;

    hr = device->QueryInterface<ID3D11Device1>(device1.target());
    if (FAILED(hr)) return false;

    com::asset<IDXGIDevice> dxgi_device;
    hr = device1->QueryInterface<IDXGIDevice>(dxgi_device.target());
    if (FAILED(hr)) return false;

    hr = papp->d2_1_factory()->CreateDevice(dxgi_device, d2d1_device.target());
    if (FAILED(hr)) return false;

    return SUCCEEDED(hr);
  }

  bool window_graphics_dxgi::create_device() {

    application *papp = static_cast<application *>(gool::app());

    com::asset<ID3D11Device>         device = papp->device_3d();
    if (!device) return false;

    com::asset<ID3D11Device1>        device1;
    com::asset<ID3D11DeviceContext1> context1;

    HRESULT hr;

    hr = device->QueryInterface<ID3D11Device1>(device1.target());
    if (FAILED(hr)) return false;

    com::asset<IDXGIDevice> dxgi_device;
    hr = device1->QueryInterface<IDXGIDevice>(dxgi_device.target());
    if (FAILED(hr)) return false;

    com::asset<ID2D1Device> d2d1_device;
    hr = papp->d2_1_factory()->CreateDevice(dxgi_device, d2d1_device.target());
    if (FAILED(hr)) return false;

    com::asset<ID2D1DeviceContext> dc;

    hr = d2d1_device->CreateDeviceContext(D2D1_DEVICE_CONTEXT_OPTIONS_NONE, dc.target());
    if (FAILED(hr)) return false;

    device_context(dc);

    com::asset<IDXGIAdapter> dxgi_adapter;
    hr = dxgi_device->GetAdapter(dxgi_adapter.target());
    if (FAILED(hr)) return false;

    com::asset<IDXGIFactory2> dxgi_factory;
    hr = dxgi_adapter->GetParent(
        __uuidof(dxgi_factory),
        reinterpret_cast<void **>(dxgi_factory.target()));
    if (FAILED(hr)) return false;

    DXGI_SWAP_CHAIN_DESC1 props = {};
    props.Format                = DXGI_FORMAT_B8G8R8A8_UNORM;
    props.SampleDesc.Count      = 1;
    props.BufferUsage           = DXGI_USAGE_RENDER_TARGET_OUTPUT;
    props.BufferCount           = 2;
    props.SwapEffect            = DXGI_SWAP_EFFECT_DISCARD;
    props.AlphaMode             = DXGI_ALPHA_MODE_IGNORE;

    hr = dxgi_factory->CreateSwapChainForHwnd(device1, _window->get_hwnd(), &props, nullptr,
                                              nullptr, _swap_chain.target());

    if (FAILED(hr)) return false;

    if (!_swap_chain)
      return false; // this erroneous behavior is observed at least in D3DGear:
                    // it returns S_OK but _swap_chain is NULL - bastards.

    dxgi_factory->MakeWindowAssociation(_window->get_hwnd(), DXGI_MWA_NO_ALT_ENTER);

    return true;
  }

  void window_graphics_dxgi::resize(gool::size nsz) {
    if (!nsz.empty() && device_context()) {
      device_context()->SetTarget(_bitmap = nullptr);
      HRESULT hr = _swap_chain ? _swap_chain->ResizeBuffers(0, nsz.x, nsz.y, DXGI_FORMAT_UNKNOWN, 0): E_FAIL;
      if (SUCCEEDED(hr))
        create_device_swap_chain_bitmap();
      else {
        release_device();
        create_device();
      }
    }
    set_clip_rc(nsz);
  }

  window_graphics_dxgi *window_graphics_dxgi::create(html::iwindow *pw,
                                                     bool is_transparent,
                                                     GRAPHICS_CAPS caps,
                                                     bool for_layered) {
    if (!is_feasible()) return nullptr;

    auto_ptr<window_graphics_dxgi> pg = auto_ptr<window_graphics_dxgi>(new window_graphics_dxgi(pw, is_transparent, caps, for_layered));

    if (pg->create_device() && pg->create_device_swap_chain_bitmap()) {
      pg->_graphics_caps = d2d_app()->requested_gfx_layer;
      return pg.release();
    }

    return nullptr;
  }
#endif // defined(USE_D2D_PLUS)

  dx_window_graphics *dx_window_graphics::create(html::iwindow * pw,
                                                 IDXGISwapChain *pSwapChain) {
    auto_ptr<dx_window_graphics> pg =
        auto_ptr<dx_window_graphics>(new dx_window_graphics(true));

    D2D1_RENDER_TARGET_PROPERTIES rtp = D2D1::RenderTargetProperties(
        D2D1_RENDER_TARGET_TYPE_DEFAULT,
        D2D1::PixelFormat(DXGI_FORMAT_UNKNOWN, D2D1_ALPHA_MODE_PREMULTIPLIED),
        96.0, 96.0);

    HRESULT hr;

    com::asset<IDXGISurface> surface;
    hr = pSwapChain->GetBuffer(0, // buffer index
                               __uuidof(surface),
                               reinterpret_cast<void **>(surface.target()));
    if (FAILED(hr)) return nullptr;

    com::asset<ID2D1RenderTarget> rt;

    hr = d2_factory()->CreateDxgiSurfaceRenderTarget(surface, &rtp, rt.target());
    if (FAILED(hr)) return nullptr;

    pg->render_target(rt);

    return pg.release();
  }


#if defined(USE_HARDWARE_BLACKLIST) || defined(USE_DX_ON_LAYERED)

#ifdef USE_D2D_PLUS
  bool create_DX_device(com::asset<ID3D11Device> &device,
                        GRAPHICS_CAPS        requested_caps,
                        GRAPHICS_CAPS &      actual_caps) {
    if (!_D3D11CreateDevice) return false;

    D3D_DRIVER_TYPE drivers[] = {
        D3D_DRIVER_TYPE_HARDWARE,
        D3D_DRIVER_TYPE_WARP,
    };

    D3D_FEATURE_LEVEL levels[] = {
        D3D_FEATURE_LEVEL_11_1, D3D_FEATURE_LEVEL_11_0, D3D_FEATURE_LEVEL_10_1,
        D3D_FEATURE_LEVEL_10_0, D3D_FEATURE_LEVEL_9_3,  D3D_FEATURE_LEVEL_9_2,
        D3D_FEATURE_LEVEL_9_1};

    int m_start = 0;
    if (requested_caps == WARP_GRAPHICS || !is_display_hw_capable())
      m_start = 1; // the driver is known as bad so force to use WARP instead.

    // D3D_FEATURE_LEVEL  used_level;

    for (int m = m_start; m < items_in(drivers); ++m) {
      HRESULT hr = _D3D11CreateDevice()(
          0, // adapter
          drivers[m], NULL, D3D11_CREATE_DEVICE_BGRA_SUPPORT, levels,
          items_in(levels), D3D11_SDK_VERSION, device.target(), NULL, NULL);

      if (SUCCEEDED(hr)) {
        actual_caps = m == 0 ? HARDWARE_GRAPHICS : WARP_GRAPHICS;
        return true;
      }
    }
    return false;
  }

#else
  bool create_DX_device(com::asset<ID3D10Device1> &device,
                        GRAPHICS_CAPS         requested_caps,
                        GRAPHICS_CAPS &       actual_caps) {
    if (!_D3D10CreateDevice1) return false;

    D3D10_DRIVER_TYPE drivers[] = {D3D10_DRIVER_TYPE_HARDWARE,
                                   D3D10_DRIVER_TYPE_WARP};

    D3D10_FEATURE_LEVEL1 levels[] = {
        // D3D11_FEATURE_LEVEL_11_0,
        D3D10_FEATURE_LEVEL_10_1, D3D10_FEATURE_LEVEL_10_0,
        /*D3D10_FEATURE_LEVEL_9_3,
        D3D10_FEATURE_LEVEL_9_2,
        D3D10_FEATURE_LEVEL_9_1,*/
    };

    int m_start = 0;
    if (requested_caps == WARP_GRAPHICS || !is_display_hw_capable())
      m_start = 1; // the driver is known as bad so force to use WARP instead.

    for (int m = m_start; m < items_in(drivers); ++m) {
      for (int n = 0; n < items_in(levels); ++n) {
        HRESULT hr =
            _D3D10CreateDevice1()(0, // adapter
                                  drivers[m],
                                  0, // reserved
                                  D3D10_CREATE_DEVICE_BGRA_SUPPORT, levels[n],
                                  D3D10_1_SDK_VERSION, device.target());

        if (SUCCEEDED(hr)) {
          actual_caps = m == 0 ? HARDWARE_GRAPHICS : WARP_GRAPHICS;
          return true;
        }
      }
    }
    return false;
  }
#endif

#endif

#if defined(USE_DX_ON_LAYERED)

  layered_window_graphics_dx *
  layered_window_graphics_dx::create(html::iwindow *pw,
                                     GRAPHICS_CAPS  requested_caps) {
    auto_ptr<layered_window_graphics_dx> pg =
        auto_ptr<layered_window_graphics_dx>(new layered_window_graphics_dx());
    // bool is_hw = false;
    if (!create_DX_device(pg->_device, requested_caps, pg->_graphics_caps))
      return 0;
    pg->resize(pw->client_dim());
    return pg.release();
  }
#endif

  layered_window_graphics_hdc *
  layered_window_graphics_hdc::create(html::iwindow *pw, GRAPHICS_CAPS caps) {
    auto_ptr<layered_window_graphics_hdc> pg =
        auto_ptr<layered_window_graphics_hdc>(
            new layered_window_graphics_hdc(caps));
    pg->resize(pw->client_dim());
    return pg.release();
  }

#if defined(USE_DX_ON_LAYERED)
  void layered_window_graphics_dx::resize(gool::size nsz) {
    assert(_device);

    if (!_device) return;

#ifdef USE_D2D_PLUS
    D3D11_TEXTURE2D_DESC description = {};
    description.ArraySize            = 1;
    description.BindFlags            = D3D11_BIND_RENDER_TARGET;
    description.Format               = DXGI_FORMAT_B8G8R8A8_UNORM;
    description.Width                = max(1, nsz.x);
    description.Height               = max(1, nsz.y);
    description.MipLevels            = 1;
    description.SampleDesc.Count     = 1;
    description.MiscFlags            = D3D11_RESOURCE_MISC_GDI_COMPATIBLE;
    HRESULT hr = _device->CreateTexture2D(&description, 0, _texture.target());
    if (FAILED(hr)) {
      assert(false);
      return;
    }
    hr = _texture->QueryInterface<IDXGISurface>(_surface.target());
#else
    D3D10_TEXTURE2D_DESC description = {};
    description.ArraySize            = 1;
    description.BindFlags            = D3D10_BIND_RENDER_TARGET;
    description.Format               = DXGI_FORMAT_B8G8R8A8_UNORM;
    description.Width                = max(1, nsz.x);
    description.Height               = max(1, nsz.y);
    description.MipLevels            = 1;
    description.SampleDesc.Count     = 1;
    description.MiscFlags            = D3D10_RESOURCE_MISC_GDI_COMPATIBLE;

    HRESULT hr = _device->CreateTexture2D(&description, 0, _texture.target());
    if (FAILED(hr)) {
      assert(false);
      return;
    }
    hr = _texture->QueryInterface<IDXGISurface>(_surface.target());
#endif

    if (FAILED(hr)) {
      assert(false);
      return;
    }

    D2D1_RENDER_TARGET_PROPERTIES rtp = D2D1::RenderTargetProperties();
    rtp.dpiX                          = 96.0;
    rtp.dpiY                          = 96.0;
    rtp.usage                         = D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE;
    rtp.pixelFormat = D2D1::PixelFormat(DXGI_FORMAT_B8G8R8A8_UNORM,
                                        D2D1_ALPHA_MODE_PREMULTIPLIED);
    // rtp.minLevel = D2D1_FEATURE_LEVEL_10;

    hr = d2_factory()->CreateDxgiSurfaceRenderTarget(_surface, &rtp,
                                                     _render_target.target());

#ifdef USE_D2D_PLUS
    if (SUCCEEDED(hr)) {
      _render_target->QueryInterface<ID2D1DeviceContext>(_device_context.target());
    }
#endif
    assert(SUCCEEDED(hr));
    set_clip_rc(nsz);
  }
#endif

  void layered_window_graphics_hdc::resize(gool::size nsz) {
    // super::resize( nsz );
    
    if (render_target() && _bitmap && _bitmap->dim() == nsz) 
      return;

    _bitmap = new dib32(nsz);

    com::asset<ID2D1DCRenderTarget> rt;

    if (!render_target()) {

      D2D1_RENDER_TARGET_PROPERTIES props = D2D1::RenderTargetProperties(
          _render_target_type,
          D2D1::PixelFormat(DXGI_FORMAT_B8G8R8A8_UNORM,
                            D2D1_ALPHA_MODE_PREMULTIPLIED),
          0, 0, D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE,
          D2D1_FEATURE_LEVEL_DEFAULT);

      HRESULT hr = d2_factory()->CreateDCRenderTarget(&props, rt.target());
      assert(SUCCEEDED(hr));
      if (SUCCEEDED(hr)) {
        render_target(rt);
        D2D1_RENDER_TARGET_PROPERTIES hardware = props;
        hardware.type = D2D1_RENDER_TARGET_TYPE_HARDWARE;
        if (_render_target->IsSupported(&hardware))
          _render_target_type = D2D1_RENDER_TARGET_TYPE_HARDWARE;
        else
          _render_target_type = D2D1_RENDER_TARGET_TYPE_SOFTWARE;
      }
    }
    else
      render_target()->QueryInterface<ID2D1DCRenderTarget>(rt.target());

    if (rt) {
      rect rc(nsz);
      rt->BindDC(_bitmap->DC(), PRECT(rc));
    }
    set_clip_rc(nsz);
  }

} // namespace d2d

