#pragma once

#include "d2d.h"
#include "html/html.h"
#include "html/html-layout-text-analysis.h"
#include "html/html-layout-text-flow.h"
#include "d2d-application.h"

namespace d2d {

  using namespace tool;
  using namespace gool;
  using namespace html;
  using namespace html::tflow;

  // Helper source/sink class for text analysis.
  class text_analysis
      : public html::tflow::text_analysis,
        public com::base<text_analysis,
                         com::list<IDWriteTextAnalysisSource,
                                   com::list<IDWriteTextAnalysisSink,
                                             com::list<IUnknown>>>> {

  public:
    // the only public method that wraps text analysis functionality:
    static bool exec(view &v, element *el, tflow::text_flow &tf,
                     slice<hnode> nodes);

  private:
    text_analysis() {}

    bool generate_results(view &v, element *el, slice<hnode> nodes,
                          IDWriteTextAnalyzer *textAnalyzer,
                          OUT tool::array<wchar> &text,
                          OUT tool::array<text_run> &runs,
                          OUT tool::array<LINE_BREAKPOINT> &breakpoints);

    void shape_glyph_runs(view &v, element *elem, tflow::text_flow &tf,
                          IDWriteTextAnalyzer *textAnalyzer);

    // IDWriteTextAnalysisSource implementation

    IFACEMETHODIMP GetTextAtPosition(UINT32 text_position,
                                     OUT WCHAR const **text_string,
                                     OUT UINT32 *text_length) throw();

    IFACEMETHODIMP GetTextBeforePosition(UINT32 text_position,
                                         OUT WCHAR const **text_string,
                                         OUT UINT32 *text_length) throw();

    IFACEMETHODIMP_(DWRITE_READING_DIRECTION)
    GetParagraphReadingDirection() throw();

    IFACEMETHODIMP GetLocaleName(UINT32 text_position, OUT UINT32 *text_length,
                                 OUT WCHAR const **localeName) throw();

    IFACEMETHODIMP GetNumberSubstitution(
        UINT32 text_position, OUT UINT32 *text_length,
        OUT IDWriteNumberSubstitution **numberSubstitution) throw();

    // IDWriteTextAnalysisSink implementation

    IFACEMETHODIMP
    SetScriptAnalysis(UINT32 text_position, UINT32 text_length,
                      DWRITE_SCRIPT_ANALYSIS const *scriptAnalysis) throw();

    IFACEMETHODIMP SetLineBreakpoints(
        UINT32 text_position, UINT32 text_length,
        const DWRITE_LINE_BREAKPOINT *lineBreakpoints // [text_length]
        ) throw();

    IFACEMETHODIMP SetBidiLevel(UINT32 text_position, UINT32 text_length,
                                UINT8 explicitLevel,
                                UINT8 resolvedLevel) throw();

    IFACEMETHODIMP SetNumberSubstitution(
        UINT32 text_position, UINT32 text_length,
        IDWriteNumberSubstitution *numberSubstitution) throw();
  };

  void setup_text_flow(html::view &v, html::element *elem,
                       html::tflow::text_flow &              tf,
                       tool::slice<tool::handle<html::node>> nodes);

} // namespace d2d