#include "d2d.h"
#include "html/html.h"
#include "html/html-view-print.h"
#include "win/win-delayload.h"

#include <xpsobjectmodel_1.h>
#include <DocumentTarget.h>
#include <Prntvpt.h>

//#pragma comment(lib, "Prntvpt.lib")

DLOADV(_PTConvertDevModeToPrintTicket, PTConvertDevModeToPrintTicket,
       prntvpt.dll,
       HRESULT(WINAPI *)(HPTPROVIDER hProvider, ULONG cbDevmode,
                         PDEVMODE pDevmode, EPrintTicketScope scope,
                         IStream *pPrintTicket));

DLOADV(_PTOpenProvider, PTOpenProvider, prntvpt.dll,
       HRESULT(WINAPI *)(PCWSTR pszPrinterName, DWORD version,
                         HPTPROVIDER *phProvider));

DLOADV(_PTCloseProvider, PTCloseProvider, prntvpt.dll,
       HRESULT(WINAPI *)(HPTPROVIDER hProvider));

namespace d2d {
  using namespace mswin;

  html::print_view* application::create_print_processor(const window_params& params) {
    html::print_view* ppv = new print_view(params);
    ppv->app        = this;
    return ppv;
  }

  struct d2d_print_target : gool::print_target {
    virtual bool print(const ustring &doc_name,
                       function<bool(gool::graphics *page_gfx, int page_no)>
                           renderer) override;

    HRESULT get_print_ticket_from_devmode(
        /*out*/ com::asset<IStream> &print_ticket_stream);
  };

  HRESULT d2d_print_target::get_print_ticket_from_devmode(
      /*out*/ com::asset<IStream> &print_ticket_stream) {
    HRESULT     hr       = E_FAIL;
    HPTPROVIDER provider = nullptr;

    if (!_PTConvertDevModeToPrintTicket()) return hr;
    if (!_PTOpenProvider()) return hr;
    if (!_PTCloseProvider()) return hr;

    // Allocate stream for print ticket.
    hr = CreateStreamOnHGlobal(nullptr, TRUE, print_ticket_stream.target());

    if (SUCCEEDED(hr)) {
      hr = _PTOpenProvider()(device_name.c_str(), 1, &provider);
    }

    // Get PrintTicket from DEVMODE.
    if (SUCCEEDED(hr)) {
      hr = _PTConvertDevModeToPrintTicket()(
          provider, ULONG(this->device_mode.length()),
          (PDEVMODE)device_mode.begin(), kPTJobScope, print_ticket_stream);
    }

    if (FAILED(hr)) {
      // Release printTicketStream if fails.
      print_ticket_stream = nullptr;
    }

    if (provider) { _PTCloseProvider()(provider); }

    return hr;
  }

  bool create_d2d_device(com::asset<ID2D1Device> &d2d1_device);

  bool d2d_print_target::print(
      const ustring &                                       doc_name,
      function<bool(gool::graphics *page_gfx, int page_no)> renderer) {
#if !defined(WIC_SUPPORT) || !defined(USE_D2D_PLUS)
    return false;
#else
    application *papp = static_cast<application *>(gool::app());
    if (!papp || !papp->d2_1_factory()) return false;

    // Printing-specific resources.
    com::asset<IStream>                     job_print_ticket_stream;
    com::asset<ID2D1PrintControl>           print_control;
    com::asset<IPrintDocumentPackageTarget> document_target;
    // com::asset<D2DPrintJobChecker> print_job_checker;

    // const DEVMODE* dev_mode = (const DEVMODE*)device_mode.cbegin();

    HRESULT hr;

    // Convert DEVMODE to a job print ticket stream.
    hr = get_print_ticket_from_devmode(job_print_ticket_stream);

    // Create a factory for document print job.
    com::asset<IPrintDocumentPackageTargetFactory> document_target_factory;
    if (SUCCEEDED(hr)) {
      hr = document_target_factory.CoCreateInstance(
          __uuidof(PrintDocumentPackageTargetFactory), CLSCTX_INPROC_SERVER);
    }

    if (SUCCEEDED(hr)) {
      hr = document_target_factory->CreateDocumentPackageTargetForPrintJob(
          device_name, // printer name
          doc_name,    // job name
          nullptr,     // job output stream; when nullptr, send to printer
          job_print_ticket_stream, // job print ticket
          document_target.target() // result IPrintDocumentPackageTarget object
      );
    }

    com::asset<ID2D1Device> d2d1_device;

    if (!create_d2d_device(d2d1_device)) return false;

    // Create a new print control linked to the package target.
    if (SUCCEEDED(hr)) {
      hr = d2d1_device->CreatePrintControl(papp->wic_factory(), document_target,
                                           nullptr, print_control.target());
    }

    com::asset<ID2D1DeviceContext> d2d_context_for_print;
    if (SUCCEEDED(hr)) {
      // Create a D2D Device Context dedicated for the print job.
      hr = d2d1_device->CreateDeviceContext(D2D1_DEVICE_CONTEXT_OPTIONS_NONE,
                                            d2d_context_for_print.target());
    }

    handle<dx_surface_graphics> dx_gfx =
        dx_surface_graphics::create(d2d_context_for_print);

#if TRUE
    sizef page_size_dips = sizef(page_device_rect.size()) / sizef(device_dpi) *
                           sizef(96.0f, 96.0f);
#else
    // Convert 1/10 of a millimeter DEVMODE unit to 1/96 of inch D2D unit
    sizef page_size_dips;
    page_size_dips.x = page_paper_size.x / 254.0f * 96.0f;
    page_size_dips.y = page_paper_size.y / 254.0f * 96.0f;
#endif

    if (SUCCEEDED(hr)) {
      sizef scale(page_size_dips.x / this->page_device_size.x,
                  page_size_dips.y / this->page_device_size.y);

      for (int page_index = 1;; page_index++) {
        com::asset<ID2D1CommandList> command_list;

        hr = d2d_context_for_print->CreateCommandList(command_list.target());

        bool has_more_pages = false;

        // Create, draw, and add a Direct2D Command List for each page.
        if (SUCCEEDED(hr)) {
          // d2d_context_for_print->SetDpi(float(device_dpi.x),
          // float(device_dpi.y));
          d2d_context_for_print->SetTarget(command_list);
          d2d_context_for_print->BeginDraw();
          {
            gool::state _(dx_gfx);
            dx_gfx->scale(scale);
            has_more_pages = renderer(dx_gfx, page_index);
          }
          d2d_context_for_print->EndDraw();

          command_list->Close();
        } else
          break;

        if (SUCCEEDED(hr)) {
          hr = print_control->AddPage(
              command_list, D2D1::SizeF(page_size_dips.x, page_size_dips.y),
              nullptr);
        } else
          break;

        if (!has_more_pages) break;
      }

      // Send the job to the printing subsystem and discard
      // printing-specific resources.
      HRESULT hr_final = print_control->Close();

      if (SUCCEEDED(hr)) { hr = hr_final; }

      return SUCCEEDED(hr);
    }
    return true;
#endif
  }

  handle<gool::print_target> application::create_print_target() {
    return handle<gool::print_target>(new d2d_print_target());
  }

} // namespace d2d