#ifndef __d2d_objects_h__
#define __d2d_objects_h__

#include <d2d1.h>
#include <d2d1helper.h>
#include <dwrite.h>
#include <wincodec.h>
#include <dcomp.h>
#include <dxgi1_3.h>

#include "tool/tool.h"
#include "gool/gool.h"
#include "d2d-primitives.h"

namespace d2d {
  using namespace tool;
  using namespace gool;

  template <class RTS> struct SOLID_BRUSHes {
    ID2D1SolidColorBrush *get_solid_brush(const gool::argb &k) {
      bool                         created = false;
      asset<ID2D1SolidColorBrush> &pa      = solid_brushes.get_ref(k, created);
      HRESULT                      hr      = created ? static_cast<RTS *>(this)
                                 ->render_target()
                                 ->CreateSolidColorBrush(g2f(k), pa.target())
                           : S_OK;
      assert(SUCCEEDED(hr));
      return pa;
    }
    hash_table<gool::argb, com::asset<ID2D1SolidColorBrush>> solid_brushes;
  };

} // namespace d2d

#endif