#include "d2d-primitives.h"

#pragma once

// all the stuff here is about emulation of single GDI::AddFontMemResourceEx
// call.
// :((((

namespace d2d {

  struct custom_font_data : resource {
    // d2d::asset<IDWriteFontCollection> collection;
    tool::array<byte> data;
  };

  // Maps exceptions to equivalent HRESULTs,
  inline HRESULT ExceptionToHResult() throw() {
    try {
      throw; // Rethrow previous exception.
    } catch (std::bad_alloc &) { return E_OUTOFMEMORY; } catch (...) {
      return E_FAIL;
    }
  }

  class ResourceFontContext;

  class ResourceFontCollectionLoader : public IDWriteFontCollectionLoader {
  public:
    ResourceFontCollectionLoader(ResourceFontContext *c)
        : refCount_(0), ctx(c) {}

    // IUnknown methods
    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid,
                                                     void **ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef();
    virtual ULONG STDMETHODCALLTYPE Release();

    // IDWriteFontCollectionLoader methods
    virtual HRESULT STDMETHODCALLTYPE CreateEnumeratorFromKey(
        IDWriteFactory *factory,
        void const *    collectionKey, // [collectionKeySize] in bytes
        UINT32          collectionKeySize,
        OUT IDWriteFontFileEnumerator **fontFileEnumerator);

  private:
    ULONG refCount_;

    ResourceFontContext *ctx;

    // static IDWriteFontCollectionLoader* instance_;
  };

  // ResourceFontFileEnumerator
  //
  //      Implements the IDWriteFontFileEnumerator interface for a collection
  //      of fonts embedded in the application as resources. The font collection
  //      key is an array of resource IDs.
  //
  class ResourceFontFileEnumerator : public IDWriteFontFileEnumerator {
  public:
    ResourceFontFileEnumerator(ResourceFontContext *c);

    HRESULT Initialize(tool::chars name);

    ~ResourceFontFileEnumerator() {}

    // IUnknown methods
    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid,
                                                     void **ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef();
    virtual ULONG STDMETHODCALLTYPE Release();

    // IDWriteFontFileEnumerator methods
    virtual HRESULT STDMETHODCALLTYPE MoveNext(OUT BOOL *hasCurrentFile);
    virtual HRESULT                   STDMETHODCALLTYPE
                                      GetCurrentFontFile(OUT IDWriteFontFile **fontFile);

  private:
    ULONG refCount_;

    ResourceFontContext *       ctx;
    d2d::asset<IDWriteFontFile> currentFile;
    tool::chars                 name;
    // tool::bytes data;
    // std::vector<UINT> resourceIDs_;
    // size_t nextIndex_;
  };

  // ResourceFontFileLoader
  //
  //      Implements the IDWriteFontFileLoader interface for fonts
  //      embedded as a resources in the application. The font file key is
  //      a UINT resource identifier.
  //
  class ResourceFontFileLoader : public IDWriteFontFileLoader {
  public:
    ResourceFontFileLoader(ResourceFontContext *c) : refCount_(0), ctx(c) {}

    // IUnknown methods
    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid,
                                                     void **ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef();
    virtual ULONG STDMETHODCALLTYPE Release();

    // IDWriteFontFileLoader methods
    virtual HRESULT STDMETHODCALLTYPE CreateStreamFromKey(
        void const *fontFileReferenceKey, // [fontFileReferenceKeySize] in bytes
        UINT32      fontFileReferenceKeySize,
        OUT IDWriteFontFileStream **fontFileStream);

    // Gets the singleton loader instance.
    // static IDWriteFontFileLoader* GetLoader()
    //{
    //    return instance_;
    //}
    //
    // static bool IsLoaderInitialized()
    //{
    //    return instance_ != NULL;
    //}

  private:
    ULONG                refCount_;
    ResourceFontContext *ctx;

    // static IDWriteFontFileLoader* instance_;
  };

  // ResourceFontFileStream
  //
  //      Implements the IDWriteFontFileStream interface in terms of a font
  //      embedded as a resource in the application. The font file key is
  //      a UINT resource identifier.
  //
  class ResourceFontFileStream : public IDWriteFontFileStream {
    ResourceFontFileStream(const ResourceFontFileStream &);
    ResourceFontFileStream &operator=(const ResourceFontFileStream &);

  public:
    explicit ResourceFontFileStream(tool::array<byte> &data);

    // IUnknown methods
    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid,
                                                     void **ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef();
    virtual ULONG STDMETHODCALLTYPE Release();

    // IDWriteFontFileStream methods
    virtual HRESULT STDMETHODCALLTYPE ReadFileFragment(
        void const **fragmentStart, // [fragmentSize] in bytes
        UINT64 fileOffset, UINT64 fragmentSize, OUT void **fragmentContext);

    virtual void STDMETHODCALLTYPE ReleaseFileFragment(void *fragmentContext);

    virtual HRESULT STDMETHODCALLTYPE GetFileSize(OUT UINT64 *fileSize);

    virtual HRESULT STDMETHODCALLTYPE
                    GetLastWriteTime(OUT UINT64 *lastWriteTime);

    bool IsInitialized() { return true; }

  private:
    ULONG              refCount_;
    tool::array<byte> &data;
  };

  class ResourceFontContext {
  public:
    ResourceFontContext();
    ~ResourceFontContext();

    HRESULT Initialize(IDWriteFactory *pf);
    void    Shutdown();

    HRESULT CreateFontCollection(uint id, OUT IDWriteFontCollection **result);

  private:
    // Not copyable or assignable.
    ResourceFontContext(ResourceFontContext const &);
    ResourceFontContext &operator=(ResourceFontContext const &);

    HRESULT InitializeInternal(IDWriteFactory *pf);

    // Error code from Initialize().
    HRESULT hr_;

  public:
    d2d::asset<IDWriteFactory>               factory;
    array<tool::handle<custom_font_data>>    custom_fonts_data;
    d2d::asset<ResourceFontCollectionLoader> collection_loader;
    d2d::asset<ResourceFontFileLoader>       file_loader;
  };

} // namespace d2d