#ifndef __config_h__
#define __config_h__

#include "version.h"

// values of the DEVICE macro define (defined in premake scripts)
#define DESKTOP 1
#define HANDHELD 2
#define IOT 3

#define HAS_MOUSE
#define PNG_SUPPORT
#define GIF_SUPPORT
#define SVG_SUPPORT // SVG can be used as <img src="drawing.svg"> and
                    // background-image:url(drawing.svg)
#define ZIP_SUPPORT // markup can be loaded from .zip files

#define HTTP_SUPPORT // use built-in HTTP client for external resources, if
                     // #undef'ed then no external requests are fulfilled by
                     // default

#define CSS_PX_LOGICAL_BY_DEFAULT true
                     // true - px is a dip - logical pixels as in browsers
                     // false - px is a ppx - physical screen pixel as it is used to be in Sciter

#define USE_OVERSCROLL true // kinetic scroll - allow overscroll with go back animation, MacOS style.
                            // 'false' if not
//#define USE_INCREMENTAL_INIT - not complete !

#ifndef SUPPORT_WINDOWSXP
  #define USE_THREAD_LOCAL   // use of thread_local - has problems on XP
                             // if you #undef this please ensure that only one GUI
                             // thread with sciter windows is used in your process.
#endif

// define these
//#define HTTP_USER_AGENT "foo.bar"
//#define HTTP_CONNECTION_TIMEOUT 10000

//#define DISALLOW_FILE_ICON_TO_READ_FS // define to disable FS reads by
//behavior:file-icon

#define ASYNC_MAX_TIMEOUT 20000 // 20 seconds per call by default

#if defined(_WIN32) || defined(_WIN64)

#ifndef WINVER
#define WINVER 0x0A00       //_WIN32_WINNT_WIN10
#define _WIN32_WINNT 0x0A00 //_WIN32_WINNT_WIN10
#endif

#define ACCESSIBLE
#define USE_UIAUTOMATION 

#define USE_D2D
#ifdef _DEBUG
#define USE_D2D_DEBUG // debugLevel = D2D1_DEBUG_LEVEL_INFORMATION; see
                      // https://msdn.microsoft.com/en-us/library/windows/desktop/ee794277(v=vs.85).aspx#enabling_the_debug_layer
#endif
#define USE_D2D_PLUS // with this the engine will try to use Direct2D v.1.1 and above if it
                     // is available

#define USE_ACRYLIC_BLURBEHIND // Acrylic is more blurry

#if !defined(WINDOWLESS)
  #define WIC_SUPPORT  // WICImagingFactory, JPG_SUPPORT and WIC_SUPPORT are mutually exclusive
  #ifndef SCITERJS
    #define THEMES_SUPPORT //
  #endif
  #define SYSTEM_DD_SUPPORT // shell drag-n-drop
#endif

#if defined(SKIA_BACKEND)
#define USE_SKIA
#define USE_ICU4C
#else
#define USE_GDI
#endif

//#define USE_DX_ON_LAYERED // use of DirectX on layered windows (this feature
//may have problems on some video cards).
//                          // if USE_DX_ON_LAYERED is not defined
//                          implementation uses ID2D1DCRenderTarget +
//                          UpdateLayeredWindow.
//                          // I'd suggest to use SciterSetOption(NULL,
//                          SCITER_SET_GFX_LAYER, GFX_LAYER_WARP ) if main
//                          window is layered.

//#define USE_HARDWARE_BLACKLIST // Windows only, if defined then the engine
//will try to use gpu-blacklist.json black list to disable H/W renderer

#define JPG_SUPPORT

#define WEBP_SUPPORT

#define USE_VIDEO

#ifndef WINDOWLESS
  #define USE_DS_VIDEO // undef it if you don't want default DirectShow video
                       // playback
#endif

#define HAS_APNG

#ifdef _DEBUG
#define DEBUG_DRAW_PIPELINE // Direct2D drawing failure reports.
#endif

#define NATIVE_WINDOWS_BACKEND

#if defined(WINDOWLESS)
#define HWINDOW LPVOID
#include "engine/lite/lite-virtual-keys.h"
#else
#define HWINDOW HWND
#include "win/win-virtual-keys.h"
#endif

#if defined(USE_D2D_PLUS) && defined(USE_ACRYLIC_BLURBEHIND)
#define USE_DIRECT_COMP // enable direct composition / acrylic support
#endif

#define USE_ANIMATED_SCROLL

#define CAN_WORK_AS_TABLET

#elif defined(__APPLE__)

  #define JPG_SUPPORT
  #define WEBP_SUPPORT

  #ifdef WINDOWLESS
    #define HWINDOW void *
  #else
    #define HWINDOW void *
    #define USE_CGX  // core graphics & friends
    #define CORETEXT_LAYOUT
    #define THEMES_SUPPORT
  #endif

  #define USE_SKIA // yet Skia

  #define EXTERNAL_LOADER // exclude http loader for while
  #define NATIVE_OSX_BACKEND
  #define SCROLL_INDICATOR_ONLY // no scrollbars but indicator

  #define USE_VIDEO
  #define HAS_APNG

  #define USE_ANIMATED_SCROLL

  //#define USE_LAYERS // uncomment this if layers are needed on MacOS

  #include "osx/osx-virtual-keys.h"

#elif defined(__linux__)

#ifdef WINDOWLESS
#define HWINDOW void *
#ifndef SKIA_BACKEND
#define SKIA_BACKEND
#endif
#define USE_SKIA // yet Skia
#define CAN_WORK_AS_TABLET
#include "engine/lite/lite-virtual-keys.h"
#else
#include <gtk/gtk.h>
#define PANGO_ENABLE_ENGINE
#define USE_CAIRO // core graphics & friends
#define NATIVE_GTK_BACKEND
#define HWINDOW GtkWidget*
#include "gtk/gtk-virtual-keys.h"
#endif

//#ifndef _DEBUG
//#define assert(n)
//#endif

#define JPG_SUPPORT
#define WEBP_SUPPORT
#define USE_VIDEO

#define EXTERNAL_LOADER       // exclude http loader for while
#define SCROLL_INDICATOR_ONLY // no scrollbars but indicator
//#define THEMES_SUPPORT

#define USE_ANIMATED_SCROLL

#define PNG_SUPPORT
#define HAS_APNG

#else
#error "Unsupported platform yet"
#endif

#if defined(SCITER) || defined(SCITERJS)
#ifndef WINDOWLESS
#define SPELL_CHECK_SUPPORT // on by default
#endif
#define TLS_SUPPORT        // websockets, wss support, optional
#define SCREENSHOT_SUPPORT // potentially unsafe (privacy),
                           // view.screenBox(n,#snapshot) : Image, optional
#endif

#define NETWORK_SUPPORT    // network support: sockets, etc. Used to communicate
                           // with inspector
#define WEBSOCKETS_SUPPORT // websockets support, optional

#define AUDIO_SUPPORT      // view.audio(url)

#define PROCESS_SUPPORT // System.Process - run arbitrary executables, optional

//#define JSON_ISOLATION 3  // 1 - sciter::value does not contain proxies of
//objects and arrays
// 2 - sciter::value does not contain proxies of objects, arrays and functions
// 3 - sciter::value does not contain proxies of objects, arrays, functions and
// native functions - almost pure JSON

#define TISCRIPT_HEAP_SIZE (2 * 1024 * 1024)   // initial script heap size (one half)
#define TISCRIPT_EXPAND_SIZE (4 * 1024 * 1024) // granularity of heap expansion. 0 means script heap is not
                                               // allowed to be expanded.
#define TISCRIPT_STACK_SIZE (64 * 1024)
#define TISCRIPT_MAX_ASYNCS (64) // max number of simultaneously running async functions

#define TISCRIPT_DEBUGGER
#define TISCRIPT_USE_PERSISTENCE

#define MAX_HTTP_DATA_LENGTH (128) // max length of single HTTP message, megabytes

//#define SCRIPT_DISABLE_FEATURE_FILE_IO
//#define SCRIPT_DISABLE_FEATURE_SOCKET_IO
//#define SCRIPT_DISABLE_FEATURE_EVAL
//#define SCRIPT_DISABLE_FEATURE_SYSINFO

//#define TISCRIPT_USE_VIRTUAL_MEMORY
//#define TISCRIPT_VIRTUAL_MEMORY_SIZE (512 * 1024 * 1024) // up to 512MB

#if defined(SCRIPT_DISABLE_FEATURE_FILE_IO)
  #define FEATURE_FILE_IO 0x00000000
#else
  #define FEATURE_FILE_IO 0x00000001
#endif

#if defined(SCRIPT_DISABLE_FEATURE_SOCKET_IO)
  #define FEATURE_SOCKET_IO 0x00000000
#else
  #define FEATURE_SOCKET_IO 0x00000002
#endif

#if defined(SCRIPT_DISABLE_FEATURE_EVAL)
  #define FEATURE_EVAL 0x00000000
#else
  #define FEATURE_EVAL 0x00000004
#endif

#if defined(SCRIPT_DISABLE_FEATURE_SYSINFO)
  #define FEATURE_SYSINFO 0x00000000
#else
  #define FEATURE_SYSINFO 0x00000008
#endif

#if defined(USE_D2D_PLUS) && !defined(USE_D2D)
  #define USE_D2D
#endif

#ifdef USE_LOTTIE
  //#define LOTTIE_CACHE_SUPPORT 1
  #define LOTTIE_THREAD_SUPPORT 1
#endif

#endif
