#include "api-defs.h"


extern tool::bytes get_resource(const wchar *path);

#define EXEC_START(p) pview->exec([&r,pview,p]() -> bool {
#define EXEC_START_2(p1, p2) pview->exec([&r,pview,p1,p2]() -> bool {
#define EXEC_START_3(p1, p2, p3) pview->exec([&r,pview,p1,p2,p3]() -> bool {
#define EXEC_START_4(p1, p2, p3, p4) pview->exec([&r,pview,p1,p2,p3,p4]() -> bool {
#define EXEC_START_5(p1, p2, p3, p4, p5) pview->exec([&r,pview,p1,p2,p3,p4,p5]() -> bool {
#define EXEC_END                                                               \
  return true;                                                                 \
  });

EXPORT SBOOL SCAPI SciterLoadFile_api(HWINDOW hWndSciter, LPCWSTR filename) {
  get_pview(hWndSciter);
  if (!pview) return FALSE;

  tool::ustring ufilename = filename;
  tool::string  url;

  if (ufilename().starts_with(WCHARS("../"))) {
    ufilename = WCHARS("./") + ufilename;
  }

  if (ufilename().starts_with(WCHARS("./"))) {
    byte buffer[1024];
    size_t sz = items_in(buffer);
    if (uv_cwd((char*)buffer, &sz) == 0) {
      tool::ustring t = u8::cvt(bytes(buffer, sz));
      t += ufilename(1);
      url = tool::url::path_to_file_url(t);
    }
  }

#ifdef WINDOWS
  else if (ufilename.like(W("*://*")) || (ufilename.like(W("*:*")) && !ufilename().contains('\\')))
#else
  if (ufilename.like(W("*://*")) || ufilename.like(W("*:*")))
#endif
    url = tool::url::escape(ufilename);
  else    
    url = tool::url::path_to_file_url(ufilename);

  SBOOL r = FALSE;
  EXEC_START(url)
  r = pview->load_url(url);
  EXEC_END
  return r;
}

EXPORT SBOOL SCAPI SciterLoadHtml_api(HWINDOW hWndSciter, LPCBYTE html,
                                     UINT htmlSize, LPCWSTR baseUrl) {
  get_pview(hWndSciter);
  if (!pview) return FALSE;

  SBOOL r = TRUE;
  EXEC_START_3(html, htmlSize, baseUrl)

  string base(baseUrl);

  handle<html::request> hrq = new html::request(base, html::DATA_HTML);
  hrq->dst_view             = pview.ptr();
  hrq->rq_type              = html::RQ_PUSH;
  hrq->data                 = bytes(html, htmlSize);
  pview->on_data_loaded(hrq);

  r = pview->load(hrq);

  EXEC_END
  return r;
}

EXPORT SBOOL SCAPI SciterSetMediaType_api(HWINDOW hwnd, LPCWSTR mediaType) {
  get_pview(hwnd);
  if (!pview || !mediaType) return FALSE;

  SBOOL r = TRUE;
  EXEC_START(mediaType)
  pview->set_media_vars(chars_of(mediaType),false);
  EXEC_END
  return r;
}

EXPORT SBOOL SCAPI SciterSetMediaVars_api(HWINDOW             hwnd,
                                         const SCITER_VALUE *mediaVars) {
  get_pview(hwnd);
  if (!mediaVars) return FALSE;

  SBOOL r = TRUE;
  if (pview) {
    EXEC_START(mediaVars)
      pview->set_media_vars(*((const tool::value *)mediaVars), false, true);
    EXEC_END
  }
  else
    html::view::set_default_media_vars(*((const tool::value *)mediaVars), false);
  
  return r;
}

EXPORT SBOOL SCAPI SciterSetHomeURL_api(HWINDOW hwnd, LPCWSTR baseURL) {
  get_pview(hwnd);
  if (!pview) return FALSE;
  pview->home_url = string(baseURL);
  return TRUE;
}

//

EXPORT SBOOL SCAPI SciterDataReady_api(HWINDOW hwnd, LPCWSTR uri, LPCBYTE data,
                                      UINT dataLength) {
  get_pview(hwnd);
  if (!pview) return FALSE;

  if (data && dataLength && pview->current_rq) {
    pview->current_rq->data = bytes(data, dataLength);
    return TRUE;
  }
  return FALSE;
}

SciterResourceType data_type(const string &url) {
  tool::chars rurl = tool::chars_of(url);
  if (tool::is_like(rurl, "*.png") || tool::is_like(rurl, "*.gif") ||
      tool::is_like(rurl, "*.jpg") || tool::is_like(rurl, "*.jpeg"))
    return RT_DATA_IMAGE;
  if (tool::is_like(rurl, "*.css")) return RT_DATA_STYLE;
  if (tool::is_like(rurl, "*.tis") || tool::is_like(rurl, "*.js"))
    return RT_DATA_SCRIPT;

  /*tool::chars rmimetype = tool::make_chars(mimetype);
  if( like(rmimetype, "*.html"))
    return RT_DATA_HTML;
  if( like(rmimetype, "*script"))
    return RT_DATA_SCRIPT;
  if( like(rmimetype, "*css"))
    return RT_DATA_STYLE;
  */
  return RT_DATA_HTML;
}

EXPORT SBOOL SCAPI SciterDataReadyAsync_api(HWINDOW hwnd, LPCWSTR uri,
                                           LPCBYTE data, UINT dataLength,
                                           LPVOID requestId) {
  get_pview(hwnd);
  if (!pview) return FALSE;

  if (requestId && reinterpret_cast<html::pump::request *>(requestId)->is_valid()) {
    tool::handle<html::pump::request> prq = reinterpret_cast<html::pump::request *>(requestId);
    prq->data.push(data, dataLength);
    prq->success_flag = true;
    pview->async([prq, pview]() -> bool {
      pview->dispatch_request(prq);
      return true;
    });
    prq->release();
    return TRUE;
  } else {
    if (data && dataLength) {
      tool::handle<html::pump::request> hrq = new html::pump::request(uri, (html::RESOURCE_DATA_TYPE)data_type(uri));
      hrq->success_flag = true;
      hrq->data.push(data, dataLength);
      pview->async([hrq, pview]() -> bool {
        pview->dispatch_request(hrq);
        return true;
      });
      return TRUE;
    }
  }

  /*
  if(data && dataLength)
  {
    if(requestId)
    {
      tool::handle<html::pump::request> prq = (html::pump::request*)requestId;
      prq->data.push(data, dataLength);
      pview->data_arrived(prq);
      prq->release();
      return TRUE;
    }
    else
    {
      tool::handle<html::pump::request> hrq = new html::pump::request( uri,
  (html::RESOURCE_DATA_TYPE) data_type(uri) ); hrq->data.push(data, dataLength);
      pview->data_arrived(hrq);
    }
    return TRUE;
  }*/
  return FALSE;
}

SCDOM_RESULT SCAPI SciterWindowAttachEventHandler_api(HWINDOW           hwnd,
                                                      ElementEventProc *pep,
                                                      LPVOID            tag,
                                                      UINT subscriptions) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  if (!pep || !subscriptions) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(pep, tag, subscriptions)

  ext_ctl *nb = new ext_ctl(pep, tag, subscriptions);
  pview->attach_behavior(nb);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterWindowDetachEventHandler_api(HWINDOW           hwnd,
                                                      ElementEventProc *pep,
                                                      LPVOID            tag) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  if (!pep) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(pep, tag)

  html::ctl *t     = pview->ground_behavior;
  html::ctl *found = 0;
  for (; t; t = t->next)
    if (t->is_ext()) {
      ext_ctl *ec = static_cast<ext_ctl *>(t);
      if (ec->pep == pep && ec->tag == tag) {
        found = ec;
        break;
      }
    }

  if (found) pview->detach_behavior(found);

  EXEC_END
  return r;
}

EXPORT SBOOL SCAPI SciterSetMasterCSS_api(LPCBYTE pb, UINT numBytes) {
  if (!pb || !numBytes) return FALSE;

  html::application::set_stock_styles(tool::chars((const char *)pb, numBytes),
                                      false);
  return TRUE;
}

EXPORT SBOOL SCAPI SciterAppendMasterCSS_api(LPCBYTE pb, UINT numBytes) {
  if (!pb || !numBytes) return FALSE;

  html::application::set_stock_styles(tool::chars((const char *)pb, numBytes),
                                      true);
  return TRUE;
}

EXPORT SBOOL SCAPI SciterSetCSS_api(HWINDOW hWndSciter, LPCBYTE utf8,
                                   UINT numBytes, LPCWSTR baseUrl,
                                   LPCWSTR mediaType) {
  if (!utf8 || !numBytes) return FALSE;
  get_pview(hWndSciter);
  if (!pview) return FALSE;

  SBOOL r = TRUE;
  EXEC_START_4(utf8, numBytes, baseUrl, mediaType)

  if (mediaType) pview->set_media_vars(chars_of(mediaType), false, false);
  ustring wcss = u8::cvt(chars((const char *)utf8, numBytes));
  pview->doc()->reset_styles(wcss, string(baseUrl));
  pview->doc()->drop_layout_tree(pview,true);
  pview->doc()->measure(*pview, pview->dimension());
  pview->refresh();

  EXEC_END
  return r;
}

EXPORT UINT SCAPI SciterGetMinWidth_api(HWINDOW hWndSciter) {
  get_pview(hWndSciter);
  if (!pview) return 0;

  handle<html::document> pd = pview->doc();
  if (!pd) return 0;

  UINT r = 0;
  EXEC_START(pd)

  pd->resolve_styles(*pview);
  pview->commit_update();
  r = (UINT)pd->min_content_width(*pview);

  EXEC_END
  return r;
}

EXPORT UINT SCAPI SciterGetMinHeight_api(HWINDOW hWndSciter, UINT width) {
  get_pview(hWndSciter);
  if (!pview) return 0;

  handle<html::document> pd = pview->doc();
  if (!pd) return 0;

  UINT r = 0;
  EXEC_START_2(pd, width)

  if (pd->dim().x != int(width)) pd->set_width(*pview, width);
  pview->commit_update();
  r = (UINT)pd->min_content_height(*pview);

  EXEC_END
  return r;
}

EXPORT SBOOL SCAPI SciterGraphicsCaps_api(LPUINT pcaps) {
  if (!pcaps) return FALSE;
  gool::GRAPHICS_CAPS caps = gool::app()->graphics_caps();
  *pcaps                   = caps;
  return TRUE;
}

EXPORT SBOOL SCAPI SciterCall_api(HWINDOW hwnd, LPCSTR functionName, UINT argc,
                                 const SCITER_VALUE *argv,
                                 SCITER_VALUE * retval) {
  get_pview(hwnd);
  if (!pview) return FALSE;

#if defined(SCITER)  
  tool::ustring script = functionName;
#elif defined(SCITERJS)  
  tool::string script = functionName;
#endif

  handle<html::document> root = pview->doc();
  if (!root) return FALSE;

  SBOOL r = FALSE;
  EXEC_START_5(root, script, argc, argv, retval)

#if defined(SCITER)  
    tis::xview *pxv = pview;
  tis::pvalue method(pxv->vm);

  try {
    tis::auto_scope as(pxv->vm, root->ns);
    method = tis::CsEvalString(tis::CsCurrentScope(pxv->vm), root->ns, script,
      script.length());
    if (tis::CsMethodP(method)) {
      tool::value rv = tis::call_by_tool(method, root->ns, argc, (const tool::value *)argv);
      if (retval) *((tool::value *)retval) = rv;
      r = TRUE;
    }
  }
  catch (tis::script_exception &e) {
    if (retval)
      *((tool::value *)retval) = tis::value_to_value(pxv->vm, pxv->vm->val);
    e;
    tis::CsDisplay(pxv->vm, pxv->vm->val, pxv->vm->standardError);
  }
#elif defined(SCITERJS) 
    qjs::xview *pxv = (qjs::xview *)pview;
    r = qjs::call(pxv,script(), argc, (const tool::value *)argv, (tool::value *)retval);
#endif

  EXEC_END
  return r;
}

/*EXPORT SBOOL SCAPI Sciter_v2V_api(HVM vm, tiscript_value tisv,
                                 SCITER_VALUE *jsonv, SBOOL isolate) {
  if (!jsonv || !vm) return FALSE;
  tis::VM *   pvm = (tis::VM *)vm;
  tool::value rv  = tis::value_to_value(pvm, tisv);
  if (isolate) rv.isolate();
  *((tool::value *)jsonv) = rv;
  return TRUE;
}

EXPORT SBOOL SCAPI Sciter_V2v_api(HVM vm, const SCITER_VALUE *jsonv,
                                 tiscript_value *tisv) {
  if (!jsonv || !vm || !tisv) return FALSE;
  tis::VM *  pvm = (tis::VM *)vm;
  tis::value rv  = tis::value_to_value(pvm, *((const tool::value *)jsonv));
  *tisv          = rv;
  return TRUE;
}*/

EXPORT SBOOL SCAPI SciterEval_api(HWINDOW hwnd, LPCWSTR script,
                                 UINT scriptLength, SCITER_VALUE *pretval) {
  get_pview(hwnd);
  if (!pview) return FALSE;

  handle<html::document> root = pview->doc();
  if (!root) return FALSE;

#if defined(SCITER)
  SBOOL r = FALSE;
  EXEC_START_4(root, script, scriptLength, pretval)

  tis::xview *pxv = pview;

  try {
    tis::auto_scope as(pxv->vm, root->ns);
    tis::value      val       = tis::CsEvalString(tis::CsCurrentScope(pxv->vm),
                                       tis::element_object(pxv->vm, root),
                                       script, scriptLength);
    *((tool::value *)pretval) = tis::value_to_value(pxv->vm, val);
    r                         = TRUE;
  } catch (tis::script_exception &) {
    *((tool::value *)pretval) = tis::value_to_value(pxv->vm, pxv->vm->val);
    tis::CsDisplay(pxv->vm, pxv->vm->val, pxv->vm->standardError);
  }
  EXEC_END
#elif defined(SCITERJS) 
  SBOOL r = FALSE;
  string s = u8::cvt(wchars(script, scriptLength));
  EXEC_START_2(s, pretval)
    qjs::xview *pxv = (qjs::xview *)pview;
    r = qjs::eval(pxv,s(), (tool::value *)pretval);
  EXEC_END
#endif
  return r;
}

/*EXPORT HVM SCAPI SciterGetVM_api(HWINDOW hwnd) {
  get_pview(hwnd);
  if (!pview) return 0;
  tis::xview *pxv = pview;
  return HVM(pxv->vm.ptr());
}*/

SBOOL SCAPI SciterSetGlobalAsset_api(som_asset_t* pass)
{
  if (!pass)
    return FALSE;
#if defined(SCITER)
  if (auto psp = sciter::om::asset_get_passport(pass)) {
    tis::xvm * pvm = (tis::xvm *)tis::xvm::get_current();
    if (!pvm) pvm = tis::xvm::create();
    tis::value tval = tis::CsMakeAssetObject(pvm, pass);
    tis::CsSetGlobalValue(CsGlobalScope(pvm), psp->name, tval);
    return TRUE;
  }
#elif defined(SCITERJS)
  if (auto psp = sciter::om::asset_get_passport(pass)) {
    qjs::hruntime& hr = qjs::hruntime::current();
    hr.globals[psp->name] = value::wrap_asset(pass);
    return TRUE;
  }
#endif
  return FALSE;
}

SBOOL SCAPI SciterReleaseGlobalAsset_api(som_asset_t* pass)
{
  if (!pass)
    return FALSE;
#if defined(SCITER)
  /*if (auto psp = sciter::om::asset_get_passport(pass)) {
    tis::xvm * pvm = (tis::xvm *)tis::xvm::get_current();
    if (!pvm) pvm = tis::xvm::create();
    tis::value tval = tis::CsMakeAssetObject(pvm, pass);
    tis::CsSetGlobalValue(CsGlobalScope(pvm), psp->name, tval);
    return TRUE;
  }*/
#elif defined(SCITERJS)
  if (auto psp = sciter::om::asset_get_passport(pass)) {
    qjs::hruntime& hr = qjs::hruntime::current();
    return hr.globals.remove(psp->name);
  }
#endif
  return FALSE;
}


UINT SCAPI SciterSetVariable_api(HWINDOW hwndOrNull, LPCWSTR path, const VALUE* pval_to_set)
{
  return FALSE;
}
UINT SCAPI SciterGetVariable_api(HWINDOW hwndOrNull, LPCWSTR path, VALUE* pval_to_get)
{
  return FALSE;
}

#define VAL(pv) ((tool::value*)(pv))

UINT   SCAPI SciterElementUnwrap_api(const VALUE* pval, HELEMENT* ppElement)
{
  if(!pval || !ppElement)
    return SCDOM_INVALID_PARAMETER;
  *ppElement = VAL(pval)->get_resource<html::element>();
  return *ppElement ? SCDOM_OK : SCDOM_OPERATION_FAILED;
}
UINT   SCAPI SciterElementWrap_api(VALUE* pval, HELEMENT pElement)
{
  if (!pval || !pElement)
    return SCDOM_INVALID_PARAMETER;
  VAL(pval)->set_resource(pElement);
  return SCDOM_OK;
}
UINT   SCAPI SciterNodeUnwrap_api(const VALUE* pval, HNODE* ppNode)
{
  if (!pval || !ppNode)
    return SCDOM_INVALID_PARAMETER;
  *ppNode = VAL(pval)->get_resource<html::node>();
  return *ppNode ? SCDOM_OK : SCDOM_OPERATION_FAILED;
}
UINT   SCAPI SciterNodeWrap_api(VALUE* pval, HNODE pNode)
{
  if (!pval || !pNode)
    return SCDOM_INVALID_PARAMETER;
  VAL(pval)->set_resource(pNode);
  return SCDOM_OK;
}


EXPORT SBOOL SCAPI SciterSetOption_api(HWINDOW hwnd, UINT option,
                                      UINT_PTR value) {
  switch (option) {
  case SCITER_SMOOTH_SCROLL: {
    get_pview(hwnd);
    if (!pview) return FALSE;
    // pview->use_smooth_scroll = value != FALSE;
    return TRUE;
  }
  case SCITER_SET_PX_AS_DIP:
    if (hwnd) {
      get_pview(hwnd);
      if (pview) {
        pview->treat_px_as_dip = !!value;
        return TRUE;
      }
    }
    else {
      gool::treat_px_as_dip = !!value;
      return TRUE;
    }
    return FALSE;

#ifdef WINDOWS
  case SCITER_CONNECTION_TIMEOUT:
    html::pump::connection_timeout = uint(value);
    return TRUE;
  case SCITER_HTTPS_ERROR:
    html::pump::https_error_action = uint(value);
    return TRUE;
#endif

    // case SCITER_FONT_SMOOTHING: gool::font_smoothing =
    // (gool::FONT_SMOOTHING)value; return TRUE;
  case SCITER_TRANSPARENT_WINDOW:
    if (hwnd) {
      get_pview(hwnd);
      if (!pview) return FALSE;

      SBOOL r = TRUE;
      EXEC_START(value)
        pview->set_transparency(value != FALSE);
      EXEC_END
        return r;
    }
    break;

  case SCITER_ALPHA_WINDOW:
    if (hwnd) {
      get_pview(hwnd);
      if (!pview) return FALSE;
      SBOOL r = TRUE;
      EXEC_START(value)
        pview->set_layered(value != FALSE);
      EXEC_END
        return r;
    }
    break;

  case SCITER_SET_GPU_BLACKLIST:
    //#ifdef WINDOWS
    //    return gool::set_gpu_black_list((LPCSTR)value);
    //#else
    return FALSE;
    //#endif
  case SCITER_SET_SCRIPT_RUNTIME_FEATURES:
  {
#if defined(SCITER)
    tis::VM *pvm = nullptr;
    if (hwnd) {
      get_pview(hwnd);
      if (!pview) return FALSE;
      pvm = pview->vm;
    }
    tis::CsSetFeatures(pvm, (uint)value);
#elif defined(SCITERJS)
#endif
    return TRUE;
  }

  case SCITER_SET_GFX_LAYER:
    gool::application::requested_gfx_layer = GRAPHICS_CAPS(value);
    return TRUE;

  case SCITER_SET_UX_THEMING:
#ifdef WINDOWS
    html::use_platform_theming = !value;
    return TRUE;
#else
    return TRUE;
#endif

  case SCITER_SET_DEBUG_MODE:
    if (hwnd) {
      get_pview(hwnd);
      if (!pview) return FALSE;
      pview->debug_mode(!!value);
      return TRUE;
    }
    else
      html::view::default_debug_mode = uint(value);

    return TRUE;
  case SCITER_SET_INIT_SCRIPT:
#if defined(SCITER)
    tis::xview::set_init_script((LPCSTR)value);
#elif defined(SCITERJS)
    qjs::xview::set_init_script((LPCSTR)value);
#endif
    return TRUE;

  case SCITER_SET_MAIN_WINDOW:
  {
    get_pview(hwnd);
    if (!pview) return FALSE;
    pview->is_main(!!value);
    return TRUE;
  }

  case SCITER_SET_MAX_HTTP_DATA_LENGTH:
    html::pump::max_http_data_length = uint(value);
    return TRUE;

  case SCITER_ENABLE_UIAUTOMATION:
#if defined(WINDOWS) && defined(USE_UIAUTOMATION) && !defined(WINDOWLESS)
    mswin::window::use_uiautomation = !!value;
    return TRUE;
#endif
    return FALSE;
  }
    
  return FALSE;
}

EXPORT VOID SCAPI SciterUpdateWindow_api(HWINDOW hwnd) {
  get_pview(hwnd);
  if (!pview) return;

  SBOOL r = TRUE;
  EXEC_START(hwnd)
  pview->to_update.update(pview);
  pview->update();
  r = TRUE;
  EXEC_END
}

EXPORT VOID SCAPI SciterGetPPI_api(HWINDOW hwnd, UINT *px, UINT *py) {
  get_pview(hwnd);
  gool::size sz;
  if (!pview)
    sz = gool::resolution_provider::desktop().pixels_per_inch();
  else {
    sz = pview->pixels_per_inch();
  }
  if (px && py) {
    *px = UINT(sz.x);
    *py = UINT(sz.y);
  }
}

/*EXPORT SBOOL SCAPI Sciter_v2V_api(tiscript_VM *vm, tiscript_value tisv,
                                 VALUE *jsonv, SBOOL isolate) {
  if (!jsonv || !vm) return FALSE;
  tis::VM *   pvm = (tis::VM *)vm;
  tool::value rv  = tis::value_to_value(pvm, tisv);
  if (isolate) rv.isolate();
  *((tool::value *)jsonv) = rv;
  return TRUE;
}

EXPORT SBOOL SCAPI Sciter_V2v_api(tiscript_VM *vm, const VALUE *jsonv,
                                 tiscript_value *tisv) {
  if (!jsonv || !vm || !tisv) return FALSE;
  tis::VM *  pvm = (tis::VM *)vm;
  tis::value rv  = tis::value_to_value(pvm, *((const tool::value *)jsonv));
  *tisv          = rv;
  return TRUE;
}*/

#if defined(SCITER)
  bool sciter_get_view_expando(tis::xview *pv, tool::value &pval);
#endif

EXPORT SBOOL SCAPI SciterGetViewExpando_api(HWINDOW hwnd, VALUE *pval) {
#if defined(SCITER)
  if (!pval) return FALSE;

  get_pview(hwnd);

  SBOOL r = TRUE;
  EXEC_START(pval)
  if (!sciter_get_view_expando(pview, *((tool::value *)pval))) {
    *(tool::value *)pval = tool::value();
    r                    = FALSE;
  }
  EXEC_END
  return r;
#else 
  return FALSE;
#endif
}

EXPORT HSARCHIVE SCAPI SciterOpenArchive_api(LPCBYTE archiveData,
                                             UINT    archiveDataLength) {
  tool::sar *psar = new tool::sar(tool::bytes(archiveData, archiveDataLength));
  if (!psar) return 0;
  if (psar->nitems() == 0) {
    delete psar;
    return 0;
  }
  return psar;
}
EXPORT SBOOL SCAPI SciterGetArchiveItem_api(HSARCHIVE harc, LPCWSTR path,
                                           LPCBYTE *pdata, UINT *pdataLength) {
  if (!harc || !pdata || !pdataLength) return FALSE;
  bytes data   = harc->get(path);
  *pdata       = data.start;
  *pdataLength = UINT(data.length);
  return !!data;
}

EXPORT SBOOL SCAPI SciterCloseArchive_api(HSARCHIVE harc) {
  if (harc) {
    delete harc;
    return TRUE;
  }
  return FALSE;
}

  /*
  EXTERN_C
  {
  #ifdef WINDOWS
    #ifdef STATIC_LIB
       tiscript_native_interface*  EXTAPI TIScriptAPI()
    #else
    __declspec(dllexport) tiscript_native_interface*  EXTAPI TIScriptAPI()
    #endif
  #else
    EXPORT tiscript_native_interface*  EXTAPI TIScriptAPI()
  #endif
    {
      return &native_interface;
    }
  }*/

#undef EXEC_START
#undef EXEC_START_2
#undef EXEC_START_3
#undef EXEC_START_4
#undef EXEC_START_5
#undef EXEC_END
