#ifndef __ext_ctl_h__
#define __ext_ctl_h__

#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"
#include "sdk-headers.h"

using namespace tool;
using namespace html;

struct ext_ctl : public html::ctl {
  string            name;
  ElementEventProc *pep;
  void *            tag;

  ext_ctl(const string &behavior_name, ElementEventProc *ep, void *t, uint subs = 0xFFFF)
      : name(behavior_name), pep(ep), tag(t) { next = nullptr; subscription = subs; }
  ext_ctl(ElementEventProc *ep, void *t, uint subs = 0xFFFF) : pep(ep), tag(t) {
    next = nullptr; 
    subscription = subs;
  }
  virtual ~ext_ctl() {}

  som_passport_t* asset_get_passport() const override;
  
  virtual html::CTL_TYPE get_type() override { return html::CTL_UNKNOWN; }

  virtual bool is_ext() const override { return true; }

  virtual som_asset_t* as_asset() override;
  
  virtual const string &behavior_name() const override { return name; }

  virtual bool attach(view &v, element *self) override;
  virtual void detach(view &v, element *self) override;
  virtual bool on(view &v, element *self, event_mouse &evt) override;
  virtual bool on(view &v, element *self, event_key &evt) override;
  virtual bool on(view &v, element *self, event_focus &evt) override;
  virtual bool on(view &v, element *self, event_behavior &evt) override;
  virtual bool on(view &v, element *self, event_scroll &evt) override;
  virtual bool on(view &v, element *self, event_gesture &evt) override;
  virtual bool on(view &v, element *self, event_exchange &evt) override;

  virtual void on_size_changed(view &v, element *self) override;
  virtual bool on_timer(view &v, element *self, timer_id tid,
                        TIMER_KIND kind) override;

  virtual bool on_method_call(view &v, element *self,
                              method_params *params) override;
  virtual bool on_data_arrived(view &v, element *self,
                               pump::request *rq) override;

  virtual bool focusable(const element *self) override {
    return (subscription & ::HANDLE_FOCUS) != 0;
  }

  virtual bool draw_outline(view &v, element *self, graphics *sf,  point pos) override;

  virtual bool draw_foreground(view &v, element *self, graphics *sf,
                               point pos) override;
  virtual bool draw_background(view &v, element *self, graphics *sf,
                               point pos) override;
  virtual bool draw_content(view &v, element *self, graphics *sf,
                            point pos) override;

  virtual bool get_scroll_data(view &v, element *self,
                               scroll_data &sd) override;
  virtual bool set_scroll_pos(view &v, element *self, point pos, bool smooth) override {
    return false;
  }

  virtual bool on_x_method_call(view &v, element *self, const char *name,
                                const tool::value *argv, size_t argc,
                                tool::value &retval) override;
#ifdef SCITER
//  virtual bool on_script_method_call(view &v, element *self, tis::VM *c,
//                                     tis::value  tag,
//                                     tis::value &retval) override;
#endif
  virtual bool set_value(view &v, element *self, const tool::value &val) override;
  virtual bool get_value(view &v, element *self, tool::value &val) override;
  virtual bool is_empty(const element *self, bool &yes) override;

  virtual element* r13n_container(element* self) { return self; }     /* reconcilliation of children is enabled. */
  

};

#endif