#include "api-defs.h"
#include "ext-ctl-api.h"

extern html::element *element_ptr(HELEMENT he);

void ext_ctl::detach(view &v, element *self) {
  assert(pep);
  if (pep) {
    helement              ap_self(self);
    INITIALIZATION_PARAMS prm;
    prm.cmd = BEHAVIOR_DETACH;
    pep(tag, self, HANDLE_INITIALIZATION, &prm);
  }
}

som_passport_t* ext_ctl::asset_get_passport() const {
  assert(pep);
  if (pep) {
    SOM_PARAMS prm;
    prm.cmd = SOM_GET_PASSPORT;
    if(pep(tag, NULL, HANDLE_SOM, &prm))
      return prm.data.passport;
  }
  return nullptr;
}

bool ext_ctl::attach(view &v, element *self) {
  assert(pep);
  if (pep) {
    helement ap_self(self);

    UINT subscr = 0xFFFFFFFF;
    if (pep(tag, self, UINT(SUBSCRIPTIONS_REQUEST), &subscr))
      this->subscription = subscr;

    INITIALIZATION_PARAMS prm;
    prm.cmd = BEHAVIOR_ATTACH;
    pep(tag, self, HANDLE_INITIALIZATION, &prm);
    return true;
  }
  return false;
}


som_asset_t* ext_ctl::as_asset()
{ 
  assert(pep);
  if (pep) {
    SOM_PARAMS prm;
    prm.cmd = SOM_GET_ASSET;
    if(pep(tag, NULL, HANDLE_SOM, &prm))
      return prm.data.asset;
  }
  return nullptr;
}

bool ext_ctl::on(view &v, element *self, event_mouse &evt) {
  if (pep) {
    helement     ap_self(self);
    helement     ap_target(evt.target);
    MOUSE_PARAMS mp;
    mp.alt_state    = evt.alt_state;
    mp.button_state = evt.button_state;
    mp.cursor_type  = UINT(-1);
    mp.cmd          = evt.cmd;
    mp.pos.x        = evt.pos.x;
    mp.pos.y        = evt.pos.y;
    mp.pos_view.x   = evt.pos_view.x;
    mp.pos_view.y   = evt.pos_view.y;
    mp.target       = (HELEMENT)evt.target;
    mp.is_on_icon   = evt.is_on_icon != 0;

    mp.dragging      = (HELEMENT)evt.dragging.ptr();
    mp.dragging_mode = evt.dragging_mode;
    if (pep(tag, self, ::HANDLE_MOUSE, &mp)) {
      if (mp.cursor_type != UINT(-1))
        evt.cursor = cursor::system(mp.cursor_type);
      evt.dragging      = (element *)mp.dragging;
      evt.dragging_mode = (html::DRAGGING_MODE)mp.dragging_mode;
      return true;
    }
  }
  return false;
}

bool ext_ctl::on(view &v, element *self, event_key &evt) {
  if (pep) {
    helement   ap_self(self);
    helement   ap_target(evt.target);
    KEY_PARAMS kp;
    kp.alt_state  = evt.alt_state;
    kp.cmd        = evt.cmd;
    kp.key_code   = evt.key_code;
    kp.target     = evt.target;
    bool r        = pep(tag, self, ::HANDLE_KEY, &kp) != FALSE;
    evt.key_code  = kp.key_code;
    evt.alt_state = kp.alt_state;
    return r;
  }
  return false;
}
bool ext_ctl::on(view &v, element *self, event_focus &evt) {
  if (pep) {
    helement     ap_self(self);
    helement     ap_target(evt.target);
    FOCUS_PARAMS fp;
    fp.cmd      = evt.cmd;
    fp.cause    = evt.cause;
    fp.target   = evt.target;
    return pep(tag, self, ::HANDLE_FOCUS, &fp) != FALSE;
  }
  return false;
}

bool ext_ctl::on(view &v, element *self, event_scroll &evt) {
  if (pep && ((subscription & ::HANDLE_SCROLL) != 0)) {
    helement      ap_self(self);
    helement      ap_target(evt.target);
    SCROLL_PARAMS sp;
    sp.cmd      = evt.cmd;
    sp.pos      = evt.pos;
    sp.vertical = evt.vertical;
    sp.target   = evt.target;
    sp.reason   = evt.reason;
    sp.source   = evt.source;
    bool r      = pep(tag, self, ::HANDLE_SCROLL, &sp) != FALSE;
    return r;
  }
  return false;
}

bool ext_ctl::on(view &v, element *self, event_gesture &evt) {
  if (pep && ((subscription & ::HANDLE_GESTURE) != 0)) {
    helement       ap_self(self);
    helement       ap_target(evt.target);
    GESTURE_PARAMS sp;
    sp.cmd         = evt.cmd;
    sp.target      = evt.target;
    sp.pos.x       = evt.pos.x;
    sp.pos.y       = evt.pos.y;
    sp.pos_view.x  = evt.pos_view.x;
    sp.pos_view.y  = evt.pos_view.y;
    sp.flags       = evt.flags;
    sp.delta_time  = evt.delta_time;
    sp.delta_xy.cx = evt.delta_xy.x;
    sp.delta_xy.cy = evt.delta_xy.y;
    sp.delta_v     = evt.delta_v;
    bool r         = pep(tag, self, ::HANDLE_GESTURE, &sp) != FALSE;
    if (r) evt.flags = sp.flags;
    return r;
  }
  return false;
}

void ext_ctl::on_size_changed(view &v, element *self) {
  if (pep) {
    helement ap_self(self);
    pep(tag, self, ::HANDLE_SIZE, 0);
  }
}

bool ext_ctl::set_value(view &pv, element *self, const value &v) {
  if (pep && ((subscription & ::HANDLE_METHOD_CALL) != 0)) {
    byte          bparams[sizeof(VALUE_PARAMS)] = {0};
    VALUE_PARAMS *params                        = (VALUE_PARAMS *)bparams;
    params->methodID                            = SET_VALUE;
    *((tool::value *)&params->val)              = v;
    helement ap_self(self);
    bool     r = pep(tag, (HELEMENT)self, ::HANDLE_METHOD_CALL,
                 (METHOD_PARAMS *)params) != FALSE;
    ((tool::value *)&params->val)->clear();
    return r;
  }
  return false;
}
bool ext_ctl::get_value(view &pv, element *self, value &v) {
  if (pep && ((subscription & ::HANDLE_METHOD_CALL) != 0)) {
    byte          bparams[sizeof(VALUE_PARAMS)] = {0};
    VALUE_PARAMS *params                        = (VALUE_PARAMS *)bparams;
    params->methodID                            = GET_VALUE;
    helement ap_self(self);
    if (pep(tag, (HELEMENT)self, ::HANDLE_METHOD_CALL,
            (METHOD_PARAMS *)params)) {
      v = *((tool::value *)&params->val);
      ((tool::value *)&params->val)->clear();
      return true;
    }
  }
  return false;
}

bool ext_ctl::is_empty(const element *self, bool &yes) {
  if (pep && ((subscription & ::HANDLE_METHOD_CALL) != 0)) {
    IS_EMPTY_PARAMS params;
    params.is_empty = 0;
    helement ap_self(self);
    if (pep(tag, (HELEMENT)self, ::HANDLE_METHOD_CALL,
            (METHOD_PARAMS *)&params)) {
      yes = params.is_empty != 0;
      return true;
    }
  }
  return false;
}

bool ext_ctl::on_timer(view &v, element *self, timer_id timer_id,
                       TIMER_KIND kind) {
  if (pep && (kind == EXTERNAL_TIMER)) {
    helement     ap_self(self);
    TIMER_PARAMS params;
    params.timerId = UINT_PTR(timer_id);
    return pep(tag, self, ::HANDLE_TIMER, &params) != FALSE;
    // return pep( tag, self, HANDLE_TIMER, 0 ) != FALSE;
  }
  return false;
}

bool ext_ctl::draw_foreground(view &v, element *self, graphics *sf, point pos) {
  if (pep && ((subscription & ::HANDLE_DRAW) != 0)) {
    gool::size  sz = self->dim();
    helement    ap_self(self);
    DRAW_PARAMS dp;
    dp.area.left   = pos.x;
    dp.area.top    = pos.y;
    dp.area.right  = pos.x + sz.x;
    dp.area.bottom = pos.y + sz.y;
    dp.cmd         = DRAW_FOREGROUND;
    dp.gfx         = sf;
    dp.reserved    = 0;
    return pep(tag, self, ::HANDLE_DRAW, &dp) != FALSE;
  }
  return false;
}

bool ext_ctl::draw_outline(view &v, element *self, graphics *sf, point pos) {
  if (pep && ((subscription & ::HANDLE_DRAW) != 0)) {
    gool::size  sz = self->dim();
    helement    ap_self(self);
    DRAW_PARAMS dp;
    dp.area.left = pos.x;
    dp.area.top = pos.y;
    dp.area.right = pos.x + sz.x;
    dp.area.bottom = pos.y + sz.y;
    dp.cmd = DRAW_OUTLINE;
    dp.gfx = sf;
    dp.reserved = 0;
    return pep(tag, self, ::HANDLE_DRAW, &dp) != FALSE;
  }
  return false;
}


bool ext_ctl::draw_background(view &v, element *self, graphics *sf, point pos) {
  if (pep && ((subscription & ::HANDLE_DRAW) != 0)) {
    gool::size  sz = self->dim();
    helement    ap_self(self);
    DRAW_PARAMS dp;
    dp.area.left   = pos.x;
    dp.area.top    = pos.y;
    dp.area.right  = pos.x + sz.x;
    dp.area.bottom = pos.y + sz.y;
    dp.cmd         = DRAW_BACKGROUND;
    dp.gfx         = sf;
    dp.reserved    = 0;
    return pep(tag, self, ::HANDLE_DRAW, &dp) != FALSE;
  }
  return false;
}

bool ext_ctl::draw_content(view &v, element *self, graphics *sf, point pos) {
  if (pep && ((subscription & ::HANDLE_DRAW) != 0)) {
    gool::size  sz = self->dim();
    helement    ap_self(self);
    DRAW_PARAMS dp;
    dp.area.left   = pos.x;
    dp.area.top    = pos.y;
    dp.area.right  = pos.x + sz.x;
    dp.area.bottom = pos.y + sz.y;
    dp.cmd         = DRAW_CONTENT;
    dp.gfx         = sf;
    dp.reserved    = 0;
    return pep(tag, self, ::HANDLE_DRAW, &dp) != FALSE;
  }
  return false;
}

struct RAW_BEHAVIOR_EVENT_PARAMS {
  UINT     cmd;      // BEHAVIOR_EVENTS
  HELEMENT heTarget; // target element handler, in MENU_ITEM_CLICK this is owner
                     // element that caused this menu - e.g. context menu owner
  // In scripting this field named as Event.owner
  HELEMENT he; // source element e.g. in SELECTION_CHANGED it is new selected
               // <option>, in MENU_ITEM_CLICK it is menu item (LI) element
  UINT_PTR
      reason; // EVENT_REASON or EDIT_CHANGED_REASON - UI action causing change.
  // In case of custom event notifications this may be any
  // application specific value.
  VALUE data; // auxiliary data accompanied with the event. E.g. FORM_SUBMIT
              // event is using this field to pass collection of values.
  LPCWSTR name;
};

UINT SCAPI ValueInit_api(VALUE *pval);
UINT SCAPI ValueClear_api(VALUE *pval);
UINT SCAPI ValueCopy_api(VALUE *pdst, const VALUE *psrc);

bool ext_ctl::on(view &v, element *self, event_behavior &evt) {
  helement ap_self(self);
  helement ap_target(evt.target);
  helement ap_source(evt.source);

  RAW_BEHAVIOR_EVENT_PARAMS bep;
  memzero(bep);
  bep.cmd      = evt.cmd;
  bep.heTarget = evt.target;
  bep.he       = evt.source;
  bep.reason   = evt.reason;
  bep.name     = evt.name.c_str();
  ValueInit_api(&bep.data);
  ValueCopy_api(&bep.data, (VALUE *)&evt.data);

  bool result = pep(tag, self, ::HANDLE_BEHAVIOR_EVENT, &bep) != FALSE;

  evt.source = bep.he;

  ValueCopy_api((VALUE *)&evt.data, &bep.data);
  ValueClear_api(&bep.data);

  return result;
}

struct RAW_EXCHANGE_PARAMS
{
  UINT         cmd;          // EXCHANGE_EVENTS
  HELEMENT     target;       // target element
  HELEMENT     source;       // source element (can be null if D&D from external window)
  POINT        pos;          // position of cursor, element relative
  POINT        pos_view;     // position of cursor, view relative
  UINT         mode;         // DD_MODE 
  VALUE        data;         // packaged drag data
};

bool ext_ctl::on(view &v, element *self, event_exchange &evt) {
  if (pep && ((subscription & ::HANDLE_EXCHANGE) != 0)) {
    helement       ap_self(self);
    helement       ap_target(evt.target);
    static_assert(sizeof(EXCHANGE_PARAMS) == sizeof(RAW_EXCHANGE_PARAMS), "ext representation must match");
    RAW_EXCHANGE_PARAMS sp;
    memzero(sp);
    sp.cmd = evt.cmd;
    sp.target = evt.target;
    sp.source = evt.dd_source;
    sp.pos.x = evt.pos.x;
    sp.pos.y = evt.pos.y;
    sp.pos_view.x = evt.pos_view.x;
    sp.pos_view.y = evt.pos_view.y;
    sp.mode = evt.dd_modes;
    value t = evt.data_value();
    ValueInit_api(&sp.data);
    ValueCopy_api(&sp.data, (VALUE *)&t);
    bool r = pep(tag, self, ::HANDLE_EXCHANGE, &sp) != FALSE;
    ValueClear_api(&sp.data);
    if (r) evt.dd_modes = html::DD_MODE(sp.mode);
    return r;
  }
  return false;
}


bool ext_ctl::on_method_call(view &v, element *self, method_params *params) {
  helement ap_self(self);
  return pep(tag, self, ::HANDLE_METHOD_CALL, (METHOD_PARAMS *)params) != FALSE;
}

struct RAW_SCRIPTING_METHOD_PARAMS {
  LPCSTR name;   //< method name
  VALUE *argv;   //< vector of arguments
  UINT   argc;   //< argument count
  VALUE  result; //< return value
};

bool ext_ctl::on_x_method_call(view &v, element *self, const char *name,
                               const tool::value *argv, size_t argc,
                               tool::value &retval) {
  helement ap_self(self);

  RAW_SCRIPTING_METHOD_PARAMS smp;
  memzero(smp);

  smp.name = name;
  smp.argv = (SCITER_VALUE *)argv;
  smp.argc = UINT(argc);
  ValueInit_api(&smp.result);
  bool r = pep(tag, self, ::HANDLE_SCRIPTING_METHOD_CALL, &smp) != FALSE;
  ValueCopy_api((VALUE *)&retval, &smp.result);
  ValueClear_api(&smp.result);
  return r;
}

bool ext_ctl::get_scroll_data(view &v, element *self, scroll_data &sd) {
  return false;
}

bool ext_ctl::on_data_arrived(view &v, element *self, pump::request *rq) {
  helement ap_self(self);
  helement ap_src(rq->initiator);
  ustring  uurl(rq->url);

  DATA_ARRIVED_PARAMS ps;

  ps.initiator = rq->initiator;
  ps.data      = rq->data.head(); // data buffer
  ps.dataSize  = rq->data.size(); // size of data
  ps.dataType  = rq->rq_type;
  ps.status    = rq->status;
  ps.uri       = uurl;

  return pep(tag, self, ::HANDLE_DATA_ARRIVED, &ps) != FALSE;
}
