# Alternative GNU Make project makefile autogenerated by Premake

ifndef config
  config=debug_x32
endif

ifndef verbose
  SILENT = @
endif

.PHONY: clean prebuild

SHELLTYPE := posix
ifeq (.exe,$(findstring .exe,$(ComSpec)))
	SHELLTYPE := msdos
endif

# Configurations
# #############################################

RESCOMP = windres
INCLUDES += -I../.. -I../../engine/tool -I../../engine/gool -I../../engine/html -I../../build.windows/include -I../../engine/external/zlib -I../../engine -I../../engine/external/rlottie/inc -I../../engine/external/rlottie/src/lottie -I../../engine/external/rlottie/src/vector -I../../engine/xdom -I../../engine/tiscript/include -I../../engine/tiscript/dybase/inc -I../../engine/external/uv/include -I../../engine/external/uv/src -I../../engine/external/uv-tls/include
FORCE_INCLUDE +=
ALL_CPPFLAGS += $(CPPFLAGS) -MMD -MP $(DEFINES) $(INCLUDES)
ALL_RESFLAGS += $(RESFLAGS) $(DEFINES) $(INCLUDES)
LIBS += -luuid
LDDEPS +=
LINKCMD = $(AR) -rcs "$@" $(OBJECTS)
define PREBUILDCMDS
endef
define PRELINKCMDS
endef
define POSTBUILDCMDS
endef

ifeq ($(config),debug_x32)
TARGETDIR = ../../lib.lnx/x32
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/x32/Debug/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m32 -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m32 -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib32 -m32 -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),debug_x64)
TARGETDIR = ../../lib.lnx/x64
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/x64/Debug/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m64 -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m64 -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib64 -m64 -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),debug_arm32)
TARGETDIR = ../../lib.lnx/arm32
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/arm32/Debug/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),debug_arm64)
TARGETDIR = ../../lib.lnx/arm64
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/arm64/Debug/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),release_x32)
TARGETDIR = ../../lib.lnx/x32
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/x32/Release/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m32 -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m32 -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib32 -m32 -flto -s -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),release_x64)
TARGETDIR = ../../lib.lnx/x64
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/x64/Release/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m64 -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m64 -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib64 -m64 -flto -s -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),release_arm32)
TARGETDIR = ../../lib.lnx/arm32
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/arm32/Release/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -flto -s -fPIC -pthread -static-libstdc++ -latomic

else ifeq ($(config),release_arm64)
TARGETDIR = ../../lib.lnx/arm64
TARGET = $(TARGETDIR)/libsciter.static.a
OBJDIR = obj/arm64/Release/sciter.static
DEFINES += -DDEVICE=IOT -DSCITER -DUSE_LOTTIE=1 -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DSTATIC_LIB -DMONOLITHIC -DPNG_ARM_NEON_OPT=0
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -flto -s -fPIC -pthread -static-libstdc++ -latomic

else
  $(error "invalid configuration $(config)")
endif

# Per File Configurations
# #############################################


# File sets
# #############################################

OBJECTS :=

OBJECTS += $(OBJDIR)/adler32.o
OBJECTS += $(OBJDIR)/aes.o
OBJECTS += $(OBJDIR)/aesni.o
OBJECTS += $(OBJDIR)/affentry.o
OBJECTS += $(OBJDIR)/affixmgr.o
OBJECTS += $(OBJDIR)/alpha_dec.o
OBJECTS += $(OBJDIR)/alpha_enc.o
OBJECTS += $(OBJDIR)/alpha_processing.o
OBJECTS += $(OBJDIR)/alpha_processing_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/alpha_processing_neon.o
OBJECTS += $(OBJDIR)/alpha_processing_sse2.o
OBJECTS += $(OBJDIR)/alpha_processing_sse41.o
OBJECTS += $(OBJDIR)/analysis_enc.o
OBJECTS += $(OBJDIR)/anim_decode.o
OBJECTS += $(OBJDIR)/arc4.o
OBJECTS += $(OBJDIR)/argb.o
OBJECTS += $(OBJDIR)/argb_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/argb_sse2.o
OBJECTS += $(OBJDIR)/asn1parse.o
OBJECTS += $(OBJDIR)/asn1write.o
OBJECTS += $(OBJDIR)/async.o
OBJECTS += $(OBJDIR)/backward_references_enc.o
OBJECTS += $(OBJDIR)/base64.o
OBJECTS += $(OBJDIR)/bignum.o
OBJECTS += $(OBJDIR)/bio.o
OBJECTS += $(OBJDIR)/bit_reader_utils.o
OBJECTS += $(OBJDIR)/bit_writer_utils.o
OBJECTS += $(OBJDIR)/blowfish.o
OBJECTS += $(OBJDIR)/btree.o
OBJECTS += $(OBJDIR)/buffer_dec.o
OBJECTS += $(OBJDIR)/camellia.o
OBJECTS += $(OBJDIR)/ccm.o
OBJECTS += $(OBJDIR)/certs.o
OBJECTS += $(OBJDIR)/cipher.o
OBJECTS += $(OBJDIR)/cipher_wrap.o
OBJECTS += $(OBJDIR)/cmac.o
OBJECTS += $(OBJDIR)/color_cache_utils.o
OBJECTS += $(OBJDIR)/compress.o
OBJECTS += $(OBJDIR)/config_enc.o
OBJECTS += $(OBJDIR)/core.o
OBJECTS += $(OBJDIR)/cost.o
OBJECTS += $(OBJDIR)/cost_enc.o
OBJECTS += $(OBJDIR)/cost_mips32.o
OBJECTS += $(OBJDIR)/cost_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/cost_sse2.o
OBJECTS += $(OBJDIR)/cpu.o
OBJECTS += $(OBJDIR)/crc32.o
OBJECTS += $(OBJDIR)/cs_angle.o
OBJECTS += $(OBJDIR)/cs_api.o
OBJECTS += $(OBJDIR)/cs_asset.o
OBJECTS += $(OBJDIR)/cs_bytevector.o
OBJECTS += $(OBJDIR)/cs_cobject.o
OBJECTS += $(OBJDIR)/cs_color.o
OBJECTS += $(OBJDIR)/cs_com.o
OBJECTS += $(OBJDIR)/cs_datetime.o
OBJECTS += $(OBJDIR)/cs_debug.o
OBJECTS += $(OBJDIR)/cs_duration.o
OBJECTS += $(OBJDIR)/cs_enter.o
OBJECTS += $(OBJDIR)/cs_env.o
OBJECTS += $(OBJDIR)/cs_error.o
OBJECTS += $(OBJDIR)/cs_eval.o
OBJECTS += $(OBJDIR)/cs_fcn.o
OBJECTS += $(OBJDIR)/cs_file.o
OBJECTS += $(OBJDIR)/cs_float.o
OBJECTS += $(OBJDIR)/cs_hash.o
OBJECTS += $(OBJDIR)/cs_heap.o
OBJECTS += $(OBJDIR)/cs_instanceof.o
OBJECTS += $(OBJDIR)/cs_int.o
OBJECTS += $(OBJDIR)/cs_integer.o
OBJECTS += $(OBJDIR)/cs_json.o
OBJECTS += $(OBJDIR)/cs_length.o
OBJECTS += $(OBJDIR)/cs_math.o
OBJECTS += $(OBJDIR)/cs_method.o
OBJECTS += $(OBJDIR)/cs_net.o
OBJECTS += $(OBJDIR)/cs_object.o
OBJECTS += $(OBJDIR)/cs_parse.o
OBJECTS += $(OBJDIR)/cs_persistent.o
OBJECTS += $(OBJDIR)/cs_printf.o
OBJECTS += $(OBJDIR)/cs_rcode.o
OBJECTS += $(OBJDIR)/cs_regexp.o
OBJECTS += $(OBJDIR)/cs_scn.o
OBJECTS += $(OBJDIR)/cs_storage.o
OBJECTS += $(OBJDIR)/cs_stream.o
OBJECTS += $(OBJDIR)/cs_string.o
OBJECTS += $(OBJDIR)/cs_symbol.o
OBJECTS += $(OBJDIR)/cs_system.o
OBJECTS += $(OBJDIR)/cs_type.o
OBJECTS += $(OBJDIR)/cs_vector.o
OBJECTS += $(OBJDIR)/cs_vm.o
OBJECTS += $(OBJDIR)/cs_wcode.o
OBJECTS += $(OBJDIR)/cs_xml_parser.o
OBJECTS += $(OBJDIR)/csutil.o
OBJECTS += $(OBJDIR)/ctr_drbg.o
OBJECTS += $(OBJDIR)/database.o
OBJECTS += $(OBJDIR)/debug.o
OBJECTS += $(OBJDIR)/dec.o
OBJECTS += $(OBJDIR)/dec_clip_tables.o
OBJECTS += $(OBJDIR)/dec_mips32.o
OBJECTS += $(OBJDIR)/dec_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/dec_msa.o
OBJECTS += $(OBJDIR)/dec_neon.o
OBJECTS += $(OBJDIR)/dec_sse2.o
OBJECTS += $(OBJDIR)/dec_sse41.o
OBJECTS += $(OBJDIR)/deflate.o
OBJECTS += $(OBJDIR)/delta_palettization_enc.o
OBJECTS += $(OBJDIR)/demux.o
OBJECTS += $(OBJDIR)/des.o
OBJECTS += $(OBJDIR)/dhm.o
OBJECTS += $(OBJDIR)/dl.o
OBJECTS += $(OBJDIR)/dybase.o
OBJECTS += $(OBJDIR)/ecdh.o
OBJECTS += $(OBJDIR)/ecdsa.o
OBJECTS += $(OBJDIR)/ecjpake.o
OBJECTS += $(OBJDIR)/ecp.o
OBJECTS += $(OBJDIR)/ecp_curves.o
OBJECTS += $(OBJDIR)/enc.o
OBJECTS += $(OBJDIR)/enc_avx2.o
OBJECTS += $(OBJDIR)/enc_mips32.o
OBJECTS += $(OBJDIR)/enc_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/enc_msa.o
OBJECTS += $(OBJDIR)/enc_neon.o
OBJECTS += $(OBJDIR)/enc_sse2.o
OBJECTS += $(OBJDIR)/enc_sse41.o
OBJECTS += $(OBJDIR)/entropy.o
OBJECTS += $(OBJDIR)/entropy_poll.o
OBJECTS += $(OBJDIR)/error.o
OBJECTS += $(OBJDIR)/file.o
OBJECTS += $(OBJDIR)/filemgr.o
OBJECTS += $(OBJDIR)/filter_enc.o
OBJECTS += $(OBJDIR)/filters.o
OBJECTS += $(OBJDIR)/filters_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/filters_msa.o
OBJECTS += $(OBJDIR)/filters_neon.o
OBJECTS += $(OBJDIR)/filters_sse2.o
OBJECTS += $(OBJDIR)/filters_utils.o
OBJECTS += $(OBJDIR)/frame_dec.o
OBJECTS += $(OBJDIR)/frame_enc.o
OBJECTS += $(OBJDIR)/fs-poll.o
OBJECTS += $(OBJDIR)/fs.o
OBJECTS += $(OBJDIR)/gcm.o
OBJECTS += $(OBJDIR)/getaddrinfo.o
OBJECTS += $(OBJDIR)/getnameinfo.o
OBJECTS += $(OBJDIR)/gool-exif.o
OBJECTS += $(OBJDIR)/gool-figures.o
OBJECTS += $(OBJDIR)/gool-font.o
OBJECTS += $(OBJDIR)/gool-gif-io.o
OBJECTS += $(OBJDIR)/gool-graphics.o
OBJECTS += $(OBJDIR)/gool-icon.o
OBJECTS += $(OBJDIR)/gool-image-blur.o
OBJECTS += $(OBJDIR)/gool-image-io.o
OBJECTS += $(OBJDIR)/gool-image-transformation.o
OBJECTS += $(OBJDIR)/gool-image.o
OBJECTS += $(OBJDIR)/gool-theme.o
OBJECTS += $(OBJDIR)/gool-types.o
OBJECTS += $(OBJDIR)/gtk-application.o
OBJECTS += $(OBJDIR)/gtk-clipboard.o
OBJECTS += $(OBJDIR)/gtk-cursor.o
OBJECTS += $(OBJDIR)/gtk-gool.o
OBJECTS += $(OBJDIR)/gtk-graphics.o
OBJECTS += $(OBJDIR)/gtk-iwindow.o
OBJECTS += $(OBJDIR)/gtk-popup.o
OBJECTS += $(OBJDIR)/gtk-sciter-api.o
OBJECTS += $(OBJDIR)/gtk-text-analysis.o
OBJECTS += $(OBJDIR)/gtk-theme.o
OBJECTS += $(OBJDIR)/gtk-view.o
OBJECTS += $(OBJDIR)/gtk-window-api.o
OBJECTS += $(OBJDIR)/hashmgr.o
OBJECTS += $(OBJDIR)/havege.o
OBJECTS += $(OBJDIR)/histogram_enc.o
OBJECTS += $(OBJDIR)/hmac_drbg.o
OBJECTS += $(OBJDIR)/html-actions-ops.o
OBJECTS += $(OBJDIR)/html-actions-stack.o
OBJECTS += $(OBJDIR)/html-animator-blend.o
OBJECTS += $(OBJDIR)/html-animator-css.o
OBJECTS += $(OBJDIR)/html-animator-image.o
OBJECTS += $(OBJDIR)/html-animator-scroll.o
OBJECTS += $(OBJDIR)/html-animator.o
OBJECTS += $(OBJDIR)/html-behavior.o
OBJECTS += $(OBJDIR)/html-clipboard.o
OBJECTS += $(OBJDIR)/html-css-istream.o
OBJECTS += $(OBJDIR)/html-css-script.o
OBJECTS += $(OBJDIR)/html-ctl-buttons.o
OBJECTS += $(OBJDIR)/html-ctl-column-resizer.o
OBJECTS += $(OBJDIR)/html-ctl-date.o
OBJECTS += $(OBJDIR)/html-ctl-dropdown-select.o
OBJECTS += $(OBJDIR)/html-ctl-edit.o
OBJECTS += $(OBJDIR)/html-ctl-effects.o
OBJECTS += $(OBJDIR)/html-ctl-frame.o
OBJECTS += $(OBJDIR)/html-ctl-highlighted.o
OBJECTS += $(OBJDIR)/html-ctl-htmlarea.o
OBJECTS += $(OBJDIR)/html-ctl-hyperlink.o
OBJECTS += $(OBJDIR)/html-ctl-image.o
OBJECTS += $(OBJDIR)/html-ctl-lists.o
OBJECTS += $(OBJDIR)/html-ctl-lottie.o
OBJECTS += $(OBJDIR)/html-ctl-masked-edit.o
OBJECTS += $(OBJDIR)/html-ctl-menu.o
OBJECTS += $(OBJDIR)/html-ctl-numeric.o
OBJECTS += $(OBJDIR)/html-ctl-output.o
OBJECTS += $(OBJDIR)/html-ctl-pager.o
OBJECTS += $(OBJDIR)/html-ctl-plaintext.o
OBJECTS += $(OBJDIR)/html-ctl-progress.o
OBJECTS += $(OBJDIR)/html-ctl-richtext.o
OBJECTS += $(OBJDIR)/html-ctl-scrollbar.o
OBJECTS += $(OBJDIR)/html-ctl-select.o
OBJECTS += $(OBJDIR)/html-ctl-slider.o
OBJECTS += $(OBJDIR)/html-ctl-swipe.o
OBJECTS += $(OBJDIR)/html-ctl-textarea.o
OBJECTS += $(OBJDIR)/html-ctl-video-zero.o
OBJECTS += $(OBJDIR)/html-ctl-video.o
OBJECTS += $(OBJDIR)/html-ctl-virtual-list.o
OBJECTS += $(OBJDIR)/html-document.o
OBJECTS += $(OBJDIR)/html-dom.o
OBJECTS += $(OBJDIR)/html-drag-n-drop.o
OBJECTS += $(OBJDIR)/html-drawing.o
OBJECTS += $(OBJDIR)/html-emit.o
OBJECTS += $(OBJDIR)/html-event-handlers.o
OBJECTS += $(OBJDIR)/html-float-ctx.o
OBJECTS += $(OBJDIR)/html-intrinsic-styles.o
OBJECTS += $(OBJDIR)/html-layout-columns.o
OBJECTS += $(OBJDIR)/html-layout-default.o
OBJECTS += $(OBJDIR)/html-layout-grid.o
OBJECTS += $(OBJDIR)/html-layout-horizontal-wrap.o
OBJECTS += $(OBJDIR)/html-layout-horizontal.o
OBJECTS += $(OBJDIR)/html-layout-image.o
OBJECTS += $(OBJDIR)/html-layout-stack.o
OBJECTS += $(OBJDIR)/html-layout-svg.o
OBJECTS += $(OBJDIR)/html-layout-table-body.o
OBJECTS += $(OBJDIR)/html-layout-table.o
OBJECTS += $(OBJDIR)/html-layout-template.o
OBJECTS += $(OBJDIR)/html-layout-text-analysis.o
OBJECTS += $(OBJDIR)/html-layout-text-flow.o
OBJECTS += $(OBJDIR)/html-layout-text.o
OBJECTS += $(OBJDIR)/html-layout-vertical-wrap.o
OBJECTS += $(OBJDIR)/html-layout-vertical.o
OBJECTS += $(OBJDIR)/html-layout.o
OBJECTS += $(OBJDIR)/html-parser.o
OBJECTS += $(OBJDIR)/html-primitives.o
OBJECTS += $(OBJDIR)/html-pump.o
OBJECTS += $(OBJDIR)/html-scrollbar.o
OBJECTS += $(OBJDIR)/html-streams.o
OBJECTS += $(OBJDIR)/html-style-parser.o
OBJECTS += $(OBJDIR)/html-style-prop-list.o
OBJECTS += $(OBJDIR)/html-style-property.o
OBJECTS += $(OBJDIR)/html-style-types.o
OBJECTS += $(OBJDIR)/html-style.o
OBJECTS += $(OBJDIR)/html-svg-image.o
OBJECTS += $(OBJDIR)/html-symbols.o
OBJECTS += $(OBJDIR)/html-touch.o
OBJECTS += $(OBJDIR)/html-view-events.o
OBJECTS += $(OBJDIR)/html-view-focus.o
OBJECTS += $(OBJDIR)/html-view-update-queue.o
OBJECTS += $(OBJDIR)/html-view.o
OBJECTS += $(OBJDIR)/html-z-ctx.o
OBJECTS += $(OBJDIR)/huffman_encode_utils.o
OBJECTS += $(OBJDIR)/huffman_utils.o
OBJECTS += $(OBJDIR)/hunspell.o
OBJECTS += $(OBJDIR)/hunzip.o
OBJECTS += $(OBJDIR)/idec_dec.o
OBJECTS += $(OBJDIR)/idna.o
OBJECTS += $(OBJDIR)/inet.o
OBJECTS += $(OBJDIR)/inffast.o
OBJECTS += $(OBJDIR)/inflate.o
OBJECTS += $(OBJDIR)/inftrees.o
OBJECTS += $(OBJDIR)/io_dec.o
OBJECTS += $(OBJDIR)/ioapi.o
OBJECTS += $(OBJDIR)/iterator_enc.o
OBJECTS += $(OBJDIR)/jaricom.o
OBJECTS += $(OBJDIR)/jcapimin.o
OBJECTS += $(OBJDIR)/jcapistd.o
OBJECTS += $(OBJDIR)/jcarith.o
OBJECTS += $(OBJDIR)/jccoefct.o
OBJECTS += $(OBJDIR)/jccolor.o
OBJECTS += $(OBJDIR)/jcdctmgr.o
OBJECTS += $(OBJDIR)/jchuff.o
OBJECTS += $(OBJDIR)/jcinit.o
OBJECTS += $(OBJDIR)/jcmainct.o
OBJECTS += $(OBJDIR)/jcmarker.o
OBJECTS += $(OBJDIR)/jcmaster.o
OBJECTS += $(OBJDIR)/jcomapi.o
OBJECTS += $(OBJDIR)/jcparam.o
OBJECTS += $(OBJDIR)/jcprepct.o
OBJECTS += $(OBJDIR)/jcsample.o
OBJECTS += $(OBJDIR)/jctrans.o
OBJECTS += $(OBJDIR)/jdapimin.o
OBJECTS += $(OBJDIR)/jdapistd.o
OBJECTS += $(OBJDIR)/jdarith.o
OBJECTS += $(OBJDIR)/jdatadst.o
OBJECTS += $(OBJDIR)/jdatasrc.o
OBJECTS += $(OBJDIR)/jdcoefct.o
OBJECTS += $(OBJDIR)/jdcolor.o
OBJECTS += $(OBJDIR)/jddctmgr.o
OBJECTS += $(OBJDIR)/jdhuff.o
OBJECTS += $(OBJDIR)/jdinput.o
OBJECTS += $(OBJDIR)/jdmainct.o
OBJECTS += $(OBJDIR)/jdmarker.o
OBJECTS += $(OBJDIR)/jdmaster.o
OBJECTS += $(OBJDIR)/jdmerge.o
OBJECTS += $(OBJDIR)/jdpostct.o
OBJECTS += $(OBJDIR)/jdsample.o
OBJECTS += $(OBJDIR)/jdtrans.o
OBJECTS += $(OBJDIR)/jerror.o
OBJECTS += $(OBJDIR)/jfdctflt.o
OBJECTS += $(OBJDIR)/jfdctfst.o
OBJECTS += $(OBJDIR)/jfdctint.o
OBJECTS += $(OBJDIR)/jidctflt.o
OBJECTS += $(OBJDIR)/jidctfst.o
OBJECTS += $(OBJDIR)/jidctint.o
OBJECTS += $(OBJDIR)/jmemmgr.o
OBJECTS += $(OBJDIR)/jmemnobs.o
OBJECTS += $(OBJDIR)/jquant1.o
OBJECTS += $(OBJDIR)/jquant2.o
OBJECTS += $(OBJDIR)/jutils.o
OBJECTS += $(OBJDIR)/linux-core.o
OBJECTS += $(OBJDIR)/linux-inotify.o
OBJECTS += $(OBJDIR)/linux-syscalls.o
OBJECTS += $(OBJDIR)/linux_http_pump_curl.o
OBJECTS += $(OBJDIR)/linux_specifics.o
OBJECTS += $(OBJDIR)/linux_spell_checker.o
OBJECTS += $(OBJDIR)/loop-watcher.o
OBJECTS += $(OBJDIR)/loop.o
OBJECTS += $(OBJDIR)/lossless.o
OBJECTS += $(OBJDIR)/lossless_enc.o
OBJECTS += $(OBJDIR)/lossless_enc_mips32.o
OBJECTS += $(OBJDIR)/lossless_enc_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/lossless_enc_msa.o
OBJECTS += $(OBJDIR)/lossless_enc_neon.o
OBJECTS += $(OBJDIR)/lossless_enc_sse2.o
OBJECTS += $(OBJDIR)/lossless_enc_sse41.o
OBJECTS += $(OBJDIR)/lossless_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/lossless_msa.o
OBJECTS += $(OBJDIR)/lossless_neon.o
OBJECTS += $(OBJDIR)/lossless_sse2.o
OBJECTS += $(OBJDIR)/lottieanimation.o
OBJECTS += $(OBJDIR)/lottieitem.o
OBJECTS += $(OBJDIR)/lottieitem_capi.o
OBJECTS += $(OBJDIR)/lottiekeypath.o
OBJECTS += $(OBJDIR)/lottieloader.o
OBJECTS += $(OBJDIR)/lottiemodel.o
OBJECTS += $(OBJDIR)/lottieparser.o
OBJECTS += $(OBJDIR)/lottieproxymodel.o
OBJECTS += $(OBJDIR)/md.o
OBJECTS += $(OBJDIR)/md2.o
OBJECTS += $(OBJDIR)/md4.o
OBJECTS += $(OBJDIR)/md5.o
OBJECTS += $(OBJDIR)/md_wrap.o
OBJECTS += $(OBJDIR)/memory_buffer_alloc.o
OBJECTS += $(OBJDIR)/near_lossless_enc.o
OBJECTS += $(OBJDIR)/net_sockets.o
OBJECTS += $(OBJDIR)/oid.o
OBJECTS += $(OBJDIR)/padlock.o
OBJECTS += $(OBJDIR)/pagepool.o
OBJECTS += $(OBJDIR)/pem.o
OBJECTS += $(OBJDIR)/phonet.o
OBJECTS += $(OBJDIR)/picture_csp_enc.o
OBJECTS += $(OBJDIR)/picture_enc.o
OBJECTS += $(OBJDIR)/picture_psnr_enc.o
OBJECTS += $(OBJDIR)/picture_rescale_enc.o
OBJECTS += $(OBJDIR)/picture_tools_enc.o
OBJECTS += $(OBJDIR)/pipe.o
OBJECTS += $(OBJDIR)/pk.o
OBJECTS += $(OBJDIR)/pk_wrap.o
OBJECTS += $(OBJDIR)/pkcs11.o
OBJECTS += $(OBJDIR)/pkcs12.o
OBJECTS += $(OBJDIR)/pkcs5.o
OBJECTS += $(OBJDIR)/pkparse.o
OBJECTS += $(OBJDIR)/pkwrite.o
OBJECTS += $(OBJDIR)/platform.o
OBJECTS += $(OBJDIR)/png.o
OBJECTS += $(OBJDIR)/pngerror.o
OBJECTS += $(OBJDIR)/pngget.o
OBJECTS += $(OBJDIR)/pngmem.o
OBJECTS += $(OBJDIR)/pngpread.o
OBJECTS += $(OBJDIR)/pngread.o
OBJECTS += $(OBJDIR)/pngrio.o
OBJECTS += $(OBJDIR)/pngrtran.o
OBJECTS += $(OBJDIR)/pngrutil.o
OBJECTS += $(OBJDIR)/pngset.o
OBJECTS += $(OBJDIR)/pngtrans.o
OBJECTS += $(OBJDIR)/pngwio.o
OBJECTS += $(OBJDIR)/pngwrite.o
OBJECTS += $(OBJDIR)/pngwtran.o
OBJECTS += $(OBJDIR)/pngwutil.o
OBJECTS += $(OBJDIR)/poll.o
OBJECTS += $(OBJDIR)/predictor_enc.o
OBJECTS += $(OBJDIR)/process.o
OBJECTS += $(OBJDIR)/procfs-exepath.o
OBJECTS += $(OBJDIR)/proctitle.o
OBJECTS += $(OBJDIR)/quant_dec.o
OBJECTS += $(OBJDIR)/quant_enc.o
OBJECTS += $(OBJDIR)/quant_levels_dec_utils.o
OBJECTS += $(OBJDIR)/quant_levels_utils.o
OBJECTS += $(OBJDIR)/random-devurandom.o
OBJECTS += $(OBJDIR)/random-getrandom.o
OBJECTS += $(OBJDIR)/random-sysctl-linux.o
OBJECTS += $(OBJDIR)/random.o
OBJECTS += $(OBJDIR)/random_utils.o
OBJECTS += $(OBJDIR)/re.o
OBJECTS += $(OBJDIR)/replist.o
OBJECTS += $(OBJDIR)/rescaler.o
OBJECTS += $(OBJDIR)/rescaler_mips32.o
OBJECTS += $(OBJDIR)/rescaler_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/rescaler_msa.o
OBJECTS += $(OBJDIR)/rescaler_neon.o
OBJECTS += $(OBJDIR)/rescaler_sse2.o
OBJECTS += $(OBJDIR)/rescaler_utils.o
OBJECTS += $(OBJDIR)/ripemd160.o
OBJECTS += $(OBJDIR)/rsa.o
OBJECTS += $(OBJDIR)/rsa_internal.o
OBJECTS += $(OBJDIR)/sha1.o
OBJECTS += $(OBJDIR)/sha256.o
OBJECTS += $(OBJDIR)/sha512.o
OBJECTS += $(OBJDIR)/signal.o
OBJECTS += $(OBJDIR)/snprintf.o
OBJECTS += $(OBJDIR)/snscanf.o
OBJECTS += $(OBJDIR)/ssl_cache.o
OBJECTS += $(OBJDIR)/ssl_ciphersuites.o
OBJECTS += $(OBJDIR)/ssl_cli.o
OBJECTS += $(OBJDIR)/ssl_cookie.o
OBJECTS += $(OBJDIR)/ssl_srv.o
OBJECTS += $(OBJDIR)/ssl_ticket.o
OBJECTS += $(OBJDIR)/ssl_tls.o
OBJECTS += $(OBJDIR)/stream.o
OBJECTS += $(OBJDIR)/strscpy.o
OBJECTS += $(OBJDIR)/suggestmgr.o
OBJECTS += $(OBJDIR)/syntax_enc.o
OBJECTS += $(OBJDIR)/tcp.o
OBJECTS += $(OBJDIR)/thread.o
OBJECTS += $(OBJDIR)/thread_utils.o
OBJECTS += $(OBJDIR)/threading.o
OBJECTS += $(OBJDIR)/threadpool.o
OBJECTS += $(OBJDIR)/timer.o
OBJECTS += $(OBJDIR)/timing.o
OBJECTS += $(OBJDIR)/tl_async_io.o
OBJECTS += $(OBJDIR)/tl_base64.o
OBJECTS += $(OBJDIR)/tl_basic.o
OBJECTS += $(OBJDIR)/tl_crc32.o
OBJECTS += $(OBJDIR)/tl_datetime.o
OBJECTS += $(OBJDIR)/tl_eval_parser.o
OBJECTS += $(OBJDIR)/tl_eval_vm.o
OBJECTS += $(OBJDIR)/tl_filesystem.o
OBJECTS += $(OBJDIR)/tl_lzf.o
OBJECTS += $(OBJDIR)/tl_mm_file.o
OBJECTS += $(OBJDIR)/tl_sar.o
OBJECTS += $(OBJDIR)/tl_string.o
OBJECTS += $(OBJDIR)/tl_tokenizer.o
OBJECTS += $(OBJDIR)/tl_url.o
OBJECTS += $(OBJDIR)/tl_ustring.o
OBJECTS += $(OBJDIR)/tl_util.o
OBJECTS += $(OBJDIR)/tl_wregexp.o
OBJECTS += $(OBJDIR)/tl_zip.o
OBJECTS += $(OBJDIR)/tls_engine.o
OBJECTS += $(OBJDIR)/token_enc.o
OBJECTS += $(OBJDIR)/tree_dec.o
OBJECTS += $(OBJDIR)/tree_enc.o
OBJECTS += $(OBJDIR)/trees.o
OBJECTS += $(OBJDIR)/tty.o
OBJECTS += $(OBJDIR)/ucdata_lt.o
OBJECTS += $(OBJDIR)/udp.o
OBJECTS += $(OBJDIR)/uncompr.o
OBJECTS += $(OBJDIR)/unzip.o
OBJECTS += $(OBJDIR)/upsampling.o
OBJECTS += $(OBJDIR)/upsampling_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/upsampling_msa.o
OBJECTS += $(OBJDIR)/upsampling_neon.o
OBJECTS += $(OBJDIR)/upsampling_sse2.o
OBJECTS += $(OBJDIR)/utils.o
OBJECTS += $(OBJDIR)/uv-common.o
OBJECTS += $(OBJDIR)/uv-data-getter-setters.o
OBJECTS += $(OBJDIR)/uv_tls.o
OBJECTS += $(OBJDIR)/v_ft_math.o
OBJECTS += $(OBJDIR)/v_ft_raster.o
OBJECTS += $(OBJDIR)/v_ft_stroker.o
OBJECTS += $(OBJDIR)/varenaalloc.o
OBJECTS += $(OBJDIR)/vbezier.o
OBJECTS += $(OBJDIR)/vbitmap.o
OBJECTS += $(OBJDIR)/vbrush.o
OBJECTS += $(OBJDIR)/vdasher.o
OBJECTS += $(OBJDIR)/vdebug.o
OBJECTS += $(OBJDIR)/vdrawable.o
OBJECTS += $(OBJDIR)/vdrawhelper.o
OBJECTS += $(OBJDIR)/vdrawhelper_common.o
OBJECTS += $(OBJDIR)/vdrawhelper_neon.o
OBJECTS += $(OBJDIR)/vdrawhelper_sse2.o
OBJECTS += $(OBJDIR)/velapsedtimer.o
OBJECTS += $(OBJDIR)/version.o
OBJECTS += $(OBJDIR)/version1.o
OBJECTS += $(OBJDIR)/version_features.o
OBJECTS += $(OBJDIR)/vimageloader.o
OBJECTS += $(OBJDIR)/vinterpolator.o
OBJECTS += $(OBJDIR)/vmatrix.o
OBJECTS += $(OBJDIR)/vp8_dec.o
OBJECTS += $(OBJDIR)/vp8l_dec.o
OBJECTS += $(OBJDIR)/vp8l_enc.o
OBJECTS += $(OBJDIR)/vpainter.o
OBJECTS += $(OBJDIR)/vpath.o
OBJECTS += $(OBJDIR)/vpathmesure.o
OBJECTS += $(OBJDIR)/vraster.o
OBJECTS += $(OBJDIR)/vrect.o
OBJECTS += $(OBJDIR)/vrle.o
OBJECTS += $(OBJDIR)/webp_dec.o
OBJECTS += $(OBJDIR)/webp_enc.o
OBJECTS += $(OBJDIR)/websockets.o
OBJECTS += $(OBJDIR)/x509.o
OBJECTS += $(OBJDIR)/x509_create.o
OBJECTS += $(OBJDIR)/x509_crl.o
OBJECTS += $(OBJDIR)/x509_crt.o
OBJECTS += $(OBJDIR)/x509_csr.o
OBJECTS += $(OBJDIR)/x509write_crt.o
OBJECTS += $(OBJDIR)/x509write_csr.o
OBJECTS += $(OBJDIR)/xattributes.o
OBJECTS += $(OBJDIR)/xaudio.o
OBJECTS += $(OBJDIR)/xdialog.o
OBJECTS += $(OBJDIR)/xelement.o
OBJECTS += $(OBJDIR)/xevent.o
OBJECTS += $(OBJDIR)/xgraphics.o
OBJECTS += $(OBJDIR)/ximage.o
OBJECTS += $(OBJDIR)/xnode.o
OBJECTS += $(OBJDIR)/xrichtext.o
OBJECTS += $(OBJDIR)/xsciter.o
OBJECTS += $(OBJDIR)/xselection.o
OBJECTS += $(OBJDIR)/xstate.o
OBJECTS += $(OBJDIR)/xstyle.o
OBJECTS += $(OBJDIR)/xsymbols.o
OBJECTS += $(OBJDIR)/xtea.o
OBJECTS += $(OBJDIR)/xtokenizer.o
OBJECTS += $(OBJDIR)/xview.o
OBJECTS += $(OBJDIR)/yuv.o
OBJECTS += $(OBJDIR)/yuv_mips32.o
OBJECTS += $(OBJDIR)/yuv_mips_dsp_r2.o
OBJECTS += $(OBJDIR)/yuv_sse2.o
OBJECTS += $(OBJDIR)/zutil.o

# Rules
# #############################################

all: $(TARGET)
	@:

$(TARGET): $(OBJECTS) $(LDDEPS) | $(TARGETDIR)
	$(PRELINKCMDS)
	@echo Linking sciter.static
	$(SILENT) $(LINKCMD)
	$(POSTBUILDCMDS)

$(TARGETDIR):
	@echo Creating $(TARGETDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(TARGETDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(TARGETDIR))
endif

$(OBJDIR):
	@echo Creating $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(OBJDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(OBJDIR))
endif

clean:
	@echo Cleaning sciter.static
ifeq (posix,$(SHELLTYPE))
	$(SILENT) rm -f  $(TARGET)
	$(SILENT) rm -rf $(OBJDIR)
else
	$(SILENT) if exist $(subst /,\\,$(TARGET)) del $(subst /,\\,$(TARGET))
	$(SILENT) if exist $(subst /,\\,$(OBJDIR)) rmdir /s /q $(subst /,\\,$(OBJDIR))
endif

prebuild: | $(OBJDIR)
	$(PREBUILDCMDS)

ifneq (,$(PCH))
$(OBJECTS): $(GCH) | $(PCH_PLACEHOLDER)
$(GCH): $(PCH) | prebuild
	@echo $(notdir $<)
	$(SILENT) $(CXX) -x c++-header $(ALL_CXXFLAGS) -o "$@" -MF "$(@:%.gch=%.d)" -c "$<"
$(PCH_PLACEHOLDER): $(GCH) | $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) touch "$@"
else
	$(SILENT) echo $null >> "$@"
endif
else
$(OBJECTS): | prebuild
endif


# File Rules
# #############################################

$(OBJDIR)/affentry.o: ../../engine/external/hunspell/affentry.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/affixmgr.o: ../../engine/external/hunspell/affixmgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/csutil.o: ../../engine/external/hunspell/csutil.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filemgr.o: ../../engine/external/hunspell/filemgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hashmgr.o: ../../engine/external/hunspell/hashmgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hunspell.o: ../../engine/external/hunspell/hunspell.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hunzip.o: ../../engine/external/hunspell/hunzip.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/phonet.o: ../../engine/external/hunspell/phonet.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/replist.o: ../../engine/external/hunspell/replist.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/suggestmgr.o: ../../engine/external/hunspell/suggestmgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jaricom.o: ../../engine/external/jpeg/jaricom.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcapimin.o: ../../engine/external/jpeg/jcapimin.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcapistd.o: ../../engine/external/jpeg/jcapistd.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcarith.o: ../../engine/external/jpeg/jcarith.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jccoefct.o: ../../engine/external/jpeg/jccoefct.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jccolor.o: ../../engine/external/jpeg/jccolor.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcdctmgr.o: ../../engine/external/jpeg/jcdctmgr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jchuff.o: ../../engine/external/jpeg/jchuff.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcinit.o: ../../engine/external/jpeg/jcinit.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcmainct.o: ../../engine/external/jpeg/jcmainct.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcmarker.o: ../../engine/external/jpeg/jcmarker.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcmaster.o: ../../engine/external/jpeg/jcmaster.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcomapi.o: ../../engine/external/jpeg/jcomapi.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcparam.o: ../../engine/external/jpeg/jcparam.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcprepct.o: ../../engine/external/jpeg/jcprepct.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jcsample.o: ../../engine/external/jpeg/jcsample.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jctrans.o: ../../engine/external/jpeg/jctrans.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdapimin.o: ../../engine/external/jpeg/jdapimin.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdapistd.o: ../../engine/external/jpeg/jdapistd.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdarith.o: ../../engine/external/jpeg/jdarith.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdatadst.o: ../../engine/external/jpeg/jdatadst.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdatasrc.o: ../../engine/external/jpeg/jdatasrc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdcoefct.o: ../../engine/external/jpeg/jdcoefct.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdcolor.o: ../../engine/external/jpeg/jdcolor.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jddctmgr.o: ../../engine/external/jpeg/jddctmgr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdhuff.o: ../../engine/external/jpeg/jdhuff.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdinput.o: ../../engine/external/jpeg/jdinput.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdmainct.o: ../../engine/external/jpeg/jdmainct.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdmarker.o: ../../engine/external/jpeg/jdmarker.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdmaster.o: ../../engine/external/jpeg/jdmaster.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdmerge.o: ../../engine/external/jpeg/jdmerge.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdpostct.o: ../../engine/external/jpeg/jdpostct.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdsample.o: ../../engine/external/jpeg/jdsample.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jdtrans.o: ../../engine/external/jpeg/jdtrans.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jerror.o: ../../engine/external/jpeg/jerror.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jfdctflt.o: ../../engine/external/jpeg/jfdctflt.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jfdctfst.o: ../../engine/external/jpeg/jfdctfst.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jfdctint.o: ../../engine/external/jpeg/jfdctint.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jidctflt.o: ../../engine/external/jpeg/jidctflt.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jidctfst.o: ../../engine/external/jpeg/jidctfst.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jidctint.o: ../../engine/external/jpeg/jidctint.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jmemmgr.o: ../../engine/external/jpeg/jmemmgr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jmemnobs.o: ../../engine/external/jpeg/jmemnobs.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jquant1.o: ../../engine/external/jpeg/jquant1.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jquant2.o: ../../engine/external/jpeg/jquant2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/jutils.o: ../../engine/external/jpeg/jutils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/png.o: ../../engine/external/png/png.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngerror.o: ../../engine/external/png/pngerror.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngget.o: ../../engine/external/png/pngget.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngmem.o: ../../engine/external/png/pngmem.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngpread.o: ../../engine/external/png/pngpread.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngread.o: ../../engine/external/png/pngread.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngrio.o: ../../engine/external/png/pngrio.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngrtran.o: ../../engine/external/png/pngrtran.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngrutil.o: ../../engine/external/png/pngrutil.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngset.o: ../../engine/external/png/pngset.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngtrans.o: ../../engine/external/png/pngtrans.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngwio.o: ../../engine/external/png/pngwio.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngwrite.o: ../../engine/external/png/pngwrite.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngwtran.o: ../../engine/external/png/pngwtran.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pngwutil.o: ../../engine/external/png/pngwutil.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottieanimation.o: ../../engine/external/rlottie/src/lottie/lottieanimation.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottieitem.o: ../../engine/external/rlottie/src/lottie/lottieitem.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottieitem_capi.o: ../../engine/external/rlottie/src/lottie/lottieitem_capi.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottiekeypath.o: ../../engine/external/rlottie/src/lottie/lottiekeypath.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottieloader.o: ../../engine/external/rlottie/src/lottie/lottieloader.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottiemodel.o: ../../engine/external/rlottie/src/lottie/lottiemodel.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottieparser.o: ../../engine/external/rlottie/src/lottie/lottieparser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lottieproxymodel.o: ../../engine/external/rlottie/src/lottie/lottieproxymodel.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/v_ft_math.o: ../../engine/external/rlottie/src/vector/freetype/v_ft_math.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/v_ft_raster.o: ../../engine/external/rlottie/src/vector/freetype/v_ft_raster.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/v_ft_stroker.o: ../../engine/external/rlottie/src/vector/freetype/v_ft_stroker.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/varenaalloc.o: ../../engine/external/rlottie/src/vector/varenaalloc.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vbezier.o: ../../engine/external/rlottie/src/vector/vbezier.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vbitmap.o: ../../engine/external/rlottie/src/vector/vbitmap.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vbrush.o: ../../engine/external/rlottie/src/vector/vbrush.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdasher.o: ../../engine/external/rlottie/src/vector/vdasher.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdebug.o: ../../engine/external/rlottie/src/vector/vdebug.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdrawable.o: ../../engine/external/rlottie/src/vector/vdrawable.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdrawhelper.o: ../../engine/external/rlottie/src/vector/vdrawhelper.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdrawhelper_common.o: ../../engine/external/rlottie/src/vector/vdrawhelper_common.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdrawhelper_neon.o: ../../engine/external/rlottie/src/vector/vdrawhelper_neon.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vdrawhelper_sse2.o: ../../engine/external/rlottie/src/vector/vdrawhelper_sse2.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/velapsedtimer.o: ../../engine/external/rlottie/src/vector/velapsedtimer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vimageloader.o: ../../engine/external/rlottie/src/vector/vimageloader.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vinterpolator.o: ../../engine/external/rlottie/src/vector/vinterpolator.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vmatrix.o: ../../engine/external/rlottie/src/vector/vmatrix.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vpainter.o: ../../engine/external/rlottie/src/vector/vpainter.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vpath.o: ../../engine/external/rlottie/src/vector/vpath.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vpathmesure.o: ../../engine/external/rlottie/src/vector/vpathmesure.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vraster.o: ../../engine/external/rlottie/src/vector/vraster.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vrect.o: ../../engine/external/rlottie/src/vector/vrect.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vrle.o: ../../engine/external/rlottie/src/vector/vrle.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/bio.o: ../../engine/external/uv-tls/src/bio.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/aes.o: ../../engine/external/uv-tls/src/mbedtls/aes.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/aesni.o: ../../engine/external/uv-tls/src/mbedtls/aesni.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/arc4.o: ../../engine/external/uv-tls/src/mbedtls/arc4.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/asn1parse.o: ../../engine/external/uv-tls/src/mbedtls/asn1parse.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/asn1write.o: ../../engine/external/uv-tls/src/mbedtls/asn1write.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/base64.o: ../../engine/external/uv-tls/src/mbedtls/base64.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/bignum.o: ../../engine/external/uv-tls/src/mbedtls/bignum.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/blowfish.o: ../../engine/external/uv-tls/src/mbedtls/blowfish.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/camellia.o: ../../engine/external/uv-tls/src/mbedtls/camellia.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ccm.o: ../../engine/external/uv-tls/src/mbedtls/ccm.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/certs.o: ../../engine/external/uv-tls/src/mbedtls/certs.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cipher.o: ../../engine/external/uv-tls/src/mbedtls/cipher.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cipher_wrap.o: ../../engine/external/uv-tls/src/mbedtls/cipher_wrap.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cmac.o: ../../engine/external/uv-tls/src/mbedtls/cmac.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ctr_drbg.o: ../../engine/external/uv-tls/src/mbedtls/ctr_drbg.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/debug.o: ../../engine/external/uv-tls/src/mbedtls/debug.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/des.o: ../../engine/external/uv-tls/src/mbedtls/des.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dhm.o: ../../engine/external/uv-tls/src/mbedtls/dhm.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecdh.o: ../../engine/external/uv-tls/src/mbedtls/ecdh.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecdsa.o: ../../engine/external/uv-tls/src/mbedtls/ecdsa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecjpake.o: ../../engine/external/uv-tls/src/mbedtls/ecjpake.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecp.o: ../../engine/external/uv-tls/src/mbedtls/ecp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecp_curves.o: ../../engine/external/uv-tls/src/mbedtls/ecp_curves.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/entropy.o: ../../engine/external/uv-tls/src/mbedtls/entropy.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/entropy_poll.o: ../../engine/external/uv-tls/src/mbedtls/entropy_poll.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/error.o: ../../engine/external/uv-tls/src/mbedtls/error.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gcm.o: ../../engine/external/uv-tls/src/mbedtls/gcm.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/havege.o: ../../engine/external/uv-tls/src/mbedtls/havege.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hmac_drbg.o: ../../engine/external/uv-tls/src/mbedtls/hmac_drbg.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md.o: ../../engine/external/uv-tls/src/mbedtls/md.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md2.o: ../../engine/external/uv-tls/src/mbedtls/md2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md4.o: ../../engine/external/uv-tls/src/mbedtls/md4.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md5.o: ../../engine/external/uv-tls/src/mbedtls/md5.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md_wrap.o: ../../engine/external/uv-tls/src/mbedtls/md_wrap.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/memory_buffer_alloc.o: ../../engine/external/uv-tls/src/mbedtls/memory_buffer_alloc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/net_sockets.o: ../../engine/external/uv-tls/src/mbedtls/net_sockets.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/oid.o: ../../engine/external/uv-tls/src/mbedtls/oid.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/padlock.o: ../../engine/external/uv-tls/src/mbedtls/padlock.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pem.o: ../../engine/external/uv-tls/src/mbedtls/pem.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pk.o: ../../engine/external/uv-tls/src/mbedtls/pk.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pk_wrap.o: ../../engine/external/uv-tls/src/mbedtls/pk_wrap.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkcs11.o: ../../engine/external/uv-tls/src/mbedtls/pkcs11.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkcs12.o: ../../engine/external/uv-tls/src/mbedtls/pkcs12.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkcs5.o: ../../engine/external/uv-tls/src/mbedtls/pkcs5.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkparse.o: ../../engine/external/uv-tls/src/mbedtls/pkparse.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkwrite.o: ../../engine/external/uv-tls/src/mbedtls/pkwrite.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/platform.o: ../../engine/external/uv-tls/src/mbedtls/platform.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ripemd160.o: ../../engine/external/uv-tls/src/mbedtls/ripemd160.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rsa.o: ../../engine/external/uv-tls/src/mbedtls/rsa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rsa_internal.o: ../../engine/external/uv-tls/src/mbedtls/rsa_internal.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/sha1.o: ../../engine/external/uv-tls/src/mbedtls/sha1.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/sha256.o: ../../engine/external/uv-tls/src/mbedtls/sha256.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/sha512.o: ../../engine/external/uv-tls/src/mbedtls/sha512.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_cache.o: ../../engine/external/uv-tls/src/mbedtls/ssl_cache.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_ciphersuites.o: ../../engine/external/uv-tls/src/mbedtls/ssl_ciphersuites.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_cli.o: ../../engine/external/uv-tls/src/mbedtls/ssl_cli.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_cookie.o: ../../engine/external/uv-tls/src/mbedtls/ssl_cookie.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_srv.o: ../../engine/external/uv-tls/src/mbedtls/ssl_srv.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_ticket.o: ../../engine/external/uv-tls/src/mbedtls/ssl_ticket.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_tls.o: ../../engine/external/uv-tls/src/mbedtls/ssl_tls.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/threading.o: ../../engine/external/uv-tls/src/mbedtls/threading.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/timing.o: ../../engine/external/uv-tls/src/mbedtls/timing.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/version.o: ../../engine/external/uv-tls/src/mbedtls/version.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/version_features.o: ../../engine/external/uv-tls/src/mbedtls/version_features.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509.o: ../../engine/external/uv-tls/src/mbedtls/x509.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_create.o: ../../engine/external/uv-tls/src/mbedtls/x509_create.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_crl.o: ../../engine/external/uv-tls/src/mbedtls/x509_crl.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_crt.o: ../../engine/external/uv-tls/src/mbedtls/x509_crt.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_csr.o: ../../engine/external/uv-tls/src/mbedtls/x509_csr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509write_crt.o: ../../engine/external/uv-tls/src/mbedtls/x509write_crt.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509write_csr.o: ../../engine/external/uv-tls/src/mbedtls/x509write_csr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xtea.o: ../../engine/external/uv-tls/src/mbedtls/xtea.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tls_engine.o: ../../engine/external/uv-tls/src/tls_engine.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uv_tls.o: ../../engine/external/uv-tls/src/uv_tls.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/fs-poll.o: ../../engine/external/uv/src/fs-poll.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/idna.o: ../../engine/external/uv/src/idna.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inet.o: ../../engine/external/uv/src/inet.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random.o: ../../engine/external/uv/src/random.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/strscpy.o: ../../engine/external/uv/src/strscpy.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/threadpool.o: ../../engine/external/uv/src/threadpool.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/timer.o: ../../engine/external/uv/src/timer.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/async.o: ../../engine/external/uv/src/unix/async.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/core.o: ../../engine/external/uv/src/unix/core.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dl.o: ../../engine/external/uv/src/unix/dl.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/fs.o: ../../engine/external/uv/src/unix/fs.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/getaddrinfo.o: ../../engine/external/uv/src/unix/getaddrinfo.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/getnameinfo.o: ../../engine/external/uv/src/unix/getnameinfo.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux-core.o: ../../engine/external/uv/src/unix/linux-core.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux-inotify.o: ../../engine/external/uv/src/unix/linux-inotify.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux-syscalls.o: ../../engine/external/uv/src/unix/linux-syscalls.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/loop-watcher.o: ../../engine/external/uv/src/unix/loop-watcher.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/loop.o: ../../engine/external/uv/src/unix/loop.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pipe.o: ../../engine/external/uv/src/unix/pipe.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/poll.o: ../../engine/external/uv/src/unix/poll.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/process.o: ../../engine/external/uv/src/unix/process.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/procfs-exepath.o: ../../engine/external/uv/src/unix/procfs-exepath.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/proctitle.o: ../../engine/external/uv/src/unix/proctitle.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random-devurandom.o: ../../engine/external/uv/src/unix/random-devurandom.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random-getrandom.o: ../../engine/external/uv/src/unix/random-getrandom.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random-sysctl-linux.o: ../../engine/external/uv/src/unix/random-sysctl-linux.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/signal.o: ../../engine/external/uv/src/unix/signal.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/stream.o: ../../engine/external/uv/src/unix/stream.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tcp.o: ../../engine/external/uv/src/unix/tcp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/thread.o: ../../engine/external/uv/src/unix/thread.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tty.o: ../../engine/external/uv/src/unix/tty.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/udp.o: ../../engine/external/uv/src/unix/udp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uv-common.o: ../../engine/external/uv/src/uv-common.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uv-data-getter-setters.o: ../../engine/external/uv/src/uv-data-getter-setters.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/version1.o: ../../engine/external/uv/src/version.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_dec.o: ../../engine/external/webp/src/dec/alpha_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/buffer_dec.o: ../../engine/external/webp/src/dec/buffer_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/frame_dec.o: ../../engine/external/webp/src/dec/frame_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/idec_dec.o: ../../engine/external/webp/src/dec/idec_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/io_dec.o: ../../engine/external/webp/src/dec/io_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quant_dec.o: ../../engine/external/webp/src/dec/quant_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tree_dec.o: ../../engine/external/webp/src/dec/tree_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vp8_dec.o: ../../engine/external/webp/src/dec/vp8_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vp8l_dec.o: ../../engine/external/webp/src/dec/vp8l_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/webp_dec.o: ../../engine/external/webp/src/dec/webp_dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/anim_decode.o: ../../engine/external/webp/src/demux/anim_decode.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/demux.o: ../../engine/external/webp/src/demux/demux.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_processing.o: ../../engine/external/webp/src/dsp/alpha_processing.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_processing_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/alpha_processing_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_processing_neon.o: ../../engine/external/webp/src/dsp/alpha_processing_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_processing_sse2.o: ../../engine/external/webp/src/dsp/alpha_processing_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_processing_sse41.o: ../../engine/external/webp/src/dsp/alpha_processing_sse41.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/argb.o: ../../engine/external/webp/src/dsp/argb.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/argb_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/argb_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/argb_sse2.o: ../../engine/external/webp/src/dsp/argb_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cost.o: ../../engine/external/webp/src/dsp/cost.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cost_mips32.o: ../../engine/external/webp/src/dsp/cost_mips32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cost_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/cost_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cost_sse2.o: ../../engine/external/webp/src/dsp/cost_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cpu.o: ../../engine/external/webp/src/dsp/cpu.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec.o: ../../engine/external/webp/src/dsp/dec.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_clip_tables.o: ../../engine/external/webp/src/dsp/dec_clip_tables.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_mips32.o: ../../engine/external/webp/src/dsp/dec_mips32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/dec_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_msa.o: ../../engine/external/webp/src/dsp/dec_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_neon.o: ../../engine/external/webp/src/dsp/dec_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_sse2.o: ../../engine/external/webp/src/dsp/dec_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dec_sse41.o: ../../engine/external/webp/src/dsp/dec_sse41.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc.o: ../../engine/external/webp/src/dsp/enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_avx2.o: ../../engine/external/webp/src/dsp/enc_avx2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_mips32.o: ../../engine/external/webp/src/dsp/enc_mips32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/enc_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_msa.o: ../../engine/external/webp/src/dsp/enc_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_neon.o: ../../engine/external/webp/src/dsp/enc_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_sse2.o: ../../engine/external/webp/src/dsp/enc_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/enc_sse41.o: ../../engine/external/webp/src/dsp/enc_sse41.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filters.o: ../../engine/external/webp/src/dsp/filters.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filters_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/filters_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filters_msa.o: ../../engine/external/webp/src/dsp/filters_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filters_neon.o: ../../engine/external/webp/src/dsp/filters_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filters_sse2.o: ../../engine/external/webp/src/dsp/filters_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless.o: ../../engine/external/webp/src/dsp/lossless.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc.o: ../../engine/external/webp/src/dsp/lossless_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc_mips32.o: ../../engine/external/webp/src/dsp/lossless_enc_mips32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/lossless_enc_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc_msa.o: ../../engine/external/webp/src/dsp/lossless_enc_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc_neon.o: ../../engine/external/webp/src/dsp/lossless_enc_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc_sse2.o: ../../engine/external/webp/src/dsp/lossless_enc_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_enc_sse41.o: ../../engine/external/webp/src/dsp/lossless_enc_sse41.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/lossless_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_msa.o: ../../engine/external/webp/src/dsp/lossless_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_neon.o: ../../engine/external/webp/src/dsp/lossless_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/lossless_sse2.o: ../../engine/external/webp/src/dsp/lossless_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler.o: ../../engine/external/webp/src/dsp/rescaler.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler_mips32.o: ../../engine/external/webp/src/dsp/rescaler_mips32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/rescaler_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler_msa.o: ../../engine/external/webp/src/dsp/rescaler_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler_neon.o: ../../engine/external/webp/src/dsp/rescaler_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler_sse2.o: ../../engine/external/webp/src/dsp/rescaler_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/upsampling.o: ../../engine/external/webp/src/dsp/upsampling.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/upsampling_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/upsampling_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/upsampling_msa.o: ../../engine/external/webp/src/dsp/upsampling_msa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/upsampling_neon.o: ../../engine/external/webp/src/dsp/upsampling_neon.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/upsampling_sse2.o: ../../engine/external/webp/src/dsp/upsampling_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/yuv.o: ../../engine/external/webp/src/dsp/yuv.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/yuv_mips32.o: ../../engine/external/webp/src/dsp/yuv_mips32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/yuv_mips_dsp_r2.o: ../../engine/external/webp/src/dsp/yuv_mips_dsp_r2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/yuv_sse2.o: ../../engine/external/webp/src/dsp/yuv_sse2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/alpha_enc.o: ../../engine/external/webp/src/enc/alpha_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/analysis_enc.o: ../../engine/external/webp/src/enc/analysis_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/backward_references_enc.o: ../../engine/external/webp/src/enc/backward_references_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/config_enc.o: ../../engine/external/webp/src/enc/config_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cost_enc.o: ../../engine/external/webp/src/enc/cost_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/delta_palettization_enc.o: ../../engine/external/webp/src/enc/delta_palettization_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filter_enc.o: ../../engine/external/webp/src/enc/filter_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/frame_enc.o: ../../engine/external/webp/src/enc/frame_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/histogram_enc.o: ../../engine/external/webp/src/enc/histogram_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/iterator_enc.o: ../../engine/external/webp/src/enc/iterator_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/near_lossless_enc.o: ../../engine/external/webp/src/enc/near_lossless_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/picture_csp_enc.o: ../../engine/external/webp/src/enc/picture_csp_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/picture_enc.o: ../../engine/external/webp/src/enc/picture_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/picture_psnr_enc.o: ../../engine/external/webp/src/enc/picture_psnr_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/picture_rescale_enc.o: ../../engine/external/webp/src/enc/picture_rescale_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/picture_tools_enc.o: ../../engine/external/webp/src/enc/picture_tools_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/predictor_enc.o: ../../engine/external/webp/src/enc/predictor_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quant_enc.o: ../../engine/external/webp/src/enc/quant_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/syntax_enc.o: ../../engine/external/webp/src/enc/syntax_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/token_enc.o: ../../engine/external/webp/src/enc/token_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tree_enc.o: ../../engine/external/webp/src/enc/tree_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/vp8l_enc.o: ../../engine/external/webp/src/enc/vp8l_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/webp_enc.o: ../../engine/external/webp/src/enc/webp_enc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/bit_reader_utils.o: ../../engine/external/webp/src/utils/bit_reader_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/bit_writer_utils.o: ../../engine/external/webp/src/utils/bit_writer_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/color_cache_utils.o: ../../engine/external/webp/src/utils/color_cache_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filters_utils.o: ../../engine/external/webp/src/utils/filters_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/huffman_encode_utils.o: ../../engine/external/webp/src/utils/huffman_encode_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/huffman_utils.o: ../../engine/external/webp/src/utils/huffman_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quant_levels_dec_utils.o: ../../engine/external/webp/src/utils/quant_levels_dec_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quant_levels_utils.o: ../../engine/external/webp/src/utils/quant_levels_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random_utils.o: ../../engine/external/webp/src/utils/random_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rescaler_utils.o: ../../engine/external/webp/src/utils/rescaler_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/thread_utils.o: ../../engine/external/webp/src/utils/thread_utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/utils.o: ../../engine/external/webp/src/utils/utils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/adler32.o: ../../engine/external/zlib/adler32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/compress.o: ../../engine/external/zlib/compress.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/crc32.o: ../../engine/external/zlib/crc32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/deflate.o: ../../engine/external/zlib/deflate.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inffast.o: ../../engine/external/zlib/inffast.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inflate.o: ../../engine/external/zlib/inflate.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inftrees.o: ../../engine/external/zlib/inftrees.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ioapi.o: ../../engine/external/zlib/ioapi.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/trees.o: ../../engine/external/zlib/trees.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uncompr.o: ../../engine/external/zlib/uncompr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/unzip.o: ../../engine/external/zlib/unzip.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/zutil.o: ../../engine/external/zlib/zutil.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-exif.o: ../../engine/gool/gool-exif.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-figures.o: ../../engine/gool/gool-figures.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-font.o: ../../engine/gool/gool-font.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-gif-io.o: ../../engine/gool/gool-gif-io.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-graphics.o: ../../engine/gool/gool-graphics.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-icon.o: ../../engine/gool/gool-icon.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-image-blur.o: ../../engine/gool/gool-image-blur.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-image-io.o: ../../engine/gool/gool-image-io.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-image-transformation.o: ../../engine/gool/gool-image-transformation.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-image.o: ../../engine/gool/gool-image.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-theme.o: ../../engine/gool/gool-theme.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gool-types.o: ../../engine/gool/gool-types.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-actions-ops.o: ../../engine/html/html-actions-ops.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-actions-stack.o: ../../engine/html/html-actions-stack.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-animator-blend.o: ../../engine/html/html-animator-blend.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-animator-css.o: ../../engine/html/html-animator-css.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-animator-image.o: ../../engine/html/html-animator-image.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-animator-scroll.o: ../../engine/html/html-animator-scroll.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-animator.o: ../../engine/html/html-animator.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-behavior.o: ../../engine/html/html-behavior.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-clipboard.o: ../../engine/html/html-clipboard.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-css-istream.o: ../../engine/html/html-css-istream.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-css-script.o: ../../engine/html/html-css-script.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-buttons.o: ../../engine/html/html-ctl-buttons.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-column-resizer.o: ../../engine/html/html-ctl-column-resizer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-date.o: ../../engine/html/html-ctl-date.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-dropdown-select.o: ../../engine/html/html-ctl-dropdown-select.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-edit.o: ../../engine/html/html-ctl-edit.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-effects.o: ../../engine/html/html-ctl-effects.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-frame.o: ../../engine/html/html-ctl-frame.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-highlighted.o: ../../engine/html/html-ctl-highlighted.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-htmlarea.o: ../../engine/html/html-ctl-htmlarea.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-hyperlink.o: ../../engine/html/html-ctl-hyperlink.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-image.o: ../../engine/html/html-ctl-image.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-lists.o: ../../engine/html/html-ctl-lists.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-lottie.o: ../../engine/html/html-ctl-lottie.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-masked-edit.o: ../../engine/html/html-ctl-masked-edit.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-menu.o: ../../engine/html/html-ctl-menu.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-numeric.o: ../../engine/html/html-ctl-numeric.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-output.o: ../../engine/html/html-ctl-output.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-pager.o: ../../engine/html/html-ctl-pager.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-plaintext.o: ../../engine/html/html-ctl-plaintext.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-progress.o: ../../engine/html/html-ctl-progress.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-richtext.o: ../../engine/html/html-ctl-richtext.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-scrollbar.o: ../../engine/html/html-ctl-scrollbar.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-select.o: ../../engine/html/html-ctl-select.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-slider.o: ../../engine/html/html-ctl-slider.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-swipe.o: ../../engine/html/html-ctl-swipe.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-textarea.o: ../../engine/html/html-ctl-textarea.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-video-zero.o: ../../engine/html/html-ctl-video-zero.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-video.o: ../../engine/html/html-ctl-video.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-ctl-virtual-list.o: ../../engine/html/html-ctl-virtual-list.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-document.o: ../../engine/html/html-document.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-dom.o: ../../engine/html/html-dom.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-drag-n-drop.o: ../../engine/html/html-drag-n-drop.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-drawing.o: ../../engine/html/html-drawing.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-emit.o: ../../engine/html/html-emit.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-event-handlers.o: ../../engine/html/html-event-handlers.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-float-ctx.o: ../../engine/html/html-float-ctx.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-intrinsic-styles.o: ../../engine/html/html-intrinsic-styles.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-columns.o: ../../engine/html/html-layout-columns.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-default.o: ../../engine/html/html-layout-default.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-grid.o: ../../engine/html/html-layout-grid.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-horizontal-wrap.o: ../../engine/html/html-layout-horizontal-wrap.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-horizontal.o: ../../engine/html/html-layout-horizontal.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-image.o: ../../engine/html/html-layout-image.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-stack.o: ../../engine/html/html-layout-stack.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-svg.o: ../../engine/html/html-layout-svg.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-table-body.o: ../../engine/html/html-layout-table-body.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-table.o: ../../engine/html/html-layout-table.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-template.o: ../../engine/html/html-layout-template.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-text-analysis.o: ../../engine/html/html-layout-text-analysis.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-text-flow.o: ../../engine/html/html-layout-text-flow.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-text.o: ../../engine/html/html-layout-text.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-vertical-wrap.o: ../../engine/html/html-layout-vertical-wrap.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout-vertical.o: ../../engine/html/html-layout-vertical.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-layout.o: ../../engine/html/html-layout.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-parser.o: ../../engine/html/html-parser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-primitives.o: ../../engine/html/html-primitives.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-pump.o: ../../engine/html/html-pump.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-scrollbar.o: ../../engine/html/html-scrollbar.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-streams.o: ../../engine/html/html-streams.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-style-parser.o: ../../engine/html/html-style-parser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-style-prop-list.o: ../../engine/html/html-style-prop-list.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-style-property.o: ../../engine/html/html-style-property.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-style-types.o: ../../engine/html/html-style-types.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-style.o: ../../engine/html/html-style.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-svg-image.o: ../../engine/html/html-svg-image.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-symbols.o: ../../engine/html/html-symbols.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-touch.o: ../../engine/html/html-touch.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-view-events.o: ../../engine/html/html-view-events.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-view-focus.o: ../../engine/html/html-view-focus.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-view-update-queue.o: ../../engine/html/html-view-update-queue.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-view.o: ../../engine/html/html-view.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/html-z-ctx.o: ../../engine/html/html-z-ctx.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux_http_pump_curl.o: ../../engine/html/ports/linux_http_pump_curl.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_com.o: ../../engine/tiscript/com/cs_com.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_eval.o: ../../engine/tiscript/com/cs_eval.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_scn.o: ../../engine/tiscript/com/cs_scn.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_wcode.o: ../../engine/tiscript/com/cs_wcode.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/btree.o: ../../engine/tiscript/dybase/src/btree.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/database.o: ../../engine/tiscript/dybase/src/database.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dybase.o: ../../engine/tiscript/dybase/src/dybase.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/file.o: ../../engine/tiscript/dybase/src/file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pagepool.o: ../../engine/tiscript/dybase/src/pagepool.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_angle.o: ../../engine/tiscript/int/cs_angle.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_api.o: ../../engine/tiscript/int/cs_api.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_asset.o: ../../engine/tiscript/int/cs_asset.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_bytevector.o: ../../engine/tiscript/int/cs_bytevector.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_cobject.o: ../../engine/tiscript/int/cs_cobject.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_color.o: ../../engine/tiscript/int/cs_color.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_datetime.o: ../../engine/tiscript/int/cs_datetime.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_debug.o: ../../engine/tiscript/int/cs_debug.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_duration.o: ../../engine/tiscript/int/cs_duration.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_enter.o: ../../engine/tiscript/int/cs_enter.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_env.o: ../../engine/tiscript/int/cs_env.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_error.o: ../../engine/tiscript/int/cs_error.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_fcn.o: ../../engine/tiscript/int/cs_fcn.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_file.o: ../../engine/tiscript/int/cs_file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_float.o: ../../engine/tiscript/int/cs_float.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_hash.o: ../../engine/tiscript/int/cs_hash.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_heap.o: ../../engine/tiscript/int/cs_heap.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_instanceof.o: ../../engine/tiscript/int/cs_instanceof.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_int.o: ../../engine/tiscript/int/cs_int.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_integer.o: ../../engine/tiscript/int/cs_integer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_json.o: ../../engine/tiscript/int/cs_json.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_length.o: ../../engine/tiscript/int/cs_length.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_math.o: ../../engine/tiscript/int/cs_math.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_method.o: ../../engine/tiscript/int/cs_method.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_net.o: ../../engine/tiscript/int/cs_net.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_object.o: ../../engine/tiscript/int/cs_object.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_parse.o: ../../engine/tiscript/int/cs_parse.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_persistent.o: ../../engine/tiscript/int/cs_persistent.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_printf.o: ../../engine/tiscript/int/cs_printf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_rcode.o: ../../engine/tiscript/int/cs_rcode.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_regexp.o: ../../engine/tiscript/int/cs_regexp.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_storage.o: ../../engine/tiscript/int/cs_storage.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_stream.o: ../../engine/tiscript/int/cs_stream.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_string.o: ../../engine/tiscript/int/cs_string.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_symbol.o: ../../engine/tiscript/int/cs_symbol.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_system.o: ../../engine/tiscript/int/cs_system.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_type.o: ../../engine/tiscript/int/cs_type.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_vector.o: ../../engine/tiscript/int/cs_vector.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_vm.o: ../../engine/tiscript/int/cs_vm.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_xml_parser.o: ../../engine/tiscript/int/cs_xml_parser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_eval_parser.o: ../../engine/tool/eval/tl_eval_parser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_eval_vm.o: ../../engine/tool/eval/tl_eval_vm.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux_specifics.o: ../../engine/tool/ports/linux_specifics.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux_spell_checker.o: ../../engine/tool/ports/linux_spell_checker.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/re.o: ../../engine/tool/re/re.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/snprintf.o: ../../engine/tool/snprintf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/snscanf.o: ../../engine/tool/snscanf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_async_io.o: ../../engine/tool/tl_async_io.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_base64.o: ../../engine/tool/tl_base64.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_basic.o: ../../engine/tool/tl_basic.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_crc32.o: ../../engine/tool/tl_crc32.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_datetime.o: ../../engine/tool/tl_datetime.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_filesystem.o: ../../engine/tool/tl_filesystem.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_lzf.o: ../../engine/tool/tl_lzf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_mm_file.o: ../../engine/tool/tl_mm_file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_sar.o: ../../engine/tool/tl_sar.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_string.o: ../../engine/tool/tl_string.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_tokenizer.o: ../../engine/tool/tl_tokenizer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_url.o: ../../engine/tool/tl_url.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_ustring.o: ../../engine/tool/tl_ustring.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_util.o: ../../engine/tool/tl_util.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_wregexp.o: ../../engine/tool/tl_wregexp.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_zip.o: ../../engine/tool/tl_zip.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ucdata_lt.o: ../../engine/tool/ucdata/ucdata_lt.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/websockets.o: ../../engine/tool/websockets/websockets.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xattributes.o: ../../engine/xdom/xattributes.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xaudio.o: ../../engine/xdom/xaudio.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xdialog.o: ../../engine/xdom/xdialog.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xelement.o: ../../engine/xdom/xelement.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xevent.o: ../../engine/xdom/xevent.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xgraphics.o: ../../engine/xdom/xgraphics.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ximage.o: ../../engine/xdom/ximage.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xnode.o: ../../engine/xdom/xnode.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xrichtext.o: ../../engine/xdom/xrichtext.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xsciter.o: ../../engine/xdom/xsciter.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xselection.o: ../../engine/xdom/xselection.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xstate.o: ../../engine/xdom/xstate.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xstyle.o: ../../engine/xdom/xstyle.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xsymbols.o: ../../engine/xdom/xsymbols.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xtokenizer.o: ../../engine/xdom/xtokenizer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xview.o: ../../engine/xdom/xview.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-application.o: ../../gtk/gtk-application.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-clipboard.o: ../../gtk/gtk-clipboard.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-cursor.o: ../../gtk/gtk-cursor.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-gool.o: ../../gtk/gtk-gool.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-graphics.o: ../../gtk/gtk-graphics.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-iwindow.o: ../../gtk/gtk-iwindow.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-popup.o: ../../gtk/gtk-popup.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-sciter-api.o: ../../gtk/gtk-sciter-api.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-text-analysis.o: ../../gtk/gtk-text-analysis.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-theme.o: ../../gtk/gtk-theme.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-view.o: ../../gtk/gtk-view.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gtk-window-api.o: ../../gtk/gtk-window-api.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"

-include $(OBJECTS:%.o=%.d)
ifneq (,$(PCH))
  -include $(PCH_PLACEHOLDER).d
endif