# Alternative GNU Make project makefile autogenerated by Premake

ifndef config
  config=debug_x32
endif

ifndef verbose
  SILENT = @
endif

.PHONY: clean prebuild

SHELLTYPE := posix
ifeq (.exe,$(findstring .exe,$(ComSpec)))
	SHELLTYPE := msdos
endif

# Configurations
# #############################################

RESCOMP = windres
TARGETDIR = ../../../sdk.js/bin/linux
TARGET = $(TARGETDIR)/qjsc
INCLUDES += -I../../../engine/quickjs -I../../../engine/quickjs/storage/dybase/include
FORCE_INCLUDE +=
ALL_CPPFLAGS += $(CPPFLAGS) -MMD -MP $(DEFINES) $(INCLUDES)
ALL_RESFLAGS += $(RESFLAGS) $(DEFINES) $(INCLUDES)
LIBS +=
LDDEPS +=
LINKCMD = $(CXX) -o "$@" $(OBJECTS) $(RESOURCES) $(ALL_LDFLAGS) $(LIBS)
define PREBUILDCMDS
endef
define PRELINKCMDS
endef
define POSTBUILDCMDS
endef

ifeq ($(config),debug_x32)
OBJDIR = obj/x32/Debug/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m32 -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m32 -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib32 -m32 -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),debug_x64)
OBJDIR = obj/x64/Debug/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m64 -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m64 -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib64 -m64 -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),debug_arm32)
OBJDIR = obj/arm32/Debug/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),debug_arm64)
OBJDIR = obj/arm64/Debug/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),release_x32)
OBJDIR = obj/x32/Release/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m32 -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m32 -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib32 -m32 -flto -s -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),release_x64)
OBJDIR = obj/x64/Release/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m64 -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m64 -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib64 -m64 -flto -s -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),release_arm32)
OBJDIR = obj/arm32/Release/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -flto -s -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

else ifeq ($(config),release_arm64)
OBJDIR = obj/arm64/Release/qjsc
DEFINES += -DDEVICE=IOT -DJS_STRICT_NAN_BOXING -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE -DCONFIG_BIGNUM -DCONFIG_JSX -DCONFIG_JSX_SCITER -DCONFIG_DEBUGGER -DCONFIG_STORAGE -DCONFIG_OBJECT_LITERAL_CALL
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -flto -s -static-libstdc++ -latomic -fPIC -fexceptions -pthread -lm -Wl,--no-undefined -ldl

endif

# Per File Configurations
# #############################################


# File sets
# #############################################

GENERATED :=
OBJECTS :=

GENERATED += $(OBJDIR)/btree.o
GENERATED += $(OBJDIR)/cutils.o
GENERATED += $(OBJDIR)/database.o
GENERATED += $(OBJDIR)/dybase.o
GENERATED += $(OBJDIR)/file.o
GENERATED += $(OBJDIR)/libbf.o
GENERATED += $(OBJDIR)/libregexp.o
GENERATED += $(OBJDIR)/libunicode.o
GENERATED += $(OBJDIR)/pagepool.o
GENERATED += $(OBJDIR)/qjsc.o
GENERATED += $(OBJDIR)/quickjs-libc.o
GENERATED += $(OBJDIR)/quickjs-storage.o
GENERATED += $(OBJDIR)/quickjs.o
OBJECTS += $(OBJDIR)/btree.o
OBJECTS += $(OBJDIR)/cutils.o
OBJECTS += $(OBJDIR)/database.o
OBJECTS += $(OBJDIR)/dybase.o
OBJECTS += $(OBJDIR)/file.o
OBJECTS += $(OBJDIR)/libbf.o
OBJECTS += $(OBJDIR)/libregexp.o
OBJECTS += $(OBJDIR)/libunicode.o
OBJECTS += $(OBJDIR)/pagepool.o
OBJECTS += $(OBJDIR)/qjsc.o
OBJECTS += $(OBJDIR)/quickjs-libc.o
OBJECTS += $(OBJDIR)/quickjs-storage.o
OBJECTS += $(OBJDIR)/quickjs.o

# Rules
# #############################################

all: $(TARGET)
	@:

$(TARGET): $(GENERATED) $(OBJECTS) $(LDDEPS) | $(TARGETDIR)
	$(PRELINKCMDS)
	@echo Linking qjsc
	$(SILENT) $(LINKCMD)
	$(POSTBUILDCMDS)

$(TARGETDIR):
	@echo Creating $(TARGETDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(TARGETDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(TARGETDIR))
endif

$(OBJDIR):
	@echo Creating $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(OBJDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(OBJDIR))
endif

clean:
	@echo Cleaning qjsc
ifeq (posix,$(SHELLTYPE))
	$(SILENT) rm -f  $(TARGET)
	$(SILENT) rm -rf $(GENERATED)
	$(SILENT) rm -rf $(OBJDIR)
else
	$(SILENT) if exist $(subst /,\\,$(TARGET)) del $(subst /,\\,$(TARGET))
	$(SILENT) if exist $(subst /,\\,$(GENERATED)) rmdir /s /q $(subst /,\\,$(GENERATED))
	$(SILENT) if exist $(subst /,\\,$(OBJDIR)) rmdir /s /q $(subst /,\\,$(OBJDIR))
endif

prebuild: | $(OBJDIR)
	$(PREBUILDCMDS)

ifneq (,$(PCH))
$(OBJECTS): $(GCH) | $(PCH_PLACEHOLDER)
$(GCH): $(PCH) | prebuild
	@echo $(notdir $<)
	$(SILENT) $(CXX) -x c++-header $(ALL_CXXFLAGS) -o "$@" -MF "$(@:%.gch=%.d)" -c "$<"
$(PCH_PLACEHOLDER): $(GCH) | $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) touch "$@"
else
	$(SILENT) echo $null >> "$@"
endif
else
$(OBJECTS): | prebuild
endif


# File Rules
# #############################################

$(OBJDIR)/cutils.o: ../../../engine/quickjs/cutils.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/libbf.o: ../../../engine/quickjs/libbf.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/libregexp.o: ../../../engine/quickjs/libregexp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/libunicode.o: ../../../engine/quickjs/libunicode.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/qjsc.o: ../../../engine/quickjs/qjsc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quickjs-libc.o: ../../../engine/quickjs/quickjs-libc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quickjs.o: ../../../engine/quickjs/quickjs.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/btree.o: ../../../engine/quickjs/storage/dybase/src/btree.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/database.o: ../../../engine/quickjs/storage/dybase/src/database.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dybase.o: ../../../engine/quickjs/storage/dybase/src/dybase.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/file.o: ../../../engine/quickjs/storage/dybase/src/file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pagepool.o: ../../../engine/quickjs/storage/dybase/src/pagepool.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/quickjs-storage.o: ../../../engine/quickjs/storage/quickjs-storage.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"

-include $(OBJECTS:%.o=%.d)
ifneq (,$(PCH))
  -include $(PCH_PLACEHOLDER).d
endif