#include "xgl-window.h"

namespace xgl {

//  bool need_gpu( iwindow* pw ) {
//  }

  bool popup::setup_backend()
  {
    /*
    if (_requested_graphics == SKIA_OPENGL_GRAPHICS) {
      _device = new DeviceOpenGL(this);
      if (!_device)
        return false;
      if (_device->attach())
        return true;
      // no luck, fallback to raster
    }// */
    _device = new DeviceRaster(this);
    return _device->attach();
  }

  void popup::attached(HWINDOW hw) {
    super::attached(hw);
    setup_backend();
  }
  void popup::detached(HWINDOW hw) {
    super::detached(hw);
  }

  bool popup::render(void* dc, rect paint_rc) {
     if (!_device)
       setup_backend();
     if (_device) {
       auto painter = [this, paint_rc](graphics* gfx) { return this->render_on(gfx, paint_rc); };
       return _device->render(painter, paint_rc, dc);
     }
     return false;
  }

  bool popup::render_layered(void *dc, rect client_rc) {
    bool r = false;
    if (_device) {
      rect rc = this->client_dim();
      auto painter = [this, rc](graphics* gfx) { return this->render_on(gfx, rc); };
      r = _device->render_layered(painter, rc);
    }
    super::render_layered(dc,client_rc);
    return r;
  }
  
  bool popup::render_on(gool::graphics* pg, rect paint_rc)
  {
    auto_state<bool> _1(is_painting, true);
    auto_state<xgl::graphics*> _2(_surface, static_cast<xgl::graphics*>(pg));
    html::view* pv = _root->pview();
    if (pv && _root->ldata && _root->state.popup())
    {
      auto_state<gool::graphics*> _1(pv->drawing_surface, _surface);
      _surface->set_drawing_root(_root);
      _root->commit_measure(*pv);
      _surface->begin_drawing();
      assert(_root->ldata->dim_min.x.is_defined() && _root->ldata->dim_min.y.is_defined());
      assert(_root->ldata->dim.x > 0 && _root->ldata->dim.y > 0);
      point vp = _root->view_pos(*pv);
      auto outline_margins = _root->outline_distance(*pv);
      point rp = vp - outline_margins.s;
      rect rc(vp, _root->dim());
      rc >>= outline_margins;
      _surface->offset( -rp );
      _root->draw(*pv, _surface, vp);
      _surface->end_drawing();
    }
    invalid = rect();
    return true;
  }


  sciter_popup_base_t* window::create_popup()
  {
    return new popup();
  }


}
