#include "xgl-window-base.h"

#include "xgl/skia/include/gpu/gl/GrGLInterface.h"
#include "xgl/skia/include/gpu/GrContext.h"
#include "xgl/skia/src/gpu/gl/GrGLUtil.h"
#include "xgl/skia/include/gpu/SkGr.h"


namespace xgl {
  BackendDevice::~BackendDevice()
  {}


  void  BackendDevice::refresh(iwindow* self, const rect& area)
  {
     self->iwindow::refresh(area);
     //self->iwindow::refresh();
  }


//| "primitive" raster device - rasterization by CPU in memory

  DeviceRaster::~DeviceRaster() {
    detach();
  }

  void DeviceRaster::resize(int width, int height, SkColorType ct) {
    super::resize(width, height, ct);
    SkImageInfo ninfo = fBitmap.info().makeWH(width,height);
    if( ninfo != fBitmap.info() )
    {
      fBitmap.allocPixels(ninfo);
      invalidate(0, 0, width, height);
    }
    super::invalidate(0, 0, width, height);
  }

  bool DeviceRaster::render(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc)
  {

    if (paint_rc.empty())
      return false;

    float scale = backing_scale();

    size  dim( int(paint_rc.width() * scale), int(paint_rc.height() * scale) );

    if (dim.x != fBitmap.width() || dim.y != fBitmap.height())
    {
      SkImageInfo info = SkImageInfo::MakeN32Premul(dim.x, dim.y);
                         //SkImageInfo::Make(dim.x, dim.y, kBGRA_8888_SkColorType,kPremul_SkAlphaType);
      fBitmap.setInfo(info);
      fBitmap.allocPixels();
    }

    //fBitmap.eraseARGB(0,0,0,0); // begin_drawing should do that

    {
      SkCanvas canvas(fBitmap);
      handle<xgl::graphics> gfx = new xgl::graphics(&canvas,fIsTransparent);
      gfx->scale(scale);
      gfx->set_clip_rc(dim);
      gfx->offset(-paint_rc.s);
      gfx->begin_drawing();
      painter(gfx);
      gfx->end_drawing();
    }

    present(paint_rc,hdc);

    return true;

  }


//| OpenGL device:
  DeviceOpenGL::~DeviceOpenGL()
  {
    detach();
  }


  SkSurface* DeviceOpenGL::createSurface() {

    if( !fContext )
    {
        if (!init()) {
            SkDebugf("cannot create GPU Device\n");
            detach();
            return nullptr;
        }

        fInterface = GrGLCreateNativeInterface();
        //fInterface = GrGLInterfaceRemoveNVPR(fInterface);

        SkASSERT(NULL != fInterface);

        fContext = GrContext::Create(kOpenGL_GrBackend, (GrBackendContext)fInterface);

        SkASSERT(NULL != fContext);
        setUpRenderTarget();
        if( !this->fRenderTarget )
            return nullptr;
    }

    SkSurfaceProps props(getSurfaceProps());
        
    //static ref<SkColorSpace> colorSpace = SkColorSpace::NewNamed(SkColorSpace::kUnknown_Named);

    return SkSurface::NewRenderTargetDirect(fRenderTarget, &props);
  }

  bool DeviceOpenGL::render_layered(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc) {
    return render(painter, rect::make_xywh(0,0,width(),height()), hdc);
  }

  bool DeviceOpenGL::render_layer(element* el, function<bool(xgl::graphics* gfx,element* el)> painter, gool::rect paint_rc, void* hdc)
  {
    SkAutoTUnref<SkSurface> surface(createSurface());
    SkCanvas* canvas = surface->getCanvas();

    if (!canvas) {
      return false;
    }

    SkAutoCanvasRestore acr(canvas, true);

    SkIRect ir;  ir.set(0, 0, this->width(), this->height());

    SkRegion dirty(ir);
    canvas->clipRegion(dirty);

    {
      handle<xgl::graphics> gfx = new xgl::graphics(canvas,fIsTransparent);
      gfx->set_clip_rc(paint_rc);
      painter(gfx, el);
    }
    fContext->flush();

    return true;
  }


  void DeviceOpenGL::resize(int width, int height, SkColorType ct)
  {
    super::resize(width, height, ct);
    //refresh(fWindow, fWindow->client_dim());
    if(fContext)
      setUpRenderTarget();
  }


}
