#include "xgl-window-base.h"

#ifndef WINDOWLESS

#include "xgl/skia/include/gpu/gl/GrGLInterface.h"
#include "xgl/skia/include/gpu/GrContext.h"
#include "xgl/skia/src/gpu/gl/GrGLUtil.h"
#include "xgl/skia/include/gpu/SkGr.h"

#include "xgl/skia/src/utils/win/SkWGL.h"
#include "win/win-layered.h"
#include <gl/GL.h>

namespace xgl {

  float BackendDevice::backing_scale() const { return 1; }

  void BackendDevice::on_dpi_change() {  }

//| "primitive" raster device - rasterization by CPU in memory


  bool DeviceRaster::render_layered(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc)
  {
    size dim(this->width(), this->height());

    if (dim.empty())
      return false;

    //if (paint_rc.empty())
    //  return false;

    dib32 dib(dim);

    SkImageInfo info = SkImageInfo::Make(dim.x, dim.y, kBGRA_8888_SkColorType, kPremul_SkAlphaType);
    fBitmap.setInfo(info);
    fBitmap.setPixels(dib.bits());

    HWND hwnd = this->getHWnd();

    mswin::layered_window_ctx lwctx(dim);
    {
      SkCanvas canvas(fBitmap);
      canvas.clear(SK_ColorTRANSPARENT);
      handle<xgl::graphics> gfx = new xgl::graphics(&canvas,true);
      //gfx->text_paint.setLCDRenderText(false);
      //gfx->offset(-paint_rc.origin);
      gfx->set_clip_rc(dim);
      gfx->begin_drawing();
      painter(gfx);
      gfx->begin_drawing();
    }

    lwctx.update(hwnd, dib.DC());
    fBitmap.reset();

    return true;
  }

  bool DeviceRaster::present(rect paint_rc, void* hdc)
  {

    BITMAPINFO bmi;
    memset(&bmi, 0, sizeof(bmi));
    bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth = fBitmap.width();
    bmi.bmiHeader.biHeight = -fBitmap.height(); // top-down image
    bmi.bmiHeader.biPlanes = 1;
    bmi.bmiHeader.biBitCount = 32;
    bmi.bmiHeader.biCompression = BI_RGB;
    bmi.bmiHeader.biSizeImage = 0;

    fBitmap.lockPixels();

    argb* pixels = (argb*)fBitmap.getPixels();
    int ret = SetDIBitsToDevice(HDC(hdc),
      paint_rc.s.x, paint_rc.s.y,
      fBitmap.width(), fBitmap.height(),
      0, 0,
      0, fBitmap.height(),
      pixels,
      &bmi,
      DIB_RGB_COLORS);

    fBitmap.unlockPixels();

    (void)ret; // we're ignoring potential failures for now.

    return true;
  }

//| OpenGL device:

  void  DeviceOpenGL::refresh(iwindow* self, const rect& area)
  {
    self->iwindow::refresh(area);
    //self->request_render_layered();
  }
   
  void DeviceOpenGL::enable_vsync(bool enable)
  {}
    
  bool DeviceOpenGL::init()
  {
    HDC dc = GetDC(getHWnd());
    if (NULL == fHGLRC) {
      fHGLRC = SkCreateWGLContext(dc, 0 /*msaaSampleCount*/, kGLPreferCompatibilityProfile_SkWGLContextRequest);
      if (NULL == fHGLRC) {
        return false;
      }
      glClearStencil(0);
      glClearColor(1, 1, 1, 1);
      glStencilMask(0xffffffff);
      glClear(GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
    }
    if (wglMakeCurrent(dc, (HGLRC)fHGLRC)) {
      // use DescribePixelFormat to get the stencil bit depth.
      int pixelFormat = GetPixelFormat(dc);
      PIXELFORMATDESCRIPTOR pfd;
      DescribePixelFormat(dc, pixelFormat, sizeof(pfd), &pfd);
      fAttachmentInfo.fStencilBits = pfd.cStencilBits;

      // Get sample count if the MSAA WGL extension is present
      SkWGLExtensions extensions;
      if (extensions.hasExtension(dc, "WGL_ARB_multisample")) {
        static const int kSampleCountAttr = SK_WGL_SAMPLES;
        extensions.getPixelFormatAttribiv(dc,
          pixelFormat,
          0,
          1,
          &kSampleCountAttr,
          &fAttachmentInfo.fSampleCount);
      }
      else {
        fAttachmentInfo.fSampleCount = 0;
      }

      glViewport(0, 0, width(), height());
      ReleaseDC(getHWnd(), dc);
      return true;
    }
    ReleaseDC(getHWnd(), dc);
    return false;
  }

  bool DeviceOpenGL::attach() {
    super::resize(this->width(), this->height());
    return init();
  }


  bool DeviceOpenGL::detach() {
    if (fHGLRC) {
      HDC hdc = GetDC(getHWnd());
      wglMakeCurrent(hdc, (HGLRC)fHGLRC);
      SkSafeUnref(fRenderTarget);
      SkSafeUnref(fContext);
      SkSafeUnref(fInterface);
      wglMakeCurrent(hdc, 0);
      ReleaseDC(getHWnd(), hdc);
      wglDeleteContext((HGLRC)fHGLRC);
      fHGLRC = NULL;
      ReleaseDC(getHWnd(), hdc);
    }
    return true;
  }

  bool DeviceOpenGL::update_request() { return false; }
  void DeviceOpenGL::start_drawing() { }

  bool DeviceOpenGL::render(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc) {

    if (paint_rc.empty())
      return false;

    wglMakeCurrent(HDC(hdc), (HGLRC)fHGLRC);

    //glEnable(GL_BLEND);
    //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //Clear the screen and depth buffer

    SkAutoTUnref<SkSurface> surface(createSurface());
    if (!surface)
      return false;
    SkCanvas* canvas = surface->getCanvas();
      
    if (!canvas) {
      wglMakeCurrent(NULL, NULL);
      return false;
    }
      
    SkAutoCanvasRestore acr(canvas, true);

    SkIRect ir;  ir.set(0, 0, this->width(), this->height());

    SkRegion dirty(ir);
    canvas->clipRegion(dirty);

#ifdef SK_SIMULATE_FAILED_MALLOC
      gEnableControlledThrow = true;
#endif

    {
      argb cc;
      html::BLUR_BEHIND bb = fWindow->get_blurbehind();
      switch (bb) {
        case html::BLUR_BEHIND_ULTRA_DARK: cc = argb(0, 0, 0, 250); break;
        case html::BLUR_BEHIND_DARK:       cc = argb(0x33, 0x33, 0x33, 216); break;
        case html::BLUR_BEHIND_LIGHT:      cc = argb(0xFD, 0xFD, 0xFD, 216); break;
        case html::BLUR_BEHIND_ULTRA_LIGHT:cc = argb(0xFF, 0xFF, 0xFF, 204); break;
        default: cc = argb(0xFF, 0xFF, 0xFF, 0xFF); break;
      }
      handle<xgl::graphics> gfx = new xgl::graphics(canvas,cc);
      gfx->set_clip_rc(paint_rc);
      gfx->begin_drawing();
      painter(gfx);
      gfx->end_drawing();
    }
    fContext->flush();

#ifdef SK_SIMULATE_FAILED_MALLOC
      gEnableControlledThrow = false;
#endif

    present();

    wglMakeCurrent(NULL, NULL);

    return true;
  }

  bool DeviceOpenGL::present() {
    HDC dc = GetDC(getHWnd());
    SwapBuffers(dc);
    ReleaseDC(getHWnd(), dc);
    return true;
  }

  void DeviceOpenGL::setUpRenderTarget()
  {
    SkSafeUnref(fRenderTarget);
    GrBackendRenderTargetDesc desc;
    desc.fWidth = width();
    desc.fHeight = height();
    desc.fConfig = kSkia8888_GrPixelConfig;
    desc.fOrigin = kBottomLeft_GrSurfaceOrigin;
    desc.fSampleCnt = fAttachmentInfo.fSampleCount;
    desc.fStencilBits = fAttachmentInfo.fStencilBits;
    GrGLint buffer;
    GR_GL_GetIntegerv(fInterface, GR_GL_FRAMEBUFFER_BINDING, &buffer);
    desc.fRenderTargetHandle = buffer;
    //desc.fRenderTargetHandle = 0;
    this->fRenderTarget = fContext->wrapBackendRenderTarget(desc);
  }

}

#endif
