#ifndef __xgl_types_h__
#define __xgl_types_h__

#include "config.h"
#include "tool/tool.h"
#include "gool/gool.h"
#include "xgl/xgl-ref.h"
#include "xgl/skia/include/core/SkRefCnt.h"
#include "xgl/skia/include/core/SkSurface.h"

namespace xgl {

	inline gool::rectf cvt(const SkRect& rc)   {
		return gool::rectf(rc.x(), rc.y(), rc.x() + rc.width(), rc.y() + rc.height());
	}

	inline gool::rect cvt(const SkIRect& rc)   {
		return gool::rect(gool::point(rc.x(), rc.y()), gool::size(rc.width(), rc.height()));
	}

  inline gool::pointf cvt(const SkPoint& pt)   {
    return gool::pointf(pt.x(), pt.y());
  }

  inline SkPoint cvt(const gool::pointf& pt)   {
    return SkPoint::Make(pt.x, pt.y);
  }
  inline SkIPoint cvt(const gool::point& pt)   {
    return SkIPoint::Make(pt.x, pt.y);
  }

  inline SkPoint cvtf(const gool::point& pt)   {
    return SkPoint::Make(SkScalar(pt.x), SkScalar(pt.y));
  }
  
  inline SkRect cvt(const gool::rectf& rc)   {
    return SkRect::MakeXYWH(rc.left(),rc.top(),rc.width(), rc.height());
  }

  inline SkIRect cvt(const gool::rect& rc)   {
    return SkIRect::MakeXYWH(rc.left(), rc.top(), rc.width(), rc.height());
  }
  
  inline SkRect cvtf(const gool::rect& rc)   {
    return SkRect::MakeXYWH((SkScalar)rc.left(), (SkScalar)rc.top(), (SkScalar)rc.width(), (SkScalar)rc.height());
  }

  inline SkColor cvt(const gool::argb& c) {
    return SkColorSetARGBInline(c.alfa, c.red, c.green, c.blue);
  }


}



#endif


