#include "xgl-graphics.h"

#include "xgl/skia/include/effects/SkBlurImageFilter.h"
#include "xgl/skia/include/effects/SkBlurMaskFilter.h"
#include "xgl/skia/include/effects/SkColorMatrixFilter.h"
#include "xgl/skia/include/effects/SkDropShadowImageFilter.h"
#include "xgl/skia/src/effects/SkBlurMask.h"

namespace xgl 
{
  struct filter_graph_builder : public gool::filter_graph_builder
  {

    SkPaint            paint;

    ref<SkColorFilter> cf_tail;
    ref<SkImageFilter> if_tail;

    virtual bool add_blur(float p) 
    { 
      paint.setImageFilter(if_tail = SkBlurImageFilter::Create(p,p, if_tail ));
      return true;      
    }

    virtual bool add_brightness(float p) { 

      SkScalar mx[20] = {
        1,  0,  0, 0, 255 * p,
        0,  1,  0, 0, 255 * p,
        0,  0,  1, 0, 255 * p,
        0,  0,  0, 1, 0 };

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(mx);

      if( cf_tail )
        cf_tail = SkColorFilter::CreateComposeFilter(f,cf_tail);
      else 
        cf_tail = f;

      paint.setColorFilter(cf_tail);
      return true;      
    }

    virtual bool add_contrast(float p) { 

      float t = (1.0f - p) / 2.0f;

      SkScalar mx[20] = {
        p,  0,  0, 0, 255 * t,
        0,  p,  0, 0, 255 * t,
        0,  0,  p, 0, 255 * t,
        0,  0,  0, 1, 0 };

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(mx);

      if (cf_tail)
        cf_tail = SkColorFilter::CreateComposeFilter(f, cf_tail);
      else
        cf_tail = f;

      paint.setColorFilter(cf_tail);
      return true;
    }
    virtual bool add_grayscale(float p) { 

/*      SkScalar grayscale[20] = {
        0.299f, 0.587f, 0.114f, 0.0f, 0.0f,
        0.299f, 0.587f, 0.114f, 0.0f, 0.0f,
        0.299f, 0.587f, 0.114f, 0.0f, 0.0f,
        0.0f,   0.0f,   0.0f,   1.0f, 0.0f };

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(grayscale); */

      p = 1.0f - p; // grayscale level to saturation

      float r_weight = 0.299f;
      float g_weight = 0.587f;
      float b_weight = 0.114f;

      float a = (1.0f - p) * r_weight + p;
      float b = (1.0f - p) * r_weight;
      float c = (1.0f - p) * r_weight;
      float d = (1.0f - p) * g_weight;
      float e = (1.0f - p) * g_weight + p;
      float f = (1.0f - p) * g_weight;
      float g = (1.0f - p) * b_weight;
      float h = (1.0f - p) * b_weight;
      float i = (1.0f - p) * b_weight + p;

      SkScalar grayscale[20] = {
        a, d, g, 0.0f, 0.0f,
        b, e, h, 0.0f, 0.0f,
        c, f, i, 0.0f, 0.0f,
        0.0f, 0.0f,  0.0f,  1.0f, 0.0f };

      ref<SkColorFilter> flt = SkColorMatrixFilter::Create(grayscale);

      if (cf_tail)
        cf_tail = SkColorFilter::CreateComposeFilter(flt, cf_tail);
      else
        cf_tail = flt;

      paint.setColorFilter(cf_tail);
      return true;
    }
    virtual bool add_hue_rotate(float a) { 

      // the magic is taken from: https://msdn.microsoft.com/ru-ru/hh706342?f=255&MSPPError=-2147217396

      float m1[9] = {
        0.213f,  0.715f,  0.072f, 
        0.213f,  0.715f,  0.072f, 
        0.213f,  0.715f,  0.072f };

      float m2[9] = {
        0.787f, -0.715f, -0.072f, 
       -0.213f,  0.285f, -0.072f, 
       -0.213f, -0.715f,  0.928f };

      float m3[9] = {
       -0.213f, -0.715f,  0.928f, 
        0.143f,  0.140f, -0.283f, 
       -0.787f,  0.715f,  0.072f };

     SkColorMatrix r; r.setIdentity();
     
     float cos_theta = cosf(a);
     float sin_theta = sinf(a);

     r.fMat[0] = m1[0] + cos_theta * m2[0] + sin_theta * m3[0];
     r.fMat[1] = m1[1] + cos_theta * m2[1] + sin_theta * m3[1];
     r.fMat[2] = m1[2] + cos_theta * m2[2] + sin_theta * m3[2];

     r.fMat[5] = m1[3] + cos_theta * m2[3] + sin_theta * m3[3];
     r.fMat[6] = m1[4] + cos_theta * m2[4] + sin_theta * m3[4];
     r.fMat[7] = m1[5] + cos_theta * m2[5] + sin_theta * m3[5];

     r.fMat[10] = m1[6] + cos_theta * m2[6] + sin_theta * m3[6];
     r.fMat[11] = m1[7] + cos_theta * m2[7] + sin_theta * m3[7];
     r.fMat[12] = m1[8] + cos_theta * m2[8] + sin_theta * m3[8];

     ref<SkColorFilter> f = SkColorMatrixFilter::Create(r.fMat);

     if (cf_tail)
       cf_tail = SkColorFilter::CreateComposeFilter(f, cf_tail);
     else
       cf_tail = f;

     paint.setColorFilter(cf_tail);
     return true;
    }
    virtual bool add_invert() { 

      SkScalar invert[20] = {
        -1,  0,  0, 0, 255,
        0, -1,  0, 0, 255,
        0,  0, -1, 0, 255,
        0,  0,  0, 1, 0 };

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(invert);

      if (cf_tail)
        cf_tail = SkColorFilter::CreateComposeFilter(f, cf_tail);
      else
        cf_tail = f;

      paint.setColorFilter(cf_tail);
      return true;
        
    }
    virtual bool add_opacity(float p) { 

      SkScalar invert[20] = {
        1,  0,  0, 0, 0,
        0,  1,  0, 0, 0,
        0,  0,  1, 0, 0,
        0,  0,  0, p, 0 };

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(invert);

      if (cf_tail)
        cf_tail = SkColorFilter::CreateComposeFilter(f, cf_tail);
      else
        cf_tail = f;

      paint.setColorFilter(cf_tail);
      return true;
    }
    virtual bool add_saturate(float p) 
    {
      SkColorMatrix r; //r.setIdentity();
      r.setSaturation(p);

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(r.fMat);

      if (cf_tail)
        cf_tail = SkColorFilter::CreateComposeFilter(f, cf_tail);
      else
        cf_tail = f;

      paint.setColorFilter(cf_tail);
      return true;
    }

    virtual bool add_sepia(float p) { 

      SkScalar sepia[20] = {
        0.393f, 0.769f, 0.189f, 0.0f, 0.0f,
        0.349f, 0.686f, 0.168f, 0.0f, 0.0f,
        0.272f, 0.534f, 0.131f, 0.0f, 0.0f,
        0.0f,   0.0f,   0.0f,   1.0f, 0.0f };

      ref<SkColorFilter> f = SkColorMatrixFilter::Create(sepia);

      if (cf_tail)
        cf_tail = SkColorFilter::CreateComposeFilter(f, cf_tail);
      else
        cf_tail = f;

      paint.setColorFilter(cf_tail);

      return true;         
    }
    virtual bool add_drop_shadow(float offx,float offy,float blur_radius,float spread_radius, gool::argb clr) 
    { 
        SkScalar sigma = //SkBlurMask::ConvertRadiusToSigma(blur_radius); ???
                        blur_radius;
        paint.setImageFilter(if_tail = SkDropShadowImageFilter::Create(offx, offy, sigma,sigma, cvt(clr), SkDropShadowImageFilter::kDrawShadowAndForeground_ShadowMode, if_tail));
        return true;
      return true;
    }

    virtual bool add_composition(COMPOSITION_OP op) override {

      // NOT implemented yet
      // NOTE: this requires second bitmap for composition

      return false;

      

/*      asset<ID2D1Effect> effect;
      HRESULT hr = pdc->CreateEffect(CLSID_D2D1Composite, effect.target());
      if( FAILED(hr) )
        return false;
      if( tail )
        effect->SetInputEffect(0, tail);
      else
        effect->SetInput(0, bitmap);

      D2D1_COMPOSITE_MODE md;

      switch(op) {
      default:
        case src_over : md = D2D1_COMPOSITE_MODE_SOURCE_OVER; break;
        case dst_over : md = D2D1_COMPOSITE_MODE_DESTINATION_OVER; break;
        case src_in   : md = D2D1_COMPOSITE_MODE_SOURCE_IN; break;
        case dst_in   : md = D2D1_COMPOSITE_MODE_DESTINATION_IN; break;
        case src_out  : md = D2D1_COMPOSITE_MODE_SOURCE_OUT; break;
        case dst_out  : md = D2D1_COMPOSITE_MODE_DESTINATION_OUT; break;
        case src_atop : md = D2D1_COMPOSITE_MODE_SOURCE_ATOP; break;
        case dst_atop : md = D2D1_COMPOSITE_MODE_DESTINATION_ATOP; break;
        case dst_src_xor  : md = D2D1_COMPOSITE_MODE_XOR; break;
        case dst_copy_src : md = D2D1_COMPOSITE_MODE_SOURCE_COPY; break;
      }
      
      hr = effect->SetValue(D2D1_COMPOSITE_PROP_MODE, md);
      if( FAILED(hr) )
        return false;

      tail = effect;
      return true;  */  
    }

  };

  SkPaint get_filtered_paint(function<bool(gool::filter_graph_builder*)> filters)
  {
    filter_graph_builder builder;
    filters(&builder);
    return builder.paint;
  }

}