#include "config.h"
#include "tool/tool.h"
#include "xgl-graphics.h"

#include "xgl/skia/include/core/SkPaint.h"
#include "xgl/skia/include/core/SkTypeface.h"
#include "xgl/skia/src/core/SkGlyphCache.h"


namespace xgl {

  bool font::has_glyph_for(uint ucodepoint) const
  {
    //SkPaint paint;
    //paint.setTypeface(xgl_typeface());
    //SkAutoGlyphCache auto_cache(paint, NULL, NULL);
    //SkGlyphCache*    cache = auto_cache.getCache();
    //return cache->unicharToGlyph(ucodepoint) != 0;
    int n = xgl_typeface()->charsToGlyphs(&ucodepoint, SkTypeface::kUTF32_Encoding, nullptr,1);
    return n > 0;
  }
  uint font::glyph_index(uint ucodepoint) const
  {
    //SkPaint paint;
    //paint.setTypeface(xgl_typeface());
    //SkAutoGlyphCache auto_cache(paint, NULL, NULL);
    //SkGlyphCache*    cache = auto_cache.getCache();
    //return cache->unicharToGlyph(ucodepoint);
    uint16 glyphs[4] = {0,0,0,0};
    int n = xgl_typeface()->charsToGlyphs(&ucodepoint, SkTypeface::kUTF32_Encoding, glyphs, 1);
    assert(n <= 1);
    return n > 0 ? glyphs[0] : 0;
  }

  ustring font::used_font_name() const {
    SkString s;
    xgl_typeface()->getFamilyName(&s);
      return ustring(chars_of(s.c_str()));
  }

  uint font::get_glyph_indices_and_advances( slice<wchar> text , function<void(uint16,float,float)> cb )
  {

    int i;
    SkScalar x;

    buffer<wchar, 512> wt(text.length + 1);
    wt.target().copy(text).copy(wchar('\0'));

    SkPaint paint;
    paint.setTextEncoding(SkPaint::kUTF16_TextEncoding);
    paint.setAntiAlias(true);
    paint.setTypeface(this->xgl_typeface());
    paint.setTextSize(this->size);

    int num_glyphs = paint.textToGlyphs(wt.cbegin(), wt.size() * sizeof(wchar), nullptr);

    buffer<uint16_t, 512> glyphs(num_glyphs);
    buffer<int32_t, 512>  adjustments(num_glyphs);
    buffer<SkScalar,512>  widths(num_glyphs);
    buffer<SkPoint,512>   pts(num_glyphs);

    SkPaint glyphPaint(paint);
    glyphPaint.setTextEncoding(SkPaint::kGlyphID_TextEncoding);

    //convert to glyphs
    num_glyphs = paint.textToGlyphs(wt.cbegin(), wt.size() * sizeof(wchar), glyphs.begin());

    //compute the glyph positions
    glyphPaint.getTextWidths(glyphs.cbegin(), num_glyphs * sizeof(uint16_t), widths.begin());
    for (i = 0, x = 0; i < num_glyphs; i++)
    {
      pts[i].set(x, 0);
      x += widths[i];
    }

    //adjust for kerning
    if (xgl_typeface()->getKerningPairAdjustments(glyphs.cbegin(), num_glyphs, adjustments.begin()))
    {
      SkScalar globalAdj = 0;
      SkScalar scale = glyphPaint.getTextSize() / glyphPaint.getTypeface()->getUnitsPerEm();

      for (i = 0; i < num_glyphs - 1; i++)
      {
        globalAdj += adjustments[i] * scale;
        pts[i + 1].fX += globalAdj;
      }
    }

    //send the glyphs/points to the callback
    for (i = 0; i < num_glyphs - 1; i++)
      cb(glyphs[i], pts[i + 1].x() - pts[i].x(), pts[i].y());

    return num_glyphs - 1;

  }

  bool font::glyph_metrics(::uint16 glyph_index, float em_size, float& width, float& height) const {

    SkPaint paint;
    paint.setTextEncoding(SkPaint::kUTF16_TextEncoding);
    paint.setAntiAlias(true);
    paint.setTypeface(this->xgl_typeface());
    paint.setTextSize(this->size);
    paint.setTextEncoding(SkPaint::kGlyphID_TextEncoding);

    //compute the glyph positions
    paint.getTextWidths(&glyph_index, 1 * sizeof(uint16_t), &width);
    height = paint.getTextSize();
    return true;
  }

}

