//
//  osx-sciter-api.cpp
//  sciter-osx
//
//  Created by andrew on 2014-04-06.
//  Copyright (c) 2014 andrew fedoniouk. All rights reserved.
//

#include "config.h"
#include "sdk/include/sciter-x.h"
//#include "osx-mm.h"
//#include "osx-cvt.h"
#include "xgl-sciter.h"
#include "xgl-view.h"
#include "api/ext-ctl-api.h"

xgl::view* xglview( HWINDOW hw );

using namespace tool;

//|
//| Sciter API
//|

struct xgl_view_callback : public html::view_callback {
    
    HWINDOW               _hwnd;
    SciterHostCallback*   _callback;
    LPVOID                _callback_param;
    
    xgl_view_callback( HWINDOW hwnd, SciterHostCallback*   cb, LPVOID cb_param )
    : _hwnd(hwnd), _callback(cb), _callback_param(cb_param) {}
    
    virtual bool          load_data(html::view* pv, html::pump::request* rq)
    {
        pv->current_rq = rq;
        
        SCN_LOAD_DATA nm;
        nm.hwnd = _hwnd;
        nm.code = SC_LOAD_DATA;
        
        ustring uri = url::unescape(rq->url);
        nm.uri = LPCWSTR(uri.c_str());
        nm.outData = rq->data.size()? rq->data.head(): 0;
        nm.outDataSize = rq->data.size();
        nm.dataType = rq->data_type;
        nm.principal = rq->dst;
        nm.initiator = rq->initiator;
        nm.requestId = rq;
        
        UINT lr = 0;
        
        if(_callback)
        {
            array<byte> data; swap(data,rq->data);
            lr = _callback((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);
            if( rq->data.size() )
                return true;
            swap(data,rq->data);
        }
        
        if(nm.outData && nm.outDataSize && nm.outData != rq->data.head())
        {
            rq->data.push(nm.outData,nm.outDataSize);
            return true;
        }
        
        if(lr == LOAD_DELAYED)
        {
            rq->add_ref();
            return true;
        }
        
        if(lr != 0)
            return nm.outDataSize > 0;
        
        return false;
    }
    virtual bool          data_loaded(html::view* pv, html::pump::request* rq)
    {
        if(!_callback)
            return false;
        SCN_DATA_LOADED nm; memzero(nm);
        
        nm.code = SC_DATA_LOADED;
        nm.hwnd = _hwnd;
        ustring uri = url::unescape(rq->url);
        nm.uri = LPCWSTR(uri.c_str());
        nm.data = rq->data.elements();
        nm.dataSize = rq->data.size();
        nm.dataType = rq->data_type;
        
        (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);
        
        if(nm.data == 0 && nm.dataSize == 0)
            return true;
        return false;
    }
    virtual html::ctl*    create_behavior(html::view *pv, html::element* b, const tool::string& name )
    {

        html::helement ap = b;
        
        SCN_ATTACH_BEHAVIOR nmab;
        nmab.code = SC_ATTACH_BEHAVIOR;
        nmab.hwnd = _hwnd;
        nmab.behaviorName = name;
        nmab.element = ap.ptr();
        nmab.elementProc = 0;
        nmab.elementTag = 0;
        
        if(_callback)
        {
            (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nmab,_callback_param);
            if(nmab.elementProc)
                return new ext_ctl(name, nmab.elementProc, nmab.elementTag );
        }
        
        /*if( strchr(nmab.behaviorName,':') ) // attempt to load behavior from external .sbx (sciter binary extension - dll) file
        {
            tool::string bn = nmab.behaviorName;
            chars lib_name, bhv_name;
            if( !chars(bn).split(':',lib_name, bhv_name) )
                return 0;
            
            char buffer[2048]; buffer[0] = 0;
            GetModuleFileNameA( HINST_THISCOMPONENT ,buffer, sizeof(buffer));
            string drive, dir, name, ext;
            split_path(buffer, drive, dir, name, ext);
            
            string dll_name = string(lib_name) + ".dll";
            string s = drive + dir + dll_name;
            
            SciterBehaviorFactory* sbf = getExtFactory(s);
            if( !sbf )
                return 0;
            // second attempt, just dll name
            sbf = getExtFactory(dll_name);
            if( !sbf )
                return 0;
            
            //if( !( sbf = (SciterBehaviorFactory*) ::GetProcAddress( hlib, "SciterBehaviorFactory" ) ) )
            //  return 0;
            
            if( sbf( string(bhv_name), nmab.element, &nmab.elementProc, &nmab.elementTag))
            {
                if(nmab.elementProc)
                    return new ext_ctl(name, nmab.elementProc, nmab.elementTag );
                
            }
            nmab.elementTag  = 0;
            nmab.elementProc = 0;
        }*/
        return 0;
        
    }
    
    void deliver_posted_callback(uint_ptr wp, uint_ptr lp) {
        SCN_POSTED_NOTIFICATION nm;
        nm.hwnd = _hwnd;
        nm.code = SC_POSTED_NOTIFICATION;
        nm.wparam = wp;
        nm.lparam = lp;
        nm.lreturn = 0;
        if(_callback)
          (*_callback)((LPSCITER_CALLBACK_NOTIFICATION)&nm,_callback_param);
    }
    
    
};

void xgl_deliver_posted_callback(xgl::view* pv, uint_ptr wp, uint_ptr lp) {
  xgl_view_callback* pcb = pv->callback.ptr_of<xgl_view_callback>();
  pcb->deliver_posted_callback(wp,lp);
  pv->posted_callback_complete.signal();
}

VOID SCAPI SciterSetCallback_api(HWINDOW hwnd, LPSciterHostCallback cb, LPVOID cbParam)
{
    tool::handle<xgl::view> pview = xglview(hwnd);
    if(!pview || !cb)
        return ;
    
    critical_section cs(pview->guard);
    
    xgl_view_callback* pcb = new xgl_view_callback( hwnd, cb, cbParam );
    
    pview->set_callback(pcb);
}

LPVOID SCAPI SciterGetCallbackParam_api(HWINDOW hwnd)
{
    tool::handle<xgl::view> pview = xglview(hwnd);
    if(!pview)
        return nullptr;
    
    critical_section cs(pview->guard);

    xgl_view_callback* pcb = (xgl_view_callback*) pview->get_callback();
    if(pcb)
      return pcb->_callback_param;
    return nullptr;
}


LPCWSTR SCAPI SciterClassName_api()
{
    return WSTR("sciter-view");
}

uint module_version(bool major);

UINT SCAPI SciterVersion_api(BOOL major)
{
    return module_version(major);
}

UINT_PTR SCAPI SciterPostCallback_api(HWINDOW hwnd, UINT_PTR wp, UINT_PTR lp, UINT timeoutms)
{
    tool::handle<xgl::view> pview = xglview(hwnd);
    if(!pview)
        return 0;
    if( timeoutms ) {
        pview->post_posted_callback(wp,lp);
        pview->posted_callback_complete.wait();
    }
    else {
        pview->post_posted_callback(wp,lp);
    }
    return 0;
}

struct xglview_debug_output: public html::view_debug_output {
    DEBUG_OUTPUT_PROC _out;
    void*             _out_prm;
    xglview_debug_output(DEBUG_OUTPUT_PROC out, void* out_prm) :_out(out), _out_prm(out_prm) {}
    virtual void print(uint subs, uint sev, wchars msg ) override
    {
        _out(_out_prm, subs, sev, msg.start, msg.size() );
    }
};

VOID SCAPI SciterSetupDebugOutput_api(
                                       HWINDOW               hwndOrNull,// HWINDOW or null if this is global output handler
                                       LPVOID                param,     // param to be passed "as is" to the pfOutput
                                       DEBUG_OUTPUT_PROC     pfOutput   // output function, output stream alike thing.
)
{
    if(hwndOrNull)
    {
        tool::handle<xgl::view> pview = xglview(hwndOrNull);
        if(pview)
        {
            if( pfOutput )
                pview->set_debug_output(new xglview_debug_output(pfOutput,param));
            else
                pview->set_debug_output(0);
            return;
        }
    }
    setup_debug_output(param, pfOutput);
}

HWINDOW SCAPI  SciterCreateWindow_api(UINT creationFlags,
  LPRECT frame,
  SciterWindowDelegate* delegate,
  LPVOID delegateParam,
  HWINDOW parent)
{
  xgl::view* pp = 0;
  //if (parent) pp = mswin::window::ptr(parent);

  gool::rect rc = frame;
  html::window_params params;

  params.parent = pp;
  if (!rc.empty()) {
    params.pos = rc.origin;
    params.dim = rc.size();
  }
  /*
  params.delegate = delegate;
  params.delegateParam = delegateParam;

  //params.window_style = 0;
  //params.window_style_ex = 0;

  if (creationFlags & SW_CHILD)
    params.window_style |= WS_CHILD;
  else {
    if (creationFlags & SW_ALPHA) {
      params.window_style = WS_POPUP;
      params.window_style_ex |= WS_EX_LAYERED;
      params.is_transparent = true;
    }
    if (creationFlags & SW_TITLEBAR)
      params.window_style |= WS_CAPTION;
    if (creationFlags & SW_RESIZEABLE)
      params.window_style |= WS_THICKFRAME;
    if (creationFlags & SW_CONTROLS)
      params.window_style |= WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
    if (creationFlags & SW_TOOL)
      params.window_style_ex |= WS_EX_TOOLWINDOW;
    if (creationFlags & SW_OWNS_VM)
      params.owns_vm = true;
    if (creationFlags & SW_ENABLE_DEBUG)
      params.debug_mode = true;
    if (creationFlags & SW_MAIN)
      params.is_main = true;
    if (creationFlags & SW_GLASSY)
      params.is_glassy = true;
  }*/
  try {
    auto pw = app()->create_frame(params);
    return pw->get_hwnd();
  }
  catch (std::bad_alloc&) {
    return NULL;
  }
}


#define get_pview(hwnd) tool::handle<xgl::view> pview = xglview(hwnd);

#include "api/graphics-api.cpp"
#include "api/window-api.cpp"
#include "api/dom-api.cpp"
#include "api/ext-ctl-api.cpp"
#include "api/value-api.cpp"
#include "api/api-iface.cpp"