#include "config.h"
#include "xgl-view.h"
#include "xgl-graphics.h"

#include "SkEvent.h"
#include "SkTypes.h"
#include "SkApplication.h"
#include "SkOSWindow_Win.h"

xgl::view* xglview(HWINDOW hw)
{
  return xgl::view::get_view_of(hw);
}

SkOSWindow* xglwindow(const xgl::view* pv)
{
  //return xgl::view::get_view_of(hw);
  return const_cast<xgl::view*>(pv);
}


static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

// Returns the main window Win32 class name.
static const wchar* register_class(HINSTANCE hInstance) {
  WNDCLASSEXW wcex;
  // The main window class name
  static const wchar* gSZWindowClass = W("xgl-sciter-window");

  wcex.cbSize = sizeof(WNDCLASSEX);

  wcex.style = CS_HREDRAW | CS_VREDRAW;
  wcex.lpfnWndProc = WndProc;
  wcex.cbClsExtra = 0;
  wcex.cbWndExtra = 0;
  wcex.hInstance = hInstance;
  wcex.hIcon = NULL;
  wcex.hCursor = NULL;
  wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  wcex.lpszMenuName = NULL;
  wcex.lpszClassName = gSZWindowClass;
  wcex.hIconSm = NULL;

  RegisterClassEx(&wcex);

  return gSZWindowClass;
}


xgl::view* xgl_create_frame(const html::window_params& params) {

  SkOSWindow::WindowInit winInit;
  winInit.fInstance = GetModuleHandle(NULL);
  winInit.fClass = register_class(winInit.fInstance);

  xgl::view* pw = new xgl::view(&winInit, params);

  pw->add_ref();
  return pw;
}


LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
  switch (message) {
  case WM_COMMAND:
    return DefWindowProc(hWnd, message, wParam, lParam);
  case WM_DESTROY:
    PostQuitMessage(0);
    break;
  case WM_ERASEBKGND:
    return 1;
  default: {
    SkOSWindow* window = SkOSWindow::GetOSWindowForHWND(hWnd);
    if (window && window->wndProc(hWnd, message, wParam, lParam)) {
      return 0;
    }
    else {
      return DefWindowProc(hWnd, message, wParam, lParam);
    }
  }
  }
  return 0;
}



namespace xgl {

  void view::update() {
    SkOSWindow::present();
  }

  //void view_posted_callback(gpointer user_data)
  //{
  //  posted_callback_info* pcb = static_cast<posted_callback_info*>(user_data);
  //  xgl_deliver_posted_callback(pcb->pv, pcb->wp, pcb->lp );
  //  pcb->release();
  //}



}
