
function skia_filter(f)
  if f then
    if USE_SKIA_BY_DEFAULT then 
      filter { f }
    else 
      filter { f, "configurations:*Skia" }
    end 
  else 
    if not USE_SKIA_BY_DEFAULT then 
      filter { "configurations:*Skia" }
    else 
      filter { f }
    end 

  end 
end

function skia_includes() 

  skia_filter()

  defines { "SKIA_BACKEND" }
  includedirs { 
    "xgl",
    "xgl/skia/include/animator",
    "xgl/skia/third_party/ktx",
    "xgl/skia/third_party/etc1",
    "xgl/skia/include/views",
    "xgl/skia/include/views/animated",
    "xgl/skia/src/lazy",
    "xgl/skia/include/effects",
    "xgl/skia/include/xml",
    "xgl/skia/include/c",
    "xgl/skia/include/config",
    "xgl/skia/include/core",
    "xgl/skia/include/pathops",
    "xgl/skia/include/pipe",
    "xgl/skia/include/ports",
    "xgl/skia/include/utils",
    "xgl/skia/include/images",
    "xgl/skia/src/core",
    "xgl/skia/src/sfnt",
    "xgl/skia/src/image",
    "xgl/skia/src/opts",
    "xgl/skia/src/utils",
    "xgl/skia/include/gpu",
    "xgl/skia/src/gpu",
    "xgl/skia/include/private",
    "xgl/skia/include/codec",
    "xgl/skia/src/codec"
  }
  -- ????
  filter "system:macosx"
    includedirs {"xgl/skia/include/utils/mac"}

  filter "configurations:Debug*"
    defines { "SK_DEBUG" }
  filter "configurations:Release*"
    defines { "SK_RELEASE" }  
  filter {}

end

function include_files_uv() 
  
  if _OPTIONS["windowsxp"] then 
    
    includedirs { "engine/external/uv.xp/include", "engine/external/uv.xp/src" }

    files { "engine/external/uv.xp/src/*.c", "engine/external/uv.xp/include/*.h", "engine/external/uv.xp/src/*.h" }

    filter "system:windows"
      files { "engine/external/uv.xp/src/win/*.c" }
    
    filter "not system:windows"
      files { 
        "engine/external/uv.xp/src/unix/async.c",
        "engine/external/uv.xp/src/unix/atomic-ops.h",
        "engine/external/uv.xp/src/unix/core.c",
        "engine/external/uv.xp/src/unix/dl.c",
        "engine/external/uv.xp/src/unix/fs.c",
        "engine/external/uv.xp/src/unix/getaddrinfo.c",
        "engine/external/uv.xp/src/unix/getnameinfo.c",
        "engine/external/uv.xp/src/unix/internal.h",
        "engine/external/uv.xp/src/unix/loop-watcher.c",
        "engine/external/uv.xp/src/unix/loop.c",
        "engine/external/uv.xp/src/unix/pipe.c",
        "engine/external/uv.xp/src/unix/poll.c",
        "engine/external/uv.xp/src/unix/process.c",
        "engine/external/uv.xp/src/unix/signal.c",
        "engine/external/uv.xp/src/unix/spinlock.h",
        "engine/external/uv.xp/src/unix/stream.c",
        "engine/external/uv.xp/src/unix/tcp.c",
        "engine/external/uv.xp/src/unix/thread.c",
        "engine/external/uv.xp/src/unix/tty.c",
        "engine/external/uv.xp/src/unix/udp.c",
        "engine/external/uv.xp/src/unix/timer.c",
      }

    filter "system:macosx"
      files {
        "engine/external/uv.xp/src/unix/bsd-ifaddrs.c",
        "engine/external/uv.xp/src/unix/darwin.c",
        "engine/external/uv.xp/src/unix/darwin-proctitle.c",
        "engine/external/uv.xp/src/unix/fsevents.c",
        "engine/external/uv.xp/src/unix/kqueue.c",
        "engine/external/uv.xp/src/unix/proctitle.c",
      }
    filter "system:linux"
      files {
        "engine/external/uv.xp/src/unix/linux-core.c",
        "engine/external/uv.xp/src/unix/linux-inotify.c",
        "engine/external/uv.xp/src/unix/linux-syscalls.c",
        "engine/external/uv.xp/src/unix/procfs-exepath.c",
        "engine/external/uv.xp/src/unix/proctitle.c",
        "engine/external/uv.xp/src/unix/sysinfo-loadavg.c",
        "engine/external/uv.xp/src/unix/sysinfo-memory.c",
      }
    filter "system:android"
      files {
        "engine/external/uv.xp/src/unix/linux-core.c",
        "engine/external/uv.xp/src/unix/linux-inotify.c",
        "engine/external/uv.xp/src/unix/linux-syscalls.c",
        "engine/external/uv.xp/src/unix/pthread-fixes.c",
        "engine/external/uv.xp/src/unix/procfs-exepath.c",
        "engine/external/uv.xp/src/unix/proctitle.c",
        "engine/external/uv.xp/src/unix/sysinfo-loadavg.c",
        "engine/external/uv.xp/src/unix/sysinfo-memory.c",
        "engine/external/uv.xp/src/unix/android-ifaddrs.c",
      }
    filter {}


  else

    includedirs { "engine/external/uv/include", "engine/external/uv/src" }

    filter {}

    files { "engine/external/uv/src/*.c", 
            "engine/external/uv/include/*.h", 
            "engine/external/uv/src/*.h" }

    filter "system:windows"
      files { "engine/external/uv/src/win/*.c" }
    
    filter "not system:windows"
      files { 
         "engine/external/uv/src/unix/async.c",
         "engine/external/uv/src/unix/atomic-ops.h",
         "engine/external/uv/src/unix/core.c",
         "engine/external/uv/src/unix/dl.c",
         "engine/external/uv/src/unix/fs.c",
         "engine/external/uv/src/unix/getaddrinfo.c",
         "engine/external/uv/src/unix/getnameinfo.c",
         "engine/external/uv/src/unix/internal.h",
         "engine/external/uv/src/unix/loop-watcher.c",
         "engine/external/uv/src/unix/loop.c",
         "engine/external/uv/src/unix/pipe.c",
         "engine/external/uv/src/unix/poll.c",
         "engine/external/uv/src/unix/process.c",
         "engine/external/uv/src/unix/random-devurandom.c",
         "engine/external/uv/src/unix/signal.c",
         "engine/external/uv/src/unix/spinlock.h",
         "engine/external/uv/src/unix/stream.c",
         "engine/external/uv/src/unix/tcp.c",
         "engine/external/uv/src/unix/thread.c",
         "engine/external/uv/src/unix/tty.c",
         "engine/external/uv/src/unix/udp.c"
      }

    filter "system:macosx"
      files {
        "engine/external/uv/src/unix/bsd-ifaddrs.c",
        "engine/external/uv/src/unix/darwin-proctitle.c",
        "engine/external/uv/src/unix/darwin-stub.h",
        "engine/external/uv/src/unix/darwin.c",
        "engine/external/uv/src/unix/fsevents.c",
        "engine/external/uv/src/unix/kqueue.c",
        "engine/external/uv/src/unix/proctitle.c",
        "engine/external/uv/src/unix/random-getentropy.c"

      }
    filter "system:linux"
      files {
        "engine/external/uv/src/unix/linux-core.c",
        "engine/external/uv/src/unix/linux-inotify.c",
        "engine/external/uv/src/unix/linux-syscalls.c",
        "engine/external/uv/src/unix/linux-syscalls.h",
        "engine/external/uv/src/unix/procfs-exepath.c",
        "engine/external/uv/src/unix/proctitle.c",
        "engine/external/uv/src/unix/random-getrandom.c",
        "engine/external/uv/src/unix/random-sysctl-linux.c"
      }
    filter "system:android"
      files {
        "engine/external/uv/src/unix/android-ifaddrs.c",
        "engine/external/uv/src/unix/linux-core.c",
        "engine/external/uv/src/unix/linux-inotify.c",
        "engine/external/uv/src/unix/linux-syscalls.c",
        "engine/external/uv/src/unix/proctitle.c",
        "engine/external/uv/src/unix/procfs-exepath.c",
        "engine/external/uv/src/unix/pthread-fixes.c",
        "engine/external/uv/src/unix/random-getrandom.c",
        "engine/external/uv/src/unix/random-sysctl-linux.c"
      }
    filter {}
  end

end



function include_files_uv_tls() 

  includedirs { 
     "engine/external/uv/include", 
     "engine/external/uv/src",
     "engine/external/uv-tls/include",
   --  "engine/external/uv-tls/include/mbedtls" 
   }

  files { 
     "engine/external/uv-tls/src/*.c",
     "engine/external/uv-tls/src/mbedtls/*.c" }

end

function include_files_tool() 

  files { "engine/tool/eval/*.h",
          "engine/tool/eval/*.cpp",
          "engine/tool/re/re.h", 
          "engine/tool/re/re.cpp", 
          "engine/tool/ucdata/*.h", 
          "engine/tool/ucdata/*.cpp", 
          "engine/tool/websockets/*.h", 
          "engine/tool/websockets/*.cpp",
          "engine/tool/*.h", 
          "engine/tool/*.cpp" }

  filter "system:linux"
    links { "uuid" }
  filter {}

  if WINDOWLESS then
    filter "not system:macos"
      files { "engine/tool/ports/lite_*.cpp" }
    filter "system:macosx"
      files { "engine/tool/ports/macosx_*.h", "engine/tool/ports/macosx_*.cpp", "engine/tool/ports/macosx_*.mm" }
  else
    filter "system:windows"
      files { "engine/tool/ports/windows_*.cpp" }
    filter "system:macosx"
      files { "engine/tool/ports/macosx_*.h", "engine/tool/ports/macosx_*.cpp", "engine/tool/ports/macosx_*.mm" }
    filter "system:linux"
      files { "engine/tool/ports/linux_*.cpp" }

    -- hunspell
      files { 
        "engine/external/hunspell/*.h", 
        "engine/external/hunspell/*.hxx",
        "engine/external/hunspell/*.cxx"
      }
      -- includedirs { "engine/external/hunspell"} - contains config.h :(
  end
  filter {}
end

function include_files_gool() 

  files { "engine/gool/*.cpp", "engine/gool/*.h" }

  if not WINDOWLESS then  
    filter "system:windows"
      files { "engine/gool/ports/windows_*.cpp" }
    filter "system:macosx"
      files { "engine/gool/ports/macosx_*.h", "engine/gool/ports/macosx_*.cpp", "engine/gool/ports/macosx_*.mm" }
    filter "system:linux"
      files { "engine/gool/ports/linux_*.cpp" }
    filter {}
  else
    filter "system:macosx"
      files { "engine/gool/ports/macosx_*.mm" }
    filter {}
  end  

end

function include_files_zlib()

  includedirs { "engine/external/zlib" }

  files { "engine/external/zlib/adler32.c",
          "engine/external/zlib/compress.c",
          "engine/external/zlib/crc32.c", 
          "engine/external/zlib/deflate.c",
          "engine/external/zlib/inffast.c",
          "engine/external/zlib/inflate.c",
          "engine/external/zlib/inftrees.c",
          "engine/external/zlib/ioapi.c",
          "engine/external/zlib/trees.c",
          "engine/external/zlib/uncompr.c",
          "engine/external/zlib/unzip.c",
          "engine/external/zlib/zutil.c",
          "engine/external/zlib/gzclose.c",
          "engine/external/zlib/gzlib.c",
          "engine/external/zlib/gzread.c",
          "engine/external/zlib/gzwrite.c", }

end

function include_files_png()

  includedirs { "engine/external/zlib" }

  files { 
    "engine/external/png/png.c",
    "engine/external/png/png.h",
    "engine/external/png/pngconf.h",
    "engine/external/png/pngdebug.h",
    "engine/external/png/pngerror.c",
    "engine/external/png/pngget.c",
    "engine/external/png/pnginfo.h",
    "engine/external/png/pnglibconf.h",
    "engine/external/png/pngmem.c",
    "engine/external/png/pngpread.c",
    "engine/external/png/pngpriv.h",
    "engine/external/png/pngread.c",
    "engine/external/png/pngrio.c",
    "engine/external/png/pngrtran.c",
    "engine/external/png/pngrutil.c",
    "engine/external/png/pngset.c",
    "engine/external/png/pngstruct.h",
    "engine/external/png/pngtrans.c",
    "engine/external/png/pngwio.c",
    "engine/external/png/pngwrite.c",
    "engine/external/png/pngwtran.c",
    "engine/external/png/pngwutil.c" }

  defines { "PNG_ARM_NEON_OPT=0" }

  filter {}

end

function include_files_jpeg()

  files { 
    "engine/external/jpeg/jaricom.c",
    "engine/external/jpeg/jcapimin.c",
    "engine/external/jpeg/jcapistd.c",
    "engine/external/jpeg/jcarith.c",
    "engine/external/jpeg/jccoefct.c",
    "engine/external/jpeg/jccolor.c",
    "engine/external/jpeg/jcdctmgr.c",
    "engine/external/jpeg/jchuff.c",
    "engine/external/jpeg/jcinit.c",
    "engine/external/jpeg/jcmainct.c",
    "engine/external/jpeg/jcmarker.c",
    "engine/external/jpeg/jcmaster.c",
    "engine/external/jpeg/jcomapi.c",
    "engine/external/jpeg/jcparam.c",
    "engine/external/jpeg/jcprepct.c",
    "engine/external/jpeg/jcsample.c",
    "engine/external/jpeg/jctrans.c",
    "engine/external/jpeg/jdapimin.c",
    "engine/external/jpeg/jdapistd.c",
    "engine/external/jpeg/jdarith.c",
    "engine/external/jpeg/jdatadst.c",
    "engine/external/jpeg/jdatasrc.c",
    "engine/external/jpeg/jdcoefct.c",
    "engine/external/jpeg/jdcolor.c",
    "engine/external/jpeg/jddctmgr.c",
    "engine/external/jpeg/jdhuff.c",
    "engine/external/jpeg/jdinput.c",
    "engine/external/jpeg/jdmainct.c",
    "engine/external/jpeg/jdmarker.c",
    "engine/external/jpeg/jdmaster.c",
    "engine/external/jpeg/jdmerge.c",
    "engine/external/jpeg/jdpostct.c",
    "engine/external/jpeg/jdsample.c",
    "engine/external/jpeg/jdtrans.c",
    "engine/external/jpeg/jerror.c",
    "engine/external/jpeg/jfdctflt.c",
    "engine/external/jpeg/jfdctfst.c",
    "engine/external/jpeg/jfdctint.c",
    "engine/external/jpeg/jidctflt.c",
    "engine/external/jpeg/jidctfst.c",
    "engine/external/jpeg/jidctint.c",
    "engine/external/jpeg/jmemmgr.c",
    "engine/external/jpeg/jmemnobs.c",
    "engine/external/jpeg/jquant1.c",
    "engine/external/jpeg/jquant2.c",
    "engine/external/jpeg/jutils.c" }

end

function include_files_webp()

  files { 
    "engine/external/webp/src/dec/alpha_dec.c",
    "engine/external/webp/src/dec/buffer_dec.c",
    "engine/external/webp/src/dec/frame_dec.c",
    "engine/external/webp/src/dec/idec_dec.c",
    "engine/external/webp/src/dec/io_dec.c",
    "engine/external/webp/src/dec/quant_dec.c",
    "engine/external/webp/src/dec/tree_dec.c",
    "engine/external/webp/src/dec/vp8_dec.c",
    "engine/external/webp/src/dec/vp8l_dec.c",
    "engine/external/webp/src/dec/webp_dec.c",
    "engine/external/webp/src/demux/anim_decode.c",
    "engine/external/webp/src/demux/demux.c",
    "engine/external/webp/src/dsp/alpha_processing.c",
    "engine/external/webp/src/dsp/alpha_processing_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/alpha_processing_neon.c",
    "engine/external/webp/src/dsp/alpha_processing_sse2.c",
    "engine/external/webp/src/dsp/alpha_processing_sse41.c",
    "engine/external/webp/src/dsp/argb.c",
    "engine/external/webp/src/dsp/argb_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/argb_sse2.c",
    "engine/external/webp/src/dsp/cost.c",
    "engine/external/webp/src/dsp/cost_mips32.c",
    "engine/external/webp/src/dsp/cost_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/cost_sse2.c",
    "engine/external/webp/src/dsp/cpu.c",
    "engine/external/webp/src/dsp/dec.c",
    "engine/external/webp/src/dsp/dec_clip_tables.c",
    "engine/external/webp/src/dsp/dec_mips32.c",
    "engine/external/webp/src/dsp/dec_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/dec_msa.c",
    "engine/external/webp/src/dsp/dec_neon.c",
    "engine/external/webp/src/dsp/dec_sse2.c",
    "engine/external/webp/src/dsp/dec_sse41.c",
    "engine/external/webp/src/dsp/enc.c",
    "engine/external/webp/src/dsp/enc_avx2.c",
    "engine/external/webp/src/dsp/enc_mips32.c",
    "engine/external/webp/src/dsp/enc_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/enc_msa.c",
    "engine/external/webp/src/dsp/enc_neon.c",
    "engine/external/webp/src/dsp/enc_sse2.c",
    "engine/external/webp/src/dsp/enc_sse41.c",
    "engine/external/webp/src/dsp/filters.c",
    "engine/external/webp/src/dsp/filters_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/filters_msa.c",
    "engine/external/webp/src/dsp/filters_neon.c",
    "engine/external/webp/src/dsp/filters_sse2.c",
    "engine/external/webp/src/dsp/lossless.c",
    "engine/external/webp/src/dsp/lossless_enc.c",
    "engine/external/webp/src/dsp/lossless_enc_mips32.c",
    "engine/external/webp/src/dsp/lossless_enc_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/lossless_enc_msa.c",
    "engine/external/webp/src/dsp/lossless_enc_neon.c",
    "engine/external/webp/src/dsp/lossless_enc_sse2.c",
    "engine/external/webp/src/dsp/lossless_enc_sse41.c",
    "engine/external/webp/src/dsp/lossless_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/lossless_msa.c",
    "engine/external/webp/src/dsp/lossless_neon.c",
    "engine/external/webp/src/dsp/lossless_sse2.c",
    "engine/external/webp/src/dsp/rescaler.c",
    "engine/external/webp/src/dsp/rescaler_mips32.c",
    "engine/external/webp/src/dsp/rescaler_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/rescaler_msa.c",
    "engine/external/webp/src/dsp/rescaler_neon.c",
    "engine/external/webp/src/dsp/rescaler_sse2.c",
    "engine/external/webp/src/dsp/upsampling.c",
    "engine/external/webp/src/dsp/upsampling_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/upsampling_msa.c",
    "engine/external/webp/src/dsp/upsampling_neon.c",
    "engine/external/webp/src/dsp/upsampling_sse2.c",
    "engine/external/webp/src/dsp/yuv.c",
    "engine/external/webp/src/dsp/yuv_mips32.c",
    "engine/external/webp/src/dsp/yuv_mips_dsp_r2.c",
    "engine/external/webp/src/dsp/yuv_sse2.c",
    "engine/external/webp/src/enc/alpha_enc.c",
    "engine/external/webp/src/enc/analysis_enc.c",
    "engine/external/webp/src/enc/backward_references_enc.c",
    "engine/external/webp/src/enc/config_enc.c",
    "engine/external/webp/src/enc/cost_enc.c",
    "engine/external/webp/src/enc/delta_palettization_enc.c",
    "engine/external/webp/src/enc/filter_enc.c",
    "engine/external/webp/src/enc/frame_enc.c",
    "engine/external/webp/src/enc/histogram_enc.c",
    "engine/external/webp/src/enc/iterator_enc.c",
    "engine/external/webp/src/enc/near_lossless_enc.c",
    "engine/external/webp/src/enc/picture_csp_enc.c",
    "engine/external/webp/src/enc/picture_enc.c",
    "engine/external/webp/src/enc/picture_psnr_enc.c",
    "engine/external/webp/src/enc/picture_rescale_enc.c",
    "engine/external/webp/src/enc/picture_tools_enc.c",
    "engine/external/webp/src/enc/predictor_enc.c",
    "engine/external/webp/src/enc/quant_enc.c",
    "engine/external/webp/src/enc/syntax_enc.c",
    "engine/external/webp/src/enc/token_enc.c",
    "engine/external/webp/src/enc/tree_enc.c",
    "engine/external/webp/src/enc/vp8l_enc.c",
    "engine/external/webp/src/enc/webp_enc.c",
    "engine/external/webp/src/utils/bit_reader_utils.c",
    "engine/external/webp/src/utils/bit_writer_utils.c",
    "engine/external/webp/src/utils/color_cache_utils.c",
    "engine/external/webp/src/utils/filters_utils.c",
    "engine/external/webp/src/utils/huffman_encode_utils.c",
    "engine/external/webp/src/utils/huffman_utils.c",
    "engine/external/webp/src/utils/quant_levels_dec_utils.c",
    "engine/external/webp/src/utils/quant_levels_utils.c",
    "engine/external/webp/src/utils/random_utils.c",
    "engine/external/webp/src/utils/rescaler_utils.c",
    "engine/external/webp/src/utils/thread_utils.c",
    "engine/external/webp/src/utils/utils.c",    
  }

end

function include_files_rlottie() 

  if CONFIG.defines.USE_LOTTIE then

    includedirs { 
      "engine", 
      "engine/external/rlottie/inc", 
      "engine/external/rlottie/src/lottie", 
      "engine/external/rlottie/src/vector",
      --"engine/external/rlottie/src/vector/freetype",
    }    

    files { 
      -- "engine/external/rlottie/src/binding/**.cpp", -- not used
      "engine/external/rlottie/src/lottie/**.cpp",
      "engine/external/rlottie/src/vector/*.cpp",
      "engine/external/rlottie/src/vector/freetype/*.cpp",
    }

  end

end


function include_files_dybase()

  if SCRIPT == TIS then 
    includedirs { "engine/tiscript/dybase/inc" }  
    files { "engine/tiscript/dybase/src/*.cpp" }
  else
    includedirs { "engine/quickjs/storage/dybase/include" } 
  end

end

function include_files_directshow()

  includedirs { "engine/external/directshow" }

  files { "engine/external/directshow/*.cpp" }

end

function include_files_gtk()

  files { 
    "gtk/*.h",
    "gtk/*.cpp" }

end

function include_files_html()

  files { "engine/html/*.cpp", "engine/html/*.h", "engine/html/kiwi/*.h"  }

  filter "system:windows"
    includedirs { "engine/external/directshow" }
    files { "engine/html/ports/windows_*.cpp" }
  filter "system:macosx"
    files { "engine/html/ports/macosx_*.cpp", "engine/html/ports/macosx_*.mm" }
  filter "system:linux"
    files { "engine/html/ports/linux_*.cpp" }
  filter "system:android"
    files { "engine/html/ports/android_*.cpp" }
  filter {}
    
end

function include_files_lite()

  includedirs { "engine/lite" }
  files { "engine/lite/*.h", "engine/lite/*.cpp" }

end

function include_files_osx() 

  includedirs { "xgl" }

  files { 
    "osx/*.h",
    "osx/osx-sciter-api.cpp",
    "osx/osx-sciter-application.cpp",
    "osx/osx-sciter-clipboard.mm",
    "osx/osx-sciter-graphics.cpp",
    "osx/osx-sciter-graphics.mm",
    "osx/osx-graphics-font.mm",
    "osx/osx-sciter-popup.cpp",
    "osx/osx-sciter-text-analysis.cpp",
    "osx/osx-sciter-text-analysis-coretext.cpp",
    "osx/osx-sciter-text-flow.cpp",
    "osx/osx-sciter-view.cpp",
    "osx/osx-sciter-view-bridge.mm",  
    "osx/osx-sciter-window-controls.mm",
    "osx/osx-theme.cpp",
    "osx/osx-video.mm",  
    "osx/SciterPopupView.mm",
    "osx/SciterView.mm"
  }

end


function include_files_d2d() 

  if not WINDOWLESS then
    files { "engine/d2d/*.cpp","engine/d2d/*.h" }
  else
    files { 
      "engine/d2d/d2d.cpp",
      "engine/d2d/d2d-application.cpp",
      "engine/d2d/d2d-font-loader.cpp",
      "engine/d2d/d2d-graphics.cpp",
      "engine/d2d/d2d-bb-window-graphics.cpp",
      "engine/d2d/d2d-text-analysis.cpp",
      "engine/d2d/d2d-text-flow.cpp",
      "engine/d2d/*.h",
    }
  end

end  

function include_files_gdi() 
  filter "configurations:Release or Debug or ReleaseMD or DebugMD"
    files { "engine/gdi+/*.cpp","engine/gdi+/*.h" }  
  filter{}
end

function include_files_win() 

  includedirs "engine/win"

  files { 
    "engine/win/*.h",
    "engine/win/win-accessible.cpp",
    "engine/win/win-application.cpp",
    "engine/win/win-callback.cpp",
    "engine/win/win-frame.cpp",
    "engine/win/win-ime.cpp",
    "engine/win/win-popup.cpp",
    "engine/win/win-shell-icon.cpp",
    "engine/win/win-theme-95.cpp",
    "engine/win/win-theme-xp.cpp",
    "engine/win/win-theme.cpp",
    "engine/win/win-ux-themes.cpp",
    "engine/win/win-view.cpp",
    "engine/win/win-sciter-api.cpp",
    "engine/win/win-touch.cpp",
  }
end

function include_files_tis() 

  if SCRIPT == TIS then 

    includedirs { 
      "engine/tiscript/include", 
      "engine/tiscript/dybase/inc" 
    }    

    files { 
      "engine/tiscript/include/*.h",
      "engine/tiscript/int/*.cpp",
      "engine/tiscript/com/*.cpp",
     }

  end 

end

function include_files_xdom() 

  if SCRIPT == TIS then 

    includedirs { "engine/xdom" }  
    files { 
      "engine/xdom/*.h",
      "engine/xdom/*.cpp" 
    }  

  end

end


function include_files_qjs() 

  defines {
    "CONFIG_BIGNUM", 
    "CONFIG_JSX", 
    "CONFIG_JSX_SCITER",
    "CONFIG_DEBUGGER",
    "CONFIG_STORAGE",
    "CONFIG_OBJECT_LITERAL_CALL" 
  }

  includedirs { 
    "engine/quickjs",
    "engine/quickjs/storage/dybase/include"
  }    

  files { 
    "engine/quickjs/cutils.h",
    "engine/quickjs/cutils.c",
    "engine/quickjs/libregexp.c",
    "engine/quickjs/libunicode.c",
    "engine/quickjs/libbf.c",
    "engine/quickjs/quickjs.c",
    "engine/quickjs/quickjs-libc.c",
    --"engine/quickjs/quickjs-bjson.c",
    "engine/quickjs/libregexp.h",
    "engine/quickjs/libregexp-opcode.h",
    "engine/quickjs/libunicode.h",
    "engine/quickjs/libunicode-table.h",
    "engine/quickjs/list.h",
    "engine/quickjs/quickjs.h",
    "engine/quickjs/quickjs-atom.h",
    "engine/quickjs/quickjs-jsx.h",
    "engine/quickjs/quickjs-libc.h",
    "engine/quickjs/quickjs-opcode.h"
   }
   
   exceptionhandling "On"
  
  files {
    "engine/quickjs/storage/quickjs-storage.c",
    "engine/quickjs/storage/quickjs-storage.h",
    "engine/quickjs/storage/dybase/src/*.cpp",
    "engine/quickjs/storage/dybase/src/*.h",
    "engine/quickjs/storage/dybase/include/*.h"
  }
  includedirs {
    "engine/quickjs/storage/dybase/include"
  }

end

function include_files_xdomjs() 

  includedirs { "engine/xdomjs", "engine/xdomjs/uv" }  
  files { 
    "engine/xdomjs/*.h",
    "engine/xdomjs/*.hpp",
    "engine/xdomjs/*.cpp",
    "engine/xdomjs/uv/*.h",
    "engine/xdomjs/uv/*.c"
  }  

end


function include_freetype_files() 

  filter "system:android"

    files {
      "engine/external/freetype/src/base/basepic.c",
      "engine/external/freetype/src/base/ftapi.c",
      "engine/external/freetype/src/base/ftbase.c",
      "engine/external/freetype/src/base/ftbbox.c",
      "engine/external/freetype/src/base/ftbitmap.c",
      "engine/external/freetype/src/base/ftdbgmem.c",
      "engine/external/freetype/src/base/ftdebug.c",
      "engine/external/freetype/src/base/ftfstype.c",      
      "engine/external/freetype/src/base/ftglyph.c",
      "engine/external/freetype/src/base/ftinit.c",
      "engine/external/freetype/src/base/ftmm.c",
      "engine/external/freetype/src/base/ftpic.c",
      "engine/external/freetype/src/base/ftstroke.c",
      "engine/external/freetype/src/base/ftsynth.c",
      "engine/external/freetype/src/base/ftsystem.c",
      "engine/external/freetype/src/base/fttype1.c",
      "engine/external/freetype/src/autofit/autofit.c",
      "engine/external/freetype/src/cff/cff.c",
      "engine/external/freetype/src/pshinter/pshglob.c",
      "engine/external/freetype/src/pshinter/pshinter.c",
      "engine/external/freetype/src/pshinter/pshpic.c",
      "engine/external/freetype/src/pshinter/pshrec.c",
      "engine/external/freetype/src/psnames/psnames.c",
      "engine/external/freetype/src/psnames/pspic.c",
      "engine/external/freetype/src/raster/raster.c",
      "engine/external/freetype/src/raster/rastpic.c",
      "engine/external/freetype/src/sfnt/pngshim.c",
      "engine/external/freetype/src/sfnt/sfdriver.c",
      "engine/external/freetype/src/sfnt/sfntpic.c",
      "engine/external/freetype/src/sfnt/sfobjs.c",
      "engine/external/freetype/src/sfnt/ttbdf.c",
      "engine/external/freetype/src/sfnt/ttcmap.c",
      "engine/external/freetype/src/sfnt/ttkern.c",
      "engine/external/freetype/src/sfnt/ttload.c",
      "engine/external/freetype/src/sfnt/ttmtx.c",
      "engine/external/freetype/src/sfnt/ttpost.c",
      "engine/external/freetype/src/sfnt/ttsbit.c",
      "engine/external/freetype/src/smooth/ftspic.c",
      "engine/external/freetype/src/smooth/smooth.c",
      "engine/external/freetype/src/truetype/truetype.c",
      "engine/external/freetype/src/type1/t1driver.c",
      "engine/external/freetype/src/cid/cidgload.c",
      "engine/external/freetype/src/cid/cidload.c",
      "engine/external/freetype/src/cid/cidobjs.c",
      "engine/external/freetype/src/cid/cidparse.c",
      "engine/external/freetype/src/cid/cidriver.c",
      "engine/external/freetype/src/pfr/pfr.c",
      "engine/external/freetype/src/pfr/pfrgload.c",
      "engine/external/freetype/src/pfr/pfrload.c",
      "engine/external/freetype/src/pfr/pfrobjs.c",
      "engine/external/freetype/src/pfr/pfrsbit.c",
      "engine/external/freetype/src/type42/t42objs.c",
      "engine/external/freetype/src/type42/t42parse.c",
      "engine/external/freetype/src/type42/type42.c",
      "engine/external/freetype/src/winfonts/winfnt.c",
      "engine/external/freetype/src/pcf/pcfdrivr.c",
      "engine/external/freetype/src/pcf/pcfread.c",
      "engine/external/freetype/src/pcf/pcfutil.c",
      "engine/external/freetype/src/psaux/afmparse.c",
      "engine/external/freetype/src/psaux/psaux.c",
      "engine/external/freetype/src/psaux/psconv.c",
      "engine/external/freetype/src/psaux/psobjs.c",
      "engine/external/freetype/src/psaux/t1decode.c",
      "engine/external/freetype/src/tools/apinames.c",
      "engine/external/freetype/src/type1/t1afm.c",
      "engine/external/freetype/src/type1/t1gload.c",
      "engine/external/freetype/src/type1/t1load.c",
      "engine/external/freetype/src/type1/t1objs.c",
      "engine/external/freetype/src/type1/t1parse.c",
      "engine/external/freetype/src/bdf/bdfdrivr.c",
      "engine/external/freetype/src/bdf/bdflib.c",
      "engine/external/freetype/src/gzip/ftgzip.c",
      "engine/external/freetype/src/lzw/ftlzw.c",
    }
    includedirs {
      "engine/external/freetype/include",
      "engine/external/freetype/src" 
    }
  
  filter{}

end  

function include_files_xgl_skia()                                                                                

  skia_filter("platforms:x32 or x64")
    vectorextensions "SSE3"

  skia_filter()

    includedirs { 
      "xgl",
      "xgl/skia/include/animator",
      "xgl/skia/third_party/ktx",
      "xgl/skia/third_party/etc1",
      "xgl/skia/include/views",
      "xgl/skia/include/views/animated",
      "xgl/skia/src/lazy",
      "xgl/skia/include/effects",
      "xgl/skia/include/xml",
      "xgl/skia/include/c",
      "xgl/skia/include/config",
      "xgl/skia/include/core",
      "xgl/skia/include/pathops",
      "xgl/skia/include/pipe",
      "xgl/skia/include/ports",
      "xgl/skia/include/utils",
      "xgl/skia/include/images",
      "xgl/skia/src/core",
      "xgl/skia/src/sfnt",
      "xgl/skia/src/image",
      "xgl/skia/src/opts",
      "xgl/skia/src/utils",
      "xgl/skia/include/gpu",
      "xgl/skia/src/gpu",
      "xgl/skia/include/private",
      "xgl/skia/include/codec",
      "xgl/skia/src/codec"}

    files { 
      "xgl/skia/src/core/*.cpp",
      "xgl/skia/src/c/*.cpp",
      "xgl/skia/src/effects/gradients/*.cpp",
      "xgl/skia/src/effects/*.cpp",

      "xgl/skia/src/gpu/batches/*.cpp",
      "xgl/skia/src/gpu/effects/*.cpp",
      "xgl/skia/src/gpu/glsl/*.cpp",
      "xgl/skia/src/gpu/gl/builders/*.cpp",
      "xgl/skia/src/gpu/gl/*.cpp",
      "xgl/skia/src/gpu/gl/debug/*.cpp",
      "xgl/skia/src/gpu/*.cpp",
      "xgl/skia/src/gpu/text/*.cpp",

      "xgl/skia/src/images/SkImageDecoder.cpp",
      "xgl/skia/src/images/SkImageDecoder_FactoryDefault.cpp",
      "xgl/skia/src/images/SkImageDecoder_FactoryRegistrar.cpp",
      "xgl/skia/src/images/SkImageEncoder.cpp",
      "xgl/skia/src/images/SkImageEncoder_Factory.cpp",

      "xgl/skia/src/image/*.cpp",
      "xgl/skia/src/lazy/*.cpp",
      "xgl/skia/src/pathops/*.cpp",

      "xgl/skia/src/fonts/SkFontMgr_indirect.cpp",
      "xgl/skia/src/fonts/SkGScalerContext.cpp",
      "xgl/skia/src/fonts/SkRemotableFontMgr.cpp",

      "xgl/skia/src/ports/SkDiscardableMemory_none.cpp",
      "xgl/skia/src/ports/SkGlobalInitialization_default.cpp",
      "xgl/skia/src/ports/SkImageGenerator_skia.cpp",
      "xgl/skia/src/ports/SkMemory_malloc.cpp",
      "xgl/skia/src/ports/SkOSFile_stdio.cpp",
      "xgl/skia/src/sfnt/SkOTTable_name.cpp",
      "xgl/skia/src/sfnt/SkOTUtils.cpp",

      "xgl/skia/src/utils/SkBase64.cpp",
      "xgl/skia/src/utils/SkBitSet.cpp",
      "xgl/skia/src/utils/SkBoundaryPatch.cpp",
      "xgl/skia/src/utils/SkCamera.cpp",
      "xgl/skia/src/utils/SkCanvasStack.cpp",
      "xgl/skia/src/utils/SkCanvasStateUtils.cpp",
      "xgl/skia/src/utils/SkDashPath.cpp",
      "xgl/skia/src/utils/SkDumpCanvas.cpp",
      "xgl/skia/src/utils/SkEventTracer.cpp",
      "xgl/skia/src/utils/SkFrontBufferedStream.cpp",
      "xgl/skia/src/utils/SkInterpolator.cpp",
      "xgl/skia/src/utils/SkLayer.cpp",
      "xgl/skia/src/utils/SkMatrix22.cpp",
      "xgl/skia/src/utils/SkMeshUtils.cpp",
      "xgl/skia/src/utils/SkNinePatch.cpp",
      "xgl/skia/src/utils/SkNullCanvas.cpp",
      "xgl/skia/src/utils/SkNWayCanvas.cpp",
      "xgl/skia/src/utils/SkOSFile.cpp",
      "xgl/skia/src/utils/SkPaintFilterCanvas.cpp",
      "xgl/skia/src/utils/SkParse.cpp",
      "xgl/skia/src/utils/SkParseColor.cpp",
      "xgl/skia/src/utils/SkParsePath.cpp",
      "xgl/skia/src/utils/SkPatchGrid.cpp",
      "xgl/skia/src/utils/SkPatchUtils.cpp",
      "xgl/skia/src/utils/SkRTConf.cpp",
      "xgl/skia/src/utils/SkCondVar.cpp",
      "xgl/skia/src/utils/SkTextBox.cpp",
      "xgl/skia/src/utils/SkTextureCompressor.cpp",
      "xgl/skia/src/utils/SkTextureCompressor_ASTC.cpp",
      "xgl/skia/src/utils/SkTextureCompressor_LATC.cpp",
      "xgl/skia/src/utils/SkTextureCompressor_R11EAC.cpp",

      "xgl/skia/third_party/etc1/etc1.cpp",
      "xgl/skia/third_party/ktx/ktx.cpp",
--x86
      "xgl/skia/src/opts/opts_check_x86.cpp",
      "xgl/skia/src/opts/SkBitmapFilter_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkBitmapProcState_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkBitmapProcState_opts_SSSE3.cpp",
      "xgl/skia/src/opts/SkBlitRow_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkBlitRow_opts_SSE4.cpp",
      "xgl/skia/src/opts/SkBlurImage_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkBlurImage_opts_SSE4.cpp",
      "xgl/skia/src/opts/SkMorphology_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkUtils_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkXfermode_opts_SSE2.cpp",
      "xgl/skia/src/opts/SkTextureCompression_opts_none.cpp",
--arm
      "xgl/skia/src/opts/SkBitmapProcState_arm_neon.cpp",
      "xgl/skia/src/opts/SkBitmapProcState_matrixProcs_neon.cpp",
      "xgl/skia/src/opts/SkBitmapProcState_opts_arm.cpp",
      "xgl/skia/src/opts/SkBlitMask_opts_arm.cpp",
      "xgl/skia/src/opts/SkBlitMask_opts_arm_neon.cpp",
      "xgl/skia/src/opts/SkBlitRow_opts_arm.cpp",
      "xgl/skia/src/opts/SkBlitRow_opts_arm_neon.cpp",
      "xgl/skia/src/opts/SkTextureCompression_opts_arm.cpp",
      "xgl/skia/src/opts/SkMorphology_opts_arm.cpp",
      "xgl/skia/src/opts/SkMorphology_opts_neon.cpp",
      "xgl/skia/src/opts/SkXfermode_opts_arm.cpp",
      "xgl/skia/src/opts/SkXfermode_opts_arm_neon.cpp",
      "xgl/skia/src/opts/SkBlurImage_opts_arm.cpp",
      "xgl/skia/src/opts/SkBlurImage_opts_neon.cpp",
      "xgl/skia/src/opts/SkTextureCompression_opts_arm.cpp",
      "xgl/skia/src/opts/SkTextureCompression_opts_neon.cpp",
      "xgl/skia/src/opts/SkUtils_opts_none.cpp",

    }

    removefiles {
      "xgl/skia/src/gpu/gl/GrGLDefaultInterface_none.cpp",
      "xgl/skia/src/gpu/gl/GrGLCreateNativeInterface_none.cpp",      
      "xgl/skia/src/pathops/SkPathOpsPostSect.cpp",
    }

    -- xgl stuff
    
    files {
      "xgl/xgl-application.cpp",
      "xgl/xgl-bitmap-graphics.cpp",
      "xgl/xgl-cursor.cpp",
      "xgl/xgl-font.cpp",
      "xgl/xgl-gool.cpp",
      "xgl/xgl-graphics-filters.cpp",
      "xgl/xgl-graphics.cpp",
      "xgl/xgl-text-analysis.cpp",
      "xgl/xgl-window-base.cpp",
      "xgl/xgl-window-popup.cpp",
      "xgl/xgl-window.cpp",
    }
--[[
    skia_filter("platforms:x32 or x64")
      files
      {
        "xgl/skia/src/opts/opts_check_x86.cpp",
        "xgl/skia/src/opts/SkBitmapFilter_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkBitmapProcState_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkBitmapProcState_opts_SSSE3.cpp",
        "xgl/skia/src/opts/SkBlitRow_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkBlitRow_opts_SSE4.cpp",
        "xgl/skia/src/opts/SkBlurImage_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkBlurImage_opts_SSE4.cpp",
        "xgl/skia/src/opts/SkMorphology_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkUtils_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkXfermode_opts_SSE2.cpp",
        "xgl/skia/src/opts/SkTextureCompression_opts_none.cpp",
        --"xgl/skia/src/opts/SkOpts_avx.cpp",
        --"xgl/skia/src/opts/SkOpts_sse41.cpp",
        --"xgl/skia/src/opts/SkOpts_ssse3.cpp",
     }

    skia_filter("platforms:arm32 or arm64")
       --defines {"SK_ARM_HAS_OPTIONAL_NEON"}
       files {
        "xgl/skia/src/opts/SkBitmapProcState_arm_neon.cpp",
        "xgl/skia/src/opts/SkBitmapProcState_matrixProcs_neon.cpp",
        "xgl/skia/src/opts/SkBitmapProcState_opts_arm.cpp",
        "xgl/skia/src/opts/SkBlitMask_opts_arm.cpp",
        "xgl/skia/src/opts/SkBlitMask_opts_arm_neon.cpp",
        "xgl/skia/src/opts/SkBlitRow_opts_arm.cpp",
        "xgl/skia/src/opts/SkBlitRow_opts_arm_neon.cpp",
        "xgl/skia/src/opts/SkTextureCompression_opts_arm.cpp",
        "xgl/skia/src/opts/SkMorphology_opts_arm.cpp",
        "xgl/skia/src/opts/SkMorphology_opts_neon.cpp",
        "xgl/skia/src/opts/SkXfermode_opts_arm.cpp",
        "xgl/skia/src/opts/SkXfermode_opts_arm_neon.cpp",
        "xgl/skia/src/opts/SkBlurImage_opts_arm.cpp",
        "xgl/skia/src/opts/SkBlurImage_opts_neon.cpp",
        "xgl/skia/src/opts/SkTextureCompression_opts_arm.cpp",
        "xgl/skia/src/opts/SkTextureCompression_opts_neon.cpp",
        
        "xgl/skia/src/opts/SkUtils_opts_none.cpp",

        --"xgl/skia/src/opts/memset.arm.S",
        --"xgl/skia/src/opts/memset16_neon.S",
        --"xgl/skia/src/opts/memset32_neon.S",
       }

--]]       

    skia_filter("system:windows")

      links { "OpenGL32" }

      defines { "SK_INTERNAL",
              "SK_GAMMA_SRGB",
              "SK_GAMMA_APPLY_TO_A8",
              "SK_SCALAR_TO_FLOAT_EXCLUDED",
              "SK_ALLOW_STATIC_GLOBAL_INITIALIZERS=1",
              "SK_SUPPORT_GPU=1",
              "SK_CPU_SSE_LEVEL=41",
              "SK_SUPPORT_OPENCL=0",
              "SK_FORCE_DISTANCE_FIELD_TEXT=0",
              "_HAS_EXCEPTIONS=0",
              "GR_GL_FUNCTION_TYPE=__stdcall",
              "SK_BUILD_FOR_WIN32" }


      includedirs { 
        "xgl/skia/include/utils/win",
        "xgl/skia/src/utils/win",
        "xgl/skia/gyp/config/win" }

      files { 
        "xgl/skia/src/ports/SkDebug_win.cpp",
        "xgl/skia/src/gpu/gl/win/GrGLCreateNativeInterface_win.cpp", 
        "xgl/skia/src/gpu/gl/win/SkCreatePlatformGLContext_win.cpp", 
        "xgl/skia/src/utils/SkThreadUtils_win.cpp",
        "xgl/skia/src/utils/win/SkAutoCoInitialize.cpp",
        "xgl/skia/src/utils/win/SkDWrite.cpp",
        "xgl/skia/src/utils/win/SkDWriteFontFileStream.cpp",
        "xgl/skia/src/utils/win/SkDWriteGeometrySink.cpp",
        "xgl/skia/src/utils/win/SkHRESULT.cpp",
        "xgl/skia/src/utils/win/SkIStream.cpp",
        "xgl/skia/src/utils/win/SkWGL_win.cpp",
        "xgl/skia/src/ports/SkOSFile_win.cpp",
        "xgl/skia/src/ports/SkRemotableFontMgr_win_dw.cpp",
        "xgl/skia/src/ports/SkScalerContext_win_dw.cpp",
        "xgl/skia/src/ports/SkTLS_win.cpp",
        "xgl/skia/src/ports/SkTypeface_win_dw.cpp",
        "xgl/skia/src/ports/SkFontHost_win.cpp",
        "xgl/skia/src/ports/SkFontMgr_win_dw.cpp",

        "xgl/xgl-window-base-win.cpp",
       }

  skia_filter("system:macosx")

    --vectorextensions "AVX2"

    xcodebuildsettings { ["CLANG_X86_VECTOR_INSTRUCTIONS"]="sse4.1" }

    defines 
    { 
      "U_DISABLE_RENAMING",
      "SK_INTERNAL",
      "SK_GAMMA_SRGB",
      "SK_GAMMA_APPLY_TO_A8",
      "SK_ALLOW_STATIC_GLOBAL_INITIALIZERS=1",
      "SK_SUPPORT_GPU=1",
      --"SK_CPU_SSE_LEVEL=41",
      "SK_SUPPORT_OPENCL=0",
      "SK_FORCE_DISTANCE_FIELD_TEXT=0",
      "SK_TEST_QCMS",
      "SK_BUILD_FOR_MAC",
      "SK_ARM_NEON_IS_NONE",
    }

    includedirs { 
      "xgl/skia/include/utils/mac" }

    files { 
      "xgl/skia/src/ports/SkFontHost_mac.cpp", 
      --"xgl/skia/src/ports/SkImageEncoder_CG.cpp",
      --"xgl/skia/src/ports/SkImageGeneratorCG.cpp", 
      "xgl/skia/src/ports/SkOSFile_posix.cpp",
      -- "xgl/skia/src/ports/SkOSLibrary_posix.cpp",
      "xgl/skia/src/ports/SkTLS_pthread.cpp",
      "xgl/skia/src/ports/SkDebug_stdio.cpp",
      "xgl/skia/src/utils/SkThreadUtils_pthread.cpp",
      "xgl/skia/src/utils/mac/*.cpp",
      "xgl/skia/src/gpu/gl/mac/*.cpp",
      "xgl/xgl-window-base-mac.mm",
     }

  skia_filter("system:linux")

    --vectorextensions "AVX2"

    defines 
    { 
      "SK_INTERNAL",
      "SK_GAMMA_SRGB",
      "SK_GAMMA_APPLY_TO_A8",
      "SK_ALLOW_STATIC_GLOBAL_INITIALIZERS=1",
      "SK_SUPPORT_GPU=1",
      "SK_SUPPORT_OPENCL=0",
      "SK_SUPPORT_OPENCL=0",
      "SK_FORCE_DISTANCE_FIELD_TEXT=0",
      "SK_TEST_QCMS",
      "SK_BUILD_FOR_UNIX" 
    }

    files { 
      "xgl/skia/src/gpu/gl/glx/GrGLCreateNativeInterface_glx.cpp",
      "xgl/skia/src/gpu/gl/glx/SkCreatePlatformGLContext_glx.cpp",
      "xgl/skia/src/ports/SkDebug_stdio.cpp",
      "xgl/skia/src/ports/SkDiscardableMemory_none.cpp",
      "xgl/skia/src/ports/SkFontConfigInterface_direct.cpp",
      "xgl/skia/src/ports/SkFontConfigInterface_direct.h",
      --"xgl/skia/src/ports/SkFontConfigInterface_direct_factory.cpp",
      "xgl/skia/src/ports/SkFontConfigTypeface.h",
      "xgl/skia/src/ports/SkFontHost_FreeType.cpp",
      "xgl/skia/src/ports/SkFontHost_FreeType_common.cpp",
      "xgl/skia/src/ports/SkFontHost_FreeType_common.h",
      "xgl/skia/src/ports/SkFontMgr_android_parser.h",
      "xgl/skia/src/ports/SkFontMgr_fontconfig.cpp",
      --"xgl/skia/src/ports/SkFontMgr_fontconfig_factory.cpp",
      "xgl/skia/src/ports/SkGlobalInitialization_default.cpp",
      --"xgl/skia/src/ports/SkImageGenerator_none.cpp",
      "xgl/skia/src/ports/SkMemory_malloc.cpp",
      "xgl/skia/src/ports/SkOSFile_posix.cpp",
      "xgl/skia/src/ports/SkOSFile_stdio.cpp",
      --"xgl/skia/src/ports/SkOSLibrary_posix.cpp",
      "xgl/skia/src/ports/SkTLS_pthread.cpp",
      "xgl/skia/src/utils/SkThreadUtils_pthread.cpp",
     }

    if not WINDOWLESS then
      files { "xgl/xgl-window-base-unix.cpp" }
    end

  skia_filter("system:android")
    defines 
    { 
      "SK_INTERNAL",
      "SK_GAMMA_SRGB",
      "SK_GAMMA_APPLY_TO_A8",
      "SK_ALLOW_STATIC_GLOBAL_INITIALIZERS=1",
      "SK_SUPPORT_GPU=1",
      "SK_SUPPORT_OPENCL=0",
      "SK_FORCE_DISTANCE_FIELD_TEXT=0",
      "SK_BUILD_FOR_ANDROID", 
      "FT2_BUILD_LIBRARY=1", "FT_CONFIG_OPTION_SYSTEM_ZLIB",
      "HAVE_MEMMOVE",
      "ANDROID_NDK",
    }

    includedirs {
      "xgl/skia/third_party/externals/expat/lib"
    }
    

    files { 
      "xgl/skia/third_party/externals/expat/lib/*.c",   

      "xgl/skia/src/gpu/gl/android/GrGLCreateNativeInterface_android.cpp",
      "xgl/skia/src/gpu/gl/egl/SkCreatePlatformGLContext_egl.cpp",
      "xgl/skia/src/ports/SkDebug_android.cpp",
      "xgl/skia/src/ports/SkDiscardableMemory_none.cpp",

      "xgl/skia/src/ports/SkFontHost_FreeType.cpp",
      "xgl/skia/src/ports/SkFontHost_FreeType_common.cpp",
      "xgl/skia/src/ports/SkFontHost_FreeType_common.h",

      "xgl/skia/src/ports/SkFontConfigParser_android.cpp",
      "xgl/skia/src/ports/SkFontMgr_android.cpp",
      
      "xgl/skia/src/ports/SkGlobalInitialization_default.cpp",

      "xgl/skia/src/ports/SkMemory_malloc.cpp",
      "xgl/skia/src/ports/SkOSFile_posix.cpp",
      "xgl/skia/src/ports/SkOSFile_stdio.cpp",
      "xgl/skia/src/ports/SkTLS_pthread.cpp",
      "xgl/skia/src/utils/SkThreadUtils_pthread.cpp",
     }

  filter {}

end

