
#include "osx-sciter-view.h"
#include "SciterView.h"

#if 0
namespace osx {

void window_controls::setup( view& v)
{

  window_controls *wc = new window_controls();
    
  document *d = v.doc();
    
  wc->button_close = html::find_first(v,d,WCHARS("[role=window-close]"));
  wc->button_icon = html::find_first(v,d,WCHARS("[role=window-icon]"));
  wc->button_min = html::find_first(v,d,WCHARS("[role=window-minimize]"));
  wc->button_max = html::find_first(v,d,WCHARS("[role=window-maximize]"));
  wc->caption = html::find_first(v,d,WCHARS("[role=window-caption]"));
  wc->corner = html::find_first(v,d,WCHARS("[role=window-corner]"));
  wc->body = html::find_first(v,d,WCHARS("[role=window-body]"));
  if(!wc->body) wc->body = html::find_first(v,d,WCHARS("body"));
    
  v._window_controls = wc;
}

HIT_TEST_AREA window_controls::hittest( view& v, gool::point pt ) {

 #define IS_INSIDE( el ) (el && (el->hit_box(v,element::TO_VIEW) && pt))

//      if( IS_INSIDE(button_icon) )
//        return HTSYSMENU;

      if( IS_INSIDE(corner) )
        return HTBOTTOMRIGHT;

      if( IS_INSIDE(button_close) )
        return HTCLIENT;
      if( IS_INSIDE(button_min) )
        return HTCLIENT;

      if( IS_INSIDE(button_max) )
        return HTCLIENT;

      if( IS_INSIDE(caption) )
          return HTCAPTION;

      if(body && v.get_resizeable())
      {
          rect body_rc = body->content_box(v,element::TO_VIEW);

          if( body_rc && pt )
            return HTCLIENT;

          if( pt.y < body_rc.top() + 10 ) 
          {
            if( pt.x < body_rc.left() + 10 ) 
              return HTTOPLEFT;
            if( pt.x > body_rc.right() - 10 ) 
              return HTTOPRIGHT;
          }
          else if( pt.y > body_rc.bottom() - 10 ) 
          {
            if( pt.x < body_rc.left() + 10 ) 
              return HTBOTTOMLEFT;
            if( pt.x > body_rc.right() - 10 ) 
              return HTBOTTOMRIGHT;
          }

          if( pt.y < body_rc.top() ) 
            return HTTOP;
          if( pt.y > body_rc.bottom() ) 
            return HTBOTTOM;
          if( pt.x < body_rc.left() ) 
            return HTLEFT;
          if( pt.x > body_rc.right() ) 
            return HTRIGHT;
      }
      return HTCLIENT;
#undef IS_INSIDE
}

bool window_controls::handle( view& v, event_mouse& evt)
{
    constexpr int THRESHOLD = 1;
    //SciterView* nv = (SciterView *)v.get_hwnd();
    if( !dragging) {
        if ( evt.cmd == MOUSE_DCLICK
            && evt.target->belongs_to(caption,true)
            && v.get_maximizable())
        {
          v.set_window_state(gool::WINDOW_MAXIMIZED);
          return true;
        }
        else if( evt.cmd == MOUSE_MOVE
            && evt.is_point_button()
            && evt.target->belongs_to(caption,true)
            && distance(dragging_offset, evt.pos) > THRESHOLD )
        {
            run_move_loop(v,evt);
            return true;
        }
        else if( evt.cmd == MOUSE_DOWN  && evt.target->belongs_to(caption,true)) {
            dragging_offset = evt.pos;
            return true;
        }
        else if( evt.cmd == MOUSE_UP  && button_min && evt.target->belongs_to(button_min,true) && button_min->state.pressed()) {
            v.set_window_state(gool::WINDOW_MINIMIZED);
            return true;
        }
        else if( evt.cmd == MOUSE_UP  && button_max && evt.target->belongs_to(button_max,true) && button_max->state.pressed()) {
            if(v.get_window_state() == gool::WINDOW_MAXIMIZED)
                v.set_window_state(gool::WINDOW_SHOWN);
            else
                v.set_window_state(gool::WINDOW_MAXIMIZED);
            return true;
        }
        else if( evt.cmd == MOUSE_UP  && button_close && evt.target->belongs_to(button_close,true) && button_close->state.pressed()) {
            v.ask_close_window();
            return true;
        }
    }
    else { // dragging
        if( evt.cmd == MOUSE_MOVE ) {
          point pos = evt.pos_view + v.screen_pos() - dragging_offset;
          v.move_window( rect ( pos, v.window_dim() ) );
          return true;
        }
    }
    return false;
}

bool window_controls::handle( view& v, event_behavior& evt)
{
    //SciterView* nv = (SciterView *)v.get_hwnd();
    //nv.mouseDownCanMoveWindow = caption && caption->state.hover()? TRUE : FALSE;
    
    if( evt.cmd == BUTTON_CLICK  && button_min && evt.target == button_min) {
        v.set_window_state(gool::WINDOW_MINIMIZED);
        return true;
    }
    else if( evt.cmd == BUTTON_CLICK  && button_max && evt.target == button_max) {
        if(v.get_window_state() == gool::WINDOW_MAXIMIZED)
            v.set_window_state(gool::WINDOW_SHOWN);
        else
            v.set_window_state(gool::WINDOW_MAXIMIZED);
        return true;
    }
    else if( evt.cmd == BUTTON_CLICK  && button_close && evt.target == button_close) {
        v.ask_close_window();
        return true;
    }
    
    return false;
}
    
    bool window_controls::run_move_loop(view& v, event_mouse& evt)
    {
        //dragging_offset = evt.pos_view;
        dragging = true;
        v.set_capture_strict(caption);
        bool result;
        
        //NSView *nv = (NSView *)v.get_hwnd();
        //[[nv window] cacheImageInRect: nv.frame];
        if(v.do_event(html::DO_EVENT_UNTIL_MOUSE_UP, result))
        {
          //[[nv window] restoreCachedImage];
          //[[nv window] flushWindow];
          v.set_capture(nullptr);
          dragging = false;
        }
        return result;
    }
    
}

#endif
