#ifndef __osx_sciter_view_h__
#define __osx_sciter_view_h__

#include "osx-sciter-basics.h"
#include "osx-sciter-graphics.h"
#include "osx-sciter-window-controls.h"

#include <CoreVideo/CVDisplayLink.h>

//class NSViewPeer;

extern void osx_draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, gool::argb color, const html::style* run_style);
extern void osx_set_timer(osx::view* pw, uint_ptr id, uint ms);
extern array<ustring> osx_ask_file_name(osx::view::AFN_MODE mode, const ustring& caption, const ustring& filename, const wchar* def_ext, const wchar* filter);
extern bool osx_ask_folder_name(const ustring& caption, ustring& foldername);


namespace osx
{
  class graphics;
    
  struct timer_def: public tool::resource {
    CF::ref<CFRunLoopTimerRef> ntimer;
    uint_ptr                   tid;
    tool::handle<timer_def>    next;

    timer_def(CFRunLoopTimerRef r, uint_ptr id, timer_def* n) { ntimer = r; tid = id; next = n;}
  };
    
  class popup;
    
  class view
#if defined(SCITER)
    : public tis::xview
#elif defined(SCITERJS)
    : public qjs::xview
#endif
  {
  public:
#if defined(SCITER)
    typedef tis::xview view_type_t;
    typedef tis::xview super;
#elif defined(SCITERJS)
    typedef qjs::xview view_type_t;
    typedef qjs::xview super;
#endif
    friend struct window_controls;

    view(const window_params& params);
    virtual ~view();

    static  bool init(bool start);
      
    //virtual HWINDOW get_hwnd() const override { return _nsview; }
    virtual gool::graphics* surface() override;
    
    virtual html::VIEW_TYPE view_type() const override { return type == html::DIALOG_WINDOW ? html::VIEW_DIALOG: html::VIEW_WINDOW; }
    //virtual bool uses_physical_size() const { return false; }

    // events
    //virtual void attached() override { super::attached(); } // this object got HWND to it, _hwnd field is valid, ctor
    virtual void stop() override;

    virtual void set_transparency( bool on_off ) {}
    virtual bool get_transparency() const { return false; }
      
    virtual void enable_vsync(bool enable) {}

    OBSOLETE virtual size screen_dim();
      
    virtual bool        set_frame_type(FRAME_TYPE on) override;
    virtual FRAME_TYPE  get_frame_type() const override;

    virtual bool    set_resizeable(bool on)  override;
    virtual bool    get_resizeable() const   override;

    int_v           _layer_resize_policy;
    virtual bool    set_resize_policy(int layer_resize_policy) override { _layer_resize_policy = layer_resize_policy; return true; }
    virtual int     get_resize_policy() const override { return _layer_resize_policy.val(11/*NSViewLayerContentPlacementTopLeft*/); }

    virtual bool    set_minimizable(bool on)  override;
    virtual bool    get_minimizable()     override;
    virtual bool    set_maximizable(bool on)  override;
    virtual bool    get_maximizable()     override;
      
    virtual float_v aspect_ratio() const override;
    virtual void    aspect_ratio(float_v v) override;

    virtual bool get_min_size(gool::size& sz) override;
    virtual bool get_max_size(gool::size& sz) override;
    virtual bool set_min_size(gool::size sz = gool::size()) override;
    virtual bool set_max_size(gool::size sz = gool::size()) override;
      
    virtual bool is_enabled() const override;
    virtual void set_enabled(bool on_off) override;

    virtual bool set_icon(gool::image* pimg) override;
    virtual gool::image* get_icon() const override;
      
    virtual bool        set_blurbehind(BLUR_BEHIND bb) override;
    //virtual BLUR_BEHIND get_blurbehind() const override;
      
    virtual bool is_active() const override;
    virtual bool on_focus(bool got) override { _has_focus = got; return super::on_focus(got);  }
    virtual bool set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) override;
    virtual bool activate(bool and_bring_to_front) override;
      
    //virtual void on_dpi_changed(size dpi, rect proposed_window_rect) override;

    virtual size pixels_per_inch() override;
    virtual size physical_pixels_per_inch() override;
      
    virtual int  get_window_metrics(tool::value::length_special_values what) override;

    virtual element* element_under_cursor(/* out, view related */ gool::point& cursor_pos );

    virtual uint dblclick_timeout() const;

    virtual void  do_request_idle();
            void  stop_request_idle();
    virtual void  set_timer(uint_ptr id, uint ms, uint_ptr& sys_id);
            void  stop_timers();
            //void  setup_mouse_idle(bool on, gool::point pt);
            //void  handle_mouse_idle();

    virtual void          set_cursor(gool::cursor* pcur) override;
    virtual gool::cursor* get_cursor() override;

    virtual bool ask_close_window(bool by_chrome = false);
    virtual bool close_window();
            bool rq_close_window();

    virtual array<ustring> ask_file_name(AFN_MODE mode, const ustring& caption, const ustring& filename, const wchar* def_ext, const wchar* filter) override
    {
        array<ustring> r = osx_ask_file_name(mode, caption, filename, def_ext, filter);
        activate(true);
        refresh();
        return r;
    }
    virtual bool ask_folder_name(const ustring& caption, ustring& foldername) { return osx_ask_folder_name(caption, foldername); }

    //virtual rect  screen_workarea(rect rc = rect()) const override;
    virtual void  replace_windowed() override;
    virtual rect  window_decoration() const override; // return width of window decorations
    virtual void  move_window(const rect& spos, bool client_rc = false) override; 
    virtual WINDOW_STATE get_window_state() const;
    virtual bool         set_window_state( WINDOW_STATE ws );
    virtual ustring      get_window_title() const;
    virtual bool         set_window_title(const wchar* title);

    virtual bool         show();
    virtual bool         show_modal();

    virtual bool         do_event( DO_EVENT_MANNER m, bool& result );

    virtual bool         add_animation(element* b, animation* pba, const style* new_style, const style* old_style );
    virtual void         on_animation_tick();
            bool         is_animation_frame_pending() const { return _pending_animation_frame_request; }
    virtual void         remove_all_animations();
    virtual void         stop_animation_frames() override;

    virtual iwindow* create_window( html::element* forel, html::element* anchor, html::WINDOW_TYPE wt, function<rect(html::view&,html::element*,html::element*)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode = ELEMENT_WINDOW_AUTO ) override;
    virtual void setup_text_flow( html::element* elem, html::tflow::text_flow& tf, tool::slice< tool::handle<html::node> > nodes ) override;
    virtual void draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, argb color, const style* run_style) override
                { osx_draw_glyph_run( gfx, tf, gr, at, color, run_style); }

    virtual  bool     close_popup( element* b, bool set_auto_focus );

    virtual  void     enable_ime( bool on) override;
             bool     is_ime_enabled() const { return _ime_enabled.val(0) != 0; }
      
    virtual  bool     request_animation_frame(uint delay = 0) override;

    virtual  popup*   create_popup();

    /*virtual   bool    draw(void* dc,gool::rect dirty_rc) override
    {
      return iwindow::draw(dc,dirty_rc);
    }*/
      
    virtual   bool    render(void* dc,gool::rect dirty_rc) override;
    virtual   void    render(gool::graphics* gfx, rect dirty_rc);
    //virtual   void    post_request_render_layered() override;
      
    virtual   bool    update_request() { return false; }
      
    virtual GRAPHICS_CAPS graphics_caps() const { return SOFTWARE_GRAPHICS; }
    virtual ustring       graphics_backend() const { return W("CoreGraphics"); }

    // notifications, called by peer:
    void handle_minimized() {
        if(_window_state != WINDOW_MINIMIZED) {
            _preminimized_window_state = _window_state;
            _window_state = WINDOW_MINIMIZED; on_state_changed();
        }
    }
    void handle_restored() {  _window_state = _preminimized_window_state; on_state_changed();}
    void handle_fullscreen() { _preminimized_window_state = _window_state; _window_state = WINDOW_FULL_SCREEN ; on_state_changed();}
    void handle_shown() { if(_window_state != WINDOW_SHOWN) {_window_state = WINDOW_SHOWN ; on_state_changed(); } }
    void handle_hidden() { if(_window_state != WINDOW_HIDDEN) {_window_state = WINDOW_HIDDEN ; on_state_changed(); } }
    void handle_timer(CFRunLoopTimerRef timer);

    virtual void init_media_vars() override;
      
    void *currentEvent = nullptr;
    virtual bool supports_native_ui_window_move() const override;
    virtual bool perform_window_move() override;

    virtual bool do_drag(clipboard::data *pd, uint &ddm /*in out, DD_MODE flags*/, element *src,
                         gool::bitmap *drag_image, point offset) override;
  
    virtual void release_backend() {}
      
    void *trayicon_item = nullptr;
    void *trayicon_image = nullptr;
    virtual bool trayicon_setup(const tray_icon_params& params) override;
    virtual bool trayicon_remove() override;
    virtual bool trayicon_place(rect& rc) override;
    
    int_v request_id;
    virtual bool request_attention(WRA_MODE wm) override;

      // true if window at screen_pos is this one or one of its popups
    virtual bool is_at_position(point screen_pos) override;
      
  protected:

    size          _dim;
    gool::graphics* _gfx;
    bool          _is_painting;
    point         _last_known_point;
    bool          _mouse_inside;
    bool          _scrollbar_handling;                // true if inside scrollbar handling
    tristate_v    _collapsing;                        // true if window is shown but is about to be minimized
    bool          _non_client_mouse;                  // true is mouse is on NC area
    tristate_v    _has_focus;                         // true if it has focus
    bool          _is_closing;                        // true if window is handling close request
    FRAME_TYPE    _frame_type;
    tristate_v    _ime_enabled;

    WINDOW_STATE            _window_state;
    WINDOW_STATE            _preminimized_window_state;
    rect                    _preminimized_window_place;
      
    handle<gool::cursor> _cursor;                     // current cursor

    tristate_v          _pending_animation_frame_request; 

    handle<gool::application> _app_holder;

    handle<timer_def>   _first_timer_def;
      
public:
    handle<clipboard::data>    dragging_data;

    CF::ref<CFRunLoopTimerRef> mouse_idle_timer;
    CF::ref<CFRunLoopTimerRef> idle_timer;
#if defined(CVDL_ANIMATION)
    CVDisplayLinkRef           animator;
#endif

    unsigned long              dd_completion = 0;
    unsigned long              dd_operation = 0;
      
  };



}



#endif
