#include "osx-sciter.h"

gool::rect  osx_iwindow_screen_pos(html::iwindow* iw);
gool::size  osx_iwindow_client_dim(html::iwindow* iw);
gool::size  osx_iwindow_window_dim(html::iwindow* iw);
gool::point osx_iwindow_client_screen_pos(html::iwindow* iw);
gool::point osx_iwindow_cursor_pos(html::iwindow* iw);
void        osx_iwindow_refresh(html::iwindow* iw, const gool::rect& rc);
void        osx_iwindow_update(html::iwindow* iw);
gool::size  osx_screen_dim();
gool::size  osx_screen_workarea(gool::rect rc);
gool::rect  osx_screen_workarea( HWINDOW hwnd, gool::rect rc );
gool::size  osx_pixels_per_inch(html::iwindow* iw);
gool::size  osx_physical_pixels_per_inch(html::iwindow* iw);
gool::rect  osx_window_decoration(html::iwindow* iw);
bool osx_iwindow_has_close_button(html::iwindow* iw);

void osx_iwindow_screen_pos(html::iwindow* iw, gool::point pos);
bool osx_iwindow_is_visible(html::iwindow* iw);
void osx_iwindow_screen_pos(html::iwindow* iw, gool::rect rc);
bool    osx_iwindow_set_title(html::iwindow* iw, const wchar* title);
tool::ustring osx_iwindow_get_title(const html::iwindow* iw);

void osx_iwindow_replace_child(html::iwindow* iw, gool::rect box, bool visible);

void osx_iwindow_close(html::iwindow* iw, bool force);


bool osx_do_events(osx::view* pv, html::DO_EVENT_MANNER m, bool& result );
void osx_do_animation_tick( osx::view* pv );

void osx_post_event();
void osx_deliver_posted_callback(osx::view* pv, uint_ptr wp, uint_ptr lp );

bool osx_set_application_icon(html::iwindow* iw, gool::image* pimg);

namespace html {

  point iwindow::screen_pos() { return osx_iwindow_screen_pos(this).start(); }
  size  iwindow::client_dim() { return osx_iwindow_client_dim(this); }
  size  iwindow::window_dim() { return osx_iwindow_window_dim(this); }
  point iwindow::client_screen_pos() { return osx_iwindow_client_screen_pos(this); }
  point iwindow::cursor_pos() { return osx_iwindow_cursor_pos(this) - client_screen_pos(); }
  void  iwindow::invalidate(const rect& area) { osx_iwindow_refresh(this, area); }
  void  iwindow::update() { osx_iwindow_update(this); }
  //void  iwindow::post_request_render_layered() { osx_iwindow_refresh(this, gool::rect(client_dim())); }
    
}


namespace osx
{
#define ANIMATION_FRAME uint_ptr(-1)
    
   
    view::view(const window_params& params)
      : super(params)
      , _gfx(0)
      , _window_state(gool::WINDOW_STATE_NA)
      , _is_closing(false)
#if defined(CVDL_ANIMATION)
      , animator(nullptr)
#endif
      , _frame_type( html::STANDARD )
     {
        _app_holder = gool::app();
        init_media_vars();
    }
    view::~view() {
    }
    
    size view::screen_dim() { return osx_screen_dim(); }

    gool::graphics* view::surface() {
      return _gfx;
    }

    void view::render(gool::graphics* gfx,gool::rect dirty_rc)
    {
      //graphics gfx(g);

      auto_state<gool::graphics*>  _1(_gfx,gfx);
      auto_state<bool>             _2(is_painting,true);
      auto_state<gool::graphics*>  _3(drawing_surface, _gfx);

      gfx->set_clip_rc(dirty_rc);
      html::view::paint();
    }
    
    popup* view::create_popup() {
        return new popup();
    }
    
    iwindow* view::create_window( html::element* forel, html::element* anchor, html::WINDOW_TYPE wt, function<gool::rect(html::view&,html::element*,html::element*)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode )
    {
      handle<popup> pup = create_popup();
      if(!pup)
          return nullptr;
      pup->type = wt;
      pup->windowing_mode = mode;
      pup->root( forel );
      pup->anchor(anchor);
      pup->pfocus(get_focus_element());
        
      pup->set_hwnd(osx_create_popup_nsview(get_hwnd(),wt,pup));
        
      windows.push(pup.ptr());
  
      gool::rect rc = setup_and_calc_place(*this,forel,anchor);
      
      if( windows.get_index(pup.ptr()) < 0 )
          return 0;

      pup->show_at(rc);
      return pup;
       
    }
    
    /*
     
     int   theme::scrollbar_width() { return 16; }
     int   theme::scrollbar_height() { return 16; }
     int   theme::small_icon_width() { return 18; }
     int   theme::small_icon_height() { return 18; }
     int   theme::border_width() { return 1; }
     int   theme::border_3d_width() { return 2; }

     */
    
    int view::get_window_metrics(tool::value::length_special_values what) {
        switch (what)
        {
            case tool::value::$scrollbar_height:   return 16;
            case tool::value::$scrollbar_width:    return 16;
            case tool::value::$small_icon_height:  return 18;
            case tool::value::$small_icon_width:   return 18;
            case tool::value::$border_width:       return 1;
            case tool::value::$border_3d_width:    return 2;
                
            case tool::value::$window_caption_height: return 22;
            case tool::value::$window_button_height:  return 20;
            case tool::value::$window_button_width:   return 20;
            case tool::value::$window_frame_width:    return 0;
            
            default:
                assert(false);
                return 10;
        }
    }

    bool  view::close_popup( element* b, bool set_auto_focus )
    {
      handle<iwindow> hw = b->window(*this);
      if(!hw)
        return false;
      super::close_popup(b,set_auto_focus);
      if(hw->get_hwnd())
      {
        hw->dismiss();
        check_mouse(true);
        return true;
      }
      return false;
    }
    
    bool view::set_icon(gool::image* pimg)
    {
        if ( osx_set_application_icon(this, pimg)) {
            _icon = pimg;
            return true;
        }
        return false;
    }
    gool::image* view::get_icon() const
    {
        return _icon;
    }
    
    void view_idle_callback(CFRunLoopTimerRef timer, void *info)
    {
       handle<osx::view> pv = osx::view::ptr<osx::view>(info);
       if( !pv )
           return;
       if(!pv->get_hwnd())
         pv->stop_request_idle();
       else if(pv->on_idle()) {
         //assert(pv->idle_requests_counter == 0);
         //assert(!pv->items_in_idle_queue());
         pv->stop_request_idle();
       }
       else
         osx_post_event();
    }

    
    void view::stop_request_idle()
    {
        critical_section _(posted_guard);
        if(!idle_timer)
            return;
        if(items_in_idle_queue() && !dismissing)
            return;
        CFRunLoopTimerInvalidate(idle_timer);
        CFRunLoopRemoveTimer ( CFRunLoopGetMain(), idle_timer, kCFRunLoopCommonModes );
        idle_timer = nullptr;
    }
    
    void view::do_request_idle()
    {
        critical_section _(posted_guard);
        if(idle_timer)
            return;
        CFRunLoopTimerContext ctx = {0};
        ctx.info = get_hwnd();

        constexpr double idle_threshold = 1.0 / 60;

        CFRunLoopRef loop = CFRunLoopGetMain();
        if(!loop)
          return;
        
        idle_timer = CFRunLoopTimerCreate(NULL, CFAbsoluteTimeGetCurrent() + idle_threshold, idle_threshold, 0, 0, &view_idle_callback,&ctx);
        if(idle_timer)
          CFRunLoopAddTimer( loop, idle_timer, kCFRunLoopCommonModes );
    }

    struct posted_callback_info: resource {
        uint_ptr     wp;
        uint_ptr     lp;
        handle<osx::view> pv;
    };
    
    void view::handle_timer(CFRunLoopTimerRef timer)
    {
      handle<timer_def> pt;
      handle<timer_def> t = _first_timer_def;
      for(;t; t = t->next ) {
          if( t->ntimer == timer )
              goto GOTIT;
          pt = t;
       }
       assert(false);
       return;
     GOTIT:
       //printf("handle_timer %lld\n", t->tid);
#if !defined(CVDL_ANIMATION)
       if( t->tid == ANIMATION_FRAME )
         on_animation_tick();
       else
#endif
         on_timer(t->tid);
        
    }
    
    void view_timer_callback(CFRunLoopTimerRef timer, void *info)
    {
        osx::view* pv = osx::view::ptr<osx::view>(info);
        if(pv)
          pv->handle_timer(timer);
    }
    
    void  view::set_timer(uint_ptr id, uint ms,uint_ptr& sys_id)
    {
        if( ms == 0 ) {

            handle<timer_def> pt;
            handle<timer_def> t = _first_timer_def;
            
            for(;t; t = t->next ) {
                if( t->tid == id )
                {
                  //printf("remove_timer %lld\n", id);
                  if( pt ) pt->next = t->next;
                  else _first_timer_def = t->next;
                  CFRunLoopTimerInvalidate(t->ntimer);
                  CFRunLoopRemoveTimer ( CFRunLoopGetMain(), t->ntimer, kCFRunLoopCommonModes );
                    
                  this->release(); // --
                    
                  break;
                }
                pt = t;
            }
            return;
        }
        
        double dms = ms / 1000.0;
        
        CFRunLoopTimerContext ctx = {0};
        ctx.info = get_hwnd();
        
        this->add_ref(); // ++
        
        CFRunLoopTimerRef tr = CFRunLoopTimerCreate(NULL, CFAbsoluteTimeGetCurrent() + dms, dms, 0, 0, &view_timer_callback,&ctx);
        
        if(!tr)
            return;
        
        _first_timer_def = new timer_def( tr, id, _first_timer_def );
        
        //printf("add_timer %lld\n", id);
        
        CFRunLoopAddTimer( CFRunLoopGetMain(), tr, kCFRunLoopCommonModes );

    }
    
    void view::stop_timers() {
        handle<timer_def> t = _first_timer_def;
        for(;t; t = t->next ) {
            CFRunLoopRemoveTimer ( CFRunLoopGetMain(), t->ntimer, kCFRunLoopCommonModes );
            CFRunLoopTimerInvalidate(t->ntimer);
            t->ntimer = nullptr;
            this->release();
        }
        _first_timer_def = nullptr;
    }

    bool view::add_animation(element* b, animation* ba, const style* new_style, const style* old_style)
    {
      if(!get_hwnd())
        return false;
      if(_collapsing)
        return false;
      if(!super::add_animation(b, ba, new_style,old_style))
        return false;
      return true;
    }
    
   
#if defined(CVDL_ANIMATION)
    static CVReturn view_DisplayLinkCallback (
                                    CVDisplayLinkRef displayLink,
                                    const CVTimeStamp *inNow,
                                    const CVTimeStamp *inOutputTime,
                                    CVOptionFlags flagsIn,
                                    CVOptionFlags *flagsOut,
                                    void *displayLinkContext
                                           )
    {
        handle<view> pv = static_cast<view*>(displayLinkContext);
        //pv->on_animation_tick();
        //osx_do_animation_tick( pv );
        pv->async([pv]()->bool { pv->on_animation_tick(); return true; } );
        return kCVReturnSuccess;
    }
#endif
   
    bool view::request_animation_frame(uint delay) 
    {
      if(!get_hwnd())
        return false;

      if( _pending_animation_frame_request )
        return false;
      _pending_animation_frame_request = true;
       
#if defined(CVDL_ANIMATION)
        if( !this->animator ) {
            CVReturn ret = CVDisplayLinkCreateWithActiveCGDisplays ( &this->animator );
            assert( ret == kCVReturnSuccess );
            ret = CVDisplayLinkSetOutputCallback ( this->animator, view_DisplayLinkCallback, this );
            //  CVDisplayLinkRetain
        }
        CVDisplayLinkStart(this->animator);
#else
      uint_ptr dummy = 0;
      this->set_timer(ANIMATION_FRAME, ANIMATION_TIMER_SPAN, dummy);
#endif
       
      return true;
    }

    void view::on_animation_tick()
    {
      uint ticks;
      uint delay;
      uint delta = 0;
        
      _pending_animation_frame_request = false;

      uint_ptr dummy = 0; 
      this->set_timer(ANIMATION_FRAME, 0,dummy);

      //if( !Component::isVisible() )
      //  return;
        
      ticks = get_animation_ticks();
    
      if( !get_hwnd() || !doc() )
        goto STOP;

      if( animating.size() == 0 )
        goto STOP;

       
      delay = do_animation(ticks);

      if( animating.size() == 0 || delay == 0 )
        goto STOP;

      delta = get_animation_ticks() - ticks;

      request_animation_frame(delta < delay? delay - delta : 0);
        
      //update();

      return;
  STOP:
      _pending_animation_frame_request = false;
      remove_all_animations();
      return;
    }
    
    void view::stop_animation_frames() {
        
#if defined(CVDL_ANIMATION)
        if( this->animator ) {
            CVDisplayLinkStop(this->animator);
        }
#else
        uint_ptr dummy = 0;
        this->set_timer(ANIMATION_FRAME, 0, dummy);
#endif
        
    }

    void view::remove_all_animations()
    {
      super::remove_all_animations();
      //CVDisplayLinkStop(this->animator);
      stop_animation_frames();
#if defined(CVDL_ANIMATION)
      CVDisplayLinkRelease(this->animator);
      this->animator = nullptr;
#endif
    }
    
/*    void view::stop()
    {
        super::stop();
        setup_mouse_idle(false, point());
        stop_request_idle();
        stop_timers();
        _nsview = nullptr;
    } */
    

    element* view::element_under_cursor(point& pt) 
    {
      return find_element(pt);
    }

    bool view::is_active() const
    {
      return !!_has_focus;
    }

    void view::set_cursor(gool::cursor* pcur)
    {
      if(pcur)
          pcur->set();
      //super::set_cursor(pcur);
    }
    gool::cursor* view::get_cursor()
    {
      //return super::get_cursor();
      return nullptr;
    }

    size view::pixels_per_inch() {
        
      if( dpi.x.is_undefined() )
          dpi = osx_pixels_per_inch(this);

      return dpi;
      //  osx_pixels_per_inch(this);
    }
    
    size view::physical_pixels_per_inch() {
        
        if( physical_dpi.x.is_undefined() )
            physical_dpi = osx_physical_pixels_per_inch(this);
        
        return physical_dpi;
        //  osx_pixels_per_inch(this);
    }

    bool view::ask_close_window(bool by_chrome) {
        if( _is_closing )
            return true;
        //if(osx_iwindow_has_close_button(this)) - this fails under modal loop
        //   osx_iwindow_close(this, false);     - don't uncomment it
        //else
           post(delegate(this,&view::rq_close_window),true);
        return true;
    }
    bool view::close_window() {
        osx_iwindow_close(this,true);
        return true;
    }

    bool view::rq_close_window() {
      if( inside_animation_frame )
        return false; // cannot do it now, need reposting      
      auto_state<bool> _(_is_closing,true);
      if(ask_unload(doc(),UNLOAD_BY_CODE))
        osx_iwindow_close(this,true);
      return true;
    }
    
    //bool view::ask_file_name(bool to_save, const ustring& caption, ustring& filename, const wchar* def_ext, const wchar* filter) { return false; }

    rect view::window_decoration() const
    {
      return osx_window_decoration(const_cast<view*>(this));
    }

    bool view::is_enabled() const {
        return super::is_enabled();
    }
    void view::set_enabled(bool on_off) {
        super::set_enabled(on_off);
    }
    /*
    void view::adjust_window_rect(rect& rc) const {

        rect br = osx_iwindow_screen_pos(const_cast<view*>(this));
        rect cr = rect(osx_iwindow_client_screen_pos(const_cast<view*>(this)),osx_iwindow_client_dim(const_cast<view*>(this)));
        
        rc.origin -= cr.origin - br.origin;
        rc.corner += br.corner - cr.corner;
    } */

    void view::move_window(const rect& spos, bool client_rc)
    {
      super::move_window(spos,client_rc);
      rect place = spos;
      if( client_rc )
          place >>= window_decoration();
      osx_iwindow_screen_pos(this, place);
    }

    ustring      view::get_window_title() const
    {
      //return ustring();
      return osx_iwindow_get_title(this);
    }
    bool         view::set_window_title(const wchar* title)
    {
      return osx_iwindow_set_title(this,title);
    }
    bool view::show() {
      //Component::toFront(true);
      return true;
    }

    bool view::do_event( DO_EVENT_MANNER m, bool& result )
    {
      if( dismissing )
        return false;
      if (super::do_event(m, result))
        return true;
      return osx_do_events(this,m,result);
    }
    
    void view::replace_windowed() {
       if( windows.size() == 0 )
           return;
        
        uint cnt = 0, popups = 0;
        int i;
        
        for(i = windows.size() - 1; i >= 0; --i)
        {
            auto biw = windows[i];
            element *b = biw->root();
            if( !b ) {
                windows.remove(i);
                continue;
            }
            
            if( b->state.popup() )
            {
                ++popups;
                continue;
            }
            
            rect rc = b->content_box(*this,element::TO_VIEW);
            element* pw = b->get_windowed_container(*this,false);
            if( pw && pw != this->doc() )
                rc -= pw->view_pos(*this);
            
            bool visible = b->is_visible(*this);
            
            osx_iwindow_replace_child(biw, rc, visible);
            
            ++cnt;
        }
        //EndDeferWindowPos(hdwp);
        
        // need this pass to update popup windows (that are not children)
        
        if( popups )
        {
            //dbg_printf("window::replace_popus ++\n");
            for(i = 0; i < windows.size(); i++)
            {
                auto biw = windows[i];
                element *b = biw->root();
                if(!b)
                    continue;
                if(!b->pview())
                    continue;
                if(!b->state.popup() || !b->is_visible(*this) || !osx_iwindow_is_visible(biw))
                    continue;
                
                b->check_layout(*this);
                rect rc = b->outline_box(*this, element::TO_SCREEN);
                rect rcw = osx_iwindow_screen_pos(biw);
                if( rc != rcw ) {
                    osx_iwindow_screen_pos(biw, rc);
                    rcw = osx_iwindow_screen_pos(biw);
//#ifdef _DEBUG
//                    if( rc != rcw)
//                      dbg_printf("new pos : %d/%d and %d/%d\n", rc.left(), rc.top(), rcw.left(), rcw.top());/
//#endif
                    // didn't convince WM to set window pos
                    if( (rc != rcw) && b->airborn)
                        switch(b->airborn->type) {
                            default:
                                break;
                            case AIRBORN_WINDOW_VIEW:
                                b->airborn->pos = rcw.start() - client_screen_pos() + b->border_distance(*this).start();
                                break;
                            case AIRBORN_WINDOW_SCREEN:
                                b->airborn->pos = rcw.start() + b->border_distance(*this).start();
                                break;
                        }
                }
            }
            //dbg_printf("window::replace_popus --\n");
        }
        
        if(cnt && !is_painting)
        {
            update();  
        }
    }
    
    
}

namespace html {
    rect iwindow::screen_workarea(rect rc) const {
/*        if( anchor() ) {
            html::view* pv = anchor()->pview();
            if( pv ) {
                HWINDOW hw = anchor()->get_window(*pv)->get_hwnd();
                return osx_screen_workarea( hw, rc );
            }
        } */
        return osx_screen_workarea( get_hwnd(), rc );
    }
}
