//
//  osx-sciter-popup.cpp
//  sciter-osx
//
//  Created by andrew on 2014-04-05.
//  Copyright (c) 2014 andrew fedoniouk. All rights reserved.
//

#include "osx-sciter-popup.h"
#include "osx-sciter-view.h"

namespace osx {

    void popup::render(gool::graphics* gfx, rect client_rc)
    {
        if(!_root) return;
        html::view* pv = _root->pview();
        if(!pv || !_root->state.popup()) return;
        
        auto_state<bool> _(is_painting,true);
        
        gfx->set_clip_rc(client_rc);
        gfx->set_drawing_root(_root);
        
        _root->commit_measure(*pv);
        point vp = _root->view_pos(*pv);
        point rp = vp - point(_root->ldata->borpad_left(), _root->ldata->borpad_top());
        rect rc(vp, _root->dim());
        rc >>= rect( _root->ldata->borpad_left(), _root->ldata->borpad_top(), _root->ldata->borpad_right(), _root->ldata->borpad_bottom() );
        gfx->offset(-rp);
        _root->draw(*pv,gfx,vp);
    }
    
    void popup::dismiss()
    {
        osx_destroy_popup_nsview( _hwnd, this->windowing_mode );
    }
    void popup::show_at( gool::rect rc )
    {
        HWINDOW pw = 0;
        if(_anchor) {
          html::view* pv = _anchor->pview();
          if(pv)
            pw = _anchor->get_window(*pv)->get_hwnd();
        }
        osx_show_popup_nsview_at( _hwnd, pw, rc, this->windowing_mode );
    }
    void popup::detached(HWINDOW hw)
    {
        html::view* pv = _root->pview();
        if(pv) {
            critical_section _(pv->guard);
            pv->forget_window(this);
        }
        _root = nullptr;
        _anchor = nullptr;
        _pfocus = nullptr;
    }

}
