#include "osx-sciter.h"
#include "osx-sciter-application.h"

#if defined(USE_SKIA)
  #include "xgl/xgl.h"
#endif

extern void osx_init_font(osx::font& f);
extern void osx_find_all_typeface_names(tool::pool<ustring>& names);
void osx_system_fontname(tool::ustring& name, float& points);
void osx_system_font(tool::ustring& name, float& out_points, uint& weight, bool& italic);
bool osx_each_font_family( function<bool(wchars name)> cb, function<void(ucode,ucode)> cb_ranges_or_null );

handle<html::view>  osx_create_frame(const window_params& params);
handle<html::view>  osx_create_dialog(const window_params& params);
CTFontRef osx_install_font(tool::bytes data);

gool::argb osx_sys_color(gool::SYSTEM_COLORS cs );

namespace html {
    bool event::get_key_state(uint vk_code) {
        return CGEventSourceKeyState(kCGEventSourceStateCombinedSessionState, CGKeyCode(vk_code));
    }
}

namespace osx {
    
  static tool::ustring system_fontname()
    {
        ustring r; float dips;
        osx_system_fontname(r,dips);
        return r;
    }
    
  static tool::pool<ustring> names;
    

    gool::font* application::create_font(const ustring& name
                    , float size
                    , uint weight
                    , bool italic
                    , gool::FONT_RENDERING  mode) {
      osx::font key;
      key.name = name;
      key.size = size;
      key.weight = weight;
      key.italic = italic;
      osx::font* pf = _fonts.intern(key);
      if( pf ) init_font(pf);
        
      gool::get_current_system_color = &osx_sys_color;
        
      return pf;
    }
    
    gool::font* application::register_font( CTFontRef ctf )
    {
        osx::font key;
        CF::ref<CFStringRef> name = CTFontCopyPostScriptName(ctf);
        key.name = cvt(name);
        key.size = CTFontGetSize(ctf);
        key.weight = 400;
        key.italic = false;
        osx::font* pf = _fonts.intern(key);
        if( pf && !pf->_ct_font) {
            pf->ascent = ceil(CTFontGetAscent(ctf));
            pf->descent = ceil(CTFontGetDescent(ctf));
            pf->_ct_font = ctf;
            CFRetain(ctf);
        }
        return pf;
    }
    
    CF::ref<CTFontRef>   application::ctfont(gool::font* pf)
    {
        CTFontRef rt = static_cast<osx::font*>(pf)->ct_font();
        return CF::ref<CTFontRef>::copy(rt);
    }
      
    void application::clear_font_cache() {
        auto fonts = _fonts.elements()();
        for( uint n = 0; n < fonts.length; ++n )
            fonts[n]->_ct_font = nullptr;
    }
    
    tool::ustring application::get_supported_font_family(const tool::ustring& family_name_list)
    {
       ustring r;
       auto acceptor = [&r]( wchars ff ) -> bool {
           r = ff;
           return true;
       };
       get_supported_font_family(family_name_list, acceptor, wchars(), WS_UNKNOWN );
       return r;
    }
      
    wchars application::fallback_list(wchars lang_id, WRITING_SCRIPT script, bool serif )
    {
      switch(script)
      {
          default:
          case WS_UNKNOWN:
              return serif
              ? WCHARS("Georgia,Times,Times New Roman, Bangla MN,Devanagari MN,Euphemia UCAS,Kannad MN,Kefa,Khmer MN,Lao MN,Malayalam MN,Mshtakan,Myanmar MN,Oriya MN, Sathu,Sinhala MN,Tamil MN,!")
              : WCHARS("Helvetica,Arial Unicode MS,Ayuthaya,Bangla Sangam MN,Devanagari Sangam MN,Euphemia UCAS,Kannad Sangam MN,Kefa,Khmer Sangam MN,Lao Sangam MN,Malayalam Sangam MN,Mshtakan,Myanmar Sangam MN,Oriya Sangam MN, Sathu,Sinhala Sangam MN,Tamil Sangam MN,!");
          case WS_CYRILLIC: return serif
              ? WCHARS("Georgia,Times,!")
              : WCHARS("Helvetica,Arial Unicode MS,!");
          case WS_HANZI:
              if(lang_id.starts_with(WCHARS("ja")))
                  return serif
                  ? WCHARS("Hiragino Kaku Gothic Pro,Hiragino Kaku Gothic ProN,!")
                  : WCHARS("Hiragino Mincho Pro,Hiragino Mincho ProN,!");
              else if(lang_id.ends_with(WCHARS("tw")))
                  return serif  // traditional
                  ? WCHARS("Kaiti TC,Apple LiGothic,!")
                  : WCHARS("Heiti TC,LiHei Pro,BiauKai,!");
              else
                  return serif  // simplified
                  ? WCHARS("Kaiti SC,Hei,!")
                  : WCHARS("Heiti SC,Hannotate SC,ST Song,Hei,!");
          case WS_KANA:
              return serif
              ? WCHARS("Hiragino Kaku Gothic Pro,Hiragino Kaku Gothic ProN,!")
              : WCHARS("Hiragino Mincho Pro,Hiragino Mincho ProN,!");
          case WS_ARABIC:
              return serif
              ? WCHARS("Nadeem,Geeza Pro,!")
              : WCHARS("Baghdad,Geezah,!");
          case WS_HEBREW:
              return serif
              ? WCHARS("New Peninim,Corsiva Hebrew,!")
              : WCHARS("Arial Hebrew,Raanana,!");
          case WS_HANGUL:
              return serif
              ? WCHARS("Apple Myungjo,Hangangche,!")
              : WCHARS("Apple Gothic,Jung Gothic,!");
      }      
    }
     
      
    bool application::get_supported_font_family(wchars family_name_list,
                                   const function<bool(wchars)>& cb,
                                   tool::wchars lang_id,
                                   WRITING_SCRIPT script ) // cb shall return true if it accepts the family
    {
      if( names.size() == 0 )
          osx_find_all_typeface_names(names);

      static ustring monospace = W("Menlo");
      static ustring serif = W("Times New Roman");
      static ustring sansserif = W("Lucida Grande");
      static ustring system = system_fontname();
//      static ustring system = system_fontname() + W(",sans-serif,!");
      static ustring last_resort = W("LastResort");

      wtokens tz( family_name_list,WCHARS(",;") );
      wchars name;

      while(tz.next(name))
      {
        name = trim(name);
        if( icmp(name,WCHARS("monospace"))  )
          return get_supported_font_family( monospace(), cb, lang_id, script);
        else if( icmp(name,WCHARS("sans-serif")) )
          return get_supported_font_family( sansserif(), cb, lang_id, script )
              || get_supported_font_family( fallback_list( lang_id, script, false ), cb,  lang_id, script );
        else if( icmp(name,WCHARS("serif")) ) {
          return get_supported_font_family( serif(),cb,  lang_id, script )
              || get_supported_font_family( fallback_list( lang_id, script, true ) , cb,  lang_id, script );
        }
        else if( icmp(name,WCHARS("cursive")) )
          return get_supported_font_family(WCHARS("apple chancery,zapf chancery,freestyle script,brush script,serif"),cb, lang_id, script);
        else if( icmp(name,WCHARS("fantasy")) )
          return get_supported_font_family(WCHARS("comic sans,zapfino,sans-serif"),cb, lang_id, script);
        else if( name.like(W("system*"))) {
          if(cb(system()))
             return true;
          break;
        }
        else if(name == WCHARS("!"))
          return cb(last_resort());
        else if(names.exists(name) && cb( name ))
          return true;
        else if( this->has_memory_family(name) && cb(name) )
            return true;
        else if( icmp(name,system()) && cb( name ) )
          return true;
      }
      return get_supported_font_family( fallback_list( lang_id, script, false ) , cb,  lang_id, script );
      //  return true;
      //cb(last_resort());
      //return true;
    }
    
   
    bool application::get_used_font(
                                tool::handle<gool::font>& pf,
                                tool::wchars family_name_list, const gool::font* proto,
                                tool::wchars lang_id, 
                                WRITING_SCRIPT script, 
                                uint char_code)
    {
        handle<gool::font> rf;
        auto acceptor = [&]( wchars ff ) -> bool
        {
            rf = this->create_font( ff, proto->size, proto->weight, proto->italic, proto->mode);
            if(char_code && !rf->has_glyph_for(char_code))
              return false;
            return true;
        };
        bool r =  get_supported_font_family(family_name_list, acceptor, lang_id, script );
        pf = rf;
        return r;
    }

    gool::path* application::create_path() { return new osx::path(); }

    gool::graphics* application::create_bitmap_graphics( gool::graphics *proto, gool::bitmap *bmp, gool::argb initc ) { return new osx::bitmap_graphics(bmp,initc); }

    gool::graphics* application::create_bitmap_bits_graphics(gool::bitmap* bmp, gool::argb initc, bool high_quality ) { return new osx::bitmap_bits_graphics(bmp,initc); }


    //gool::GRAPHICS_CAPS application::graphics_caps() const { return gool::UNKNOWN_GRAPHICS; }

    handle<html::view>  application::create_frame(const window_params& params)
    {
      return osx_create_frame(params);
    }
    handle<html::view>  application::create_dialog(const window_params& params)
    {
      return osx_create_dialog(params);
    }
      
    //application::font_collection_t application::construct_font_collection(tool::bytes data)
    bool application::construct_font_collection_for(memory_font_variant& fv)
    {
#if defined(USE_CGX)
        fv.coll = osx_install_font(fv.data());
        return fv.coll != nullptr;
#else
        return false;
#endif
    }
      
    bool application::install_font(const tool::ustring& name,
                                       int        weight,
                                       bool       italic,
                                       tool::bytes data) {
        return install_memory_font(name, weight, italic, data);
    }

    bool application::each_font_family( function<bool(wchars name)> cb, function<void(ucode,ucode)> cb_ranges_or_null )
    {
        return osx_each_font_family( cb, cb_ranges_or_null );
    }
    
    bool application::init_font(gool::font* pfont)
    {
      osx::font* pf = static_cast<osx::font*>(pfont);
      if( pf && !pf->_ct_font )
          osx_init_font(*pf);
      return true;
    }
    
    osx::view* application::create_window_processor(const window_params& params)
    {
      return new osx::view(params);
    }

    application* application::instance = 0;
    
  
    application* app_factory() {
        if(application::instance)
            return application::instance;
#if defined(USE_SKIA)
        if( application::requested_gfx_layer == SKIA_GRAPHICS || application::requested_gfx_layer == SKIA_OPENGL_GRAPHICS )
            application::instance = //new xgl::application();
                                    xgl::app_factory();
        else
#endif
            application::instance = new osx::application();
        return application::instance;
    }
    
    void application::get_system_font(/*inout*/ ustring& name, /*out*/int& size, /*out*/ uint& weight, /*out*/bool& italic)
    {
        float fsz;
        osx_system_font(name,fsz, weight, italic);
        size = int(fsz);
    }

}

namespace gool {

  application* app()
  {
      return osx::app_factory();
  }
 
}

#if defined(SCITERJS)
  #include "../engine/master-css-resources-js.cpp"
#else
  #include "../engine/master-css-resources.cpp"
#endif


tool::bytes get_resource( const wchar* path ) {
  static tool::sar ctx( tool::items_of(master_css_resources) );
  return ctx.get(path);
}

std::pair<tool::bytes,tool::ustring> get_stock_style_resource() 
{
  tool::ustring u = W("ux-master.css");
  tool::bytes r = get_resource(u);
  return std::pair<tool::bytes,tool::ustring>(r,u);
}


bool load_file_thumbnail(const ustring& path, uint size, load_file_thumbnail_callback* pcb)
{
  return false;
}




