/*
*/

#include "osx-sciter.h"
#include "osx-sciter-graphics.h"
#include "osx-mm.h"
#include "osx-cvt.h"
#include "osx-ref.h"
#include "osx-ime.h"
#include <ApplicationServices/ApplicationServices.h>
#include <Carbon/Carbon.h>
#include "SciterView.h"

#import <Cocoa/Cocoa.h>



namespace osx
{
    ime_ctx& view::ime()
    {
        if(!_ime_ctx) _ime_ctx = new ime_ctx();
        return *_ime_ctx;
    }
    
    bool ime_ctx::hasMarkedText() const
    {
        return (marking.location != NSNotFound) && (marking.length != 0);
    }
    
    NSAttributedString* ime_ctx::getAttributedSubstringFromRange(osx::view* pv, NSRange aRange,NSRange* aActualRange)
    {
        if (aActualRange) {
            *aActualRange = NSMakeRange(NSNotFound, 0);
        }
        
        if (/*Destroyed() || */aRange.location == NSNotFound || aRange.length == 0) {
            return nil;
        }
        
        /*nsRefPtr<IMEInputHandler> kungFuDeathGrip(this);
        
        nsAutoString str;
        WidgetQueryContentEvent textContent(true, NS_QUERY_TEXT_CONTENT, mWidget);
        textContent.InitForQueryTextContent(aRange.location, aRange.length);
        DispatchEvent(textContent);
        
        PR_LOG(gLog, PR_LOG_ALWAYS,
               ("%p IMEInputHandler::GetAttributedSubstringFromRange, "
                "textContent={ mSucceeded=%s, mReply={ mString=\"%s\", mOffset=%llu } }",
                this, TrueOrFalse(textContent.mSucceeded),
                NS_ConvertUTF16toUTF8(textContent.mReply.mString).get(),
                textContent.mReply.mOffset));
        
        if (!textContent.mSucceeded) {
            return nil;
        }*/
        
        NSString* nsstr = cvt(buffer()); // ????????
        NSAttributedString* result =
        [[[NSAttributedString alloc] initWithString:nsstr
                                         attributes:nil] autorelease];
        if (aActualRange) {
            aActualRange->location = 0; //textContent.mReply.mOffset;
            aActualRange->length = buffer.size();//textContent.mReply.mString.Length();
        }
        return result;
        
    }
    
    NSRect firstRectForCharacterRange(osx::view* hview, NSRange aRange, NSRangePointer actualRange)
    {
        gool::rect rc;
        if(hview->focus_element && hview->focus_element->get_caret_location(*hview, rc)) {
            if(actualRange)
                *actualRange = NSMakeRange(0,0);
            rc += hview->focus_element->screen_pos(*hview);
            return tons(osx_screen_rect(rc));
        }
        if(actualRange)
           *actualRange = NSMakeRange(NSNotFound,0);
        
        return NSMakeRect(0.0, 0.0, 0.0, 0.0);
    }
    
    
    
}



