#include "html/html.h"
#include "gtk-view.h"
#include "api/api-defs.h"
#include "api/ext-ctl-api.h"

using namespace tool;

//gtk::view* gtkview( HWINDOW hw );

void gtk_layered_setup(GtkWidget *win)
{
  //return;
  GdkScreen *screen;
  GdkVisual *visual;

  gtk_widget_set_app_paintable(win, TRUE);
  screen = gdk_screen_get_default();
  visual = gdk_screen_get_rgba_visual(screen);

  if (visual != NULL && gdk_screen_is_composited(screen)) {
      gtk_widget_set_visual(win, visual);
  }
}

static gboolean gw_state_changed(GtkWidget *widget,GdkEventWindowState *event, gpointer user_data)
{
    gtk::view* pv = static_cast<gtk::view*>(user_data);

    gool::WINDOW_STATE ws = WINDOW_STATE_NA;

    if( event->new_window_state & GDK_WINDOW_STATE_WITHDRAWN )
      ws = WINDOW_HIDDEN;
    else if( event->new_window_state & GDK_WINDOW_STATE_ICONIFIED )
      ws = WINDOW_MINIMIZED;
    else if( event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED ) {
      if( pv->get_frame_type() == STANDARD_EXTENDED )
      {
          auto gw = gtkwindow( pv );
          gtk_window_set_decorated (gw, false);
      }
      ws = WINDOW_MAXIMIZED;
    }
    else {
      if( pv->get_frame_type() == STANDARD_EXTENDED )
      {
          auto gw = gtkwindow( pv );
          gtk_window_set_decorated (gw, true);
      }
      ws = WINDOW_SHOWN;
    }

    //dbg_printf("state changed %d\n",ws);

    pv->update_window_state(ws);
    return TRUE;
}

static gboolean gw_delete_event (GtkWidget *widget, GdkEvent  *event, gpointer user_data)
{
    gtk::view* pv = static_cast<gtk::view*>(user_data);

  /* If you return FALSE in the "delete_event" signal handler,
   * GTK will emit the "destroy" signal. Returning TRUE means
   * you don't want the window to be destroyed.
   *
   * This is useful for popping up 'are you sure you want to quit?'
   * type dialogs.
   */

   bool by_code = pv->_closerq_by_code;
   pv->_closerq_by_code = false;

   if(pv->ask_unload( pv->doc(), by_code ? gtk::view::UNLOAD_BY_CODE : gtk::view::UNLOAD_BY_CHROME))
     return FALSE; // proceed with destroy
   return TRUE; // discard closing
}

static gboolean gw_configure_event (GtkWidget *widget,
               GdkEventConfigure  *event,
               gpointer   user_data)
{
  gtk::view* pv = static_cast<gtk::view*>(user_data);
  if(pv)
  {
    point pos(event->x,event->y);
    size siz(event->width,event->height);
    if( pv->screen_pos() != pos )
    {
       //pv->_window_pos.x = event->x;
       //pv->_window_pos.y = event->y;
       if( event->send_event) {
         rect rc(pos,siz);
         pv->on_move_request(rc);
       }
       else
         pv->on_move();
    }
    if(pv->window_dim() != siz){
      rect rc(pos,siz);
      pv->on_size_request(0,rc);
    }

  }
  return FALSE;
}


static gboolean gw_size_event (GtkWidget *widget,
               GdkRectangle  *rect,
               gpointer   user_data)
{
  gtk::view* pv = static_cast<gtk::view*>(user_data);
  printf("gw_size_event %d %d\n", rect->width, rect->height);
  //pv->adjust_window_rect()
  //rect dc = pv->window_decoration();
  //gool::size sz(event->width - dc.left() - dc.right(), event->height - dc.top() - dc.bottom());
  //pv->on_size(sz);
  //pv->update();
  return FALSE;
}

static void gw_realized(GtkWidget* widget, gpointer user_data)
{
  gtk::view* pv = static_cast<gtk::view*>(user_data);
#ifdef USE_SKIA
  pv->attach(pv->get_hwnd());
#endif // USE_SKIA
}


/*static void gw_activate(GtkWindow *window, gpointer user_data)
{
  gtk::view* pv = static_cast<gtk::view*>(user_data);
  if(pv)
    pv->on_activate(html::ACTIVATED);
}*/

#if 0
static gboolean gw_focus_in_event(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return false;
  //if(!event->in)

  bool is_active = //gtk_window_has_toplevel_focus(GTK_WINDOW(widget));
                   gtk_window_is_active(GTK_WINDOW(widget));
  if(bool(pv->_window_is_active.val(0)) != is_active ) {
    pv->_window_is_active = true;
    pv->on_activate(html::ACTIVATED);
  }
  return false;
}

static gboolean gw_focus_out_event(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return false;

  bool is_inactive = !gtk_window_has_toplevel_focus(GTK_WINDOW(widget));
  if( (!bool(pv->_window_is_active.val(0)))  != is_inactive ) {
    pv->_window_is_active = false;
    pv->on_activate(html::INACTIVE);
  }
  return false;
}
#else

static gboolean gw_focus_in_event(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return false;
  //if(!event->in)

  bool is_active = gtk_window_is_active(GTK_WINDOW(widget));
  //if(bool(pv->_window_is_active.val(0)) != is_active ) {
  //  pv->_window_is_active = true;
    pv->on_activate(html::ACTIVATED);
  //}
  return false;
}

static gboolean gw_focus_out_event(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return false;

  bool is_inactive = !gtk_window_is_active(GTK_WINDOW(widget));
  //if( (!bool(pv->_window_is_active.val(0)))  != is_inactive ) {
    //pv->_window_is_active = false;
    pv->on_activate(html::INACTIVE);
  //}
  return false;
}

#endif


void setup_window_callbacks(HWINDOW hw)
{
  gtk::view* pview = gtkview( hw );
  auto* win = gtkwindow(hw);
  g_signal_connect( G_OBJECT(win), "window-state-event", G_CALLBACK(gw_state_changed), pview);
  g_signal_connect( G_OBJECT(win), "delete-event", G_CALLBACK (gw_delete_event), pview);
  g_signal_connect( G_OBJECT(win), "configure-event", G_CALLBACK (gw_configure_event), pview);
  //g_signal_connect( G_OBJECT(win), "size-allocate", G_CALLBACK (gw_size_allocate_event), pview);
  g_signal_connect( G_OBJECT(win), "realize", G_CALLBACK (gw_realized), pview);
  //g_signal_connect( G_OBJECT(win), "map", G_CALLBACK (gw_mapped), pview);
  g_signal_connect (G_OBJECT(win), "focus-in-event", G_CALLBACK (gw_focus_in_event), pview);
  g_signal_connect (G_OBJECT(win), "focus-out-event", G_CALLBACK (gw_focus_out_event), pview);

}


SBOOL SCAPI SciterProcX_api(HWINDOW hwnd, SCITER_X_MSG* pMsg )
{
  return FALSE;
}


HWINDOW SCAPI  SciterCreateWindow_api( UINT creationFlags,
                                        LPRECT frame,
                                        SciterWindowDelegate* delegate,
                                        LPVOID delegateParam,
                                        HWINDOW parent)
{
/*
#ifdef USE_SKIA
  RECT rcDefault = {0,0, 800, 600};
  LPRECT prc = frame ? frame : &rcDefault;
  gool::rect rc(gool::point(prc->left, prc->top), gool::point(prc->right, prc->bottom));

  html::window_params params;

  if(parent)
    params.parent = gtkview(parent);
  params.pos = rc.origin;
  params.dim = rc.size();

  if( creationFlags & SW_CHILD ) {
    //params.window_style |= WS_CHILD;
  } else {
    if( creationFlags & SW_OWNS_VM )
      params.owns_vm = true;
    if( creationFlags & SW_ENABLE_DEBUG )
      params.debug_mode = true;
    if( creationFlags & SW_MAIN )
      params.is_main = true;

    if( creationFlags & SW_GLASSY )
      params.is_glassy = true;
    else if( creationFlags & SW_ALPHA )
      params.is_transparent = true;
  }

  if(creationFlags & SW_POPUP)
    params.window_type = html::POPUP_WINDOW;
  else if(creationFlags & SW_TOOL)
    params.window_type = html::TOOL_WINDOW;
  else if(creationFlags & SW_CHILD)
    params.window_type = html::CHILD_WINDOW;
  else
    params.window_type = html::FRAME_WINDOW;

  auto* pw = gool::app()->create_frame(params);
  return pw->get_hwnd();
#endif // USE_SKIA */

  //g_log_set_handler ("Gtk", G_LOG_LEVEL_WARNING, (GLogFunc) gtk_false, NULL);
  //gtk_init (&argc, &argv);
  //g_log_set_handler ("Gtk", G_LOG_LEVEL_WARNING, g_log_default_handler, NULL);

  /* Create the main window */
  GtkWidget *win = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_default_size (GTK_WINDOW (win), 32, 32);
  gtk_layered_setup(win);

  gtk_container_set_border_width (GTK_CONTAINER (win), 0);
  gtk_window_set_title (GTK_WINDOW (win), "uSciter");


  int width = frame ? frame->right - frame->left : 800;
  int height = frame ? frame->bottom - frame->top : 600;

  if( width <= 0 ) width = 800;
  if( height <= 0 ) height = 600;

  //gtk_window_resize (GTK_WINDOW (win), width, height);

  if( !frame)
    gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_CENTER);
  else
    gtk_window_move (GTK_WINDOW (win), frame->left, frame->top);

  //g_signal_connect (win, "destroy", gtk_main_quit, NULL);
  window_params params;

  if( creationFlags & SW_CHILD ) {
    //params.window_style |= WS_CHILD;
  } else {
    if(creationFlags & SW_MAIN)
      params.is_main = true;
    if( creationFlags & SW_OWNS_VM )
      params.owns_vm = true;
    if( creationFlags & SW_ENABLE_DEBUG )
      params.debug_mode = true;
    if( creationFlags & SW_MAIN )
      params.is_main = true;

    if( creationFlags & SW_GLASSY )
      params.is_glassy = true;
    else if( creationFlags & SW_ALPHA )
      params.is_transparent = true;
  }

  if(creationFlags & SW_POPUP)
    params.window_type = html::POPUP_WINDOW;
  else if(creationFlags & SW_TOOL)
    params.window_type = html::TOOL_WINDOW;
  else if(creationFlags & SW_CHILD)
    params.window_type = html::CHILD_WINDOW;
  else
    params.window_type = html::FRAME_WINDOW;

  GtkWidget* sciter_widget = sciter_new(GTK_WINDOW (win),&params);

  gtk::view* pview = gtkview( sciter_widget );

  //gtk_container_add (GTK_CONTAINER (win), sciter_widget);
  gtk_init_sys_colors_table(sciter_widget, true);

  setup_window_callbacks(sciter_widget);

  gtk_widget_show(sciter_widget);

  if((creationFlags & SW_TITLEBAR) == 0)
    gtk_window_set_decorated(GTK_WINDOW (win), FALSE);
  else if( (creationFlags & SW_CONTROLS) == 0 )
    gtk_window_set_deletable(GTK_WINDOW (win),FALSE);

  if( (creationFlags & SW_RESIZEABLE) == 0 )
    gtk_window_set_resizable(GTK_WINDOW (win),FALSE);

  if( creationFlags & SW_MAIN )
    g_signal_connect_swapped(G_OBJECT(win), "destroy", G_CALLBACK(gtk_main_quit), NULL);

  if( creationFlags & (SW_GLASSY | SW_ALPHA) )
  {
    //gtk_layered_setup(win);
    pview->set_transparency( (creationFlags & SW_ALPHA) != 0 );
    //pview->set_glassy( (creationFlags & SW_GLASSY) != 0 );
  }
  if( creationFlags & SW_POPUP )
    gtk_window_set_skip_taskbar_hint( GTK_WINDOW (win), TRUE );

  //if( creationFlags & SW_ENABLE_DEBUG) {
  //  pview->debug_mode(true);
  //}

  gtk_window_set_default_size(GTK_WINDOW(win), width, height);

  gtk_widget_realize (win);

  //pview->_client_dim = gool::size(width, height);
  //pview->_window_dim = gool::size(width, height);
  //gtk_window_resize(GTK_WINDOW (win), width, height);
  //gtk_widget_set_size_request (win, width, height);

  pview->start(params);


  return sciter_widget;
}

rect gtk_screen_workarea( gtk::view* nparent = nullptr )
{
    if( nparent )
      return nparent->screen_workarea();

    GdkScreen* screen = gdk_screen_get_default();
    GdkRectangle dest;
    gdk_screen_get_monitor_geometry (screen, gdk_screen_get_primary_monitor(screen), &dest);
    return gtk::cvt(dest);
}

handle<gtk::view> gtk_create_frame(const window_params& params)
{
    gool::rect drc(params.pos,params.dim);

    bool needs_debug = params.debug_mode.val( params.parent ? params.parent->debug_mode() : false );

    GtkWidget* sciter_widget = sciter_new(nullptr,&params);
    handle<gtk::view> pview = gtkview( sciter_widget );

    //pview->parent(params.parent);
    //pview->type = params.window_type;


    ustring caption = params.caption;

    bool require_layered = false;

    html::view::frame_attributes fatts;


    GtkWindowType     gwt = GTK_WINDOW_TOPLEVEL;
    GdkWindowTypeHint gwhint = GDK_WINDOW_TYPE_HINT_NORMAL;

    switch( params.window_type )
    {
        default:
        case html::FRAME_WINDOW:  gwt = GTK_WINDOW_TOPLEVEL ; break;
        case html::DIALOG_WINDOW: gwt = GTK_WINDOW_TOPLEVEL ; gwhint = GDK_WINDOW_TYPE_HINT_DIALOG; break;
        case html::TOOL_WINDOW:   gwt = GTK_WINDOW_TOPLEVEL ; gwhint = GDK_WINDOW_TYPE_HINT_UTILITY; break;
        case html::POPUP_WINDOW:  gwt = GTK_WINDOW_TOPLEVEL ; gwhint = GDK_WINDOW_TYPE_HINT_UTILITY; break;
    }


    GtkWidget *win = gtk_window_new (gwt);

    if( params.window_type == html::POPUP_WINDOW) {
      gtk_window_set_decorated( GTK_WINDOW (win), FALSE);
      gtk_window_set_skip_taskbar_hint( GTK_WINDOW (win), TRUE );
    }

    //gtk_window_set_default_size (GTK_WINDOW (win), 32, 32);
    gtk_window_set_type_hint (GTK_WINDOW (win),gwhint);
    gtk_layered_setup(win);
    gtk_container_set_border_width (GTK_CONTAINER (win), 0);
    //gtk_window_set_title (GTK_WINDOW (win), "uSciter");

    gool::rect wrc = params.dim.empty() ? gool::rect(gool::size(800,600)) : rect( params.pos,params.dim );

    gtk_container_add (GTK_CONTAINER (win), sciter_widget);
    gtk_widget_show(sciter_widget);
    gtk_init_sys_colors_table(sciter_widget, true);

    setup_window_callbacks(sciter_widget);

    //[nv setExtDelegate: (id)delegate];
    html::FRAME_TYPE ft = html::FRAME_TYPE::STANDARD;

    if(params.window_type == html::POPUP_WINDOW && params.parent)
       gtk_window_set_transient_for(GTK_WINDOW (win), gtkwindow(params.parent->get_hwnd()));
    //if(params.window_type == html::POPUP_WINDOW)
    //   gtk_window_set_decorated(GTK_WINDOW (win), FALSE);

    gtk_widget_realize( win );

    pview->start(params);

    auto realized = gtk_widget_get_realized(win);


    //if( !!params.data )
    {
        //handle<html::request> hrq = new html::request( params.url, html::DATA_HTML );
        //hrq->rq_type = html::RQ_PUSH;
        //hrq->data = params.data;
        //pview->load(hrq);
        //pview->on_data_loaded(hrq);

        if( html::document* pd = pview->doc() ){

            html::element* title = html::find_first( *pview, pd, WCHARS(":root>head>title") );
            if( title )
              caption = title->get_text(*pview);

            pview->required_frame_attributes(fatts);

            ft = (html::FRAME_TYPE) fatts.frame_type.val(ft);

            //resizeable = pd->atts.get_bool("resizeable",resizeable);
            //custom_frame = pd->atts.get_bool("custom-frame");
            html::style* cs = pd->get_style(*pview);
            require_layered = ft == html::LAYERED || cs->is_transparent() || cs->opacity != 255 || cs->has_rounded_corners();

            gool::rect parentrc = gtk_screen_workarea( params.parent.ptr_of<gtk::view>() );

            gool::size ssz = parentrc.size();

            gool::size msz = params.dim;
            if( msz.x <= 0 ) {
               msz.x = pd->min_width(*pview,ssz.x);
               if( msz.x <= 0 )
                 msz.x = min(640,parentrc.width() / 2);
            }
            if( pd->dim().x != msz.x )
                pd->set_width(*pview,msz.x);
            if( msz.y <= 0 ) {
              msz.y = pd->min_height(*pview,ssz.y);
              if( msz.y <= 0 )
                msz.y = min(480,parentrc.height() / 2);
            }

            /*size wdim = pview->window_dim();
            size cdim = pview->client_dim();

            if(!wdim.empty() && !cdim.empty()) {
                msz += pview->window_dim();
                msz -= pview->client_dim();
            }*/

            gool::point pt = params.pos;

            wrc = gool::rect( pt,msz );

            //wrc >>= pd->outer_distance(*pview);
            //pd->measure(*pview, msz);

            if( params.alignment < 0 && params.alignment >= -9)
            {
                if( params.parent ) {
                   parentrc = params.parent->screen_workarea();
                   wrc.pointOf(abs(params.alignment),params.parent->screen_place().pointOf(abs(params.alignment)));
                }
                else
                   wrc.pointOf(abs(params.alignment),parentrc.pointOf(abs(params.alignment)));
            }
            else if( params.alignment > 0 && params.alignment <= 9 )
            {
                wrc.pointOf(params.alignment,parentrc.pointOf(params.alignment));

            }
            else if( params.alignment > 9 )
            {
                wrc.pointOf(5,parentrc.pointOf(5));
            }

            //inscribe_to_screen(pview,wrc,drc);
            wrc.inscribe(parentrc);

        }
    }

    bool layered = false;
    if( fatts.frame_type.is_undefined() )
        layered = require_layered;
    else
        layered = ft == html::LAYERED;

    //
    // WRONG here gtk_window_set_decorated( GTK_WINDOW (win), ft == html::STANDARD);

    if( layered ) {
      pview->set_transparency( layered );
      //pview->set_glassy( false );
    }
    //else
    //  pview->set_glassy( true );

    if(ft != html::STANDARD)
      gtk_window_set_decorated( GTK_WINDOW (win), FALSE);

    gtk_window_set_title( GTK_WINDOW (win), u8::cvt(caption) ) ;
    //gtk_window_set_resizable(GTK_WINDOW (win) , resizeable.val(params.window_type == html::FRAME_WINDOW) );

    pview->set_resizeable(fatts.resizeable.val(params.window_type == html::FRAME_WINDOW));
    //pview->move_window(wrc);

    //gtk_window_set_policy (GTK_WINDOW (win), TRUE, TRUE, TRUE);
    //gtk_window_set_default_size (GTK_WINDOW (win), wrc.width(), wrc.height());

    //if(!pview->window_was_moved)
    {
      //gtk_window_set_default_size (GTK_WINDOW (win), 10, 10);
      //gtk_widget_set_size_request(win, wrc.width(), wrc.height());
      //pview->_client_dim = wrc.size();
      //pview->_window_dim = wrc.size();
      //gtk_window_move (GTK_WINDOW (win), wrc.origin.x, wrc.origin.y);
      pview->move_window(wrc);
    }
    //gtk_widget_show(sciter_widget);

    return pview;
}


typedef struct
{
  GtkWindow *dialog;
  gint response_id;
  GMainLoop *loop;
  gboolean destroyed;
} RunInfo;

static void shutdown_loop (RunInfo *ri)
{
  if (g_main_loop_is_running (ri->loop))
    g_main_loop_quit (ri->loop);
}

static void run_unmap_handler (GtkDialog *dialog, gpointer data)
{
  RunInfo *ri = (RunInfo *)data;
  shutdown_loop (ri);
}

static void run_destroy_handler (GtkDialog *dialog, gpointer data)
{
  RunInfo *ri = (RunInfo *)data;
  /* shutdown_loop will be called by run_unmap_handler */
  ri->destroyed = TRUE;
}

gint gtk_run_dialog (GtkWindow *dialog)
{
  RunInfo ri = { NULL, GTK_RESPONSE_NONE, NULL, FALSE };
  gboolean was_modal = FALSE;
  gboolean was_hide_on_close;
  gulong unmap_handler;
  gulong destroy_handler;

  g_object_ref (dialog);

  was_modal = gtk_window_get_modal (GTK_WINDOW (dialog));
  gtk_window_set_modal (GTK_WINDOW (dialog), FALSE); // Note FALSE, otherwise popups will not work, why?
                                                     // Because it does gtk_grab_add (widget); for some reason

  //was_hide_on_close = gtk_window_get_hide_on_close (GTK_WINDOW (dialog));
  //gtk_window_set_hide_on_close (GTK_WINDOW (dialog), TRUE);

  if (!gtk_widget_get_visible (GTK_WIDGET (dialog)))
    gtk_widget_show (GTK_WIDGET (dialog));

  unmap_handler =
    g_signal_connect (dialog,
                      "unmap",
                      G_CALLBACK (run_unmap_handler),
                      &ri);

  destroy_handler =
    g_signal_connect (dialog,
                      "destroy",
                      G_CALLBACK (run_destroy_handler),
                      &ri);

  ri.loop = g_main_loop_new (NULL, FALSE);
  g_main_loop_run (ri.loop);
  g_main_loop_unref (ri.loop);

  ri.loop = NULL;

  if (!ri.destroyed)
    {
      gtk_window_set_modal (GTK_WINDOW (dialog), was_modal);
      //gtk_window_set_hide_on_close (GTK_WINDOW (dialog), was_hide_on_close);
      g_signal_handler_disconnect (dialog, unmap_handler);
      g_signal_handler_disconnect (dialog, destroy_handler);
    }

  g_object_unref (dialog);
  return ri.response_id;
}
