#ifndef __GTK_VIRT_KEYS_H__
#define __GTK_VIRT_KEYS_H__

#include <gtk/gtk.h>

/*
 * Virtual Keys, Standard Set
 */
#define KB_LBUTTON        -1//0x01
#define KB_RBUTTON        -2//0x02
#define KB_CANCEL         -3//0x03
#define KB_MBUTTON        -4//0x04

#define KB_BACK           GDK_KEY_BackSpace
#define KB_TAB            GDK_KEY_Tab
#define KB_CLEAR          -5//0//x0C

#define KB_RETURN         GDK_KEY_Return
#define KB_SHIFT          GDK_KEY_Shift_L
#define KB_LSHIFT         GDK_KEY_Shift_L
#define KB_RSHIFT         GDK_KEY_Shift_R

#define KB_SHORTCUT       GDK_KEY_Control_L
#define KB_CONTROL        GDK_KEY_Control_L
#define KB_LCONTROL       GDK_KEY_Control_L
#define KB_RCONTROL       GDK_KEY_Control_R
#define KB_SNAPSHOT       GDK_KEY_Print
#define KB_PRINT          GDK_KEY_Print

#define KB_ESCAPE         GDK_KEY_Escape
#define KB_PAUSE          GDK_KEY_Pause

#define KB_MENU           GDK_KEY_Menu

#define KB_CAPITAL        GDK_KEY_Caps_Lock //GDK_KEY_Num_Lock
//#define GDK_KEY_Kana_Lock           -6//0x15
#define KB_HANGUL         -7//0x15
#define KB_JUNJA          -8//0x17
#define KB_FINAL          -9//0x18
#define KB_HANJA          -10//0x19
#define KB_KANJI          -11//0x19

#define KB_CONVERT        -12//0x1C
#define KB_NONCONVERT     -13//0x1D
#define KB_ACCEPT         -14//0x1E
#define KB_MODECHANGE     -15//0x1F

#define KB_SPACE          GDK_KEY_space
#define KB_PRIOR          GDK_KEY_Page_Up
#define KB_NEXT           GDK_KEY_Page_Down
#define KB_END            GDK_KEY_End
#define KB_HOME           GDK_KEY_Home
#define KB_LEFT           GDK_KEY_Left
#define KB_UP             GDK_KEY_Up
#define KB_RIGHT          GDK_KEY_Right
#define KB_DOWN           GDK_KEY_Down

#define KB_SELECT         -16//0x29
#define KB_EXECUTE        -17//0x2B

#define KB_INSERT         GDK_KEY_Insert
#define KB_DELETE         GDK_KEY_Delete
#define KB_HELP           -18//0x2F
#define KB_LWIN           0x85
#define KB_RWIN           134
#define KB_APPS           -19//0x5D
#define KB_NUMPAD0        GDK_KEY_KP_0
#define KB_NUMPAD1        GDK_KEY_KP_1
#define KB_NUMPAD2        GDK_KEY_KP_2
#define KB_NUMPAD3        GDK_KEY_KP_3
#define KB_NUMPAD4        GDK_KEY_KP_4
#define KB_NUMPAD5        GDK_KEY_KP_5
#define KB_NUMPAD6        GDK_KEY_KP_6
#define KB_NUMPAD7        GDK_KEY_KP_7
#define KB_NUMPAD8        GDK_KEY_KP_8
#define KB_NUMPAD9        GDK_KEY_KP_9
#define KB_MULTIPLY       GDK_KEY_KP_Multiply
#define KB_ADD            GDK_KEY_KP_Add
#define KB_SEPARATOR      GDK_KEY_KP_Separator
#define KB_SUBTRACT       GDK_KEY_KP_Subtract
#define KB_DECIMAL        GDK_KEY_KP_Decimal
#define KB_DIVIDE         GDK_KEY_KP_Divide
#define KB_F1             GDK_KEY_F1
#define KB_F2             GDK_KEY_F2
#define KB_F3             GDK_KEY_F3
#define KB_F4             GDK_KEY_F4
#define KB_F5             GDK_KEY_F5
#define KB_F6             GDK_KEY_F6
#define KB_F7             GDK_KEY_F7
#define KB_F8             GDK_KEY_F8
#define KB_F9             GDK_KEY_F9
#define KB_F10            GDK_KEY_F10
#define KB_F11            GDK_KEY_F11
#define KB_F12            GDK_KEY_F12

#define KB_F13            GDK_KEY_F13
#define KB_F14            GDK_KEY_F14
#define KB_F15            GDK_KEY_F15
#define KB_F16            GDK_KEY_F16
#define KB_F17            GDK_KEY_F17
#define KB_F18            GDK_KEY_F18
#define KB_F19            GDK_KEY_F19
#define KB_F20            GDK_KEY_F20
#define KB_F21            GDK_KEY_F21
#define KB_F22            GDK_KEY_F22
#define KB_F23            GDK_KEY_F23
#define KB_F24            GDK_KEY_F24

#define KB_NUMLOCK        GDK_KEY_Num_Lock
#define KB_SCROLL         GDK_KEY_Scroll_Lock

#define KB_Q             GDK_KEY_q
#define KB_W             GDK_KEY_w
#define KB_E             GDK_KEY_e
#define KB_R             GDK_KEY_r
#define KB_T             GDK_KEY_t
#define KB_Y             GDK_KEY_y
#define KB_U             GDK_KEY_u
#define KB_I             GDK_KEY_i
#define KB_O             GDK_KEY_o
#define KB_P             GDK_KEY_p
#define KB_RIGHTBRACKET  GDK_KEY_bracketright // [
#define KB_LEFTBRACKET   GDK_KEY_bracketleft // ]
#define KB_BACKSLASH     GDK_KEY_backslash // |

#define KB_A             GDK_KEY_a
#define KB_S             GDK_KEY_s
#define KB_D             GDK_KEY_d
#define KB_F             GDK_KEY_f
#define KB_G             GDK_KEY_g
#define KB_H             GDK_KEY_h
#define KB_J             GDK_KEY_j
#define KB_K             GDK_KEY_k
#define KB_L             GDK_KEY_l
#define KB_SEMICOLON     GDK_KEY_semicolon  // ;:
#define KB_QUOTE         GDK_KEY_quoteright // '"

#define KB_Z             GDK_KEY_z
#define KB_X             GDK_KEY_x
#define KB_C             GDK_KEY_c
#define KB_V             GDK_KEY_v
#define KB_B             GDK_KEY_b
#define KB_N             GDK_KEY_n
#define KB_M             GDK_KEY_m

#define KB_COMMA         GDK_KEY_comma
#define KB_DOT           GDK_KEY_period
#define KB_SLASH         GDK_KEY_slash

#define KB_1             GDK_KEY_1
#define KB_2             GDK_KEY_2
#define KB_3             GDK_KEY_3
#define KB_4             GDK_KEY_4
#define KB_5             GDK_KEY_5
#define KB_6             GDK_KEY_6
#define KB_7             GDK_KEY_7
#define KB_8             GDK_KEY_8
#define KB_9             GDK_KEY_9
#define KB_0             GDK_KEY_0
#define KB_MINUS         GDK_KEY_minus
#define KB_PLUS          GDK_KEY_equal


#endif
