#ifndef __GTK_VIEW_H_INCLUDED__
#define __GTK_VIEW_H_INCLUDED__

#include "gtk-sciter.h"
#include "gtk-graphics.h"

namespace gtk {

  using namespace tool;
  using namespace gool;
  using namespace html;

  class popup;

  class view :
#if defined(SCITER)
      public tis::xview
#elif defined(SCITERJS)
      public qjs::xview
#endif
  {
  public:
#if defined(SCITER)
    typedef tis::xview view_type_t;
    typedef tis::xview super;
#elif defined(SCITERJS)
    typedef qjs::xview view_type_t;
    typedef qjs::xview super;
#endif

    enum { MOUSE_IDLE_TIMER_ID = 1};

    view(const window_params& params)
    : super(params)
    , _idle_id(0)
    , _delegate(0)
    , _delegate_param(0)
    , _gfx(0)
    , _is_closing(false)
    , _mouse_idle_timer_id(0)
    , _window_state( WINDOW_STATE_NA )
    //, _is_glassy(false)
    , _is_transparent(false)
    {
      _app_holder = gool::app();
      init_media_vars();
    }
    virtual ~view() {
      //setup_mouse_idle(false);
      if(_idle_id) {
        g_source_remove (_idle_id);
        _idle_id = 0;
      }

      //pdoc = pdoc;
    }

    virtual bool needs_opengl() { return false; }

    void attach(GtkWidget* gview) { set_hwnd(gview); _window_state = WINDOW_HIDDEN; } // this object got HWND to it, _hwnd field is valid, ctor
    void detach() { stop(); set_hwnd(nullptr); } // detaching the instance from NSView

    //virtual HWINDOW get_hwnd() const override { return _widget; }
    virtual html::VIEW_TYPE view_type() const override { return type == html::DIALOG_WINDOW ? html::VIEW_DIALOG: html::VIEW_WINDOW; }

    //        bool is_transparent() const { return !!_is_transparent; }
    virtual void set_transparency( bool on_off ) override { _is_transparent = on_off; }
    virtual bool get_transparency() const override { return _is_transparent; }

    //virtual void set_glassy( bool on_off ) { _is_glassy = on_off; }
    //virtual bool get_glassy() const { return _is_glassy; }

    virtual gool::graphics* surface() override;

    virtual bool add_animation(element* b, animation* pba, const style* new_style, const style* old_style ) override;
    virtual void on_animation_tick() override;
            bool on_animation_tick(uint atick);
    virtual bool request_animation_frame(uint delay = 0) override;
    virtual void stop_animation_frames() override;
    virtual uint get_animation_ticks() override;

    virtual bool is_active() const override;
    virtual bool activate(bool and_bring_to_front) override;
    //virtual bool set_focus(element* b, FOCUS_CAUSE cause, bool postfactum) override;
    virtual bool do_set_focus(
        helement b, FOCUS_CAUSE cause,
        bool postfactum = false /* true -shall not try to set focus on HWND*/) override;

    virtual size pixels_per_inch() override;
    //virtual element* element_under_cursor(/* out, view related */ gool::point& cursor_pos ) override;
    virtual void          set_cursor(gool::cursor* pcur) override;
    virtual gool::cursor* get_cursor() override;

    virtual void  stop() override;

    virtual void  do_request_idle() override;
    virtual void  set_timer(uint_ptr id, uint ms, uint_ptr& sys_id) override;
    virtual bool  on_timer(uint_ptr uid) override;

            //void  setup_mouse_idle(bool on, point pt = point());

    virtual bool ask_close_window(bool by_chrome = false) override;
    virtual bool close_window() override;

            bool rq_close_window();

    virtual array<ustring> ask_file_name(AFN_MODE mode, const ustring& caption, const ustring& filename, const wchar* def_ext, const wchar* filter) override;
    virtual bool ask_folder_name(const ustring& caption, ustring& foldername) override;

    virtual void         replace_windowed() override;
    virtual rect         window_decoration() const override;
            rect         update_window_decoration();
    virtual void         move_window(const rect& spos, bool clent_rc = false) override;
    virtual WINDOW_STATE get_window_state() const override;
    virtual bool         set_window_state( WINDOW_STATE ws ) override;
    virtual ustring      get_window_title() const override;
    virtual bool         set_window_title(const wchar* title) override;

    virtual bool         set_icon(gool::image *pimg) override;

    //virtual bool         show() override;
    virtual bool         show_modal() override;

    virtual bool         do_event( DO_EVENT_MANNER m, bool& result ) override;

    virtual void setup_text_flow( html::element* elem, html::tflow::text_flow& tf, tool::slice< tool::handle<html::node> > nodes ) override;
    virtual void draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, argb color, const style* run_style) override;

    //virtual gool::text_layout* create_text_layout(wchars text, const text_format& tf) override;

    virtual iwindow*  create_window( html::element* forel, html::element* anchor, html::WINDOW_TYPE wt, function<rect(html::view&,html::element*,html::element*)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode = ELEMENT_WINDOW_AUTO ) override;
    virtual  bool     close_popup( element* b, bool set_auto_focus ) override;
    virtual popup*    create_popup(html::WINDOW_TYPE wt);

    virtual GRAPHICS_CAPS graphics_caps() const override { return SOFTWARE_GRAPHICS; }
    ustring               graphics_backend() const override { return ustring(W("cairo")); }

    virtual void init_media_vars() override;

    virtual int get_window_metrics(tool::value::length_special_values what) override;

    virtual bool render(void* dc, rect client_rc) override;
    virtual bool render_layered(void *dc, rect client_rc) override { return render(dc, client_rc); }

    virtual void render(graphics* pg, gool::rect dirty_rc); // removed from html::iwindow

    void post_posted_callback(uint_ptr wp, uint_ptr lp);

    static gboolean idle_callback (gpointer user_data);
    static gboolean mouse_idle_timer_callback(gpointer user_data);

    void update_window_state(WINDOW_STATE st) {
      _window_state = st;
      on_state_changed();
    }

    virtual float_v aspect_ratio() const override { return _aspect_ratio; }
    virtual void    aspect_ratio(float_v r) override;

    virtual bool get_min_size(gool::size& sz) override;
    virtual bool get_max_size(gool::size& sz) override;
    virtual bool set_min_size(gool::size sz = gool::size()) override;
    virtual bool set_max_size(gool::size sz = gool::size()) override;

    virtual bool        set_resizeable(bool on);
    virtual bool        get_resizeable() const;
    virtual bool        set_topmost(bool on);
    virtual bool        get_topmost();
    virtual bool        set_minimizable(bool on);
    virtual bool        get_minimizable();
    virtual bool        set_maximizable(bool on);
    virtual bool        get_maximizable();

    //virtual size        window_dim() override; //{ if( _window_dim.x.is_defined() ) return _window_dim; return iwindow::window_dim(); }
    //virtual size        client_dim() override; //{ if( _client_dim.x.is_defined() ) return _client_dim; return iwindow::client_dim(); }

    virtual void        on_size(size sz) override { super::on_size(sz); }

    virtual bool        supports_native_ui_window_move() const override { return true; }

    FRAME_TYPE         _frame_type = STANDARD;
    virtual bool       set_frame_type(FRAME_TYPE on) override;
    virtual FRAME_TYPE get_frame_type() const override { return _frame_type; }

    GtkStatusIcon* trayicon_status_icon = nullptr;
    //GdkPixbuf*     trayicon_status_icon_pixbuf = nullptr;

    virtual bool trayicon_setup(const tray_icon_params& params) override;
    virtual bool trayicon_remove() override;
    virtual bool trayicon_place(rect& rc) override;

protected:
    //GtkWidget*            _widget;
    SciterWindowDelegate* _delegate;
    LPVOID                _delegate_param;

    html::WINDOW_STATE    _window_state;

    handle<cursor>        _cursor;

    //bool                  _is_glassy;
    bool                  _is_transparent;
    bool                  _is_closing;

    float_v               _aspect_ratio;
    dim_v_t               _min_size;
    dim_v_t               _max_size;
    tristate_v            _is_topmost;
    tristate_v            _is_resizeable;

    void                  update_geometry();

    handle<gool::application> _app_holder;
    guint                  _idle_id;
    uint_v                 _animation_ticker;
    uint_ptr               _mouse_idle_timer_id;
    point                  _mouse_idle_pos;
    static gboolean gv_on_animation_tick(GtkWidget *widget, GdkFrameClock *frame_clock, gpointer user_data);
#if 0
    static gboolean gv_anim_callback(gpointer user_data);
#endif
public:
    //dim_v_t               _window_dim;
    //dim_v_t               _client_dim;
    //mutable dim_v_t       _decorations_origin;
    //mutable dim_v_t       _decorations_corner;
    //point_v_t             _window_pos;
    tristate_v            _window_is_active;

    //rect                  _rq_window_place;
    //tristate_v            _rq_window_pos;

    //tool::event            posted_callback_complete;
    handle<graphics>       _gfx;
    tristate_v             _got_mouse_up;
    tristate_v             _closerq_by_code;
  };

}

template <typename ET>
inline uint get_alts(ET* ev) {
    uint alts = 0;
    if(ev->state & GDK_CONTROL_MASK) alts |= html::ALT_CONTROL;
    if(ev->state & GDK_MOD1_MASK) alts |= html::ALT_ALT;
    if(ev->state & GDK_SHIFT_MASK) alts |= html::ALT_SHIFT;
    //if(ev->state & GDK_MOD2_MASK) alts |= html::ALT_COMMAND;
    return alts;
}

template <typename ET>
inline uint get_mouse_buttons(ET *ev) {

    uint buttons = 0;
    if( ev->state & GDK_BUTTON1_MASK ) buttons |= html::MAIN_BUTTON;
    if( ev->state & GDK_BUTTON2_MASK ) buttons |= html::PROP_BUTTON;
    if( ev->state & GDK_BUTTON3_MASK ) buttons |= html::MIDDLE_BUTTON;
    return buttons;
}

inline uint get_mouse_buttons(GdkEventButton *ev) {

    uint buttons = 0;

    if( ev->button == GDK_BUTTON_PRIMARY ) buttons = html::MAIN_BUTTON;
    else if( ev->button == GDK_BUTTON_SECONDARY ) buttons = html::PROP_BUTTON;
    else if( ev->button == GDK_BUTTON_MIDDLE ) buttons = html::MIDDLE_BUTTON;

    return buttons;
}


#if 0
extern "C" {

#define GTK_SCITER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, sciter_get_type (), SciterObject)
#define GTK_SCITER_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, sciter_get_type (), SciterClass)
#define IS_GTK_SCITER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, sciter_get_type ())


struct _SciterObject {
  GtkDrawingArea darea;
  gtk::view*     pview;
};

struct _SciterClass {
  GtkDrawingAreaClass parent_class;
//
//  void (* command) (struct _SciterObject *ttt);
//  void (* notify) (struct _SciterObject *ttt);
};

typedef struct _SciterObject SciterObject;
typedef struct _SciterClass  SciterClass;

extern void sciter_class_init(SciterClass *klass);
extern void sciter_init(SciterObject *sci);


GType      sciter_get_type  (void);
//void       sciter_set_id  (SciterObject *sci, uptr_t id);
//sptr_t     sciter_send_message  (SciterObject *sci,unsigned int iMessage, uptr_t wParam, sptr_t lParam);
void       sciter_release_resources(void);

}
#endif

extern GtkWidget* sciter_new(GtkWindow* pwin, const window_params* params);


extern gtk::view* gtkview(HWINDOW hw);
extern GtkWindow* gtkwindow(HWINDOW hwnd);
extern GtkWindow* gtkwindow(const gtk::view* pv);


#endif // GTK-VIEW_H_INCLUDED
