#include "gtk-view.h"
#include "gtk-graphics.h"
#include "gtk-application.h"
#include <gdk/gdkkeysyms.h>
#include <X11/Xlib.h>

#if defined(USE_SKIA)
#include "xgl/xgl.h"
#endif

//tool::hash_map<GtkWidget*,gtk::view*>
//tool::hash_table<uint_ptr,tool::handle<gtk::view>> g_all;

//gtk_view* GObject *object

gtk::view* gtkview(GtkWidget* hw)
{
  return html::view::ptr<gtk::view>(hw);
}

GdkEvent* current_event = nullptr;

//static GtkWidgetClass super_klass;

#if defined(USE_SKIA)
static gboolean gv_render (GtkGLArea *area, GdkGLContext *context, gpointer data); // OpenGL
static void     gv_resize(GtkGLArea *area, gint width,gint height, gpointer data);
#endif
static gboolean gv_draw(GtkWidget	 *widget, cairo_t *cr, gpointer data); // cairo
static void     gv_size_allocate(GtkWidget *widget, GtkAllocation *allocation, gpointer data);
static gboolean gv_configuration(GtkWidget *widget, GdkEvent *event, gpointer data);


static gboolean gv_button_press_event(GtkWidget	*widget, GdkEventButton *event, gpointer data);
static gboolean gv_button_release_event(GtkWidget	     *widget, GdkEventButton *event, gpointer data);
static gboolean gv_motion_notify_event(GtkWidget	     *widget, GdkEventMotion *event, gpointer data);
static gboolean gv_enter_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event, gpointer data);
static gboolean gv_leave_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event, gpointer data);
static gboolean gv_scroll_event(GtkWidget           *widget, GdkEventScroll      *event, gpointer data);

static gboolean gv_key_press_event(GtkWidget	     *widget, GdkEventKey	     *event, gpointer data);
static gboolean gv_key_release_event(GtkWidget	     *widget, GdkEventKey	     *event, gpointer data);

static gboolean gv_focus_in_event(GtkWidget	     *widget, GdkEventFocus	     *event, gpointer data);
static gboolean gv_focus_out_event(GtkWidget	 *widget, GdkEventFocus	     *event, gpointer data);
static void     gv_attached (GtkWidget *widget, gpointer   data);

extern gool::size gtk_pixels_per_inch(GdkScreen* ds);

extern uint module_version(bool major);

extern gint gtk_run_dialog (GtkWindow *dialog);

extern "C" {

/*GType sciter_get_type() {
	static GType sciter_type = 0;

	if (!sciter_type) {
		sciter_type = g_type_from_name("Sciter");
		if (!sciter_type) {
			static GTypeInfo sciter_info = {
				(guint16) sizeof (SciterClass),
				NULL, //(GBaseInitFunc)
				NULL, //(GBaseFinalizeFunc)
				(GClassInitFunc) sciter_class_init,
				NULL, //(GClassFinalizeFunc)
				NULL, //gconstpointer data
				(guint16) sizeof (SciterObject),
				0, //n_preallocs
				(GInstanceInitFunc) sciter_init,
				NULL //(GTypeValueTable*)
			};

			sciter_type = g_type_register_static(
				GTK_TYPE_DRAWING_AREA, "Sciter", &sciter_info, (GTypeFlags) 0);
		}
	}

	return sciter_type;
}*/

#if 0
void sciter_class_init(SciterClass *klass) {
	GObjectClass *object_class = (GObjectClass*) klass;
	GtkWidgetClass *widget_class = (GtkWidgetClass*) klass;
	GtkDrawingAreaClass *drawing_area_class = (GtkDrawingAreaClass*) klass;

	super_klass = *widget_class;

	/*
	GSignalFlags sigflags = GSignalFlags(G_SIGNAL_ACTION | G_SIGNAL_RUN_LAST);
	sciter_signals[COMMAND_SIGNAL] = g_signal_new(
	                                       "sciter-command",
	                                       G_TYPE_FROM_CLASS(object_class),
	                                       sigflags,
	                                       G_STRUCT_OFFSET(SciterClass, command),
	                                       NULL, //(GSignalAccumulator)
	                                       NULL, //(gpointer)
	                                       SIG_MARSHAL,
	                                       G_TYPE_NONE,
	                                       2, MARSHAL_ARGUMENTS);

	sciter_signals[NOTIFY_SIGNAL] = g_signal_new(
	                                       "sciter-notify",
	                                       G_TYPE_FROM_CLASS(object_class),
	                                       sigflags,
	                                       G_STRUCT_OFFSET(struct _SciterClass, notify),
	                                       NULL,
	                                       NULL,
	                                       SIG_MARSHAL,
	                                       G_TYPE_NONE,
	                                       2, MARSHAL_ARGUMENTS);
	                                       */
	//klass->command = NULL;
	//klass->notify = NULL;

	//atomClipboard = gdk_atom_intern("CLIPBOARD", FALSE);
	//atomUTF8 = gdk_atom_intern("UTF8_STRING", FALSE);
	//atomString = GDK_SELECTION_TYPE_STRING;
	//atomUriList = gdk_atom_intern("text/uri-list", FALSE);
	//atomDROPFILES_DND = gdk_atom_intern("DROPFILES_DND", FALSE);

	// Define default signal handlers for the class:  Could move more
	// of the signal handlers here (those that currently attached to wDraw
	// in Initialise() may require coordinate translation?)
	object_class->finalize = Destroy;
	widget_class->draw = gv_draw;
	widget_class->size_allocate = gv_size_allocate;
	widget_class->motion_notify_event = gv_motion_notify_event;
	widget_class->button_press_event = gv_button_press_event;
	widget_class->button_release_event = gv_button_release_event;
	widget_class->key_press_event = gv_key_press_event;
	widget_class->key_release_event = gv_key_release_event;
	widget_class->scroll_event = gv_scroll_event;
	widget_class->enter_notify_event = gv_enter_notify_event;
	widget_class->leave_notify_event = gv_leave_notify_event;
    widget_class->focus_in_event = gv_focus_in_event;
	widget_class->focus_out_event = gv_focus_out_event;

	/*widget_class->size_request = SizeRequest;
	widget_class->expose_event = ExposeMain;
	widget_class->motion_notify_event = Motion;
	widget_class->button_press_event = Press;
	widget_class->button_release_event = MouseRelease;
	widget_class->scroll_event = ScrollEvent;
	widget_class->focus_in_event = FocusIn;
	widget_class->focus_out_event = FocusOut;
	widget_class->selection_received = SelectionReceived;
	widget_class->selection_get = SelectionGet;
	widget_class->selection_clear_event = SelectionClear;

	widget_class->drag_data_received = DragDataReceived;
	widget_class->drag_motion = DragMotion;
	widget_class->drag_leave = DragLeave;
	widget_class->drag_end = DragEnd;
	widget_class->drag_drop = Drop;
	widget_class->drag_data_get = DragDataGet;

	widget_class->realize = Realize;
	widget_class->unrealize = UnRealize;
	widget_class->map = Map;
	widget_class->unmap = UnMap; */

	//drawing_area_class->forall = MainForAll;
}




void sciter_init(SciterObject *sci) {
	//GTK_WIDGET_SET_FLAGS(sci, GTK_CAN_FOCUS);
	gtk_widget_set_can_focus(GTK_WIDGET(sci),TRUE);
	//sci->psview = new SciterGTK(sci);
}
#endif

}


GtkWindow* gtkwindow(HWINDOW hwnd) {
  if(!hwnd) return nullptr;
  GtkWidget* gw = gtk_widget_get_toplevel(hwnd);
  if(!gw) return nullptr;
  return GTK_WINDOW(gw);
}

GtkWindow* gtkwindow(const gtk::view* pv) {
  return gtkwindow(pv->get_hwnd());
}

static void gv_destroy( GtkWidget *widget, gpointer   data )
{
    gtk::view *pv = static_cast<gtk::view*>(data);
    assert(pv);
	if( pv ) {
     handle<gtk::view> self = pv;
     self->stop();
     self->set_hwnd(nullptr);
	  //self->release();
	}
}

/*static void force_update(GtkWidget* area) {
  GtkAllocation reg;
  gtk_widget_get_allocation((GtkWidget*)area, &reg);
  cairo_region_t *creg = cairo_region_create_rectangle(&reg);
  cairo_t *cr = gdk_cairo_create(gtk_widget_get_window((GtkWidget*)area));
  gdk_cairo_region(cr, creg);
  cairo_clip(cr);
  gtk_widget_draw((GtkWidget*)area, cr);
  cairo_destroy(cr);
  cairo_region_destroy(creg);
}*/

static void     gv_attached (GtkWidget *widget, gpointer   data)
{
    gtk::view *pv = static_cast<gtk::view*>(data);
    assert(pv);
	if( pv ) {
 	  //pv->set_hwnd(widget);
	}
}


GtkWidget* sciter_new(GtkWindow* pwin, const window_params* params) {

//#ifdef USE_SKIA
//	scit->pview = gtk::app()->create_window_processor(params);
//#else
//	scit->pview = new gtk::view(params);
//#endif
	//html::view_creation_params params(wtype);
    handle<gtk::view> pview = gtk::app_factory()->create_window_processor(*params);

#if defined(USE_SKIA)
    GtkWidget *widget = pview->needs_opengl()?
        gtk_gl_area_new () :
        gtk_drawing_area_new ();
#else
    GtkWidget *widget = gtk_drawing_area_new ();
#endif
	if(pwin)
	  gtk_container_add (GTK_CONTAINER (pwin), widget);

    //g_all[uint_ptr(G_OBJECT((widget)))] = pview;
    pview->set_hwnd(widget);
    //pview->attach(widget);

    gtk_widget_set_can_focus(widget,TRUE);

    g_signal_connect (widget, "destroy", G_CALLBACK (gv_destroy), pview.ptr());

    g_signal_connect (widget, "motion-notify-event", G_CALLBACK (gv_motion_notify_event), pview.ptr());
    g_signal_connect (widget, "button-press-event", G_CALLBACK (gv_button_press_event), pview.ptr());
    g_signal_connect (widget, "button-release-event", G_CALLBACK (gv_button_release_event), pview.ptr());

    g_signal_connect (widget, "key-press-event", G_CALLBACK (gv_key_press_event), pview.ptr());
    g_signal_connect (widget, "key-release-event", G_CALLBACK (gv_key_release_event), pview.ptr());

    g_signal_connect (widget, "scroll-event", G_CALLBACK (gv_scroll_event), pview.ptr());
    g_signal_connect (widget, "enter-notify-event", G_CALLBACK (gv_enter_notify_event), pview.ptr());
    g_signal_connect (widget, "leave-notify-event", G_CALLBACK (gv_leave_notify_event), pview.ptr());

    g_signal_connect (widget, "focus-in-event", G_CALLBACK (gv_focus_in_event), pview.ptr());
    g_signal_connect (widget, "focus-out-event", G_CALLBACK (gv_focus_out_event), pview.ptr());

    g_signal_connect (widget, "focus-out-event", G_CALLBACK (gv_focus_out_event), pview.ptr());
    g_signal_connect (widget, "realize", G_CALLBACK (gv_attached), pview.ptr());



    if(pview->needs_opengl()) {
#if defined(USE_SKIA)
        g_signal_connect (widget, "render", G_CALLBACK (gv_render), pview.ptr());
        g_signal_connect (widget, "resize", G_CALLBACK (gv_resize), pview.ptr());
        //gtk_widget_set_double_buffered (GTK_WIDGET(gtkwindow(widget)), FALSE);
        gtk_widget_set_app_paintable(GTK_WIDGET(gtkwindow(widget)),TRUE);
#else
	assert(false);
#endif
    }
    else {
        g_signal_connect (widget, "draw", G_CALLBACK (gv_draw), pview.ptr());
        g_signal_connect (widget, "size-allocate", G_CALLBACK (gv_size_allocate), pview.ptr());
    }


    gtk_widget_set_events (widget,
         GDK_EXPOSURE_MASK
       | GDK_ENTER_NOTIFY_MASK
       | GDK_LEAVE_NOTIFY_MASK
	   | GDK_BUTTON_PRESS_MASK
       | GDK_BUTTON_RELEASE_MASK
       | GDK_POINTER_MOTION_MASK
       | GDK_KEY_PRESS_MASK
       | GDK_KEY_RELEASE_MASK
       | GDK_FOCUS_CHANGE_MASK
       | GDK_SCROLL_MASK
       );
  return widget;
}

HWINDOW SciterCreateWidget_api( LPRECT frame ) // returns GtkWidget
{
  window_params params(html::CHILD_WINDOW);
  GtkWidget* gw = sciter_new(nullptr, &params);
  return gw;
}

//void gtk_deliver_posted_callback(gtk::view* pv, uint_ptr wp, uint_ptr lp);

static gboolean gv_draw(GtkWidget* widget, cairo_t* cr, gpointer data)
{
  gtk::view* self = static_cast<gtk::view*>(data);
  if (!self) return FALSE;

  //if (gtk_gl_area_get_error (area) != NULL)
  //  return;
  //puts("gv_draw\n");

  //return self->render();

  gool::rectd invalid;
  cairo_clip_extents(cr,&invalid.s.x,&invalid.s.y,&invalid.e.x,&invalid.e.y);

  self->draw(cr,gool::rect(invalid));


/*  gtk::view* self = static_cast<gtk::view*>(data);

  gool::rectd invalid;
  cairo_clip_extents(cr,&invalid.origin.x,&invalid.origin.y,&invalid.corner.x,&invalid.corner.y);

//#ifdef USE_SKIA
//  gool::rect rc(self->client_dim());
//  self->render(rc);
//#else

  if( !self->_gfx || self->_gfx->target() != cr )
     self->_gfx = new gtk::graphics( cr );

  self->render(self->_gfx,invalid);

//#endif // USE_SKIA
*/
  return true;
}

#if defined(USE_SKIA)
static gboolean gv_render (GtkGLArea *area, GdkGLContext *context, gpointer data)
{
  //puts("gv_render A\n");
  xgl::view* self = static_cast<xgl::view*>(data);
  if (!self)
    return FALSE;

  //if (gtk_gl_area_get_error (area) != NULL)
  //  return;
  //puts("gv_render B\n");

  return self->render_window(context);
}

static void gv_resize(GtkGLArea *area, gint width,gint height, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return;

  pv->update_window_decoration();

  pv->on_size(gool::size( width, height) );
}
#endif

static void gv_size_allocate(GtkWidget *widget, GtkAllocation *allocation, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return;


  pv->update_window_decoration();
  //gool::point pt = { allocation->x,allocation->y };
  gool::size sz = gool::size( allocation->width,allocation->height);
  pv->dim = sz;
  pv->on_size(sz);

  //printf("gv_size_allocate %d,%d\n", allocation->width,allocation->height);

}

static gboolean gv_focus_in_event(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);

  auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

  if (!pv) return false;
  //pv->on_activate(html::ACTIVATED);
  return pv->on_focus(true);
}

static gboolean gv_focus_out_event(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return false;
  auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);
  //pv->on_activate(html::INACTIVE);
  return pv->on_focus(false);
}

static gboolean gv_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
  gtk::view* pv = static_cast<gtk::view*>(data);
  if (!pv) return false;
  auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

  // pv->setup_mouse_idle(false);
  int cmd = html::MOUSE_DOWN;
  if( event->type == GDK_2BUTTON_PRESS )
    cmd = html::MOUSE_DCLICK;
  bool r = pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
  if( r ) {
    if(pv->mouse_down_on_caption && pv->supports_native_ui_window_move())
      gtk_window_begin_move_drag(gtkwindow(pv),event->button,event->x_root,event->y_root,event->time);
    return true;
  }
  return false;
}
static gboolean gv_button_release_event(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;;
	// pv->setup_mouse_idle(false);
	int cmd = html::MOUSE_UP;
	pv->_got_mouse_up = true;
	gboolean r = pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
	if( !r && event->button == GDK_BUTTON_SECONDARY )
	  pv->on_context_menu(gool::point(event->x,event->y));
    return r;
}
static gboolean gv_motion_notify_event(GtkWidget *widget, GdkEventMotion *event, gpointer data)
{
    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;
    auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);
    if( event->is_hint ) {
      //return;
      struct {
         int x;
         int y;
         GdkModifierType state;
      } em;
      gdk_window_get_pointer (event->window, &em.x, &em.y, &em.state);
      return pv->on_mouse(html::MOUSE_MOVE, get_mouse_buttons(&em),get_alts(&em),gool::point(em.x,em.y));
    }

	//pv->setup_mouse_idle(true,gool::point(event->x,event->y));

	int cmd = html::MOUSE_MOVE;
	return pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
}

static gboolean gv_scroll_event(GtkWidget           *widget, GdkEventScroll      *event, gpointer data)
{
    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;;

    auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

	int cmd = html::MOUSE_WHEEL;

	gdouble delta_x, delta_y;

	// pv->setup_mouse_idle(false);

	if(gdk_event_get_scroll_deltas ((GdkEvent*)event,&delta_x,&delta_y))
	{
	  delta_x *= MOUSE_WHEEL_UNIT;
	  delta_y *= MOUSE_WHEEL_UNIT;
	  return pv->on_mouse(cmd, make_dword(short(delta_x),short(delta_y)), get_alts(event),gool::point(event->x,event->y));
	}
	else if( event->type == GDK_SCROLL ) {
      short steps = event->direction ==  GDK_SCROLL_UP? 120:-120;
	  return pv->on_mouse(cmd, make_dword(0,steps), 0 /*get_alts(event)*/,gool::point(event->x,event->y));
	}
  return false;
}

static gboolean gv_enter_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event, gpointer data)
{
    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;
    auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

	int cmd = html::MOUSE_ENTER;
	// pv->setup_mouse_idle(false);
	return pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
}
static gboolean gv_leave_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event, gpointer data)
{
    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;
	auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

	int cmd = html::MOUSE_LEAVE;
	// pv->setup_mouse_idle(false);
	return pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
}

// map the keypad keys to their equivalent functions
static int key_translate(int keyIn) {
	switch (keyIn) {
  	case GDK_KEY_Tab:      return KB_TAB;
	  case GDK_KEY_Down:		   return KB_DOWN;
	  case GDK_KEY_Up:		     return KB_UP;
	  case GDK_KEY_Left:		   return KB_LEFT;
	  case GDK_KEY_Right:  	 return KB_RIGHT;
	  case GDK_KEY_Home:		   return KB_HOME;
	  case GDK_KEY_End:		   return KB_END;
	  case GDK_KEY_Page_Up:   return KB_PRIOR;
	  case GDK_KEY_Page_Down: return KB_NEXT;
	  case GDK_KEY_Delete:		 return KB_DELETE;
	  case GDK_KEY_Insert: 	 return KB_INSERT;
	  case GDK_KEY_Return: 		 return KB_RETURN;
	  case GDK_KEY_Escape:		   return KB_ESCAPE;
	  case GDK_KEY_BackSpace:		 return KB_BACK;
	  case GDK_KEY_KP_Add:	     return KB_ADD;
	  case GDK_KEY_KP_Subtract:  return KB_SUBTRACT;
	  case GDK_KEY_KP_Divide: 	 return KB_DIVIDE;
	  case GDK_KEY_Super_L:      return KB_LWIN;
	  case GDK_KEY_Super_R:		   return KB_RWIN;
	  case GDK_KEY_Menu:		     return KB_MENU;
	  default:
	  		  return keyIn;
	}
}

gboolean gv_key_press_event(GtkWidget	     *widget, GdkEventKey	     *event, gpointer data)
{
    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;
    auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

	// pv->setup_mouse_idle(false);

	//uint alts = get_alts(event);
	bool ctrl = (event->state & GDK_CONTROL_MASK) != 0;

  guint key = event->keyval;

//#ifdef _DEBUG

//#endif
  if(key == GDK_KEY_ISO_Left_Tab)
    key = GDK_KEY_Tab;
  else
    gdk_keyval_convert_case (key,&key,nullptr);

  bool r = pv->on_key( KEY_DOWN, key , get_alts(event));

  if (r)
    return true;

	if (ctrl)
		return r;

    guint32 ucs4 = gdk_keyval_to_unicode (event->keyval);
      //printf("ucs4 %x\n",ucs4);
    if( ucs4 )
      return pv->on_key( KEY_CHAR,ucs4,get_alts(event)) || r;
    return r;
}

static gboolean gv_key_release_event(GtkWidget	     *widget, GdkEventKey	     *event, gpointer data)
{
    gtk::view* pv = static_cast<gtk::view*>(data);
	if (!pv) return false;

    auto_state<GdkEvent*> _(current_event, (GdkEvent*)event);

	// pv->setup_mouse_idle(false);

    guint key = event->keyval;
    //gdk_keyval_convert_case (key,&key,nullptr);
    if(key == GDK_KEY_ISO_Left_Tab)
      key = GDK_KEY_Tab;
    else
      gdk_keyval_convert_case (key,&key,nullptr);

    return pv->on_key( KEY_UP,key, get_alts(event));
}

namespace gtk {

/*    struct posted_callback_info: resource {
        uint_ptr     wp;
        uint_ptr     lp;
        handle<gtk::view> pv;
    };

    gboolean view_posted_callback(gpointer user_data)
    {
        posted_callback_info* pcb = static_cast<posted_callback_info*>(user_data);
        gtk_deliver_posted_callback(pcb->pv, pcb->wp, pcb->lp );
        pcb->release();
        return FALSE;
    }

    void view::post_posted_callback(uint_ptr wp, uint_ptr lp)
    {
        posted_callback_info* pcb = new posted_callback_info();
        pcb->add_ref();
        pcb->pv = this;
        pcb->wp = wp;
        pcb->lp = lp;

        g_idle_add( view_posted_callback , pcb );

    } */

    gool::graphics* view::surface()
    {
      return _gfx;
    }

    bool view::is_active() const
    {
      return gtk_window_is_active(gtkwindow(this));
    }
    bool view::do_set_focus(helement b, FOCUS_CAUSE cause, bool postfactum)
    {
      if(is_enabled() && !postfactum) {
        gtk_widget_show(GTK_WIDGET(gtkwindow(this)));
        async([this]() -> bool {
          //gtk_window_present_with_time(gtkwindow(this),GDK_CURRENT_TIME);
          gtk_window_present(gtkwindow(this));
          return true;
        });
      }
      return super::do_set_focus(b, cause, postfactum);
    }

    bool view::activate(bool and_bring_to_front) {
      //gtk_window_activate_default (gtkwindow(this));
      gtk_window_present(gtkwindow(this));
      gtk_window_activate_default (gtkwindow(this));
      return true;
    }


    bool  view::on_timer(uint_ptr uid)
    {
      return super::on_timer(uid);
    }


    size view::pixels_per_inch()
    {
      if(dpi.x.is_defined())
        return dpi;

      gool::size r(96,96);
#if 0
      auto hwnd = get_hwnd();
      if(!hwnd)
        return r;

      auto screen = gtk_widget_get_screen (hwnd);
      if( !screen )
        return r;

      GtkWidget* gtw = gtk_widget_get_toplevel(hwnd);
      if( !gtw )
        return r;
      GdkWindow* gdw = gtk_widget_get_window(gtw);
      if( !gdw )
        return r;

      int  mn = gdk_screen_get_monitor_at_window(screen,gdw);

      /*GdkRectangle rc;
      gdk_screen_get_monitor_geometry(screen,mn,&rc);

      gool::sized in;
      in.x = gdk_screen_get_monitor_width_mm(screen,mn) * 0.0393701;
      in.y = gdk_screen_get_monitor_height_mm(screen,mn) * 0.0393701;

      if(!in.empty())
      {
        r.x = int(rc.width / in.x + 0.5 );
        r.y = int(rc.height / in.y + 0.5 );
      }*/

      r *= gdk_screen_get_monitor_scale_factor (screen,mn);
#endif
      dpi = r;

      return dpi;
    }
    void     view::set_cursor(gool::cursor* pcur)
    {
        _cursor = pcur;
        GdkWindow* win = gtk_widget_get_parent_window(get_hwnd());
        if(win)
           gdk_window_set_cursor(win, _cursor? _cursor->pcur: nullptr);
    }
    gool::cursor* view::get_cursor()
    {
       return _cursor;
    }

    gboolean view::idle_callback (gpointer user_data) {
       view* pv = static_cast<view*>(user_data);
       if(pv->on_idle()) {
         critical_section _( pv->posted_guard );
         if(!pv->items_in_idle_queue()) {
		   pv->_idle_id = 0;
		   return FALSE;
         }
	   }
       return TRUE;
    }

    void  view::do_request_idle()
    {
      critical_section _( posted_guard );
      if(!_idle_id)
         _idle_id = g_timeout_add(16, idle_callback, this);
    }

    void  view::stop() {
       if(_idle_id) {
         g_source_remove(_idle_id);
         _idle_id = 0;
       }
       super::stop();
    }

    struct timer_task: resource
    {

      weak_handle<view> pv;
      uint_ptr id;

      static void create(view* pv, uint_ptr id, uint ms, uint_ptr& sys_id)
      {
        timer_task* tt = new timer_task();
        tt->pv = pv;
        tt->id = id;
        tt->add_ref();

        sys_id = g_timeout_add_full ( G_PRIORITY_DEFAULT,ms, timer_callback, tt, timer_destroyed);
      }
      static void remove( uint_ptr sys_id ) {
        //g_source_remove (guint(sys_id)); - because return FALSE; in timer_callback
      }

      static gboolean timer_callback(gpointer user_data)
      {
        timer_task* tt = static_cast<timer_task*>(user_data);
        if(tt && tt->pv)
          tt->pv->on_timer( tt->id );
        return FALSE;
      }
      static void  timer_destroyed(gpointer data)
      {
        timer_task* tt = static_cast<timer_task*>(data);
        tt->release();
      }
    };

    void  view::set_timer(uint_ptr id, uint ms, uint_ptr& sys_id)
    {
      if(ms)
        timer_task::create(this,id,ms,sys_id);
      else
        timer_task::remove(sys_id);
    }

    bool  view::ask_close_window(bool by_chrome)
    {
      if(_is_closing)
        return true;
      //auto gw = gtkwindow( this );
      //if( gw )
      //   gtk_window_close( gw );

      post( delegate(this, &view::rq_close_window), true );

      return true;
    }

    bool  view::rq_close_window() {

      if( inside_animation_frame )
        return false; // cannot do it now, need reposting

      auto_state<bool> _(_is_closing,true);

      _closerq_by_code = true;

      if( ask_unload(doc(), UNLOAD_BY_CODE) )
        close_window();

      return true;
    }

    bool  view::close_window()
    {
      /* handled by view::stop() - each([this](html::view* pv){
        if( pv->parent() == this )
          pv->close_window();
      });*/
      auto gw = gtkwindow( this );
      //wrong: gtk_widget_destroy ( GTK_WIDGET(gw) );
      gtk_window_close(gw);
      return true;
    }

    rect view::window_decoration() const {

      return const_cast<view*>(this)->update_window_decoration();

      //if( _decorations_origin.x.is_defined()  )
      //  return rect(_decorations_origin.x, _decorations_origin.y, _decorations_corner.x, _decorations_corner.y);

      // approximate
/*      screen_info si;
      if(get_screen_info(0, si))
      {
         static rect dmr(0,0,0,0);
         if( dmr == rect(0,0,0,0) )
           dmr = rect(si.workarea.left() - si.monitor.left(),
               si.workarea.top() - si.monitor.top(),
               si.monitor.right() - si.workarea.right(),
               si.monitor.bottom() - si.workarea.bottom());
         return dmr;
      } */
      //return rect(0,0,0,0);
    }

    static rect known_decorations(0,0,0,0);

    rect view::update_window_decoration() {

      //if( get_frame_type() != html::STANDARD )
      return rect(0,0,0,0);

      /*auto hwnd = get_hwnd();
      if(!hwnd)
        return known_decorations;

      auto win = gtk_widget_get_window (hwnd);
      if(!win)
        return known_decorations;

      GdkRectangle cr = {0};
      gtk_widget_get_allocation(get_hwnd(),&cr);
      gdk_window_get_origin (win, &cr.x, &cr.y);

      GdkRectangle wr = {0};
      gdk_window_get_frame_extents (win, &wr);

      if( wr.width <= cr.width || wr.height <= cr.height)
        return known_decorations;

      rect wrc = rect::make_xywh( wr.x,wr.y,wr.width,wr.height );
      rect crc = rect::make_xywh( cr.x,cr.y,cr.width,cr.height );

      rect  mr(crc.left() - wrc.left(),
               crc.top() - wrc.top(),
               wrc.right() - crc.right(),
               wrc.bottom() - crc.bottom()); // return width of window decorations

      _decorations_origin.x = mr.origin.x;
      _decorations_origin.y = mr.origin.y;

      _decorations_corner.x = mr.corner.x;
      _decorations_corner.y = mr.corner.y;

      known_decorations = mr;

      return rect(_decorations_origin.x, _decorations_origin.y, _decorations_corner.x, _decorations_corner.y);
      */
    }

    /*size view::window_dim() {
      // do GTK have frame size at all?
      auto gw = gtkwindow( this );
      size sz;
      if( gw )
         gtk_window_get_size (gw, &sz.x, &sz.y);
      return sz;
    }

    size view::client_dim() {
      //if( _client_dim.x.is_defined() ) return _client_dim; return iwindow::client_dim();
      auto gw = gtkwindow( this );
      size sz;
      if( gw )
         gtk_window_get_size (gw, &sz.x, &sz.y);
      return sz;
    }*/


    void view::move_window(const rect& spos,bool client_rc)
    {
      super::move_window(spos);
      auto gw = gtkwindow( this );
      gtk_window_set_position (gw,GTK_WIN_POS_NONE);
      gtk_window_set_gravity (gw,GDK_GRAVITY_NORTH_WEST);
      gtk_window_move(gw,spos.left(),spos.top());
      gtk_window_resize(gw,spos.width(),spos.height());

#if 0
      auto gw = gtkwindow( this );
      rect decoration = get_frame_type() == STANDARD ? window_decoration() : rect(0,0,0,0);
      if( gw ) {
        GdkWindow* gdw = gtk_widget_get_window( GTK_WIDGET(gw) );
        if( !gdw ) return;

        if( get_window_state() <= WINDOW_HIDDEN )
          _rq_window_place = spos;

        //gdk_window_ensure_native (gdw);
        _window_dim = spos.size();
        rect crc = spos.size();
        crc <<= decoration;
        _client_dim = crc.size();

        //printf("move_window %d,%d\n", spos.width(), spos.height());

        gtk_window_set_position (gw,GTK_WIN_POS_NONE);
        gtk_window_set_gravity (gw,GDK_GRAVITY_NORTH_WEST);
        gtk_window_resize(gw,spos.width(),spos.height());
        gtk_window_move(gw,spos.left(),spos.top());

        //gdk_window_ensure_native(gdw);

        //gdk_window_move_resize (gdw, spos.left(),spos.top(), _client_dim.x,_client_dim.y);

        //if(!gdk_window_is_viewable(gdw) /*!gtk_widget_get_mapped(GTK_WIDGET(gw))*/)
#if 0
        if(!gtk_widget_get_window(get_hwnd()))
        {
          //gtk_window_set_default_size(gw,spos.width(),spos.height());
          gtk_window_set_position (gw,GTK_WIN_POS_NONE);
          gtk_window_set_gravity (gw,GDK_GRAVITY_NORTH_WEST);
          gtk_window_resize(gw,spos.width(),spos.height());
          gtk_window_move(gw,spos.left(),spos.top());
          //_rq_window_place = spos;
        } else {
          /*gtk_window_set_position (gw,GTK_WIN_POS_NONE);
          gtk_window_set_gravity (gw,GDK_GRAVITY_NORTH_WEST);
          gtk_window_resize(gw,spos.width(),spos.height());
          gtk_window_move(gw,spos.left(),spos.top());*/
          gdk_window_move_resize (gdw, spos.left(),spos.top(), _client_dim.x,_client_dim.y);
        }
#endif
        //gdk_window_move( gdw, spos.left(),spos.top() );
        //gdk_window_resize( gdw, _client_dim.x,_client_dim.y );

        // WTF this function gets FRAME position but CLIENT dimensions?

        //update_geometry();
      }
#endif
    }
    WINDOW_STATE view::get_window_state() const
    {
       return _window_state;
    }
    bool         view::set_window_state( WINDOW_STATE ws )
    {
       GtkWindow *gw = gtkwindow(this);
       if(!gw)
         return false;

       if( _window_state == ws)
         return false;

       auto p_window_state = _window_state;

       _window_state = ws;

       switch(ws) {
         case WINDOW_HIDDEN: gtk_widget_hide (GTK_WIDGET(gw)); return true;
         case WINDOW_SHOWN:
         if( p_window_state == WINDOW_MAXIMIZED )
           gtk_window_unmaximize(gw);
         else if(p_window_state == WINDOW_MINIMIZED)
           gtk_window_present(gw);
         else
           gtk_widget_show (GTK_WIDGET(gw));
         return true;
         case WINDOW_MAXIMIZED:
           gtk_window_maximize (gw);
           return true;
         case WINDOW_MINIMIZED: gtk_window_iconify(gw); return true;
         case WINDOW_FULL_SCREEN: gtk_window_fullscreen(gw); return true;
       }
       return false;
    }

    bool         view::set_frame_type(FRAME_TYPE ft)
    {
      super::set_frame_type(ft);
      _frame_type = ft;

      // doesn't really work on GTK

      gboolean needs_decorations = ft == STANDARD ? TRUE: FALSE;
      //gboolean needs_shadow = ft == STANDARD ? TRUE: FALSE;

      auto gw = gtkwindow( this );
      if(gw) {
        switch(ft)
        {
          case STANDARD:
            gtk_window_set_decorated (gw, true);
            break;
          case STANDARD_EXTENDED: {
              gtk_window_set_decorated (gw, true);
              GtkWidget* header = gtk_header_bar_new();
              gtk_window_set_titlebar(gw,header);
            }
            break;
          default:
            gtk_window_set_decorated (gw, false);
            break;
        }
        set_resizeable(get_resizeable());
      }
      return true;

    }

    bool         view::show_modal()
    {
       GtkWindow* gw = gtkwindow(this);

       handle<gtk::view> parent_view = (gtk::view*)parent();

       if( parent_view ) {
         gtk_window_set_transient_for(gw, gtkwindow( parent_view ));
         if(parent_view->doc())
           parent_view->doc()->state_on(*parent_view,html::S_DISABLED);
         //gtk_widget_set_sensitive (GTK_WIDGET(gtkwindow(parent_view)), FALSE);
       }

       handle<view> self = this;

       gtk_widget_show(GTK_WIDGET(gw));
       gtk_window_set_modal(gw,TRUE);
       gtk_window_set_keep_above(gw,TRUE);
       self->update_window_state(gool::WINDOW_SHOWN);

       #if  1
       while( self->get_hwnd() )
       {
          if(self->_window_state == WINDOW_HIDDEN) break;
          if(self->_window_state == WINDOW_STATE_NA) break;
          if(gtk_main_iteration_do (true) )
             return false;
          //force_update(parent()->get_hwnd());
          //parent()->on_animation_tick();
          //parent()->refresh();
       }
       #else
         gtk_run_dialog (gw);
       #endif

       if(parent_view) {
         if(parent_view->doc())
           parent_view->doc()->state_off(*parent_view,html::S_DISABLED);
       }
         //BUGGY, WHY?: gtk_widget_set_sensitive (GTK_WIDGET(gtkwindow(parent_view)), TRUE);

       //GMainLoop* loop = g_main_loop_new(NULL,FALSE);
       //g_main_loop_run(loop);
       //g_main_loop_unref(loop);

       return dialog_retval != NOTHING_VALUE;

    }


    /*static GdkFilterReturn GdkMouseUpFilter(GdkXEvent *xevent, GdkEvent *event, gpointer data)
    {
       if( ((XButtonEvent*)xevent)->type == ButtonRelease)
         *((bool*)data) = false;
       return GDK_FILTER_CONTINUE;
    }*/

    bool is_mouse_down(gtk::view* pv)
    {
        GtkWidget* gtw = gtk_widget_get_toplevel(pv->get_hwnd());
        if( !gtw )
          return false;
        GdkWindow* gdw = gtk_widget_get_window(gtw);
        if( !gdw )
          return false;

        struct {
             int x;
             int y;
             GdkModifierType state;
        } em;
        gdk_window_get_pointer (gdw, &em.x, &em.y, &em.state);
        return get_mouse_buttons(&em) != 0;
        //  printf("hint %d %d %x\n", em.x,em.y, get_mouse_buttons(&em));
    }


    bool         view::do_event( DO_EVENT_MANNER m, bool& result )
    {
      if( dismissing )
        return false;

      if (super::do_event(m, result))
        return true;

      result = true;
      switch( m )  {
        case DO_EVENT_WAIT:   return !gtk_main_iteration_do (true);
        case DO_EVENT_NOWAIT: return !gtk_main_iteration_do (false);
        case DO_EVENT_ALL:
        {
           handle<gtk::view> self = this;
           while( self->get_hwnd() ) {
             //if(self->_window_state == WINDOW_HIDDEN) break;
             //if(self->_window_state == WINDOW_STATE_NA) break;
             if( gtk_main_iteration_do (true) )
               return false;
           }
           return true;
        }
        case DO_EVENT_UNTIL_MOUSE_UP:
        {
          handle<gtk::view> self = this;
          self->_got_mouse_up = false;

          while( self->get_hwnd() && !self->_got_mouse_up && is_mouse_down(self)) {
            if(self->_window_state == WINDOW_HIDDEN) break;
            if(self->_window_state == WINDOW_STATE_NA) break;
            if( gtk_main_iteration_do (false) )
              return false;
            yield();
          }
          //printf("DO_EVENT_UNTIL_MOUSE_UP ended\n");
          return true;
        }
        case DO_EVENT_ONLY_IO:
         return html::view::exec_idle();
      }
      return false;
    }

    /*gool::text_layout* view::create_text_layout(wchars text, const text_format& tf)
    {
      gtk::text_layout* pl =  new gtk::text_layout();
      pl->set( *this,text, tf, app );
      return pl;
    }*/


    void      view::init_media_vars()
    {
      super::init_media_vars();

      GdkScreen *screen = gdk_screen_get_default();
      GdkVisual *visual = gdk_screen_get_rgba_visual(screen);

      gool::size min_w_size(0,0);
      gool::size max_w_size = screen_workarea().size();
      gool::size w_size = max_w_size;
      gool::size device_size = max_w_size;

      uint bits_per_pixel = 0;
      uint num_colors = 0;

      gool::size dpi = pixels_per_inch();
      gool::size dpcm;

      bool high_contrast = false;
      bool has_pen = false;
      bool has_mouse = false;
      bool has_mouse_wheel = false;
      bool has_horizontal_mouse_wheel = false; //GetSystemMetrics(SM_MOUSEHORIZONTALWHEELPRESENT) != 0;
      bool screen_reader = false;
      bool slow_machine = false;

    #if defined(PLATFORM_DESKTOP)
      //has_pen = GetSystemMetrics(SM_PENWINDOWS) != 0;
      has_mouse = true;
      has_mouse_wheel = true;
      //slow_machine = GetSystemMetrics(SM_SLOWMACHINE) != 0;
    #endif

        num_colors = gdk_visual_get_best_depth();

        dpcm.x = (dpi.x * 254) / 100;
        dpcm.y = (dpi.y * 254) / 100;

        if( get_hwnd() )
        {
          w_size = client_dim();
        }

        _media_vars["width"] = tool::value::make_length(w_size.x,tool::value::px);
        _media_vars["height"] = tool::value::make_length(w_size.y,tool::value::px);
        _media_vars["min-width"] = tool::value::make_length(min_w_size.x,tool::value::px);
        _media_vars["min-height"] = tool::value::make_length(min_w_size.y,tool::value::px);
        _media_vars["max-width"] = tool::value::make_length(max_w_size.x,tool::value::px);
        _media_vars["max-height"] = tool::value::make_length(max_w_size.y,tool::value::px);
        _media_vars["aspect-ratio"] = tool::value(double(w_size.x)/double(w_size.y));

        _media_vars["monitors"] = tool::value( gdk_screen_get_n_monitors(screen) );
        _media_vars["device-width"] = tool::value::make_length(device_size.x,tool::value::px);
        _media_vars["device-height"] = tool::value::make_length(device_size.y,tool::value::px);
        _media_vars["device-aspect-ratio"] = tool::value(double(device_size.x)/double(device_size.y));

        _media_vars["orientation-portrait"] = device_size.y > device_size.x;
        _media_vars["orientation-landscape"] = device_size.y < device_size.x;
        _media_vars["color"] = int(bits_per_pixel);
        _media_vars["color-index"] = int(num_colors);
        //monochrome ???

        if(dpi.x == dpi.y) // dots per inch
        {
          _media_vars["resolution"] = dpi.x;
          _media_vars["min-resolution"] = dpi.x;
          _media_vars["max-resolution"] = dpi.x;
        }
        else
        {
          // A \91resolution\92 (without a "min-" or "max-" prefix) query never matches a device with non-square pixels.
          _media_vars["min-resolution"] = min(dpi.x,dpi.y);
          _media_vars["max-resolution"] = max(dpi.x,dpi.y);
        }

        if(dpcm.x == dpcm.y) // dots per sentimeter
        {
          _media_vars["resolution-dpcm"] = dpcm.x;
          _media_vars["min-resolution-dpcm"] = dpcm.x;
          _media_vars["max-resolution-dpcm"] = dpcm.x;
        }
        else
        {
          // A \91resolution\92 (without a "min-" or "max-" prefix) query never matches a device with non-square pixels.
          _media_vars["min-resolution-dpcm"] = min(dpcm.x,dpcm.y);
          _media_vars["max-resolution-dpcm"] = max(dpcm.x,dpcm.y);
        }

        _media_vars["high-contrast"] = high_contrast;
        _media_vars["contrast-screen"] = high_contrast; // Symantec's var.

        _media_vars["has-pen"] = has_pen;
        _media_vars["has-mouse"] = has_mouse;
        _media_vars["has-mouse-wheel"] = has_mouse_wheel;
        _media_vars["has-horizontal-mouse-wheel"] = has_horizontal_mouse_wheel;
        _media_vars["screen-reader"] = screen_reader;
        _media_vars["slow-machine"] = slow_machine;

        _media_vars["engine"] = ustring(WTEXT("sciter"));
        _media_vars["engine-version-minor"] = (int)module_version(false);
        _media_vars["engine-version-major"] = (int)module_version(true);

        static uint ver[4] = { SCITER_VERSION };

        _media_vars["sciter"] = value(ver[0]);

        _media_vars["os"] = ustring(tool::environment::get_os_version_name());
        _media_vars["platform"] = ustring("Linux");

        _media_vars["old-themes"] = environment::get_os_version() < environment::WIN_VISTA;
        _media_vars["new-themes"] = environment::get_os_version() >= environment::WIN_VISTA;

        bool composited = false;

        if (visual != NULL && gdk_screen_is_composited(screen))
           composited = true;

        _media_vars["composition-supported"] = tool::value(composited);
        _media_vars["on-glass"] = tool::value(get_transparency());

        _media_vars["graphics-layer"] = tool::value(graphics_caps());

        _media_vars["ui-blurbehind"] = tool::value(get_transparency()); //tool::value(composited);
        _media_vars["ui-ambience"] = tool::value("light");

    }

    /*
    int scrollbar_width() { return 16; }
  int scrollbar_height() { return 16; }
  int small_icon_width() { return 24;  }
  int small_icon_height() { return 24; }
  int border_width()      { return 1; }
  int border_3d_width()   { return 2; }
*/

    int view::get_window_metrics(tool::value::length_special_values what) {
        switch (what)
        {
          case tool::value::$scrollbar_height:   return 16;
          case tool::value::$scrollbar_width:    return 16;
          case tool::value::$small_icon_height:  return 24;
          case tool::value::$small_icon_width:   return 24;
          case tool::value::$border_width:       return 1;
          case tool::value::$border_3d_width:    return 2;

          case tool::value::$window_caption_height: return 24;
          case tool::value::$window_button_height:  return 24;
          case tool::value::$window_button_width:   return 24;
          case tool::value::$window_frame_width: return 0;
          default:
            assert(false);
            return 10;
        }
    }

    void view::render(graphics* gfx,gool::rect dirty_rc)
    {
      _gfx = gfx;

      html::BLUR_BEHIND bb = this->get_blurbehind();
      //printf("render BLUR_BEHIND %d\n",bb);

      if( bb ) {
        cairo_save(gfx->target());
        switch(bb) {
            case html::BLUR_BEHIND_ULTRA_DARK: cairo_set_source_rgba(gfx->target(), 0, 0, 0, 0.95); break;
            case html::BLUR_BEHIND_DARK: cairo_set_source_rgba(gfx->target(), 0.33, 0.33, 0.33,0.95); break;
            case html::BLUR_BEHIND_LIGHT: cairo_set_source_rgba(gfx->target(),0.8,0.8,0.8,0.9); break;
            case html::BLUR_BEHIND_ULTRA_LIGHT: cairo_set_source_rgba(gfx->target(),1,1,1,0.95); break;
            default:
              cairo_set_source_rgba(gfx->target(), 0, 0, 0, 0); break;
        }
        //cairo_set_source_rgba(gfx->target(), 0.4, 0.4, 0.4,0.75);
        cairo_set_operator(gfx->target(), CAIRO_OPERATOR_SOURCE);
        cairo_paint(gfx->target());
        cairo_restore(gfx->target());
      } else if( get_transparency() ) {
        cairo_save(gfx->target());
        cairo_set_source_rgba(gfx->target(), 0, 0, 0, 0);
        cairo_set_operator(gfx->target(), CAIRO_OPERATOR_SOURCE);
        cairo_paint(gfx->target());
        cairo_restore(gfx->target());
      } else {
        cairo_save(gfx->target());
        cairo_set_source_rgba(gfx->target(), 1, 1, 1, 1);
        cairo_set_operator(gfx->target(), CAIRO_OPERATOR_SOURCE);
        cairo_paint(gfx->target());
        cairo_restore(gfx->target());
      }

      //auto_state<graphics*>       _1(_gfx,gfx);
      auto_state<bool>            _2(is_painting,true);
      auto_state<gool::graphics*> _3(drawing_surface, _gfx);

      gfx->set_clip_rc(dirty_rc);
      html::view::paint();
    }

    bool view::ask_folder_name(const ustring& caption, ustring& foldername)
    {
        tool::string cap = caption.length()? u8::cvt(caption) : string("Select Folder");

        GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER;

        auto parent = gtkwindow(this);

        assert(GTK_IS_WINDOW(parent));

        GtkWidget *dialog = gtk_file_chooser_dialog_new ( cap,
                                      parent,
                                      action,
                                      "Cancel",
                                      GTK_RESPONSE_CANCEL,
                                      "Open",
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);

        //gtk_widget_realize(dialog);

        gtk_window_set_transient_for(GTK_WINDOW (dialog), gtkwindow(this));
        gtk_window_set_position( GTK_WINDOW( dialog ), GTK_WIN_POS_CENTER_ON_PARENT );
        gtk_window_set_modal ( GTK_WINDOW (dialog), TRUE );
        if( foldername.length() )
          gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), tool::string(foldername).c_str());

        gint res = gtk_dialog_run (GTK_DIALOG (dialog));
        if (res == GTK_RESPONSE_ACCEPT)
        {
          GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);
          char *selected_foldername = gtk_file_chooser_get_filename (chooser);
          //open_file (filename);
          foldername = ustring(selected_foldername);
          g_free (selected_foldername);
        }
        gtk_widget_destroy (dialog);

        return res == GTK_RESPONSE_ACCEPT;
    }

    array<ustring> view::ask_file_name(view::AFN_MODE mode, const ustring& caption, const ustring& filename, const wchar* def_ext, const wchar* filter)
    {
       array<ustring> filenames;

       auto add_filter =[](GtkWidget *file_chooser,tool::string title, tool::string pattern)
       {
          GtkFileFilter *f = gtk_file_filter_new();
          gtk_file_filter_set_name(f, title);
          //WTF? pattern.to_lower();
          chars pat = pattern();
          while( !!pat ) {
            tool::chars glob = pat.chop(';');
            if( !glob )
              break;
            gtk_file_filter_add_pattern(f,string(glob));
          }
          gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(file_chooser), f);
       };

       auto add_filters=[&add_filter](GtkWidget *file_chooser, tool::chars filters )
       {
          while( !!filters ) {
            tool::chars name = filters.chop('|');
            tool::chars filt = filters.chop('|');
            if( !!name && !!filt )
              add_filter( file_chooser, name, filt );
          }
       };

      string u8filter = filter;

      if( mode == view::AFN_OPEN || mode == view::AFN_OPEN_MULTIPLE ) {

        tool::string cap = caption.length()? u8::cvt(caption): string("Open File");

        GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;

        auto parent = gtkwindow(this);

        assert(GTK_IS_WINDOW(parent));

        GtkWidget *dialog = gtk_file_chooser_dialog_new ( cap,
                                      parent,
                                      action,
                                      "Cancel",
                                      GTK_RESPONSE_CANCEL,
                                      "Open",
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);

        add_filters(dialog, tool::string(filter));

        //gtk_widget_realize(dialog);

        gtk_window_set_transient_for(GTK_WINDOW (dialog), gtkwindow(this));
        gtk_window_set_position( GTK_WINDOW( dialog ), GTK_WIN_POS_CENTER_ON_PARENT );
        gtk_window_set_modal ( GTK_WINDOW (dialog), TRUE );

        gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog), mode == view::AFN_OPEN_MULTIPLE);
        if( filename.length() ) {
          gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), tool::string(filename).c_str());
        }


        gint res = gtk_dialog_run (GTK_DIALOG (dialog));
        if (res == GTK_RESPONSE_ACCEPT)
        {
          GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);

          if(mode == view::AFN_OPEN_MULTIPLE) {
             GSList* ls = gtk_file_chooser_get_filenames(chooser);
             for(GSList* item = ls; item; item = item->next) {
               filenames.push(ustring((const char*)item->data));
               g_free(item->data);
             }
             g_slist_free(ls);
          } else {
            char *selected_filename = gtk_file_chooser_get_filename (chooser);
            filenames.push(ustring(selected_filename));
            g_free (selected_filename);
          }
        }
        gtk_widget_destroy (dialog);

        return filenames;

      } else {
        // save

        tool::string cap = caption.length()? u8::cvt(caption): string("Save File");

        GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SAVE;
        GtkWidget *dialog = gtk_file_chooser_dialog_new (cap,
                                      gtkwindow(this),
                                      action,
                                      "Cancel",
                                      GTK_RESPONSE_CANCEL,
                                      "Save",
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);

        gtk_window_set_transient_for(GTK_WINDOW (dialog), gtkwindow(this));
        gtk_window_set_modal ( GTK_WINDOW (dialog), true );

        GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);

        gtk_file_chooser_set_do_overwrite_confirmation (chooser, TRUE);

        add_filters(dialog, tool::string(filter));

        if (filename.length() == 0)
          gtk_file_chooser_set_current_name (chooser, "Untitled document");
        else {
          gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), tool::string(filename).c_str());
          if( !filename().ends_with('/') ) {
            tool::string fn = filename().r_tail('/');
            gtk_file_chooser_set_current_name (chooser, fn);
          }
        }
          //gtk_file_chooser_select_filename (chooser, u8::cvt(filename));

        gint res = gtk_dialog_run (GTK_DIALOG (dialog));
        if (res == GTK_RESPONSE_ACCEPT)
        {
          char *selected_filename;
          selected_filename = gtk_file_chooser_get_filename (chooser);

          ustring fn = selected_filename;
          if(def_ext && def_ext[0] && !(fn().r_tail('/').like(W("*.*")))) {
            fn += '.';
            fn += def_ext;
          }
          g_free (selected_filename);
          filenames.push(fn);
        }

        gtk_widget_destroy (dialog);
        return filenames;
      }
   }

   ustring view::get_window_title() const {

     GtkWindow* pw = gtkwindow(this);
     if( pw )
       return gtk_window_get_title (pw);
     return ustring();
   }
   bool view::set_window_title(const wchar* title) {
     GtkWindow* pw = gtkwindow(this);
     if( pw ) {
       gtk_window_set_title (pw, string(title).c_str());
       return true;
     }
     return false;
   }

   static void bmp_destroy(guchar *pixels, gpointer data) {
     free(pixels);
   }

   GdkPixbuf* to_pixbuf(gool::bitmap* bmp) {

     slice<argb> pixels = bmp->get_bits();
     argb* data = (argb*)malloc(sizeof(argb)*pixels.length);
     for( uint n = 0; n < pixels.length; ++n) {
       argb t = pixels[n];
       swap(t.red,t.blue);
       data[n] = t;
     }

     GdkPixbuf* pb = gdk_pixbuf_new_from_data(
       (const byte*)data,
       GDK_COLORSPACE_RGB,
       true,
       8,
       bmp->dim().x,
       bmp->dim().y,
       bmp->stride(),
       bmp_destroy,
       bmp);
     return pb;
   }

   bool view::set_icon(gool::image *pimg) {
     GtkWindow* pw = gtkwindow(this);
     if(!pw)
       return false;
     handle<gool::bitmap> bmp = pimg->get_bitmap(nullptr,pimg->dim());
     if(!bmp)
       return false;
     GdkPixbuf* pb = to_pixbuf(bmp);
     if(pb && GDK_IS_PIXBUF(pb)) {
       gtk_window_set_icon(pw,pb);
       return true;
     }
     return false;
   }


    bool view::add_animation(element* b, animation* pba, const style* new_style, const style* old_style )
    {
      if(!get_hwnd())
        return false;

      //request_animation_frame(ANIMATION_TIMER_SPAN);
      if(!super::add_animation(b, pba, new_style,old_style))
        return false;
      return true;
    }

    uint view::get_animation_ticks()
    {
      GtkWidget *widget = get_hwnd();
      if(!widget)
        return 0;

      gint64 mcs = g_get_monotonic_time();

      //GdkFrameClock *clk = gtk_widget_get_frame_clock (widget);
      //if( !clk )
      //  return 0;
      //gint64 mcs = gdk_frame_clock_get_frame_time (clk);

      return uint(mcs / 1000u); // milliseconds
    }

    void view::on_animation_tick()
    {
       on_animation_tick( get_animation_ticks() );
    }

    bool view::on_animation_tick(uint ticks)
    {
      if( !ticks || !check_visibility() || dismissing ) {
        stop_animation_frames();
        return false;
      }

      uint delay = 0;
      uint delta = 0;

      if( !doc() )
        goto STOP;

      if( animating.size() == 0 )
        goto STOP;

      delay = do_animation(ticks);

      if( animating.size() == 0 || delay == 0 )
        goto STOP;

      //update();
      //while( gtk_events_pending() )
      //  gtk_main_iteration();

      request_animation_frame(delay/*not used*/);


      return true;
STOP:
      remove_all_animations();
      return false;
    }

    static uint prev_animation_tick = 0;


    gboolean view::gv_on_animation_tick(GtkWidget *widget, GdkFrameClock *frame_clock, gpointer user_data)
    {
      gint64 mcs = gdk_frame_clock_get_frame_time (frame_clock);

      uint animation_tick = uint(mcs / 1000u); // milliseconds

#if 0
      if(prev_animation_tick)
      {
        printf("animation delta %d\n", animation_tick - prev_animation_tick  );
      }
      prev_animation_tick = animation_tick;
#endif

      handle<view> pv = static_cast<view*>(user_data);

      if(pv->on_animation_tick(animation_tick) && !pv->dismissing)
        return G_SOURCE_CONTINUE;

      pv->_animation_ticker.clear();
      return G_SOURCE_REMOVE;

    }

    void view::stop_animation_frames()
    {
       if( _animation_ticker.is_undefined() )
         return;

       GtkWidget *widget = get_hwnd();
       if(!widget)
         return;

       gtk_widget_remove_tick_callback (widget,_animation_ticker);
       _animation_ticker.clear();
    }
    bool      view::request_animation_frame(uint delay)
    {
       if( _animation_ticker.is_defined() )
         return true;

       GtkWidget *widget = get_hwnd();
       if(!widget)
         return false;

       _animation_ticker = gtk_widget_add_tick_callback (widget, gv_on_animation_tick, this, NULL);
       return true;
    }


    void view::update_geometry()
    {

      GdkGeometry geometry = {0};

      uint hints = GdkWindowHints(0);

      gool::size sz = window_dim();

      if( _aspect_ratio.is_defined() ) {
        geometry.max_aspect = geometry.min_aspect = _aspect_ratio;
        hints |= GDK_HINT_ASPECT;
      }

      if(!_is_resizeable) {
        geometry.min_width = sz.x;
        geometry.min_height = sz.y;
        hints |= GDK_HINT_MIN_SIZE;
      }
      else if( _min_size.x.is_defined() ) {
        geometry.min_width = _min_size.x;
        geometry.min_height = _min_size.y;
        hints |= GDK_HINT_MIN_SIZE;
      } else
        hints |= GDK_HINT_MIN_SIZE;

      if(!_is_resizeable) {
        geometry.max_width = sz.x;
        geometry.max_height = sz.y;
        hints |= GDK_HINT_MAX_SIZE;
      }
      else if( _max_size.x.is_defined() ) {
        geometry.max_width = _max_size.x;
        geometry.max_height = _max_size.y;
        hints |= GDK_HINT_MAX_SIZE;
      }

      geometry.base_width = sz.x;
      geometry.base_height = sz.y;

      GtkWidget* gtw = gtk_widget_get_toplevel(get_hwnd());
      if( !gtw )
        return;

      GdkWindow* gdw = gtk_widget_get_window( gtw );
      if( !gdw )
        return;

      gdk_window_set_geometry_hints (gdw,&geometry,GdkWindowHints(hints));
    }

    void view::aspect_ratio(float_v r) {

      _aspect_ratio = r;

      update_geometry();
    }

    bool view::get_min_size(gool::size& sz)
    {
      if( _min_size.x.is_defined() )
      {
        sz = _min_size;
        return true;
      }
      return false;
    }

    bool view::get_max_size(gool::size& sz)
    {
      if( _max_size.x.is_defined() )
      {
        sz = _max_size;
        return true;
      }
      return false;
    }
    bool view::set_min_size(gool::size sz)
    {
      if( !sz.empty() ) {
        _min_size = sz;
      } else {
        _min_size.x.clear();
        _min_size.y.clear();
      }
      update_geometry();
      return true;
    }
    bool view::set_max_size(gool::size sz)
    {
      if( !sz.empty() ) {
        _max_size = sz;
      } else {
        _max_size.x.clear();
        _max_size.y.clear();
      }
      update_geometry();
      return true;
    }

    bool view::set_resizeable(bool on)
    {
	  //if( !win ) return false;
      //gool::rect rc = screen_place();
      // WHAT A F*** IS THAT ???
      //if( !on )
      //  gtk_widget_set_size_request(win, rc.width(), rc.height());
      //else
      //  gtk_widget_set_size_request(win, 0, 0);

	  // NOTE: gtk_window_set_resizable causes window to change size, f***
	  /*this->async([this,on]()->bool {
		GtkWidget* win = gtk_widget_get_toplevel(get_hwnd());
		if(win)
		  gtk_window_set_resizable(GTK_WINDOW (win), on );
		return true;
	  });*/

      //update_geometry();
      //move_window(rc);

      _is_resizeable = on;
      update_geometry();

      return true;
    }
    bool view::get_resizeable() const
    {
      return _is_resizeable.val(true);
      //GtkWidget* win = gtk_widget_get_toplevel(get_hwnd()); if( !win ) return false;
      //return gtk_window_get_resizable(GTK_WINDOW (win));
    }

    bool view::set_minimizable(bool on)
    {
      GdkWindowTypeHint gwhint = on? GDK_WINDOW_TYPE_HINT_NORMAL : GDK_WINDOW_TYPE_HINT_DIALOG;
      GtkWidget* win = gtk_widget_get_toplevel(get_hwnd()); if( !win ) return false;

      //gdk_window_set_decorations (GdkWindow *window,
      //                      GdkWMDecoration decorations);

      gtk_window_set_type_hint(GTK_WINDOW (win),gwhint);
      return true;
    }
    bool view::get_minimizable() {
      GtkWidget* win = gtk_widget_get_toplevel(get_hwnd()); if( !win ) return false;
      return gtk_window_get_type_hint(GTK_WINDOW(win)) == GDK_WINDOW_TYPE_HINT_NORMAL;
    }
    bool view::set_maximizable(bool on)
    {
      GdkWindowTypeHint gwhint = on? GDK_WINDOW_TYPE_HINT_NORMAL : GDK_WINDOW_TYPE_HINT_DIALOG;
      GtkWidget* win = gtk_widget_get_toplevel(get_hwnd()); if( !win ) return false;
      gtk_window_set_type_hint(GTK_WINDOW (win),gwhint);
      return true;
    }
    bool view::get_maximizable()
    {
      GtkWidget* win = gtk_widget_get_toplevel(get_hwnd()); if( !win ) return false;
      return gtk_window_get_type_hint(GTK_WINDOW(win)) == GDK_WINDOW_TYPE_HINT_NORMAL;
    }

    bool view::set_topmost(bool on) {
      GtkWidget* win = gtk_widget_get_toplevel(get_hwnd()); if( !win ) return false;
      _is_topmost = on;
      gtk_window_set_keep_above (GTK_WINDOW(win), on);
      return true;
    }
    bool view::get_topmost()
    {
      return _is_topmost;
    }

    bool view::render(void* dc, gool::rect invalid)
    {
        if( !_gfx || _gfx->target() != static_cast<cairo_t*>(dc) )
          _gfx = new gtk::graphics( static_cast<cairo_t*>(dc), get_transparency() );
        if (has_animations())
          on_animation_tick();
        check_timers_overdue_in_all_views();
        render(_gfx,gool::rect(invalid));
        return true;
    }

    /*gboolean trayicon_press_event (GtkStatusIcon *status_icon,
               GdkEventButton *event,
               gpointer       user_data) {
      view* pv = (view*)user_data;
      return pv->trayicon_notify(gool::point(event->x_root,event->y_root),get_mouse_buttons(event),html::MOUSE_DOWN);
    }*/

    gboolean trayicon_release_event (GtkStatusIcon *status_icon,
               GdkEventButton *event,
               gpointer       user_data) {
      view* pv = (view*)user_data;
      return pv->trayicon_notify(gool::point(event->x_root,event->y_root),get_mouse_buttons(event),html::MOUSE_CLICK);
    }

    bool view::trayicon_setup(const tray_icon_params& params) {
      if(!trayicon_status_icon) {
        trayicon_status_icon = gtk_status_icon_new();
        if(!trayicon_status_icon)
          return false;
        //g_signal_connect(G_OBJECT(trayicon_status_icon),
        //   "button-press-event",G_CALLBACK(trayicon_press_event), this);
        g_signal_connect(G_OBJECT(trayicon_status_icon),
           "button-release-event",G_CALLBACK(trayicon_release_event), this);
      }

      if(params.img) {
        handle<gool::bitmap> pbm = params.img->get_bitmap(nullptr, size(64,64));
        if(!pbm)
          return false;
        GdkPixbuf* pixb =  to_pixbuf(pbm);
        gtk_status_icon_set_from_pixbuf(trayicon_status_icon,pixb);
        g_object_unref(pixb);
      }

      if(params.tooltip.is_defined()) {
        string u8 = params.tooltip;
        gtk_status_icon_set_tooltip_text(trayicon_status_icon, u8.c_str());
      }
      return true;
    }
    bool view::trayicon_remove() {
      if(!trayicon_status_icon)
        return false;
      //g_signal_handlers_disconnect_by_func(G_OBJECT(trayicon_status_icon), G_CALLBACK(trayicon_press_event), this);
      //g_signal_handlers_disconnect_by_func(G_OBJECT(trayicon_status_icon), G_CALLBACK(&trayicon_release_event), this);
	  g_signal_handlers_disconnect_by_data(G_OBJECT(trayicon_status_icon),this);
      gtk_status_icon_set_visible(trayicon_status_icon,FALSE);
      g_object_unref(trayicon_status_icon);
      trayicon_status_icon = nullptr;
      return true;
    }
    bool view::trayicon_place(rect& rc) {
      if(!trayicon_status_icon)
        return false;

      GdkScreen        *screen = nullptr;
      GdkRectangle      area;
      GtkOrientation    orientation;
      //gdk_screen_get_number (GdkScreen *screen);
      gtk_status_icon_get_geometry(trayicon_status_icon,&screen,&area,&orientation);
      rc = rect::make_xywh(area.x,area.y,area.width,area.height);
      return true;
    }

}
